/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/datalabeling/v1beta1/data_labeling_service.proto

package com.google.cloud.datalabeling.v1beta1;

/**
 *
 *
 * <pre>
 * Request message for LabelVideo.
 * </pre>
 *
 * Protobuf type {@code google.cloud.datalabeling.v1beta1.LabelVideoRequest}
 */
public final class LabelVideoRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.datalabeling.v1beta1.LabelVideoRequest)
    LabelVideoRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use LabelVideoRequest.newBuilder() to construct.
  private LabelVideoRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private LabelVideoRequest() {
    parent_ = "";
    feature_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new LabelVideoRequest();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.datalabeling.v1beta1.DataLabelingServiceOuterClass
        .internal_static_google_cloud_datalabeling_v1beta1_LabelVideoRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.datalabeling.v1beta1.DataLabelingServiceOuterClass
        .internal_static_google_cloud_datalabeling_v1beta1_LabelVideoRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.datalabeling.v1beta1.LabelVideoRequest.class,
            com.google.cloud.datalabeling.v1beta1.LabelVideoRequest.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Video labeling task feature.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.datalabeling.v1beta1.LabelVideoRequest.Feature}
   */
  public enum Feature implements com.google.protobuf.ProtocolMessageEnum {
    /** <code>FEATURE_UNSPECIFIED = 0;</code> */
    FEATURE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Label whole video or video segment with one or more labels.
     * </pre>
     *
     * <code>CLASSIFICATION = 1;</code>
     */
    CLASSIFICATION(1),
    /**
     *
     *
     * <pre>
     * Label objects with bounding box on image frames extracted from the video.
     * </pre>
     *
     * <code>OBJECT_DETECTION = 2;</code>
     */
    OBJECT_DETECTION(2),
    /**
     *
     *
     * <pre>
     * Label and track objects in video.
     * </pre>
     *
     * <code>OBJECT_TRACKING = 3;</code>
     */
    OBJECT_TRACKING(3),
    /**
     *
     *
     * <pre>
     * Label the range of video for the specified events.
     * </pre>
     *
     * <code>EVENT = 4;</code>
     */
    EVENT(4),
    UNRECOGNIZED(-1),
    ;

    /** <code>FEATURE_UNSPECIFIED = 0;</code> */
    public static final int FEATURE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Label whole video or video segment with one or more labels.
     * </pre>
     *
     * <code>CLASSIFICATION = 1;</code>
     */
    public static final int CLASSIFICATION_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Label objects with bounding box on image frames extracted from the video.
     * </pre>
     *
     * <code>OBJECT_DETECTION = 2;</code>
     */
    public static final int OBJECT_DETECTION_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Label and track objects in video.
     * </pre>
     *
     * <code>OBJECT_TRACKING = 3;</code>
     */
    public static final int OBJECT_TRACKING_VALUE = 3;
    /**
     *
     *
     * <pre>
     * Label the range of video for the specified events.
     * </pre>
     *
     * <code>EVENT = 4;</code>
     */
    public static final int EVENT_VALUE = 4;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Feature valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Feature forNumber(int value) {
      switch (value) {
        case 0:
          return FEATURE_UNSPECIFIED;
        case 1:
          return CLASSIFICATION;
        case 2:
          return OBJECT_DETECTION;
        case 3:
          return OBJECT_TRACKING;
        case 4:
          return EVENT;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Feature> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Feature> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Feature>() {
          public Feature findValueByNumber(int number) {
            return Feature.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.datalabeling.v1beta1.LabelVideoRequest.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final Feature[] VALUES = values();

    public static Feature valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Feature(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.datalabeling.v1beta1.LabelVideoRequest.Feature)
  }

  private int requestConfigCase_ = 0;
  private java.lang.Object requestConfig_;

  public enum RequestConfigCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    VIDEO_CLASSIFICATION_CONFIG(4),
    OBJECT_DETECTION_CONFIG(5),
    OBJECT_TRACKING_CONFIG(6),
    EVENT_CONFIG(7),
    REQUESTCONFIG_NOT_SET(0);
    private final int value;

    private RequestConfigCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static RequestConfigCase valueOf(int value) {
      return forNumber(value);
    }

    public static RequestConfigCase forNumber(int value) {
      switch (value) {
        case 4:
          return VIDEO_CLASSIFICATION_CONFIG;
        case 5:
          return OBJECT_DETECTION_CONFIG;
        case 6:
          return OBJECT_TRACKING_CONFIG;
        case 7:
          return EVENT_CONFIG;
        case 0:
          return REQUESTCONFIG_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public RequestConfigCase getRequestConfigCase() {
    return RequestConfigCase.forNumber(requestConfigCase_);
  }

  public static final int VIDEO_CLASSIFICATION_CONFIG_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * Configuration for video classification task.
   * One of video_classification_config, object_detection_config,
   * object_tracking_config and event_config is required.
   * </pre>
   *
   * <code>
   * .google.cloud.datalabeling.v1beta1.VideoClassificationConfig video_classification_config = 4;
   * </code>
   *
   * @return Whether the videoClassificationConfig field is set.
   */
  @java.lang.Override
  public boolean hasVideoClassificationConfig() {
    return requestConfigCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * Configuration for video classification task.
   * One of video_classification_config, object_detection_config,
   * object_tracking_config and event_config is required.
   * </pre>
   *
   * <code>
   * .google.cloud.datalabeling.v1beta1.VideoClassificationConfig video_classification_config = 4;
   * </code>
   *
   * @return The videoClassificationConfig.
   */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig
      getVideoClassificationConfig() {
    if (requestConfigCase_ == 4) {
      return (com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig) requestConfig_;
    }
    return com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Configuration for video classification task.
   * One of video_classification_config, object_detection_config,
   * object_tracking_config and event_config is required.
   * </pre>
   *
   * <code>
   * .google.cloud.datalabeling.v1beta1.VideoClassificationConfig video_classification_config = 4;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.VideoClassificationConfigOrBuilder
      getVideoClassificationConfigOrBuilder() {
    if (requestConfigCase_ == 4) {
      return (com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig) requestConfig_;
    }
    return com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig.getDefaultInstance();
  }

  public static final int OBJECT_DETECTION_CONFIG_FIELD_NUMBER = 5;
  /**
   *
   *
   * <pre>
   * Configuration for video object detection task.
   * One of video_classification_config, object_detection_config,
   * object_tracking_config and event_config is required.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.ObjectDetectionConfig object_detection_config = 5;
   * </code>
   *
   * @return Whether the objectDetectionConfig field is set.
   */
  @java.lang.Override
  public boolean hasObjectDetectionConfig() {
    return requestConfigCase_ == 5;
  }
  /**
   *
   *
   * <pre>
   * Configuration for video object detection task.
   * One of video_classification_config, object_detection_config,
   * object_tracking_config and event_config is required.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.ObjectDetectionConfig object_detection_config = 5;
   * </code>
   *
   * @return The objectDetectionConfig.
   */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.ObjectDetectionConfig getObjectDetectionConfig() {
    if (requestConfigCase_ == 5) {
      return (com.google.cloud.datalabeling.v1beta1.ObjectDetectionConfig) requestConfig_;
    }
    return com.google.cloud.datalabeling.v1beta1.ObjectDetectionConfig.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Configuration for video object detection task.
   * One of video_classification_config, object_detection_config,
   * object_tracking_config and event_config is required.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.ObjectDetectionConfig object_detection_config = 5;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.ObjectDetectionConfigOrBuilder
      getObjectDetectionConfigOrBuilder() {
    if (requestConfigCase_ == 5) {
      return (com.google.cloud.datalabeling.v1beta1.ObjectDetectionConfig) requestConfig_;
    }
    return com.google.cloud.datalabeling.v1beta1.ObjectDetectionConfig.getDefaultInstance();
  }

  public static final int OBJECT_TRACKING_CONFIG_FIELD_NUMBER = 6;
  /**
   *
   *
   * <pre>
   * Configuration for video object tracking task.
   * One of video_classification_config, object_detection_config,
   * object_tracking_config and event_config is required.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.ObjectTrackingConfig object_tracking_config = 6;
   * </code>
   *
   * @return Whether the objectTrackingConfig field is set.
   */
  @java.lang.Override
  public boolean hasObjectTrackingConfig() {
    return requestConfigCase_ == 6;
  }
  /**
   *
   *
   * <pre>
   * Configuration for video object tracking task.
   * One of video_classification_config, object_detection_config,
   * object_tracking_config and event_config is required.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.ObjectTrackingConfig object_tracking_config = 6;
   * </code>
   *
   * @return The objectTrackingConfig.
   */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.ObjectTrackingConfig getObjectTrackingConfig() {
    if (requestConfigCase_ == 6) {
      return (com.google.cloud.datalabeling.v1beta1.ObjectTrackingConfig) requestConfig_;
    }
    return com.google.cloud.datalabeling.v1beta1.ObjectTrackingConfig.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Configuration for video object tracking task.
   * One of video_classification_config, object_detection_config,
   * object_tracking_config and event_config is required.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.ObjectTrackingConfig object_tracking_config = 6;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.ObjectTrackingConfigOrBuilder
      getObjectTrackingConfigOrBuilder() {
    if (requestConfigCase_ == 6) {
      return (com.google.cloud.datalabeling.v1beta1.ObjectTrackingConfig) requestConfig_;
    }
    return com.google.cloud.datalabeling.v1beta1.ObjectTrackingConfig.getDefaultInstance();
  }

  public static final int EVENT_CONFIG_FIELD_NUMBER = 7;
  /**
   *
   *
   * <pre>
   * Configuration for video event task.
   * One of video_classification_config, object_detection_config,
   * object_tracking_config and event_config is required.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.EventConfig event_config = 7;</code>
   *
   * @return Whether the eventConfig field is set.
   */
  @java.lang.Override
  public boolean hasEventConfig() {
    return requestConfigCase_ == 7;
  }
  /**
   *
   *
   * <pre>
   * Configuration for video event task.
   * One of video_classification_config, object_detection_config,
   * object_tracking_config and event_config is required.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.EventConfig event_config = 7;</code>
   *
   * @return The eventConfig.
   */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.EventConfig getEventConfig() {
    if (requestConfigCase_ == 7) {
      return (com.google.cloud.datalabeling.v1beta1.EventConfig) requestConfig_;
    }
    return com.google.cloud.datalabeling.v1beta1.EventConfig.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Configuration for video event task.
   * One of video_classification_config, object_detection_config,
   * object_tracking_config and event_config is required.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.EventConfig event_config = 7;</code>
   */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.EventConfigOrBuilder getEventConfigOrBuilder() {
    if (requestConfigCase_ == 7) {
      return (com.google.cloud.datalabeling.v1beta1.EventConfig) requestConfig_;
    }
    return com.google.cloud.datalabeling.v1beta1.EventConfig.getDefaultInstance();
  }

  public static final int PARENT_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object parent_ = "";
  /**
   *
   *
   * <pre>
   * Required. Name of the dataset to request labeling task, format:
   * projects/{project_id}/datasets/{dataset_id}
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The parent.
   */
  @java.lang.Override
  public java.lang.String getParent() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parent_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. Name of the dataset to request labeling task, format:
   * projects/{project_id}/datasets/{dataset_id}
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for parent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentBytes() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int BASIC_CONFIG_FIELD_NUMBER = 2;
  private com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig basicConfig_;
  /**
   *
   *
   * <pre>
   * Required. Basic human annotation config.
   * </pre>
   *
   * <code>
   * .google.cloud.datalabeling.v1beta1.HumanAnnotationConfig basic_config = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the basicConfig field is set.
   */
  @java.lang.Override
  public boolean hasBasicConfig() {
    return basicConfig_ != null;
  }
  /**
   *
   *
   * <pre>
   * Required. Basic human annotation config.
   * </pre>
   *
   * <code>
   * .google.cloud.datalabeling.v1beta1.HumanAnnotationConfig basic_config = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The basicConfig.
   */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig getBasicConfig() {
    return basicConfig_ == null
        ? com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig.getDefaultInstance()
        : basicConfig_;
  }
  /**
   *
   *
   * <pre>
   * Required. Basic human annotation config.
   * </pre>
   *
   * <code>
   * .google.cloud.datalabeling.v1beta1.HumanAnnotationConfig basic_config = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfigOrBuilder
      getBasicConfigOrBuilder() {
    return basicConfig_ == null
        ? com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig.getDefaultInstance()
        : basicConfig_;
  }

  public static final int FEATURE_FIELD_NUMBER = 3;
  private int feature_ = 0;
  /**
   *
   *
   * <pre>
   * Required. The type of video labeling task.
   * </pre>
   *
   * <code>
   * .google.cloud.datalabeling.v1beta1.LabelVideoRequest.Feature feature = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The enum numeric value on the wire for feature.
   */
  @java.lang.Override
  public int getFeatureValue() {
    return feature_;
  }
  /**
   *
   *
   * <pre>
   * Required. The type of video labeling task.
   * </pre>
   *
   * <code>
   * .google.cloud.datalabeling.v1beta1.LabelVideoRequest.Feature feature = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The feature.
   */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.LabelVideoRequest.Feature getFeature() {
    com.google.cloud.datalabeling.v1beta1.LabelVideoRequest.Feature result =
        com.google.cloud.datalabeling.v1beta1.LabelVideoRequest.Feature.forNumber(feature_);
    return result == null
        ? com.google.cloud.datalabeling.v1beta1.LabelVideoRequest.Feature.UNRECOGNIZED
        : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, parent_);
    }
    if (basicConfig_ != null) {
      output.writeMessage(2, getBasicConfig());
    }
    if (feature_
        != com.google.cloud.datalabeling.v1beta1.LabelVideoRequest.Feature.FEATURE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(3, feature_);
    }
    if (requestConfigCase_ == 4) {
      output.writeMessage(
          4, (com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig) requestConfig_);
    }
    if (requestConfigCase_ == 5) {
      output.writeMessage(
          5, (com.google.cloud.datalabeling.v1beta1.ObjectDetectionConfig) requestConfig_);
    }
    if (requestConfigCase_ == 6) {
      output.writeMessage(
          6, (com.google.cloud.datalabeling.v1beta1.ObjectTrackingConfig) requestConfig_);
    }
    if (requestConfigCase_ == 7) {
      output.writeMessage(7, (com.google.cloud.datalabeling.v1beta1.EventConfig) requestConfig_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, parent_);
    }
    if (basicConfig_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getBasicConfig());
    }
    if (feature_
        != com.google.cloud.datalabeling.v1beta1.LabelVideoRequest.Feature.FEATURE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, feature_);
    }
    if (requestConfigCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, (com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig) requestConfig_);
    }
    if (requestConfigCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5, (com.google.cloud.datalabeling.v1beta1.ObjectDetectionConfig) requestConfig_);
    }
    if (requestConfigCase_ == 6) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              6, (com.google.cloud.datalabeling.v1beta1.ObjectTrackingConfig) requestConfig_);
    }
    if (requestConfigCase_ == 7) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              7, (com.google.cloud.datalabeling.v1beta1.EventConfig) requestConfig_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.datalabeling.v1beta1.LabelVideoRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.datalabeling.v1beta1.LabelVideoRequest other =
        (com.google.cloud.datalabeling.v1beta1.LabelVideoRequest) obj;

    if (!getParent().equals(other.getParent())) return false;
    if (hasBasicConfig() != other.hasBasicConfig()) return false;
    if (hasBasicConfig()) {
      if (!getBasicConfig().equals(other.getBasicConfig())) return false;
    }
    if (feature_ != other.feature_) return false;
    if (!getRequestConfigCase().equals(other.getRequestConfigCase())) return false;
    switch (requestConfigCase_) {
      case 4:
        if (!getVideoClassificationConfig().equals(other.getVideoClassificationConfig()))
          return false;
        break;
      case 5:
        if (!getObjectDetectionConfig().equals(other.getObjectDetectionConfig())) return false;
        break;
      case 6:
        if (!getObjectTrackingConfig().equals(other.getObjectTrackingConfig())) return false;
        break;
      case 7:
        if (!getEventConfig().equals(other.getEventConfig())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PARENT_FIELD_NUMBER;
    hash = (53 * hash) + getParent().hashCode();
    if (hasBasicConfig()) {
      hash = (37 * hash) + BASIC_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getBasicConfig().hashCode();
    }
    hash = (37 * hash) + FEATURE_FIELD_NUMBER;
    hash = (53 * hash) + feature_;
    switch (requestConfigCase_) {
      case 4:
        hash = (37 * hash) + VIDEO_CLASSIFICATION_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getVideoClassificationConfig().hashCode();
        break;
      case 5:
        hash = (37 * hash) + OBJECT_DETECTION_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getObjectDetectionConfig().hashCode();
        break;
      case 6:
        hash = (37 * hash) + OBJECT_TRACKING_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getObjectTrackingConfig().hashCode();
        break;
      case 7:
        hash = (37 * hash) + EVENT_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getEventConfig().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.datalabeling.v1beta1.LabelVideoRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datalabeling.v1beta1.LabelVideoRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datalabeling.v1beta1.LabelVideoRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datalabeling.v1beta1.LabelVideoRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datalabeling.v1beta1.LabelVideoRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datalabeling.v1beta1.LabelVideoRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datalabeling.v1beta1.LabelVideoRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datalabeling.v1beta1.LabelVideoRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datalabeling.v1beta1.LabelVideoRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.datalabeling.v1beta1.LabelVideoRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datalabeling.v1beta1.LabelVideoRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datalabeling.v1beta1.LabelVideoRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.datalabeling.v1beta1.LabelVideoRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request message for LabelVideo.
   * </pre>
   *
   * Protobuf type {@code google.cloud.datalabeling.v1beta1.LabelVideoRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.datalabeling.v1beta1.LabelVideoRequest)
      com.google.cloud.datalabeling.v1beta1.LabelVideoRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.datalabeling.v1beta1.DataLabelingServiceOuterClass
          .internal_static_google_cloud_datalabeling_v1beta1_LabelVideoRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.datalabeling.v1beta1.DataLabelingServiceOuterClass
          .internal_static_google_cloud_datalabeling_v1beta1_LabelVideoRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.datalabeling.v1beta1.LabelVideoRequest.class,
              com.google.cloud.datalabeling.v1beta1.LabelVideoRequest.Builder.class);
    }

    // Construct using com.google.cloud.datalabeling.v1beta1.LabelVideoRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (videoClassificationConfigBuilder_ != null) {
        videoClassificationConfigBuilder_.clear();
      }
      if (objectDetectionConfigBuilder_ != null) {
        objectDetectionConfigBuilder_.clear();
      }
      if (objectTrackingConfigBuilder_ != null) {
        objectTrackingConfigBuilder_.clear();
      }
      if (eventConfigBuilder_ != null) {
        eventConfigBuilder_.clear();
      }
      parent_ = "";
      basicConfig_ = null;
      if (basicConfigBuilder_ != null) {
        basicConfigBuilder_.dispose();
        basicConfigBuilder_ = null;
      }
      feature_ = 0;
      requestConfigCase_ = 0;
      requestConfig_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.datalabeling.v1beta1.DataLabelingServiceOuterClass
          .internal_static_google_cloud_datalabeling_v1beta1_LabelVideoRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.LabelVideoRequest getDefaultInstanceForType() {
      return com.google.cloud.datalabeling.v1beta1.LabelVideoRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.LabelVideoRequest build() {
      com.google.cloud.datalabeling.v1beta1.LabelVideoRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.LabelVideoRequest buildPartial() {
      com.google.cloud.datalabeling.v1beta1.LabelVideoRequest result =
          new com.google.cloud.datalabeling.v1beta1.LabelVideoRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.datalabeling.v1beta1.LabelVideoRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.parent_ = parent_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.basicConfig_ =
            basicConfigBuilder_ == null ? basicConfig_ : basicConfigBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.feature_ = feature_;
      }
    }

    private void buildPartialOneofs(
        com.google.cloud.datalabeling.v1beta1.LabelVideoRequest result) {
      result.requestConfigCase_ = requestConfigCase_;
      result.requestConfig_ = this.requestConfig_;
      if (requestConfigCase_ == 4 && videoClassificationConfigBuilder_ != null) {
        result.requestConfig_ = videoClassificationConfigBuilder_.build();
      }
      if (requestConfigCase_ == 5 && objectDetectionConfigBuilder_ != null) {
        result.requestConfig_ = objectDetectionConfigBuilder_.build();
      }
      if (requestConfigCase_ == 6 && objectTrackingConfigBuilder_ != null) {
        result.requestConfig_ = objectTrackingConfigBuilder_.build();
      }
      if (requestConfigCase_ == 7 && eventConfigBuilder_ != null) {
        result.requestConfig_ = eventConfigBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.datalabeling.v1beta1.LabelVideoRequest) {
        return mergeFrom((com.google.cloud.datalabeling.v1beta1.LabelVideoRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.datalabeling.v1beta1.LabelVideoRequest other) {
      if (other == com.google.cloud.datalabeling.v1beta1.LabelVideoRequest.getDefaultInstance())
        return this;
      if (!other.getParent().isEmpty()) {
        parent_ = other.parent_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (other.hasBasicConfig()) {
        mergeBasicConfig(other.getBasicConfig());
      }
      if (other.feature_ != 0) {
        setFeatureValue(other.getFeatureValue());
      }
      switch (other.getRequestConfigCase()) {
        case VIDEO_CLASSIFICATION_CONFIG:
          {
            mergeVideoClassificationConfig(other.getVideoClassificationConfig());
            break;
          }
        case OBJECT_DETECTION_CONFIG:
          {
            mergeObjectDetectionConfig(other.getObjectDetectionConfig());
            break;
          }
        case OBJECT_TRACKING_CONFIG:
          {
            mergeObjectTrackingConfig(other.getObjectTrackingConfig());
            break;
          }
        case EVENT_CONFIG:
          {
            mergeEventConfig(other.getEventConfig());
            break;
          }
        case REQUESTCONFIG_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                parent_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getBasicConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 18
            case 24:
              {
                feature_ = input.readEnum();
                bitField0_ |= 0x00000040;
                break;
              } // case 24
            case 34:
              {
                input.readMessage(
                    getVideoClassificationConfigFieldBuilder().getBuilder(), extensionRegistry);
                requestConfigCase_ = 4;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(
                    getObjectDetectionConfigFieldBuilder().getBuilder(), extensionRegistry);
                requestConfigCase_ = 5;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(
                    getObjectTrackingConfigFieldBuilder().getBuilder(), extensionRegistry);
                requestConfigCase_ = 6;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getEventConfigFieldBuilder().getBuilder(), extensionRegistry);
                requestConfigCase_ = 7;
                break;
              } // case 58
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int requestConfigCase_ = 0;
    private java.lang.Object requestConfig_;

    public RequestConfigCase getRequestConfigCase() {
      return RequestConfigCase.forNumber(requestConfigCase_);
    }

    public Builder clearRequestConfig() {
      requestConfigCase_ = 0;
      requestConfig_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig,
            com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig.Builder,
            com.google.cloud.datalabeling.v1beta1.VideoClassificationConfigOrBuilder>
        videoClassificationConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Configuration for video classification task.
     * One of video_classification_config, object_detection_config,
     * object_tracking_config and event_config is required.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.VideoClassificationConfig video_classification_config = 4;
     * </code>
     *
     * @return Whether the videoClassificationConfig field is set.
     */
    @java.lang.Override
    public boolean hasVideoClassificationConfig() {
      return requestConfigCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * Configuration for video classification task.
     * One of video_classification_config, object_detection_config,
     * object_tracking_config and event_config is required.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.VideoClassificationConfig video_classification_config = 4;
     * </code>
     *
     * @return The videoClassificationConfig.
     */
    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig
        getVideoClassificationConfig() {
      if (videoClassificationConfigBuilder_ == null) {
        if (requestConfigCase_ == 4) {
          return (com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig) requestConfig_;
        }
        return com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig.getDefaultInstance();
      } else {
        if (requestConfigCase_ == 4) {
          return videoClassificationConfigBuilder_.getMessage();
        }
        return com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for video classification task.
     * One of video_classification_config, object_detection_config,
     * object_tracking_config and event_config is required.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.VideoClassificationConfig video_classification_config = 4;
     * </code>
     */
    public Builder setVideoClassificationConfig(
        com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig value) {
      if (videoClassificationConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        requestConfig_ = value;
        onChanged();
      } else {
        videoClassificationConfigBuilder_.setMessage(value);
      }
      requestConfigCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for video classification task.
     * One of video_classification_config, object_detection_config,
     * object_tracking_config and event_config is required.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.VideoClassificationConfig video_classification_config = 4;
     * </code>
     */
    public Builder setVideoClassificationConfig(
        com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig.Builder builderForValue) {
      if (videoClassificationConfigBuilder_ == null) {
        requestConfig_ = builderForValue.build();
        onChanged();
      } else {
        videoClassificationConfigBuilder_.setMessage(builderForValue.build());
      }
      requestConfigCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for video classification task.
     * One of video_classification_config, object_detection_config,
     * object_tracking_config and event_config is required.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.VideoClassificationConfig video_classification_config = 4;
     * </code>
     */
    public Builder mergeVideoClassificationConfig(
        com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig value) {
      if (videoClassificationConfigBuilder_ == null) {
        if (requestConfigCase_ == 4
            && requestConfig_
                != com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig
                    .getDefaultInstance()) {
          requestConfig_ =
              com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig.newBuilder(
                      (com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig)
                          requestConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          requestConfig_ = value;
        }
        onChanged();
      } else {
        if (requestConfigCase_ == 4) {
          videoClassificationConfigBuilder_.mergeFrom(value);
        } else {
          videoClassificationConfigBuilder_.setMessage(value);
        }
      }
      requestConfigCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for video classification task.
     * One of video_classification_config, object_detection_config,
     * object_tracking_config and event_config is required.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.VideoClassificationConfig video_classification_config = 4;
     * </code>
     */
    public Builder clearVideoClassificationConfig() {
      if (videoClassificationConfigBuilder_ == null) {
        if (requestConfigCase_ == 4) {
          requestConfigCase_ = 0;
          requestConfig_ = null;
          onChanged();
        }
      } else {
        if (requestConfigCase_ == 4) {
          requestConfigCase_ = 0;
          requestConfig_ = null;
        }
        videoClassificationConfigBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for video classification task.
     * One of video_classification_config, object_detection_config,
     * object_tracking_config and event_config is required.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.VideoClassificationConfig video_classification_config = 4;
     * </code>
     */
    public com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig.Builder
        getVideoClassificationConfigBuilder() {
      return getVideoClassificationConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Configuration for video classification task.
     * One of video_classification_config, object_detection_config,
     * object_tracking_config and event_config is required.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.VideoClassificationConfig video_classification_config = 4;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.VideoClassificationConfigOrBuilder
        getVideoClassificationConfigOrBuilder() {
      if ((requestConfigCase_ == 4) && (videoClassificationConfigBuilder_ != null)) {
        return videoClassificationConfigBuilder_.getMessageOrBuilder();
      } else {
        if (requestConfigCase_ == 4) {
          return (com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig) requestConfig_;
        }
        return com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for video classification task.
     * One of video_classification_config, object_detection_config,
     * object_tracking_config and event_config is required.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.VideoClassificationConfig video_classification_config = 4;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig,
            com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig.Builder,
            com.google.cloud.datalabeling.v1beta1.VideoClassificationConfigOrBuilder>
        getVideoClassificationConfigFieldBuilder() {
      if (videoClassificationConfigBuilder_ == null) {
        if (!(requestConfigCase_ == 4)) {
          requestConfig_ =
              com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig.getDefaultInstance();
        }
        videoClassificationConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig,
                com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig.Builder,
                com.google.cloud.datalabeling.v1beta1.VideoClassificationConfigOrBuilder>(
                (com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig) requestConfig_,
                getParentForChildren(),
                isClean());
        requestConfig_ = null;
      }
      requestConfigCase_ = 4;
      onChanged();
      return videoClassificationConfigBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.ObjectDetectionConfig,
            com.google.cloud.datalabeling.v1beta1.ObjectDetectionConfig.Builder,
            com.google.cloud.datalabeling.v1beta1.ObjectDetectionConfigOrBuilder>
        objectDetectionConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Configuration for video object detection task.
     * One of video_classification_config, object_detection_config,
     * object_tracking_config and event_config is required.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.ObjectDetectionConfig object_detection_config = 5;
     * </code>
     *
     * @return Whether the objectDetectionConfig field is set.
     */
    @java.lang.Override
    public boolean hasObjectDetectionConfig() {
      return requestConfigCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * Configuration for video object detection task.
     * One of video_classification_config, object_detection_config,
     * object_tracking_config and event_config is required.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.ObjectDetectionConfig object_detection_config = 5;
     * </code>
     *
     * @return The objectDetectionConfig.
     */
    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.ObjectDetectionConfig getObjectDetectionConfig() {
      if (objectDetectionConfigBuilder_ == null) {
        if (requestConfigCase_ == 5) {
          return (com.google.cloud.datalabeling.v1beta1.ObjectDetectionConfig) requestConfig_;
        }
        return com.google.cloud.datalabeling.v1beta1.ObjectDetectionConfig.getDefaultInstance();
      } else {
        if (requestConfigCase_ == 5) {
          return objectDetectionConfigBuilder_.getMessage();
        }
        return com.google.cloud.datalabeling.v1beta1.ObjectDetectionConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for video object detection task.
     * One of video_classification_config, object_detection_config,
     * object_tracking_config and event_config is required.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.ObjectDetectionConfig object_detection_config = 5;
     * </code>
     */
    public Builder setObjectDetectionConfig(
        com.google.cloud.datalabeling.v1beta1.ObjectDetectionConfig value) {
      if (objectDetectionConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        requestConfig_ = value;
        onChanged();
      } else {
        objectDetectionConfigBuilder_.setMessage(value);
      }
      requestConfigCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for video object detection task.
     * One of video_classification_config, object_detection_config,
     * object_tracking_config and event_config is required.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.ObjectDetectionConfig object_detection_config = 5;
     * </code>
     */
    public Builder setObjectDetectionConfig(
        com.google.cloud.datalabeling.v1beta1.ObjectDetectionConfig.Builder builderForValue) {
      if (objectDetectionConfigBuilder_ == null) {
        requestConfig_ = builderForValue.build();
        onChanged();
      } else {
        objectDetectionConfigBuilder_.setMessage(builderForValue.build());
      }
      requestConfigCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for video object detection task.
     * One of video_classification_config, object_detection_config,
     * object_tracking_config and event_config is required.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.ObjectDetectionConfig object_detection_config = 5;
     * </code>
     */
    public Builder mergeObjectDetectionConfig(
        com.google.cloud.datalabeling.v1beta1.ObjectDetectionConfig value) {
      if (objectDetectionConfigBuilder_ == null) {
        if (requestConfigCase_ == 5
            && requestConfig_
                != com.google.cloud.datalabeling.v1beta1.ObjectDetectionConfig
                    .getDefaultInstance()) {
          requestConfig_ =
              com.google.cloud.datalabeling.v1beta1.ObjectDetectionConfig.newBuilder(
                      (com.google.cloud.datalabeling.v1beta1.ObjectDetectionConfig) requestConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          requestConfig_ = value;
        }
        onChanged();
      } else {
        if (requestConfigCase_ == 5) {
          objectDetectionConfigBuilder_.mergeFrom(value);
        } else {
          objectDetectionConfigBuilder_.setMessage(value);
        }
      }
      requestConfigCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for video object detection task.
     * One of video_classification_config, object_detection_config,
     * object_tracking_config and event_config is required.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.ObjectDetectionConfig object_detection_config = 5;
     * </code>
     */
    public Builder clearObjectDetectionConfig() {
      if (objectDetectionConfigBuilder_ == null) {
        if (requestConfigCase_ == 5) {
          requestConfigCase_ = 0;
          requestConfig_ = null;
          onChanged();
        }
      } else {
        if (requestConfigCase_ == 5) {
          requestConfigCase_ = 0;
          requestConfig_ = null;
        }
        objectDetectionConfigBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for video object detection task.
     * One of video_classification_config, object_detection_config,
     * object_tracking_config and event_config is required.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.ObjectDetectionConfig object_detection_config = 5;
     * </code>
     */
    public com.google.cloud.datalabeling.v1beta1.ObjectDetectionConfig.Builder
        getObjectDetectionConfigBuilder() {
      return getObjectDetectionConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Configuration for video object detection task.
     * One of video_classification_config, object_detection_config,
     * object_tracking_config and event_config is required.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.ObjectDetectionConfig object_detection_config = 5;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.ObjectDetectionConfigOrBuilder
        getObjectDetectionConfigOrBuilder() {
      if ((requestConfigCase_ == 5) && (objectDetectionConfigBuilder_ != null)) {
        return objectDetectionConfigBuilder_.getMessageOrBuilder();
      } else {
        if (requestConfigCase_ == 5) {
          return (com.google.cloud.datalabeling.v1beta1.ObjectDetectionConfig) requestConfig_;
        }
        return com.google.cloud.datalabeling.v1beta1.ObjectDetectionConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for video object detection task.
     * One of video_classification_config, object_detection_config,
     * object_tracking_config and event_config is required.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.ObjectDetectionConfig object_detection_config = 5;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.ObjectDetectionConfig,
            com.google.cloud.datalabeling.v1beta1.ObjectDetectionConfig.Builder,
            com.google.cloud.datalabeling.v1beta1.ObjectDetectionConfigOrBuilder>
        getObjectDetectionConfigFieldBuilder() {
      if (objectDetectionConfigBuilder_ == null) {
        if (!(requestConfigCase_ == 5)) {
          requestConfig_ =
              com.google.cloud.datalabeling.v1beta1.ObjectDetectionConfig.getDefaultInstance();
        }
        objectDetectionConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datalabeling.v1beta1.ObjectDetectionConfig,
                com.google.cloud.datalabeling.v1beta1.ObjectDetectionConfig.Builder,
                com.google.cloud.datalabeling.v1beta1.ObjectDetectionConfigOrBuilder>(
                (com.google.cloud.datalabeling.v1beta1.ObjectDetectionConfig) requestConfig_,
                getParentForChildren(),
                isClean());
        requestConfig_ = null;
      }
      requestConfigCase_ = 5;
      onChanged();
      return objectDetectionConfigBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.ObjectTrackingConfig,
            com.google.cloud.datalabeling.v1beta1.ObjectTrackingConfig.Builder,
            com.google.cloud.datalabeling.v1beta1.ObjectTrackingConfigOrBuilder>
        objectTrackingConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Configuration for video object tracking task.
     * One of video_classification_config, object_detection_config,
     * object_tracking_config and event_config is required.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.ObjectTrackingConfig object_tracking_config = 6;
     * </code>
     *
     * @return Whether the objectTrackingConfig field is set.
     */
    @java.lang.Override
    public boolean hasObjectTrackingConfig() {
      return requestConfigCase_ == 6;
    }
    /**
     *
     *
     * <pre>
     * Configuration for video object tracking task.
     * One of video_classification_config, object_detection_config,
     * object_tracking_config and event_config is required.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.ObjectTrackingConfig object_tracking_config = 6;
     * </code>
     *
     * @return The objectTrackingConfig.
     */
    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.ObjectTrackingConfig getObjectTrackingConfig() {
      if (objectTrackingConfigBuilder_ == null) {
        if (requestConfigCase_ == 6) {
          return (com.google.cloud.datalabeling.v1beta1.ObjectTrackingConfig) requestConfig_;
        }
        return com.google.cloud.datalabeling.v1beta1.ObjectTrackingConfig.getDefaultInstance();
      } else {
        if (requestConfigCase_ == 6) {
          return objectTrackingConfigBuilder_.getMessage();
        }
        return com.google.cloud.datalabeling.v1beta1.ObjectTrackingConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for video object tracking task.
     * One of video_classification_config, object_detection_config,
     * object_tracking_config and event_config is required.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.ObjectTrackingConfig object_tracking_config = 6;
     * </code>
     */
    public Builder setObjectTrackingConfig(
        com.google.cloud.datalabeling.v1beta1.ObjectTrackingConfig value) {
      if (objectTrackingConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        requestConfig_ = value;
        onChanged();
      } else {
        objectTrackingConfigBuilder_.setMessage(value);
      }
      requestConfigCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for video object tracking task.
     * One of video_classification_config, object_detection_config,
     * object_tracking_config and event_config is required.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.ObjectTrackingConfig object_tracking_config = 6;
     * </code>
     */
    public Builder setObjectTrackingConfig(
        com.google.cloud.datalabeling.v1beta1.ObjectTrackingConfig.Builder builderForValue) {
      if (objectTrackingConfigBuilder_ == null) {
        requestConfig_ = builderForValue.build();
        onChanged();
      } else {
        objectTrackingConfigBuilder_.setMessage(builderForValue.build());
      }
      requestConfigCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for video object tracking task.
     * One of video_classification_config, object_detection_config,
     * object_tracking_config and event_config is required.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.ObjectTrackingConfig object_tracking_config = 6;
     * </code>
     */
    public Builder mergeObjectTrackingConfig(
        com.google.cloud.datalabeling.v1beta1.ObjectTrackingConfig value) {
      if (objectTrackingConfigBuilder_ == null) {
        if (requestConfigCase_ == 6
            && requestConfig_
                != com.google.cloud.datalabeling.v1beta1.ObjectTrackingConfig
                    .getDefaultInstance()) {
          requestConfig_ =
              com.google.cloud.datalabeling.v1beta1.ObjectTrackingConfig.newBuilder(
                      (com.google.cloud.datalabeling.v1beta1.ObjectTrackingConfig) requestConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          requestConfig_ = value;
        }
        onChanged();
      } else {
        if (requestConfigCase_ == 6) {
          objectTrackingConfigBuilder_.mergeFrom(value);
        } else {
          objectTrackingConfigBuilder_.setMessage(value);
        }
      }
      requestConfigCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for video object tracking task.
     * One of video_classification_config, object_detection_config,
     * object_tracking_config and event_config is required.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.ObjectTrackingConfig object_tracking_config = 6;
     * </code>
     */
    public Builder clearObjectTrackingConfig() {
      if (objectTrackingConfigBuilder_ == null) {
        if (requestConfigCase_ == 6) {
          requestConfigCase_ = 0;
          requestConfig_ = null;
          onChanged();
        }
      } else {
        if (requestConfigCase_ == 6) {
          requestConfigCase_ = 0;
          requestConfig_ = null;
        }
        objectTrackingConfigBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for video object tracking task.
     * One of video_classification_config, object_detection_config,
     * object_tracking_config and event_config is required.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.ObjectTrackingConfig object_tracking_config = 6;
     * </code>
     */
    public com.google.cloud.datalabeling.v1beta1.ObjectTrackingConfig.Builder
        getObjectTrackingConfigBuilder() {
      return getObjectTrackingConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Configuration for video object tracking task.
     * One of video_classification_config, object_detection_config,
     * object_tracking_config and event_config is required.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.ObjectTrackingConfig object_tracking_config = 6;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.ObjectTrackingConfigOrBuilder
        getObjectTrackingConfigOrBuilder() {
      if ((requestConfigCase_ == 6) && (objectTrackingConfigBuilder_ != null)) {
        return objectTrackingConfigBuilder_.getMessageOrBuilder();
      } else {
        if (requestConfigCase_ == 6) {
          return (com.google.cloud.datalabeling.v1beta1.ObjectTrackingConfig) requestConfig_;
        }
        return com.google.cloud.datalabeling.v1beta1.ObjectTrackingConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for video object tracking task.
     * One of video_classification_config, object_detection_config,
     * object_tracking_config and event_config is required.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.ObjectTrackingConfig object_tracking_config = 6;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.ObjectTrackingConfig,
            com.google.cloud.datalabeling.v1beta1.ObjectTrackingConfig.Builder,
            com.google.cloud.datalabeling.v1beta1.ObjectTrackingConfigOrBuilder>
        getObjectTrackingConfigFieldBuilder() {
      if (objectTrackingConfigBuilder_ == null) {
        if (!(requestConfigCase_ == 6)) {
          requestConfig_ =
              com.google.cloud.datalabeling.v1beta1.ObjectTrackingConfig.getDefaultInstance();
        }
        objectTrackingConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datalabeling.v1beta1.ObjectTrackingConfig,
                com.google.cloud.datalabeling.v1beta1.ObjectTrackingConfig.Builder,
                com.google.cloud.datalabeling.v1beta1.ObjectTrackingConfigOrBuilder>(
                (com.google.cloud.datalabeling.v1beta1.ObjectTrackingConfig) requestConfig_,
                getParentForChildren(),
                isClean());
        requestConfig_ = null;
      }
      requestConfigCase_ = 6;
      onChanged();
      return objectTrackingConfigBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.EventConfig,
            com.google.cloud.datalabeling.v1beta1.EventConfig.Builder,
            com.google.cloud.datalabeling.v1beta1.EventConfigOrBuilder>
        eventConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Configuration for video event task.
     * One of video_classification_config, object_detection_config,
     * object_tracking_config and event_config is required.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.EventConfig event_config = 7;</code>
     *
     * @return Whether the eventConfig field is set.
     */
    @java.lang.Override
    public boolean hasEventConfig() {
      return requestConfigCase_ == 7;
    }
    /**
     *
     *
     * <pre>
     * Configuration for video event task.
     * One of video_classification_config, object_detection_config,
     * object_tracking_config and event_config is required.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.EventConfig event_config = 7;</code>
     *
     * @return The eventConfig.
     */
    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.EventConfig getEventConfig() {
      if (eventConfigBuilder_ == null) {
        if (requestConfigCase_ == 7) {
          return (com.google.cloud.datalabeling.v1beta1.EventConfig) requestConfig_;
        }
        return com.google.cloud.datalabeling.v1beta1.EventConfig.getDefaultInstance();
      } else {
        if (requestConfigCase_ == 7) {
          return eventConfigBuilder_.getMessage();
        }
        return com.google.cloud.datalabeling.v1beta1.EventConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for video event task.
     * One of video_classification_config, object_detection_config,
     * object_tracking_config and event_config is required.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.EventConfig event_config = 7;</code>
     */
    public Builder setEventConfig(com.google.cloud.datalabeling.v1beta1.EventConfig value) {
      if (eventConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        requestConfig_ = value;
        onChanged();
      } else {
        eventConfigBuilder_.setMessage(value);
      }
      requestConfigCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for video event task.
     * One of video_classification_config, object_detection_config,
     * object_tracking_config and event_config is required.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.EventConfig event_config = 7;</code>
     */
    public Builder setEventConfig(
        com.google.cloud.datalabeling.v1beta1.EventConfig.Builder builderForValue) {
      if (eventConfigBuilder_ == null) {
        requestConfig_ = builderForValue.build();
        onChanged();
      } else {
        eventConfigBuilder_.setMessage(builderForValue.build());
      }
      requestConfigCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for video event task.
     * One of video_classification_config, object_detection_config,
     * object_tracking_config and event_config is required.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.EventConfig event_config = 7;</code>
     */
    public Builder mergeEventConfig(com.google.cloud.datalabeling.v1beta1.EventConfig value) {
      if (eventConfigBuilder_ == null) {
        if (requestConfigCase_ == 7
            && requestConfig_
                != com.google.cloud.datalabeling.v1beta1.EventConfig.getDefaultInstance()) {
          requestConfig_ =
              com.google.cloud.datalabeling.v1beta1.EventConfig.newBuilder(
                      (com.google.cloud.datalabeling.v1beta1.EventConfig) requestConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          requestConfig_ = value;
        }
        onChanged();
      } else {
        if (requestConfigCase_ == 7) {
          eventConfigBuilder_.mergeFrom(value);
        } else {
          eventConfigBuilder_.setMessage(value);
        }
      }
      requestConfigCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for video event task.
     * One of video_classification_config, object_detection_config,
     * object_tracking_config and event_config is required.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.EventConfig event_config = 7;</code>
     */
    public Builder clearEventConfig() {
      if (eventConfigBuilder_ == null) {
        if (requestConfigCase_ == 7) {
          requestConfigCase_ = 0;
          requestConfig_ = null;
          onChanged();
        }
      } else {
        if (requestConfigCase_ == 7) {
          requestConfigCase_ = 0;
          requestConfig_ = null;
        }
        eventConfigBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for video event task.
     * One of video_classification_config, object_detection_config,
     * object_tracking_config and event_config is required.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.EventConfig event_config = 7;</code>
     */
    public com.google.cloud.datalabeling.v1beta1.EventConfig.Builder getEventConfigBuilder() {
      return getEventConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Configuration for video event task.
     * One of video_classification_config, object_detection_config,
     * object_tracking_config and event_config is required.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.EventConfig event_config = 7;</code>
     */
    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.EventConfigOrBuilder getEventConfigOrBuilder() {
      if ((requestConfigCase_ == 7) && (eventConfigBuilder_ != null)) {
        return eventConfigBuilder_.getMessageOrBuilder();
      } else {
        if (requestConfigCase_ == 7) {
          return (com.google.cloud.datalabeling.v1beta1.EventConfig) requestConfig_;
        }
        return com.google.cloud.datalabeling.v1beta1.EventConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for video event task.
     * One of video_classification_config, object_detection_config,
     * object_tracking_config and event_config is required.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.EventConfig event_config = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.EventConfig,
            com.google.cloud.datalabeling.v1beta1.EventConfig.Builder,
            com.google.cloud.datalabeling.v1beta1.EventConfigOrBuilder>
        getEventConfigFieldBuilder() {
      if (eventConfigBuilder_ == null) {
        if (!(requestConfigCase_ == 7)) {
          requestConfig_ = com.google.cloud.datalabeling.v1beta1.EventConfig.getDefaultInstance();
        }
        eventConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datalabeling.v1beta1.EventConfig,
                com.google.cloud.datalabeling.v1beta1.EventConfig.Builder,
                com.google.cloud.datalabeling.v1beta1.EventConfigOrBuilder>(
                (com.google.cloud.datalabeling.v1beta1.EventConfig) requestConfig_,
                getParentForChildren(),
                isClean());
        requestConfig_ = null;
      }
      requestConfigCase_ = 7;
      onChanged();
      return eventConfigBuilder_;
    }

    private java.lang.Object parent_ = "";
    /**
     *
     *
     * <pre>
     * Required. Name of the dataset to request labeling task, format:
     * projects/{project_id}/datasets/{dataset_id}
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The parent.
     */
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Name of the dataset to request labeling task, format:
     * projects/{project_id}/datasets/{dataset_id}
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for parent.
     */
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Name of the dataset to request labeling task, format:
     * projects/{project_id}/datasets/{dataset_id}
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The parent to set.
     * @return This builder for chaining.
     */
    public Builder setParent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      parent_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Name of the dataset to request labeling task, format:
     * projects/{project_id}/datasets/{dataset_id}
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParent() {
      parent_ = getDefaultInstance().getParent();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Name of the dataset to request labeling task, format:
     * projects/{project_id}/datasets/{dataset_id}
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for parent to set.
     * @return This builder for chaining.
     */
    public Builder setParentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      parent_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig basicConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig,
            com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig.Builder,
            com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfigOrBuilder>
        basicConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Required. Basic human annotation config.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.HumanAnnotationConfig basic_config = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the basicConfig field is set.
     */
    public boolean hasBasicConfig() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. Basic human annotation config.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.HumanAnnotationConfig basic_config = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The basicConfig.
     */
    public com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig getBasicConfig() {
      if (basicConfigBuilder_ == null) {
        return basicConfig_ == null
            ? com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig.getDefaultInstance()
            : basicConfig_;
      } else {
        return basicConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Basic human annotation config.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.HumanAnnotationConfig basic_config = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setBasicConfig(
        com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig value) {
      if (basicConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        basicConfig_ = value;
      } else {
        basicConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Basic human annotation config.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.HumanAnnotationConfig basic_config = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setBasicConfig(
        com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig.Builder builderForValue) {
      if (basicConfigBuilder_ == null) {
        basicConfig_ = builderForValue.build();
      } else {
        basicConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Basic human annotation config.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.HumanAnnotationConfig basic_config = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeBasicConfig(
        com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig value) {
      if (basicConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && basicConfig_ != null
            && basicConfig_
                != com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig
                    .getDefaultInstance()) {
          getBasicConfigBuilder().mergeFrom(value);
        } else {
          basicConfig_ = value;
        }
      } else {
        basicConfigBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Basic human annotation config.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.HumanAnnotationConfig basic_config = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearBasicConfig() {
      bitField0_ = (bitField0_ & ~0x00000020);
      basicConfig_ = null;
      if (basicConfigBuilder_ != null) {
        basicConfigBuilder_.dispose();
        basicConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Basic human annotation config.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.HumanAnnotationConfig basic_config = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig.Builder
        getBasicConfigBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getBasicConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. Basic human annotation config.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.HumanAnnotationConfig basic_config = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfigOrBuilder
        getBasicConfigOrBuilder() {
      if (basicConfigBuilder_ != null) {
        return basicConfigBuilder_.getMessageOrBuilder();
      } else {
        return basicConfig_ == null
            ? com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig.getDefaultInstance()
            : basicConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Basic human annotation config.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.HumanAnnotationConfig basic_config = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig,
            com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig.Builder,
            com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfigOrBuilder>
        getBasicConfigFieldBuilder() {
      if (basicConfigBuilder_ == null) {
        basicConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig,
                com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig.Builder,
                com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfigOrBuilder>(
                getBasicConfig(), getParentForChildren(), isClean());
        basicConfig_ = null;
      }
      return basicConfigBuilder_;
    }

    private int feature_ = 0;
    /**
     *
     *
     * <pre>
     * Required. The type of video labeling task.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.LabelVideoRequest.Feature feature = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The enum numeric value on the wire for feature.
     */
    @java.lang.Override
    public int getFeatureValue() {
      return feature_;
    }
    /**
     *
     *
     * <pre>
     * Required. The type of video labeling task.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.LabelVideoRequest.Feature feature = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The enum numeric value on the wire for feature to set.
     * @return This builder for chaining.
     */
    public Builder setFeatureValue(int value) {
      feature_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The type of video labeling task.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.LabelVideoRequest.Feature feature = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The feature.
     */
    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.LabelVideoRequest.Feature getFeature() {
      com.google.cloud.datalabeling.v1beta1.LabelVideoRequest.Feature result =
          com.google.cloud.datalabeling.v1beta1.LabelVideoRequest.Feature.forNumber(feature_);
      return result == null
          ? com.google.cloud.datalabeling.v1beta1.LabelVideoRequest.Feature.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Required. The type of video labeling task.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.LabelVideoRequest.Feature feature = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The feature to set.
     * @return This builder for chaining.
     */
    public Builder setFeature(
        com.google.cloud.datalabeling.v1beta1.LabelVideoRequest.Feature value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000040;
      feature_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The type of video labeling task.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.LabelVideoRequest.Feature feature = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFeature() {
      bitField0_ = (bitField0_ & ~0x00000040);
      feature_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.datalabeling.v1beta1.LabelVideoRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.datalabeling.v1beta1.LabelVideoRequest)
  private static final com.google.cloud.datalabeling.v1beta1.LabelVideoRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.datalabeling.v1beta1.LabelVideoRequest();
  }

  public static com.google.cloud.datalabeling.v1beta1.LabelVideoRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<LabelVideoRequest> PARSER =
      new com.google.protobuf.AbstractParser<LabelVideoRequest>() {
        @java.lang.Override
        public LabelVideoRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<LabelVideoRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<LabelVideoRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.LabelVideoRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
