/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/datalabeling/v1beta1/annotation.proto

package com.google.cloud.datalabeling.v1beta1;

/**
 *
 *
 * <pre>
 * Video object tracking annotation.
 * </pre>
 *
 * Protobuf type {@code google.cloud.datalabeling.v1beta1.VideoObjectTrackingAnnotation}
 */
public final class VideoObjectTrackingAnnotation extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.datalabeling.v1beta1.VideoObjectTrackingAnnotation)
    VideoObjectTrackingAnnotationOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use VideoObjectTrackingAnnotation.newBuilder() to construct.
  private VideoObjectTrackingAnnotation(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private VideoObjectTrackingAnnotation() {
    objectTrackingFrames_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new VideoObjectTrackingAnnotation();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.datalabeling.v1beta1.AnnotationOuterClass
        .internal_static_google_cloud_datalabeling_v1beta1_VideoObjectTrackingAnnotation_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.datalabeling.v1beta1.AnnotationOuterClass
        .internal_static_google_cloud_datalabeling_v1beta1_VideoObjectTrackingAnnotation_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.datalabeling.v1beta1.VideoObjectTrackingAnnotation.class,
            com.google.cloud.datalabeling.v1beta1.VideoObjectTrackingAnnotation.Builder.class);
  }

  public static final int ANNOTATION_SPEC_FIELD_NUMBER = 1;
  private com.google.cloud.datalabeling.v1beta1.AnnotationSpec annotationSpec_;
  /**
   *
   *
   * <pre>
   * Label of the object tracked in this annotation.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.AnnotationSpec annotation_spec = 1;</code>
   *
   * @return Whether the annotationSpec field is set.
   */
  @java.lang.Override
  public boolean hasAnnotationSpec() {
    return annotationSpec_ != null;
  }
  /**
   *
   *
   * <pre>
   * Label of the object tracked in this annotation.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.AnnotationSpec annotation_spec = 1;</code>
   *
   * @return The annotationSpec.
   */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.AnnotationSpec getAnnotationSpec() {
    return annotationSpec_ == null
        ? com.google.cloud.datalabeling.v1beta1.AnnotationSpec.getDefaultInstance()
        : annotationSpec_;
  }
  /**
   *
   *
   * <pre>
   * Label of the object tracked in this annotation.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.AnnotationSpec annotation_spec = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.AnnotationSpecOrBuilder
      getAnnotationSpecOrBuilder() {
    return annotationSpec_ == null
        ? com.google.cloud.datalabeling.v1beta1.AnnotationSpec.getDefaultInstance()
        : annotationSpec_;
  }

  public static final int TIME_SEGMENT_FIELD_NUMBER = 2;
  private com.google.cloud.datalabeling.v1beta1.TimeSegment timeSegment_;
  /**
   *
   *
   * <pre>
   * The time segment of the video to which object tracking applies.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.TimeSegment time_segment = 2;</code>
   *
   * @return Whether the timeSegment field is set.
   */
  @java.lang.Override
  public boolean hasTimeSegment() {
    return timeSegment_ != null;
  }
  /**
   *
   *
   * <pre>
   * The time segment of the video to which object tracking applies.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.TimeSegment time_segment = 2;</code>
   *
   * @return The timeSegment.
   */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.TimeSegment getTimeSegment() {
    return timeSegment_ == null
        ? com.google.cloud.datalabeling.v1beta1.TimeSegment.getDefaultInstance()
        : timeSegment_;
  }
  /**
   *
   *
   * <pre>
   * The time segment of the video to which object tracking applies.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.TimeSegment time_segment = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.TimeSegmentOrBuilder getTimeSegmentOrBuilder() {
    return timeSegment_ == null
        ? com.google.cloud.datalabeling.v1beta1.TimeSegment.getDefaultInstance()
        : timeSegment_;
  }

  public static final int OBJECT_TRACKING_FRAMES_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.datalabeling.v1beta1.ObjectTrackingFrame>
      objectTrackingFrames_;
  /**
   *
   *
   * <pre>
   * The list of frames where this object track appears.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.datalabeling.v1beta1.ObjectTrackingFrame object_tracking_frames = 3;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.datalabeling.v1beta1.ObjectTrackingFrame>
      getObjectTrackingFramesList() {
    return objectTrackingFrames_;
  }
  /**
   *
   *
   * <pre>
   * The list of frames where this object track appears.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.datalabeling.v1beta1.ObjectTrackingFrame object_tracking_frames = 3;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.datalabeling.v1beta1.ObjectTrackingFrameOrBuilder>
      getObjectTrackingFramesOrBuilderList() {
    return objectTrackingFrames_;
  }
  /**
   *
   *
   * <pre>
   * The list of frames where this object track appears.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.datalabeling.v1beta1.ObjectTrackingFrame object_tracking_frames = 3;
   * </code>
   */
  @java.lang.Override
  public int getObjectTrackingFramesCount() {
    return objectTrackingFrames_.size();
  }
  /**
   *
   *
   * <pre>
   * The list of frames where this object track appears.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.datalabeling.v1beta1.ObjectTrackingFrame object_tracking_frames = 3;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.ObjectTrackingFrame getObjectTrackingFrames(
      int index) {
    return objectTrackingFrames_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The list of frames where this object track appears.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.datalabeling.v1beta1.ObjectTrackingFrame object_tracking_frames = 3;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.ObjectTrackingFrameOrBuilder
      getObjectTrackingFramesOrBuilder(int index) {
    return objectTrackingFrames_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (annotationSpec_ != null) {
      output.writeMessage(1, getAnnotationSpec());
    }
    if (timeSegment_ != null) {
      output.writeMessage(2, getTimeSegment());
    }
    for (int i = 0; i < objectTrackingFrames_.size(); i++) {
      output.writeMessage(3, objectTrackingFrames_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (annotationSpec_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getAnnotationSpec());
    }
    if (timeSegment_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getTimeSegment());
    }
    for (int i = 0; i < objectTrackingFrames_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(3, objectTrackingFrames_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.datalabeling.v1beta1.VideoObjectTrackingAnnotation)) {
      return super.equals(obj);
    }
    com.google.cloud.datalabeling.v1beta1.VideoObjectTrackingAnnotation other =
        (com.google.cloud.datalabeling.v1beta1.VideoObjectTrackingAnnotation) obj;

    if (hasAnnotationSpec() != other.hasAnnotationSpec()) return false;
    if (hasAnnotationSpec()) {
      if (!getAnnotationSpec().equals(other.getAnnotationSpec())) return false;
    }
    if (hasTimeSegment() != other.hasTimeSegment()) return false;
    if (hasTimeSegment()) {
      if (!getTimeSegment().equals(other.getTimeSegment())) return false;
    }
    if (!getObjectTrackingFramesList().equals(other.getObjectTrackingFramesList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasAnnotationSpec()) {
      hash = (37 * hash) + ANNOTATION_SPEC_FIELD_NUMBER;
      hash = (53 * hash) + getAnnotationSpec().hashCode();
    }
    if (hasTimeSegment()) {
      hash = (37 * hash) + TIME_SEGMENT_FIELD_NUMBER;
      hash = (53 * hash) + getTimeSegment().hashCode();
    }
    if (getObjectTrackingFramesCount() > 0) {
      hash = (37 * hash) + OBJECT_TRACKING_FRAMES_FIELD_NUMBER;
      hash = (53 * hash) + getObjectTrackingFramesList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.datalabeling.v1beta1.VideoObjectTrackingAnnotation parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datalabeling.v1beta1.VideoObjectTrackingAnnotation parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datalabeling.v1beta1.VideoObjectTrackingAnnotation parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datalabeling.v1beta1.VideoObjectTrackingAnnotation parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datalabeling.v1beta1.VideoObjectTrackingAnnotation parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datalabeling.v1beta1.VideoObjectTrackingAnnotation parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datalabeling.v1beta1.VideoObjectTrackingAnnotation parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datalabeling.v1beta1.VideoObjectTrackingAnnotation parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datalabeling.v1beta1.VideoObjectTrackingAnnotation
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.datalabeling.v1beta1.VideoObjectTrackingAnnotation
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datalabeling.v1beta1.VideoObjectTrackingAnnotation parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datalabeling.v1beta1.VideoObjectTrackingAnnotation parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.datalabeling.v1beta1.VideoObjectTrackingAnnotation prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Video object tracking annotation.
   * </pre>
   *
   * Protobuf type {@code google.cloud.datalabeling.v1beta1.VideoObjectTrackingAnnotation}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.datalabeling.v1beta1.VideoObjectTrackingAnnotation)
      com.google.cloud.datalabeling.v1beta1.VideoObjectTrackingAnnotationOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.datalabeling.v1beta1.AnnotationOuterClass
          .internal_static_google_cloud_datalabeling_v1beta1_VideoObjectTrackingAnnotation_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.datalabeling.v1beta1.AnnotationOuterClass
          .internal_static_google_cloud_datalabeling_v1beta1_VideoObjectTrackingAnnotation_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.datalabeling.v1beta1.VideoObjectTrackingAnnotation.class,
              com.google.cloud.datalabeling.v1beta1.VideoObjectTrackingAnnotation.Builder.class);
    }

    // Construct using
    // com.google.cloud.datalabeling.v1beta1.VideoObjectTrackingAnnotation.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      annotationSpec_ = null;
      if (annotationSpecBuilder_ != null) {
        annotationSpecBuilder_.dispose();
        annotationSpecBuilder_ = null;
      }
      timeSegment_ = null;
      if (timeSegmentBuilder_ != null) {
        timeSegmentBuilder_.dispose();
        timeSegmentBuilder_ = null;
      }
      if (objectTrackingFramesBuilder_ == null) {
        objectTrackingFrames_ = java.util.Collections.emptyList();
      } else {
        objectTrackingFrames_ = null;
        objectTrackingFramesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.datalabeling.v1beta1.AnnotationOuterClass
          .internal_static_google_cloud_datalabeling_v1beta1_VideoObjectTrackingAnnotation_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.VideoObjectTrackingAnnotation
        getDefaultInstanceForType() {
      return com.google.cloud.datalabeling.v1beta1.VideoObjectTrackingAnnotation
          .getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.VideoObjectTrackingAnnotation build() {
      com.google.cloud.datalabeling.v1beta1.VideoObjectTrackingAnnotation result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.VideoObjectTrackingAnnotation buildPartial() {
      com.google.cloud.datalabeling.v1beta1.VideoObjectTrackingAnnotation result =
          new com.google.cloud.datalabeling.v1beta1.VideoObjectTrackingAnnotation(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.datalabeling.v1beta1.VideoObjectTrackingAnnotation result) {
      if (objectTrackingFramesBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          objectTrackingFrames_ = java.util.Collections.unmodifiableList(objectTrackingFrames_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.objectTrackingFrames_ = objectTrackingFrames_;
      } else {
        result.objectTrackingFrames_ = objectTrackingFramesBuilder_.build();
      }
    }

    private void buildPartial0(
        com.google.cloud.datalabeling.v1beta1.VideoObjectTrackingAnnotation result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.annotationSpec_ =
            annotationSpecBuilder_ == null ? annotationSpec_ : annotationSpecBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.timeSegment_ =
            timeSegmentBuilder_ == null ? timeSegment_ : timeSegmentBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.datalabeling.v1beta1.VideoObjectTrackingAnnotation) {
        return mergeFrom(
            (com.google.cloud.datalabeling.v1beta1.VideoObjectTrackingAnnotation) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.datalabeling.v1beta1.VideoObjectTrackingAnnotation other) {
      if (other
          == com.google.cloud.datalabeling.v1beta1.VideoObjectTrackingAnnotation
              .getDefaultInstance()) return this;
      if (other.hasAnnotationSpec()) {
        mergeAnnotationSpec(other.getAnnotationSpec());
      }
      if (other.hasTimeSegment()) {
        mergeTimeSegment(other.getTimeSegment());
      }
      if (objectTrackingFramesBuilder_ == null) {
        if (!other.objectTrackingFrames_.isEmpty()) {
          if (objectTrackingFrames_.isEmpty()) {
            objectTrackingFrames_ = other.objectTrackingFrames_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureObjectTrackingFramesIsMutable();
            objectTrackingFrames_.addAll(other.objectTrackingFrames_);
          }
          onChanged();
        }
      } else {
        if (!other.objectTrackingFrames_.isEmpty()) {
          if (objectTrackingFramesBuilder_.isEmpty()) {
            objectTrackingFramesBuilder_.dispose();
            objectTrackingFramesBuilder_ = null;
            objectTrackingFrames_ = other.objectTrackingFrames_;
            bitField0_ = (bitField0_ & ~0x00000004);
            objectTrackingFramesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getObjectTrackingFramesFieldBuilder()
                    : null;
          } else {
            objectTrackingFramesBuilder_.addAllMessages(other.objectTrackingFrames_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getAnnotationSpecFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getTimeSegmentFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                com.google.cloud.datalabeling.v1beta1.ObjectTrackingFrame m =
                    input.readMessage(
                        com.google.cloud.datalabeling.v1beta1.ObjectTrackingFrame.parser(),
                        extensionRegistry);
                if (objectTrackingFramesBuilder_ == null) {
                  ensureObjectTrackingFramesIsMutable();
                  objectTrackingFrames_.add(m);
                } else {
                  objectTrackingFramesBuilder_.addMessage(m);
                }
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.cloud.datalabeling.v1beta1.AnnotationSpec annotationSpec_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.AnnotationSpec,
            com.google.cloud.datalabeling.v1beta1.AnnotationSpec.Builder,
            com.google.cloud.datalabeling.v1beta1.AnnotationSpecOrBuilder>
        annotationSpecBuilder_;
    /**
     *
     *
     * <pre>
     * Label of the object tracked in this annotation.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.AnnotationSpec annotation_spec = 1;</code>
     *
     * @return Whether the annotationSpec field is set.
     */
    public boolean hasAnnotationSpec() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Label of the object tracked in this annotation.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.AnnotationSpec annotation_spec = 1;</code>
     *
     * @return The annotationSpec.
     */
    public com.google.cloud.datalabeling.v1beta1.AnnotationSpec getAnnotationSpec() {
      if (annotationSpecBuilder_ == null) {
        return annotationSpec_ == null
            ? com.google.cloud.datalabeling.v1beta1.AnnotationSpec.getDefaultInstance()
            : annotationSpec_;
      } else {
        return annotationSpecBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Label of the object tracked in this annotation.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.AnnotationSpec annotation_spec = 1;</code>
     */
    public Builder setAnnotationSpec(com.google.cloud.datalabeling.v1beta1.AnnotationSpec value) {
      if (annotationSpecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        annotationSpec_ = value;
      } else {
        annotationSpecBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Label of the object tracked in this annotation.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.AnnotationSpec annotation_spec = 1;</code>
     */
    public Builder setAnnotationSpec(
        com.google.cloud.datalabeling.v1beta1.AnnotationSpec.Builder builderForValue) {
      if (annotationSpecBuilder_ == null) {
        annotationSpec_ = builderForValue.build();
      } else {
        annotationSpecBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Label of the object tracked in this annotation.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.AnnotationSpec annotation_spec = 1;</code>
     */
    public Builder mergeAnnotationSpec(com.google.cloud.datalabeling.v1beta1.AnnotationSpec value) {
      if (annotationSpecBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && annotationSpec_ != null
            && annotationSpec_
                != com.google.cloud.datalabeling.v1beta1.AnnotationSpec.getDefaultInstance()) {
          getAnnotationSpecBuilder().mergeFrom(value);
        } else {
          annotationSpec_ = value;
        }
      } else {
        annotationSpecBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Label of the object tracked in this annotation.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.AnnotationSpec annotation_spec = 1;</code>
     */
    public Builder clearAnnotationSpec() {
      bitField0_ = (bitField0_ & ~0x00000001);
      annotationSpec_ = null;
      if (annotationSpecBuilder_ != null) {
        annotationSpecBuilder_.dispose();
        annotationSpecBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Label of the object tracked in this annotation.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.AnnotationSpec annotation_spec = 1;</code>
     */
    public com.google.cloud.datalabeling.v1beta1.AnnotationSpec.Builder getAnnotationSpecBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getAnnotationSpecFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Label of the object tracked in this annotation.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.AnnotationSpec annotation_spec = 1;</code>
     */
    public com.google.cloud.datalabeling.v1beta1.AnnotationSpecOrBuilder
        getAnnotationSpecOrBuilder() {
      if (annotationSpecBuilder_ != null) {
        return annotationSpecBuilder_.getMessageOrBuilder();
      } else {
        return annotationSpec_ == null
            ? com.google.cloud.datalabeling.v1beta1.AnnotationSpec.getDefaultInstance()
            : annotationSpec_;
      }
    }
    /**
     *
     *
     * <pre>
     * Label of the object tracked in this annotation.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.AnnotationSpec annotation_spec = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.AnnotationSpec,
            com.google.cloud.datalabeling.v1beta1.AnnotationSpec.Builder,
            com.google.cloud.datalabeling.v1beta1.AnnotationSpecOrBuilder>
        getAnnotationSpecFieldBuilder() {
      if (annotationSpecBuilder_ == null) {
        annotationSpecBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datalabeling.v1beta1.AnnotationSpec,
                com.google.cloud.datalabeling.v1beta1.AnnotationSpec.Builder,
                com.google.cloud.datalabeling.v1beta1.AnnotationSpecOrBuilder>(
                getAnnotationSpec(), getParentForChildren(), isClean());
        annotationSpec_ = null;
      }
      return annotationSpecBuilder_;
    }

    private com.google.cloud.datalabeling.v1beta1.TimeSegment timeSegment_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.TimeSegment,
            com.google.cloud.datalabeling.v1beta1.TimeSegment.Builder,
            com.google.cloud.datalabeling.v1beta1.TimeSegmentOrBuilder>
        timeSegmentBuilder_;
    /**
     *
     *
     * <pre>
     * The time segment of the video to which object tracking applies.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.TimeSegment time_segment = 2;</code>
     *
     * @return Whether the timeSegment field is set.
     */
    public boolean hasTimeSegment() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * The time segment of the video to which object tracking applies.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.TimeSegment time_segment = 2;</code>
     *
     * @return The timeSegment.
     */
    public com.google.cloud.datalabeling.v1beta1.TimeSegment getTimeSegment() {
      if (timeSegmentBuilder_ == null) {
        return timeSegment_ == null
            ? com.google.cloud.datalabeling.v1beta1.TimeSegment.getDefaultInstance()
            : timeSegment_;
      } else {
        return timeSegmentBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The time segment of the video to which object tracking applies.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.TimeSegment time_segment = 2;</code>
     */
    public Builder setTimeSegment(com.google.cloud.datalabeling.v1beta1.TimeSegment value) {
      if (timeSegmentBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        timeSegment_ = value;
      } else {
        timeSegmentBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time segment of the video to which object tracking applies.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.TimeSegment time_segment = 2;</code>
     */
    public Builder setTimeSegment(
        com.google.cloud.datalabeling.v1beta1.TimeSegment.Builder builderForValue) {
      if (timeSegmentBuilder_ == null) {
        timeSegment_ = builderForValue.build();
      } else {
        timeSegmentBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time segment of the video to which object tracking applies.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.TimeSegment time_segment = 2;</code>
     */
    public Builder mergeTimeSegment(com.google.cloud.datalabeling.v1beta1.TimeSegment value) {
      if (timeSegmentBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && timeSegment_ != null
            && timeSegment_
                != com.google.cloud.datalabeling.v1beta1.TimeSegment.getDefaultInstance()) {
          getTimeSegmentBuilder().mergeFrom(value);
        } else {
          timeSegment_ = value;
        }
      } else {
        timeSegmentBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time segment of the video to which object tracking applies.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.TimeSegment time_segment = 2;</code>
     */
    public Builder clearTimeSegment() {
      bitField0_ = (bitField0_ & ~0x00000002);
      timeSegment_ = null;
      if (timeSegmentBuilder_ != null) {
        timeSegmentBuilder_.dispose();
        timeSegmentBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time segment of the video to which object tracking applies.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.TimeSegment time_segment = 2;</code>
     */
    public com.google.cloud.datalabeling.v1beta1.TimeSegment.Builder getTimeSegmentBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getTimeSegmentFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The time segment of the video to which object tracking applies.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.TimeSegment time_segment = 2;</code>
     */
    public com.google.cloud.datalabeling.v1beta1.TimeSegmentOrBuilder getTimeSegmentOrBuilder() {
      if (timeSegmentBuilder_ != null) {
        return timeSegmentBuilder_.getMessageOrBuilder();
      } else {
        return timeSegment_ == null
            ? com.google.cloud.datalabeling.v1beta1.TimeSegment.getDefaultInstance()
            : timeSegment_;
      }
    }
    /**
     *
     *
     * <pre>
     * The time segment of the video to which object tracking applies.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.TimeSegment time_segment = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.TimeSegment,
            com.google.cloud.datalabeling.v1beta1.TimeSegment.Builder,
            com.google.cloud.datalabeling.v1beta1.TimeSegmentOrBuilder>
        getTimeSegmentFieldBuilder() {
      if (timeSegmentBuilder_ == null) {
        timeSegmentBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datalabeling.v1beta1.TimeSegment,
                com.google.cloud.datalabeling.v1beta1.TimeSegment.Builder,
                com.google.cloud.datalabeling.v1beta1.TimeSegmentOrBuilder>(
                getTimeSegment(), getParentForChildren(), isClean());
        timeSegment_ = null;
      }
      return timeSegmentBuilder_;
    }

    private java.util.List<com.google.cloud.datalabeling.v1beta1.ObjectTrackingFrame>
        objectTrackingFrames_ = java.util.Collections.emptyList();

    private void ensureObjectTrackingFramesIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        objectTrackingFrames_ =
            new java.util.ArrayList<com.google.cloud.datalabeling.v1beta1.ObjectTrackingFrame>(
                objectTrackingFrames_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.ObjectTrackingFrame,
            com.google.cloud.datalabeling.v1beta1.ObjectTrackingFrame.Builder,
            com.google.cloud.datalabeling.v1beta1.ObjectTrackingFrameOrBuilder>
        objectTrackingFramesBuilder_;

    /**
     *
     *
     * <pre>
     * The list of frames where this object track appears.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datalabeling.v1beta1.ObjectTrackingFrame object_tracking_frames = 3;
     * </code>
     */
    public java.util.List<com.google.cloud.datalabeling.v1beta1.ObjectTrackingFrame>
        getObjectTrackingFramesList() {
      if (objectTrackingFramesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(objectTrackingFrames_);
      } else {
        return objectTrackingFramesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The list of frames where this object track appears.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datalabeling.v1beta1.ObjectTrackingFrame object_tracking_frames = 3;
     * </code>
     */
    public int getObjectTrackingFramesCount() {
      if (objectTrackingFramesBuilder_ == null) {
        return objectTrackingFrames_.size();
      } else {
        return objectTrackingFramesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The list of frames where this object track appears.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datalabeling.v1beta1.ObjectTrackingFrame object_tracking_frames = 3;
     * </code>
     */
    public com.google.cloud.datalabeling.v1beta1.ObjectTrackingFrame getObjectTrackingFrames(
        int index) {
      if (objectTrackingFramesBuilder_ == null) {
        return objectTrackingFrames_.get(index);
      } else {
        return objectTrackingFramesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The list of frames where this object track appears.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datalabeling.v1beta1.ObjectTrackingFrame object_tracking_frames = 3;
     * </code>
     */
    public Builder setObjectTrackingFrames(
        int index, com.google.cloud.datalabeling.v1beta1.ObjectTrackingFrame value) {
      if (objectTrackingFramesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureObjectTrackingFramesIsMutable();
        objectTrackingFrames_.set(index, value);
        onChanged();
      } else {
        objectTrackingFramesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of frames where this object track appears.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datalabeling.v1beta1.ObjectTrackingFrame object_tracking_frames = 3;
     * </code>
     */
    public Builder setObjectTrackingFrames(
        int index,
        com.google.cloud.datalabeling.v1beta1.ObjectTrackingFrame.Builder builderForValue) {
      if (objectTrackingFramesBuilder_ == null) {
        ensureObjectTrackingFramesIsMutable();
        objectTrackingFrames_.set(index, builderForValue.build());
        onChanged();
      } else {
        objectTrackingFramesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of frames where this object track appears.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datalabeling.v1beta1.ObjectTrackingFrame object_tracking_frames = 3;
     * </code>
     */
    public Builder addObjectTrackingFrames(
        com.google.cloud.datalabeling.v1beta1.ObjectTrackingFrame value) {
      if (objectTrackingFramesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureObjectTrackingFramesIsMutable();
        objectTrackingFrames_.add(value);
        onChanged();
      } else {
        objectTrackingFramesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of frames where this object track appears.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datalabeling.v1beta1.ObjectTrackingFrame object_tracking_frames = 3;
     * </code>
     */
    public Builder addObjectTrackingFrames(
        int index, com.google.cloud.datalabeling.v1beta1.ObjectTrackingFrame value) {
      if (objectTrackingFramesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureObjectTrackingFramesIsMutable();
        objectTrackingFrames_.add(index, value);
        onChanged();
      } else {
        objectTrackingFramesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of frames where this object track appears.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datalabeling.v1beta1.ObjectTrackingFrame object_tracking_frames = 3;
     * </code>
     */
    public Builder addObjectTrackingFrames(
        com.google.cloud.datalabeling.v1beta1.ObjectTrackingFrame.Builder builderForValue) {
      if (objectTrackingFramesBuilder_ == null) {
        ensureObjectTrackingFramesIsMutable();
        objectTrackingFrames_.add(builderForValue.build());
        onChanged();
      } else {
        objectTrackingFramesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of frames where this object track appears.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datalabeling.v1beta1.ObjectTrackingFrame object_tracking_frames = 3;
     * </code>
     */
    public Builder addObjectTrackingFrames(
        int index,
        com.google.cloud.datalabeling.v1beta1.ObjectTrackingFrame.Builder builderForValue) {
      if (objectTrackingFramesBuilder_ == null) {
        ensureObjectTrackingFramesIsMutable();
        objectTrackingFrames_.add(index, builderForValue.build());
        onChanged();
      } else {
        objectTrackingFramesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of frames where this object track appears.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datalabeling.v1beta1.ObjectTrackingFrame object_tracking_frames = 3;
     * </code>
     */
    public Builder addAllObjectTrackingFrames(
        java.lang.Iterable<? extends com.google.cloud.datalabeling.v1beta1.ObjectTrackingFrame>
            values) {
      if (objectTrackingFramesBuilder_ == null) {
        ensureObjectTrackingFramesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, objectTrackingFrames_);
        onChanged();
      } else {
        objectTrackingFramesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of frames where this object track appears.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datalabeling.v1beta1.ObjectTrackingFrame object_tracking_frames = 3;
     * </code>
     */
    public Builder clearObjectTrackingFrames() {
      if (objectTrackingFramesBuilder_ == null) {
        objectTrackingFrames_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        objectTrackingFramesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of frames where this object track appears.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datalabeling.v1beta1.ObjectTrackingFrame object_tracking_frames = 3;
     * </code>
     */
    public Builder removeObjectTrackingFrames(int index) {
      if (objectTrackingFramesBuilder_ == null) {
        ensureObjectTrackingFramesIsMutable();
        objectTrackingFrames_.remove(index);
        onChanged();
      } else {
        objectTrackingFramesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of frames where this object track appears.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datalabeling.v1beta1.ObjectTrackingFrame object_tracking_frames = 3;
     * </code>
     */
    public com.google.cloud.datalabeling.v1beta1.ObjectTrackingFrame.Builder
        getObjectTrackingFramesBuilder(int index) {
      return getObjectTrackingFramesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The list of frames where this object track appears.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datalabeling.v1beta1.ObjectTrackingFrame object_tracking_frames = 3;
     * </code>
     */
    public com.google.cloud.datalabeling.v1beta1.ObjectTrackingFrameOrBuilder
        getObjectTrackingFramesOrBuilder(int index) {
      if (objectTrackingFramesBuilder_ == null) {
        return objectTrackingFrames_.get(index);
      } else {
        return objectTrackingFramesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The list of frames where this object track appears.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datalabeling.v1beta1.ObjectTrackingFrame object_tracking_frames = 3;
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.datalabeling.v1beta1.ObjectTrackingFrameOrBuilder>
        getObjectTrackingFramesOrBuilderList() {
      if (objectTrackingFramesBuilder_ != null) {
        return objectTrackingFramesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(objectTrackingFrames_);
      }
    }
    /**
     *
     *
     * <pre>
     * The list of frames where this object track appears.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datalabeling.v1beta1.ObjectTrackingFrame object_tracking_frames = 3;
     * </code>
     */
    public com.google.cloud.datalabeling.v1beta1.ObjectTrackingFrame.Builder
        addObjectTrackingFramesBuilder() {
      return getObjectTrackingFramesFieldBuilder()
          .addBuilder(
              com.google.cloud.datalabeling.v1beta1.ObjectTrackingFrame.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The list of frames where this object track appears.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datalabeling.v1beta1.ObjectTrackingFrame object_tracking_frames = 3;
     * </code>
     */
    public com.google.cloud.datalabeling.v1beta1.ObjectTrackingFrame.Builder
        addObjectTrackingFramesBuilder(int index) {
      return getObjectTrackingFramesFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.datalabeling.v1beta1.ObjectTrackingFrame.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The list of frames where this object track appears.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datalabeling.v1beta1.ObjectTrackingFrame object_tracking_frames = 3;
     * </code>
     */
    public java.util.List<com.google.cloud.datalabeling.v1beta1.ObjectTrackingFrame.Builder>
        getObjectTrackingFramesBuilderList() {
      return getObjectTrackingFramesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.ObjectTrackingFrame,
            com.google.cloud.datalabeling.v1beta1.ObjectTrackingFrame.Builder,
            com.google.cloud.datalabeling.v1beta1.ObjectTrackingFrameOrBuilder>
        getObjectTrackingFramesFieldBuilder() {
      if (objectTrackingFramesBuilder_ == null) {
        objectTrackingFramesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.datalabeling.v1beta1.ObjectTrackingFrame,
                com.google.cloud.datalabeling.v1beta1.ObjectTrackingFrame.Builder,
                com.google.cloud.datalabeling.v1beta1.ObjectTrackingFrameOrBuilder>(
                objectTrackingFrames_,
                ((bitField0_ & 0x00000004) != 0),
                getParentForChildren(),
                isClean());
        objectTrackingFrames_ = null;
      }
      return objectTrackingFramesBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.datalabeling.v1beta1.VideoObjectTrackingAnnotation)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.datalabeling.v1beta1.VideoObjectTrackingAnnotation)
  private static final com.google.cloud.datalabeling.v1beta1.VideoObjectTrackingAnnotation
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.datalabeling.v1beta1.VideoObjectTrackingAnnotation();
  }

  public static com.google.cloud.datalabeling.v1beta1.VideoObjectTrackingAnnotation
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<VideoObjectTrackingAnnotation> PARSER =
      new com.google.protobuf.AbstractParser<VideoObjectTrackingAnnotation>() {
        @java.lang.Override
        public VideoObjectTrackingAnnotation parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<VideoObjectTrackingAnnotation> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<VideoObjectTrackingAnnotation> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.VideoObjectTrackingAnnotation
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
