/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datacatalog.lineage.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class LineageEventName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_PROCESS_RUN_LINEAGE_EVENT = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/processes/{process}/runs/{run}/lineageEvents/{lineage_event}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String process;
    private final String run;
    private final String lineageEvent;

    @Deprecated
    protected LineageEventName() {
        this.project = null;
        this.location = null;
        this.process = null;
        this.run = null;
        this.lineageEvent = null;
    }

    private LineageEventName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.process = (String)Preconditions.checkNotNull((Object)builder.getProcess());
        this.run = (String)Preconditions.checkNotNull((Object)builder.getRun());
        this.lineageEvent = (String)Preconditions.checkNotNull((Object)builder.getLineageEvent());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getProcess() {
        return this.process;
    }

    public String getRun() {
        return this.run;
    }

    public String getLineageEvent() {
        return this.lineageEvent;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static LineageEventName of(String project, String location, String process, String run, String lineageEvent) {
        return LineageEventName.newBuilder().setProject(project).setLocation(location).setProcess(process).setRun(run).setLineageEvent(lineageEvent).build();
    }

    public static String format(String project, String location, String process, String run, String lineageEvent) {
        return LineageEventName.newBuilder().setProject(project).setLocation(location).setProcess(process).setRun(run).setLineageEvent(lineageEvent).build().toString();
    }

    public static LineageEventName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_PROCESS_RUN_LINEAGE_EVENT.validatedMatch(formattedString, "LineageEventName.parse: formattedString not in valid format");
        return LineageEventName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("process"), (String)matchMap.get("run"), (String)matchMap.get("lineage_event"));
    }

    public static List<LineageEventName> parseList(List<String> formattedStrings) {
        ArrayList<LineageEventName> list = new ArrayList<LineageEventName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(LineageEventName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<LineageEventName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (LineageEventName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_PROCESS_RUN_LINEAGE_EVENT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            LineageEventName lineageEventName = this;
            synchronized (lineageEventName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.process != null) {
                        fieldMapBuilder.put((Object)"process", (Object)this.process);
                    }
                    if (this.run != null) {
                        fieldMapBuilder.put((Object)"run", (Object)this.run);
                    }
                    if (this.lineageEvent != null) {
                        fieldMapBuilder.put((Object)"lineage_event", (Object)this.lineageEvent);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_PROCESS_RUN_LINEAGE_EVENT.instantiate(new String[]{"project", this.project, "location", this.location, "process", this.process, "run", this.run, "lineage_event", this.lineageEvent});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            LineageEventName that = (LineageEventName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.process, that.process) && Objects.equals(this.run, that.run) && Objects.equals(this.lineageEvent, that.lineageEvent);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.process);
        h *= 1000003;
        h ^= Objects.hashCode(this.run);
        h *= 1000003;
        return h ^= Objects.hashCode(this.lineageEvent);
    }

    public static class Builder {
        private String project;
        private String location;
        private String process;
        private String run;
        private String lineageEvent;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getProcess() {
            return this.process;
        }

        public String getRun() {
            return this.run;
        }

        public String getLineageEvent() {
            return this.lineageEvent;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setProcess(String process) {
            this.process = process;
            return this;
        }

        public Builder setRun(String run) {
            this.run = run;
            return this;
        }

        public Builder setLineageEvent(String lineageEvent) {
            this.lineageEvent = lineageEvent;
            return this;
        }

        private Builder(LineageEventName lineageEventName) {
            this.project = lineageEventName.project;
            this.location = lineageEventName.location;
            this.process = lineageEventName.process;
            this.run = lineageEventName.run;
            this.lineageEvent = lineageEventName.lineageEvent;
        }

        public LineageEventName build() {
            return new LineageEventName(this);
        }
    }
}

