/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/datacatalog/lineage/v1/lineage.proto

package com.google.cloud.datacatalog.lineage.v1;

/**
 *
 *
 * <pre>
 * A lineage event represents an operation on assets. Within the operation, the
 * data flows from the source to the target defined in the links field.
 * </pre>
 *
 * Protobuf type {@code google.cloud.datacatalog.lineage.v1.LineageEvent}
 */
public final class LineageEvent extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.datacatalog.lineage.v1.LineageEvent)
    LineageEventOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use LineageEvent.newBuilder() to construct.
  private LineageEvent(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private LineageEvent() {
    name_ = "";
    links_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new LineageEvent();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.datacatalog.lineage.v1.LineageProto
        .internal_static_google_cloud_datacatalog_lineage_v1_LineageEvent_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.datacatalog.lineage.v1.LineageProto
        .internal_static_google_cloud_datacatalog_lineage_v1_LineageEvent_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.datacatalog.lineage.v1.LineageEvent.class,
            com.google.cloud.datacatalog.lineage.v1.LineageEvent.Builder.class);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Immutable. The resource name of the lineage event.
   * Format:
   * `projects/{project}/locations/{location}/processes/{process}/runs/{run}/lineageEvents/{lineage_event}`.
   * Can be specified or auto-assigned.
   * {lineage_event} must be not longer than 200 characters and only
   * contain characters in a set: `a-zA-Z0-9_-:.`
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Immutable. The resource name of the lineage event.
   * Format:
   * `projects/{project}/locations/{location}/processes/{process}/runs/{run}/lineageEvents/{lineage_event}`.
   * Can be specified or auto-assigned.
   * {lineage_event} must be not longer than 200 characters and only
   * contain characters in a set: `a-zA-Z0-9_-:.`
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LINKS_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.datacatalog.lineage.v1.EventLink> links_;
  /**
   *
   *
   * <pre>
   * Optional. List of source-target pairs. Can't contain more than 100 tuples.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.datacatalog.lineage.v1.EventLink links = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.datacatalog.lineage.v1.EventLink> getLinksList() {
    return links_;
  }
  /**
   *
   *
   * <pre>
   * Optional. List of source-target pairs. Can't contain more than 100 tuples.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.datacatalog.lineage.v1.EventLink links = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.datacatalog.lineage.v1.EventLinkOrBuilder>
      getLinksOrBuilderList() {
    return links_;
  }
  /**
   *
   *
   * <pre>
   * Optional. List of source-target pairs. Can't contain more than 100 tuples.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.datacatalog.lineage.v1.EventLink links = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public int getLinksCount() {
    return links_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. List of source-target pairs. Can't contain more than 100 tuples.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.datacatalog.lineage.v1.EventLink links = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.datacatalog.lineage.v1.EventLink getLinks(int index) {
    return links_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. List of source-target pairs. Can't contain more than 100 tuples.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.datacatalog.lineage.v1.EventLink links = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.datacatalog.lineage.v1.EventLinkOrBuilder getLinksOrBuilder(int index) {
    return links_.get(index);
  }

  public static final int START_TIME_FIELD_NUMBER = 6;
  private com.google.protobuf.Timestamp startTime_;
  /**
   *
   *
   * <pre>
   * Required. The beginning of the transformation which resulted in this
   * lineage event. For streaming scenarios, it should be the beginning of the
   * period from which the lineage is being reported.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 6 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the startTime field is set.
   */
  @java.lang.Override
  public boolean hasStartTime() {
    return startTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Required. The beginning of the transformation which resulted in this
   * lineage event. For streaming scenarios, it should be the beginning of the
   * period from which the lineage is being reported.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 6 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The startTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getStartTime() {
    return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
  }
  /**
   *
   *
   * <pre>
   * Required. The beginning of the transformation which resulted in this
   * lineage event. For streaming scenarios, it should be the beginning of the
   * period from which the lineage is being reported.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 6 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
    return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
  }

  public static final int END_TIME_FIELD_NUMBER = 7;
  private com.google.protobuf.Timestamp endTime_;
  /**
   *
   *
   * <pre>
   * Optional. The end of the transformation which resulted in this lineage
   * event.  For streaming scenarios, it should be the end of the period from
   * which the lineage is being reported.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return Whether the endTime field is set.
   */
  @java.lang.Override
  public boolean hasEndTime() {
    return endTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Optional. The end of the transformation which resulted in this lineage
   * event.  For streaming scenarios, it should be the end of the period from
   * which the lineage is being reported.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The endTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getEndTime() {
    return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The end of the transformation which resulted in this lineage
   * event.  For streaming scenarios, it should be the end of the period from
   * which the lineage is being reported.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
    return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (startTime_ != null) {
      output.writeMessage(6, getStartTime());
    }
    if (endTime_ != null) {
      output.writeMessage(7, getEndTime());
    }
    for (int i = 0; i < links_.size(); i++) {
      output.writeMessage(8, links_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (startTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getStartTime());
    }
    if (endTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getEndTime());
    }
    for (int i = 0; i < links_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, links_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.datacatalog.lineage.v1.LineageEvent)) {
      return super.equals(obj);
    }
    com.google.cloud.datacatalog.lineage.v1.LineageEvent other =
        (com.google.cloud.datacatalog.lineage.v1.LineageEvent) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getLinksList().equals(other.getLinksList())) return false;
    if (hasStartTime() != other.hasStartTime()) return false;
    if (hasStartTime()) {
      if (!getStartTime().equals(other.getStartTime())) return false;
    }
    if (hasEndTime() != other.hasEndTime()) return false;
    if (hasEndTime()) {
      if (!getEndTime().equals(other.getEndTime())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (getLinksCount() > 0) {
      hash = (37 * hash) + LINKS_FIELD_NUMBER;
      hash = (53 * hash) + getLinksList().hashCode();
    }
    if (hasStartTime()) {
      hash = (37 * hash) + START_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getStartTime().hashCode();
    }
    if (hasEndTime()) {
      hash = (37 * hash) + END_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getEndTime().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.datacatalog.lineage.v1.LineageEvent parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datacatalog.lineage.v1.LineageEvent parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.lineage.v1.LineageEvent parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datacatalog.lineage.v1.LineageEvent parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.lineage.v1.LineageEvent parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datacatalog.lineage.v1.LineageEvent parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.lineage.v1.LineageEvent parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datacatalog.lineage.v1.LineageEvent parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.lineage.v1.LineageEvent parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.datacatalog.lineage.v1.LineageEvent parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.lineage.v1.LineageEvent parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datacatalog.lineage.v1.LineageEvent parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.datacatalog.lineage.v1.LineageEvent prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A lineage event represents an operation on assets. Within the operation, the
   * data flows from the source to the target defined in the links field.
   * </pre>
   *
   * Protobuf type {@code google.cloud.datacatalog.lineage.v1.LineageEvent}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.datacatalog.lineage.v1.LineageEvent)
      com.google.cloud.datacatalog.lineage.v1.LineageEventOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.datacatalog.lineage.v1.LineageProto
          .internal_static_google_cloud_datacatalog_lineage_v1_LineageEvent_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.datacatalog.lineage.v1.LineageProto
          .internal_static_google_cloud_datacatalog_lineage_v1_LineageEvent_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.datacatalog.lineage.v1.LineageEvent.class,
              com.google.cloud.datacatalog.lineage.v1.LineageEvent.Builder.class);
    }

    // Construct using com.google.cloud.datacatalog.lineage.v1.LineageEvent.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      if (linksBuilder_ == null) {
        links_ = java.util.Collections.emptyList();
      } else {
        links_ = null;
        linksBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      startTime_ = null;
      if (startTimeBuilder_ != null) {
        startTimeBuilder_.dispose();
        startTimeBuilder_ = null;
      }
      endTime_ = null;
      if (endTimeBuilder_ != null) {
        endTimeBuilder_.dispose();
        endTimeBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.datacatalog.lineage.v1.LineageProto
          .internal_static_google_cloud_datacatalog_lineage_v1_LineageEvent_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.datacatalog.lineage.v1.LineageEvent getDefaultInstanceForType() {
      return com.google.cloud.datacatalog.lineage.v1.LineageEvent.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.datacatalog.lineage.v1.LineageEvent build() {
      com.google.cloud.datacatalog.lineage.v1.LineageEvent result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.datacatalog.lineage.v1.LineageEvent buildPartial() {
      com.google.cloud.datacatalog.lineage.v1.LineageEvent result =
          new com.google.cloud.datacatalog.lineage.v1.LineageEvent(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.datacatalog.lineage.v1.LineageEvent result) {
      if (linksBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          links_ = java.util.Collections.unmodifiableList(links_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.links_ = links_;
      } else {
        result.links_ = linksBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.datacatalog.lineage.v1.LineageEvent result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.startTime_ = startTimeBuilder_ == null ? startTime_ : startTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.endTime_ = endTimeBuilder_ == null ? endTime_ : endTimeBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.datacatalog.lineage.v1.LineageEvent) {
        return mergeFrom((com.google.cloud.datacatalog.lineage.v1.LineageEvent) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.datacatalog.lineage.v1.LineageEvent other) {
      if (other == com.google.cloud.datacatalog.lineage.v1.LineageEvent.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (linksBuilder_ == null) {
        if (!other.links_.isEmpty()) {
          if (links_.isEmpty()) {
            links_ = other.links_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureLinksIsMutable();
            links_.addAll(other.links_);
          }
          onChanged();
        }
      } else {
        if (!other.links_.isEmpty()) {
          if (linksBuilder_.isEmpty()) {
            linksBuilder_.dispose();
            linksBuilder_ = null;
            links_ = other.links_;
            bitField0_ = (bitField0_ & ~0x00000002);
            linksBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getLinksFieldBuilder()
                    : null;
          } else {
            linksBuilder_.addAllMessages(other.links_);
          }
        }
      }
      if (other.hasStartTime()) {
        mergeStartTime(other.getStartTime());
      }
      if (other.hasEndTime()) {
        mergeEndTime(other.getEndTime());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 50:
              {
                input.readMessage(getStartTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getEndTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 58
            case 66:
              {
                com.google.cloud.datacatalog.lineage.v1.EventLink m =
                    input.readMessage(
                        com.google.cloud.datacatalog.lineage.v1.EventLink.parser(),
                        extensionRegistry);
                if (linksBuilder_ == null) {
                  ensureLinksIsMutable();
                  links_.add(m);
                } else {
                  linksBuilder_.addMessage(m);
                }
                break;
              } // case 66
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Immutable. The resource name of the lineage event.
     * Format:
     * `projects/{project}/locations/{location}/processes/{process}/runs/{run}/lineageEvents/{lineage_event}`.
     * Can be specified or auto-assigned.
     * {lineage_event} must be not longer than 200 characters and only
     * contain characters in a set: `a-zA-Z0-9_-:.`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. The resource name of the lineage event.
     * Format:
     * `projects/{project}/locations/{location}/processes/{process}/runs/{run}/lineageEvents/{lineage_event}`.
     * Can be specified or auto-assigned.
     * {lineage_event} must be not longer than 200 characters and only
     * contain characters in a set: `a-zA-Z0-9_-:.`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. The resource name of the lineage event.
     * Format:
     * `projects/{project}/locations/{location}/processes/{process}/runs/{run}/lineageEvents/{lineage_event}`.
     * Can be specified or auto-assigned.
     * {lineage_event} must be not longer than 200 characters and only
     * contain characters in a set: `a-zA-Z0-9_-:.`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The resource name of the lineage event.
     * Format:
     * `projects/{project}/locations/{location}/processes/{process}/runs/{run}/lineageEvents/{lineage_event}`.
     * Can be specified or auto-assigned.
     * {lineage_event} must be not longer than 200 characters and only
     * contain characters in a set: `a-zA-Z0-9_-:.`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The resource name of the lineage event.
     * Format:
     * `projects/{project}/locations/{location}/processes/{process}/runs/{run}/lineageEvents/{lineage_event}`.
     * Can be specified or auto-assigned.
     * {lineage_event} must be not longer than 200 characters and only
     * contain characters in a set: `a-zA-Z0-9_-:.`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.datacatalog.lineage.v1.EventLink> links_ =
        java.util.Collections.emptyList();

    private void ensureLinksIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        links_ = new java.util.ArrayList<com.google.cloud.datacatalog.lineage.v1.EventLink>(links_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.datacatalog.lineage.v1.EventLink,
            com.google.cloud.datacatalog.lineage.v1.EventLink.Builder,
            com.google.cloud.datacatalog.lineage.v1.EventLinkOrBuilder>
        linksBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. List of source-target pairs. Can't contain more than 100 tuples.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datacatalog.lineage.v1.EventLink links = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.datacatalog.lineage.v1.EventLink> getLinksList() {
      if (linksBuilder_ == null) {
        return java.util.Collections.unmodifiableList(links_);
      } else {
        return linksBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. List of source-target pairs. Can't contain more than 100 tuples.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datacatalog.lineage.v1.EventLink links = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public int getLinksCount() {
      if (linksBuilder_ == null) {
        return links_.size();
      } else {
        return linksBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. List of source-target pairs. Can't contain more than 100 tuples.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datacatalog.lineage.v1.EventLink links = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.datacatalog.lineage.v1.EventLink getLinks(int index) {
      if (linksBuilder_ == null) {
        return links_.get(index);
      } else {
        return linksBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. List of source-target pairs. Can't contain more than 100 tuples.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datacatalog.lineage.v1.EventLink links = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setLinks(int index, com.google.cloud.datacatalog.lineage.v1.EventLink value) {
      if (linksBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLinksIsMutable();
        links_.set(index, value);
        onChanged();
      } else {
        linksBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of source-target pairs. Can't contain more than 100 tuples.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datacatalog.lineage.v1.EventLink links = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setLinks(
        int index, com.google.cloud.datacatalog.lineage.v1.EventLink.Builder builderForValue) {
      if (linksBuilder_ == null) {
        ensureLinksIsMutable();
        links_.set(index, builderForValue.build());
        onChanged();
      } else {
        linksBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of source-target pairs. Can't contain more than 100 tuples.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datacatalog.lineage.v1.EventLink links = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addLinks(com.google.cloud.datacatalog.lineage.v1.EventLink value) {
      if (linksBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLinksIsMutable();
        links_.add(value);
        onChanged();
      } else {
        linksBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of source-target pairs. Can't contain more than 100 tuples.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datacatalog.lineage.v1.EventLink links = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addLinks(int index, com.google.cloud.datacatalog.lineage.v1.EventLink value) {
      if (linksBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLinksIsMutable();
        links_.add(index, value);
        onChanged();
      } else {
        linksBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of source-target pairs. Can't contain more than 100 tuples.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datacatalog.lineage.v1.EventLink links = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addLinks(
        com.google.cloud.datacatalog.lineage.v1.EventLink.Builder builderForValue) {
      if (linksBuilder_ == null) {
        ensureLinksIsMutable();
        links_.add(builderForValue.build());
        onChanged();
      } else {
        linksBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of source-target pairs. Can't contain more than 100 tuples.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datacatalog.lineage.v1.EventLink links = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addLinks(
        int index, com.google.cloud.datacatalog.lineage.v1.EventLink.Builder builderForValue) {
      if (linksBuilder_ == null) {
        ensureLinksIsMutable();
        links_.add(index, builderForValue.build());
        onChanged();
      } else {
        linksBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of source-target pairs. Can't contain more than 100 tuples.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datacatalog.lineage.v1.EventLink links = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAllLinks(
        java.lang.Iterable<? extends com.google.cloud.datacatalog.lineage.v1.EventLink> values) {
      if (linksBuilder_ == null) {
        ensureLinksIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, links_);
        onChanged();
      } else {
        linksBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of source-target pairs. Can't contain more than 100 tuples.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datacatalog.lineage.v1.EventLink links = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearLinks() {
      if (linksBuilder_ == null) {
        links_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        linksBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of source-target pairs. Can't contain more than 100 tuples.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datacatalog.lineage.v1.EventLink links = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeLinks(int index) {
      if (linksBuilder_ == null) {
        ensureLinksIsMutable();
        links_.remove(index);
        onChanged();
      } else {
        linksBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of source-target pairs. Can't contain more than 100 tuples.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datacatalog.lineage.v1.EventLink links = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.datacatalog.lineage.v1.EventLink.Builder getLinksBuilder(int index) {
      return getLinksFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. List of source-target pairs. Can't contain more than 100 tuples.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datacatalog.lineage.v1.EventLink links = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.datacatalog.lineage.v1.EventLinkOrBuilder getLinksOrBuilder(int index) {
      if (linksBuilder_ == null) {
        return links_.get(index);
      } else {
        return linksBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. List of source-target pairs. Can't contain more than 100 tuples.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datacatalog.lineage.v1.EventLink links = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.datacatalog.lineage.v1.EventLinkOrBuilder>
        getLinksOrBuilderList() {
      if (linksBuilder_ != null) {
        return linksBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(links_);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. List of source-target pairs. Can't contain more than 100 tuples.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datacatalog.lineage.v1.EventLink links = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.datacatalog.lineage.v1.EventLink.Builder addLinksBuilder() {
      return getLinksFieldBuilder()
          .addBuilder(com.google.cloud.datacatalog.lineage.v1.EventLink.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. List of source-target pairs. Can't contain more than 100 tuples.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datacatalog.lineage.v1.EventLink links = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.datacatalog.lineage.v1.EventLink.Builder addLinksBuilder(int index) {
      return getLinksFieldBuilder()
          .addBuilder(
              index, com.google.cloud.datacatalog.lineage.v1.EventLink.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. List of source-target pairs. Can't contain more than 100 tuples.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datacatalog.lineage.v1.EventLink links = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.datacatalog.lineage.v1.EventLink.Builder>
        getLinksBuilderList() {
      return getLinksFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.datacatalog.lineage.v1.EventLink,
            com.google.cloud.datacatalog.lineage.v1.EventLink.Builder,
            com.google.cloud.datacatalog.lineage.v1.EventLinkOrBuilder>
        getLinksFieldBuilder() {
      if (linksBuilder_ == null) {
        linksBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.datacatalog.lineage.v1.EventLink,
                com.google.cloud.datacatalog.lineage.v1.EventLink.Builder,
                com.google.cloud.datacatalog.lineage.v1.EventLinkOrBuilder>(
                links_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
        links_ = null;
      }
      return linksBuilder_;
    }

    private com.google.protobuf.Timestamp startTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        startTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Required. The beginning of the transformation which resulted in this
     * lineage event. For streaming scenarios, it should be the beginning of the
     * period from which the lineage is being reported.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the startTime field is set.
     */
    public boolean hasStartTime() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. The beginning of the transformation which resulted in this
     * lineage event. For streaming scenarios, it should be the beginning of the
     * period from which the lineage is being reported.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The startTime.
     */
    public com.google.protobuf.Timestamp getStartTime() {
      if (startTimeBuilder_ == null) {
        return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
      } else {
        return startTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The beginning of the transformation which resulted in this
     * lineage event. For streaming scenarios, it should be the beginning of the
     * period from which the lineage is being reported.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setStartTime(com.google.protobuf.Timestamp value) {
      if (startTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        startTime_ = value;
      } else {
        startTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The beginning of the transformation which resulted in this
     * lineage event. For streaming scenarios, it should be the beginning of the
     * period from which the lineage is being reported.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setStartTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (startTimeBuilder_ == null) {
        startTime_ = builderForValue.build();
      } else {
        startTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The beginning of the transformation which resulted in this
     * lineage event. For streaming scenarios, it should be the beginning of the
     * period from which the lineage is being reported.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeStartTime(com.google.protobuf.Timestamp value) {
      if (startTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && startTime_ != null
            && startTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getStartTimeBuilder().mergeFrom(value);
        } else {
          startTime_ = value;
        }
      } else {
        startTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The beginning of the transformation which resulted in this
     * lineage event. For streaming scenarios, it should be the beginning of the
     * period from which the lineage is being reported.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearStartTime() {
      bitField0_ = (bitField0_ & ~0x00000004);
      startTime_ = null;
      if (startTimeBuilder_ != null) {
        startTimeBuilder_.dispose();
        startTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The beginning of the transformation which resulted in this
     * lineage event. For streaming scenarios, it should be the beginning of the
     * period from which the lineage is being reported.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getStartTimeBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getStartTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. The beginning of the transformation which resulted in this
     * lineage event. For streaming scenarios, it should be the beginning of the
     * period from which the lineage is being reported.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
      if (startTimeBuilder_ != null) {
        return startTimeBuilder_.getMessageOrBuilder();
      } else {
        return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The beginning of the transformation which resulted in this
     * lineage event. For streaming scenarios, it should be the beginning of the
     * period from which the lineage is being reported.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getStartTimeFieldBuilder() {
      if (startTimeBuilder_ == null) {
        startTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getStartTime(), getParentForChildren(), isClean());
        startTime_ = null;
      }
      return startTimeBuilder_;
    }

    private com.google.protobuf.Timestamp endTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        endTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. The end of the transformation which resulted in this lineage
     * event.  For streaming scenarios, it should be the end of the period from
     * which the lineage is being reported.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the endTime field is set.
     */
    public boolean hasEndTime() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. The end of the transformation which resulted in this lineage
     * event.  For streaming scenarios, it should be the end of the period from
     * which the lineage is being reported.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The endTime.
     */
    public com.google.protobuf.Timestamp getEndTime() {
      if (endTimeBuilder_ == null) {
        return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
      } else {
        return endTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The end of the transformation which resulted in this lineage
     * event.  For streaming scenarios, it should be the end of the period from
     * which the lineage is being reported.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setEndTime(com.google.protobuf.Timestamp value) {
      if (endTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        endTime_ = value;
      } else {
        endTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The end of the transformation which resulted in this lineage
     * event.  For streaming scenarios, it should be the end of the period from
     * which the lineage is being reported.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setEndTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (endTimeBuilder_ == null) {
        endTime_ = builderForValue.build();
      } else {
        endTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The end of the transformation which resulted in this lineage
     * event.  For streaming scenarios, it should be the end of the period from
     * which the lineage is being reported.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeEndTime(com.google.protobuf.Timestamp value) {
      if (endTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && endTime_ != null
            && endTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getEndTimeBuilder().mergeFrom(value);
        } else {
          endTime_ = value;
        }
      } else {
        endTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The end of the transformation which resulted in this lineage
     * event.  For streaming scenarios, it should be the end of the period from
     * which the lineage is being reported.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearEndTime() {
      bitField0_ = (bitField0_ & ~0x00000008);
      endTime_ = null;
      if (endTimeBuilder_ != null) {
        endTimeBuilder_.dispose();
        endTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The end of the transformation which resulted in this lineage
     * event.  For streaming scenarios, it should be the end of the period from
     * which the lineage is being reported.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getEndTimeBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getEndTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. The end of the transformation which resulted in this lineage
     * event.  For streaming scenarios, it should be the end of the period from
     * which the lineage is being reported.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
      if (endTimeBuilder_ != null) {
        return endTimeBuilder_.getMessageOrBuilder();
      } else {
        return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The end of the transformation which resulted in this lineage
     * event.  For streaming scenarios, it should be the end of the period from
     * which the lineage is being reported.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getEndTimeFieldBuilder() {
      if (endTimeBuilder_ == null) {
        endTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getEndTime(), getParentForChildren(), isClean());
        endTime_ = null;
      }
      return endTimeBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.datacatalog.lineage.v1.LineageEvent)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.datacatalog.lineage.v1.LineageEvent)
  private static final com.google.cloud.datacatalog.lineage.v1.LineageEvent DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.datacatalog.lineage.v1.LineageEvent();
  }

  public static com.google.cloud.datacatalog.lineage.v1.LineageEvent getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<LineageEvent> PARSER =
      new com.google.protobuf.AbstractParser<LineageEvent>() {
        @java.lang.Override
        public LineageEvent parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<LineageEvent> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<LineageEvent> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.datacatalog.lineage.v1.LineageEvent getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
