/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/datacatalog/lineage/v1/lineage.proto

package com.google.cloud.datacatalog.lineage.v1;

/**
 *
 *
 * <pre>
 * A process is the definition of a data transformation operation.
 * </pre>
 *
 * Protobuf type {@code google.cloud.datacatalog.lineage.v1.Process}
 */
public final class Process extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.datacatalog.lineage.v1.Process)
    ProcessOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Process.newBuilder() to construct.
  private Process(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Process() {
    name_ = "";
    displayName_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Process();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.datacatalog.lineage.v1.LineageProto
        .internal_static_google_cloud_datacatalog_lineage_v1_Process_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 3:
        return internalGetAttributes();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.datacatalog.lineage.v1.LineageProto
        .internal_static_google_cloud_datacatalog_lineage_v1_Process_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.datacatalog.lineage.v1.Process.class,
            com.google.cloud.datacatalog.lineage.v1.Process.Builder.class);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Immutable. The resource name of the lineage process. Format:
   * `projects/{project}/locations/{location}/processes/{process}`.
   * Can be specified or auto-assigned.
   * {process} must be not longer than 200 characters and only
   * contain characters in a set: `a-zA-Z0-9_-:.`
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Immutable. The resource name of the lineage process. Format:
   * `projects/{project}/locations/{location}/processes/{process}`.
   * Can be specified or auto-assigned.
   * {process} must be not longer than 200 characters and only
   * contain characters in a set: `a-zA-Z0-9_-:.`
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";
  /**
   *
   *
   * <pre>
   * Optional. A human-readable name you can set to display in a user interface.
   * Must be not longer than 200 characters and only contain UTF-8 letters
   * or numbers, spaces or characters like `_-:&amp;.`
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. A human-readable name you can set to display in a user interface.
   * Must be not longer than 200 characters and only contain UTF-8 letters
   * or numbers, spaces or characters like `_-:&amp;.`
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ATTRIBUTES_FIELD_NUMBER = 3;

  private static final class AttributesDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, com.google.protobuf.Value>
        defaultEntry =
            com.google.protobuf.MapEntry
                .<java.lang.String, com.google.protobuf.Value>newDefaultInstance(
                    com.google.cloud.datacatalog.lineage.v1.LineageProto
                        .internal_static_google_cloud_datacatalog_lineage_v1_Process_AttributesEntry_descriptor,
                    com.google.protobuf.WireFormat.FieldType.STRING,
                    "",
                    com.google.protobuf.WireFormat.FieldType.MESSAGE,
                    com.google.protobuf.Value.getDefaultInstance());
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, com.google.protobuf.Value> attributes_;

  private com.google.protobuf.MapField<java.lang.String, com.google.protobuf.Value>
      internalGetAttributes() {
    if (attributes_ == null) {
      return com.google.protobuf.MapField.emptyMapField(AttributesDefaultEntryHolder.defaultEntry);
    }
    return attributes_;
  }

  public int getAttributesCount() {
    return internalGetAttributes().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Optional. The attributes of the process. Should only be used for the
   * purpose of non-semantic management (classifying, describing or labeling the
   * process).
   *
   * Up to 100 attributes are allowed.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.protobuf.Value&gt; attributes = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public boolean containsAttributes(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetAttributes().getMap().containsKey(key);
  }
  /** Use {@link #getAttributesMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, com.google.protobuf.Value> getAttributes() {
    return getAttributesMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. The attributes of the process. Should only be used for the
   * purpose of non-semantic management (classifying, describing or labeling the
   * process).
   *
   * Up to 100 attributes are allowed.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.protobuf.Value&gt; attributes = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, com.google.protobuf.Value> getAttributesMap() {
    return internalGetAttributes().getMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. The attributes of the process. Should only be used for the
   * purpose of non-semantic management (classifying, describing or labeling the
   * process).
   *
   * Up to 100 attributes are allowed.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.protobuf.Value&gt; attributes = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public /* nullable */ com.google.protobuf.Value getAttributesOrDefault(
      java.lang.String key,
      /* nullable */
      com.google.protobuf.Value defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.protobuf.Value> map =
        internalGetAttributes().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Optional. The attributes of the process. Should only be used for the
   * purpose of non-semantic management (classifying, describing or labeling the
   * process).
   *
   * Up to 100 attributes are allowed.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.protobuf.Value&gt; attributes = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.Value getAttributesOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.protobuf.Value> map =
        internalGetAttributes().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int ORIGIN_FIELD_NUMBER = 4;
  private com.google.cloud.datacatalog.lineage.v1.Origin origin_;
  /**
   *
   *
   * <pre>
   * Optional. The origin of this process and its runs and lineage events.
   * </pre>
   *
   * <code>
   * .google.cloud.datacatalog.lineage.v1.Origin origin = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the origin field is set.
   */
  @java.lang.Override
  public boolean hasOrigin() {
    return origin_ != null;
  }
  /**
   *
   *
   * <pre>
   * Optional. The origin of this process and its runs and lineage events.
   * </pre>
   *
   * <code>
   * .google.cloud.datacatalog.lineage.v1.Origin origin = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The origin.
   */
  @java.lang.Override
  public com.google.cloud.datacatalog.lineage.v1.Origin getOrigin() {
    return origin_ == null
        ? com.google.cloud.datacatalog.lineage.v1.Origin.getDefaultInstance()
        : origin_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The origin of this process and its runs and lineage events.
   * </pre>
   *
   * <code>
   * .google.cloud.datacatalog.lineage.v1.Origin origin = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.datacatalog.lineage.v1.OriginOrBuilder getOriginOrBuilder() {
    return origin_ == null
        ? com.google.cloud.datacatalog.lineage.v1.Origin.getDefaultInstance()
        : origin_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, displayName_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetAttributes(), AttributesDefaultEntryHolder.defaultEntry, 3);
    if (origin_ != null) {
      output.writeMessage(4, getOrigin());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, displayName_);
    }
    for (java.util.Map.Entry<java.lang.String, com.google.protobuf.Value> entry :
        internalGetAttributes().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, com.google.protobuf.Value> attributes__ =
          AttributesDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, attributes__);
    }
    if (origin_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getOrigin());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.datacatalog.lineage.v1.Process)) {
      return super.equals(obj);
    }
    com.google.cloud.datacatalog.lineage.v1.Process other =
        (com.google.cloud.datacatalog.lineage.v1.Process) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (!internalGetAttributes().equals(other.internalGetAttributes())) return false;
    if (hasOrigin() != other.hasOrigin()) return false;
    if (hasOrigin()) {
      if (!getOrigin().equals(other.getOrigin())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    if (!internalGetAttributes().getMap().isEmpty()) {
      hash = (37 * hash) + ATTRIBUTES_FIELD_NUMBER;
      hash = (53 * hash) + internalGetAttributes().hashCode();
    }
    if (hasOrigin()) {
      hash = (37 * hash) + ORIGIN_FIELD_NUMBER;
      hash = (53 * hash) + getOrigin().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.datacatalog.lineage.v1.Process parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datacatalog.lineage.v1.Process parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.lineage.v1.Process parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datacatalog.lineage.v1.Process parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.lineage.v1.Process parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datacatalog.lineage.v1.Process parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.lineage.v1.Process parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datacatalog.lineage.v1.Process parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.lineage.v1.Process parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.datacatalog.lineage.v1.Process parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.lineage.v1.Process parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datacatalog.lineage.v1.Process parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.datacatalog.lineage.v1.Process prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A process is the definition of a data transformation operation.
   * </pre>
   *
   * Protobuf type {@code google.cloud.datacatalog.lineage.v1.Process}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.datacatalog.lineage.v1.Process)
      com.google.cloud.datacatalog.lineage.v1.ProcessOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.datacatalog.lineage.v1.LineageProto
          .internal_static_google_cloud_datacatalog_lineage_v1_Process_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 3:
          return internalGetAttributes();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 3:
          return internalGetMutableAttributes();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.datacatalog.lineage.v1.LineageProto
          .internal_static_google_cloud_datacatalog_lineage_v1_Process_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.datacatalog.lineage.v1.Process.class,
              com.google.cloud.datacatalog.lineage.v1.Process.Builder.class);
    }

    // Construct using com.google.cloud.datacatalog.lineage.v1.Process.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      displayName_ = "";
      internalGetMutableAttributes().clear();
      origin_ = null;
      if (originBuilder_ != null) {
        originBuilder_.dispose();
        originBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.datacatalog.lineage.v1.LineageProto
          .internal_static_google_cloud_datacatalog_lineage_v1_Process_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.datacatalog.lineage.v1.Process getDefaultInstanceForType() {
      return com.google.cloud.datacatalog.lineage.v1.Process.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.datacatalog.lineage.v1.Process build() {
      com.google.cloud.datacatalog.lineage.v1.Process result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.datacatalog.lineage.v1.Process buildPartial() {
      com.google.cloud.datacatalog.lineage.v1.Process result =
          new com.google.cloud.datacatalog.lineage.v1.Process(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.datacatalog.lineage.v1.Process result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.displayName_ = displayName_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.attributes_ = internalGetAttributes();
        result.attributes_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.origin_ = originBuilder_ == null ? origin_ : originBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.datacatalog.lineage.v1.Process) {
        return mergeFrom((com.google.cloud.datacatalog.lineage.v1.Process) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.datacatalog.lineage.v1.Process other) {
      if (other == com.google.cloud.datacatalog.lineage.v1.Process.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      internalGetMutableAttributes().mergeFrom(other.internalGetAttributes());
      bitField0_ |= 0x00000004;
      if (other.hasOrigin()) {
        mergeOrigin(other.getOrigin());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                com.google.protobuf.MapEntry<java.lang.String, com.google.protobuf.Value>
                    attributes__ =
                        input.readMessage(
                            AttributesDefaultEntryHolder.defaultEntry.getParserForType(),
                            extensionRegistry);
                internalGetMutableAttributes()
                    .getMutableMap()
                    .put(attributes__.getKey(), attributes__.getValue());
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getOriginFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Immutable. The resource name of the lineage process. Format:
     * `projects/{project}/locations/{location}/processes/{process}`.
     * Can be specified or auto-assigned.
     * {process} must be not longer than 200 characters and only
     * contain characters in a set: `a-zA-Z0-9_-:.`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. The resource name of the lineage process. Format:
     * `projects/{project}/locations/{location}/processes/{process}`.
     * Can be specified or auto-assigned.
     * {process} must be not longer than 200 characters and only
     * contain characters in a set: `a-zA-Z0-9_-:.`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. The resource name of the lineage process. Format:
     * `projects/{project}/locations/{location}/processes/{process}`.
     * Can be specified or auto-assigned.
     * {process} must be not longer than 200 characters and only
     * contain characters in a set: `a-zA-Z0-9_-:.`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The resource name of the lineage process. Format:
     * `projects/{project}/locations/{location}/processes/{process}`.
     * Can be specified or auto-assigned.
     * {process} must be not longer than 200 characters and only
     * contain characters in a set: `a-zA-Z0-9_-:.`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The resource name of the lineage process. Format:
     * `projects/{project}/locations/{location}/processes/{process}`.
     * Can be specified or auto-assigned.
     * {process} must be not longer than 200 characters and only
     * contain characters in a set: `a-zA-Z0-9_-:.`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * Optional. A human-readable name you can set to display in a user interface.
     * Must be not longer than 200 characters and only contain UTF-8 letters
     * or numbers, spaces or characters like `_-:&amp;.`
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A human-readable name you can set to display in a user interface.
     * Must be not longer than 200 characters and only contain UTF-8 letters
     * or numbers, spaces or characters like `_-:&amp;.`
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A human-readable name you can set to display in a user interface.
     * Must be not longer than 200 characters and only contain UTF-8 letters
     * or numbers, spaces or characters like `_-:&amp;.`
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A human-readable name you can set to display in a user interface.
     * Must be not longer than 200 characters and only contain UTF-8 letters
     * or numbers, spaces or characters like `_-:&amp;.`
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A human-readable name you can set to display in a user interface.
     * Must be not longer than 200 characters and only contain UTF-8 letters
     * or numbers, spaces or characters like `_-:&amp;.`
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, com.google.protobuf.Value> attributes_;

    private com.google.protobuf.MapField<java.lang.String, com.google.protobuf.Value>
        internalGetAttributes() {
      if (attributes_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            AttributesDefaultEntryHolder.defaultEntry);
      }
      return attributes_;
    }

    private com.google.protobuf.MapField<java.lang.String, com.google.protobuf.Value>
        internalGetMutableAttributes() {
      if (attributes_ == null) {
        attributes_ =
            com.google.protobuf.MapField.newMapField(AttributesDefaultEntryHolder.defaultEntry);
      }
      if (!attributes_.isMutable()) {
        attributes_ = attributes_.copy();
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return attributes_;
    }

    public int getAttributesCount() {
      return internalGetAttributes().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Optional. The attributes of the process. Should only be used for the
     * purpose of non-semantic management (classifying, describing or labeling the
     * process).
     *
     * Up to 100 attributes are allowed.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.protobuf.Value&gt; attributes = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public boolean containsAttributes(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetAttributes().getMap().containsKey(key);
    }
    /** Use {@link #getAttributesMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.protobuf.Value> getAttributes() {
      return getAttributesMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. The attributes of the process. Should only be used for the
     * purpose of non-semantic management (classifying, describing or labeling the
     * process).
     *
     * Up to 100 attributes are allowed.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.protobuf.Value&gt; attributes = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, com.google.protobuf.Value> getAttributesMap() {
      return internalGetAttributes().getMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. The attributes of the process. Should only be used for the
     * purpose of non-semantic management (classifying, describing or labeling the
     * process).
     *
     * Up to 100 attributes are allowed.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.protobuf.Value&gt; attributes = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public /* nullable */ com.google.protobuf.Value getAttributesOrDefault(
        java.lang.String key,
        /* nullable */
        com.google.protobuf.Value defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.protobuf.Value> map =
          internalGetAttributes().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Optional. The attributes of the process. Should only be used for the
     * purpose of non-semantic management (classifying, describing or labeling the
     * process).
     *
     * Up to 100 attributes are allowed.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.protobuf.Value&gt; attributes = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.protobuf.Value getAttributesOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.protobuf.Value> map =
          internalGetAttributes().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearAttributes() {
      bitField0_ = (bitField0_ & ~0x00000004);
      internalGetMutableAttributes().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The attributes of the process. Should only be used for the
     * purpose of non-semantic management (classifying, describing or labeling the
     * process).
     *
     * Up to 100 attributes are allowed.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.protobuf.Value&gt; attributes = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeAttributes(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableAttributes().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.protobuf.Value> getMutableAttributes() {
      bitField0_ |= 0x00000004;
      return internalGetMutableAttributes().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. The attributes of the process. Should only be used for the
     * purpose of non-semantic management (classifying, describing or labeling the
     * process).
     *
     * Up to 100 attributes are allowed.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.protobuf.Value&gt; attributes = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder putAttributes(java.lang.String key, com.google.protobuf.Value value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableAttributes().getMutableMap().put(key, value);
      bitField0_ |= 0x00000004;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The attributes of the process. Should only be used for the
     * purpose of non-semantic management (classifying, describing or labeling the
     * process).
     *
     * Up to 100 attributes are allowed.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.protobuf.Value&gt; attributes = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder putAllAttributes(
        java.util.Map<java.lang.String, com.google.protobuf.Value> values) {
      internalGetMutableAttributes().getMutableMap().putAll(values);
      bitField0_ |= 0x00000004;
      return this;
    }

    private com.google.cloud.datacatalog.lineage.v1.Origin origin_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datacatalog.lineage.v1.Origin,
            com.google.cloud.datacatalog.lineage.v1.Origin.Builder,
            com.google.cloud.datacatalog.lineage.v1.OriginOrBuilder>
        originBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. The origin of this process and its runs and lineage events.
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.lineage.v1.Origin origin = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the origin field is set.
     */
    public boolean hasOrigin() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. The origin of this process and its runs and lineage events.
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.lineage.v1.Origin origin = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The origin.
     */
    public com.google.cloud.datacatalog.lineage.v1.Origin getOrigin() {
      if (originBuilder_ == null) {
        return origin_ == null
            ? com.google.cloud.datacatalog.lineage.v1.Origin.getDefaultInstance()
            : origin_;
      } else {
        return originBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The origin of this process and its runs and lineage events.
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.lineage.v1.Origin origin = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setOrigin(com.google.cloud.datacatalog.lineage.v1.Origin value) {
      if (originBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        origin_ = value;
      } else {
        originBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The origin of this process and its runs and lineage events.
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.lineage.v1.Origin origin = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setOrigin(
        com.google.cloud.datacatalog.lineage.v1.Origin.Builder builderForValue) {
      if (originBuilder_ == null) {
        origin_ = builderForValue.build();
      } else {
        originBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The origin of this process and its runs and lineage events.
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.lineage.v1.Origin origin = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeOrigin(com.google.cloud.datacatalog.lineage.v1.Origin value) {
      if (originBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && origin_ != null
            && origin_ != com.google.cloud.datacatalog.lineage.v1.Origin.getDefaultInstance()) {
          getOriginBuilder().mergeFrom(value);
        } else {
          origin_ = value;
        }
      } else {
        originBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The origin of this process and its runs and lineage events.
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.lineage.v1.Origin origin = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearOrigin() {
      bitField0_ = (bitField0_ & ~0x00000008);
      origin_ = null;
      if (originBuilder_ != null) {
        originBuilder_.dispose();
        originBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The origin of this process and its runs and lineage events.
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.lineage.v1.Origin origin = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.datacatalog.lineage.v1.Origin.Builder getOriginBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getOriginFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. The origin of this process and its runs and lineage events.
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.lineage.v1.Origin origin = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.datacatalog.lineage.v1.OriginOrBuilder getOriginOrBuilder() {
      if (originBuilder_ != null) {
        return originBuilder_.getMessageOrBuilder();
      } else {
        return origin_ == null
            ? com.google.cloud.datacatalog.lineage.v1.Origin.getDefaultInstance()
            : origin_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The origin of this process and its runs and lineage events.
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.lineage.v1.Origin origin = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datacatalog.lineage.v1.Origin,
            com.google.cloud.datacatalog.lineage.v1.Origin.Builder,
            com.google.cloud.datacatalog.lineage.v1.OriginOrBuilder>
        getOriginFieldBuilder() {
      if (originBuilder_ == null) {
        originBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datacatalog.lineage.v1.Origin,
                com.google.cloud.datacatalog.lineage.v1.Origin.Builder,
                com.google.cloud.datacatalog.lineage.v1.OriginOrBuilder>(
                getOrigin(), getParentForChildren(), isClean());
        origin_ = null;
      }
      return originBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.datacatalog.lineage.v1.Process)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.datacatalog.lineage.v1.Process)
  private static final com.google.cloud.datacatalog.lineage.v1.Process DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.datacatalog.lineage.v1.Process();
  }

  public static com.google.cloud.datacatalog.lineage.v1.Process getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Process> PARSER =
      new com.google.protobuf.AbstractParser<Process>() {
        @java.lang.Override
        public Process parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Process> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Process> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.datacatalog.lineage.v1.Process getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
