/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/datacatalog/lineage/v1/lineage.proto

package com.google.cloud.datacatalog.lineage.v1;

/**
 *
 *
 * <pre>
 * Request message for
 * [SearchLinks][google.cloud.datacatalog.lineage.v1.Lineage.SearchLinks].
 * </pre>
 *
 * Protobuf type {@code google.cloud.datacatalog.lineage.v1.SearchLinksRequest}
 */
public final class SearchLinksRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.datacatalog.lineage.v1.SearchLinksRequest)
    SearchLinksRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use SearchLinksRequest.newBuilder() to construct.
  private SearchLinksRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private SearchLinksRequest() {
    parent_ = "";
    pageToken_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new SearchLinksRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.datacatalog.lineage.v1.LineageProto
        .internal_static_google_cloud_datacatalog_lineage_v1_SearchLinksRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.datacatalog.lineage.v1.LineageProto
        .internal_static_google_cloud_datacatalog_lineage_v1_SearchLinksRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.datacatalog.lineage.v1.SearchLinksRequest.class,
            com.google.cloud.datacatalog.lineage.v1.SearchLinksRequest.Builder.class);
  }

  private int criteriaCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object criteria_;

  public enum CriteriaCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    SOURCE(4),
    TARGET(5),
    CRITERIA_NOT_SET(0);
    private final int value;

    private CriteriaCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static CriteriaCase valueOf(int value) {
      return forNumber(value);
    }

    public static CriteriaCase forNumber(int value) {
      switch (value) {
        case 4:
          return SOURCE;
        case 5:
          return TARGET;
        case 0:
          return CRITERIA_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public CriteriaCase getCriteriaCase() {
    return CriteriaCase.forNumber(criteriaCase_);
  }

  public static final int PARENT_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object parent_ = "";
  /**
   *
   *
   * <pre>
   * Required. The project and location you want search in.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The parent.
   */
  @java.lang.Override
  public java.lang.String getParent() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parent_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The project and location you want search in.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for parent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentBytes() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SOURCE_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * Optional. Send asset information in the **source** field to retrieve all
   * links that lead from the specified asset to downstream assets.
   * </pre>
   *
   * <code>
   * .google.cloud.datacatalog.lineage.v1.EntityReference source = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the source field is set.
   */
  @java.lang.Override
  public boolean hasSource() {
    return criteriaCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * Optional. Send asset information in the **source** field to retrieve all
   * links that lead from the specified asset to downstream assets.
   * </pre>
   *
   * <code>
   * .google.cloud.datacatalog.lineage.v1.EntityReference source = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The source.
   */
  @java.lang.Override
  public com.google.cloud.datacatalog.lineage.v1.EntityReference getSource() {
    if (criteriaCase_ == 4) {
      return (com.google.cloud.datacatalog.lineage.v1.EntityReference) criteria_;
    }
    return com.google.cloud.datacatalog.lineage.v1.EntityReference.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Optional. Send asset information in the **source** field to retrieve all
   * links that lead from the specified asset to downstream assets.
   * </pre>
   *
   * <code>
   * .google.cloud.datacatalog.lineage.v1.EntityReference source = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.datacatalog.lineage.v1.EntityReferenceOrBuilder getSourceOrBuilder() {
    if (criteriaCase_ == 4) {
      return (com.google.cloud.datacatalog.lineage.v1.EntityReference) criteria_;
    }
    return com.google.cloud.datacatalog.lineage.v1.EntityReference.getDefaultInstance();
  }

  public static final int TARGET_FIELD_NUMBER = 5;
  /**
   *
   *
   * <pre>
   * Optional. Send asset information in the **target** field to retrieve all
   * links that lead from upstream assets to the specified asset.
   * </pre>
   *
   * <code>
   * .google.cloud.datacatalog.lineage.v1.EntityReference target = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the target field is set.
   */
  @java.lang.Override
  public boolean hasTarget() {
    return criteriaCase_ == 5;
  }
  /**
   *
   *
   * <pre>
   * Optional. Send asset information in the **target** field to retrieve all
   * links that lead from upstream assets to the specified asset.
   * </pre>
   *
   * <code>
   * .google.cloud.datacatalog.lineage.v1.EntityReference target = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The target.
   */
  @java.lang.Override
  public com.google.cloud.datacatalog.lineage.v1.EntityReference getTarget() {
    if (criteriaCase_ == 5) {
      return (com.google.cloud.datacatalog.lineage.v1.EntityReference) criteria_;
    }
    return com.google.cloud.datacatalog.lineage.v1.EntityReference.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Optional. Send asset information in the **target** field to retrieve all
   * links that lead from upstream assets to the specified asset.
   * </pre>
   *
   * <code>
   * .google.cloud.datacatalog.lineage.v1.EntityReference target = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.datacatalog.lineage.v1.EntityReferenceOrBuilder getTargetOrBuilder() {
    if (criteriaCase_ == 5) {
      return (com.google.cloud.datacatalog.lineage.v1.EntityReference) criteria_;
    }
    return com.google.cloud.datacatalog.lineage.v1.EntityReference.getDefaultInstance();
  }

  public static final int PAGE_SIZE_FIELD_NUMBER = 2;
  private int pageSize_ = 0;
  /**
   *
   *
   * <pre>
   * Optional. The maximum number of links to return in a single page of the
   * response. A page may contain fewer links than this value. If unspecified,
   * at most 10 links are returned.
   *
   * Maximum value is 100; values greater than 100 are reduced to 100.
   * </pre>
   *
   * <code>int32 page_size = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The pageSize.
   */
  @java.lang.Override
  public int getPageSize() {
    return pageSize_;
  }

  public static final int PAGE_TOKEN_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object pageToken_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The page token received from a previous `SearchLinksRequest`
   * call. Use it to get the next page.
   *
   * When requesting subsequent pages of a response, remember that
   * all parameters must match the values you provided
   * in the original request.
   * </pre>
   *
   * <code>string page_token = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The pageToken.
   */
  @java.lang.Override
  public java.lang.String getPageToken() {
    java.lang.Object ref = pageToken_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      pageToken_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The page token received from a previous `SearchLinksRequest`
   * call. Use it to get the next page.
   *
   * When requesting subsequent pages of a response, remember that
   * all parameters must match the values you provided
   * in the original request.
   * </pre>
   *
   * <code>string page_token = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for pageToken.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPageTokenBytes() {
    java.lang.Object ref = pageToken_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      pageToken_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, parent_);
    }
    if (pageSize_ != 0) {
      output.writeInt32(2, pageSize_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pageToken_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, pageToken_);
    }
    if (criteriaCase_ == 4) {
      output.writeMessage(4, (com.google.cloud.datacatalog.lineage.v1.EntityReference) criteria_);
    }
    if (criteriaCase_ == 5) {
      output.writeMessage(5, (com.google.cloud.datacatalog.lineage.v1.EntityReference) criteria_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, parent_);
    }
    if (pageSize_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, pageSize_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pageToken_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, pageToken_);
    }
    if (criteriaCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, (com.google.cloud.datacatalog.lineage.v1.EntityReference) criteria_);
    }
    if (criteriaCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5, (com.google.cloud.datacatalog.lineage.v1.EntityReference) criteria_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.datacatalog.lineage.v1.SearchLinksRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.datacatalog.lineage.v1.SearchLinksRequest other =
        (com.google.cloud.datacatalog.lineage.v1.SearchLinksRequest) obj;

    if (!getParent().equals(other.getParent())) return false;
    if (getPageSize() != other.getPageSize()) return false;
    if (!getPageToken().equals(other.getPageToken())) return false;
    if (!getCriteriaCase().equals(other.getCriteriaCase())) return false;
    switch (criteriaCase_) {
      case 4:
        if (!getSource().equals(other.getSource())) return false;
        break;
      case 5:
        if (!getTarget().equals(other.getTarget())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PARENT_FIELD_NUMBER;
    hash = (53 * hash) + getParent().hashCode();
    hash = (37 * hash) + PAGE_SIZE_FIELD_NUMBER;
    hash = (53 * hash) + getPageSize();
    hash = (37 * hash) + PAGE_TOKEN_FIELD_NUMBER;
    hash = (53 * hash) + getPageToken().hashCode();
    switch (criteriaCase_) {
      case 4:
        hash = (37 * hash) + SOURCE_FIELD_NUMBER;
        hash = (53 * hash) + getSource().hashCode();
        break;
      case 5:
        hash = (37 * hash) + TARGET_FIELD_NUMBER;
        hash = (53 * hash) + getTarget().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.datacatalog.lineage.v1.SearchLinksRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datacatalog.lineage.v1.SearchLinksRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.lineage.v1.SearchLinksRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datacatalog.lineage.v1.SearchLinksRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.lineage.v1.SearchLinksRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datacatalog.lineage.v1.SearchLinksRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.lineage.v1.SearchLinksRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datacatalog.lineage.v1.SearchLinksRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.lineage.v1.SearchLinksRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.datacatalog.lineage.v1.SearchLinksRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.lineage.v1.SearchLinksRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datacatalog.lineage.v1.SearchLinksRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.datacatalog.lineage.v1.SearchLinksRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request message for
   * [SearchLinks][google.cloud.datacatalog.lineage.v1.Lineage.SearchLinks].
   * </pre>
   *
   * Protobuf type {@code google.cloud.datacatalog.lineage.v1.SearchLinksRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.datacatalog.lineage.v1.SearchLinksRequest)
      com.google.cloud.datacatalog.lineage.v1.SearchLinksRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.datacatalog.lineage.v1.LineageProto
          .internal_static_google_cloud_datacatalog_lineage_v1_SearchLinksRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.datacatalog.lineage.v1.LineageProto
          .internal_static_google_cloud_datacatalog_lineage_v1_SearchLinksRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.datacatalog.lineage.v1.SearchLinksRequest.class,
              com.google.cloud.datacatalog.lineage.v1.SearchLinksRequest.Builder.class);
    }

    // Construct using com.google.cloud.datacatalog.lineage.v1.SearchLinksRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      parent_ = "";
      if (sourceBuilder_ != null) {
        sourceBuilder_.clear();
      }
      if (targetBuilder_ != null) {
        targetBuilder_.clear();
      }
      pageSize_ = 0;
      pageToken_ = "";
      criteriaCase_ = 0;
      criteria_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.datacatalog.lineage.v1.LineageProto
          .internal_static_google_cloud_datacatalog_lineage_v1_SearchLinksRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.datacatalog.lineage.v1.SearchLinksRequest getDefaultInstanceForType() {
      return com.google.cloud.datacatalog.lineage.v1.SearchLinksRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.datacatalog.lineage.v1.SearchLinksRequest build() {
      com.google.cloud.datacatalog.lineage.v1.SearchLinksRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.datacatalog.lineage.v1.SearchLinksRequest buildPartial() {
      com.google.cloud.datacatalog.lineage.v1.SearchLinksRequest result =
          new com.google.cloud.datacatalog.lineage.v1.SearchLinksRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.datacatalog.lineage.v1.SearchLinksRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.parent_ = parent_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.pageSize_ = pageSize_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.pageToken_ = pageToken_;
      }
    }

    private void buildPartialOneofs(
        com.google.cloud.datacatalog.lineage.v1.SearchLinksRequest result) {
      result.criteriaCase_ = criteriaCase_;
      result.criteria_ = this.criteria_;
      if (criteriaCase_ == 4 && sourceBuilder_ != null) {
        result.criteria_ = sourceBuilder_.build();
      }
      if (criteriaCase_ == 5 && targetBuilder_ != null) {
        result.criteria_ = targetBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.datacatalog.lineage.v1.SearchLinksRequest) {
        return mergeFrom((com.google.cloud.datacatalog.lineage.v1.SearchLinksRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.datacatalog.lineage.v1.SearchLinksRequest other) {
      if (other == com.google.cloud.datacatalog.lineage.v1.SearchLinksRequest.getDefaultInstance())
        return this;
      if (!other.getParent().isEmpty()) {
        parent_ = other.parent_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.getPageSize() != 0) {
        setPageSize(other.getPageSize());
      }
      if (!other.getPageToken().isEmpty()) {
        pageToken_ = other.pageToken_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      switch (other.getCriteriaCase()) {
        case SOURCE:
          {
            mergeSource(other.getSource());
            break;
          }
        case TARGET:
          {
            mergeTarget(other.getTarget());
            break;
          }
        case CRITERIA_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                parent_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 16:
              {
                pageSize_ = input.readInt32();
                bitField0_ |= 0x00000008;
                break;
              } // case 16
            case 26:
              {
                pageToken_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getSourceFieldBuilder().getBuilder(), extensionRegistry);
                criteriaCase_ = 4;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getTargetFieldBuilder().getBuilder(), extensionRegistry);
                criteriaCase_ = 5;
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int criteriaCase_ = 0;
    private java.lang.Object criteria_;

    public CriteriaCase getCriteriaCase() {
      return CriteriaCase.forNumber(criteriaCase_);
    }

    public Builder clearCriteria() {
      criteriaCase_ = 0;
      criteria_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object parent_ = "";
    /**
     *
     *
     * <pre>
     * Required. The project and location you want search in.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The parent.
     */
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The project and location you want search in.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for parent.
     */
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The project and location you want search in.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The parent to set.
     * @return This builder for chaining.
     */
    public Builder setParent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The project and location you want search in.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParent() {
      parent_ = getDefaultInstance().getParent();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The project and location you want search in.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for parent to set.
     * @return This builder for chaining.
     */
    public Builder setParentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datacatalog.lineage.v1.EntityReference,
            com.google.cloud.datacatalog.lineage.v1.EntityReference.Builder,
            com.google.cloud.datacatalog.lineage.v1.EntityReferenceOrBuilder>
        sourceBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Send asset information in the **source** field to retrieve all
     * links that lead from the specified asset to downstream assets.
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.lineage.v1.EntityReference source = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the source field is set.
     */
    @java.lang.Override
    public boolean hasSource() {
      return criteriaCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * Optional. Send asset information in the **source** field to retrieve all
     * links that lead from the specified asset to downstream assets.
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.lineage.v1.EntityReference source = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The source.
     */
    @java.lang.Override
    public com.google.cloud.datacatalog.lineage.v1.EntityReference getSource() {
      if (sourceBuilder_ == null) {
        if (criteriaCase_ == 4) {
          return (com.google.cloud.datacatalog.lineage.v1.EntityReference) criteria_;
        }
        return com.google.cloud.datacatalog.lineage.v1.EntityReference.getDefaultInstance();
      } else {
        if (criteriaCase_ == 4) {
          return sourceBuilder_.getMessage();
        }
        return com.google.cloud.datacatalog.lineage.v1.EntityReference.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Send asset information in the **source** field to retrieve all
     * links that lead from the specified asset to downstream assets.
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.lineage.v1.EntityReference source = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setSource(com.google.cloud.datacatalog.lineage.v1.EntityReference value) {
      if (sourceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        criteria_ = value;
        onChanged();
      } else {
        sourceBuilder_.setMessage(value);
      }
      criteriaCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Send asset information in the **source** field to retrieve all
     * links that lead from the specified asset to downstream assets.
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.lineage.v1.EntityReference source = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setSource(
        com.google.cloud.datacatalog.lineage.v1.EntityReference.Builder builderForValue) {
      if (sourceBuilder_ == null) {
        criteria_ = builderForValue.build();
        onChanged();
      } else {
        sourceBuilder_.setMessage(builderForValue.build());
      }
      criteriaCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Send asset information in the **source** field to retrieve all
     * links that lead from the specified asset to downstream assets.
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.lineage.v1.EntityReference source = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeSource(com.google.cloud.datacatalog.lineage.v1.EntityReference value) {
      if (sourceBuilder_ == null) {
        if (criteriaCase_ == 4
            && criteria_
                != com.google.cloud.datacatalog.lineage.v1.EntityReference.getDefaultInstance()) {
          criteria_ =
              com.google.cloud.datacatalog.lineage.v1.EntityReference.newBuilder(
                      (com.google.cloud.datacatalog.lineage.v1.EntityReference) criteria_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          criteria_ = value;
        }
        onChanged();
      } else {
        if (criteriaCase_ == 4) {
          sourceBuilder_.mergeFrom(value);
        } else {
          sourceBuilder_.setMessage(value);
        }
      }
      criteriaCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Send asset information in the **source** field to retrieve all
     * links that lead from the specified asset to downstream assets.
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.lineage.v1.EntityReference source = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearSource() {
      if (sourceBuilder_ == null) {
        if (criteriaCase_ == 4) {
          criteriaCase_ = 0;
          criteria_ = null;
          onChanged();
        }
      } else {
        if (criteriaCase_ == 4) {
          criteriaCase_ = 0;
          criteria_ = null;
        }
        sourceBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Send asset information in the **source** field to retrieve all
     * links that lead from the specified asset to downstream assets.
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.lineage.v1.EntityReference source = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.datacatalog.lineage.v1.EntityReference.Builder getSourceBuilder() {
      return getSourceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Send asset information in the **source** field to retrieve all
     * links that lead from the specified asset to downstream assets.
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.lineage.v1.EntityReference source = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.datacatalog.lineage.v1.EntityReferenceOrBuilder getSourceOrBuilder() {
      if ((criteriaCase_ == 4) && (sourceBuilder_ != null)) {
        return sourceBuilder_.getMessageOrBuilder();
      } else {
        if (criteriaCase_ == 4) {
          return (com.google.cloud.datacatalog.lineage.v1.EntityReference) criteria_;
        }
        return com.google.cloud.datacatalog.lineage.v1.EntityReference.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Send asset information in the **source** field to retrieve all
     * links that lead from the specified asset to downstream assets.
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.lineage.v1.EntityReference source = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datacatalog.lineage.v1.EntityReference,
            com.google.cloud.datacatalog.lineage.v1.EntityReference.Builder,
            com.google.cloud.datacatalog.lineage.v1.EntityReferenceOrBuilder>
        getSourceFieldBuilder() {
      if (sourceBuilder_ == null) {
        if (!(criteriaCase_ == 4)) {
          criteria_ = com.google.cloud.datacatalog.lineage.v1.EntityReference.getDefaultInstance();
        }
        sourceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datacatalog.lineage.v1.EntityReference,
                com.google.cloud.datacatalog.lineage.v1.EntityReference.Builder,
                com.google.cloud.datacatalog.lineage.v1.EntityReferenceOrBuilder>(
                (com.google.cloud.datacatalog.lineage.v1.EntityReference) criteria_,
                getParentForChildren(),
                isClean());
        criteria_ = null;
      }
      criteriaCase_ = 4;
      onChanged();
      return sourceBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datacatalog.lineage.v1.EntityReference,
            com.google.cloud.datacatalog.lineage.v1.EntityReference.Builder,
            com.google.cloud.datacatalog.lineage.v1.EntityReferenceOrBuilder>
        targetBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Send asset information in the **target** field to retrieve all
     * links that lead from upstream assets to the specified asset.
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.lineage.v1.EntityReference target = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the target field is set.
     */
    @java.lang.Override
    public boolean hasTarget() {
      return criteriaCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * Optional. Send asset information in the **target** field to retrieve all
     * links that lead from upstream assets to the specified asset.
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.lineage.v1.EntityReference target = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The target.
     */
    @java.lang.Override
    public com.google.cloud.datacatalog.lineage.v1.EntityReference getTarget() {
      if (targetBuilder_ == null) {
        if (criteriaCase_ == 5) {
          return (com.google.cloud.datacatalog.lineage.v1.EntityReference) criteria_;
        }
        return com.google.cloud.datacatalog.lineage.v1.EntityReference.getDefaultInstance();
      } else {
        if (criteriaCase_ == 5) {
          return targetBuilder_.getMessage();
        }
        return com.google.cloud.datacatalog.lineage.v1.EntityReference.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Send asset information in the **target** field to retrieve all
     * links that lead from upstream assets to the specified asset.
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.lineage.v1.EntityReference target = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setTarget(com.google.cloud.datacatalog.lineage.v1.EntityReference value) {
      if (targetBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        criteria_ = value;
        onChanged();
      } else {
        targetBuilder_.setMessage(value);
      }
      criteriaCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Send asset information in the **target** field to retrieve all
     * links that lead from upstream assets to the specified asset.
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.lineage.v1.EntityReference target = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setTarget(
        com.google.cloud.datacatalog.lineage.v1.EntityReference.Builder builderForValue) {
      if (targetBuilder_ == null) {
        criteria_ = builderForValue.build();
        onChanged();
      } else {
        targetBuilder_.setMessage(builderForValue.build());
      }
      criteriaCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Send asset information in the **target** field to retrieve all
     * links that lead from upstream assets to the specified asset.
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.lineage.v1.EntityReference target = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeTarget(com.google.cloud.datacatalog.lineage.v1.EntityReference value) {
      if (targetBuilder_ == null) {
        if (criteriaCase_ == 5
            && criteria_
                != com.google.cloud.datacatalog.lineage.v1.EntityReference.getDefaultInstance()) {
          criteria_ =
              com.google.cloud.datacatalog.lineage.v1.EntityReference.newBuilder(
                      (com.google.cloud.datacatalog.lineage.v1.EntityReference) criteria_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          criteria_ = value;
        }
        onChanged();
      } else {
        if (criteriaCase_ == 5) {
          targetBuilder_.mergeFrom(value);
        } else {
          targetBuilder_.setMessage(value);
        }
      }
      criteriaCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Send asset information in the **target** field to retrieve all
     * links that lead from upstream assets to the specified asset.
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.lineage.v1.EntityReference target = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearTarget() {
      if (targetBuilder_ == null) {
        if (criteriaCase_ == 5) {
          criteriaCase_ = 0;
          criteria_ = null;
          onChanged();
        }
      } else {
        if (criteriaCase_ == 5) {
          criteriaCase_ = 0;
          criteria_ = null;
        }
        targetBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Send asset information in the **target** field to retrieve all
     * links that lead from upstream assets to the specified asset.
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.lineage.v1.EntityReference target = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.datacatalog.lineage.v1.EntityReference.Builder getTargetBuilder() {
      return getTargetFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Send asset information in the **target** field to retrieve all
     * links that lead from upstream assets to the specified asset.
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.lineage.v1.EntityReference target = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.datacatalog.lineage.v1.EntityReferenceOrBuilder getTargetOrBuilder() {
      if ((criteriaCase_ == 5) && (targetBuilder_ != null)) {
        return targetBuilder_.getMessageOrBuilder();
      } else {
        if (criteriaCase_ == 5) {
          return (com.google.cloud.datacatalog.lineage.v1.EntityReference) criteria_;
        }
        return com.google.cloud.datacatalog.lineage.v1.EntityReference.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Send asset information in the **target** field to retrieve all
     * links that lead from upstream assets to the specified asset.
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.lineage.v1.EntityReference target = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datacatalog.lineage.v1.EntityReference,
            com.google.cloud.datacatalog.lineage.v1.EntityReference.Builder,
            com.google.cloud.datacatalog.lineage.v1.EntityReferenceOrBuilder>
        getTargetFieldBuilder() {
      if (targetBuilder_ == null) {
        if (!(criteriaCase_ == 5)) {
          criteria_ = com.google.cloud.datacatalog.lineage.v1.EntityReference.getDefaultInstance();
        }
        targetBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datacatalog.lineage.v1.EntityReference,
                com.google.cloud.datacatalog.lineage.v1.EntityReference.Builder,
                com.google.cloud.datacatalog.lineage.v1.EntityReferenceOrBuilder>(
                (com.google.cloud.datacatalog.lineage.v1.EntityReference) criteria_,
                getParentForChildren(),
                isClean());
        criteria_ = null;
      }
      criteriaCase_ = 5;
      onChanged();
      return targetBuilder_;
    }

    private int pageSize_;
    /**
     *
     *
     * <pre>
     * Optional. The maximum number of links to return in a single page of the
     * response. A page may contain fewer links than this value. If unspecified,
     * at most 10 links are returned.
     *
     * Maximum value is 100; values greater than 100 are reduced to 100.
     * </pre>
     *
     * <code>int32 page_size = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The pageSize.
     */
    @java.lang.Override
    public int getPageSize() {
      return pageSize_;
    }
    /**
     *
     *
     * <pre>
     * Optional. The maximum number of links to return in a single page of the
     * response. A page may contain fewer links than this value. If unspecified,
     * at most 10 links are returned.
     *
     * Maximum value is 100; values greater than 100 are reduced to 100.
     * </pre>
     *
     * <code>int32 page_size = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The pageSize to set.
     * @return This builder for chaining.
     */
    public Builder setPageSize(int value) {

      pageSize_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The maximum number of links to return in a single page of the
     * response. A page may contain fewer links than this value. If unspecified,
     * at most 10 links are returned.
     *
     * Maximum value is 100; values greater than 100 are reduced to 100.
     * </pre>
     *
     * <code>int32 page_size = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPageSize() {
      bitField0_ = (bitField0_ & ~0x00000008);
      pageSize_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object pageToken_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The page token received from a previous `SearchLinksRequest`
     * call. Use it to get the next page.
     *
     * When requesting subsequent pages of a response, remember that
     * all parameters must match the values you provided
     * in the original request.
     * </pre>
     *
     * <code>string page_token = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The pageToken.
     */
    public java.lang.String getPageToken() {
      java.lang.Object ref = pageToken_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        pageToken_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The page token received from a previous `SearchLinksRequest`
     * call. Use it to get the next page.
     *
     * When requesting subsequent pages of a response, remember that
     * all parameters must match the values you provided
     * in the original request.
     * </pre>
     *
     * <code>string page_token = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for pageToken.
     */
    public com.google.protobuf.ByteString getPageTokenBytes() {
      java.lang.Object ref = pageToken_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        pageToken_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The page token received from a previous `SearchLinksRequest`
     * call. Use it to get the next page.
     *
     * When requesting subsequent pages of a response, remember that
     * all parameters must match the values you provided
     * in the original request.
     * </pre>
     *
     * <code>string page_token = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The pageToken to set.
     * @return This builder for chaining.
     */
    public Builder setPageToken(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      pageToken_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The page token received from a previous `SearchLinksRequest`
     * call. Use it to get the next page.
     *
     * When requesting subsequent pages of a response, remember that
     * all parameters must match the values you provided
     * in the original request.
     * </pre>
     *
     * <code>string page_token = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPageToken() {
      pageToken_ = getDefaultInstance().getPageToken();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The page token received from a previous `SearchLinksRequest`
     * call. Use it to get the next page.
     *
     * When requesting subsequent pages of a response, remember that
     * all parameters must match the values you provided
     * in the original request.
     * </pre>
     *
     * <code>string page_token = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for pageToken to set.
     * @return This builder for chaining.
     */
    public Builder setPageTokenBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      pageToken_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.datacatalog.lineage.v1.SearchLinksRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.datacatalog.lineage.v1.SearchLinksRequest)
  private static final com.google.cloud.datacatalog.lineage.v1.SearchLinksRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.datacatalog.lineage.v1.SearchLinksRequest();
  }

  public static com.google.cloud.datacatalog.lineage.v1.SearchLinksRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<SearchLinksRequest> PARSER =
      new com.google.protobuf.AbstractParser<SearchLinksRequest>() {
        @java.lang.Override
        public SearchLinksRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<SearchLinksRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<SearchLinksRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.datacatalog.lineage.v1.SearchLinksRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
