/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataplex.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DataAttributeBindingName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_DATA_ATTRIBUTE_BINDING_ID = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/dataAttributeBindings/{data_attribute_binding_id}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String dataAttributeBindingId;

    @Deprecated
    protected DataAttributeBindingName() {
        this.project = null;
        this.location = null;
        this.dataAttributeBindingId = null;
    }

    private DataAttributeBindingName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.dataAttributeBindingId = (String)Preconditions.checkNotNull((Object)builder.getDataAttributeBindingId());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getDataAttributeBindingId() {
        return this.dataAttributeBindingId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static DataAttributeBindingName of(String project, String location, String dataAttributeBindingId) {
        return DataAttributeBindingName.newBuilder().setProject(project).setLocation(location).setDataAttributeBindingId(dataAttributeBindingId).build();
    }

    public static String format(String project, String location, String dataAttributeBindingId) {
        return DataAttributeBindingName.newBuilder().setProject(project).setLocation(location).setDataAttributeBindingId(dataAttributeBindingId).build().toString();
    }

    public static DataAttributeBindingName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_DATA_ATTRIBUTE_BINDING_ID.validatedMatch(formattedString, "DataAttributeBindingName.parse: formattedString not in valid format");
        return DataAttributeBindingName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("data_attribute_binding_id"));
    }

    public static List<DataAttributeBindingName> parseList(List<String> formattedStrings) {
        ArrayList<DataAttributeBindingName> list = new ArrayList<DataAttributeBindingName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(DataAttributeBindingName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<DataAttributeBindingName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (DataAttributeBindingName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_DATA_ATTRIBUTE_BINDING_ID.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            DataAttributeBindingName dataAttributeBindingName = this;
            synchronized (dataAttributeBindingName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.dataAttributeBindingId != null) {
                        fieldMapBuilder.put((Object)"data_attribute_binding_id", (Object)this.dataAttributeBindingId);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_DATA_ATTRIBUTE_BINDING_ID.instantiate(new String[]{"project", this.project, "location", this.location, "data_attribute_binding_id", this.dataAttributeBindingId});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            DataAttributeBindingName that = (DataAttributeBindingName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.dataAttributeBindingId, that.dataAttributeBindingId);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.dataAttributeBindingId);
    }

    public static class Builder {
        private String project;
        private String location;
        private String dataAttributeBindingId;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getDataAttributeBindingId() {
            return this.dataAttributeBindingId;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setDataAttributeBindingId(String dataAttributeBindingId) {
            this.dataAttributeBindingId = dataAttributeBindingId;
            return this;
        }

        private Builder(DataAttributeBindingName dataAttributeBindingName) {
            this.project = dataAttributeBindingName.project;
            this.location = dataAttributeBindingName.location;
            this.dataAttributeBindingId = dataAttributeBindingName.dataAttributeBindingId;
        }

        public DataAttributeBindingName build() {
            return new DataAttributeBindingName(this);
        }
    }
}

