/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataplex.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AspectTypeName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_ASPECT_TYPE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/aspectTypes/{aspect_type}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String aspectType;

    @Deprecated
    protected AspectTypeName() {
        this.project = null;
        this.location = null;
        this.aspectType = null;
    }

    private AspectTypeName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.aspectType = (String)Preconditions.checkNotNull((Object)builder.getAspectType());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getAspectType() {
        return this.aspectType;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static AspectTypeName of(String project, String location, String aspectType) {
        return AspectTypeName.newBuilder().setProject(project).setLocation(location).setAspectType(aspectType).build();
    }

    public static String format(String project, String location, String aspectType) {
        return AspectTypeName.newBuilder().setProject(project).setLocation(location).setAspectType(aspectType).build().toString();
    }

    public static AspectTypeName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_ASPECT_TYPE.validatedMatch(formattedString, "AspectTypeName.parse: formattedString not in valid format");
        return AspectTypeName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("aspect_type"));
    }

    public static List<AspectTypeName> parseList(List<String> formattedStrings) {
        ArrayList<AspectTypeName> list = new ArrayList<AspectTypeName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AspectTypeName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AspectTypeName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AspectTypeName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_ASPECT_TYPE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AspectTypeName aspectTypeName = this;
            synchronized (aspectTypeName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.aspectType != null) {
                        fieldMapBuilder.put((Object)"aspect_type", (Object)this.aspectType);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_ASPECT_TYPE.instantiate(new String[]{"project", this.project, "location", this.location, "aspect_type", this.aspectType});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            AspectTypeName that = (AspectTypeName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.aspectType, that.aspectType);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.aspectType);
    }

    public static class Builder {
        private String project;
        private String location;
        private String aspectType;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getAspectType() {
            return this.aspectType;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setAspectType(String aspectType) {
            this.aspectType = aspectType;
            return this;
        }

        private Builder(AspectTypeName aspectTypeName) {
            this.project = aspectTypeName.project;
            this.location = aspectTypeName.location;
            this.aspectType = aspectTypeName.aspectType;
        }

        public AspectTypeName build() {
            return new AspectTypeName(this);
        }
    }
}

