/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataplex.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class EntityName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_LAKE_ZONE_ENTITY = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/lakes/{lake}/zones/{zone}/entities/{entity}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String lake;
    private final String zone;
    private final String entity;

    @Deprecated
    protected EntityName() {
        this.project = null;
        this.location = null;
        this.lake = null;
        this.zone = null;
        this.entity = null;
    }

    private EntityName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.lake = (String)Preconditions.checkNotNull((Object)builder.getLake());
        this.zone = (String)Preconditions.checkNotNull((Object)builder.getZone());
        this.entity = (String)Preconditions.checkNotNull((Object)builder.getEntity());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getLake() {
        return this.lake;
    }

    public String getZone() {
        return this.zone;
    }

    public String getEntity() {
        return this.entity;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static EntityName of(String project, String location, String lake, String zone, String entity) {
        return EntityName.newBuilder().setProject(project).setLocation(location).setLake(lake).setZone(zone).setEntity(entity).build();
    }

    public static String format(String project, String location, String lake, String zone, String entity) {
        return EntityName.newBuilder().setProject(project).setLocation(location).setLake(lake).setZone(zone).setEntity(entity).build().toString();
    }

    public static EntityName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_LAKE_ZONE_ENTITY.validatedMatch(formattedString, "EntityName.parse: formattedString not in valid format");
        return EntityName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("lake"), (String)matchMap.get("zone"), (String)matchMap.get("entity"));
    }

    public static List<EntityName> parseList(List<String> formattedStrings) {
        ArrayList<EntityName> list = new ArrayList<EntityName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(EntityName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<EntityName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (EntityName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_LAKE_ZONE_ENTITY.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            EntityName entityName = this;
            synchronized (entityName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.lake != null) {
                        fieldMapBuilder.put((Object)"lake", (Object)this.lake);
                    }
                    if (this.zone != null) {
                        fieldMapBuilder.put((Object)"zone", (Object)this.zone);
                    }
                    if (this.entity != null) {
                        fieldMapBuilder.put((Object)"entity", (Object)this.entity);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_LAKE_ZONE_ENTITY.instantiate(new String[]{"project", this.project, "location", this.location, "lake", this.lake, "zone", this.zone, "entity", this.entity});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            EntityName that = (EntityName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.lake, that.lake) && Objects.equals(this.zone, that.zone) && Objects.equals(this.entity, that.entity);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.lake);
        h *= 1000003;
        h ^= Objects.hashCode(this.zone);
        h *= 1000003;
        return h ^= Objects.hashCode(this.entity);
    }

    public static class Builder {
        private String project;
        private String location;
        private String lake;
        private String zone;
        private String entity;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getLake() {
            return this.lake;
        }

        public String getZone() {
            return this.zone;
        }

        public String getEntity() {
            return this.entity;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setLake(String lake) {
            this.lake = lake;
            return this;
        }

        public Builder setZone(String zone) {
            this.zone = zone;
            return this;
        }

        public Builder setEntity(String entity) {
            this.entity = entity;
            return this;
        }

        private Builder(EntityName entityName) {
            this.project = entityName.project;
            this.location = entityName.location;
            this.lake = entityName.lake;
            this.zone = entityName.zone;
            this.entity = entityName.entity;
        }

        public EntityName build() {
            return new EntityName(this);
        }
    }
}

