/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.metastore.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class FederationName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_FEDERATION = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/federations/{federation}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String federation;

    @Deprecated
    protected FederationName() {
        this.project = null;
        this.location = null;
        this.federation = null;
    }

    private FederationName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.federation = (String)Preconditions.checkNotNull((Object)builder.getFederation());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getFederation() {
        return this.federation;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static FederationName of(String project, String location, String federation) {
        return FederationName.newBuilder().setProject(project).setLocation(location).setFederation(federation).build();
    }

    public static String format(String project, String location, String federation) {
        return FederationName.newBuilder().setProject(project).setLocation(location).setFederation(federation).build().toString();
    }

    public static FederationName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_FEDERATION.validatedMatch(formattedString, "FederationName.parse: formattedString not in valid format");
        return FederationName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("federation"));
    }

    public static List<FederationName> parseList(List<String> formattedStrings) {
        ArrayList<FederationName> list = new ArrayList<FederationName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(FederationName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<FederationName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (FederationName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_FEDERATION.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            FederationName federationName = this;
            synchronized (federationName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.federation != null) {
                        fieldMapBuilder.put((Object)"federation", (Object)this.federation);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_FEDERATION.instantiate(new String[]{"project", this.project, "location", this.location, "federation", this.federation});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            FederationName that = (FederationName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.federation, that.federation);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.federation);
    }

    public static class Builder {
        private String project;
        private String location;
        private String federation;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getFederation() {
            return this.federation;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setFederation(String federation) {
            this.federation = federation;
            return this;
        }

        private Builder(FederationName federationName) {
            this.project = federationName.project;
            this.location = federationName.location;
            this.federation = federationName.federation;
        }

        public FederationName build() {
            return new FederationName(this);
        }
    }
}

