/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/metastore/v1beta/metastore_federation.proto

package com.google.cloud.metastore.v1beta;

/**
 *
 *
 * <pre>
 * Represents a federation of multiple backend metastores.
 * </pre>
 *
 * Protobuf type {@code google.cloud.metastore.v1beta.Federation}
 */
public final class Federation extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.metastore.v1beta.Federation)
    FederationOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Federation.newBuilder() to construct.
  private Federation(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Federation() {
    name_ = "";
    version_ = "";
    endpointUri_ = "";
    state_ = 0;
    stateMessage_ = "";
    uid_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Federation();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.metastore.v1beta.MetastoreFederationProto
        .internal_static_google_cloud_metastore_v1beta_Federation_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 4:
        return internalGetLabels();
      case 6:
        return internalGetBackendMetastores();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.metastore.v1beta.MetastoreFederationProto
        .internal_static_google_cloud_metastore_v1beta_Federation_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.metastore.v1beta.Federation.class,
            com.google.cloud.metastore.v1beta.Federation.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The current state of the federation.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.metastore.v1beta.Federation.State}
   */
  public enum State implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * The state of the metastore federation is unknown.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The metastore federation is in the process of being created.
     * </pre>
     *
     * <code>CREATING = 1;</code>
     */
    CREATING(1),
    /**
     *
     *
     * <pre>
     * The metastore federation is running and ready to serve queries.
     * </pre>
     *
     * <code>ACTIVE = 2;</code>
     */
    ACTIVE(2),
    /**
     *
     *
     * <pre>
     * The metastore federation is being updated. It remains usable but cannot
     * accept additional update requests or be deleted at this time.
     * </pre>
     *
     * <code>UPDATING = 3;</code>
     */
    UPDATING(3),
    /**
     *
     *
     * <pre>
     * The metastore federation is undergoing deletion. It cannot be used.
     * </pre>
     *
     * <code>DELETING = 4;</code>
     */
    DELETING(4),
    /**
     *
     *
     * <pre>
     * The metastore federation has encountered an error and cannot be used. The
     * metastore federation should be deleted.
     * </pre>
     *
     * <code>ERROR = 5;</code>
     */
    ERROR(5),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * The state of the metastore federation is unknown.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    public static final int STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The metastore federation is in the process of being created.
     * </pre>
     *
     * <code>CREATING = 1;</code>
     */
    public static final int CREATING_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The metastore federation is running and ready to serve queries.
     * </pre>
     *
     * <code>ACTIVE = 2;</code>
     */
    public static final int ACTIVE_VALUE = 2;
    /**
     *
     *
     * <pre>
     * The metastore federation is being updated. It remains usable but cannot
     * accept additional update requests or be deleted at this time.
     * </pre>
     *
     * <code>UPDATING = 3;</code>
     */
    public static final int UPDATING_VALUE = 3;
    /**
     *
     *
     * <pre>
     * The metastore federation is undergoing deletion. It cannot be used.
     * </pre>
     *
     * <code>DELETING = 4;</code>
     */
    public static final int DELETING_VALUE = 4;
    /**
     *
     *
     * <pre>
     * The metastore federation has encountered an error and cannot be used. The
     * metastore federation should be deleted.
     * </pre>
     *
     * <code>ERROR = 5;</code>
     */
    public static final int ERROR_VALUE = 5;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static State valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static State forNumber(int value) {
      switch (value) {
        case 0:
          return STATE_UNSPECIFIED;
        case 1:
          return CREATING;
        case 2:
          return ACTIVE;
        case 3:
          return UPDATING;
        case 4:
          return DELETING;
        case 5:
          return ERROR;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<State>() {
          public State findValueByNumber(int number) {
            return State.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.metastore.v1beta.Federation.getDescriptor().getEnumTypes().get(0);
    }

    private static final State[] VALUES = values();

    public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private State(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.metastore.v1beta.Federation.State)
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Immutable. The relative resource name of the federation, of the
   * form:
   * projects/{project_number}/locations/{location_id}/federations/{federation_id}`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Immutable. The relative resource name of the federation, of the
   * form:
   * projects/{project_number}/locations/{location_id}/federations/{federation_id}`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 2;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. The time when the metastore federation was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time when the metastore federation was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time when the metastore federation was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 3;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. The time when the metastore federation was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return updateTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time when the metastore federation was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time when the metastore federation was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int LABELS_FIELD_NUMBER = 4;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.metastore.v1beta.MetastoreFederationProto
                .internal_static_google_cloud_metastore_v1beta_Federation_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * User-defined labels for the metastore federation.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4;</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * User-defined labels for the metastore federation.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * User-defined labels for the metastore federation.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * User-defined labels for the metastore federation.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int VERSION_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object version_ = "";
  /**
   *
   *
   * <pre>
   * Immutable. The Apache Hive metastore version of the federation. All backend
   * metastore versions must be compatible with the federation version.
   * </pre>
   *
   * <code>string version = 5 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The version.
   */
  @java.lang.Override
  public java.lang.String getVersion() {
    java.lang.Object ref = version_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      version_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Immutable. The Apache Hive metastore version of the federation. All backend
   * metastore versions must be compatible with the federation version.
   * </pre>
   *
   * <code>string version = 5 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The bytes for version.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getVersionBytes() {
    java.lang.Object ref = version_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      version_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int BACKEND_METASTORES_FIELD_NUMBER = 6;

  private static final class BackendMetastoresDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<
            java.lang.Integer, com.google.cloud.metastore.v1beta.BackendMetastore>
        defaultEntry =
            com.google.protobuf.MapEntry
                .<java.lang.Integer, com.google.cloud.metastore.v1beta.BackendMetastore>
                    newDefaultInstance(
                        com.google.cloud.metastore.v1beta.MetastoreFederationProto
                            .internal_static_google_cloud_metastore_v1beta_Federation_BackendMetastoresEntry_descriptor,
                        com.google.protobuf.WireFormat.FieldType.INT32,
                        0,
                        com.google.protobuf.WireFormat.FieldType.MESSAGE,
                        com.google.cloud.metastore.v1beta.BackendMetastore.getDefaultInstance());
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<
          java.lang.Integer, com.google.cloud.metastore.v1beta.BackendMetastore>
      backendMetastores_;

  private com.google.protobuf.MapField<
          java.lang.Integer, com.google.cloud.metastore.v1beta.BackendMetastore>
      internalGetBackendMetastores() {
    if (backendMetastores_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          BackendMetastoresDefaultEntryHolder.defaultEntry);
    }
    return backendMetastores_;
  }

  public int getBackendMetastoresCount() {
    return internalGetBackendMetastores().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * A map from `BackendMetastore` rank to `BackendMetastore`s from which the
   * federation service serves metadata at query time. The map key represents
   * the order in which `BackendMetastore`s should be evaluated to resolve
   * database names at query time and should be greater than or equal to zero. A
   * `BackendMetastore` with a lower number will be evaluated before a
   * `BackendMetastore` with a higher number.
   * </pre>
   *
   * <code>map&lt;int32, .google.cloud.metastore.v1beta.BackendMetastore&gt; backend_metastores = 6;
   * </code>
   */
  @java.lang.Override
  public boolean containsBackendMetastores(int key) {

    return internalGetBackendMetastores().getMap().containsKey(key);
  }
  /** Use {@link #getBackendMetastoresMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.Integer, com.google.cloud.metastore.v1beta.BackendMetastore>
      getBackendMetastores() {
    return getBackendMetastoresMap();
  }
  /**
   *
   *
   * <pre>
   * A map from `BackendMetastore` rank to `BackendMetastore`s from which the
   * federation service serves metadata at query time. The map key represents
   * the order in which `BackendMetastore`s should be evaluated to resolve
   * database names at query time and should be greater than or equal to zero. A
   * `BackendMetastore` with a lower number will be evaluated before a
   * `BackendMetastore` with a higher number.
   * </pre>
   *
   * <code>map&lt;int32, .google.cloud.metastore.v1beta.BackendMetastore&gt; backend_metastores = 6;
   * </code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.Integer, com.google.cloud.metastore.v1beta.BackendMetastore>
      getBackendMetastoresMap() {
    return internalGetBackendMetastores().getMap();
  }
  /**
   *
   *
   * <pre>
   * A map from `BackendMetastore` rank to `BackendMetastore`s from which the
   * federation service serves metadata at query time. The map key represents
   * the order in which `BackendMetastore`s should be evaluated to resolve
   * database names at query time and should be greater than or equal to zero. A
   * `BackendMetastore` with a lower number will be evaluated before a
   * `BackendMetastore` with a higher number.
   * </pre>
   *
   * <code>map&lt;int32, .google.cloud.metastore.v1beta.BackendMetastore&gt; backend_metastores = 6;
   * </code>
   */
  @java.lang.Override
  public /* nullable */ com.google.cloud.metastore.v1beta.BackendMetastore
      getBackendMetastoresOrDefault(
          int key,
          /* nullable */
          com.google.cloud.metastore.v1beta.BackendMetastore defaultValue) {

    java.util.Map<java.lang.Integer, com.google.cloud.metastore.v1beta.BackendMetastore> map =
        internalGetBackendMetastores().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * A map from `BackendMetastore` rank to `BackendMetastore`s from which the
   * federation service serves metadata at query time. The map key represents
   * the order in which `BackendMetastore`s should be evaluated to resolve
   * database names at query time and should be greater than or equal to zero. A
   * `BackendMetastore` with a lower number will be evaluated before a
   * `BackendMetastore` with a higher number.
   * </pre>
   *
   * <code>map&lt;int32, .google.cloud.metastore.v1beta.BackendMetastore&gt; backend_metastores = 6;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.metastore.v1beta.BackendMetastore getBackendMetastoresOrThrow(int key) {

    java.util.Map<java.lang.Integer, com.google.cloud.metastore.v1beta.BackendMetastore> map =
        internalGetBackendMetastores().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int ENDPOINT_URI_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private volatile java.lang.Object endpointUri_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The federation endpoint.
   * </pre>
   *
   * <code>string endpoint_uri = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The endpointUri.
   */
  @java.lang.Override
  public java.lang.String getEndpointUri() {
    java.lang.Object ref = endpointUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      endpointUri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The federation endpoint.
   * </pre>
   *
   * <code>string endpoint_uri = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for endpointUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEndpointUriBytes() {
    java.lang.Object ref = endpointUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      endpointUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STATE_FIELD_NUMBER = 8;
  private int state_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. The current state of the federation.
   * </pre>
   *
   * <code>
   * .google.cloud.metastore.v1beta.Federation.State state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The current state of the federation.
   * </pre>
   *
   * <code>
   * .google.cloud.metastore.v1beta.Federation.State state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.cloud.metastore.v1beta.Federation.State getState() {
    com.google.cloud.metastore.v1beta.Federation.State result =
        com.google.cloud.metastore.v1beta.Federation.State.forNumber(state_);
    return result == null
        ? com.google.cloud.metastore.v1beta.Federation.State.UNRECOGNIZED
        : result;
  }

  public static final int STATE_MESSAGE_FIELD_NUMBER = 9;

  @SuppressWarnings("serial")
  private volatile java.lang.Object stateMessage_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Additional information about the current state of the
   * metastore federation, if available.
   * </pre>
   *
   * <code>string state_message = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The stateMessage.
   */
  @java.lang.Override
  public java.lang.String getStateMessage() {
    java.lang.Object ref = stateMessage_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      stateMessage_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Additional information about the current state of the
   * metastore federation, if available.
   * </pre>
   *
   * <code>string state_message = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for stateMessage.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getStateMessageBytes() {
    java.lang.Object ref = stateMessage_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      stateMessage_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int UID_FIELD_NUMBER = 10;

  @SuppressWarnings("serial")
  private volatile java.lang.Object uid_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The globally unique resource identifier of the metastore
   * federation.
   * </pre>
   *
   * <code>string uid = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The uid.
   */
  @java.lang.Override
  public java.lang.String getUid() {
    java.lang.Object ref = uid_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      uid_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The globally unique resource identifier of the metastore
   * federation.
   * </pre>
   *
   * <code>string uid = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for uid.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getUidBytes() {
    java.lang.Object ref = uid_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      uid_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (createTime_ != null) {
      output.writeMessage(2, getCreateTime());
    }
    if (updateTime_ != null) {
      output.writeMessage(3, getUpdateTime());
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 4);
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(version_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, version_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeIntegerMapTo(
        output,
        internalGetBackendMetastores(),
        BackendMetastoresDefaultEntryHolder.defaultEntry,
        6);
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(endpointUri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, endpointUri_);
    }
    if (state_
        != com.google.cloud.metastore.v1beta.Federation.State.STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(8, state_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(stateMessage_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 9, stateMessage_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uid_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 10, uid_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getCreateTime());
    }
    if (updateTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getUpdateTime());
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, labels__);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(version_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, version_);
    }
    for (java.util.Map.Entry<java.lang.Integer, com.google.cloud.metastore.v1beta.BackendMetastore>
        entry : internalGetBackendMetastores().getMap().entrySet()) {
      com.google.protobuf.MapEntry<
              java.lang.Integer, com.google.cloud.metastore.v1beta.BackendMetastore>
          backendMetastores__ =
              BackendMetastoresDefaultEntryHolder.defaultEntry
                  .newBuilderForType()
                  .setKey(entry.getKey())
                  .setValue(entry.getValue())
                  .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, backendMetastores__);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(endpointUri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, endpointUri_);
    }
    if (state_
        != com.google.cloud.metastore.v1beta.Federation.State.STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(8, state_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(stateMessage_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(9, stateMessage_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uid_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(10, uid_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.metastore.v1beta.Federation)) {
      return super.equals(obj);
    }
    com.google.cloud.metastore.v1beta.Federation other =
        (com.google.cloud.metastore.v1beta.Federation) obj;

    if (!getName().equals(other.getName())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (!getVersion().equals(other.getVersion())) return false;
    if (!internalGetBackendMetastores().equals(other.internalGetBackendMetastores())) return false;
    if (!getEndpointUri().equals(other.getEndpointUri())) return false;
    if (state_ != other.state_) return false;
    if (!getStateMessage().equals(other.getStateMessage())) return false;
    if (!getUid().equals(other.getUid())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    hash = (37 * hash) + VERSION_FIELD_NUMBER;
    hash = (53 * hash) + getVersion().hashCode();
    if (!internalGetBackendMetastores().getMap().isEmpty()) {
      hash = (37 * hash) + BACKEND_METASTORES_FIELD_NUMBER;
      hash = (53 * hash) + internalGetBackendMetastores().hashCode();
    }
    hash = (37 * hash) + ENDPOINT_URI_FIELD_NUMBER;
    hash = (53 * hash) + getEndpointUri().hashCode();
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    hash = (37 * hash) + STATE_MESSAGE_FIELD_NUMBER;
    hash = (53 * hash) + getStateMessage().hashCode();
    hash = (37 * hash) + UID_FIELD_NUMBER;
    hash = (53 * hash) + getUid().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.metastore.v1beta.Federation parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.metastore.v1beta.Federation parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.metastore.v1beta.Federation parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.metastore.v1beta.Federation parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.metastore.v1beta.Federation parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.metastore.v1beta.Federation parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.metastore.v1beta.Federation parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.metastore.v1beta.Federation parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.metastore.v1beta.Federation parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.metastore.v1beta.Federation parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.metastore.v1beta.Federation parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.metastore.v1beta.Federation parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.metastore.v1beta.Federation prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Represents a federation of multiple backend metastores.
   * </pre>
   *
   * Protobuf type {@code google.cloud.metastore.v1beta.Federation}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.metastore.v1beta.Federation)
      com.google.cloud.metastore.v1beta.FederationOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.metastore.v1beta.MetastoreFederationProto
          .internal_static_google_cloud_metastore_v1beta_Federation_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 4:
          return internalGetLabels();
        case 6:
          return internalGetBackendMetastores();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 4:
          return internalGetMutableLabels();
        case 6:
          return internalGetMutableBackendMetastores();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.metastore.v1beta.MetastoreFederationProto
          .internal_static_google_cloud_metastore_v1beta_Federation_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.metastore.v1beta.Federation.class,
              com.google.cloud.metastore.v1beta.Federation.Builder.class);
    }

    // Construct using com.google.cloud.metastore.v1beta.Federation.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      internalGetMutableLabels().clear();
      version_ = "";
      internalGetMutableBackendMetastores().clear();
      endpointUri_ = "";
      state_ = 0;
      stateMessage_ = "";
      uid_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.metastore.v1beta.MetastoreFederationProto
          .internal_static_google_cloud_metastore_v1beta_Federation_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.metastore.v1beta.Federation getDefaultInstanceForType() {
      return com.google.cloud.metastore.v1beta.Federation.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.metastore.v1beta.Federation build() {
      com.google.cloud.metastore.v1beta.Federation result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.metastore.v1beta.Federation buildPartial() {
      com.google.cloud.metastore.v1beta.Federation result =
          new com.google.cloud.metastore.v1beta.Federation(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.metastore.v1beta.Federation result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.labels_ = internalGetLabels();
        result.labels_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.version_ = version_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.backendMetastores_ = internalGetBackendMetastores();
        result.backendMetastores_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.endpointUri_ = endpointUri_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.state_ = state_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.stateMessage_ = stateMessage_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.uid_ = uid_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.metastore.v1beta.Federation) {
        return mergeFrom((com.google.cloud.metastore.v1beta.Federation) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.metastore.v1beta.Federation other) {
      if (other == com.google.cloud.metastore.v1beta.Federation.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      bitField0_ |= 0x00000008;
      if (!other.getVersion().isEmpty()) {
        version_ = other.version_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      internalGetMutableBackendMetastores().mergeFrom(other.internalGetBackendMetastores());
      bitField0_ |= 0x00000020;
      if (!other.getEndpointUri().isEmpty()) {
        endpointUri_ = other.endpointUri_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (!other.getStateMessage().isEmpty()) {
        stateMessage_ = other.stateMessage_;
        bitField0_ |= 0x00000100;
        onChanged();
      }
      if (!other.getUid().isEmpty()) {
        uid_ = other.uid_;
        bitField0_ |= 0x00000200;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                version_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                com.google.protobuf.MapEntry<
                        java.lang.Integer, com.google.cloud.metastore.v1beta.BackendMetastore>
                    backendMetastores__ =
                        input.readMessage(
                            BackendMetastoresDefaultEntryHolder.defaultEntry.getParserForType(),
                            extensionRegistry);
                internalGetMutableBackendMetastores()
                    .getMutableMap()
                    .put(backendMetastores__.getKey(), backendMetastores__.getValue());
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 58:
              {
                endpointUri_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            case 64:
              {
                state_ = input.readEnum();
                bitField0_ |= 0x00000080;
                break;
              } // case 64
            case 74:
              {
                stateMessage_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000100;
                break;
              } // case 74
            case 82:
              {
                uid_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000200;
                break;
              } // case 82
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Immutable. The relative resource name of the federation, of the
     * form:
     * projects/{project_number}/locations/{location_id}/federations/{federation_id}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. The relative resource name of the federation, of the
     * form:
     * projects/{project_number}/locations/{location_id}/federations/{federation_id}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. The relative resource name of the federation, of the
     * form:
     * projects/{project_number}/locations/{location_id}/federations/{federation_id}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The relative resource name of the federation, of the
     * form:
     * projects/{project_number}/locations/{location_id}/federations/{federation_id}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The relative resource name of the federation, of the
     * form:
     * projects/{project_number}/locations/{location_id}/federations/{federation_id}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The time when the metastore federation was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the metastore federation was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the metastore federation was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the metastore federation was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the metastore federation was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the metastore federation was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000002);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the metastore federation was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the metastore federation was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the metastore federation was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The time when the metastore federation was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the metastore federation was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the metastore federation was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the metastore federation was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the metastore federation was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the metastore federation was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000004);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the metastore federation was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the metastore federation was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the metastore federation was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * User-defined labels for the metastore federation.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * User-defined labels for the metastore federation.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * User-defined labels for the metastore federation.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * User-defined labels for the metastore federation.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      bitField0_ = (bitField0_ & ~0x00000008);
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * User-defined labels for the metastore federation.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      bitField0_ |= 0x00000008;
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * User-defined labels for the metastore federation.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00000008;
      return this;
    }
    /**
     *
     *
     * <pre>
     * User-defined labels for the metastore federation.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00000008;
      return this;
    }

    private java.lang.Object version_ = "";
    /**
     *
     *
     * <pre>
     * Immutable. The Apache Hive metastore version of the federation. All backend
     * metastore versions must be compatible with the federation version.
     * </pre>
     *
     * <code>string version = 5 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The version.
     */
    public java.lang.String getVersion() {
      java.lang.Object ref = version_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        version_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. The Apache Hive metastore version of the federation. All backend
     * metastore versions must be compatible with the federation version.
     * </pre>
     *
     * <code>string version = 5 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The bytes for version.
     */
    public com.google.protobuf.ByteString getVersionBytes() {
      java.lang.Object ref = version_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        version_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. The Apache Hive metastore version of the federation. All backend
     * metastore versions must be compatible with the federation version.
     * </pre>
     *
     * <code>string version = 5 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The version to set.
     * @return This builder for chaining.
     */
    public Builder setVersion(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      version_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The Apache Hive metastore version of the federation. All backend
     * metastore versions must be compatible with the federation version.
     * </pre>
     *
     * <code>string version = 5 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearVersion() {
      version_ = getDefaultInstance().getVersion();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The Apache Hive metastore version of the federation. All backend
     * metastore versions must be compatible with the federation version.
     * </pre>
     *
     * <code>string version = 5 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The bytes for version to set.
     * @return This builder for chaining.
     */
    public Builder setVersionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      version_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<
            java.lang.Integer, com.google.cloud.metastore.v1beta.BackendMetastore>
        backendMetastores_;

    private com.google.protobuf.MapField<
            java.lang.Integer, com.google.cloud.metastore.v1beta.BackendMetastore>
        internalGetBackendMetastores() {
      if (backendMetastores_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            BackendMetastoresDefaultEntryHolder.defaultEntry);
      }
      return backendMetastores_;
    }

    private com.google.protobuf.MapField<
            java.lang.Integer, com.google.cloud.metastore.v1beta.BackendMetastore>
        internalGetMutableBackendMetastores() {
      if (backendMetastores_ == null) {
        backendMetastores_ =
            com.google.protobuf.MapField.newMapField(
                BackendMetastoresDefaultEntryHolder.defaultEntry);
      }
      if (!backendMetastores_.isMutable()) {
        backendMetastores_ = backendMetastores_.copy();
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return backendMetastores_;
    }

    public int getBackendMetastoresCount() {
      return internalGetBackendMetastores().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * A map from `BackendMetastore` rank to `BackendMetastore`s from which the
     * federation service serves metadata at query time. The map key represents
     * the order in which `BackendMetastore`s should be evaluated to resolve
     * database names at query time and should be greater than or equal to zero. A
     * `BackendMetastore` with a lower number will be evaluated before a
     * `BackendMetastore` with a higher number.
     * </pre>
     *
     * <code>
     * map&lt;int32, .google.cloud.metastore.v1beta.BackendMetastore&gt; backend_metastores = 6;
     * </code>
     */
    @java.lang.Override
    public boolean containsBackendMetastores(int key) {

      return internalGetBackendMetastores().getMap().containsKey(key);
    }
    /** Use {@link #getBackendMetastoresMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.Integer, com.google.cloud.metastore.v1beta.BackendMetastore>
        getBackendMetastores() {
      return getBackendMetastoresMap();
    }
    /**
     *
     *
     * <pre>
     * A map from `BackendMetastore` rank to `BackendMetastore`s from which the
     * federation service serves metadata at query time. The map key represents
     * the order in which `BackendMetastore`s should be evaluated to resolve
     * database names at query time and should be greater than or equal to zero. A
     * `BackendMetastore` with a lower number will be evaluated before a
     * `BackendMetastore` with a higher number.
     * </pre>
     *
     * <code>
     * map&lt;int32, .google.cloud.metastore.v1beta.BackendMetastore&gt; backend_metastores = 6;
     * </code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.Integer, com.google.cloud.metastore.v1beta.BackendMetastore>
        getBackendMetastoresMap() {
      return internalGetBackendMetastores().getMap();
    }
    /**
     *
     *
     * <pre>
     * A map from `BackendMetastore` rank to `BackendMetastore`s from which the
     * federation service serves metadata at query time. The map key represents
     * the order in which `BackendMetastore`s should be evaluated to resolve
     * database names at query time and should be greater than or equal to zero. A
     * `BackendMetastore` with a lower number will be evaluated before a
     * `BackendMetastore` with a higher number.
     * </pre>
     *
     * <code>
     * map&lt;int32, .google.cloud.metastore.v1beta.BackendMetastore&gt; backend_metastores = 6;
     * </code>
     */
    @java.lang.Override
    public /* nullable */ com.google.cloud.metastore.v1beta.BackendMetastore
        getBackendMetastoresOrDefault(
            int key,
            /* nullable */
            com.google.cloud.metastore.v1beta.BackendMetastore defaultValue) {

      java.util.Map<java.lang.Integer, com.google.cloud.metastore.v1beta.BackendMetastore> map =
          internalGetBackendMetastores().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * A map from `BackendMetastore` rank to `BackendMetastore`s from which the
     * federation service serves metadata at query time. The map key represents
     * the order in which `BackendMetastore`s should be evaluated to resolve
     * database names at query time and should be greater than or equal to zero. A
     * `BackendMetastore` with a lower number will be evaluated before a
     * `BackendMetastore` with a higher number.
     * </pre>
     *
     * <code>
     * map&lt;int32, .google.cloud.metastore.v1beta.BackendMetastore&gt; backend_metastores = 6;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.metastore.v1beta.BackendMetastore getBackendMetastoresOrThrow(int key) {

      java.util.Map<java.lang.Integer, com.google.cloud.metastore.v1beta.BackendMetastore> map =
          internalGetBackendMetastores().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearBackendMetastores() {
      bitField0_ = (bitField0_ & ~0x00000020);
      internalGetMutableBackendMetastores().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A map from `BackendMetastore` rank to `BackendMetastore`s from which the
     * federation service serves metadata at query time. The map key represents
     * the order in which `BackendMetastore`s should be evaluated to resolve
     * database names at query time and should be greater than or equal to zero. A
     * `BackendMetastore` with a lower number will be evaluated before a
     * `BackendMetastore` with a higher number.
     * </pre>
     *
     * <code>
     * map&lt;int32, .google.cloud.metastore.v1beta.BackendMetastore&gt; backend_metastores = 6;
     * </code>
     */
    public Builder removeBackendMetastores(int key) {

      internalGetMutableBackendMetastores().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.Integer, com.google.cloud.metastore.v1beta.BackendMetastore>
        getMutableBackendMetastores() {
      bitField0_ |= 0x00000020;
      return internalGetMutableBackendMetastores().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * A map from `BackendMetastore` rank to `BackendMetastore`s from which the
     * federation service serves metadata at query time. The map key represents
     * the order in which `BackendMetastore`s should be evaluated to resolve
     * database names at query time and should be greater than or equal to zero. A
     * `BackendMetastore` with a lower number will be evaluated before a
     * `BackendMetastore` with a higher number.
     * </pre>
     *
     * <code>
     * map&lt;int32, .google.cloud.metastore.v1beta.BackendMetastore&gt; backend_metastores = 6;
     * </code>
     */
    public Builder putBackendMetastores(
        int key, com.google.cloud.metastore.v1beta.BackendMetastore value) {

      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableBackendMetastores().getMutableMap().put(key, value);
      bitField0_ |= 0x00000020;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A map from `BackendMetastore` rank to `BackendMetastore`s from which the
     * federation service serves metadata at query time. The map key represents
     * the order in which `BackendMetastore`s should be evaluated to resolve
     * database names at query time and should be greater than or equal to zero. A
     * `BackendMetastore` with a lower number will be evaluated before a
     * `BackendMetastore` with a higher number.
     * </pre>
     *
     * <code>
     * map&lt;int32, .google.cloud.metastore.v1beta.BackendMetastore&gt; backend_metastores = 6;
     * </code>
     */
    public Builder putAllBackendMetastores(
        java.util.Map<java.lang.Integer, com.google.cloud.metastore.v1beta.BackendMetastore>
            values) {
      internalGetMutableBackendMetastores().getMutableMap().putAll(values);
      bitField0_ |= 0x00000020;
      return this;
    }

    private java.lang.Object endpointUri_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The federation endpoint.
     * </pre>
     *
     * <code>string endpoint_uri = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The endpointUri.
     */
    public java.lang.String getEndpointUri() {
      java.lang.Object ref = endpointUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        endpointUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The federation endpoint.
     * </pre>
     *
     * <code>string endpoint_uri = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for endpointUri.
     */
    public com.google.protobuf.ByteString getEndpointUriBytes() {
      java.lang.Object ref = endpointUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        endpointUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The federation endpoint.
     * </pre>
     *
     * <code>string endpoint_uri = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The endpointUri to set.
     * @return This builder for chaining.
     */
    public Builder setEndpointUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      endpointUri_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The federation endpoint.
     * </pre>
     *
     * <code>string endpoint_uri = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEndpointUri() {
      endpointUri_ = getDefaultInstance().getEndpointUri();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The federation endpoint.
     * </pre>
     *
     * <code>string endpoint_uri = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for endpointUri to set.
     * @return This builder for chaining.
     */
    public Builder setEndpointUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      endpointUri_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. The current state of the federation.
     * </pre>
     *
     * <code>
     * .google.cloud.metastore.v1beta.Federation.State state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current state of the federation.
     * </pre>
     *
     * <code>
     * .google.cloud.metastore.v1beta.Federation.State state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {
      state_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current state of the federation.
     * </pre>
     *
     * <code>
     * .google.cloud.metastore.v1beta.Federation.State state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.metastore.v1beta.Federation.State getState() {
      com.google.cloud.metastore.v1beta.Federation.State result =
          com.google.cloud.metastore.v1beta.Federation.State.forNumber(state_);
      return result == null
          ? com.google.cloud.metastore.v1beta.Federation.State.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current state of the federation.
     * </pre>
     *
     * <code>
     * .google.cloud.metastore.v1beta.Federation.State state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.cloud.metastore.v1beta.Federation.State value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000080;
      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current state of the federation.
     * </pre>
     *
     * <code>
     * .google.cloud.metastore.v1beta.Federation.State state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {
      bitField0_ = (bitField0_ & ~0x00000080);
      state_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object stateMessage_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Additional information about the current state of the
     * metastore federation, if available.
     * </pre>
     *
     * <code>string state_message = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The stateMessage.
     */
    public java.lang.String getStateMessage() {
      java.lang.Object ref = stateMessage_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        stateMessage_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Additional information about the current state of the
     * metastore federation, if available.
     * </pre>
     *
     * <code>string state_message = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for stateMessage.
     */
    public com.google.protobuf.ByteString getStateMessageBytes() {
      java.lang.Object ref = stateMessage_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        stateMessage_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Additional information about the current state of the
     * metastore federation, if available.
     * </pre>
     *
     * <code>string state_message = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The stateMessage to set.
     * @return This builder for chaining.
     */
    public Builder setStateMessage(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      stateMessage_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Additional information about the current state of the
     * metastore federation, if available.
     * </pre>
     *
     * <code>string state_message = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStateMessage() {
      stateMessage_ = getDefaultInstance().getStateMessage();
      bitField0_ = (bitField0_ & ~0x00000100);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Additional information about the current state of the
     * metastore federation, if available.
     * </pre>
     *
     * <code>string state_message = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for stateMessage to set.
     * @return This builder for chaining.
     */
    public Builder setStateMessageBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      stateMessage_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    private java.lang.Object uid_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The globally unique resource identifier of the metastore
     * federation.
     * </pre>
     *
     * <code>string uid = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The uid.
     */
    public java.lang.String getUid() {
      java.lang.Object ref = uid_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        uid_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The globally unique resource identifier of the metastore
     * federation.
     * </pre>
     *
     * <code>string uid = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for uid.
     */
    public com.google.protobuf.ByteString getUidBytes() {
      java.lang.Object ref = uid_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        uid_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The globally unique resource identifier of the metastore
     * federation.
     * </pre>
     *
     * <code>string uid = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The uid to set.
     * @return This builder for chaining.
     */
    public Builder setUid(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      uid_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The globally unique resource identifier of the metastore
     * federation.
     * </pre>
     *
     * <code>string uid = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUid() {
      uid_ = getDefaultInstance().getUid();
      bitField0_ = (bitField0_ & ~0x00000200);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The globally unique resource identifier of the metastore
     * federation.
     * </pre>
     *
     * <code>string uid = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for uid to set.
     * @return This builder for chaining.
     */
    public Builder setUidBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      uid_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.metastore.v1beta.Federation)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.metastore.v1beta.Federation)
  private static final com.google.cloud.metastore.v1beta.Federation DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.metastore.v1beta.Federation();
  }

  public static com.google.cloud.metastore.v1beta.Federation getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Federation> PARSER =
      new com.google.protobuf.AbstractParser<Federation>() {
        @java.lang.Override
        public Federation parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Federation> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Federation> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.metastore.v1beta.Federation getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
