/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/metastore/v1beta/metastore.proto

package com.google.cloud.metastore.v1beta;

/**
 *
 *
 * <pre>
 * Metadata about the service in a location.
 * </pre>
 *
 * Protobuf type {@code google.cloud.metastore.v1beta.LocationMetadata}
 */
public final class LocationMetadata extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.metastore.v1beta.LocationMetadata)
    LocationMetadataOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use LocationMetadata.newBuilder() to construct.
  private LocationMetadata(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private LocationMetadata() {
    supportedHiveMetastoreVersions_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new LocationMetadata();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.metastore.v1beta.MetastoreProto
        .internal_static_google_cloud_metastore_v1beta_LocationMetadata_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.metastore.v1beta.MetastoreProto
        .internal_static_google_cloud_metastore_v1beta_LocationMetadata_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.metastore.v1beta.LocationMetadata.class,
            com.google.cloud.metastore.v1beta.LocationMetadata.Builder.class);
  }

  public interface HiveMetastoreVersionOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.metastore.v1beta.LocationMetadata.HiveMetastoreVersion)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The semantic version of the Hive Metastore software.
     * </pre>
     *
     * <code>string version = 1;</code>
     *
     * @return The version.
     */
    java.lang.String getVersion();
    /**
     *
     *
     * <pre>
     * The semantic version of the Hive Metastore software.
     * </pre>
     *
     * <code>string version = 1;</code>
     *
     * @return The bytes for version.
     */
    com.google.protobuf.ByteString getVersionBytes();

    /**
     *
     *
     * <pre>
     * Whether `version` will be chosen by the server if a metastore service is
     * created with a `HiveMetastoreConfig` that omits the `version`.
     * </pre>
     *
     * <code>bool is_default = 2;</code>
     *
     * @return The isDefault.
     */
    boolean getIsDefault();
  }
  /**
   *
   *
   * <pre>
   * A specification of a supported version of the Hive Metastore software.
   * </pre>
   *
   * Protobuf type {@code google.cloud.metastore.v1beta.LocationMetadata.HiveMetastoreVersion}
   */
  public static final class HiveMetastoreVersion extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.metastore.v1beta.LocationMetadata.HiveMetastoreVersion)
      HiveMetastoreVersionOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use HiveMetastoreVersion.newBuilder() to construct.
    private HiveMetastoreVersion(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private HiveMetastoreVersion() {
      version_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new HiveMetastoreVersion();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.metastore.v1beta.MetastoreProto
          .internal_static_google_cloud_metastore_v1beta_LocationMetadata_HiveMetastoreVersion_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.metastore.v1beta.MetastoreProto
          .internal_static_google_cloud_metastore_v1beta_LocationMetadata_HiveMetastoreVersion_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.metastore.v1beta.LocationMetadata.HiveMetastoreVersion.class,
              com.google.cloud.metastore.v1beta.LocationMetadata.HiveMetastoreVersion.Builder
                  .class);
    }

    public static final int VERSION_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object version_ = "";
    /**
     *
     *
     * <pre>
     * The semantic version of the Hive Metastore software.
     * </pre>
     *
     * <code>string version = 1;</code>
     *
     * @return The version.
     */
    @java.lang.Override
    public java.lang.String getVersion() {
      java.lang.Object ref = version_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        version_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The semantic version of the Hive Metastore software.
     * </pre>
     *
     * <code>string version = 1;</code>
     *
     * @return The bytes for version.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getVersionBytes() {
      java.lang.Object ref = version_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        version_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int IS_DEFAULT_FIELD_NUMBER = 2;
    private boolean isDefault_ = false;
    /**
     *
     *
     * <pre>
     * Whether `version` will be chosen by the server if a metastore service is
     * created with a `HiveMetastoreConfig` that omits the `version`.
     * </pre>
     *
     * <code>bool is_default = 2;</code>
     *
     * @return The isDefault.
     */
    @java.lang.Override
    public boolean getIsDefault() {
      return isDefault_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(version_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, version_);
      }
      if (isDefault_ != false) {
        output.writeBool(2, isDefault_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(version_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, version_);
      }
      if (isDefault_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(2, isDefault_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.metastore.v1beta.LocationMetadata.HiveMetastoreVersion)) {
        return super.equals(obj);
      }
      com.google.cloud.metastore.v1beta.LocationMetadata.HiveMetastoreVersion other =
          (com.google.cloud.metastore.v1beta.LocationMetadata.HiveMetastoreVersion) obj;

      if (!getVersion().equals(other.getVersion())) return false;
      if (getIsDefault() != other.getIsDefault()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + VERSION_FIELD_NUMBER;
      hash = (53 * hash) + getVersion().hashCode();
      hash = (37 * hash) + IS_DEFAULT_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getIsDefault());
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.metastore.v1beta.LocationMetadata.HiveMetastoreVersion parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.metastore.v1beta.LocationMetadata.HiveMetastoreVersion parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.metastore.v1beta.LocationMetadata.HiveMetastoreVersion parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.metastore.v1beta.LocationMetadata.HiveMetastoreVersion parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.metastore.v1beta.LocationMetadata.HiveMetastoreVersion parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.metastore.v1beta.LocationMetadata.HiveMetastoreVersion parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.metastore.v1beta.LocationMetadata.HiveMetastoreVersion parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.metastore.v1beta.LocationMetadata.HiveMetastoreVersion parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.metastore.v1beta.LocationMetadata.HiveMetastoreVersion
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.metastore.v1beta.LocationMetadata.HiveMetastoreVersion
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.metastore.v1beta.LocationMetadata.HiveMetastoreVersion parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.metastore.v1beta.LocationMetadata.HiveMetastoreVersion parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.metastore.v1beta.LocationMetadata.HiveMetastoreVersion prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A specification of a supported version of the Hive Metastore software.
     * </pre>
     *
     * Protobuf type {@code google.cloud.metastore.v1beta.LocationMetadata.HiveMetastoreVersion}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.metastore.v1beta.LocationMetadata.HiveMetastoreVersion)
        com.google.cloud.metastore.v1beta.LocationMetadata.HiveMetastoreVersionOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.metastore.v1beta.MetastoreProto
            .internal_static_google_cloud_metastore_v1beta_LocationMetadata_HiveMetastoreVersion_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.metastore.v1beta.MetastoreProto
            .internal_static_google_cloud_metastore_v1beta_LocationMetadata_HiveMetastoreVersion_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.metastore.v1beta.LocationMetadata.HiveMetastoreVersion.class,
                com.google.cloud.metastore.v1beta.LocationMetadata.HiveMetastoreVersion.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.metastore.v1beta.LocationMetadata.HiveMetastoreVersion.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        version_ = "";
        isDefault_ = false;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.metastore.v1beta.MetastoreProto
            .internal_static_google_cloud_metastore_v1beta_LocationMetadata_HiveMetastoreVersion_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.metastore.v1beta.LocationMetadata.HiveMetastoreVersion
          getDefaultInstanceForType() {
        return com.google.cloud.metastore.v1beta.LocationMetadata.HiveMetastoreVersion
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.metastore.v1beta.LocationMetadata.HiveMetastoreVersion build() {
        com.google.cloud.metastore.v1beta.LocationMetadata.HiveMetastoreVersion result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.metastore.v1beta.LocationMetadata.HiveMetastoreVersion
          buildPartial() {
        com.google.cloud.metastore.v1beta.LocationMetadata.HiveMetastoreVersion result =
            new com.google.cloud.metastore.v1beta.LocationMetadata.HiveMetastoreVersion(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.metastore.v1beta.LocationMetadata.HiveMetastoreVersion result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.version_ = version_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.isDefault_ = isDefault_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.metastore.v1beta.LocationMetadata.HiveMetastoreVersion) {
          return mergeFrom(
              (com.google.cloud.metastore.v1beta.LocationMetadata.HiveMetastoreVersion) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.metastore.v1beta.LocationMetadata.HiveMetastoreVersion other) {
        if (other
            == com.google.cloud.metastore.v1beta.LocationMetadata.HiveMetastoreVersion
                .getDefaultInstance()) return this;
        if (!other.getVersion().isEmpty()) {
          version_ = other.version_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (other.getIsDefault() != false) {
          setIsDefault(other.getIsDefault());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  version_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 16:
                {
                  isDefault_ = input.readBool();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object version_ = "";
      /**
       *
       *
       * <pre>
       * The semantic version of the Hive Metastore software.
       * </pre>
       *
       * <code>string version = 1;</code>
       *
       * @return The version.
       */
      public java.lang.String getVersion() {
        java.lang.Object ref = version_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          version_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The semantic version of the Hive Metastore software.
       * </pre>
       *
       * <code>string version = 1;</code>
       *
       * @return The bytes for version.
       */
      public com.google.protobuf.ByteString getVersionBytes() {
        java.lang.Object ref = version_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          version_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The semantic version of the Hive Metastore software.
       * </pre>
       *
       * <code>string version = 1;</code>
       *
       * @param value The version to set.
       * @return This builder for chaining.
       */
      public Builder setVersion(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        version_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The semantic version of the Hive Metastore software.
       * </pre>
       *
       * <code>string version = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearVersion() {
        version_ = getDefaultInstance().getVersion();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The semantic version of the Hive Metastore software.
       * </pre>
       *
       * <code>string version = 1;</code>
       *
       * @param value The bytes for version to set.
       * @return This builder for chaining.
       */
      public Builder setVersionBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        version_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private boolean isDefault_;
      /**
       *
       *
       * <pre>
       * Whether `version` will be chosen by the server if a metastore service is
       * created with a `HiveMetastoreConfig` that omits the `version`.
       * </pre>
       *
       * <code>bool is_default = 2;</code>
       *
       * @return The isDefault.
       */
      @java.lang.Override
      public boolean getIsDefault() {
        return isDefault_;
      }
      /**
       *
       *
       * <pre>
       * Whether `version` will be chosen by the server if a metastore service is
       * created with a `HiveMetastoreConfig` that omits the `version`.
       * </pre>
       *
       * <code>bool is_default = 2;</code>
       *
       * @param value The isDefault to set.
       * @return This builder for chaining.
       */
      public Builder setIsDefault(boolean value) {

        isDefault_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Whether `version` will be chosen by the server if a metastore service is
       * created with a `HiveMetastoreConfig` that omits the `version`.
       * </pre>
       *
       * <code>bool is_default = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearIsDefault() {
        bitField0_ = (bitField0_ & ~0x00000002);
        isDefault_ = false;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.metastore.v1beta.LocationMetadata.HiveMetastoreVersion)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.metastore.v1beta.LocationMetadata.HiveMetastoreVersion)
    private static final com.google.cloud.metastore.v1beta.LocationMetadata.HiveMetastoreVersion
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.metastore.v1beta.LocationMetadata.HiveMetastoreVersion();
    }

    public static com.google.cloud.metastore.v1beta.LocationMetadata.HiveMetastoreVersion
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<HiveMetastoreVersion> PARSER =
        new com.google.protobuf.AbstractParser<HiveMetastoreVersion>() {
          @java.lang.Override
          public HiveMetastoreVersion parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<HiveMetastoreVersion> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<HiveMetastoreVersion> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.metastore.v1beta.LocationMetadata.HiveMetastoreVersion
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int SUPPORTED_HIVE_METASTORE_VERSIONS_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.metastore.v1beta.LocationMetadata.HiveMetastoreVersion>
      supportedHiveMetastoreVersions_;
  /**
   *
   *
   * <pre>
   * The versions of Hive Metastore that can be used when creating a new
   * metastore service in this location. The server guarantees that exactly one
   * `HiveMetastoreVersion` in the list will set `is_default`.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.metastore.v1beta.LocationMetadata.HiveMetastoreVersion supported_hive_metastore_versions = 1;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.metastore.v1beta.LocationMetadata.HiveMetastoreVersion>
      getSupportedHiveMetastoreVersionsList() {
    return supportedHiveMetastoreVersions_;
  }
  /**
   *
   *
   * <pre>
   * The versions of Hive Metastore that can be used when creating a new
   * metastore service in this location. The server guarantees that exactly one
   * `HiveMetastoreVersion` in the list will set `is_default`.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.metastore.v1beta.LocationMetadata.HiveMetastoreVersion supported_hive_metastore_versions = 1;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends
              com.google.cloud.metastore.v1beta.LocationMetadata.HiveMetastoreVersionOrBuilder>
      getSupportedHiveMetastoreVersionsOrBuilderList() {
    return supportedHiveMetastoreVersions_;
  }
  /**
   *
   *
   * <pre>
   * The versions of Hive Metastore that can be used when creating a new
   * metastore service in this location. The server guarantees that exactly one
   * `HiveMetastoreVersion` in the list will set `is_default`.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.metastore.v1beta.LocationMetadata.HiveMetastoreVersion supported_hive_metastore_versions = 1;
   * </code>
   */
  @java.lang.Override
  public int getSupportedHiveMetastoreVersionsCount() {
    return supportedHiveMetastoreVersions_.size();
  }
  /**
   *
   *
   * <pre>
   * The versions of Hive Metastore that can be used when creating a new
   * metastore service in this location. The server guarantees that exactly one
   * `HiveMetastoreVersion` in the list will set `is_default`.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.metastore.v1beta.LocationMetadata.HiveMetastoreVersion supported_hive_metastore_versions = 1;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.metastore.v1beta.LocationMetadata.HiveMetastoreVersion
      getSupportedHiveMetastoreVersions(int index) {
    return supportedHiveMetastoreVersions_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The versions of Hive Metastore that can be used when creating a new
   * metastore service in this location. The server guarantees that exactly one
   * `HiveMetastoreVersion` in the list will set `is_default`.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.metastore.v1beta.LocationMetadata.HiveMetastoreVersion supported_hive_metastore_versions = 1;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.metastore.v1beta.LocationMetadata.HiveMetastoreVersionOrBuilder
      getSupportedHiveMetastoreVersionsOrBuilder(int index) {
    return supportedHiveMetastoreVersions_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < supportedHiveMetastoreVersions_.size(); i++) {
      output.writeMessage(1, supportedHiveMetastoreVersions_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < supportedHiveMetastoreVersions_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              1, supportedHiveMetastoreVersions_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.metastore.v1beta.LocationMetadata)) {
      return super.equals(obj);
    }
    com.google.cloud.metastore.v1beta.LocationMetadata other =
        (com.google.cloud.metastore.v1beta.LocationMetadata) obj;

    if (!getSupportedHiveMetastoreVersionsList()
        .equals(other.getSupportedHiveMetastoreVersionsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getSupportedHiveMetastoreVersionsCount() > 0) {
      hash = (37 * hash) + SUPPORTED_HIVE_METASTORE_VERSIONS_FIELD_NUMBER;
      hash = (53 * hash) + getSupportedHiveMetastoreVersionsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.metastore.v1beta.LocationMetadata parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.metastore.v1beta.LocationMetadata parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.metastore.v1beta.LocationMetadata parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.metastore.v1beta.LocationMetadata parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.metastore.v1beta.LocationMetadata parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.metastore.v1beta.LocationMetadata parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.metastore.v1beta.LocationMetadata parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.metastore.v1beta.LocationMetadata parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.metastore.v1beta.LocationMetadata parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.metastore.v1beta.LocationMetadata parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.metastore.v1beta.LocationMetadata parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.metastore.v1beta.LocationMetadata parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.metastore.v1beta.LocationMetadata prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Metadata about the service in a location.
   * </pre>
   *
   * Protobuf type {@code google.cloud.metastore.v1beta.LocationMetadata}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.metastore.v1beta.LocationMetadata)
      com.google.cloud.metastore.v1beta.LocationMetadataOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.metastore.v1beta.MetastoreProto
          .internal_static_google_cloud_metastore_v1beta_LocationMetadata_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.metastore.v1beta.MetastoreProto
          .internal_static_google_cloud_metastore_v1beta_LocationMetadata_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.metastore.v1beta.LocationMetadata.class,
              com.google.cloud.metastore.v1beta.LocationMetadata.Builder.class);
    }

    // Construct using com.google.cloud.metastore.v1beta.LocationMetadata.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (supportedHiveMetastoreVersionsBuilder_ == null) {
        supportedHiveMetastoreVersions_ = java.util.Collections.emptyList();
      } else {
        supportedHiveMetastoreVersions_ = null;
        supportedHiveMetastoreVersionsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.metastore.v1beta.MetastoreProto
          .internal_static_google_cloud_metastore_v1beta_LocationMetadata_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.metastore.v1beta.LocationMetadata getDefaultInstanceForType() {
      return com.google.cloud.metastore.v1beta.LocationMetadata.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.metastore.v1beta.LocationMetadata build() {
      com.google.cloud.metastore.v1beta.LocationMetadata result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.metastore.v1beta.LocationMetadata buildPartial() {
      com.google.cloud.metastore.v1beta.LocationMetadata result =
          new com.google.cloud.metastore.v1beta.LocationMetadata(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.metastore.v1beta.LocationMetadata result) {
      if (supportedHiveMetastoreVersionsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          supportedHiveMetastoreVersions_ =
              java.util.Collections.unmodifiableList(supportedHiveMetastoreVersions_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.supportedHiveMetastoreVersions_ = supportedHiveMetastoreVersions_;
      } else {
        result.supportedHiveMetastoreVersions_ = supportedHiveMetastoreVersionsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.metastore.v1beta.LocationMetadata result) {
      int from_bitField0_ = bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.metastore.v1beta.LocationMetadata) {
        return mergeFrom((com.google.cloud.metastore.v1beta.LocationMetadata) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.metastore.v1beta.LocationMetadata other) {
      if (other == com.google.cloud.metastore.v1beta.LocationMetadata.getDefaultInstance())
        return this;
      if (supportedHiveMetastoreVersionsBuilder_ == null) {
        if (!other.supportedHiveMetastoreVersions_.isEmpty()) {
          if (supportedHiveMetastoreVersions_.isEmpty()) {
            supportedHiveMetastoreVersions_ = other.supportedHiveMetastoreVersions_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureSupportedHiveMetastoreVersionsIsMutable();
            supportedHiveMetastoreVersions_.addAll(other.supportedHiveMetastoreVersions_);
          }
          onChanged();
        }
      } else {
        if (!other.supportedHiveMetastoreVersions_.isEmpty()) {
          if (supportedHiveMetastoreVersionsBuilder_.isEmpty()) {
            supportedHiveMetastoreVersionsBuilder_.dispose();
            supportedHiveMetastoreVersionsBuilder_ = null;
            supportedHiveMetastoreVersions_ = other.supportedHiveMetastoreVersions_;
            bitField0_ = (bitField0_ & ~0x00000001);
            supportedHiveMetastoreVersionsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getSupportedHiveMetastoreVersionsFieldBuilder()
                    : null;
          } else {
            supportedHiveMetastoreVersionsBuilder_.addAllMessages(
                other.supportedHiveMetastoreVersions_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.cloud.metastore.v1beta.LocationMetadata.HiveMetastoreVersion m =
                    input.readMessage(
                        com.google.cloud.metastore.v1beta.LocationMetadata.HiveMetastoreVersion
                            .parser(),
                        extensionRegistry);
                if (supportedHiveMetastoreVersionsBuilder_ == null) {
                  ensureSupportedHiveMetastoreVersionsIsMutable();
                  supportedHiveMetastoreVersions_.add(m);
                } else {
                  supportedHiveMetastoreVersionsBuilder_.addMessage(m);
                }
                break;
              } // case 10
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.cloud.metastore.v1beta.LocationMetadata.HiveMetastoreVersion>
        supportedHiveMetastoreVersions_ = java.util.Collections.emptyList();

    private void ensureSupportedHiveMetastoreVersionsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        supportedHiveMetastoreVersions_ =
            new java.util.ArrayList<
                com.google.cloud.metastore.v1beta.LocationMetadata.HiveMetastoreVersion>(
                supportedHiveMetastoreVersions_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.metastore.v1beta.LocationMetadata.HiveMetastoreVersion,
            com.google.cloud.metastore.v1beta.LocationMetadata.HiveMetastoreVersion.Builder,
            com.google.cloud.metastore.v1beta.LocationMetadata.HiveMetastoreVersionOrBuilder>
        supportedHiveMetastoreVersionsBuilder_;

    /**
     *
     *
     * <pre>
     * The versions of Hive Metastore that can be used when creating a new
     * metastore service in this location. The server guarantees that exactly one
     * `HiveMetastoreVersion` in the list will set `is_default`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.metastore.v1beta.LocationMetadata.HiveMetastoreVersion supported_hive_metastore_versions = 1;
     * </code>
     */
    public java.util.List<com.google.cloud.metastore.v1beta.LocationMetadata.HiveMetastoreVersion>
        getSupportedHiveMetastoreVersionsList() {
      if (supportedHiveMetastoreVersionsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(supportedHiveMetastoreVersions_);
      } else {
        return supportedHiveMetastoreVersionsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The versions of Hive Metastore that can be used when creating a new
     * metastore service in this location. The server guarantees that exactly one
     * `HiveMetastoreVersion` in the list will set `is_default`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.metastore.v1beta.LocationMetadata.HiveMetastoreVersion supported_hive_metastore_versions = 1;
     * </code>
     */
    public int getSupportedHiveMetastoreVersionsCount() {
      if (supportedHiveMetastoreVersionsBuilder_ == null) {
        return supportedHiveMetastoreVersions_.size();
      } else {
        return supportedHiveMetastoreVersionsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The versions of Hive Metastore that can be used when creating a new
     * metastore service in this location. The server guarantees that exactly one
     * `HiveMetastoreVersion` in the list will set `is_default`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.metastore.v1beta.LocationMetadata.HiveMetastoreVersion supported_hive_metastore_versions = 1;
     * </code>
     */
    public com.google.cloud.metastore.v1beta.LocationMetadata.HiveMetastoreVersion
        getSupportedHiveMetastoreVersions(int index) {
      if (supportedHiveMetastoreVersionsBuilder_ == null) {
        return supportedHiveMetastoreVersions_.get(index);
      } else {
        return supportedHiveMetastoreVersionsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The versions of Hive Metastore that can be used when creating a new
     * metastore service in this location. The server guarantees that exactly one
     * `HiveMetastoreVersion` in the list will set `is_default`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.metastore.v1beta.LocationMetadata.HiveMetastoreVersion supported_hive_metastore_versions = 1;
     * </code>
     */
    public Builder setSupportedHiveMetastoreVersions(
        int index, com.google.cloud.metastore.v1beta.LocationMetadata.HiveMetastoreVersion value) {
      if (supportedHiveMetastoreVersionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSupportedHiveMetastoreVersionsIsMutable();
        supportedHiveMetastoreVersions_.set(index, value);
        onChanged();
      } else {
        supportedHiveMetastoreVersionsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The versions of Hive Metastore that can be used when creating a new
     * metastore service in this location. The server guarantees that exactly one
     * `HiveMetastoreVersion` in the list will set `is_default`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.metastore.v1beta.LocationMetadata.HiveMetastoreVersion supported_hive_metastore_versions = 1;
     * </code>
     */
    public Builder setSupportedHiveMetastoreVersions(
        int index,
        com.google.cloud.metastore.v1beta.LocationMetadata.HiveMetastoreVersion.Builder
            builderForValue) {
      if (supportedHiveMetastoreVersionsBuilder_ == null) {
        ensureSupportedHiveMetastoreVersionsIsMutable();
        supportedHiveMetastoreVersions_.set(index, builderForValue.build());
        onChanged();
      } else {
        supportedHiveMetastoreVersionsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The versions of Hive Metastore that can be used when creating a new
     * metastore service in this location. The server guarantees that exactly one
     * `HiveMetastoreVersion` in the list will set `is_default`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.metastore.v1beta.LocationMetadata.HiveMetastoreVersion supported_hive_metastore_versions = 1;
     * </code>
     */
    public Builder addSupportedHiveMetastoreVersions(
        com.google.cloud.metastore.v1beta.LocationMetadata.HiveMetastoreVersion value) {
      if (supportedHiveMetastoreVersionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSupportedHiveMetastoreVersionsIsMutable();
        supportedHiveMetastoreVersions_.add(value);
        onChanged();
      } else {
        supportedHiveMetastoreVersionsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The versions of Hive Metastore that can be used when creating a new
     * metastore service in this location. The server guarantees that exactly one
     * `HiveMetastoreVersion` in the list will set `is_default`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.metastore.v1beta.LocationMetadata.HiveMetastoreVersion supported_hive_metastore_versions = 1;
     * </code>
     */
    public Builder addSupportedHiveMetastoreVersions(
        int index, com.google.cloud.metastore.v1beta.LocationMetadata.HiveMetastoreVersion value) {
      if (supportedHiveMetastoreVersionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSupportedHiveMetastoreVersionsIsMutable();
        supportedHiveMetastoreVersions_.add(index, value);
        onChanged();
      } else {
        supportedHiveMetastoreVersionsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The versions of Hive Metastore that can be used when creating a new
     * metastore service in this location. The server guarantees that exactly one
     * `HiveMetastoreVersion` in the list will set `is_default`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.metastore.v1beta.LocationMetadata.HiveMetastoreVersion supported_hive_metastore_versions = 1;
     * </code>
     */
    public Builder addSupportedHiveMetastoreVersions(
        com.google.cloud.metastore.v1beta.LocationMetadata.HiveMetastoreVersion.Builder
            builderForValue) {
      if (supportedHiveMetastoreVersionsBuilder_ == null) {
        ensureSupportedHiveMetastoreVersionsIsMutable();
        supportedHiveMetastoreVersions_.add(builderForValue.build());
        onChanged();
      } else {
        supportedHiveMetastoreVersionsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The versions of Hive Metastore that can be used when creating a new
     * metastore service in this location. The server guarantees that exactly one
     * `HiveMetastoreVersion` in the list will set `is_default`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.metastore.v1beta.LocationMetadata.HiveMetastoreVersion supported_hive_metastore_versions = 1;
     * </code>
     */
    public Builder addSupportedHiveMetastoreVersions(
        int index,
        com.google.cloud.metastore.v1beta.LocationMetadata.HiveMetastoreVersion.Builder
            builderForValue) {
      if (supportedHiveMetastoreVersionsBuilder_ == null) {
        ensureSupportedHiveMetastoreVersionsIsMutable();
        supportedHiveMetastoreVersions_.add(index, builderForValue.build());
        onChanged();
      } else {
        supportedHiveMetastoreVersionsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The versions of Hive Metastore that can be used when creating a new
     * metastore service in this location. The server guarantees that exactly one
     * `HiveMetastoreVersion` in the list will set `is_default`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.metastore.v1beta.LocationMetadata.HiveMetastoreVersion supported_hive_metastore_versions = 1;
     * </code>
     */
    public Builder addAllSupportedHiveMetastoreVersions(
        java.lang.Iterable<
                ? extends com.google.cloud.metastore.v1beta.LocationMetadata.HiveMetastoreVersion>
            values) {
      if (supportedHiveMetastoreVersionsBuilder_ == null) {
        ensureSupportedHiveMetastoreVersionsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, supportedHiveMetastoreVersions_);
        onChanged();
      } else {
        supportedHiveMetastoreVersionsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The versions of Hive Metastore that can be used when creating a new
     * metastore service in this location. The server guarantees that exactly one
     * `HiveMetastoreVersion` in the list will set `is_default`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.metastore.v1beta.LocationMetadata.HiveMetastoreVersion supported_hive_metastore_versions = 1;
     * </code>
     */
    public Builder clearSupportedHiveMetastoreVersions() {
      if (supportedHiveMetastoreVersionsBuilder_ == null) {
        supportedHiveMetastoreVersions_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        supportedHiveMetastoreVersionsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The versions of Hive Metastore that can be used when creating a new
     * metastore service in this location. The server guarantees that exactly one
     * `HiveMetastoreVersion` in the list will set `is_default`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.metastore.v1beta.LocationMetadata.HiveMetastoreVersion supported_hive_metastore_versions = 1;
     * </code>
     */
    public Builder removeSupportedHiveMetastoreVersions(int index) {
      if (supportedHiveMetastoreVersionsBuilder_ == null) {
        ensureSupportedHiveMetastoreVersionsIsMutable();
        supportedHiveMetastoreVersions_.remove(index);
        onChanged();
      } else {
        supportedHiveMetastoreVersionsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The versions of Hive Metastore that can be used when creating a new
     * metastore service in this location. The server guarantees that exactly one
     * `HiveMetastoreVersion` in the list will set `is_default`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.metastore.v1beta.LocationMetadata.HiveMetastoreVersion supported_hive_metastore_versions = 1;
     * </code>
     */
    public com.google.cloud.metastore.v1beta.LocationMetadata.HiveMetastoreVersion.Builder
        getSupportedHiveMetastoreVersionsBuilder(int index) {
      return getSupportedHiveMetastoreVersionsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The versions of Hive Metastore that can be used when creating a new
     * metastore service in this location. The server guarantees that exactly one
     * `HiveMetastoreVersion` in the list will set `is_default`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.metastore.v1beta.LocationMetadata.HiveMetastoreVersion supported_hive_metastore_versions = 1;
     * </code>
     */
    public com.google.cloud.metastore.v1beta.LocationMetadata.HiveMetastoreVersionOrBuilder
        getSupportedHiveMetastoreVersionsOrBuilder(int index) {
      if (supportedHiveMetastoreVersionsBuilder_ == null) {
        return supportedHiveMetastoreVersions_.get(index);
      } else {
        return supportedHiveMetastoreVersionsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The versions of Hive Metastore that can be used when creating a new
     * metastore service in this location. The server guarantees that exactly one
     * `HiveMetastoreVersion` in the list will set `is_default`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.metastore.v1beta.LocationMetadata.HiveMetastoreVersion supported_hive_metastore_versions = 1;
     * </code>
     */
    public java.util.List<
            ? extends
                com.google.cloud.metastore.v1beta.LocationMetadata.HiveMetastoreVersionOrBuilder>
        getSupportedHiveMetastoreVersionsOrBuilderList() {
      if (supportedHiveMetastoreVersionsBuilder_ != null) {
        return supportedHiveMetastoreVersionsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(supportedHiveMetastoreVersions_);
      }
    }
    /**
     *
     *
     * <pre>
     * The versions of Hive Metastore that can be used when creating a new
     * metastore service in this location. The server guarantees that exactly one
     * `HiveMetastoreVersion` in the list will set `is_default`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.metastore.v1beta.LocationMetadata.HiveMetastoreVersion supported_hive_metastore_versions = 1;
     * </code>
     */
    public com.google.cloud.metastore.v1beta.LocationMetadata.HiveMetastoreVersion.Builder
        addSupportedHiveMetastoreVersionsBuilder() {
      return getSupportedHiveMetastoreVersionsFieldBuilder()
          .addBuilder(
              com.google.cloud.metastore.v1beta.LocationMetadata.HiveMetastoreVersion
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The versions of Hive Metastore that can be used when creating a new
     * metastore service in this location. The server guarantees that exactly one
     * `HiveMetastoreVersion` in the list will set `is_default`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.metastore.v1beta.LocationMetadata.HiveMetastoreVersion supported_hive_metastore_versions = 1;
     * </code>
     */
    public com.google.cloud.metastore.v1beta.LocationMetadata.HiveMetastoreVersion.Builder
        addSupportedHiveMetastoreVersionsBuilder(int index) {
      return getSupportedHiveMetastoreVersionsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.metastore.v1beta.LocationMetadata.HiveMetastoreVersion
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The versions of Hive Metastore that can be used when creating a new
     * metastore service in this location. The server guarantees that exactly one
     * `HiveMetastoreVersion` in the list will set `is_default`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.metastore.v1beta.LocationMetadata.HiveMetastoreVersion supported_hive_metastore_versions = 1;
     * </code>
     */
    public java.util.List<
            com.google.cloud.metastore.v1beta.LocationMetadata.HiveMetastoreVersion.Builder>
        getSupportedHiveMetastoreVersionsBuilderList() {
      return getSupportedHiveMetastoreVersionsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.metastore.v1beta.LocationMetadata.HiveMetastoreVersion,
            com.google.cloud.metastore.v1beta.LocationMetadata.HiveMetastoreVersion.Builder,
            com.google.cloud.metastore.v1beta.LocationMetadata.HiveMetastoreVersionOrBuilder>
        getSupportedHiveMetastoreVersionsFieldBuilder() {
      if (supportedHiveMetastoreVersionsBuilder_ == null) {
        supportedHiveMetastoreVersionsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.metastore.v1beta.LocationMetadata.HiveMetastoreVersion,
                com.google.cloud.metastore.v1beta.LocationMetadata.HiveMetastoreVersion.Builder,
                com.google.cloud.metastore.v1beta.LocationMetadata.HiveMetastoreVersionOrBuilder>(
                supportedHiveMetastoreVersions_,
                ((bitField0_ & 0x00000001) != 0),
                getParentForChildren(),
                isClean());
        supportedHiveMetastoreVersions_ = null;
      }
      return supportedHiveMetastoreVersionsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.metastore.v1beta.LocationMetadata)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.metastore.v1beta.LocationMetadata)
  private static final com.google.cloud.metastore.v1beta.LocationMetadata DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.metastore.v1beta.LocationMetadata();
  }

  public static com.google.cloud.metastore.v1beta.LocationMetadata getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<LocationMetadata> PARSER =
      new com.google.protobuf.AbstractParser<LocationMetadata>() {
        @java.lang.Override
        public LocationMetadata parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<LocationMetadata> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<LocationMetadata> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.metastore.v1beta.LocationMetadata getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
