/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/metastore/v1beta/metastore.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.metastore.v1beta;

/**
 *
 *
 * <pre>
 * Request message for
 * [DataprocMetastore.CreateMetadataImport][google.cloud.metastore.v1beta.DataprocMetastore.CreateMetadataImport].
 * </pre>
 *
 * Protobuf type {@code google.cloud.metastore.v1beta.CreateMetadataImportRequest}
 */
public final class CreateMetadataImportRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.metastore.v1beta.CreateMetadataImportRequest)
    CreateMetadataImportRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use CreateMetadataImportRequest.newBuilder() to construct.
  private CreateMetadataImportRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private CreateMetadataImportRequest() {
    parent_ = "";
    metadataImportId_ = "";
    requestId_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new CreateMetadataImportRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.metastore.v1beta.MetastoreProto
        .internal_static_google_cloud_metastore_v1beta_CreateMetadataImportRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.metastore.v1beta.MetastoreProto
        .internal_static_google_cloud_metastore_v1beta_CreateMetadataImportRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.metastore.v1beta.CreateMetadataImportRequest.class,
            com.google.cloud.metastore.v1beta.CreateMetadataImportRequest.Builder.class);
  }

  private int bitField0_;
  public static final int PARENT_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object parent_ = "";
  /**
   *
   *
   * <pre>
   * Required. The relative resource name of the service in which to create a
   * metastore import, in the following form:
   *
   * `projects/{project_number}/locations/{location_id}/services/{service_id}`.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The parent.
   */
  @java.lang.Override
  public java.lang.String getParent() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parent_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The relative resource name of the service in which to create a
   * metastore import, in the following form:
   *
   * `projects/{project_number}/locations/{location_id}/services/{service_id}`.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for parent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentBytes() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int METADATA_IMPORT_ID_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object metadataImportId_ = "";
  /**
   *
   *
   * <pre>
   * Required. The ID of the metadata import, which is used as the final
   * component of the metadata import's name.
   *
   * This value must be between 1 and 64 characters long, begin with a letter,
   * end with a letter or number, and consist of alpha-numeric ASCII characters
   * or hyphens.
   * </pre>
   *
   * <code>string metadata_import_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The metadataImportId.
   */
  @java.lang.Override
  public java.lang.String getMetadataImportId() {
    java.lang.Object ref = metadataImportId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      metadataImportId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The ID of the metadata import, which is used as the final
   * component of the metadata import's name.
   *
   * This value must be between 1 and 64 characters long, begin with a letter,
   * end with a letter or number, and consist of alpha-numeric ASCII characters
   * or hyphens.
   * </pre>
   *
   * <code>string metadata_import_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for metadataImportId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getMetadataImportIdBytes() {
    java.lang.Object ref = metadataImportId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      metadataImportId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int METADATA_IMPORT_FIELD_NUMBER = 3;
  private com.google.cloud.metastore.v1beta.MetadataImport metadataImport_;
  /**
   *
   *
   * <pre>
   * Required. The metadata import to create. The `name` field is ignored. The
   * ID of the created metadata import must be provided in the request's
   * `metadata_import_id` field.
   * </pre>
   *
   * <code>
   * .google.cloud.metastore.v1beta.MetadataImport metadata_import = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the metadataImport field is set.
   */
  @java.lang.Override
  public boolean hasMetadataImport() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Required. The metadata import to create. The `name` field is ignored. The
   * ID of the created metadata import must be provided in the request's
   * `metadata_import_id` field.
   * </pre>
   *
   * <code>
   * .google.cloud.metastore.v1beta.MetadataImport metadata_import = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The metadataImport.
   */
  @java.lang.Override
  public com.google.cloud.metastore.v1beta.MetadataImport getMetadataImport() {
    return metadataImport_ == null
        ? com.google.cloud.metastore.v1beta.MetadataImport.getDefaultInstance()
        : metadataImport_;
  }
  /**
   *
   *
   * <pre>
   * Required. The metadata import to create. The `name` field is ignored. The
   * ID of the created metadata import must be provided in the request's
   * `metadata_import_id` field.
   * </pre>
   *
   * <code>
   * .google.cloud.metastore.v1beta.MetadataImport metadata_import = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.metastore.v1beta.MetadataImportOrBuilder getMetadataImportOrBuilder() {
    return metadataImport_ == null
        ? com.google.cloud.metastore.v1beta.MetadataImport.getDefaultInstance()
        : metadataImport_;
  }

  public static final int REQUEST_ID_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object requestId_ = "";
  /**
   *
   *
   * <pre>
   * Optional. A request ID. Specify a unique request ID to allow the server to
   * ignore the request if it has completed. The server will ignore subsequent
   * requests that provide a duplicate request ID for at least 60 minutes after
   * the first request.
   *
   * For example, if an initial request times out, followed by another request
   * with the same request ID, the server ignores the second request to prevent
   * the creation of duplicate commitments.
   *
   * The request ID must be a valid
   * [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier#Format)
   * A zero UUID (00000000-0000-0000-0000-000000000000) is not supported.
   * </pre>
   *
   * <code>string request_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The requestId.
   */
  @java.lang.Override
  public java.lang.String getRequestId() {
    java.lang.Object ref = requestId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      requestId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. A request ID. Specify a unique request ID to allow the server to
   * ignore the request if it has completed. The server will ignore subsequent
   * requests that provide a duplicate request ID for at least 60 minutes after
   * the first request.
   *
   * For example, if an initial request times out, followed by another request
   * with the same request ID, the server ignores the second request to prevent
   * the creation of duplicate commitments.
   *
   * The request ID must be a valid
   * [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier#Format)
   * A zero UUID (00000000-0000-0000-0000-000000000000) is not supported.
   * </pre>
   *
   * <code>string request_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for requestId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRequestIdBytes() {
    java.lang.Object ref = requestId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      requestId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, parent_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(metadataImportId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, metadataImportId_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(3, getMetadataImport());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(requestId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, requestId_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, parent_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(metadataImportId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, metadataImportId_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getMetadataImport());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(requestId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, requestId_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.metastore.v1beta.CreateMetadataImportRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.metastore.v1beta.CreateMetadataImportRequest other =
        (com.google.cloud.metastore.v1beta.CreateMetadataImportRequest) obj;

    if (!getParent().equals(other.getParent())) return false;
    if (!getMetadataImportId().equals(other.getMetadataImportId())) return false;
    if (hasMetadataImport() != other.hasMetadataImport()) return false;
    if (hasMetadataImport()) {
      if (!getMetadataImport().equals(other.getMetadataImport())) return false;
    }
    if (!getRequestId().equals(other.getRequestId())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PARENT_FIELD_NUMBER;
    hash = (53 * hash) + getParent().hashCode();
    hash = (37 * hash) + METADATA_IMPORT_ID_FIELD_NUMBER;
    hash = (53 * hash) + getMetadataImportId().hashCode();
    if (hasMetadataImport()) {
      hash = (37 * hash) + METADATA_IMPORT_FIELD_NUMBER;
      hash = (53 * hash) + getMetadataImport().hashCode();
    }
    hash = (37 * hash) + REQUEST_ID_FIELD_NUMBER;
    hash = (53 * hash) + getRequestId().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.metastore.v1beta.CreateMetadataImportRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.metastore.v1beta.CreateMetadataImportRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.metastore.v1beta.CreateMetadataImportRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.metastore.v1beta.CreateMetadataImportRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.metastore.v1beta.CreateMetadataImportRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.metastore.v1beta.CreateMetadataImportRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.metastore.v1beta.CreateMetadataImportRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.metastore.v1beta.CreateMetadataImportRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.metastore.v1beta.CreateMetadataImportRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.metastore.v1beta.CreateMetadataImportRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.metastore.v1beta.CreateMetadataImportRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.metastore.v1beta.CreateMetadataImportRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.metastore.v1beta.CreateMetadataImportRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request message for
   * [DataprocMetastore.CreateMetadataImport][google.cloud.metastore.v1beta.DataprocMetastore.CreateMetadataImport].
   * </pre>
   *
   * Protobuf type {@code google.cloud.metastore.v1beta.CreateMetadataImportRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.metastore.v1beta.CreateMetadataImportRequest)
      com.google.cloud.metastore.v1beta.CreateMetadataImportRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.metastore.v1beta.MetastoreProto
          .internal_static_google_cloud_metastore_v1beta_CreateMetadataImportRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.metastore.v1beta.MetastoreProto
          .internal_static_google_cloud_metastore_v1beta_CreateMetadataImportRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.metastore.v1beta.CreateMetadataImportRequest.class,
              com.google.cloud.metastore.v1beta.CreateMetadataImportRequest.Builder.class);
    }

    // Construct using com.google.cloud.metastore.v1beta.CreateMetadataImportRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getMetadataImportFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      parent_ = "";
      metadataImportId_ = "";
      metadataImport_ = null;
      if (metadataImportBuilder_ != null) {
        metadataImportBuilder_.dispose();
        metadataImportBuilder_ = null;
      }
      requestId_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.metastore.v1beta.MetastoreProto
          .internal_static_google_cloud_metastore_v1beta_CreateMetadataImportRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.metastore.v1beta.CreateMetadataImportRequest
        getDefaultInstanceForType() {
      return com.google.cloud.metastore.v1beta.CreateMetadataImportRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.metastore.v1beta.CreateMetadataImportRequest build() {
      com.google.cloud.metastore.v1beta.CreateMetadataImportRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.metastore.v1beta.CreateMetadataImportRequest buildPartial() {
      com.google.cloud.metastore.v1beta.CreateMetadataImportRequest result =
          new com.google.cloud.metastore.v1beta.CreateMetadataImportRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.cloud.metastore.v1beta.CreateMetadataImportRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.parent_ = parent_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.metadataImportId_ = metadataImportId_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.metadataImport_ =
            metadataImportBuilder_ == null ? metadataImport_ : metadataImportBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.requestId_ = requestId_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.metastore.v1beta.CreateMetadataImportRequest) {
        return mergeFrom((com.google.cloud.metastore.v1beta.CreateMetadataImportRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.metastore.v1beta.CreateMetadataImportRequest other) {
      if (other
          == com.google.cloud.metastore.v1beta.CreateMetadataImportRequest.getDefaultInstance())
        return this;
      if (!other.getParent().isEmpty()) {
        parent_ = other.parent_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getMetadataImportId().isEmpty()) {
        metadataImportId_ = other.metadataImportId_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasMetadataImport()) {
        mergeMetadataImport(other.getMetadataImport());
      }
      if (!other.getRequestId().isEmpty()) {
        requestId_ = other.requestId_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                parent_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                metadataImportId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getMetadataImportFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                requestId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object parent_ = "";
    /**
     *
     *
     * <pre>
     * Required. The relative resource name of the service in which to create a
     * metastore import, in the following form:
     *
     * `projects/{project_number}/locations/{location_id}/services/{service_id}`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The parent.
     */
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The relative resource name of the service in which to create a
     * metastore import, in the following form:
     *
     * `projects/{project_number}/locations/{location_id}/services/{service_id}`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for parent.
     */
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The relative resource name of the service in which to create a
     * metastore import, in the following form:
     *
     * `projects/{project_number}/locations/{location_id}/services/{service_id}`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The parent to set.
     * @return This builder for chaining.
     */
    public Builder setParent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The relative resource name of the service in which to create a
     * metastore import, in the following form:
     *
     * `projects/{project_number}/locations/{location_id}/services/{service_id}`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParent() {
      parent_ = getDefaultInstance().getParent();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The relative resource name of the service in which to create a
     * metastore import, in the following form:
     *
     * `projects/{project_number}/locations/{location_id}/services/{service_id}`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for parent to set.
     * @return This builder for chaining.
     */
    public Builder setParentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object metadataImportId_ = "";
    /**
     *
     *
     * <pre>
     * Required. The ID of the metadata import, which is used as the final
     * component of the metadata import's name.
     *
     * This value must be between 1 and 64 characters long, begin with a letter,
     * end with a letter or number, and consist of alpha-numeric ASCII characters
     * or hyphens.
     * </pre>
     *
     * <code>string metadata_import_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The metadataImportId.
     */
    public java.lang.String getMetadataImportId() {
      java.lang.Object ref = metadataImportId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        metadataImportId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The ID of the metadata import, which is used as the final
     * component of the metadata import's name.
     *
     * This value must be between 1 and 64 characters long, begin with a letter,
     * end with a letter or number, and consist of alpha-numeric ASCII characters
     * or hyphens.
     * </pre>
     *
     * <code>string metadata_import_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for metadataImportId.
     */
    public com.google.protobuf.ByteString getMetadataImportIdBytes() {
      java.lang.Object ref = metadataImportId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        metadataImportId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The ID of the metadata import, which is used as the final
     * component of the metadata import's name.
     *
     * This value must be between 1 and 64 characters long, begin with a letter,
     * end with a letter or number, and consist of alpha-numeric ASCII characters
     * or hyphens.
     * </pre>
     *
     * <code>string metadata_import_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The metadataImportId to set.
     * @return This builder for chaining.
     */
    public Builder setMetadataImportId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      metadataImportId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The ID of the metadata import, which is used as the final
     * component of the metadata import's name.
     *
     * This value must be between 1 and 64 characters long, begin with a letter,
     * end with a letter or number, and consist of alpha-numeric ASCII characters
     * or hyphens.
     * </pre>
     *
     * <code>string metadata_import_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMetadataImportId() {
      metadataImportId_ = getDefaultInstance().getMetadataImportId();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The ID of the metadata import, which is used as the final
     * component of the metadata import's name.
     *
     * This value must be between 1 and 64 characters long, begin with a letter,
     * end with a letter or number, and consist of alpha-numeric ASCII characters
     * or hyphens.
     * </pre>
     *
     * <code>string metadata_import_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for metadataImportId to set.
     * @return This builder for chaining.
     */
    public Builder setMetadataImportIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      metadataImportId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.cloud.metastore.v1beta.MetadataImport metadataImport_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.metastore.v1beta.MetadataImport,
            com.google.cloud.metastore.v1beta.MetadataImport.Builder,
            com.google.cloud.metastore.v1beta.MetadataImportOrBuilder>
        metadataImportBuilder_;
    /**
     *
     *
     * <pre>
     * Required. The metadata import to create. The `name` field is ignored. The
     * ID of the created metadata import must be provided in the request's
     * `metadata_import_id` field.
     * </pre>
     *
     * <code>
     * .google.cloud.metastore.v1beta.MetadataImport metadata_import = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the metadataImport field is set.
     */
    public boolean hasMetadataImport() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. The metadata import to create. The `name` field is ignored. The
     * ID of the created metadata import must be provided in the request's
     * `metadata_import_id` field.
     * </pre>
     *
     * <code>
     * .google.cloud.metastore.v1beta.MetadataImport metadata_import = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The metadataImport.
     */
    public com.google.cloud.metastore.v1beta.MetadataImport getMetadataImport() {
      if (metadataImportBuilder_ == null) {
        return metadataImport_ == null
            ? com.google.cloud.metastore.v1beta.MetadataImport.getDefaultInstance()
            : metadataImport_;
      } else {
        return metadataImportBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The metadata import to create. The `name` field is ignored. The
     * ID of the created metadata import must be provided in the request's
     * `metadata_import_id` field.
     * </pre>
     *
     * <code>
     * .google.cloud.metastore.v1beta.MetadataImport metadata_import = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setMetadataImport(com.google.cloud.metastore.v1beta.MetadataImport value) {
      if (metadataImportBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        metadataImport_ = value;
      } else {
        metadataImportBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The metadata import to create. The `name` field is ignored. The
     * ID of the created metadata import must be provided in the request's
     * `metadata_import_id` field.
     * </pre>
     *
     * <code>
     * .google.cloud.metastore.v1beta.MetadataImport metadata_import = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setMetadataImport(
        com.google.cloud.metastore.v1beta.MetadataImport.Builder builderForValue) {
      if (metadataImportBuilder_ == null) {
        metadataImport_ = builderForValue.build();
      } else {
        metadataImportBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The metadata import to create. The `name` field is ignored. The
     * ID of the created metadata import must be provided in the request's
     * `metadata_import_id` field.
     * </pre>
     *
     * <code>
     * .google.cloud.metastore.v1beta.MetadataImport metadata_import = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeMetadataImport(com.google.cloud.metastore.v1beta.MetadataImport value) {
      if (metadataImportBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && metadataImport_ != null
            && metadataImport_
                != com.google.cloud.metastore.v1beta.MetadataImport.getDefaultInstance()) {
          getMetadataImportBuilder().mergeFrom(value);
        } else {
          metadataImport_ = value;
        }
      } else {
        metadataImportBuilder_.mergeFrom(value);
      }
      if (metadataImport_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The metadata import to create. The `name` field is ignored. The
     * ID of the created metadata import must be provided in the request's
     * `metadata_import_id` field.
     * </pre>
     *
     * <code>
     * .google.cloud.metastore.v1beta.MetadataImport metadata_import = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearMetadataImport() {
      bitField0_ = (bitField0_ & ~0x00000004);
      metadataImport_ = null;
      if (metadataImportBuilder_ != null) {
        metadataImportBuilder_.dispose();
        metadataImportBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The metadata import to create. The `name` field is ignored. The
     * ID of the created metadata import must be provided in the request's
     * `metadata_import_id` field.
     * </pre>
     *
     * <code>
     * .google.cloud.metastore.v1beta.MetadataImport metadata_import = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.metastore.v1beta.MetadataImport.Builder getMetadataImportBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getMetadataImportFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. The metadata import to create. The `name` field is ignored. The
     * ID of the created metadata import must be provided in the request's
     * `metadata_import_id` field.
     * </pre>
     *
     * <code>
     * .google.cloud.metastore.v1beta.MetadataImport metadata_import = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.metastore.v1beta.MetadataImportOrBuilder getMetadataImportOrBuilder() {
      if (metadataImportBuilder_ != null) {
        return metadataImportBuilder_.getMessageOrBuilder();
      } else {
        return metadataImport_ == null
            ? com.google.cloud.metastore.v1beta.MetadataImport.getDefaultInstance()
            : metadataImport_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The metadata import to create. The `name` field is ignored. The
     * ID of the created metadata import must be provided in the request's
     * `metadata_import_id` field.
     * </pre>
     *
     * <code>
     * .google.cloud.metastore.v1beta.MetadataImport metadata_import = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.metastore.v1beta.MetadataImport,
            com.google.cloud.metastore.v1beta.MetadataImport.Builder,
            com.google.cloud.metastore.v1beta.MetadataImportOrBuilder>
        getMetadataImportFieldBuilder() {
      if (metadataImportBuilder_ == null) {
        metadataImportBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.metastore.v1beta.MetadataImport,
                com.google.cloud.metastore.v1beta.MetadataImport.Builder,
                com.google.cloud.metastore.v1beta.MetadataImportOrBuilder>(
                getMetadataImport(), getParentForChildren(), isClean());
        metadataImport_ = null;
      }
      return metadataImportBuilder_;
    }

    private java.lang.Object requestId_ = "";
    /**
     *
     *
     * <pre>
     * Optional. A request ID. Specify a unique request ID to allow the server to
     * ignore the request if it has completed. The server will ignore subsequent
     * requests that provide a duplicate request ID for at least 60 minutes after
     * the first request.
     *
     * For example, if an initial request times out, followed by another request
     * with the same request ID, the server ignores the second request to prevent
     * the creation of duplicate commitments.
     *
     * The request ID must be a valid
     * [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier#Format)
     * A zero UUID (00000000-0000-0000-0000-000000000000) is not supported.
     * </pre>
     *
     * <code>string request_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The requestId.
     */
    public java.lang.String getRequestId() {
      java.lang.Object ref = requestId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        requestId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A request ID. Specify a unique request ID to allow the server to
     * ignore the request if it has completed. The server will ignore subsequent
     * requests that provide a duplicate request ID for at least 60 minutes after
     * the first request.
     *
     * For example, if an initial request times out, followed by another request
     * with the same request ID, the server ignores the second request to prevent
     * the creation of duplicate commitments.
     *
     * The request ID must be a valid
     * [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier#Format)
     * A zero UUID (00000000-0000-0000-0000-000000000000) is not supported.
     * </pre>
     *
     * <code>string request_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for requestId.
     */
    public com.google.protobuf.ByteString getRequestIdBytes() {
      java.lang.Object ref = requestId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        requestId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A request ID. Specify a unique request ID to allow the server to
     * ignore the request if it has completed. The server will ignore subsequent
     * requests that provide a duplicate request ID for at least 60 minutes after
     * the first request.
     *
     * For example, if an initial request times out, followed by another request
     * with the same request ID, the server ignores the second request to prevent
     * the creation of duplicate commitments.
     *
     * The request ID must be a valid
     * [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier#Format)
     * A zero UUID (00000000-0000-0000-0000-000000000000) is not supported.
     * </pre>
     *
     * <code>string request_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The requestId to set.
     * @return This builder for chaining.
     */
    public Builder setRequestId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      requestId_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A request ID. Specify a unique request ID to allow the server to
     * ignore the request if it has completed. The server will ignore subsequent
     * requests that provide a duplicate request ID for at least 60 minutes after
     * the first request.
     *
     * For example, if an initial request times out, followed by another request
     * with the same request ID, the server ignores the second request to prevent
     * the creation of duplicate commitments.
     *
     * The request ID must be a valid
     * [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier#Format)
     * A zero UUID (00000000-0000-0000-0000-000000000000) is not supported.
     * </pre>
     *
     * <code>string request_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRequestId() {
      requestId_ = getDefaultInstance().getRequestId();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A request ID. Specify a unique request ID to allow the server to
     * ignore the request if it has completed. The server will ignore subsequent
     * requests that provide a duplicate request ID for at least 60 minutes after
     * the first request.
     *
     * For example, if an initial request times out, followed by another request
     * with the same request ID, the server ignores the second request to prevent
     * the creation of duplicate commitments.
     *
     * The request ID must be a valid
     * [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier#Format)
     * A zero UUID (00000000-0000-0000-0000-000000000000) is not supported.
     * </pre>
     *
     * <code>string request_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for requestId to set.
     * @return This builder for chaining.
     */
    public Builder setRequestIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      requestId_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.metastore.v1beta.CreateMetadataImportRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.metastore.v1beta.CreateMetadataImportRequest)
  private static final com.google.cloud.metastore.v1beta.CreateMetadataImportRequest
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.metastore.v1beta.CreateMetadataImportRequest();
  }

  public static com.google.cloud.metastore.v1beta.CreateMetadataImportRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CreateMetadataImportRequest> PARSER =
      new com.google.protobuf.AbstractParser<CreateMetadataImportRequest>() {
        @java.lang.Override
        public CreateMetadataImportRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<CreateMetadataImportRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CreateMetadataImportRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.metastore.v1beta.CreateMetadataImportRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
