/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/metastore/v1beta/metastore.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.metastore.v1beta;

/**
 *
 *
 * <pre>
 * Request message for
 * [DataprocMetastore.ExportMetadata][google.cloud.metastore.v1beta.DataprocMetastore.ExportMetadata].
 * </pre>
 *
 * Protobuf type {@code google.cloud.metastore.v1beta.ExportMetadataRequest}
 */
public final class ExportMetadataRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.metastore.v1beta.ExportMetadataRequest)
    ExportMetadataRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ExportMetadataRequest.newBuilder() to construct.
  private ExportMetadataRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ExportMetadataRequest() {
    service_ = "";
    requestId_ = "";
    databaseDumpType_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ExportMetadataRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.metastore.v1beta.MetastoreProto
        .internal_static_google_cloud_metastore_v1beta_ExportMetadataRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.metastore.v1beta.MetastoreProto
        .internal_static_google_cloud_metastore_v1beta_ExportMetadataRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.metastore.v1beta.ExportMetadataRequest.class,
            com.google.cloud.metastore.v1beta.ExportMetadataRequest.Builder.class);
  }

  private int destinationCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object destination_;

  public enum DestinationCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    DESTINATION_GCS_FOLDER(2),
    DESTINATION_NOT_SET(0);
    private final int value;

    private DestinationCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static DestinationCase valueOf(int value) {
      return forNumber(value);
    }

    public static DestinationCase forNumber(int value) {
      switch (value) {
        case 2:
          return DESTINATION_GCS_FOLDER;
        case 0:
          return DESTINATION_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public DestinationCase getDestinationCase() {
    return DestinationCase.forNumber(destinationCase_);
  }

  public static final int DESTINATION_GCS_FOLDER_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * A Cloud Storage URI of a folder, in the format
   * `gs://&lt;bucket_name&gt;/&lt;path_inside_bucket&gt;`. A sub-folder
   * `&lt;export_folder&gt;` containing exported files will be created below it.
   * </pre>
   *
   * <code>string destination_gcs_folder = 2;</code>
   *
   * @return Whether the destinationGcsFolder field is set.
   */
  public boolean hasDestinationGcsFolder() {
    return destinationCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * A Cloud Storage URI of a folder, in the format
   * `gs://&lt;bucket_name&gt;/&lt;path_inside_bucket&gt;`. A sub-folder
   * `&lt;export_folder&gt;` containing exported files will be created below it.
   * </pre>
   *
   * <code>string destination_gcs_folder = 2;</code>
   *
   * @return The destinationGcsFolder.
   */
  public java.lang.String getDestinationGcsFolder() {
    java.lang.Object ref = "";
    if (destinationCase_ == 2) {
      ref = destination_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (destinationCase_ == 2) {
        destination_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A Cloud Storage URI of a folder, in the format
   * `gs://&lt;bucket_name&gt;/&lt;path_inside_bucket&gt;`. A sub-folder
   * `&lt;export_folder&gt;` containing exported files will be created below it.
   * </pre>
   *
   * <code>string destination_gcs_folder = 2;</code>
   *
   * @return The bytes for destinationGcsFolder.
   */
  public com.google.protobuf.ByteString getDestinationGcsFolderBytes() {
    java.lang.Object ref = "";
    if (destinationCase_ == 2) {
      ref = destination_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (destinationCase_ == 2) {
        destination_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SERVICE_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object service_ = "";
  /**
   *
   *
   * <pre>
   * Required. The relative resource name of the metastore service to run
   * export, in the following form:
   *
   * `projects/{project_id}/locations/{location_id}/services/{service_id}`.
   * </pre>
   *
   * <code>
   * string service = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The service.
   */
  @java.lang.Override
  public java.lang.String getService() {
    java.lang.Object ref = service_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      service_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The relative resource name of the metastore service to run
   * export, in the following form:
   *
   * `projects/{project_id}/locations/{location_id}/services/{service_id}`.
   * </pre>
   *
   * <code>
   * string service = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for service.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getServiceBytes() {
    java.lang.Object ref = service_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      service_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int REQUEST_ID_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object requestId_ = "";
  /**
   *
   *
   * <pre>
   * Optional. A request ID. Specify a unique request ID to allow the server to
   * ignore the request if it has completed. The server will ignore subsequent
   * requests that provide a duplicate request ID for at least 60 minutes after
   * the first request.
   *
   * For example, if an initial request times out, followed by another request
   * with the same request ID, the server ignores the second request to prevent
   * the creation of duplicate commitments.
   *
   * The request ID must be a valid
   * [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier#Format).
   * A zero UUID (00000000-0000-0000-0000-000000000000) is not supported.
   * </pre>
   *
   * <code>string request_id = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The requestId.
   */
  @java.lang.Override
  public java.lang.String getRequestId() {
    java.lang.Object ref = requestId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      requestId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. A request ID. Specify a unique request ID to allow the server to
   * ignore the request if it has completed. The server will ignore subsequent
   * requests that provide a duplicate request ID for at least 60 minutes after
   * the first request.
   *
   * For example, if an initial request times out, followed by another request
   * with the same request ID, the server ignores the second request to prevent
   * the creation of duplicate commitments.
   *
   * The request ID must be a valid
   * [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier#Format).
   * A zero UUID (00000000-0000-0000-0000-000000000000) is not supported.
   * </pre>
   *
   * <code>string request_id = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for requestId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRequestIdBytes() {
    java.lang.Object ref = requestId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      requestId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DATABASE_DUMP_TYPE_FIELD_NUMBER = 4;
  private int databaseDumpType_ = 0;
  /**
   *
   *
   * <pre>
   * Optional. The type of the database dump. If unspecified, defaults to
   * `MYSQL`.
   * </pre>
   *
   * <code>
   * .google.cloud.metastore.v1beta.DatabaseDumpSpec.Type database_dump_type = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The enum numeric value on the wire for databaseDumpType.
   */
  @java.lang.Override
  public int getDatabaseDumpTypeValue() {
    return databaseDumpType_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The type of the database dump. If unspecified, defaults to
   * `MYSQL`.
   * </pre>
   *
   * <code>
   * .google.cloud.metastore.v1beta.DatabaseDumpSpec.Type database_dump_type = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The databaseDumpType.
   */
  @java.lang.Override
  public com.google.cloud.metastore.v1beta.DatabaseDumpSpec.Type getDatabaseDumpType() {
    com.google.cloud.metastore.v1beta.DatabaseDumpSpec.Type result =
        com.google.cloud.metastore.v1beta.DatabaseDumpSpec.Type.forNumber(databaseDumpType_);
    return result == null
        ? com.google.cloud.metastore.v1beta.DatabaseDumpSpec.Type.UNRECOGNIZED
        : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(service_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, service_);
    }
    if (destinationCase_ == 2) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, destination_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(requestId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, requestId_);
    }
    if (databaseDumpType_
        != com.google.cloud.metastore.v1beta.DatabaseDumpSpec.Type.TYPE_UNSPECIFIED.getNumber()) {
      output.writeEnum(4, databaseDumpType_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(service_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, service_);
    }
    if (destinationCase_ == 2) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, destination_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(requestId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, requestId_);
    }
    if (databaseDumpType_
        != com.google.cloud.metastore.v1beta.DatabaseDumpSpec.Type.TYPE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, databaseDumpType_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.metastore.v1beta.ExportMetadataRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.metastore.v1beta.ExportMetadataRequest other =
        (com.google.cloud.metastore.v1beta.ExportMetadataRequest) obj;

    if (!getService().equals(other.getService())) return false;
    if (!getRequestId().equals(other.getRequestId())) return false;
    if (databaseDumpType_ != other.databaseDumpType_) return false;
    if (!getDestinationCase().equals(other.getDestinationCase())) return false;
    switch (destinationCase_) {
      case 2:
        if (!getDestinationGcsFolder().equals(other.getDestinationGcsFolder())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + SERVICE_FIELD_NUMBER;
    hash = (53 * hash) + getService().hashCode();
    hash = (37 * hash) + REQUEST_ID_FIELD_NUMBER;
    hash = (53 * hash) + getRequestId().hashCode();
    hash = (37 * hash) + DATABASE_DUMP_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + databaseDumpType_;
    switch (destinationCase_) {
      case 2:
        hash = (37 * hash) + DESTINATION_GCS_FOLDER_FIELD_NUMBER;
        hash = (53 * hash) + getDestinationGcsFolder().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.metastore.v1beta.ExportMetadataRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.metastore.v1beta.ExportMetadataRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.metastore.v1beta.ExportMetadataRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.metastore.v1beta.ExportMetadataRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.metastore.v1beta.ExportMetadataRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.metastore.v1beta.ExportMetadataRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.metastore.v1beta.ExportMetadataRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.metastore.v1beta.ExportMetadataRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.metastore.v1beta.ExportMetadataRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.metastore.v1beta.ExportMetadataRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.metastore.v1beta.ExportMetadataRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.metastore.v1beta.ExportMetadataRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.metastore.v1beta.ExportMetadataRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request message for
   * [DataprocMetastore.ExportMetadata][google.cloud.metastore.v1beta.DataprocMetastore.ExportMetadata].
   * </pre>
   *
   * Protobuf type {@code google.cloud.metastore.v1beta.ExportMetadataRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.metastore.v1beta.ExportMetadataRequest)
      com.google.cloud.metastore.v1beta.ExportMetadataRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.metastore.v1beta.MetastoreProto
          .internal_static_google_cloud_metastore_v1beta_ExportMetadataRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.metastore.v1beta.MetastoreProto
          .internal_static_google_cloud_metastore_v1beta_ExportMetadataRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.metastore.v1beta.ExportMetadataRequest.class,
              com.google.cloud.metastore.v1beta.ExportMetadataRequest.Builder.class);
    }

    // Construct using com.google.cloud.metastore.v1beta.ExportMetadataRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      service_ = "";
      requestId_ = "";
      databaseDumpType_ = 0;
      destinationCase_ = 0;
      destination_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.metastore.v1beta.MetastoreProto
          .internal_static_google_cloud_metastore_v1beta_ExportMetadataRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.metastore.v1beta.ExportMetadataRequest getDefaultInstanceForType() {
      return com.google.cloud.metastore.v1beta.ExportMetadataRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.metastore.v1beta.ExportMetadataRequest build() {
      com.google.cloud.metastore.v1beta.ExportMetadataRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.metastore.v1beta.ExportMetadataRequest buildPartial() {
      com.google.cloud.metastore.v1beta.ExportMetadataRequest result =
          new com.google.cloud.metastore.v1beta.ExportMetadataRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.metastore.v1beta.ExportMetadataRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.service_ = service_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.requestId_ = requestId_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.databaseDumpType_ = databaseDumpType_;
      }
    }

    private void buildPartialOneofs(
        com.google.cloud.metastore.v1beta.ExportMetadataRequest result) {
      result.destinationCase_ = destinationCase_;
      result.destination_ = this.destination_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.metastore.v1beta.ExportMetadataRequest) {
        return mergeFrom((com.google.cloud.metastore.v1beta.ExportMetadataRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.metastore.v1beta.ExportMetadataRequest other) {
      if (other == com.google.cloud.metastore.v1beta.ExportMetadataRequest.getDefaultInstance())
        return this;
      if (!other.getService().isEmpty()) {
        service_ = other.service_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getRequestId().isEmpty()) {
        requestId_ = other.requestId_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.databaseDumpType_ != 0) {
        setDatabaseDumpTypeValue(other.getDatabaseDumpTypeValue());
      }
      switch (other.getDestinationCase()) {
        case DESTINATION_GCS_FOLDER:
          {
            destinationCase_ = 2;
            destination_ = other.destination_;
            onChanged();
            break;
          }
        case DESTINATION_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                service_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 10
            case 18:
              {
                java.lang.String s = input.readStringRequireUtf8();
                destinationCase_ = 2;
                destination_ = s;
                break;
              } // case 18
            case 26:
              {
                requestId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 32:
              {
                databaseDumpType_ = input.readEnum();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int destinationCase_ = 0;
    private java.lang.Object destination_;

    public DestinationCase getDestinationCase() {
      return DestinationCase.forNumber(destinationCase_);
    }

    public Builder clearDestination() {
      destinationCase_ = 0;
      destination_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    /**
     *
     *
     * <pre>
     * A Cloud Storage URI of a folder, in the format
     * `gs://&lt;bucket_name&gt;/&lt;path_inside_bucket&gt;`. A sub-folder
     * `&lt;export_folder&gt;` containing exported files will be created below it.
     * </pre>
     *
     * <code>string destination_gcs_folder = 2;</code>
     *
     * @return Whether the destinationGcsFolder field is set.
     */
    @java.lang.Override
    public boolean hasDestinationGcsFolder() {
      return destinationCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * A Cloud Storage URI of a folder, in the format
     * `gs://&lt;bucket_name&gt;/&lt;path_inside_bucket&gt;`. A sub-folder
     * `&lt;export_folder&gt;` containing exported files will be created below it.
     * </pre>
     *
     * <code>string destination_gcs_folder = 2;</code>
     *
     * @return The destinationGcsFolder.
     */
    @java.lang.Override
    public java.lang.String getDestinationGcsFolder() {
      java.lang.Object ref = "";
      if (destinationCase_ == 2) {
        ref = destination_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (destinationCase_ == 2) {
          destination_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A Cloud Storage URI of a folder, in the format
     * `gs://&lt;bucket_name&gt;/&lt;path_inside_bucket&gt;`. A sub-folder
     * `&lt;export_folder&gt;` containing exported files will be created below it.
     * </pre>
     *
     * <code>string destination_gcs_folder = 2;</code>
     *
     * @return The bytes for destinationGcsFolder.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getDestinationGcsFolderBytes() {
      java.lang.Object ref = "";
      if (destinationCase_ == 2) {
        ref = destination_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (destinationCase_ == 2) {
          destination_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A Cloud Storage URI of a folder, in the format
     * `gs://&lt;bucket_name&gt;/&lt;path_inside_bucket&gt;`. A sub-folder
     * `&lt;export_folder&gt;` containing exported files will be created below it.
     * </pre>
     *
     * <code>string destination_gcs_folder = 2;</code>
     *
     * @param value The destinationGcsFolder to set.
     * @return This builder for chaining.
     */
    public Builder setDestinationGcsFolder(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      destinationCase_ = 2;
      destination_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A Cloud Storage URI of a folder, in the format
     * `gs://&lt;bucket_name&gt;/&lt;path_inside_bucket&gt;`. A sub-folder
     * `&lt;export_folder&gt;` containing exported files will be created below it.
     * </pre>
     *
     * <code>string destination_gcs_folder = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDestinationGcsFolder() {
      if (destinationCase_ == 2) {
        destinationCase_ = 0;
        destination_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A Cloud Storage URI of a folder, in the format
     * `gs://&lt;bucket_name&gt;/&lt;path_inside_bucket&gt;`. A sub-folder
     * `&lt;export_folder&gt;` containing exported files will be created below it.
     * </pre>
     *
     * <code>string destination_gcs_folder = 2;</code>
     *
     * @param value The bytes for destinationGcsFolder to set.
     * @return This builder for chaining.
     */
    public Builder setDestinationGcsFolderBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      destinationCase_ = 2;
      destination_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object service_ = "";
    /**
     *
     *
     * <pre>
     * Required. The relative resource name of the metastore service to run
     * export, in the following form:
     *
     * `projects/{project_id}/locations/{location_id}/services/{service_id}`.
     * </pre>
     *
     * <code>
     * string service = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The service.
     */
    public java.lang.String getService() {
      java.lang.Object ref = service_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        service_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The relative resource name of the metastore service to run
     * export, in the following form:
     *
     * `projects/{project_id}/locations/{location_id}/services/{service_id}`.
     * </pre>
     *
     * <code>
     * string service = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for service.
     */
    public com.google.protobuf.ByteString getServiceBytes() {
      java.lang.Object ref = service_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        service_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The relative resource name of the metastore service to run
     * export, in the following form:
     *
     * `projects/{project_id}/locations/{location_id}/services/{service_id}`.
     * </pre>
     *
     * <code>
     * string service = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The service to set.
     * @return This builder for chaining.
     */
    public Builder setService(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      service_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The relative resource name of the metastore service to run
     * export, in the following form:
     *
     * `projects/{project_id}/locations/{location_id}/services/{service_id}`.
     * </pre>
     *
     * <code>
     * string service = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearService() {
      service_ = getDefaultInstance().getService();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The relative resource name of the metastore service to run
     * export, in the following form:
     *
     * `projects/{project_id}/locations/{location_id}/services/{service_id}`.
     * </pre>
     *
     * <code>
     * string service = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for service to set.
     * @return This builder for chaining.
     */
    public Builder setServiceBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      service_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object requestId_ = "";
    /**
     *
     *
     * <pre>
     * Optional. A request ID. Specify a unique request ID to allow the server to
     * ignore the request if it has completed. The server will ignore subsequent
     * requests that provide a duplicate request ID for at least 60 minutes after
     * the first request.
     *
     * For example, if an initial request times out, followed by another request
     * with the same request ID, the server ignores the second request to prevent
     * the creation of duplicate commitments.
     *
     * The request ID must be a valid
     * [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier#Format).
     * A zero UUID (00000000-0000-0000-0000-000000000000) is not supported.
     * </pre>
     *
     * <code>string request_id = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The requestId.
     */
    public java.lang.String getRequestId() {
      java.lang.Object ref = requestId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        requestId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A request ID. Specify a unique request ID to allow the server to
     * ignore the request if it has completed. The server will ignore subsequent
     * requests that provide a duplicate request ID for at least 60 minutes after
     * the first request.
     *
     * For example, if an initial request times out, followed by another request
     * with the same request ID, the server ignores the second request to prevent
     * the creation of duplicate commitments.
     *
     * The request ID must be a valid
     * [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier#Format).
     * A zero UUID (00000000-0000-0000-0000-000000000000) is not supported.
     * </pre>
     *
     * <code>string request_id = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for requestId.
     */
    public com.google.protobuf.ByteString getRequestIdBytes() {
      java.lang.Object ref = requestId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        requestId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A request ID. Specify a unique request ID to allow the server to
     * ignore the request if it has completed. The server will ignore subsequent
     * requests that provide a duplicate request ID for at least 60 minutes after
     * the first request.
     *
     * For example, if an initial request times out, followed by another request
     * with the same request ID, the server ignores the second request to prevent
     * the creation of duplicate commitments.
     *
     * The request ID must be a valid
     * [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier#Format).
     * A zero UUID (00000000-0000-0000-0000-000000000000) is not supported.
     * </pre>
     *
     * <code>string request_id = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The requestId to set.
     * @return This builder for chaining.
     */
    public Builder setRequestId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      requestId_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A request ID. Specify a unique request ID to allow the server to
     * ignore the request if it has completed. The server will ignore subsequent
     * requests that provide a duplicate request ID for at least 60 minutes after
     * the first request.
     *
     * For example, if an initial request times out, followed by another request
     * with the same request ID, the server ignores the second request to prevent
     * the creation of duplicate commitments.
     *
     * The request ID must be a valid
     * [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier#Format).
     * A zero UUID (00000000-0000-0000-0000-000000000000) is not supported.
     * </pre>
     *
     * <code>string request_id = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRequestId() {
      requestId_ = getDefaultInstance().getRequestId();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A request ID. Specify a unique request ID to allow the server to
     * ignore the request if it has completed. The server will ignore subsequent
     * requests that provide a duplicate request ID for at least 60 minutes after
     * the first request.
     *
     * For example, if an initial request times out, followed by another request
     * with the same request ID, the server ignores the second request to prevent
     * the creation of duplicate commitments.
     *
     * The request ID must be a valid
     * [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier#Format).
     * A zero UUID (00000000-0000-0000-0000-000000000000) is not supported.
     * </pre>
     *
     * <code>string request_id = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for requestId to set.
     * @return This builder for chaining.
     */
    public Builder setRequestIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      requestId_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private int databaseDumpType_ = 0;
    /**
     *
     *
     * <pre>
     * Optional. The type of the database dump. If unspecified, defaults to
     * `MYSQL`.
     * </pre>
     *
     * <code>
     * .google.cloud.metastore.v1beta.DatabaseDumpSpec.Type database_dump_type = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enum numeric value on the wire for databaseDumpType.
     */
    @java.lang.Override
    public int getDatabaseDumpTypeValue() {
      return databaseDumpType_;
    }
    /**
     *
     *
     * <pre>
     * Optional. The type of the database dump. If unspecified, defaults to
     * `MYSQL`.
     * </pre>
     *
     * <code>
     * .google.cloud.metastore.v1beta.DatabaseDumpSpec.Type database_dump_type = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The enum numeric value on the wire for databaseDumpType to set.
     * @return This builder for chaining.
     */
    public Builder setDatabaseDumpTypeValue(int value) {
      databaseDumpType_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The type of the database dump. If unspecified, defaults to
     * `MYSQL`.
     * </pre>
     *
     * <code>
     * .google.cloud.metastore.v1beta.DatabaseDumpSpec.Type database_dump_type = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The databaseDumpType.
     */
    @java.lang.Override
    public com.google.cloud.metastore.v1beta.DatabaseDumpSpec.Type getDatabaseDumpType() {
      com.google.cloud.metastore.v1beta.DatabaseDumpSpec.Type result =
          com.google.cloud.metastore.v1beta.DatabaseDumpSpec.Type.forNumber(databaseDumpType_);
      return result == null
          ? com.google.cloud.metastore.v1beta.DatabaseDumpSpec.Type.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Optional. The type of the database dump. If unspecified, defaults to
     * `MYSQL`.
     * </pre>
     *
     * <code>
     * .google.cloud.metastore.v1beta.DatabaseDumpSpec.Type database_dump_type = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The databaseDumpType to set.
     * @return This builder for chaining.
     */
    public Builder setDatabaseDumpType(
        com.google.cloud.metastore.v1beta.DatabaseDumpSpec.Type value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000008;
      databaseDumpType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The type of the database dump. If unspecified, defaults to
     * `MYSQL`.
     * </pre>
     *
     * <code>
     * .google.cloud.metastore.v1beta.DatabaseDumpSpec.Type database_dump_type = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDatabaseDumpType() {
      bitField0_ = (bitField0_ & ~0x00000008);
      databaseDumpType_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.metastore.v1beta.ExportMetadataRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.metastore.v1beta.ExportMetadataRequest)
  private static final com.google.cloud.metastore.v1beta.ExportMetadataRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.metastore.v1beta.ExportMetadataRequest();
  }

  public static com.google.cloud.metastore.v1beta.ExportMetadataRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ExportMetadataRequest> PARSER =
      new com.google.protobuf.AbstractParser<ExportMetadataRequest>() {
        @java.lang.Override
        public ExportMetadataRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ExportMetadataRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ExportMetadataRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.metastore.v1beta.ExportMetadataRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
