/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/metastore/v1beta/metastore.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.metastore.v1beta;

/**
 *
 *
 * <pre>
 * Request message for [DataprocMetastore.Restore][].
 * </pre>
 *
 * Protobuf type {@code google.cloud.metastore.v1beta.RestoreServiceRequest}
 */
public final class RestoreServiceRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.metastore.v1beta.RestoreServiceRequest)
    RestoreServiceRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use RestoreServiceRequest.newBuilder() to construct.
  private RestoreServiceRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private RestoreServiceRequest() {
    service_ = "";
    backup_ = "";
    restoreType_ = 0;
    requestId_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new RestoreServiceRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.metastore.v1beta.MetastoreProto
        .internal_static_google_cloud_metastore_v1beta_RestoreServiceRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.metastore.v1beta.MetastoreProto
        .internal_static_google_cloud_metastore_v1beta_RestoreServiceRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.metastore.v1beta.RestoreServiceRequest.class,
            com.google.cloud.metastore.v1beta.RestoreServiceRequest.Builder.class);
  }

  public static final int SERVICE_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object service_ = "";
  /**
   *
   *
   * <pre>
   * Required. The relative resource name of the metastore service to run
   * restore, in the following form:
   *
   * `projects/{project_id}/locations/{location_id}/services/{service_id}`.
   * </pre>
   *
   * <code>
   * string service = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The service.
   */
  @java.lang.Override
  public java.lang.String getService() {
    java.lang.Object ref = service_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      service_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The relative resource name of the metastore service to run
   * restore, in the following form:
   *
   * `projects/{project_id}/locations/{location_id}/services/{service_id}`.
   * </pre>
   *
   * <code>
   * string service = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for service.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getServiceBytes() {
    java.lang.Object ref = service_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      service_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int BACKUP_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object backup_ = "";
  /**
   *
   *
   * <pre>
   * Required. The relative resource name of the metastore service backup to
   * restore from, in the following form:
   *
   * `projects/{project_id}/locations/{location_id}/services/{service_id}/backups/{backup_id}`.
   * </pre>
   *
   * <code>
   * string backup = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The backup.
   */
  @java.lang.Override
  public java.lang.String getBackup() {
    java.lang.Object ref = backup_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      backup_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The relative resource name of the metastore service backup to
   * restore from, in the following form:
   *
   * `projects/{project_id}/locations/{location_id}/services/{service_id}/backups/{backup_id}`.
   * </pre>
   *
   * <code>
   * string backup = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for backup.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getBackupBytes() {
    java.lang.Object ref = backup_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      backup_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int RESTORE_TYPE_FIELD_NUMBER = 3;
  private int restoreType_ = 0;
  /**
   *
   *
   * <pre>
   * Optional. The type of restore. If unspecified, defaults to `METADATA_ONLY`.
   * </pre>
   *
   * <code>
   * .google.cloud.metastore.v1beta.Restore.RestoreType restore_type = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The enum numeric value on the wire for restoreType.
   */
  @java.lang.Override
  public int getRestoreTypeValue() {
    return restoreType_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The type of restore. If unspecified, defaults to `METADATA_ONLY`.
   * </pre>
   *
   * <code>
   * .google.cloud.metastore.v1beta.Restore.RestoreType restore_type = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The restoreType.
   */
  @java.lang.Override
  public com.google.cloud.metastore.v1beta.Restore.RestoreType getRestoreType() {
    com.google.cloud.metastore.v1beta.Restore.RestoreType result =
        com.google.cloud.metastore.v1beta.Restore.RestoreType.forNumber(restoreType_);
    return result == null
        ? com.google.cloud.metastore.v1beta.Restore.RestoreType.UNRECOGNIZED
        : result;
  }

  public static final int REQUEST_ID_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object requestId_ = "";
  /**
   *
   *
   * <pre>
   * Optional. A request ID. Specify a unique request ID to allow the server to
   * ignore the request if it has completed. The server will ignore subsequent
   * requests that provide a duplicate request ID for at least 60 minutes after
   * the first request.
   *
   * For example, if an initial request times out, followed by another request
   * with the same request ID, the server ignores the second request to prevent
   * the creation of duplicate commitments.
   *
   * The request ID must be a valid
   * [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier#Format).
   * A zero UUID (00000000-0000-0000-0000-000000000000) is not supported.
   * </pre>
   *
   * <code>string request_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The requestId.
   */
  @java.lang.Override
  public java.lang.String getRequestId() {
    java.lang.Object ref = requestId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      requestId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. A request ID. Specify a unique request ID to allow the server to
   * ignore the request if it has completed. The server will ignore subsequent
   * requests that provide a duplicate request ID for at least 60 minutes after
   * the first request.
   *
   * For example, if an initial request times out, followed by another request
   * with the same request ID, the server ignores the second request to prevent
   * the creation of duplicate commitments.
   *
   * The request ID must be a valid
   * [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier#Format).
   * A zero UUID (00000000-0000-0000-0000-000000000000) is not supported.
   * </pre>
   *
   * <code>string request_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for requestId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRequestIdBytes() {
    java.lang.Object ref = requestId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      requestId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(service_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, service_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(backup_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, backup_);
    }
    if (restoreType_
        != com.google.cloud.metastore.v1beta.Restore.RestoreType.RESTORE_TYPE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(3, restoreType_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(requestId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, requestId_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(service_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, service_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(backup_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, backup_);
    }
    if (restoreType_
        != com.google.cloud.metastore.v1beta.Restore.RestoreType.RESTORE_TYPE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, restoreType_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(requestId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, requestId_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.metastore.v1beta.RestoreServiceRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.metastore.v1beta.RestoreServiceRequest other =
        (com.google.cloud.metastore.v1beta.RestoreServiceRequest) obj;

    if (!getService().equals(other.getService())) return false;
    if (!getBackup().equals(other.getBackup())) return false;
    if (restoreType_ != other.restoreType_) return false;
    if (!getRequestId().equals(other.getRequestId())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + SERVICE_FIELD_NUMBER;
    hash = (53 * hash) + getService().hashCode();
    hash = (37 * hash) + BACKUP_FIELD_NUMBER;
    hash = (53 * hash) + getBackup().hashCode();
    hash = (37 * hash) + RESTORE_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + restoreType_;
    hash = (37 * hash) + REQUEST_ID_FIELD_NUMBER;
    hash = (53 * hash) + getRequestId().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.metastore.v1beta.RestoreServiceRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.metastore.v1beta.RestoreServiceRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.metastore.v1beta.RestoreServiceRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.metastore.v1beta.RestoreServiceRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.metastore.v1beta.RestoreServiceRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.metastore.v1beta.RestoreServiceRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.metastore.v1beta.RestoreServiceRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.metastore.v1beta.RestoreServiceRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.metastore.v1beta.RestoreServiceRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.metastore.v1beta.RestoreServiceRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.metastore.v1beta.RestoreServiceRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.metastore.v1beta.RestoreServiceRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.metastore.v1beta.RestoreServiceRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request message for [DataprocMetastore.Restore][].
   * </pre>
   *
   * Protobuf type {@code google.cloud.metastore.v1beta.RestoreServiceRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.metastore.v1beta.RestoreServiceRequest)
      com.google.cloud.metastore.v1beta.RestoreServiceRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.metastore.v1beta.MetastoreProto
          .internal_static_google_cloud_metastore_v1beta_RestoreServiceRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.metastore.v1beta.MetastoreProto
          .internal_static_google_cloud_metastore_v1beta_RestoreServiceRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.metastore.v1beta.RestoreServiceRequest.class,
              com.google.cloud.metastore.v1beta.RestoreServiceRequest.Builder.class);
    }

    // Construct using com.google.cloud.metastore.v1beta.RestoreServiceRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      service_ = "";
      backup_ = "";
      restoreType_ = 0;
      requestId_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.metastore.v1beta.MetastoreProto
          .internal_static_google_cloud_metastore_v1beta_RestoreServiceRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.metastore.v1beta.RestoreServiceRequest getDefaultInstanceForType() {
      return com.google.cloud.metastore.v1beta.RestoreServiceRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.metastore.v1beta.RestoreServiceRequest build() {
      com.google.cloud.metastore.v1beta.RestoreServiceRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.metastore.v1beta.RestoreServiceRequest buildPartial() {
      com.google.cloud.metastore.v1beta.RestoreServiceRequest result =
          new com.google.cloud.metastore.v1beta.RestoreServiceRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.metastore.v1beta.RestoreServiceRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.service_ = service_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.backup_ = backup_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.restoreType_ = restoreType_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.requestId_ = requestId_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.metastore.v1beta.RestoreServiceRequest) {
        return mergeFrom((com.google.cloud.metastore.v1beta.RestoreServiceRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.metastore.v1beta.RestoreServiceRequest other) {
      if (other == com.google.cloud.metastore.v1beta.RestoreServiceRequest.getDefaultInstance())
        return this;
      if (!other.getService().isEmpty()) {
        service_ = other.service_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getBackup().isEmpty()) {
        backup_ = other.backup_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.restoreType_ != 0) {
        setRestoreTypeValue(other.getRestoreTypeValue());
      }
      if (!other.getRequestId().isEmpty()) {
        requestId_ = other.requestId_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                service_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                backup_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 24:
              {
                restoreType_ = input.readEnum();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 34:
              {
                requestId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object service_ = "";
    /**
     *
     *
     * <pre>
     * Required. The relative resource name of the metastore service to run
     * restore, in the following form:
     *
     * `projects/{project_id}/locations/{location_id}/services/{service_id}`.
     * </pre>
     *
     * <code>
     * string service = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The service.
     */
    public java.lang.String getService() {
      java.lang.Object ref = service_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        service_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The relative resource name of the metastore service to run
     * restore, in the following form:
     *
     * `projects/{project_id}/locations/{location_id}/services/{service_id}`.
     * </pre>
     *
     * <code>
     * string service = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for service.
     */
    public com.google.protobuf.ByteString getServiceBytes() {
      java.lang.Object ref = service_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        service_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The relative resource name of the metastore service to run
     * restore, in the following form:
     *
     * `projects/{project_id}/locations/{location_id}/services/{service_id}`.
     * </pre>
     *
     * <code>
     * string service = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The service to set.
     * @return This builder for chaining.
     */
    public Builder setService(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      service_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The relative resource name of the metastore service to run
     * restore, in the following form:
     *
     * `projects/{project_id}/locations/{location_id}/services/{service_id}`.
     * </pre>
     *
     * <code>
     * string service = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearService() {
      service_ = getDefaultInstance().getService();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The relative resource name of the metastore service to run
     * restore, in the following form:
     *
     * `projects/{project_id}/locations/{location_id}/services/{service_id}`.
     * </pre>
     *
     * <code>
     * string service = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for service to set.
     * @return This builder for chaining.
     */
    public Builder setServiceBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      service_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object backup_ = "";
    /**
     *
     *
     * <pre>
     * Required. The relative resource name of the metastore service backup to
     * restore from, in the following form:
     *
     * `projects/{project_id}/locations/{location_id}/services/{service_id}/backups/{backup_id}`.
     * </pre>
     *
     * <code>
     * string backup = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The backup.
     */
    public java.lang.String getBackup() {
      java.lang.Object ref = backup_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        backup_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The relative resource name of the metastore service backup to
     * restore from, in the following form:
     *
     * `projects/{project_id}/locations/{location_id}/services/{service_id}/backups/{backup_id}`.
     * </pre>
     *
     * <code>
     * string backup = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for backup.
     */
    public com.google.protobuf.ByteString getBackupBytes() {
      java.lang.Object ref = backup_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        backup_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The relative resource name of the metastore service backup to
     * restore from, in the following form:
     *
     * `projects/{project_id}/locations/{location_id}/services/{service_id}/backups/{backup_id}`.
     * </pre>
     *
     * <code>
     * string backup = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The backup to set.
     * @return This builder for chaining.
     */
    public Builder setBackup(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      backup_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The relative resource name of the metastore service backup to
     * restore from, in the following form:
     *
     * `projects/{project_id}/locations/{location_id}/services/{service_id}/backups/{backup_id}`.
     * </pre>
     *
     * <code>
     * string backup = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBackup() {
      backup_ = getDefaultInstance().getBackup();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The relative resource name of the metastore service backup to
     * restore from, in the following form:
     *
     * `projects/{project_id}/locations/{location_id}/services/{service_id}/backups/{backup_id}`.
     * </pre>
     *
     * <code>
     * string backup = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for backup to set.
     * @return This builder for chaining.
     */
    public Builder setBackupBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      backup_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private int restoreType_ = 0;
    /**
     *
     *
     * <pre>
     * Optional. The type of restore. If unspecified, defaults to `METADATA_ONLY`.
     * </pre>
     *
     * <code>
     * .google.cloud.metastore.v1beta.Restore.RestoreType restore_type = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enum numeric value on the wire for restoreType.
     */
    @java.lang.Override
    public int getRestoreTypeValue() {
      return restoreType_;
    }
    /**
     *
     *
     * <pre>
     * Optional. The type of restore. If unspecified, defaults to `METADATA_ONLY`.
     * </pre>
     *
     * <code>
     * .google.cloud.metastore.v1beta.Restore.RestoreType restore_type = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The enum numeric value on the wire for restoreType to set.
     * @return This builder for chaining.
     */
    public Builder setRestoreTypeValue(int value) {
      restoreType_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The type of restore. If unspecified, defaults to `METADATA_ONLY`.
     * </pre>
     *
     * <code>
     * .google.cloud.metastore.v1beta.Restore.RestoreType restore_type = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The restoreType.
     */
    @java.lang.Override
    public com.google.cloud.metastore.v1beta.Restore.RestoreType getRestoreType() {
      com.google.cloud.metastore.v1beta.Restore.RestoreType result =
          com.google.cloud.metastore.v1beta.Restore.RestoreType.forNumber(restoreType_);
      return result == null
          ? com.google.cloud.metastore.v1beta.Restore.RestoreType.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Optional. The type of restore. If unspecified, defaults to `METADATA_ONLY`.
     * </pre>
     *
     * <code>
     * .google.cloud.metastore.v1beta.Restore.RestoreType restore_type = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The restoreType to set.
     * @return This builder for chaining.
     */
    public Builder setRestoreType(com.google.cloud.metastore.v1beta.Restore.RestoreType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000004;
      restoreType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The type of restore. If unspecified, defaults to `METADATA_ONLY`.
     * </pre>
     *
     * <code>
     * .google.cloud.metastore.v1beta.Restore.RestoreType restore_type = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRestoreType() {
      bitField0_ = (bitField0_ & ~0x00000004);
      restoreType_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object requestId_ = "";
    /**
     *
     *
     * <pre>
     * Optional. A request ID. Specify a unique request ID to allow the server to
     * ignore the request if it has completed. The server will ignore subsequent
     * requests that provide a duplicate request ID for at least 60 minutes after
     * the first request.
     *
     * For example, if an initial request times out, followed by another request
     * with the same request ID, the server ignores the second request to prevent
     * the creation of duplicate commitments.
     *
     * The request ID must be a valid
     * [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier#Format).
     * A zero UUID (00000000-0000-0000-0000-000000000000) is not supported.
     * </pre>
     *
     * <code>string request_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The requestId.
     */
    public java.lang.String getRequestId() {
      java.lang.Object ref = requestId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        requestId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A request ID. Specify a unique request ID to allow the server to
     * ignore the request if it has completed. The server will ignore subsequent
     * requests that provide a duplicate request ID for at least 60 minutes after
     * the first request.
     *
     * For example, if an initial request times out, followed by another request
     * with the same request ID, the server ignores the second request to prevent
     * the creation of duplicate commitments.
     *
     * The request ID must be a valid
     * [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier#Format).
     * A zero UUID (00000000-0000-0000-0000-000000000000) is not supported.
     * </pre>
     *
     * <code>string request_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for requestId.
     */
    public com.google.protobuf.ByteString getRequestIdBytes() {
      java.lang.Object ref = requestId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        requestId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A request ID. Specify a unique request ID to allow the server to
     * ignore the request if it has completed. The server will ignore subsequent
     * requests that provide a duplicate request ID for at least 60 minutes after
     * the first request.
     *
     * For example, if an initial request times out, followed by another request
     * with the same request ID, the server ignores the second request to prevent
     * the creation of duplicate commitments.
     *
     * The request ID must be a valid
     * [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier#Format).
     * A zero UUID (00000000-0000-0000-0000-000000000000) is not supported.
     * </pre>
     *
     * <code>string request_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The requestId to set.
     * @return This builder for chaining.
     */
    public Builder setRequestId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      requestId_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A request ID. Specify a unique request ID to allow the server to
     * ignore the request if it has completed. The server will ignore subsequent
     * requests that provide a duplicate request ID for at least 60 minutes after
     * the first request.
     *
     * For example, if an initial request times out, followed by another request
     * with the same request ID, the server ignores the second request to prevent
     * the creation of duplicate commitments.
     *
     * The request ID must be a valid
     * [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier#Format).
     * A zero UUID (00000000-0000-0000-0000-000000000000) is not supported.
     * </pre>
     *
     * <code>string request_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRequestId() {
      requestId_ = getDefaultInstance().getRequestId();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A request ID. Specify a unique request ID to allow the server to
     * ignore the request if it has completed. The server will ignore subsequent
     * requests that provide a duplicate request ID for at least 60 minutes after
     * the first request.
     *
     * For example, if an initial request times out, followed by another request
     * with the same request ID, the server ignores the second request to prevent
     * the creation of duplicate commitments.
     *
     * The request ID must be a valid
     * [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier#Format).
     * A zero UUID (00000000-0000-0000-0000-000000000000) is not supported.
     * </pre>
     *
     * <code>string request_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for requestId to set.
     * @return This builder for chaining.
     */
    public Builder setRequestIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      requestId_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.metastore.v1beta.RestoreServiceRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.metastore.v1beta.RestoreServiceRequest)
  private static final com.google.cloud.metastore.v1beta.RestoreServiceRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.metastore.v1beta.RestoreServiceRequest();
  }

  public static com.google.cloud.metastore.v1beta.RestoreServiceRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<RestoreServiceRequest> PARSER =
      new com.google.protobuf.AbstractParser<RestoreServiceRequest>() {
        @java.lang.Override
        public RestoreServiceRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<RestoreServiceRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<RestoreServiceRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.metastore.v1beta.RestoreServiceRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
