/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/metastore/v1beta/metastore.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.metastore.v1beta;

/**
 *
 *
 * <pre>
 * Specifies configuration information specific to running Hive metastore
 * software as the metastore service.
 * </pre>
 *
 * Protobuf type {@code google.cloud.metastore.v1beta.HiveMetastoreConfig}
 */
public final class HiveMetastoreConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.metastore.v1beta.HiveMetastoreConfig)
    HiveMetastoreConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use HiveMetastoreConfig.newBuilder() to construct.
  private HiveMetastoreConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private HiveMetastoreConfig() {
    version_ = "";
    endpointProtocol_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new HiveMetastoreConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.metastore.v1beta.MetastoreProto
        .internal_static_google_cloud_metastore_v1beta_HiveMetastoreConfig_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 2:
        return internalGetConfigOverrides();
      case 5:
        return internalGetAuxiliaryVersions();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.metastore.v1beta.MetastoreProto
        .internal_static_google_cloud_metastore_v1beta_HiveMetastoreConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.metastore.v1beta.HiveMetastoreConfig.class,
            com.google.cloud.metastore.v1beta.HiveMetastoreConfig.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Protocols available for serving the metastore service endpoint.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.metastore.v1beta.HiveMetastoreConfig.EndpointProtocol}
   */
  public enum EndpointProtocol implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * The protocol is not set.
     * </pre>
     *
     * <code>ENDPOINT_PROTOCOL_UNSPECIFIED = 0;</code>
     */
    ENDPOINT_PROTOCOL_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Use the legacy Apache Thrift protocol for the metastore service endpoint.
     * </pre>
     *
     * <code>THRIFT = 1;</code>
     */
    THRIFT(1),
    /**
     *
     *
     * <pre>
     * Use the modernized gRPC protocol for the metastore service endpoint.
     * </pre>
     *
     * <code>GRPC = 2;</code>
     */
    GRPC(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * The protocol is not set.
     * </pre>
     *
     * <code>ENDPOINT_PROTOCOL_UNSPECIFIED = 0;</code>
     */
    public static final int ENDPOINT_PROTOCOL_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Use the legacy Apache Thrift protocol for the metastore service endpoint.
     * </pre>
     *
     * <code>THRIFT = 1;</code>
     */
    public static final int THRIFT_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Use the modernized gRPC protocol for the metastore service endpoint.
     * </pre>
     *
     * <code>GRPC = 2;</code>
     */
    public static final int GRPC_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static EndpointProtocol valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static EndpointProtocol forNumber(int value) {
      switch (value) {
        case 0:
          return ENDPOINT_PROTOCOL_UNSPECIFIED;
        case 1:
          return THRIFT;
        case 2:
          return GRPC;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<EndpointProtocol> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<EndpointProtocol>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<EndpointProtocol>() {
              public EndpointProtocol findValueByNumber(int number) {
                return EndpointProtocol.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.metastore.v1beta.HiveMetastoreConfig.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final EndpointProtocol[] VALUES = values();

    public static EndpointProtocol valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private EndpointProtocol(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.metastore.v1beta.HiveMetastoreConfig.EndpointProtocol)
  }

  private int bitField0_;
  public static final int VERSION_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object version_ = "";
  /**
   *
   *
   * <pre>
   * Immutable. The Hive metastore schema version.
   * </pre>
   *
   * <code>string version = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The version.
   */
  @java.lang.Override
  public java.lang.String getVersion() {
    java.lang.Object ref = version_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      version_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Immutable. The Hive metastore schema version.
   * </pre>
   *
   * <code>string version = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The bytes for version.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getVersionBytes() {
    java.lang.Object ref = version_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      version_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CONFIG_OVERRIDES_FIELD_NUMBER = 2;

  private static final class ConfigOverridesDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.metastore.v1beta.MetastoreProto
                .internal_static_google_cloud_metastore_v1beta_HiveMetastoreConfig_ConfigOverridesEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> configOverrides_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String>
      internalGetConfigOverrides() {
    if (configOverrides_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          ConfigOverridesDefaultEntryHolder.defaultEntry);
    }
    return configOverrides_;
  }

  public int getConfigOverridesCount() {
    return internalGetConfigOverrides().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * A mapping of Hive metastore configuration key-value pairs to apply to the
   * Hive metastore (configured in `hive-site.xml`). The mappings
   * override system defaults (some keys cannot be overridden). These
   * overrides are also applied to auxiliary versions and can be further
   * customized in the auxiliary version's `AuxiliaryVersionConfig`.
   * </pre>
   *
   * <code>map&lt;string, string&gt; config_overrides = 2;</code>
   */
  @java.lang.Override
  public boolean containsConfigOverrides(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetConfigOverrides().getMap().containsKey(key);
  }
  /** Use {@link #getConfigOverridesMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getConfigOverrides() {
    return getConfigOverridesMap();
  }
  /**
   *
   *
   * <pre>
   * A mapping of Hive metastore configuration key-value pairs to apply to the
   * Hive metastore (configured in `hive-site.xml`). The mappings
   * override system defaults (some keys cannot be overridden). These
   * overrides are also applied to auxiliary versions and can be further
   * customized in the auxiliary version's `AuxiliaryVersionConfig`.
   * </pre>
   *
   * <code>map&lt;string, string&gt; config_overrides = 2;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getConfigOverridesMap() {
    return internalGetConfigOverrides().getMap();
  }
  /**
   *
   *
   * <pre>
   * A mapping of Hive metastore configuration key-value pairs to apply to the
   * Hive metastore (configured in `hive-site.xml`). The mappings
   * override system defaults (some keys cannot be overridden). These
   * overrides are also applied to auxiliary versions and can be further
   * customized in the auxiliary version's `AuxiliaryVersionConfig`.
   * </pre>
   *
   * <code>map&lt;string, string&gt; config_overrides = 2;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getConfigOverridesOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetConfigOverrides().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * A mapping of Hive metastore configuration key-value pairs to apply to the
   * Hive metastore (configured in `hive-site.xml`). The mappings
   * override system defaults (some keys cannot be overridden). These
   * overrides are also applied to auxiliary versions and can be further
   * customized in the auxiliary version's `AuxiliaryVersionConfig`.
   * </pre>
   *
   * <code>map&lt;string, string&gt; config_overrides = 2;</code>
   */
  @java.lang.Override
  public java.lang.String getConfigOverridesOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetConfigOverrides().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int KERBEROS_CONFIG_FIELD_NUMBER = 3;
  private com.google.cloud.metastore.v1beta.KerberosConfig kerberosConfig_;
  /**
   *
   *
   * <pre>
   * Information used to configure the Hive metastore service as a service
   * principal in a Kerberos realm. To disable Kerberos, use the `UpdateService`
   * method and specify this field's path
   * (`hive_metastore_config.kerberos_config`) in the request's `update_mask`
   * while omitting this field from the request's `service`.
   * </pre>
   *
   * <code>.google.cloud.metastore.v1beta.KerberosConfig kerberos_config = 3;</code>
   *
   * @return Whether the kerberosConfig field is set.
   */
  @java.lang.Override
  public boolean hasKerberosConfig() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Information used to configure the Hive metastore service as a service
   * principal in a Kerberos realm. To disable Kerberos, use the `UpdateService`
   * method and specify this field's path
   * (`hive_metastore_config.kerberos_config`) in the request's `update_mask`
   * while omitting this field from the request's `service`.
   * </pre>
   *
   * <code>.google.cloud.metastore.v1beta.KerberosConfig kerberos_config = 3;</code>
   *
   * @return The kerberosConfig.
   */
  @java.lang.Override
  public com.google.cloud.metastore.v1beta.KerberosConfig getKerberosConfig() {
    return kerberosConfig_ == null
        ? com.google.cloud.metastore.v1beta.KerberosConfig.getDefaultInstance()
        : kerberosConfig_;
  }
  /**
   *
   *
   * <pre>
   * Information used to configure the Hive metastore service as a service
   * principal in a Kerberos realm. To disable Kerberos, use the `UpdateService`
   * method and specify this field's path
   * (`hive_metastore_config.kerberos_config`) in the request's `update_mask`
   * while omitting this field from the request's `service`.
   * </pre>
   *
   * <code>.google.cloud.metastore.v1beta.KerberosConfig kerberos_config = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.metastore.v1beta.KerberosConfigOrBuilder getKerberosConfigOrBuilder() {
    return kerberosConfig_ == null
        ? com.google.cloud.metastore.v1beta.KerberosConfig.getDefaultInstance()
        : kerberosConfig_;
  }

  public static final int ENDPOINT_PROTOCOL_FIELD_NUMBER = 4;
  private int endpointProtocol_ = 0;
  /**
   *
   *
   * <pre>
   * The protocol to use for the metastore service endpoint. If unspecified,
   * defaults to `THRIFT`.
   * </pre>
   *
   * <code>
   * .google.cloud.metastore.v1beta.HiveMetastoreConfig.EndpointProtocol endpoint_protocol = 4;
   * </code>
   *
   * @return The enum numeric value on the wire for endpointProtocol.
   */
  @java.lang.Override
  public int getEndpointProtocolValue() {
    return endpointProtocol_;
  }
  /**
   *
   *
   * <pre>
   * The protocol to use for the metastore service endpoint. If unspecified,
   * defaults to `THRIFT`.
   * </pre>
   *
   * <code>
   * .google.cloud.metastore.v1beta.HiveMetastoreConfig.EndpointProtocol endpoint_protocol = 4;
   * </code>
   *
   * @return The endpointProtocol.
   */
  @java.lang.Override
  public com.google.cloud.metastore.v1beta.HiveMetastoreConfig.EndpointProtocol
      getEndpointProtocol() {
    com.google.cloud.metastore.v1beta.HiveMetastoreConfig.EndpointProtocol result =
        com.google.cloud.metastore.v1beta.HiveMetastoreConfig.EndpointProtocol.forNumber(
            endpointProtocol_);
    return result == null
        ? com.google.cloud.metastore.v1beta.HiveMetastoreConfig.EndpointProtocol.UNRECOGNIZED
        : result;
  }

  public static final int AUXILIARY_VERSIONS_FIELD_NUMBER = 5;

  private static final class AuxiliaryVersionsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<
            java.lang.String, com.google.cloud.metastore.v1beta.AuxiliaryVersionConfig>
        defaultEntry =
            com.google.protobuf.MapEntry
                .<java.lang.String, com.google.cloud.metastore.v1beta.AuxiliaryVersionConfig>
                    newDefaultInstance(
                        com.google.cloud.metastore.v1beta.MetastoreProto
                            .internal_static_google_cloud_metastore_v1beta_HiveMetastoreConfig_AuxiliaryVersionsEntry_descriptor,
                        com.google.protobuf.WireFormat.FieldType.STRING,
                        "",
                        com.google.protobuf.WireFormat.FieldType.MESSAGE,
                        com.google.cloud.metastore.v1beta.AuxiliaryVersionConfig
                            .getDefaultInstance());
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<
          java.lang.String, com.google.cloud.metastore.v1beta.AuxiliaryVersionConfig>
      auxiliaryVersions_;

  private com.google.protobuf.MapField<
          java.lang.String, com.google.cloud.metastore.v1beta.AuxiliaryVersionConfig>
      internalGetAuxiliaryVersions() {
    if (auxiliaryVersions_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          AuxiliaryVersionsDefaultEntryHolder.defaultEntry);
    }
    return auxiliaryVersions_;
  }

  public int getAuxiliaryVersionsCount() {
    return internalGetAuxiliaryVersions().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * A mapping of Hive metastore version to the auxiliary version
   * configuration. When specified, a secondary Hive metastore service is
   * created along with the primary service. All auxiliary versions must be less
   * than the service's primary version. The key is the auxiliary service name
   * and it must match the regular expression [a-z]([-a-z0-9]*[a-z0-9])?. This
   * means that the first character must be a lowercase letter, and all the
   * following characters must be hyphens, lowercase letters, or digits, except
   * the last character, which cannot be a hyphen.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.metastore.v1beta.AuxiliaryVersionConfig&gt; auxiliary_versions = 5;
   * </code>
   */
  @java.lang.Override
  public boolean containsAuxiliaryVersions(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetAuxiliaryVersions().getMap().containsKey(key);
  }
  /** Use {@link #getAuxiliaryVersionsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, com.google.cloud.metastore.v1beta.AuxiliaryVersionConfig>
      getAuxiliaryVersions() {
    return getAuxiliaryVersionsMap();
  }
  /**
   *
   *
   * <pre>
   * A mapping of Hive metastore version to the auxiliary version
   * configuration. When specified, a secondary Hive metastore service is
   * created along with the primary service. All auxiliary versions must be less
   * than the service's primary version. The key is the auxiliary service name
   * and it must match the regular expression [a-z]([-a-z0-9]*[a-z0-9])?. This
   * means that the first character must be a lowercase letter, and all the
   * following characters must be hyphens, lowercase letters, or digits, except
   * the last character, which cannot be a hyphen.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.metastore.v1beta.AuxiliaryVersionConfig&gt; auxiliary_versions = 5;
   * </code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, com.google.cloud.metastore.v1beta.AuxiliaryVersionConfig>
      getAuxiliaryVersionsMap() {
    return internalGetAuxiliaryVersions().getMap();
  }
  /**
   *
   *
   * <pre>
   * A mapping of Hive metastore version to the auxiliary version
   * configuration. When specified, a secondary Hive metastore service is
   * created along with the primary service. All auxiliary versions must be less
   * than the service's primary version. The key is the auxiliary service name
   * and it must match the regular expression [a-z]([-a-z0-9]*[a-z0-9])?. This
   * means that the first character must be a lowercase letter, and all the
   * following characters must be hyphens, lowercase letters, or digits, except
   * the last character, which cannot be a hyphen.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.metastore.v1beta.AuxiliaryVersionConfig&gt; auxiliary_versions = 5;
   * </code>
   */
  @java.lang.Override
  public /* nullable */ com.google.cloud.metastore.v1beta.AuxiliaryVersionConfig
      getAuxiliaryVersionsOrDefault(
          java.lang.String key,
          /* nullable */
          com.google.cloud.metastore.v1beta.AuxiliaryVersionConfig defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.cloud.metastore.v1beta.AuxiliaryVersionConfig> map =
        internalGetAuxiliaryVersions().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * A mapping of Hive metastore version to the auxiliary version
   * configuration. When specified, a secondary Hive metastore service is
   * created along with the primary service. All auxiliary versions must be less
   * than the service's primary version. The key is the auxiliary service name
   * and it must match the regular expression [a-z]([-a-z0-9]*[a-z0-9])?. This
   * means that the first character must be a lowercase letter, and all the
   * following characters must be hyphens, lowercase letters, or digits, except
   * the last character, which cannot be a hyphen.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.metastore.v1beta.AuxiliaryVersionConfig&gt; auxiliary_versions = 5;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.metastore.v1beta.AuxiliaryVersionConfig getAuxiliaryVersionsOrThrow(
      java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.cloud.metastore.v1beta.AuxiliaryVersionConfig> map =
        internalGetAuxiliaryVersions().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(version_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, version_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetConfigOverrides(), ConfigOverridesDefaultEntryHolder.defaultEntry, 2);
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(3, getKerberosConfig());
    }
    if (endpointProtocol_
        != com.google.cloud.metastore.v1beta.HiveMetastoreConfig.EndpointProtocol
            .ENDPOINT_PROTOCOL_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(4, endpointProtocol_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output,
        internalGetAuxiliaryVersions(),
        AuxiliaryVersionsDefaultEntryHolder.defaultEntry,
        5);
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(version_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, version_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetConfigOverrides().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> configOverrides__ =
          ConfigOverridesDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, configOverrides__);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getKerberosConfig());
    }
    if (endpointProtocol_
        != com.google.cloud.metastore.v1beta.HiveMetastoreConfig.EndpointProtocol
            .ENDPOINT_PROTOCOL_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, endpointProtocol_);
    }
    for (java.util.Map.Entry<
            java.lang.String, com.google.cloud.metastore.v1beta.AuxiliaryVersionConfig>
        entry : internalGetAuxiliaryVersions().getMap().entrySet()) {
      com.google.protobuf.MapEntry<
              java.lang.String, com.google.cloud.metastore.v1beta.AuxiliaryVersionConfig>
          auxiliaryVersions__ =
              AuxiliaryVersionsDefaultEntryHolder.defaultEntry
                  .newBuilderForType()
                  .setKey(entry.getKey())
                  .setValue(entry.getValue())
                  .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, auxiliaryVersions__);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.metastore.v1beta.HiveMetastoreConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.metastore.v1beta.HiveMetastoreConfig other =
        (com.google.cloud.metastore.v1beta.HiveMetastoreConfig) obj;

    if (!getVersion().equals(other.getVersion())) return false;
    if (!internalGetConfigOverrides().equals(other.internalGetConfigOverrides())) return false;
    if (hasKerberosConfig() != other.hasKerberosConfig()) return false;
    if (hasKerberosConfig()) {
      if (!getKerberosConfig().equals(other.getKerberosConfig())) return false;
    }
    if (endpointProtocol_ != other.endpointProtocol_) return false;
    if (!internalGetAuxiliaryVersions().equals(other.internalGetAuxiliaryVersions())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + VERSION_FIELD_NUMBER;
    hash = (53 * hash) + getVersion().hashCode();
    if (!internalGetConfigOverrides().getMap().isEmpty()) {
      hash = (37 * hash) + CONFIG_OVERRIDES_FIELD_NUMBER;
      hash = (53 * hash) + internalGetConfigOverrides().hashCode();
    }
    if (hasKerberosConfig()) {
      hash = (37 * hash) + KERBEROS_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getKerberosConfig().hashCode();
    }
    hash = (37 * hash) + ENDPOINT_PROTOCOL_FIELD_NUMBER;
    hash = (53 * hash) + endpointProtocol_;
    if (!internalGetAuxiliaryVersions().getMap().isEmpty()) {
      hash = (37 * hash) + AUXILIARY_VERSIONS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetAuxiliaryVersions().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.metastore.v1beta.HiveMetastoreConfig parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.metastore.v1beta.HiveMetastoreConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.metastore.v1beta.HiveMetastoreConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.metastore.v1beta.HiveMetastoreConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.metastore.v1beta.HiveMetastoreConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.metastore.v1beta.HiveMetastoreConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.metastore.v1beta.HiveMetastoreConfig parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.metastore.v1beta.HiveMetastoreConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.metastore.v1beta.HiveMetastoreConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.metastore.v1beta.HiveMetastoreConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.metastore.v1beta.HiveMetastoreConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.metastore.v1beta.HiveMetastoreConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.metastore.v1beta.HiveMetastoreConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Specifies configuration information specific to running Hive metastore
   * software as the metastore service.
   * </pre>
   *
   * Protobuf type {@code google.cloud.metastore.v1beta.HiveMetastoreConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.metastore.v1beta.HiveMetastoreConfig)
      com.google.cloud.metastore.v1beta.HiveMetastoreConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.metastore.v1beta.MetastoreProto
          .internal_static_google_cloud_metastore_v1beta_HiveMetastoreConfig_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 2:
          return internalGetConfigOverrides();
        case 5:
          return internalGetAuxiliaryVersions();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 2:
          return internalGetMutableConfigOverrides();
        case 5:
          return internalGetMutableAuxiliaryVersions();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.metastore.v1beta.MetastoreProto
          .internal_static_google_cloud_metastore_v1beta_HiveMetastoreConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.metastore.v1beta.HiveMetastoreConfig.class,
              com.google.cloud.metastore.v1beta.HiveMetastoreConfig.Builder.class);
    }

    // Construct using com.google.cloud.metastore.v1beta.HiveMetastoreConfig.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getKerberosConfigFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      version_ = "";
      internalGetMutableConfigOverrides().clear();
      kerberosConfig_ = null;
      if (kerberosConfigBuilder_ != null) {
        kerberosConfigBuilder_.dispose();
        kerberosConfigBuilder_ = null;
      }
      endpointProtocol_ = 0;
      internalGetMutableAuxiliaryVersions().clear();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.metastore.v1beta.MetastoreProto
          .internal_static_google_cloud_metastore_v1beta_HiveMetastoreConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.metastore.v1beta.HiveMetastoreConfig getDefaultInstanceForType() {
      return com.google.cloud.metastore.v1beta.HiveMetastoreConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.metastore.v1beta.HiveMetastoreConfig build() {
      com.google.cloud.metastore.v1beta.HiveMetastoreConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.metastore.v1beta.HiveMetastoreConfig buildPartial() {
      com.google.cloud.metastore.v1beta.HiveMetastoreConfig result =
          new com.google.cloud.metastore.v1beta.HiveMetastoreConfig(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.metastore.v1beta.HiveMetastoreConfig result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.version_ = version_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.configOverrides_ = internalGetConfigOverrides();
        result.configOverrides_.makeImmutable();
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.kerberosConfig_ =
            kerberosConfigBuilder_ == null ? kerberosConfig_ : kerberosConfigBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.endpointProtocol_ = endpointProtocol_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.auxiliaryVersions_ =
            internalGetAuxiliaryVersions().build(AuxiliaryVersionsDefaultEntryHolder.defaultEntry);
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.metastore.v1beta.HiveMetastoreConfig) {
        return mergeFrom((com.google.cloud.metastore.v1beta.HiveMetastoreConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.metastore.v1beta.HiveMetastoreConfig other) {
      if (other == com.google.cloud.metastore.v1beta.HiveMetastoreConfig.getDefaultInstance())
        return this;
      if (!other.getVersion().isEmpty()) {
        version_ = other.version_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      internalGetMutableConfigOverrides().mergeFrom(other.internalGetConfigOverrides());
      bitField0_ |= 0x00000002;
      if (other.hasKerberosConfig()) {
        mergeKerberosConfig(other.getKerberosConfig());
      }
      if (other.endpointProtocol_ != 0) {
        setEndpointProtocolValue(other.getEndpointProtocolValue());
      }
      internalGetMutableAuxiliaryVersions().mergeFrom(other.internalGetAuxiliaryVersions());
      bitField0_ |= 0x00000010;
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                version_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> configOverrides__ =
                    input.readMessage(
                        ConfigOverridesDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableConfigOverrides()
                    .getMutableMap()
                    .put(configOverrides__.getKey(), configOverrides__.getValue());
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getKerberosConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 32:
              {
                endpointProtocol_ = input.readEnum();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            case 42:
              {
                com.google.protobuf.MapEntry<
                        java.lang.String, com.google.cloud.metastore.v1beta.AuxiliaryVersionConfig>
                    auxiliaryVersions__ =
                        input.readMessage(
                            AuxiliaryVersionsDefaultEntryHolder.defaultEntry.getParserForType(),
                            extensionRegistry);
                internalGetMutableAuxiliaryVersions()
                    .ensureBuilderMap()
                    .put(auxiliaryVersions__.getKey(), auxiliaryVersions__.getValue());
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object version_ = "";
    /**
     *
     *
     * <pre>
     * Immutable. The Hive metastore schema version.
     * </pre>
     *
     * <code>string version = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The version.
     */
    public java.lang.String getVersion() {
      java.lang.Object ref = version_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        version_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. The Hive metastore schema version.
     * </pre>
     *
     * <code>string version = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The bytes for version.
     */
    public com.google.protobuf.ByteString getVersionBytes() {
      java.lang.Object ref = version_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        version_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. The Hive metastore schema version.
     * </pre>
     *
     * <code>string version = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The version to set.
     * @return This builder for chaining.
     */
    public Builder setVersion(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      version_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The Hive metastore schema version.
     * </pre>
     *
     * <code>string version = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearVersion() {
      version_ = getDefaultInstance().getVersion();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The Hive metastore schema version.
     * </pre>
     *
     * <code>string version = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The bytes for version to set.
     * @return This builder for chaining.
     */
    public Builder setVersionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      version_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> configOverrides_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetConfigOverrides() {
      if (configOverrides_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            ConfigOverridesDefaultEntryHolder.defaultEntry);
      }
      return configOverrides_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableConfigOverrides() {
      if (configOverrides_ == null) {
        configOverrides_ =
            com.google.protobuf.MapField.newMapField(
                ConfigOverridesDefaultEntryHolder.defaultEntry);
      }
      if (!configOverrides_.isMutable()) {
        configOverrides_ = configOverrides_.copy();
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return configOverrides_;
    }

    public int getConfigOverridesCount() {
      return internalGetConfigOverrides().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * A mapping of Hive metastore configuration key-value pairs to apply to the
     * Hive metastore (configured in `hive-site.xml`). The mappings
     * override system defaults (some keys cannot be overridden). These
     * overrides are also applied to auxiliary versions and can be further
     * customized in the auxiliary version's `AuxiliaryVersionConfig`.
     * </pre>
     *
     * <code>map&lt;string, string&gt; config_overrides = 2;</code>
     */
    @java.lang.Override
    public boolean containsConfigOverrides(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetConfigOverrides().getMap().containsKey(key);
    }
    /** Use {@link #getConfigOverridesMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getConfigOverrides() {
      return getConfigOverridesMap();
    }
    /**
     *
     *
     * <pre>
     * A mapping of Hive metastore configuration key-value pairs to apply to the
     * Hive metastore (configured in `hive-site.xml`). The mappings
     * override system defaults (some keys cannot be overridden). These
     * overrides are also applied to auxiliary versions and can be further
     * customized in the auxiliary version's `AuxiliaryVersionConfig`.
     * </pre>
     *
     * <code>map&lt;string, string&gt; config_overrides = 2;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getConfigOverridesMap() {
      return internalGetConfigOverrides().getMap();
    }
    /**
     *
     *
     * <pre>
     * A mapping of Hive metastore configuration key-value pairs to apply to the
     * Hive metastore (configured in `hive-site.xml`). The mappings
     * override system defaults (some keys cannot be overridden). These
     * overrides are also applied to auxiliary versions and can be further
     * customized in the auxiliary version's `AuxiliaryVersionConfig`.
     * </pre>
     *
     * <code>map&lt;string, string&gt; config_overrides = 2;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getConfigOverridesOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetConfigOverrides().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * A mapping of Hive metastore configuration key-value pairs to apply to the
     * Hive metastore (configured in `hive-site.xml`). The mappings
     * override system defaults (some keys cannot be overridden). These
     * overrides are also applied to auxiliary versions and can be further
     * customized in the auxiliary version's `AuxiliaryVersionConfig`.
     * </pre>
     *
     * <code>map&lt;string, string&gt; config_overrides = 2;</code>
     */
    @java.lang.Override
    public java.lang.String getConfigOverridesOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetConfigOverrides().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearConfigOverrides() {
      bitField0_ = (bitField0_ & ~0x00000002);
      internalGetMutableConfigOverrides().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A mapping of Hive metastore configuration key-value pairs to apply to the
     * Hive metastore (configured in `hive-site.xml`). The mappings
     * override system defaults (some keys cannot be overridden). These
     * overrides are also applied to auxiliary versions and can be further
     * customized in the auxiliary version's `AuxiliaryVersionConfig`.
     * </pre>
     *
     * <code>map&lt;string, string&gt; config_overrides = 2;</code>
     */
    public Builder removeConfigOverrides(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableConfigOverrides().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableConfigOverrides() {
      bitField0_ |= 0x00000002;
      return internalGetMutableConfigOverrides().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * A mapping of Hive metastore configuration key-value pairs to apply to the
     * Hive metastore (configured in `hive-site.xml`). The mappings
     * override system defaults (some keys cannot be overridden). These
     * overrides are also applied to auxiliary versions and can be further
     * customized in the auxiliary version's `AuxiliaryVersionConfig`.
     * </pre>
     *
     * <code>map&lt;string, string&gt; config_overrides = 2;</code>
     */
    public Builder putConfigOverrides(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableConfigOverrides().getMutableMap().put(key, value);
      bitField0_ |= 0x00000002;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A mapping of Hive metastore configuration key-value pairs to apply to the
     * Hive metastore (configured in `hive-site.xml`). The mappings
     * override system defaults (some keys cannot be overridden). These
     * overrides are also applied to auxiliary versions and can be further
     * customized in the auxiliary version's `AuxiliaryVersionConfig`.
     * </pre>
     *
     * <code>map&lt;string, string&gt; config_overrides = 2;</code>
     */
    public Builder putAllConfigOverrides(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableConfigOverrides().getMutableMap().putAll(values);
      bitField0_ |= 0x00000002;
      return this;
    }

    private com.google.cloud.metastore.v1beta.KerberosConfig kerberosConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.metastore.v1beta.KerberosConfig,
            com.google.cloud.metastore.v1beta.KerberosConfig.Builder,
            com.google.cloud.metastore.v1beta.KerberosConfigOrBuilder>
        kerberosConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Information used to configure the Hive metastore service as a service
     * principal in a Kerberos realm. To disable Kerberos, use the `UpdateService`
     * method and specify this field's path
     * (`hive_metastore_config.kerberos_config`) in the request's `update_mask`
     * while omitting this field from the request's `service`.
     * </pre>
     *
     * <code>.google.cloud.metastore.v1beta.KerberosConfig kerberos_config = 3;</code>
     *
     * @return Whether the kerberosConfig field is set.
     */
    public boolean hasKerberosConfig() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Information used to configure the Hive metastore service as a service
     * principal in a Kerberos realm. To disable Kerberos, use the `UpdateService`
     * method and specify this field's path
     * (`hive_metastore_config.kerberos_config`) in the request's `update_mask`
     * while omitting this field from the request's `service`.
     * </pre>
     *
     * <code>.google.cloud.metastore.v1beta.KerberosConfig kerberos_config = 3;</code>
     *
     * @return The kerberosConfig.
     */
    public com.google.cloud.metastore.v1beta.KerberosConfig getKerberosConfig() {
      if (kerberosConfigBuilder_ == null) {
        return kerberosConfig_ == null
            ? com.google.cloud.metastore.v1beta.KerberosConfig.getDefaultInstance()
            : kerberosConfig_;
      } else {
        return kerberosConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Information used to configure the Hive metastore service as a service
     * principal in a Kerberos realm. To disable Kerberos, use the `UpdateService`
     * method and specify this field's path
     * (`hive_metastore_config.kerberos_config`) in the request's `update_mask`
     * while omitting this field from the request's `service`.
     * </pre>
     *
     * <code>.google.cloud.metastore.v1beta.KerberosConfig kerberos_config = 3;</code>
     */
    public Builder setKerberosConfig(com.google.cloud.metastore.v1beta.KerberosConfig value) {
      if (kerberosConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        kerberosConfig_ = value;
      } else {
        kerberosConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Information used to configure the Hive metastore service as a service
     * principal in a Kerberos realm. To disable Kerberos, use the `UpdateService`
     * method and specify this field's path
     * (`hive_metastore_config.kerberos_config`) in the request's `update_mask`
     * while omitting this field from the request's `service`.
     * </pre>
     *
     * <code>.google.cloud.metastore.v1beta.KerberosConfig kerberos_config = 3;</code>
     */
    public Builder setKerberosConfig(
        com.google.cloud.metastore.v1beta.KerberosConfig.Builder builderForValue) {
      if (kerberosConfigBuilder_ == null) {
        kerberosConfig_ = builderForValue.build();
      } else {
        kerberosConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Information used to configure the Hive metastore service as a service
     * principal in a Kerberos realm. To disable Kerberos, use the `UpdateService`
     * method and specify this field's path
     * (`hive_metastore_config.kerberos_config`) in the request's `update_mask`
     * while omitting this field from the request's `service`.
     * </pre>
     *
     * <code>.google.cloud.metastore.v1beta.KerberosConfig kerberos_config = 3;</code>
     */
    public Builder mergeKerberosConfig(com.google.cloud.metastore.v1beta.KerberosConfig value) {
      if (kerberosConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && kerberosConfig_ != null
            && kerberosConfig_
                != com.google.cloud.metastore.v1beta.KerberosConfig.getDefaultInstance()) {
          getKerberosConfigBuilder().mergeFrom(value);
        } else {
          kerberosConfig_ = value;
        }
      } else {
        kerberosConfigBuilder_.mergeFrom(value);
      }
      if (kerberosConfig_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Information used to configure the Hive metastore service as a service
     * principal in a Kerberos realm. To disable Kerberos, use the `UpdateService`
     * method and specify this field's path
     * (`hive_metastore_config.kerberos_config`) in the request's `update_mask`
     * while omitting this field from the request's `service`.
     * </pre>
     *
     * <code>.google.cloud.metastore.v1beta.KerberosConfig kerberos_config = 3;</code>
     */
    public Builder clearKerberosConfig() {
      bitField0_ = (bitField0_ & ~0x00000004);
      kerberosConfig_ = null;
      if (kerberosConfigBuilder_ != null) {
        kerberosConfigBuilder_.dispose();
        kerberosConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Information used to configure the Hive metastore service as a service
     * principal in a Kerberos realm. To disable Kerberos, use the `UpdateService`
     * method and specify this field's path
     * (`hive_metastore_config.kerberos_config`) in the request's `update_mask`
     * while omitting this field from the request's `service`.
     * </pre>
     *
     * <code>.google.cloud.metastore.v1beta.KerberosConfig kerberos_config = 3;</code>
     */
    public com.google.cloud.metastore.v1beta.KerberosConfig.Builder getKerberosConfigBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getKerberosConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Information used to configure the Hive metastore service as a service
     * principal in a Kerberos realm. To disable Kerberos, use the `UpdateService`
     * method and specify this field's path
     * (`hive_metastore_config.kerberos_config`) in the request's `update_mask`
     * while omitting this field from the request's `service`.
     * </pre>
     *
     * <code>.google.cloud.metastore.v1beta.KerberosConfig kerberos_config = 3;</code>
     */
    public com.google.cloud.metastore.v1beta.KerberosConfigOrBuilder getKerberosConfigOrBuilder() {
      if (kerberosConfigBuilder_ != null) {
        return kerberosConfigBuilder_.getMessageOrBuilder();
      } else {
        return kerberosConfig_ == null
            ? com.google.cloud.metastore.v1beta.KerberosConfig.getDefaultInstance()
            : kerberosConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Information used to configure the Hive metastore service as a service
     * principal in a Kerberos realm. To disable Kerberos, use the `UpdateService`
     * method and specify this field's path
     * (`hive_metastore_config.kerberos_config`) in the request's `update_mask`
     * while omitting this field from the request's `service`.
     * </pre>
     *
     * <code>.google.cloud.metastore.v1beta.KerberosConfig kerberos_config = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.metastore.v1beta.KerberosConfig,
            com.google.cloud.metastore.v1beta.KerberosConfig.Builder,
            com.google.cloud.metastore.v1beta.KerberosConfigOrBuilder>
        getKerberosConfigFieldBuilder() {
      if (kerberosConfigBuilder_ == null) {
        kerberosConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.metastore.v1beta.KerberosConfig,
                com.google.cloud.metastore.v1beta.KerberosConfig.Builder,
                com.google.cloud.metastore.v1beta.KerberosConfigOrBuilder>(
                getKerberosConfig(), getParentForChildren(), isClean());
        kerberosConfig_ = null;
      }
      return kerberosConfigBuilder_;
    }

    private int endpointProtocol_ = 0;
    /**
     *
     *
     * <pre>
     * The protocol to use for the metastore service endpoint. If unspecified,
     * defaults to `THRIFT`.
     * </pre>
     *
     * <code>
     * .google.cloud.metastore.v1beta.HiveMetastoreConfig.EndpointProtocol endpoint_protocol = 4;
     * </code>
     *
     * @return The enum numeric value on the wire for endpointProtocol.
     */
    @java.lang.Override
    public int getEndpointProtocolValue() {
      return endpointProtocol_;
    }
    /**
     *
     *
     * <pre>
     * The protocol to use for the metastore service endpoint. If unspecified,
     * defaults to `THRIFT`.
     * </pre>
     *
     * <code>
     * .google.cloud.metastore.v1beta.HiveMetastoreConfig.EndpointProtocol endpoint_protocol = 4;
     * </code>
     *
     * @param value The enum numeric value on the wire for endpointProtocol to set.
     * @return This builder for chaining.
     */
    public Builder setEndpointProtocolValue(int value) {
      endpointProtocol_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The protocol to use for the metastore service endpoint. If unspecified,
     * defaults to `THRIFT`.
     * </pre>
     *
     * <code>
     * .google.cloud.metastore.v1beta.HiveMetastoreConfig.EndpointProtocol endpoint_protocol = 4;
     * </code>
     *
     * @return The endpointProtocol.
     */
    @java.lang.Override
    public com.google.cloud.metastore.v1beta.HiveMetastoreConfig.EndpointProtocol
        getEndpointProtocol() {
      com.google.cloud.metastore.v1beta.HiveMetastoreConfig.EndpointProtocol result =
          com.google.cloud.metastore.v1beta.HiveMetastoreConfig.EndpointProtocol.forNumber(
              endpointProtocol_);
      return result == null
          ? com.google.cloud.metastore.v1beta.HiveMetastoreConfig.EndpointProtocol.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * The protocol to use for the metastore service endpoint. If unspecified,
     * defaults to `THRIFT`.
     * </pre>
     *
     * <code>
     * .google.cloud.metastore.v1beta.HiveMetastoreConfig.EndpointProtocol endpoint_protocol = 4;
     * </code>
     *
     * @param value The endpointProtocol to set.
     * @return This builder for chaining.
     */
    public Builder setEndpointProtocol(
        com.google.cloud.metastore.v1beta.HiveMetastoreConfig.EndpointProtocol value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000008;
      endpointProtocol_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The protocol to use for the metastore service endpoint. If unspecified,
     * defaults to `THRIFT`.
     * </pre>
     *
     * <code>
     * .google.cloud.metastore.v1beta.HiveMetastoreConfig.EndpointProtocol endpoint_protocol = 4;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEndpointProtocol() {
      bitField0_ = (bitField0_ & ~0x00000008);
      endpointProtocol_ = 0;
      onChanged();
      return this;
    }

    private static final class AuxiliaryVersionsConverter
        implements com.google.protobuf.MapFieldBuilder.Converter<
            java.lang.String,
            com.google.cloud.metastore.v1beta.AuxiliaryVersionConfigOrBuilder,
            com.google.cloud.metastore.v1beta.AuxiliaryVersionConfig> {
      @java.lang.Override
      public com.google.cloud.metastore.v1beta.AuxiliaryVersionConfig build(
          com.google.cloud.metastore.v1beta.AuxiliaryVersionConfigOrBuilder val) {
        if (val instanceof com.google.cloud.metastore.v1beta.AuxiliaryVersionConfig) {
          return (com.google.cloud.metastore.v1beta.AuxiliaryVersionConfig) val;
        }
        return ((com.google.cloud.metastore.v1beta.AuxiliaryVersionConfig.Builder) val).build();
      }

      @java.lang.Override
      public com.google.protobuf.MapEntry<
              java.lang.String, com.google.cloud.metastore.v1beta.AuxiliaryVersionConfig>
          defaultEntry() {
        return AuxiliaryVersionsDefaultEntryHolder.defaultEntry;
      }
    };

    private static final AuxiliaryVersionsConverter auxiliaryVersionsConverter =
        new AuxiliaryVersionsConverter();

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.cloud.metastore.v1beta.AuxiliaryVersionConfigOrBuilder,
            com.google.cloud.metastore.v1beta.AuxiliaryVersionConfig,
            com.google.cloud.metastore.v1beta.AuxiliaryVersionConfig.Builder>
        auxiliaryVersions_;

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.cloud.metastore.v1beta.AuxiliaryVersionConfigOrBuilder,
            com.google.cloud.metastore.v1beta.AuxiliaryVersionConfig,
            com.google.cloud.metastore.v1beta.AuxiliaryVersionConfig.Builder>
        internalGetAuxiliaryVersions() {
      if (auxiliaryVersions_ == null) {
        return new com.google.protobuf.MapFieldBuilder<>(auxiliaryVersionsConverter);
      }
      return auxiliaryVersions_;
    }

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.cloud.metastore.v1beta.AuxiliaryVersionConfigOrBuilder,
            com.google.cloud.metastore.v1beta.AuxiliaryVersionConfig,
            com.google.cloud.metastore.v1beta.AuxiliaryVersionConfig.Builder>
        internalGetMutableAuxiliaryVersions() {
      if (auxiliaryVersions_ == null) {
        auxiliaryVersions_ = new com.google.protobuf.MapFieldBuilder<>(auxiliaryVersionsConverter);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return auxiliaryVersions_;
    }

    public int getAuxiliaryVersionsCount() {
      return internalGetAuxiliaryVersions().ensureBuilderMap().size();
    }
    /**
     *
     *
     * <pre>
     * A mapping of Hive metastore version to the auxiliary version
     * configuration. When specified, a secondary Hive metastore service is
     * created along with the primary service. All auxiliary versions must be less
     * than the service's primary version. The key is the auxiliary service name
     * and it must match the regular expression [a-z]([-a-z0-9]*[a-z0-9])?. This
     * means that the first character must be a lowercase letter, and all the
     * following characters must be hyphens, lowercase letters, or digits, except
     * the last character, which cannot be a hyphen.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.metastore.v1beta.AuxiliaryVersionConfig&gt; auxiliary_versions = 5;
     * </code>
     */
    @java.lang.Override
    public boolean containsAuxiliaryVersions(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetAuxiliaryVersions().ensureBuilderMap().containsKey(key);
    }
    /** Use {@link #getAuxiliaryVersionsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.cloud.metastore.v1beta.AuxiliaryVersionConfig>
        getAuxiliaryVersions() {
      return getAuxiliaryVersionsMap();
    }
    /**
     *
     *
     * <pre>
     * A mapping of Hive metastore version to the auxiliary version
     * configuration. When specified, a secondary Hive metastore service is
     * created along with the primary service. All auxiliary versions must be less
     * than the service's primary version. The key is the auxiliary service name
     * and it must match the regular expression [a-z]([-a-z0-9]*[a-z0-9])?. This
     * means that the first character must be a lowercase letter, and all the
     * following characters must be hyphens, lowercase letters, or digits, except
     * the last character, which cannot be a hyphen.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.metastore.v1beta.AuxiliaryVersionConfig&gt; auxiliary_versions = 5;
     * </code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, com.google.cloud.metastore.v1beta.AuxiliaryVersionConfig>
        getAuxiliaryVersionsMap() {
      return internalGetAuxiliaryVersions().getImmutableMap();
    }
    /**
     *
     *
     * <pre>
     * A mapping of Hive metastore version to the auxiliary version
     * configuration. When specified, a secondary Hive metastore service is
     * created along with the primary service. All auxiliary versions must be less
     * than the service's primary version. The key is the auxiliary service name
     * and it must match the regular expression [a-z]([-a-z0-9]*[a-z0-9])?. This
     * means that the first character must be a lowercase letter, and all the
     * following characters must be hyphens, lowercase letters, or digits, except
     * the last character, which cannot be a hyphen.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.metastore.v1beta.AuxiliaryVersionConfig&gt; auxiliary_versions = 5;
     * </code>
     */
    @java.lang.Override
    public /* nullable */ com.google.cloud.metastore.v1beta.AuxiliaryVersionConfig
        getAuxiliaryVersionsOrDefault(
            java.lang.String key,
            /* nullable */
            com.google.cloud.metastore.v1beta.AuxiliaryVersionConfig defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<
              java.lang.String, com.google.cloud.metastore.v1beta.AuxiliaryVersionConfigOrBuilder>
          map = internalGetMutableAuxiliaryVersions().ensureBuilderMap();
      return map.containsKey(key) ? auxiliaryVersionsConverter.build(map.get(key)) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * A mapping of Hive metastore version to the auxiliary version
     * configuration. When specified, a secondary Hive metastore service is
     * created along with the primary service. All auxiliary versions must be less
     * than the service's primary version. The key is the auxiliary service name
     * and it must match the regular expression [a-z]([-a-z0-9]*[a-z0-9])?. This
     * means that the first character must be a lowercase letter, and all the
     * following characters must be hyphens, lowercase letters, or digits, except
     * the last character, which cannot be a hyphen.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.metastore.v1beta.AuxiliaryVersionConfig&gt; auxiliary_versions = 5;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.metastore.v1beta.AuxiliaryVersionConfig getAuxiliaryVersionsOrThrow(
        java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<
              java.lang.String, com.google.cloud.metastore.v1beta.AuxiliaryVersionConfigOrBuilder>
          map = internalGetMutableAuxiliaryVersions().ensureBuilderMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return auxiliaryVersionsConverter.build(map.get(key));
    }

    public Builder clearAuxiliaryVersions() {
      bitField0_ = (bitField0_ & ~0x00000010);
      internalGetMutableAuxiliaryVersions().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A mapping of Hive metastore version to the auxiliary version
     * configuration. When specified, a secondary Hive metastore service is
     * created along with the primary service. All auxiliary versions must be less
     * than the service's primary version. The key is the auxiliary service name
     * and it must match the regular expression [a-z]([-a-z0-9]*[a-z0-9])?. This
     * means that the first character must be a lowercase letter, and all the
     * following characters must be hyphens, lowercase letters, or digits, except
     * the last character, which cannot be a hyphen.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.metastore.v1beta.AuxiliaryVersionConfig&gt; auxiliary_versions = 5;
     * </code>
     */
    public Builder removeAuxiliaryVersions(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableAuxiliaryVersions().ensureBuilderMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.cloud.metastore.v1beta.AuxiliaryVersionConfig>
        getMutableAuxiliaryVersions() {
      bitField0_ |= 0x00000010;
      return internalGetMutableAuxiliaryVersions().ensureMessageMap();
    }
    /**
     *
     *
     * <pre>
     * A mapping of Hive metastore version to the auxiliary version
     * configuration. When specified, a secondary Hive metastore service is
     * created along with the primary service. All auxiliary versions must be less
     * than the service's primary version. The key is the auxiliary service name
     * and it must match the regular expression [a-z]([-a-z0-9]*[a-z0-9])?. This
     * means that the first character must be a lowercase letter, and all the
     * following characters must be hyphens, lowercase letters, or digits, except
     * the last character, which cannot be a hyphen.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.metastore.v1beta.AuxiliaryVersionConfig&gt; auxiliary_versions = 5;
     * </code>
     */
    public Builder putAuxiliaryVersions(
        java.lang.String key, com.google.cloud.metastore.v1beta.AuxiliaryVersionConfig value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableAuxiliaryVersions().ensureBuilderMap().put(key, value);
      bitField0_ |= 0x00000010;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A mapping of Hive metastore version to the auxiliary version
     * configuration. When specified, a secondary Hive metastore service is
     * created along with the primary service. All auxiliary versions must be less
     * than the service's primary version. The key is the auxiliary service name
     * and it must match the regular expression [a-z]([-a-z0-9]*[a-z0-9])?. This
     * means that the first character must be a lowercase letter, and all the
     * following characters must be hyphens, lowercase letters, or digits, except
     * the last character, which cannot be a hyphen.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.metastore.v1beta.AuxiliaryVersionConfig&gt; auxiliary_versions = 5;
     * </code>
     */
    public Builder putAllAuxiliaryVersions(
        java.util.Map<java.lang.String, com.google.cloud.metastore.v1beta.AuxiliaryVersionConfig>
            values) {
      for (java.util.Map.Entry<
              java.lang.String, com.google.cloud.metastore.v1beta.AuxiliaryVersionConfig>
          e : values.entrySet()) {
        if (e.getKey() == null || e.getValue() == null) {
          throw new NullPointerException();
        }
      }
      internalGetMutableAuxiliaryVersions().ensureBuilderMap().putAll(values);
      bitField0_ |= 0x00000010;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A mapping of Hive metastore version to the auxiliary version
     * configuration. When specified, a secondary Hive metastore service is
     * created along with the primary service. All auxiliary versions must be less
     * than the service's primary version. The key is the auxiliary service name
     * and it must match the regular expression [a-z]([-a-z0-9]*[a-z0-9])?. This
     * means that the first character must be a lowercase letter, and all the
     * following characters must be hyphens, lowercase letters, or digits, except
     * the last character, which cannot be a hyphen.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.metastore.v1beta.AuxiliaryVersionConfig&gt; auxiliary_versions = 5;
     * </code>
     */
    public com.google.cloud.metastore.v1beta.AuxiliaryVersionConfig.Builder
        putAuxiliaryVersionsBuilderIfAbsent(java.lang.String key) {
      java.util.Map<
              java.lang.String, com.google.cloud.metastore.v1beta.AuxiliaryVersionConfigOrBuilder>
          builderMap = internalGetMutableAuxiliaryVersions().ensureBuilderMap();
      com.google.cloud.metastore.v1beta.AuxiliaryVersionConfigOrBuilder entry = builderMap.get(key);
      if (entry == null) {
        entry = com.google.cloud.metastore.v1beta.AuxiliaryVersionConfig.newBuilder();
        builderMap.put(key, entry);
      }
      if (entry instanceof com.google.cloud.metastore.v1beta.AuxiliaryVersionConfig) {
        entry = ((com.google.cloud.metastore.v1beta.AuxiliaryVersionConfig) entry).toBuilder();
        builderMap.put(key, entry);
      }
      return (com.google.cloud.metastore.v1beta.AuxiliaryVersionConfig.Builder) entry;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.metastore.v1beta.HiveMetastoreConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.metastore.v1beta.HiveMetastoreConfig)
  private static final com.google.cloud.metastore.v1beta.HiveMetastoreConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.metastore.v1beta.HiveMetastoreConfig();
  }

  public static com.google.cloud.metastore.v1beta.HiveMetastoreConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<HiveMetastoreConfig> PARSER =
      new com.google.protobuf.AbstractParser<HiveMetastoreConfig>() {
        @java.lang.Override
        public HiveMetastoreConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<HiveMetastoreConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<HiveMetastoreConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.metastore.v1beta.HiveMetastoreConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
