/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/metastore/v1beta/metastore.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.metastore.v1beta;

/**
 *
 *
 * <pre>
 * Network configuration for the Dataproc Metastore service.
 *
 * Next available ID: 4
 * </pre>
 *
 * Protobuf type {@code google.cloud.metastore.v1beta.NetworkConfig}
 */
public final class NetworkConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.metastore.v1beta.NetworkConfig)
    NetworkConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use NetworkConfig.newBuilder() to construct.
  private NetworkConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private NetworkConfig() {
    consumers_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new NetworkConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.metastore.v1beta.MetastoreProto
        .internal_static_google_cloud_metastore_v1beta_NetworkConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.metastore.v1beta.MetastoreProto
        .internal_static_google_cloud_metastore_v1beta_NetworkConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.metastore.v1beta.NetworkConfig.class,
            com.google.cloud.metastore.v1beta.NetworkConfig.Builder.class);
  }

  public interface ConsumerOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.metastore.v1beta.NetworkConfig.Consumer)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Immutable. The subnetwork of the customer project from which an IP
     * address is reserved and used as the Dataproc Metastore service's
     * endpoint. It is accessible to hosts in the subnet and to all
     * hosts in a subnet in the same region and same network. There must
     * be at least one IP address available in the subnet's primary range. The
     * subnet is specified in the following form:
     *
     * `projects/{project_number}/regions/{region_id}/subnetworks/{subnetwork_id}`
     * </pre>
     *
     * <code>
     * string subnetwork = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return Whether the subnetwork field is set.
     */
    boolean hasSubnetwork();
    /**
     *
     *
     * <pre>
     * Immutable. The subnetwork of the customer project from which an IP
     * address is reserved and used as the Dataproc Metastore service's
     * endpoint. It is accessible to hosts in the subnet and to all
     * hosts in a subnet in the same region and same network. There must
     * be at least one IP address available in the subnet's primary range. The
     * subnet is specified in the following form:
     *
     * `projects/{project_number}/regions/{region_id}/subnetworks/{subnetwork_id}`
     * </pre>
     *
     * <code>
     * string subnetwork = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The subnetwork.
     */
    java.lang.String getSubnetwork();
    /**
     *
     *
     * <pre>
     * Immutable. The subnetwork of the customer project from which an IP
     * address is reserved and used as the Dataproc Metastore service's
     * endpoint. It is accessible to hosts in the subnet and to all
     * hosts in a subnet in the same region and same network. There must
     * be at least one IP address available in the subnet's primary range. The
     * subnet is specified in the following form:
     *
     * `projects/{project_number}/regions/{region_id}/subnetworks/{subnetwork_id}`
     * </pre>
     *
     * <code>
     * string subnetwork = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for subnetwork.
     */
    com.google.protobuf.ByteString getSubnetworkBytes();

    /**
     *
     *
     * <pre>
     * Output only. The URI of the endpoint used to access the metastore
     * service.
     * </pre>
     *
     * <code>string endpoint_uri = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The endpointUri.
     */
    java.lang.String getEndpointUri();
    /**
     *
     *
     * <pre>
     * Output only. The URI of the endpoint used to access the metastore
     * service.
     * </pre>
     *
     * <code>string endpoint_uri = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for endpointUri.
     */
    com.google.protobuf.ByteString getEndpointUriBytes();

    /**
     *
     *
     * <pre>
     * Output only. The location of the endpoint URI. Format:
     * `projects/{project}/locations/{location}`.
     * </pre>
     *
     * <code>
     * string endpoint_location = 4 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The endpointLocation.
     */
    java.lang.String getEndpointLocation();
    /**
     *
     *
     * <pre>
     * Output only. The location of the endpoint URI. Format:
     * `projects/{project}/locations/{location}`.
     * </pre>
     *
     * <code>
     * string endpoint_location = 4 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for endpointLocation.
     */
    com.google.protobuf.ByteString getEndpointLocationBytes();

    com.google.cloud.metastore.v1beta.NetworkConfig.Consumer.VpcResourceCase getVpcResourceCase();
  }
  /**
   *
   *
   * <pre>
   * Contains information of the customer's network configurations.
   *
   * Next available ID: 5
   * </pre>
   *
   * Protobuf type {@code google.cloud.metastore.v1beta.NetworkConfig.Consumer}
   */
  public static final class Consumer extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.metastore.v1beta.NetworkConfig.Consumer)
      ConsumerOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Consumer.newBuilder() to construct.
    private Consumer(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Consumer() {
      endpointUri_ = "";
      endpointLocation_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Consumer();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.metastore.v1beta.MetastoreProto
          .internal_static_google_cloud_metastore_v1beta_NetworkConfig_Consumer_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.metastore.v1beta.MetastoreProto
          .internal_static_google_cloud_metastore_v1beta_NetworkConfig_Consumer_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.metastore.v1beta.NetworkConfig.Consumer.class,
              com.google.cloud.metastore.v1beta.NetworkConfig.Consumer.Builder.class);
    }

    private int vpcResourceCase_ = 0;

    @SuppressWarnings("serial")
    private java.lang.Object vpcResource_;

    public enum VpcResourceCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      SUBNETWORK(1),
      VPCRESOURCE_NOT_SET(0);
      private final int value;

      private VpcResourceCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static VpcResourceCase valueOf(int value) {
        return forNumber(value);
      }

      public static VpcResourceCase forNumber(int value) {
        switch (value) {
          case 1:
            return SUBNETWORK;
          case 0:
            return VPCRESOURCE_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public VpcResourceCase getVpcResourceCase() {
      return VpcResourceCase.forNumber(vpcResourceCase_);
    }

    public static final int SUBNETWORK_FIELD_NUMBER = 1;
    /**
     *
     *
     * <pre>
     * Immutable. The subnetwork of the customer project from which an IP
     * address is reserved and used as the Dataproc Metastore service's
     * endpoint. It is accessible to hosts in the subnet and to all
     * hosts in a subnet in the same region and same network. There must
     * be at least one IP address available in the subnet's primary range. The
     * subnet is specified in the following form:
     *
     * `projects/{project_number}/regions/{region_id}/subnetworks/{subnetwork_id}`
     * </pre>
     *
     * <code>
     * string subnetwork = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return Whether the subnetwork field is set.
     */
    public boolean hasSubnetwork() {
      return vpcResourceCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The subnetwork of the customer project from which an IP
     * address is reserved and used as the Dataproc Metastore service's
     * endpoint. It is accessible to hosts in the subnet and to all
     * hosts in a subnet in the same region and same network. There must
     * be at least one IP address available in the subnet's primary range. The
     * subnet is specified in the following form:
     *
     * `projects/{project_number}/regions/{region_id}/subnetworks/{subnetwork_id}`
     * </pre>
     *
     * <code>
     * string subnetwork = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The subnetwork.
     */
    public java.lang.String getSubnetwork() {
      java.lang.Object ref = "";
      if (vpcResourceCase_ == 1) {
        ref = vpcResource_;
      }
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (vpcResourceCase_ == 1) {
          vpcResource_ = s;
        }
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. The subnetwork of the customer project from which an IP
     * address is reserved and used as the Dataproc Metastore service's
     * endpoint. It is accessible to hosts in the subnet and to all
     * hosts in a subnet in the same region and same network. There must
     * be at least one IP address available in the subnet's primary range. The
     * subnet is specified in the following form:
     *
     * `projects/{project_number}/regions/{region_id}/subnetworks/{subnetwork_id}`
     * </pre>
     *
     * <code>
     * string subnetwork = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for subnetwork.
     */
    public com.google.protobuf.ByteString getSubnetworkBytes() {
      java.lang.Object ref = "";
      if (vpcResourceCase_ == 1) {
        ref = vpcResource_;
      }
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (vpcResourceCase_ == 1) {
          vpcResource_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int ENDPOINT_URI_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private volatile java.lang.Object endpointUri_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The URI of the endpoint used to access the metastore
     * service.
     * </pre>
     *
     * <code>string endpoint_uri = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The endpointUri.
     */
    @java.lang.Override
    public java.lang.String getEndpointUri() {
      java.lang.Object ref = endpointUri_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        endpointUri_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The URI of the endpoint used to access the metastore
     * service.
     * </pre>
     *
     * <code>string endpoint_uri = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for endpointUri.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getEndpointUriBytes() {
      java.lang.Object ref = endpointUri_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        endpointUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int ENDPOINT_LOCATION_FIELD_NUMBER = 4;

    @SuppressWarnings("serial")
    private volatile java.lang.Object endpointLocation_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The location of the endpoint URI. Format:
     * `projects/{project}/locations/{location}`.
     * </pre>
     *
     * <code>
     * string endpoint_location = 4 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The endpointLocation.
     */
    @java.lang.Override
    public java.lang.String getEndpointLocation() {
      java.lang.Object ref = endpointLocation_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        endpointLocation_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The location of the endpoint URI. Format:
     * `projects/{project}/locations/{location}`.
     * </pre>
     *
     * <code>
     * string endpoint_location = 4 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for endpointLocation.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getEndpointLocationBytes() {
      java.lang.Object ref = endpointLocation_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        endpointLocation_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (vpcResourceCase_ == 1) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, vpcResource_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(endpointUri_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, endpointUri_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(endpointLocation_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 4, endpointLocation_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (vpcResourceCase_ == 1) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, vpcResource_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(endpointUri_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, endpointUri_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(endpointLocation_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, endpointLocation_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.metastore.v1beta.NetworkConfig.Consumer)) {
        return super.equals(obj);
      }
      com.google.cloud.metastore.v1beta.NetworkConfig.Consumer other =
          (com.google.cloud.metastore.v1beta.NetworkConfig.Consumer) obj;

      if (!getEndpointUri().equals(other.getEndpointUri())) return false;
      if (!getEndpointLocation().equals(other.getEndpointLocation())) return false;
      if (!getVpcResourceCase().equals(other.getVpcResourceCase())) return false;
      switch (vpcResourceCase_) {
        case 1:
          if (!getSubnetwork().equals(other.getSubnetwork())) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + ENDPOINT_URI_FIELD_NUMBER;
      hash = (53 * hash) + getEndpointUri().hashCode();
      hash = (37 * hash) + ENDPOINT_LOCATION_FIELD_NUMBER;
      hash = (53 * hash) + getEndpointLocation().hashCode();
      switch (vpcResourceCase_) {
        case 1:
          hash = (37 * hash) + SUBNETWORK_FIELD_NUMBER;
          hash = (53 * hash) + getSubnetwork().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.metastore.v1beta.NetworkConfig.Consumer parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.metastore.v1beta.NetworkConfig.Consumer parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.metastore.v1beta.NetworkConfig.Consumer parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.metastore.v1beta.NetworkConfig.Consumer parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.metastore.v1beta.NetworkConfig.Consumer parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.metastore.v1beta.NetworkConfig.Consumer parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.metastore.v1beta.NetworkConfig.Consumer parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.metastore.v1beta.NetworkConfig.Consumer parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.metastore.v1beta.NetworkConfig.Consumer parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.metastore.v1beta.NetworkConfig.Consumer parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.metastore.v1beta.NetworkConfig.Consumer parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.metastore.v1beta.NetworkConfig.Consumer parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.metastore.v1beta.NetworkConfig.Consumer prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Contains information of the customer's network configurations.
     *
     * Next available ID: 5
     * </pre>
     *
     * Protobuf type {@code google.cloud.metastore.v1beta.NetworkConfig.Consumer}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.metastore.v1beta.NetworkConfig.Consumer)
        com.google.cloud.metastore.v1beta.NetworkConfig.ConsumerOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.metastore.v1beta.MetastoreProto
            .internal_static_google_cloud_metastore_v1beta_NetworkConfig_Consumer_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.metastore.v1beta.MetastoreProto
            .internal_static_google_cloud_metastore_v1beta_NetworkConfig_Consumer_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.metastore.v1beta.NetworkConfig.Consumer.class,
                com.google.cloud.metastore.v1beta.NetworkConfig.Consumer.Builder.class);
      }

      // Construct using com.google.cloud.metastore.v1beta.NetworkConfig.Consumer.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        endpointUri_ = "";
        endpointLocation_ = "";
        vpcResourceCase_ = 0;
        vpcResource_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.metastore.v1beta.MetastoreProto
            .internal_static_google_cloud_metastore_v1beta_NetworkConfig_Consumer_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.metastore.v1beta.NetworkConfig.Consumer getDefaultInstanceForType() {
        return com.google.cloud.metastore.v1beta.NetworkConfig.Consumer.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.metastore.v1beta.NetworkConfig.Consumer build() {
        com.google.cloud.metastore.v1beta.NetworkConfig.Consumer result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.metastore.v1beta.NetworkConfig.Consumer buildPartial() {
        com.google.cloud.metastore.v1beta.NetworkConfig.Consumer result =
            new com.google.cloud.metastore.v1beta.NetworkConfig.Consumer(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloud.metastore.v1beta.NetworkConfig.Consumer result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.endpointUri_ = endpointUri_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.endpointLocation_ = endpointLocation_;
        }
      }

      private void buildPartialOneofs(
          com.google.cloud.metastore.v1beta.NetworkConfig.Consumer result) {
        result.vpcResourceCase_ = vpcResourceCase_;
        result.vpcResource_ = this.vpcResource_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.metastore.v1beta.NetworkConfig.Consumer) {
          return mergeFrom((com.google.cloud.metastore.v1beta.NetworkConfig.Consumer) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.metastore.v1beta.NetworkConfig.Consumer other) {
        if (other == com.google.cloud.metastore.v1beta.NetworkConfig.Consumer.getDefaultInstance())
          return this;
        if (!other.getEndpointUri().isEmpty()) {
          endpointUri_ = other.endpointUri_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (!other.getEndpointLocation().isEmpty()) {
          endpointLocation_ = other.endpointLocation_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        switch (other.getVpcResourceCase()) {
          case SUBNETWORK:
            {
              vpcResourceCase_ = 1;
              vpcResource_ = other.vpcResource_;
              onChanged();
              break;
            }
          case VPCRESOURCE_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  vpcResourceCase_ = 1;
                  vpcResource_ = s;
                  break;
                } // case 10
              case 26:
                {
                  endpointUri_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 26
              case 34:
                {
                  endpointLocation_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 34
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int vpcResourceCase_ = 0;
      private java.lang.Object vpcResource_;

      public VpcResourceCase getVpcResourceCase() {
        return VpcResourceCase.forNumber(vpcResourceCase_);
      }

      public Builder clearVpcResource() {
        vpcResourceCase_ = 0;
        vpcResource_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      /**
       *
       *
       * <pre>
       * Immutable. The subnetwork of the customer project from which an IP
       * address is reserved and used as the Dataproc Metastore service's
       * endpoint. It is accessible to hosts in the subnet and to all
       * hosts in a subnet in the same region and same network. There must
       * be at least one IP address available in the subnet's primary range. The
       * subnet is specified in the following form:
       *
       * `projects/{project_number}/regions/{region_id}/subnetworks/{subnetwork_id}`
       * </pre>
       *
       * <code>
       * string subnetwork = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return Whether the subnetwork field is set.
       */
      @java.lang.Override
      public boolean hasSubnetwork() {
        return vpcResourceCase_ == 1;
      }
      /**
       *
       *
       * <pre>
       * Immutable. The subnetwork of the customer project from which an IP
       * address is reserved and used as the Dataproc Metastore service's
       * endpoint. It is accessible to hosts in the subnet and to all
       * hosts in a subnet in the same region and same network. There must
       * be at least one IP address available in the subnet's primary range. The
       * subnet is specified in the following form:
       *
       * `projects/{project_number}/regions/{region_id}/subnetworks/{subnetwork_id}`
       * </pre>
       *
       * <code>
       * string subnetwork = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The subnetwork.
       */
      @java.lang.Override
      public java.lang.String getSubnetwork() {
        java.lang.Object ref = "";
        if (vpcResourceCase_ == 1) {
          ref = vpcResource_;
        }
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (vpcResourceCase_ == 1) {
            vpcResource_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Immutable. The subnetwork of the customer project from which an IP
       * address is reserved and used as the Dataproc Metastore service's
       * endpoint. It is accessible to hosts in the subnet and to all
       * hosts in a subnet in the same region and same network. There must
       * be at least one IP address available in the subnet's primary range. The
       * subnet is specified in the following form:
       *
       * `projects/{project_number}/regions/{region_id}/subnetworks/{subnetwork_id}`
       * </pre>
       *
       * <code>
       * string subnetwork = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The bytes for subnetwork.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getSubnetworkBytes() {
        java.lang.Object ref = "";
        if (vpcResourceCase_ == 1) {
          ref = vpcResource_;
        }
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          if (vpcResourceCase_ == 1) {
            vpcResource_ = b;
          }
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Immutable. The subnetwork of the customer project from which an IP
       * address is reserved and used as the Dataproc Metastore service's
       * endpoint. It is accessible to hosts in the subnet and to all
       * hosts in a subnet in the same region and same network. There must
       * be at least one IP address available in the subnet's primary range. The
       * subnet is specified in the following form:
       *
       * `projects/{project_number}/regions/{region_id}/subnetworks/{subnetwork_id}`
       * </pre>
       *
       * <code>
       * string subnetwork = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The subnetwork to set.
       * @return This builder for chaining.
       */
      public Builder setSubnetwork(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        vpcResourceCase_ = 1;
        vpcResource_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Immutable. The subnetwork of the customer project from which an IP
       * address is reserved and used as the Dataproc Metastore service's
       * endpoint. It is accessible to hosts in the subnet and to all
       * hosts in a subnet in the same region and same network. There must
       * be at least one IP address available in the subnet's primary range. The
       * subnet is specified in the following form:
       *
       * `projects/{project_number}/regions/{region_id}/subnetworks/{subnetwork_id}`
       * </pre>
       *
       * <code>
       * string subnetwork = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearSubnetwork() {
        if (vpcResourceCase_ == 1) {
          vpcResourceCase_ = 0;
          vpcResource_ = null;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Immutable. The subnetwork of the customer project from which an IP
       * address is reserved and used as the Dataproc Metastore service's
       * endpoint. It is accessible to hosts in the subnet and to all
       * hosts in a subnet in the same region and same network. There must
       * be at least one IP address available in the subnet's primary range. The
       * subnet is specified in the following form:
       *
       * `projects/{project_number}/regions/{region_id}/subnetworks/{subnetwork_id}`
       * </pre>
       *
       * <code>
       * string subnetwork = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The bytes for subnetwork to set.
       * @return This builder for chaining.
       */
      public Builder setSubnetworkBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        vpcResourceCase_ = 1;
        vpcResource_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object endpointUri_ = "";
      /**
       *
       *
       * <pre>
       * Output only. The URI of the endpoint used to access the metastore
       * service.
       * </pre>
       *
       * <code>string endpoint_uri = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The endpointUri.
       */
      public java.lang.String getEndpointUri() {
        java.lang.Object ref = endpointUri_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          endpointUri_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The URI of the endpoint used to access the metastore
       * service.
       * </pre>
       *
       * <code>string endpoint_uri = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The bytes for endpointUri.
       */
      public com.google.protobuf.ByteString getEndpointUriBytes() {
        java.lang.Object ref = endpointUri_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          endpointUri_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The URI of the endpoint used to access the metastore
       * service.
       * </pre>
       *
       * <code>string endpoint_uri = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The endpointUri to set.
       * @return This builder for chaining.
       */
      public Builder setEndpointUri(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        endpointUri_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The URI of the endpoint used to access the metastore
       * service.
       * </pre>
       *
       * <code>string endpoint_uri = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearEndpointUri() {
        endpointUri_ = getDefaultInstance().getEndpointUri();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The URI of the endpoint used to access the metastore
       * service.
       * </pre>
       *
       * <code>string endpoint_uri = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The bytes for endpointUri to set.
       * @return This builder for chaining.
       */
      public Builder setEndpointUriBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        endpointUri_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private java.lang.Object endpointLocation_ = "";
      /**
       *
       *
       * <pre>
       * Output only. The location of the endpoint URI. Format:
       * `projects/{project}/locations/{location}`.
       * </pre>
       *
       * <code>
       * string endpoint_location = 4 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The endpointLocation.
       */
      public java.lang.String getEndpointLocation() {
        java.lang.Object ref = endpointLocation_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          endpointLocation_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The location of the endpoint URI. Format:
       * `projects/{project}/locations/{location}`.
       * </pre>
       *
       * <code>
       * string endpoint_location = 4 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The bytes for endpointLocation.
       */
      public com.google.protobuf.ByteString getEndpointLocationBytes() {
        java.lang.Object ref = endpointLocation_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          endpointLocation_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The location of the endpoint URI. Format:
       * `projects/{project}/locations/{location}`.
       * </pre>
       *
       * <code>
       * string endpoint_location = 4 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The endpointLocation to set.
       * @return This builder for chaining.
       */
      public Builder setEndpointLocation(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        endpointLocation_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The location of the endpoint URI. Format:
       * `projects/{project}/locations/{location}`.
       * </pre>
       *
       * <code>
       * string endpoint_location = 4 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearEndpointLocation() {
        endpointLocation_ = getDefaultInstance().getEndpointLocation();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The location of the endpoint URI. Format:
       * `projects/{project}/locations/{location}`.
       * </pre>
       *
       * <code>
       * string endpoint_location = 4 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The bytes for endpointLocation to set.
       * @return This builder for chaining.
       */
      public Builder setEndpointLocationBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        endpointLocation_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.metastore.v1beta.NetworkConfig.Consumer)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.metastore.v1beta.NetworkConfig.Consumer)
    private static final com.google.cloud.metastore.v1beta.NetworkConfig.Consumer DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.metastore.v1beta.NetworkConfig.Consumer();
    }

    public static com.google.cloud.metastore.v1beta.NetworkConfig.Consumer getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Consumer> PARSER =
        new com.google.protobuf.AbstractParser<Consumer>() {
          @java.lang.Override
          public Consumer parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Consumer> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Consumer> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.metastore.v1beta.NetworkConfig.Consumer getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int CONSUMERS_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.metastore.v1beta.NetworkConfig.Consumer> consumers_;
  /**
   *
   *
   * <pre>
   * Immutable. The consumer-side network configuration for the Dataproc
   * Metastore instance.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.metastore.v1beta.NetworkConfig.Consumer consumers = 1 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.metastore.v1beta.NetworkConfig.Consumer>
      getConsumersList() {
    return consumers_;
  }
  /**
   *
   *
   * <pre>
   * Immutable. The consumer-side network configuration for the Dataproc
   * Metastore instance.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.metastore.v1beta.NetworkConfig.Consumer consumers = 1 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.metastore.v1beta.NetworkConfig.ConsumerOrBuilder>
      getConsumersOrBuilderList() {
    return consumers_;
  }
  /**
   *
   *
   * <pre>
   * Immutable. The consumer-side network configuration for the Dataproc
   * Metastore instance.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.metastore.v1beta.NetworkConfig.Consumer consumers = 1 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   */
  @java.lang.Override
  public int getConsumersCount() {
    return consumers_.size();
  }
  /**
   *
   *
   * <pre>
   * Immutable. The consumer-side network configuration for the Dataproc
   * Metastore instance.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.metastore.v1beta.NetworkConfig.Consumer consumers = 1 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.metastore.v1beta.NetworkConfig.Consumer getConsumers(int index) {
    return consumers_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Immutable. The consumer-side network configuration for the Dataproc
   * Metastore instance.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.metastore.v1beta.NetworkConfig.Consumer consumers = 1 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.metastore.v1beta.NetworkConfig.ConsumerOrBuilder getConsumersOrBuilder(
      int index) {
    return consumers_.get(index);
  }

  public static final int CUSTOM_ROUTES_ENABLED_FIELD_NUMBER = 2;
  private boolean customRoutesEnabled_ = false;
  /**
   *
   *
   * <pre>
   * Enables custom routes to be imported and exported for the Dataproc
   * Metastore service's peered VPC network.
   * </pre>
   *
   * <code>bool custom_routes_enabled = 2;</code>
   *
   * @return The customRoutesEnabled.
   */
  @java.lang.Override
  public boolean getCustomRoutesEnabled() {
    return customRoutesEnabled_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < consumers_.size(); i++) {
      output.writeMessage(1, consumers_.get(i));
    }
    if (customRoutesEnabled_ != false) {
      output.writeBool(2, customRoutesEnabled_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < consumers_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, consumers_.get(i));
    }
    if (customRoutesEnabled_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(2, customRoutesEnabled_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.metastore.v1beta.NetworkConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.metastore.v1beta.NetworkConfig other =
        (com.google.cloud.metastore.v1beta.NetworkConfig) obj;

    if (!getConsumersList().equals(other.getConsumersList())) return false;
    if (getCustomRoutesEnabled() != other.getCustomRoutesEnabled()) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getConsumersCount() > 0) {
      hash = (37 * hash) + CONSUMERS_FIELD_NUMBER;
      hash = (53 * hash) + getConsumersList().hashCode();
    }
    hash = (37 * hash) + CUSTOM_ROUTES_ENABLED_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getCustomRoutesEnabled());
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.metastore.v1beta.NetworkConfig parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.metastore.v1beta.NetworkConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.metastore.v1beta.NetworkConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.metastore.v1beta.NetworkConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.metastore.v1beta.NetworkConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.metastore.v1beta.NetworkConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.metastore.v1beta.NetworkConfig parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.metastore.v1beta.NetworkConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.metastore.v1beta.NetworkConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.metastore.v1beta.NetworkConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.metastore.v1beta.NetworkConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.metastore.v1beta.NetworkConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.metastore.v1beta.NetworkConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Network configuration for the Dataproc Metastore service.
   *
   * Next available ID: 4
   * </pre>
   *
   * Protobuf type {@code google.cloud.metastore.v1beta.NetworkConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.metastore.v1beta.NetworkConfig)
      com.google.cloud.metastore.v1beta.NetworkConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.metastore.v1beta.MetastoreProto
          .internal_static_google_cloud_metastore_v1beta_NetworkConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.metastore.v1beta.MetastoreProto
          .internal_static_google_cloud_metastore_v1beta_NetworkConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.metastore.v1beta.NetworkConfig.class,
              com.google.cloud.metastore.v1beta.NetworkConfig.Builder.class);
    }

    // Construct using com.google.cloud.metastore.v1beta.NetworkConfig.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (consumersBuilder_ == null) {
        consumers_ = java.util.Collections.emptyList();
      } else {
        consumers_ = null;
        consumersBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      customRoutesEnabled_ = false;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.metastore.v1beta.MetastoreProto
          .internal_static_google_cloud_metastore_v1beta_NetworkConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.metastore.v1beta.NetworkConfig getDefaultInstanceForType() {
      return com.google.cloud.metastore.v1beta.NetworkConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.metastore.v1beta.NetworkConfig build() {
      com.google.cloud.metastore.v1beta.NetworkConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.metastore.v1beta.NetworkConfig buildPartial() {
      com.google.cloud.metastore.v1beta.NetworkConfig result =
          new com.google.cloud.metastore.v1beta.NetworkConfig(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.metastore.v1beta.NetworkConfig result) {
      if (consumersBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          consumers_ = java.util.Collections.unmodifiableList(consumers_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.consumers_ = consumers_;
      } else {
        result.consumers_ = consumersBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.metastore.v1beta.NetworkConfig result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.customRoutesEnabled_ = customRoutesEnabled_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.metastore.v1beta.NetworkConfig) {
        return mergeFrom((com.google.cloud.metastore.v1beta.NetworkConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.metastore.v1beta.NetworkConfig other) {
      if (other == com.google.cloud.metastore.v1beta.NetworkConfig.getDefaultInstance())
        return this;
      if (consumersBuilder_ == null) {
        if (!other.consumers_.isEmpty()) {
          if (consumers_.isEmpty()) {
            consumers_ = other.consumers_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureConsumersIsMutable();
            consumers_.addAll(other.consumers_);
          }
          onChanged();
        }
      } else {
        if (!other.consumers_.isEmpty()) {
          if (consumersBuilder_.isEmpty()) {
            consumersBuilder_.dispose();
            consumersBuilder_ = null;
            consumers_ = other.consumers_;
            bitField0_ = (bitField0_ & ~0x00000001);
            consumersBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getConsumersFieldBuilder()
                    : null;
          } else {
            consumersBuilder_.addAllMessages(other.consumers_);
          }
        }
      }
      if (other.getCustomRoutesEnabled() != false) {
        setCustomRoutesEnabled(other.getCustomRoutesEnabled());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.cloud.metastore.v1beta.NetworkConfig.Consumer m =
                    input.readMessage(
                        com.google.cloud.metastore.v1beta.NetworkConfig.Consumer.parser(),
                        extensionRegistry);
                if (consumersBuilder_ == null) {
                  ensureConsumersIsMutable();
                  consumers_.add(m);
                } else {
                  consumersBuilder_.addMessage(m);
                }
                break;
              } // case 10
            case 16:
              {
                customRoutesEnabled_ = input.readBool();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.cloud.metastore.v1beta.NetworkConfig.Consumer> consumers_ =
        java.util.Collections.emptyList();

    private void ensureConsumersIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        consumers_ =
            new java.util.ArrayList<com.google.cloud.metastore.v1beta.NetworkConfig.Consumer>(
                consumers_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.metastore.v1beta.NetworkConfig.Consumer,
            com.google.cloud.metastore.v1beta.NetworkConfig.Consumer.Builder,
            com.google.cloud.metastore.v1beta.NetworkConfig.ConsumerOrBuilder>
        consumersBuilder_;

    /**
     *
     *
     * <pre>
     * Immutable. The consumer-side network configuration for the Dataproc
     * Metastore instance.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.metastore.v1beta.NetworkConfig.Consumer consumers = 1 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public java.util.List<com.google.cloud.metastore.v1beta.NetworkConfig.Consumer>
        getConsumersList() {
      if (consumersBuilder_ == null) {
        return java.util.Collections.unmodifiableList(consumers_);
      } else {
        return consumersBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. The consumer-side network configuration for the Dataproc
     * Metastore instance.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.metastore.v1beta.NetworkConfig.Consumer consumers = 1 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public int getConsumersCount() {
      if (consumersBuilder_ == null) {
        return consumers_.size();
      } else {
        return consumersBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. The consumer-side network configuration for the Dataproc
     * Metastore instance.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.metastore.v1beta.NetworkConfig.Consumer consumers = 1 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public com.google.cloud.metastore.v1beta.NetworkConfig.Consumer getConsumers(int index) {
      if (consumersBuilder_ == null) {
        return consumers_.get(index);
      } else {
        return consumersBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. The consumer-side network configuration for the Dataproc
     * Metastore instance.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.metastore.v1beta.NetworkConfig.Consumer consumers = 1 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder setConsumers(
        int index, com.google.cloud.metastore.v1beta.NetworkConfig.Consumer value) {
      if (consumersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureConsumersIsMutable();
        consumers_.set(index, value);
        onChanged();
      } else {
        consumersBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The consumer-side network configuration for the Dataproc
     * Metastore instance.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.metastore.v1beta.NetworkConfig.Consumer consumers = 1 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder setConsumers(
        int index,
        com.google.cloud.metastore.v1beta.NetworkConfig.Consumer.Builder builderForValue) {
      if (consumersBuilder_ == null) {
        ensureConsumersIsMutable();
        consumers_.set(index, builderForValue.build());
        onChanged();
      } else {
        consumersBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The consumer-side network configuration for the Dataproc
     * Metastore instance.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.metastore.v1beta.NetworkConfig.Consumer consumers = 1 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder addConsumers(com.google.cloud.metastore.v1beta.NetworkConfig.Consumer value) {
      if (consumersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureConsumersIsMutable();
        consumers_.add(value);
        onChanged();
      } else {
        consumersBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The consumer-side network configuration for the Dataproc
     * Metastore instance.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.metastore.v1beta.NetworkConfig.Consumer consumers = 1 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder addConsumers(
        int index, com.google.cloud.metastore.v1beta.NetworkConfig.Consumer value) {
      if (consumersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureConsumersIsMutable();
        consumers_.add(index, value);
        onChanged();
      } else {
        consumersBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The consumer-side network configuration for the Dataproc
     * Metastore instance.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.metastore.v1beta.NetworkConfig.Consumer consumers = 1 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder addConsumers(
        com.google.cloud.metastore.v1beta.NetworkConfig.Consumer.Builder builderForValue) {
      if (consumersBuilder_ == null) {
        ensureConsumersIsMutable();
        consumers_.add(builderForValue.build());
        onChanged();
      } else {
        consumersBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The consumer-side network configuration for the Dataproc
     * Metastore instance.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.metastore.v1beta.NetworkConfig.Consumer consumers = 1 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder addConsumers(
        int index,
        com.google.cloud.metastore.v1beta.NetworkConfig.Consumer.Builder builderForValue) {
      if (consumersBuilder_ == null) {
        ensureConsumersIsMutable();
        consumers_.add(index, builderForValue.build());
        onChanged();
      } else {
        consumersBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The consumer-side network configuration for the Dataproc
     * Metastore instance.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.metastore.v1beta.NetworkConfig.Consumer consumers = 1 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder addAllConsumers(
        java.lang.Iterable<? extends com.google.cloud.metastore.v1beta.NetworkConfig.Consumer>
            values) {
      if (consumersBuilder_ == null) {
        ensureConsumersIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, consumers_);
        onChanged();
      } else {
        consumersBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The consumer-side network configuration for the Dataproc
     * Metastore instance.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.metastore.v1beta.NetworkConfig.Consumer consumers = 1 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder clearConsumers() {
      if (consumersBuilder_ == null) {
        consumers_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        consumersBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The consumer-side network configuration for the Dataproc
     * Metastore instance.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.metastore.v1beta.NetworkConfig.Consumer consumers = 1 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder removeConsumers(int index) {
      if (consumersBuilder_ == null) {
        ensureConsumersIsMutable();
        consumers_.remove(index);
        onChanged();
      } else {
        consumersBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The consumer-side network configuration for the Dataproc
     * Metastore instance.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.metastore.v1beta.NetworkConfig.Consumer consumers = 1 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public com.google.cloud.metastore.v1beta.NetworkConfig.Consumer.Builder getConsumersBuilder(
        int index) {
      return getConsumersFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Immutable. The consumer-side network configuration for the Dataproc
     * Metastore instance.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.metastore.v1beta.NetworkConfig.Consumer consumers = 1 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public com.google.cloud.metastore.v1beta.NetworkConfig.ConsumerOrBuilder getConsumersOrBuilder(
        int index) {
      if (consumersBuilder_ == null) {
        return consumers_.get(index);
      } else {
        return consumersBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. The consumer-side network configuration for the Dataproc
     * Metastore instance.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.metastore.v1beta.NetworkConfig.Consumer consumers = 1 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.metastore.v1beta.NetworkConfig.ConsumerOrBuilder>
        getConsumersOrBuilderList() {
      if (consumersBuilder_ != null) {
        return consumersBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(consumers_);
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. The consumer-side network configuration for the Dataproc
     * Metastore instance.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.metastore.v1beta.NetworkConfig.Consumer consumers = 1 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public com.google.cloud.metastore.v1beta.NetworkConfig.Consumer.Builder addConsumersBuilder() {
      return getConsumersFieldBuilder()
          .addBuilder(
              com.google.cloud.metastore.v1beta.NetworkConfig.Consumer.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Immutable. The consumer-side network configuration for the Dataproc
     * Metastore instance.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.metastore.v1beta.NetworkConfig.Consumer consumers = 1 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public com.google.cloud.metastore.v1beta.NetworkConfig.Consumer.Builder addConsumersBuilder(
        int index) {
      return getConsumersFieldBuilder()
          .addBuilder(
              index, com.google.cloud.metastore.v1beta.NetworkConfig.Consumer.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Immutable. The consumer-side network configuration for the Dataproc
     * Metastore instance.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.metastore.v1beta.NetworkConfig.Consumer consumers = 1 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public java.util.List<com.google.cloud.metastore.v1beta.NetworkConfig.Consumer.Builder>
        getConsumersBuilderList() {
      return getConsumersFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.metastore.v1beta.NetworkConfig.Consumer,
            com.google.cloud.metastore.v1beta.NetworkConfig.Consumer.Builder,
            com.google.cloud.metastore.v1beta.NetworkConfig.ConsumerOrBuilder>
        getConsumersFieldBuilder() {
      if (consumersBuilder_ == null) {
        consumersBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.metastore.v1beta.NetworkConfig.Consumer,
                com.google.cloud.metastore.v1beta.NetworkConfig.Consumer.Builder,
                com.google.cloud.metastore.v1beta.NetworkConfig.ConsumerOrBuilder>(
                consumers_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        consumers_ = null;
      }
      return consumersBuilder_;
    }

    private boolean customRoutesEnabled_;
    /**
     *
     *
     * <pre>
     * Enables custom routes to be imported and exported for the Dataproc
     * Metastore service's peered VPC network.
     * </pre>
     *
     * <code>bool custom_routes_enabled = 2;</code>
     *
     * @return The customRoutesEnabled.
     */
    @java.lang.Override
    public boolean getCustomRoutesEnabled() {
      return customRoutesEnabled_;
    }
    /**
     *
     *
     * <pre>
     * Enables custom routes to be imported and exported for the Dataproc
     * Metastore service's peered VPC network.
     * </pre>
     *
     * <code>bool custom_routes_enabled = 2;</code>
     *
     * @param value The customRoutesEnabled to set.
     * @return This builder for chaining.
     */
    public Builder setCustomRoutesEnabled(boolean value) {

      customRoutesEnabled_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Enables custom routes to be imported and exported for the Dataproc
     * Metastore service's peered VPC network.
     * </pre>
     *
     * <code>bool custom_routes_enabled = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCustomRoutesEnabled() {
      bitField0_ = (bitField0_ & ~0x00000002);
      customRoutesEnabled_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.metastore.v1beta.NetworkConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.metastore.v1beta.NetworkConfig)
  private static final com.google.cloud.metastore.v1beta.NetworkConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.metastore.v1beta.NetworkConfig();
  }

  public static com.google.cloud.metastore.v1beta.NetworkConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<NetworkConfig> PARSER =
      new com.google.protobuf.AbstractParser<NetworkConfig>() {
        @java.lang.Override
        public NetworkConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<NetworkConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<NetworkConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.metastore.v1beta.NetworkConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
