/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dataproc/v1/clusters.proto

package com.google.cloud.dataproc.v1;

public interface AcceleratorConfigOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.dataproc.v1.AcceleratorConfig)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Full URL, partial URI, or short name of the accelerator type resource to
   * expose to this instance. See
   * [Compute Engine
   * AcceleratorTypes](https://cloud.google.com/compute/docs/reference/v1/acceleratorTypes).
   *
   * Examples:
   *
   * * `https://www.googleapis.com/compute/v1/projects/[project_id]/zones/[zone]/acceleratorTypes/nvidia-tesla-k80`
   * * `projects/[project_id]/zones/[zone]/acceleratorTypes/nvidia-tesla-k80`
   * * `nvidia-tesla-k80`
   *
   * **Auto Zone Exception**: If you are using the Dataproc
   * [Auto Zone
   * Placement](https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/auto-zone#using_auto_zone_placement)
   * feature, you must use the short name of the accelerator type
   * resource, for example, `nvidia-tesla-k80`.
   * </pre>
   *
   * <code>string accelerator_type_uri = 1;</code>
   *
   * @return The acceleratorTypeUri.
   */
  java.lang.String getAcceleratorTypeUri();
  /**
   *
   *
   * <pre>
   * Full URL, partial URI, or short name of the accelerator type resource to
   * expose to this instance. See
   * [Compute Engine
   * AcceleratorTypes](https://cloud.google.com/compute/docs/reference/v1/acceleratorTypes).
   *
   * Examples:
   *
   * * `https://www.googleapis.com/compute/v1/projects/[project_id]/zones/[zone]/acceleratorTypes/nvidia-tesla-k80`
   * * `projects/[project_id]/zones/[zone]/acceleratorTypes/nvidia-tesla-k80`
   * * `nvidia-tesla-k80`
   *
   * **Auto Zone Exception**: If you are using the Dataproc
   * [Auto Zone
   * Placement](https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/auto-zone#using_auto_zone_placement)
   * feature, you must use the short name of the accelerator type
   * resource, for example, `nvidia-tesla-k80`.
   * </pre>
   *
   * <code>string accelerator_type_uri = 1;</code>
   *
   * @return The bytes for acceleratorTypeUri.
   */
  com.google.protobuf.ByteString getAcceleratorTypeUriBytes();

  /**
   *
   *
   * <pre>
   * The number of the accelerator cards of this type exposed to this instance.
   * </pre>
   *
   * <code>int32 accelerator_count = 2;</code>
   *
   * @return The acceleratorCount.
   */
  int getAcceleratorCount();
}
