/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dataproc/v1/autoscaling_policies.proto

package com.google.cloud.dataproc.v1;

/**
 *
 *
 * <pre>
 * Basic algorithm for autoscaling.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dataproc.v1.BasicAutoscalingAlgorithm}
 */
public final class BasicAutoscalingAlgorithm extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dataproc.v1.BasicAutoscalingAlgorithm)
    BasicAutoscalingAlgorithmOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use BasicAutoscalingAlgorithm.newBuilder() to construct.
  private BasicAutoscalingAlgorithm(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private BasicAutoscalingAlgorithm() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new BasicAutoscalingAlgorithm();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dataproc.v1.AutoscalingPoliciesProto
        .internal_static_google_cloud_dataproc_v1_BasicAutoscalingAlgorithm_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dataproc.v1.AutoscalingPoliciesProto
        .internal_static_google_cloud_dataproc_v1_BasicAutoscalingAlgorithm_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dataproc.v1.BasicAutoscalingAlgorithm.class,
            com.google.cloud.dataproc.v1.BasicAutoscalingAlgorithm.Builder.class);
  }

  private int configCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object config_;

  public enum ConfigCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    YARN_CONFIG(1),
    CONFIG_NOT_SET(0);
    private final int value;

    private ConfigCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ConfigCase valueOf(int value) {
      return forNumber(value);
    }

    public static ConfigCase forNumber(int value) {
      switch (value) {
        case 1:
          return YARN_CONFIG;
        case 0:
          return CONFIG_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public ConfigCase getConfigCase() {
    return ConfigCase.forNumber(configCase_);
  }

  public static final int YARN_CONFIG_FIELD_NUMBER = 1;
  /**
   *
   *
   * <pre>
   * Required. YARN autoscaling configuration.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.BasicYarnAutoscalingConfig yarn_config = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the yarnConfig field is set.
   */
  @java.lang.Override
  public boolean hasYarnConfig() {
    return configCase_ == 1;
  }
  /**
   *
   *
   * <pre>
   * Required. YARN autoscaling configuration.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.BasicYarnAutoscalingConfig yarn_config = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The yarnConfig.
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.BasicYarnAutoscalingConfig getYarnConfig() {
    if (configCase_ == 1) {
      return (com.google.cloud.dataproc.v1.BasicYarnAutoscalingConfig) config_;
    }
    return com.google.cloud.dataproc.v1.BasicYarnAutoscalingConfig.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Required. YARN autoscaling configuration.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.BasicYarnAutoscalingConfig yarn_config = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.BasicYarnAutoscalingConfigOrBuilder getYarnConfigOrBuilder() {
    if (configCase_ == 1) {
      return (com.google.cloud.dataproc.v1.BasicYarnAutoscalingConfig) config_;
    }
    return com.google.cloud.dataproc.v1.BasicYarnAutoscalingConfig.getDefaultInstance();
  }

  public static final int COOLDOWN_PERIOD_FIELD_NUMBER = 2;
  private com.google.protobuf.Duration cooldownPeriod_;
  /**
   *
   *
   * <pre>
   * Optional. Duration between scaling events. A scaling period starts after
   * the update operation from the previous event has completed.
   *
   * Bounds: [2m, 1d]. Default: 2m.
   * </pre>
   *
   * <code>.google.protobuf.Duration cooldown_period = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the cooldownPeriod field is set.
   */
  @java.lang.Override
  public boolean hasCooldownPeriod() {
    return cooldownPeriod_ != null;
  }
  /**
   *
   *
   * <pre>
   * Optional. Duration between scaling events. A scaling period starts after
   * the update operation from the previous event has completed.
   *
   * Bounds: [2m, 1d]. Default: 2m.
   * </pre>
   *
   * <code>.google.protobuf.Duration cooldown_period = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The cooldownPeriod.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getCooldownPeriod() {
    return cooldownPeriod_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : cooldownPeriod_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Duration between scaling events. A scaling period starts after
   * the update operation from the previous event has completed.
   *
   * Bounds: [2m, 1d]. Default: 2m.
   * </pre>
   *
   * <code>.google.protobuf.Duration cooldown_period = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getCooldownPeriodOrBuilder() {
    return cooldownPeriod_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : cooldownPeriod_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (configCase_ == 1) {
      output.writeMessage(1, (com.google.cloud.dataproc.v1.BasicYarnAutoscalingConfig) config_);
    }
    if (cooldownPeriod_ != null) {
      output.writeMessage(2, getCooldownPeriod());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (configCase_ == 1) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              1, (com.google.cloud.dataproc.v1.BasicYarnAutoscalingConfig) config_);
    }
    if (cooldownPeriod_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getCooldownPeriod());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dataproc.v1.BasicAutoscalingAlgorithm)) {
      return super.equals(obj);
    }
    com.google.cloud.dataproc.v1.BasicAutoscalingAlgorithm other =
        (com.google.cloud.dataproc.v1.BasicAutoscalingAlgorithm) obj;

    if (hasCooldownPeriod() != other.hasCooldownPeriod()) return false;
    if (hasCooldownPeriod()) {
      if (!getCooldownPeriod().equals(other.getCooldownPeriod())) return false;
    }
    if (!getConfigCase().equals(other.getConfigCase())) return false;
    switch (configCase_) {
      case 1:
        if (!getYarnConfig().equals(other.getYarnConfig())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasCooldownPeriod()) {
      hash = (37 * hash) + COOLDOWN_PERIOD_FIELD_NUMBER;
      hash = (53 * hash) + getCooldownPeriod().hashCode();
    }
    switch (configCase_) {
      case 1:
        hash = (37 * hash) + YARN_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getYarnConfig().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dataproc.v1.BasicAutoscalingAlgorithm parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1.BasicAutoscalingAlgorithm parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.BasicAutoscalingAlgorithm parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1.BasicAutoscalingAlgorithm parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.BasicAutoscalingAlgorithm parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1.BasicAutoscalingAlgorithm parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.BasicAutoscalingAlgorithm parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1.BasicAutoscalingAlgorithm parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.BasicAutoscalingAlgorithm parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1.BasicAutoscalingAlgorithm parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.BasicAutoscalingAlgorithm parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1.BasicAutoscalingAlgorithm parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.dataproc.v1.BasicAutoscalingAlgorithm prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Basic algorithm for autoscaling.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dataproc.v1.BasicAutoscalingAlgorithm}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dataproc.v1.BasicAutoscalingAlgorithm)
      com.google.cloud.dataproc.v1.BasicAutoscalingAlgorithmOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dataproc.v1.AutoscalingPoliciesProto
          .internal_static_google_cloud_dataproc_v1_BasicAutoscalingAlgorithm_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dataproc.v1.AutoscalingPoliciesProto
          .internal_static_google_cloud_dataproc_v1_BasicAutoscalingAlgorithm_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dataproc.v1.BasicAutoscalingAlgorithm.class,
              com.google.cloud.dataproc.v1.BasicAutoscalingAlgorithm.Builder.class);
    }

    // Construct using com.google.cloud.dataproc.v1.BasicAutoscalingAlgorithm.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (yarnConfigBuilder_ != null) {
        yarnConfigBuilder_.clear();
      }
      cooldownPeriod_ = null;
      if (cooldownPeriodBuilder_ != null) {
        cooldownPeriodBuilder_.dispose();
        cooldownPeriodBuilder_ = null;
      }
      configCase_ = 0;
      config_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dataproc.v1.AutoscalingPoliciesProto
          .internal_static_google_cloud_dataproc_v1_BasicAutoscalingAlgorithm_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.BasicAutoscalingAlgorithm getDefaultInstanceForType() {
      return com.google.cloud.dataproc.v1.BasicAutoscalingAlgorithm.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.BasicAutoscalingAlgorithm build() {
      com.google.cloud.dataproc.v1.BasicAutoscalingAlgorithm result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.BasicAutoscalingAlgorithm buildPartial() {
      com.google.cloud.dataproc.v1.BasicAutoscalingAlgorithm result =
          new com.google.cloud.dataproc.v1.BasicAutoscalingAlgorithm(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.dataproc.v1.BasicAutoscalingAlgorithm result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.cooldownPeriod_ =
            cooldownPeriodBuilder_ == null ? cooldownPeriod_ : cooldownPeriodBuilder_.build();
      }
    }

    private void buildPartialOneofs(com.google.cloud.dataproc.v1.BasicAutoscalingAlgorithm result) {
      result.configCase_ = configCase_;
      result.config_ = this.config_;
      if (configCase_ == 1 && yarnConfigBuilder_ != null) {
        result.config_ = yarnConfigBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dataproc.v1.BasicAutoscalingAlgorithm) {
        return mergeFrom((com.google.cloud.dataproc.v1.BasicAutoscalingAlgorithm) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dataproc.v1.BasicAutoscalingAlgorithm other) {
      if (other == com.google.cloud.dataproc.v1.BasicAutoscalingAlgorithm.getDefaultInstance())
        return this;
      if (other.hasCooldownPeriod()) {
        mergeCooldownPeriod(other.getCooldownPeriod());
      }
      switch (other.getConfigCase()) {
        case YARN_CONFIG:
          {
            mergeYarnConfig(other.getYarnConfig());
            break;
          }
        case CONFIG_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getYarnConfigFieldBuilder().getBuilder(), extensionRegistry);
                configCase_ = 1;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getCooldownPeriodFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int configCase_ = 0;
    private java.lang.Object config_;

    public ConfigCase getConfigCase() {
      return ConfigCase.forNumber(configCase_);
    }

    public Builder clearConfig() {
      configCase_ = 0;
      config_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.BasicYarnAutoscalingConfig,
            com.google.cloud.dataproc.v1.BasicYarnAutoscalingConfig.Builder,
            com.google.cloud.dataproc.v1.BasicYarnAutoscalingConfigOrBuilder>
        yarnConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Required. YARN autoscaling configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.BasicYarnAutoscalingConfig yarn_config = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the yarnConfig field is set.
     */
    @java.lang.Override
    public boolean hasYarnConfig() {
      return configCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * Required. YARN autoscaling configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.BasicYarnAutoscalingConfig yarn_config = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The yarnConfig.
     */
    @java.lang.Override
    public com.google.cloud.dataproc.v1.BasicYarnAutoscalingConfig getYarnConfig() {
      if (yarnConfigBuilder_ == null) {
        if (configCase_ == 1) {
          return (com.google.cloud.dataproc.v1.BasicYarnAutoscalingConfig) config_;
        }
        return com.google.cloud.dataproc.v1.BasicYarnAutoscalingConfig.getDefaultInstance();
      } else {
        if (configCase_ == 1) {
          return yarnConfigBuilder_.getMessage();
        }
        return com.google.cloud.dataproc.v1.BasicYarnAutoscalingConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. YARN autoscaling configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.BasicYarnAutoscalingConfig yarn_config = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setYarnConfig(com.google.cloud.dataproc.v1.BasicYarnAutoscalingConfig value) {
      if (yarnConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        config_ = value;
        onChanged();
      } else {
        yarnConfigBuilder_.setMessage(value);
      }
      configCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. YARN autoscaling configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.BasicYarnAutoscalingConfig yarn_config = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setYarnConfig(
        com.google.cloud.dataproc.v1.BasicYarnAutoscalingConfig.Builder builderForValue) {
      if (yarnConfigBuilder_ == null) {
        config_ = builderForValue.build();
        onChanged();
      } else {
        yarnConfigBuilder_.setMessage(builderForValue.build());
      }
      configCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. YARN autoscaling configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.BasicYarnAutoscalingConfig yarn_config = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeYarnConfig(com.google.cloud.dataproc.v1.BasicYarnAutoscalingConfig value) {
      if (yarnConfigBuilder_ == null) {
        if (configCase_ == 1
            && config_
                != com.google.cloud.dataproc.v1.BasicYarnAutoscalingConfig.getDefaultInstance()) {
          config_ =
              com.google.cloud.dataproc.v1.BasicYarnAutoscalingConfig.newBuilder(
                      (com.google.cloud.dataproc.v1.BasicYarnAutoscalingConfig) config_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          config_ = value;
        }
        onChanged();
      } else {
        if (configCase_ == 1) {
          yarnConfigBuilder_.mergeFrom(value);
        } else {
          yarnConfigBuilder_.setMessage(value);
        }
      }
      configCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. YARN autoscaling configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.BasicYarnAutoscalingConfig yarn_config = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearYarnConfig() {
      if (yarnConfigBuilder_ == null) {
        if (configCase_ == 1) {
          configCase_ = 0;
          config_ = null;
          onChanged();
        }
      } else {
        if (configCase_ == 1) {
          configCase_ = 0;
          config_ = null;
        }
        yarnConfigBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. YARN autoscaling configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.BasicYarnAutoscalingConfig yarn_config = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.dataproc.v1.BasicYarnAutoscalingConfig.Builder getYarnConfigBuilder() {
      return getYarnConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. YARN autoscaling configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.BasicYarnAutoscalingConfig yarn_config = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dataproc.v1.BasicYarnAutoscalingConfigOrBuilder
        getYarnConfigOrBuilder() {
      if ((configCase_ == 1) && (yarnConfigBuilder_ != null)) {
        return yarnConfigBuilder_.getMessageOrBuilder();
      } else {
        if (configCase_ == 1) {
          return (com.google.cloud.dataproc.v1.BasicYarnAutoscalingConfig) config_;
        }
        return com.google.cloud.dataproc.v1.BasicYarnAutoscalingConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. YARN autoscaling configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.BasicYarnAutoscalingConfig yarn_config = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.BasicYarnAutoscalingConfig,
            com.google.cloud.dataproc.v1.BasicYarnAutoscalingConfig.Builder,
            com.google.cloud.dataproc.v1.BasicYarnAutoscalingConfigOrBuilder>
        getYarnConfigFieldBuilder() {
      if (yarnConfigBuilder_ == null) {
        if (!(configCase_ == 1)) {
          config_ = com.google.cloud.dataproc.v1.BasicYarnAutoscalingConfig.getDefaultInstance();
        }
        yarnConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataproc.v1.BasicYarnAutoscalingConfig,
                com.google.cloud.dataproc.v1.BasicYarnAutoscalingConfig.Builder,
                com.google.cloud.dataproc.v1.BasicYarnAutoscalingConfigOrBuilder>(
                (com.google.cloud.dataproc.v1.BasicYarnAutoscalingConfig) config_,
                getParentForChildren(),
                isClean());
        config_ = null;
      }
      configCase_ = 1;
      onChanged();
      return yarnConfigBuilder_;
    }

    private com.google.protobuf.Duration cooldownPeriod_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        cooldownPeriodBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Duration between scaling events. A scaling period starts after
     * the update operation from the previous event has completed.
     *
     * Bounds: [2m, 1d]. Default: 2m.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration cooldown_period = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the cooldownPeriod field is set.
     */
    public boolean hasCooldownPeriod() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Duration between scaling events. A scaling period starts after
     * the update operation from the previous event has completed.
     *
     * Bounds: [2m, 1d]. Default: 2m.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration cooldown_period = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The cooldownPeriod.
     */
    public com.google.protobuf.Duration getCooldownPeriod() {
      if (cooldownPeriodBuilder_ == null) {
        return cooldownPeriod_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : cooldownPeriod_;
      } else {
        return cooldownPeriodBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Duration between scaling events. A scaling period starts after
     * the update operation from the previous event has completed.
     *
     * Bounds: [2m, 1d]. Default: 2m.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration cooldown_period = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setCooldownPeriod(com.google.protobuf.Duration value) {
      if (cooldownPeriodBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        cooldownPeriod_ = value;
      } else {
        cooldownPeriodBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Duration between scaling events. A scaling period starts after
     * the update operation from the previous event has completed.
     *
     * Bounds: [2m, 1d]. Default: 2m.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration cooldown_period = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setCooldownPeriod(com.google.protobuf.Duration.Builder builderForValue) {
      if (cooldownPeriodBuilder_ == null) {
        cooldownPeriod_ = builderForValue.build();
      } else {
        cooldownPeriodBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Duration between scaling events. A scaling period starts after
     * the update operation from the previous event has completed.
     *
     * Bounds: [2m, 1d]. Default: 2m.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration cooldown_period = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeCooldownPeriod(com.google.protobuf.Duration value) {
      if (cooldownPeriodBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && cooldownPeriod_ != null
            && cooldownPeriod_ != com.google.protobuf.Duration.getDefaultInstance()) {
          getCooldownPeriodBuilder().mergeFrom(value);
        } else {
          cooldownPeriod_ = value;
        }
      } else {
        cooldownPeriodBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Duration between scaling events. A scaling period starts after
     * the update operation from the previous event has completed.
     *
     * Bounds: [2m, 1d]. Default: 2m.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration cooldown_period = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearCooldownPeriod() {
      bitField0_ = (bitField0_ & ~0x00000002);
      cooldownPeriod_ = null;
      if (cooldownPeriodBuilder_ != null) {
        cooldownPeriodBuilder_.dispose();
        cooldownPeriodBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Duration between scaling events. A scaling period starts after
     * the update operation from the previous event has completed.
     *
     * Bounds: [2m, 1d]. Default: 2m.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration cooldown_period = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.Duration.Builder getCooldownPeriodBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getCooldownPeriodFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Duration between scaling events. A scaling period starts after
     * the update operation from the previous event has completed.
     *
     * Bounds: [2m, 1d]. Default: 2m.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration cooldown_period = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.DurationOrBuilder getCooldownPeriodOrBuilder() {
      if (cooldownPeriodBuilder_ != null) {
        return cooldownPeriodBuilder_.getMessageOrBuilder();
      } else {
        return cooldownPeriod_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : cooldownPeriod_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Duration between scaling events. A scaling period starts after
     * the update operation from the previous event has completed.
     *
     * Bounds: [2m, 1d]. Default: 2m.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration cooldown_period = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getCooldownPeriodFieldBuilder() {
      if (cooldownPeriodBuilder_ == null) {
        cooldownPeriodBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getCooldownPeriod(), getParentForChildren(), isClean());
        cooldownPeriod_ = null;
      }
      return cooldownPeriodBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dataproc.v1.BasicAutoscalingAlgorithm)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dataproc.v1.BasicAutoscalingAlgorithm)
  private static final com.google.cloud.dataproc.v1.BasicAutoscalingAlgorithm DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dataproc.v1.BasicAutoscalingAlgorithm();
  }

  public static com.google.cloud.dataproc.v1.BasicAutoscalingAlgorithm getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<BasicAutoscalingAlgorithm> PARSER =
      new com.google.protobuf.AbstractParser<BasicAutoscalingAlgorithm>() {
        @java.lang.Override
        public BasicAutoscalingAlgorithm parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<BasicAutoscalingAlgorithm> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<BasicAutoscalingAlgorithm> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dataproc.v1.BasicAutoscalingAlgorithm getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
