/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dataproc/v1/operations.proto

package com.google.cloud.dataproc.v1;

public interface BatchOperationMetadataOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.dataproc.v1.BatchOperationMetadata)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Name of the batch for the operation.
   * </pre>
   *
   * <code>string batch = 1;</code>
   *
   * @return The batch.
   */
  java.lang.String getBatch();
  /**
   *
   *
   * <pre>
   * Name of the batch for the operation.
   * </pre>
   *
   * <code>string batch = 1;</code>
   *
   * @return The bytes for batch.
   */
  com.google.protobuf.ByteString getBatchBytes();

  /**
   *
   *
   * <pre>
   * Batch UUID for the operation.
   * </pre>
   *
   * <code>string batch_uuid = 2;</code>
   *
   * @return The batchUuid.
   */
  java.lang.String getBatchUuid();
  /**
   *
   *
   * <pre>
   * Batch UUID for the operation.
   * </pre>
   *
   * <code>string batch_uuid = 2;</code>
   *
   * @return The bytes for batchUuid.
   */
  com.google.protobuf.ByteString getBatchUuidBytes();

  /**
   *
   *
   * <pre>
   * The time when the operation was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3;</code>
   *
   * @return Whether the createTime field is set.
   */
  boolean hasCreateTime();
  /**
   *
   *
   * <pre>
   * The time when the operation was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3;</code>
   *
   * @return The createTime.
   */
  com.google.protobuf.Timestamp getCreateTime();
  /**
   *
   *
   * <pre>
   * The time when the operation was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3;</code>
   */
  com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder();

  /**
   *
   *
   * <pre>
   * The time when the operation finished.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp done_time = 4;</code>
   *
   * @return Whether the doneTime field is set.
   */
  boolean hasDoneTime();
  /**
   *
   *
   * <pre>
   * The time when the operation finished.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp done_time = 4;</code>
   *
   * @return The doneTime.
   */
  com.google.protobuf.Timestamp getDoneTime();
  /**
   *
   *
   * <pre>
   * The time when the operation finished.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp done_time = 4;</code>
   */
  com.google.protobuf.TimestampOrBuilder getDoneTimeOrBuilder();

  /**
   *
   *
   * <pre>
   * The operation type.
   * </pre>
   *
   * <code>.google.cloud.dataproc.v1.BatchOperationMetadata.BatchOperationType operation_type = 6;
   * </code>
   *
   * @return The enum numeric value on the wire for operationType.
   */
  int getOperationTypeValue();
  /**
   *
   *
   * <pre>
   * The operation type.
   * </pre>
   *
   * <code>.google.cloud.dataproc.v1.BatchOperationMetadata.BatchOperationType operation_type = 6;
   * </code>
   *
   * @return The operationType.
   */
  com.google.cloud.dataproc.v1.BatchOperationMetadata.BatchOperationType getOperationType();

  /**
   *
   *
   * <pre>
   * Short description of the operation.
   * </pre>
   *
   * <code>string description = 7;</code>
   *
   * @return The description.
   */
  java.lang.String getDescription();
  /**
   *
   *
   * <pre>
   * Short description of the operation.
   * </pre>
   *
   * <code>string description = 7;</code>
   *
   * @return The bytes for description.
   */
  com.google.protobuf.ByteString getDescriptionBytes();

  /**
   *
   *
   * <pre>
   * Labels associated with the operation.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 8;</code>
   */
  int getLabelsCount();
  /**
   *
   *
   * <pre>
   * Labels associated with the operation.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 8;</code>
   */
  boolean containsLabels(java.lang.String key);
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Deprecated
  java.util.Map<java.lang.String, java.lang.String> getLabels();
  /**
   *
   *
   * <pre>
   * Labels associated with the operation.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 8;</code>
   */
  java.util.Map<java.lang.String, java.lang.String> getLabelsMap();
  /**
   *
   *
   * <pre>
   * Labels associated with the operation.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 8;</code>
   */
  /* nullable */
  java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue);
  /**
   *
   *
   * <pre>
   * Labels associated with the operation.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 8;</code>
   */
  java.lang.String getLabelsOrThrow(java.lang.String key);

  /**
   *
   *
   * <pre>
   * Warnings encountered during operation execution.
   * </pre>
   *
   * <code>repeated string warnings = 9;</code>
   *
   * @return A list containing the warnings.
   */
  java.util.List<java.lang.String> getWarningsList();
  /**
   *
   *
   * <pre>
   * Warnings encountered during operation execution.
   * </pre>
   *
   * <code>repeated string warnings = 9;</code>
   *
   * @return The count of warnings.
   */
  int getWarningsCount();
  /**
   *
   *
   * <pre>
   * Warnings encountered during operation execution.
   * </pre>
   *
   * <code>repeated string warnings = 9;</code>
   *
   * @param index The index of the element to return.
   * @return The warnings at the given index.
   */
  java.lang.String getWarnings(int index);
  /**
   *
   *
   * <pre>
   * Warnings encountered during operation execution.
   * </pre>
   *
   * <code>repeated string warnings = 9;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the warnings at the given index.
   */
  com.google.protobuf.ByteString getWarningsBytes(int index);
}
