/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dataproc/v1/clusters.proto

package com.google.cloud.dataproc.v1;

/**
 *
 *
 * <pre>
 * Describes the identifying information, config, and status of
 * a Dataproc cluster
 * </pre>
 *
 * Protobuf type {@code google.cloud.dataproc.v1.Cluster}
 */
public final class Cluster extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dataproc.v1.Cluster)
    ClusterOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Cluster.newBuilder() to construct.
  private Cluster(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Cluster() {
    projectId_ = "";
    clusterName_ = "";
    statusHistory_ = java.util.Collections.emptyList();
    clusterUuid_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Cluster();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dataproc.v1.ClustersProto
        .internal_static_google_cloud_dataproc_v1_Cluster_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 8:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dataproc.v1.ClustersProto
        .internal_static_google_cloud_dataproc_v1_Cluster_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dataproc.v1.Cluster.class,
            com.google.cloud.dataproc.v1.Cluster.Builder.class);
  }

  public static final int PROJECT_ID_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object projectId_ = "";
  /**
   *
   *
   * <pre>
   * Required. The Google Cloud Platform project ID that the cluster belongs to.
   * </pre>
   *
   * <code>string project_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The projectId.
   */
  @java.lang.Override
  public java.lang.String getProjectId() {
    java.lang.Object ref = projectId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      projectId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The Google Cloud Platform project ID that the cluster belongs to.
   * </pre>
   *
   * <code>string project_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for projectId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getProjectIdBytes() {
    java.lang.Object ref = projectId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      projectId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CLUSTER_NAME_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object clusterName_ = "";
  /**
   *
   *
   * <pre>
   * Required. The cluster name, which must be unique within a project.
   * The name must start with a lowercase letter, and can contain
   * up to 51 lowercase letters, numbers, and hyphens. It cannot end
   * with a hyphen. The name of a deleted cluster can be reused.
   * </pre>
   *
   * <code>string cluster_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The clusterName.
   */
  @java.lang.Override
  public java.lang.String getClusterName() {
    java.lang.Object ref = clusterName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      clusterName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The cluster name, which must be unique within a project.
   * The name must start with a lowercase letter, and can contain
   * up to 51 lowercase letters, numbers, and hyphens. It cannot end
   * with a hyphen. The name of a deleted cluster can be reused.
   * </pre>
   *
   * <code>string cluster_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for clusterName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getClusterNameBytes() {
    java.lang.Object ref = clusterName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      clusterName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CONFIG_FIELD_NUMBER = 3;
  private com.google.cloud.dataproc.v1.ClusterConfig config_;
  /**
   *
   *
   * <pre>
   * Optional. The cluster config for a cluster of Compute Engine Instances.
   * Note that Dataproc may set default values, and values may change
   * when clusters are updated.
   *
   * Exactly one of ClusterConfig or VirtualClusterConfig must be specified.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.ClusterConfig config = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the config field is set.
   */
  @java.lang.Override
  public boolean hasConfig() {
    return config_ != null;
  }
  /**
   *
   *
   * <pre>
   * Optional. The cluster config for a cluster of Compute Engine Instances.
   * Note that Dataproc may set default values, and values may change
   * when clusters are updated.
   *
   * Exactly one of ClusterConfig or VirtualClusterConfig must be specified.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.ClusterConfig config = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The config.
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.ClusterConfig getConfig() {
    return config_ == null
        ? com.google.cloud.dataproc.v1.ClusterConfig.getDefaultInstance()
        : config_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The cluster config for a cluster of Compute Engine Instances.
   * Note that Dataproc may set default values, and values may change
   * when clusters are updated.
   *
   * Exactly one of ClusterConfig or VirtualClusterConfig must be specified.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.ClusterConfig config = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.ClusterConfigOrBuilder getConfigOrBuilder() {
    return config_ == null
        ? com.google.cloud.dataproc.v1.ClusterConfig.getDefaultInstance()
        : config_;
  }

  public static final int VIRTUAL_CLUSTER_CONFIG_FIELD_NUMBER = 10;
  private com.google.cloud.dataproc.v1.VirtualClusterConfig virtualClusterConfig_;
  /**
   *
   *
   * <pre>
   * Optional. The virtual cluster config is used when creating a Dataproc
   * cluster that does not directly control the underlying compute resources,
   * for example, when creating a [Dataproc-on-GKE
   * cluster](https://cloud.google.com/dataproc/docs/guides/dpgke/dataproc-gke-overview).
   * Dataproc may set default values, and values may change when
   * clusters are updated. Exactly one of
   * [config][google.cloud.dataproc.v1.Cluster.config] or
   * [virtual_cluster_config][google.cloud.dataproc.v1.Cluster.virtual_cluster_config]
   * must be specified.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.VirtualClusterConfig virtual_cluster_config = 10 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the virtualClusterConfig field is set.
   */
  @java.lang.Override
  public boolean hasVirtualClusterConfig() {
    return virtualClusterConfig_ != null;
  }
  /**
   *
   *
   * <pre>
   * Optional. The virtual cluster config is used when creating a Dataproc
   * cluster that does not directly control the underlying compute resources,
   * for example, when creating a [Dataproc-on-GKE
   * cluster](https://cloud.google.com/dataproc/docs/guides/dpgke/dataproc-gke-overview).
   * Dataproc may set default values, and values may change when
   * clusters are updated. Exactly one of
   * [config][google.cloud.dataproc.v1.Cluster.config] or
   * [virtual_cluster_config][google.cloud.dataproc.v1.Cluster.virtual_cluster_config]
   * must be specified.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.VirtualClusterConfig virtual_cluster_config = 10 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The virtualClusterConfig.
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.VirtualClusterConfig getVirtualClusterConfig() {
    return virtualClusterConfig_ == null
        ? com.google.cloud.dataproc.v1.VirtualClusterConfig.getDefaultInstance()
        : virtualClusterConfig_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The virtual cluster config is used when creating a Dataproc
   * cluster that does not directly control the underlying compute resources,
   * for example, when creating a [Dataproc-on-GKE
   * cluster](https://cloud.google.com/dataproc/docs/guides/dpgke/dataproc-gke-overview).
   * Dataproc may set default values, and values may change when
   * clusters are updated. Exactly one of
   * [config][google.cloud.dataproc.v1.Cluster.config] or
   * [virtual_cluster_config][google.cloud.dataproc.v1.Cluster.virtual_cluster_config]
   * must be specified.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.VirtualClusterConfig virtual_cluster_config = 10 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.VirtualClusterConfigOrBuilder
      getVirtualClusterConfigOrBuilder() {
    return virtualClusterConfig_ == null
        ? com.google.cloud.dataproc.v1.VirtualClusterConfig.getDefaultInstance()
        : virtualClusterConfig_;
  }

  public static final int LABELS_FIELD_NUMBER = 8;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.dataproc.v1.ClustersProto
                .internal_static_google_cloud_dataproc_v1_Cluster_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Optional. The labels to associate with this cluster.
   * Label **keys** must contain 1 to 63 characters, and must conform to
   * [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
   * Label **values** may be empty, but, if present, must contain 1 to 63
   * characters, and must conform to [RFC
   * 1035](https://www.ietf.org/rfc/rfc1035.txt). No more than 32 labels can be
   * associated with a cluster.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. The labels to associate with this cluster.
   * Label **keys** must contain 1 to 63 characters, and must conform to
   * [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
   * Label **values** may be empty, but, if present, must contain 1 to 63
   * characters, and must conform to [RFC
   * 1035](https://www.ietf.org/rfc/rfc1035.txt). No more than 32 labels can be
   * associated with a cluster.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. The labels to associate with this cluster.
   * Label **keys** must contain 1 to 63 characters, and must conform to
   * [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
   * Label **values** may be empty, but, if present, must contain 1 to 63
   * characters, and must conform to [RFC
   * 1035](https://www.ietf.org/rfc/rfc1035.txt). No more than 32 labels can be
   * associated with a cluster.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Optional. The labels to associate with this cluster.
   * Label **keys** must contain 1 to 63 characters, and must conform to
   * [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
   * Label **values** may be empty, but, if present, must contain 1 to 63
   * characters, and must conform to [RFC
   * 1035](https://www.ietf.org/rfc/rfc1035.txt). No more than 32 labels can be
   * associated with a cluster.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int STATUS_FIELD_NUMBER = 4;
  private com.google.cloud.dataproc.v1.ClusterStatus status_;
  /**
   *
   *
   * <pre>
   * Output only. Cluster status.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.ClusterStatus status = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the status field is set.
   */
  @java.lang.Override
  public boolean hasStatus() {
    return status_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Cluster status.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.ClusterStatus status = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The status.
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.ClusterStatus getStatus() {
    return status_ == null
        ? com.google.cloud.dataproc.v1.ClusterStatus.getDefaultInstance()
        : status_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Cluster status.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.ClusterStatus status = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.ClusterStatusOrBuilder getStatusOrBuilder() {
    return status_ == null
        ? com.google.cloud.dataproc.v1.ClusterStatus.getDefaultInstance()
        : status_;
  }

  public static final int STATUS_HISTORY_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.dataproc.v1.ClusterStatus> statusHistory_;
  /**
   *
   *
   * <pre>
   * Output only. The previous cluster status.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dataproc.v1.ClusterStatus status_history = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.dataproc.v1.ClusterStatus> getStatusHistoryList() {
    return statusHistory_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The previous cluster status.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dataproc.v1.ClusterStatus status_history = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.dataproc.v1.ClusterStatusOrBuilder>
      getStatusHistoryOrBuilderList() {
    return statusHistory_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The previous cluster status.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dataproc.v1.ClusterStatus status_history = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public int getStatusHistoryCount() {
    return statusHistory_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. The previous cluster status.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dataproc.v1.ClusterStatus status_history = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.ClusterStatus getStatusHistory(int index) {
    return statusHistory_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. The previous cluster status.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dataproc.v1.ClusterStatus status_history = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.ClusterStatusOrBuilder getStatusHistoryOrBuilder(int index) {
    return statusHistory_.get(index);
  }

  public static final int CLUSTER_UUID_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object clusterUuid_ = "";
  /**
   *
   *
   * <pre>
   * Output only. A cluster UUID (Unique Universal Identifier). Dataproc
   * generates this value when it creates the cluster.
   * </pre>
   *
   * <code>string cluster_uuid = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The clusterUuid.
   */
  @java.lang.Override
  public java.lang.String getClusterUuid() {
    java.lang.Object ref = clusterUuid_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      clusterUuid_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. A cluster UUID (Unique Universal Identifier). Dataproc
   * generates this value when it creates the cluster.
   * </pre>
   *
   * <code>string cluster_uuid = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for clusterUuid.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getClusterUuidBytes() {
    java.lang.Object ref = clusterUuid_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      clusterUuid_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int METRICS_FIELD_NUMBER = 9;
  private com.google.cloud.dataproc.v1.ClusterMetrics metrics_;
  /**
   *
   *
   * <pre>
   * Output only. Contains cluster daemon metrics such as HDFS and YARN stats.
   *
   * **Beta Feature**: This report is available for testing purposes only. It
   * may be changed before final release.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.ClusterMetrics metrics = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the metrics field is set.
   */
  @java.lang.Override
  public boolean hasMetrics() {
    return metrics_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Contains cluster daemon metrics such as HDFS and YARN stats.
   *
   * **Beta Feature**: This report is available for testing purposes only. It
   * may be changed before final release.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.ClusterMetrics metrics = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The metrics.
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.ClusterMetrics getMetrics() {
    return metrics_ == null
        ? com.google.cloud.dataproc.v1.ClusterMetrics.getDefaultInstance()
        : metrics_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Contains cluster daemon metrics such as HDFS and YARN stats.
   *
   * **Beta Feature**: This report is available for testing purposes only. It
   * may be changed before final release.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.ClusterMetrics metrics = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.ClusterMetricsOrBuilder getMetricsOrBuilder() {
    return metrics_ == null
        ? com.google.cloud.dataproc.v1.ClusterMetrics.getDefaultInstance()
        : metrics_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(projectId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, projectId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(clusterName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, clusterName_);
    }
    if (config_ != null) {
      output.writeMessage(3, getConfig());
    }
    if (status_ != null) {
      output.writeMessage(4, getStatus());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(clusterUuid_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, clusterUuid_);
    }
    for (int i = 0; i < statusHistory_.size(); i++) {
      output.writeMessage(7, statusHistory_.get(i));
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 8);
    if (metrics_ != null) {
      output.writeMessage(9, getMetrics());
    }
    if (virtualClusterConfig_ != null) {
      output.writeMessage(10, getVirtualClusterConfig());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(projectId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, projectId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(clusterName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, clusterName_);
    }
    if (config_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getConfig());
    }
    if (status_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getStatus());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(clusterUuid_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, clusterUuid_);
    }
    for (int i = 0; i < statusHistory_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, statusHistory_.get(i));
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, labels__);
    }
    if (metrics_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getMetrics());
    }
    if (virtualClusterConfig_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(10, getVirtualClusterConfig());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dataproc.v1.Cluster)) {
      return super.equals(obj);
    }
    com.google.cloud.dataproc.v1.Cluster other = (com.google.cloud.dataproc.v1.Cluster) obj;

    if (!getProjectId().equals(other.getProjectId())) return false;
    if (!getClusterName().equals(other.getClusterName())) return false;
    if (hasConfig() != other.hasConfig()) return false;
    if (hasConfig()) {
      if (!getConfig().equals(other.getConfig())) return false;
    }
    if (hasVirtualClusterConfig() != other.hasVirtualClusterConfig()) return false;
    if (hasVirtualClusterConfig()) {
      if (!getVirtualClusterConfig().equals(other.getVirtualClusterConfig())) return false;
    }
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (hasStatus() != other.hasStatus()) return false;
    if (hasStatus()) {
      if (!getStatus().equals(other.getStatus())) return false;
    }
    if (!getStatusHistoryList().equals(other.getStatusHistoryList())) return false;
    if (!getClusterUuid().equals(other.getClusterUuid())) return false;
    if (hasMetrics() != other.hasMetrics()) return false;
    if (hasMetrics()) {
      if (!getMetrics().equals(other.getMetrics())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PROJECT_ID_FIELD_NUMBER;
    hash = (53 * hash) + getProjectId().hashCode();
    hash = (37 * hash) + CLUSTER_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getClusterName().hashCode();
    if (hasConfig()) {
      hash = (37 * hash) + CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getConfig().hashCode();
    }
    if (hasVirtualClusterConfig()) {
      hash = (37 * hash) + VIRTUAL_CLUSTER_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getVirtualClusterConfig().hashCode();
    }
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    if (hasStatus()) {
      hash = (37 * hash) + STATUS_FIELD_NUMBER;
      hash = (53 * hash) + getStatus().hashCode();
    }
    if (getStatusHistoryCount() > 0) {
      hash = (37 * hash) + STATUS_HISTORY_FIELD_NUMBER;
      hash = (53 * hash) + getStatusHistoryList().hashCode();
    }
    hash = (37 * hash) + CLUSTER_UUID_FIELD_NUMBER;
    hash = (53 * hash) + getClusterUuid().hashCode();
    if (hasMetrics()) {
      hash = (37 * hash) + METRICS_FIELD_NUMBER;
      hash = (53 * hash) + getMetrics().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dataproc.v1.Cluster parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1.Cluster parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.Cluster parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1.Cluster parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.Cluster parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1.Cluster parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.Cluster parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1.Cluster parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.Cluster parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1.Cluster parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.Cluster parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1.Cluster parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.dataproc.v1.Cluster prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Describes the identifying information, config, and status of
   * a Dataproc cluster
   * </pre>
   *
   * Protobuf type {@code google.cloud.dataproc.v1.Cluster}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dataproc.v1.Cluster)
      com.google.cloud.dataproc.v1.ClusterOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dataproc.v1.ClustersProto
          .internal_static_google_cloud_dataproc_v1_Cluster_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 8:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 8:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dataproc.v1.ClustersProto
          .internal_static_google_cloud_dataproc_v1_Cluster_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dataproc.v1.Cluster.class,
              com.google.cloud.dataproc.v1.Cluster.Builder.class);
    }

    // Construct using com.google.cloud.dataproc.v1.Cluster.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      projectId_ = "";
      clusterName_ = "";
      config_ = null;
      if (configBuilder_ != null) {
        configBuilder_.dispose();
        configBuilder_ = null;
      }
      virtualClusterConfig_ = null;
      if (virtualClusterConfigBuilder_ != null) {
        virtualClusterConfigBuilder_.dispose();
        virtualClusterConfigBuilder_ = null;
      }
      internalGetMutableLabels().clear();
      status_ = null;
      if (statusBuilder_ != null) {
        statusBuilder_.dispose();
        statusBuilder_ = null;
      }
      if (statusHistoryBuilder_ == null) {
        statusHistory_ = java.util.Collections.emptyList();
      } else {
        statusHistory_ = null;
        statusHistoryBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000040);
      clusterUuid_ = "";
      metrics_ = null;
      if (metricsBuilder_ != null) {
        metricsBuilder_.dispose();
        metricsBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dataproc.v1.ClustersProto
          .internal_static_google_cloud_dataproc_v1_Cluster_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.Cluster getDefaultInstanceForType() {
      return com.google.cloud.dataproc.v1.Cluster.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.Cluster build() {
      com.google.cloud.dataproc.v1.Cluster result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.Cluster buildPartial() {
      com.google.cloud.dataproc.v1.Cluster result = new com.google.cloud.dataproc.v1.Cluster(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.dataproc.v1.Cluster result) {
      if (statusHistoryBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)) {
          statusHistory_ = java.util.Collections.unmodifiableList(statusHistory_);
          bitField0_ = (bitField0_ & ~0x00000040);
        }
        result.statusHistory_ = statusHistory_;
      } else {
        result.statusHistory_ = statusHistoryBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.dataproc.v1.Cluster result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.projectId_ = projectId_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.clusterName_ = clusterName_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.config_ = configBuilder_ == null ? config_ : configBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.virtualClusterConfig_ =
            virtualClusterConfigBuilder_ == null
                ? virtualClusterConfig_
                : virtualClusterConfigBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.labels_ = internalGetLabels();
        result.labels_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.status_ = statusBuilder_ == null ? status_ : statusBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.clusterUuid_ = clusterUuid_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.metrics_ = metricsBuilder_ == null ? metrics_ : metricsBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dataproc.v1.Cluster) {
        return mergeFrom((com.google.cloud.dataproc.v1.Cluster) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dataproc.v1.Cluster other) {
      if (other == com.google.cloud.dataproc.v1.Cluster.getDefaultInstance()) return this;
      if (!other.getProjectId().isEmpty()) {
        projectId_ = other.projectId_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getClusterName().isEmpty()) {
        clusterName_ = other.clusterName_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasConfig()) {
        mergeConfig(other.getConfig());
      }
      if (other.hasVirtualClusterConfig()) {
        mergeVirtualClusterConfig(other.getVirtualClusterConfig());
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      bitField0_ |= 0x00000010;
      if (other.hasStatus()) {
        mergeStatus(other.getStatus());
      }
      if (statusHistoryBuilder_ == null) {
        if (!other.statusHistory_.isEmpty()) {
          if (statusHistory_.isEmpty()) {
            statusHistory_ = other.statusHistory_;
            bitField0_ = (bitField0_ & ~0x00000040);
          } else {
            ensureStatusHistoryIsMutable();
            statusHistory_.addAll(other.statusHistory_);
          }
          onChanged();
        }
      } else {
        if (!other.statusHistory_.isEmpty()) {
          if (statusHistoryBuilder_.isEmpty()) {
            statusHistoryBuilder_.dispose();
            statusHistoryBuilder_ = null;
            statusHistory_ = other.statusHistory_;
            bitField0_ = (bitField0_ & ~0x00000040);
            statusHistoryBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getStatusHistoryFieldBuilder()
                    : null;
          } else {
            statusHistoryBuilder_.addAllMessages(other.statusHistory_);
          }
        }
      }
      if (!other.getClusterUuid().isEmpty()) {
        clusterUuid_ = other.clusterUuid_;
        bitField0_ |= 0x00000080;
        onChanged();
      }
      if (other.hasMetrics()) {
        mergeMetrics(other.getMetrics());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                projectId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                clusterName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getStatusFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 34
            case 50:
              {
                clusterUuid_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000080;
                break;
              } // case 50
            case 58:
              {
                com.google.cloud.dataproc.v1.ClusterStatus m =
                    input.readMessage(
                        com.google.cloud.dataproc.v1.ClusterStatus.parser(), extensionRegistry);
                if (statusHistoryBuilder_ == null) {
                  ensureStatusHistoryIsMutable();
                  statusHistory_.add(m);
                } else {
                  statusHistoryBuilder_.addMessage(m);
                }
                break;
              } // case 58
            case 66:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                bitField0_ |= 0x00000010;
                break;
              } // case 66
            case 74:
              {
                input.readMessage(getMetricsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case 74
            case 82:
              {
                input.readMessage(
                    getVirtualClusterConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 82
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object projectId_ = "";
    /**
     *
     *
     * <pre>
     * Required. The Google Cloud Platform project ID that the cluster belongs to.
     * </pre>
     *
     * <code>string project_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The projectId.
     */
    public java.lang.String getProjectId() {
      java.lang.Object ref = projectId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        projectId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The Google Cloud Platform project ID that the cluster belongs to.
     * </pre>
     *
     * <code>string project_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for projectId.
     */
    public com.google.protobuf.ByteString getProjectIdBytes() {
      java.lang.Object ref = projectId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        projectId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The Google Cloud Platform project ID that the cluster belongs to.
     * </pre>
     *
     * <code>string project_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The projectId to set.
     * @return This builder for chaining.
     */
    public Builder setProjectId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      projectId_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The Google Cloud Platform project ID that the cluster belongs to.
     * </pre>
     *
     * <code>string project_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearProjectId() {
      projectId_ = getDefaultInstance().getProjectId();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The Google Cloud Platform project ID that the cluster belongs to.
     * </pre>
     *
     * <code>string project_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for projectId to set.
     * @return This builder for chaining.
     */
    public Builder setProjectIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      projectId_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object clusterName_ = "";
    /**
     *
     *
     * <pre>
     * Required. The cluster name, which must be unique within a project.
     * The name must start with a lowercase letter, and can contain
     * up to 51 lowercase letters, numbers, and hyphens. It cannot end
     * with a hyphen. The name of a deleted cluster can be reused.
     * </pre>
     *
     * <code>string cluster_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The clusterName.
     */
    public java.lang.String getClusterName() {
      java.lang.Object ref = clusterName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        clusterName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The cluster name, which must be unique within a project.
     * The name must start with a lowercase letter, and can contain
     * up to 51 lowercase letters, numbers, and hyphens. It cannot end
     * with a hyphen. The name of a deleted cluster can be reused.
     * </pre>
     *
     * <code>string cluster_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for clusterName.
     */
    public com.google.protobuf.ByteString getClusterNameBytes() {
      java.lang.Object ref = clusterName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        clusterName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The cluster name, which must be unique within a project.
     * The name must start with a lowercase letter, and can contain
     * up to 51 lowercase letters, numbers, and hyphens. It cannot end
     * with a hyphen. The name of a deleted cluster can be reused.
     * </pre>
     *
     * <code>string cluster_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The clusterName to set.
     * @return This builder for chaining.
     */
    public Builder setClusterName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      clusterName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The cluster name, which must be unique within a project.
     * The name must start with a lowercase letter, and can contain
     * up to 51 lowercase letters, numbers, and hyphens. It cannot end
     * with a hyphen. The name of a deleted cluster can be reused.
     * </pre>
     *
     * <code>string cluster_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearClusterName() {
      clusterName_ = getDefaultInstance().getClusterName();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The cluster name, which must be unique within a project.
     * The name must start with a lowercase letter, and can contain
     * up to 51 lowercase letters, numbers, and hyphens. It cannot end
     * with a hyphen. The name of a deleted cluster can be reused.
     * </pre>
     *
     * <code>string cluster_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for clusterName to set.
     * @return This builder for chaining.
     */
    public Builder setClusterNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      clusterName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.cloud.dataproc.v1.ClusterConfig config_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.ClusterConfig,
            com.google.cloud.dataproc.v1.ClusterConfig.Builder,
            com.google.cloud.dataproc.v1.ClusterConfigOrBuilder>
        configBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. The cluster config for a cluster of Compute Engine Instances.
     * Note that Dataproc may set default values, and values may change
     * when clusters are updated.
     *
     * Exactly one of ClusterConfig or VirtualClusterConfig must be specified.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.ClusterConfig config = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the config field is set.
     */
    public boolean hasConfig() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. The cluster config for a cluster of Compute Engine Instances.
     * Note that Dataproc may set default values, and values may change
     * when clusters are updated.
     *
     * Exactly one of ClusterConfig or VirtualClusterConfig must be specified.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.ClusterConfig config = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The config.
     */
    public com.google.cloud.dataproc.v1.ClusterConfig getConfig() {
      if (configBuilder_ == null) {
        return config_ == null
            ? com.google.cloud.dataproc.v1.ClusterConfig.getDefaultInstance()
            : config_;
      } else {
        return configBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The cluster config for a cluster of Compute Engine Instances.
     * Note that Dataproc may set default values, and values may change
     * when clusters are updated.
     *
     * Exactly one of ClusterConfig or VirtualClusterConfig must be specified.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.ClusterConfig config = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setConfig(com.google.cloud.dataproc.v1.ClusterConfig value) {
      if (configBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        config_ = value;
      } else {
        configBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The cluster config for a cluster of Compute Engine Instances.
     * Note that Dataproc may set default values, and values may change
     * when clusters are updated.
     *
     * Exactly one of ClusterConfig or VirtualClusterConfig must be specified.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.ClusterConfig config = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setConfig(com.google.cloud.dataproc.v1.ClusterConfig.Builder builderForValue) {
      if (configBuilder_ == null) {
        config_ = builderForValue.build();
      } else {
        configBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The cluster config for a cluster of Compute Engine Instances.
     * Note that Dataproc may set default values, and values may change
     * when clusters are updated.
     *
     * Exactly one of ClusterConfig or VirtualClusterConfig must be specified.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.ClusterConfig config = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeConfig(com.google.cloud.dataproc.v1.ClusterConfig value) {
      if (configBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && config_ != null
            && config_ != com.google.cloud.dataproc.v1.ClusterConfig.getDefaultInstance()) {
          getConfigBuilder().mergeFrom(value);
        } else {
          config_ = value;
        }
      } else {
        configBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The cluster config for a cluster of Compute Engine Instances.
     * Note that Dataproc may set default values, and values may change
     * when clusters are updated.
     *
     * Exactly one of ClusterConfig or VirtualClusterConfig must be specified.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.ClusterConfig config = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearConfig() {
      bitField0_ = (bitField0_ & ~0x00000004);
      config_ = null;
      if (configBuilder_ != null) {
        configBuilder_.dispose();
        configBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The cluster config for a cluster of Compute Engine Instances.
     * Note that Dataproc may set default values, and values may change
     * when clusters are updated.
     *
     * Exactly one of ClusterConfig or VirtualClusterConfig must be specified.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.ClusterConfig config = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataproc.v1.ClusterConfig.Builder getConfigBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. The cluster config for a cluster of Compute Engine Instances.
     * Note that Dataproc may set default values, and values may change
     * when clusters are updated.
     *
     * Exactly one of ClusterConfig or VirtualClusterConfig must be specified.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.ClusterConfig config = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataproc.v1.ClusterConfigOrBuilder getConfigOrBuilder() {
      if (configBuilder_ != null) {
        return configBuilder_.getMessageOrBuilder();
      } else {
        return config_ == null
            ? com.google.cloud.dataproc.v1.ClusterConfig.getDefaultInstance()
            : config_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The cluster config for a cluster of Compute Engine Instances.
     * Note that Dataproc may set default values, and values may change
     * when clusters are updated.
     *
     * Exactly one of ClusterConfig or VirtualClusterConfig must be specified.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.ClusterConfig config = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.ClusterConfig,
            com.google.cloud.dataproc.v1.ClusterConfig.Builder,
            com.google.cloud.dataproc.v1.ClusterConfigOrBuilder>
        getConfigFieldBuilder() {
      if (configBuilder_ == null) {
        configBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataproc.v1.ClusterConfig,
                com.google.cloud.dataproc.v1.ClusterConfig.Builder,
                com.google.cloud.dataproc.v1.ClusterConfigOrBuilder>(
                getConfig(), getParentForChildren(), isClean());
        config_ = null;
      }
      return configBuilder_;
    }

    private com.google.cloud.dataproc.v1.VirtualClusterConfig virtualClusterConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.VirtualClusterConfig,
            com.google.cloud.dataproc.v1.VirtualClusterConfig.Builder,
            com.google.cloud.dataproc.v1.VirtualClusterConfigOrBuilder>
        virtualClusterConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. The virtual cluster config is used when creating a Dataproc
     * cluster that does not directly control the underlying compute resources,
     * for example, when creating a [Dataproc-on-GKE
     * cluster](https://cloud.google.com/dataproc/docs/guides/dpgke/dataproc-gke-overview).
     * Dataproc may set default values, and values may change when
     * clusters are updated. Exactly one of
     * [config][google.cloud.dataproc.v1.Cluster.config] or
     * [virtual_cluster_config][google.cloud.dataproc.v1.Cluster.virtual_cluster_config]
     * must be specified.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.VirtualClusterConfig virtual_cluster_config = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the virtualClusterConfig field is set.
     */
    public boolean hasVirtualClusterConfig() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. The virtual cluster config is used when creating a Dataproc
     * cluster that does not directly control the underlying compute resources,
     * for example, when creating a [Dataproc-on-GKE
     * cluster](https://cloud.google.com/dataproc/docs/guides/dpgke/dataproc-gke-overview).
     * Dataproc may set default values, and values may change when
     * clusters are updated. Exactly one of
     * [config][google.cloud.dataproc.v1.Cluster.config] or
     * [virtual_cluster_config][google.cloud.dataproc.v1.Cluster.virtual_cluster_config]
     * must be specified.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.VirtualClusterConfig virtual_cluster_config = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The virtualClusterConfig.
     */
    public com.google.cloud.dataproc.v1.VirtualClusterConfig getVirtualClusterConfig() {
      if (virtualClusterConfigBuilder_ == null) {
        return virtualClusterConfig_ == null
            ? com.google.cloud.dataproc.v1.VirtualClusterConfig.getDefaultInstance()
            : virtualClusterConfig_;
      } else {
        return virtualClusterConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The virtual cluster config is used when creating a Dataproc
     * cluster that does not directly control the underlying compute resources,
     * for example, when creating a [Dataproc-on-GKE
     * cluster](https://cloud.google.com/dataproc/docs/guides/dpgke/dataproc-gke-overview).
     * Dataproc may set default values, and values may change when
     * clusters are updated. Exactly one of
     * [config][google.cloud.dataproc.v1.Cluster.config] or
     * [virtual_cluster_config][google.cloud.dataproc.v1.Cluster.virtual_cluster_config]
     * must be specified.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.VirtualClusterConfig virtual_cluster_config = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setVirtualClusterConfig(
        com.google.cloud.dataproc.v1.VirtualClusterConfig value) {
      if (virtualClusterConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        virtualClusterConfig_ = value;
      } else {
        virtualClusterConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The virtual cluster config is used when creating a Dataproc
     * cluster that does not directly control the underlying compute resources,
     * for example, when creating a [Dataproc-on-GKE
     * cluster](https://cloud.google.com/dataproc/docs/guides/dpgke/dataproc-gke-overview).
     * Dataproc may set default values, and values may change when
     * clusters are updated. Exactly one of
     * [config][google.cloud.dataproc.v1.Cluster.config] or
     * [virtual_cluster_config][google.cloud.dataproc.v1.Cluster.virtual_cluster_config]
     * must be specified.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.VirtualClusterConfig virtual_cluster_config = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setVirtualClusterConfig(
        com.google.cloud.dataproc.v1.VirtualClusterConfig.Builder builderForValue) {
      if (virtualClusterConfigBuilder_ == null) {
        virtualClusterConfig_ = builderForValue.build();
      } else {
        virtualClusterConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The virtual cluster config is used when creating a Dataproc
     * cluster that does not directly control the underlying compute resources,
     * for example, when creating a [Dataproc-on-GKE
     * cluster](https://cloud.google.com/dataproc/docs/guides/dpgke/dataproc-gke-overview).
     * Dataproc may set default values, and values may change when
     * clusters are updated. Exactly one of
     * [config][google.cloud.dataproc.v1.Cluster.config] or
     * [virtual_cluster_config][google.cloud.dataproc.v1.Cluster.virtual_cluster_config]
     * must be specified.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.VirtualClusterConfig virtual_cluster_config = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeVirtualClusterConfig(
        com.google.cloud.dataproc.v1.VirtualClusterConfig value) {
      if (virtualClusterConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && virtualClusterConfig_ != null
            && virtualClusterConfig_
                != com.google.cloud.dataproc.v1.VirtualClusterConfig.getDefaultInstance()) {
          getVirtualClusterConfigBuilder().mergeFrom(value);
        } else {
          virtualClusterConfig_ = value;
        }
      } else {
        virtualClusterConfigBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The virtual cluster config is used when creating a Dataproc
     * cluster that does not directly control the underlying compute resources,
     * for example, when creating a [Dataproc-on-GKE
     * cluster](https://cloud.google.com/dataproc/docs/guides/dpgke/dataproc-gke-overview).
     * Dataproc may set default values, and values may change when
     * clusters are updated. Exactly one of
     * [config][google.cloud.dataproc.v1.Cluster.config] or
     * [virtual_cluster_config][google.cloud.dataproc.v1.Cluster.virtual_cluster_config]
     * must be specified.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.VirtualClusterConfig virtual_cluster_config = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearVirtualClusterConfig() {
      bitField0_ = (bitField0_ & ~0x00000008);
      virtualClusterConfig_ = null;
      if (virtualClusterConfigBuilder_ != null) {
        virtualClusterConfigBuilder_.dispose();
        virtualClusterConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The virtual cluster config is used when creating a Dataproc
     * cluster that does not directly control the underlying compute resources,
     * for example, when creating a [Dataproc-on-GKE
     * cluster](https://cloud.google.com/dataproc/docs/guides/dpgke/dataproc-gke-overview).
     * Dataproc may set default values, and values may change when
     * clusters are updated. Exactly one of
     * [config][google.cloud.dataproc.v1.Cluster.config] or
     * [virtual_cluster_config][google.cloud.dataproc.v1.Cluster.virtual_cluster_config]
     * must be specified.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.VirtualClusterConfig virtual_cluster_config = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataproc.v1.VirtualClusterConfig.Builder
        getVirtualClusterConfigBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getVirtualClusterConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. The virtual cluster config is used when creating a Dataproc
     * cluster that does not directly control the underlying compute resources,
     * for example, when creating a [Dataproc-on-GKE
     * cluster](https://cloud.google.com/dataproc/docs/guides/dpgke/dataproc-gke-overview).
     * Dataproc may set default values, and values may change when
     * clusters are updated. Exactly one of
     * [config][google.cloud.dataproc.v1.Cluster.config] or
     * [virtual_cluster_config][google.cloud.dataproc.v1.Cluster.virtual_cluster_config]
     * must be specified.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.VirtualClusterConfig virtual_cluster_config = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataproc.v1.VirtualClusterConfigOrBuilder
        getVirtualClusterConfigOrBuilder() {
      if (virtualClusterConfigBuilder_ != null) {
        return virtualClusterConfigBuilder_.getMessageOrBuilder();
      } else {
        return virtualClusterConfig_ == null
            ? com.google.cloud.dataproc.v1.VirtualClusterConfig.getDefaultInstance()
            : virtualClusterConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The virtual cluster config is used when creating a Dataproc
     * cluster that does not directly control the underlying compute resources,
     * for example, when creating a [Dataproc-on-GKE
     * cluster](https://cloud.google.com/dataproc/docs/guides/dpgke/dataproc-gke-overview).
     * Dataproc may set default values, and values may change when
     * clusters are updated. Exactly one of
     * [config][google.cloud.dataproc.v1.Cluster.config] or
     * [virtual_cluster_config][google.cloud.dataproc.v1.Cluster.virtual_cluster_config]
     * must be specified.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.VirtualClusterConfig virtual_cluster_config = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.VirtualClusterConfig,
            com.google.cloud.dataproc.v1.VirtualClusterConfig.Builder,
            com.google.cloud.dataproc.v1.VirtualClusterConfigOrBuilder>
        getVirtualClusterConfigFieldBuilder() {
      if (virtualClusterConfigBuilder_ == null) {
        virtualClusterConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataproc.v1.VirtualClusterConfig,
                com.google.cloud.dataproc.v1.VirtualClusterConfig.Builder,
                com.google.cloud.dataproc.v1.VirtualClusterConfigOrBuilder>(
                getVirtualClusterConfig(), getParentForChildren(), isClean());
        virtualClusterConfig_ = null;
      }
      return virtualClusterConfigBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Optional. The labels to associate with this cluster.
     * Label **keys** must contain 1 to 63 characters, and must conform to
     * [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
     * Label **values** may be empty, but, if present, must contain 1 to 63
     * characters, and must conform to [RFC
     * 1035](https://www.ietf.org/rfc/rfc1035.txt). No more than 32 labels can be
     * associated with a cluster.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. The labels to associate with this cluster.
     * Label **keys** must contain 1 to 63 characters, and must conform to
     * [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
     * Label **values** may be empty, but, if present, must contain 1 to 63
     * characters, and must conform to [RFC
     * 1035](https://www.ietf.org/rfc/rfc1035.txt). No more than 32 labels can be
     * associated with a cluster.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. The labels to associate with this cluster.
     * Label **keys** must contain 1 to 63 characters, and must conform to
     * [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
     * Label **values** may be empty, but, if present, must contain 1 to 63
     * characters, and must conform to [RFC
     * 1035](https://www.ietf.org/rfc/rfc1035.txt). No more than 32 labels can be
     * associated with a cluster.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Optional. The labels to associate with this cluster.
     * Label **keys** must contain 1 to 63 characters, and must conform to
     * [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
     * Label **values** may be empty, but, if present, must contain 1 to 63
     * characters, and must conform to [RFC
     * 1035](https://www.ietf.org/rfc/rfc1035.txt). No more than 32 labels can be
     * associated with a cluster.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      bitField0_ = (bitField0_ & ~0x00000010);
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The labels to associate with this cluster.
     * Label **keys** must contain 1 to 63 characters, and must conform to
     * [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
     * Label **values** may be empty, but, if present, must contain 1 to 63
     * characters, and must conform to [RFC
     * 1035](https://www.ietf.org/rfc/rfc1035.txt). No more than 32 labels can be
     * associated with a cluster.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      bitField0_ |= 0x00000010;
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. The labels to associate with this cluster.
     * Label **keys** must contain 1 to 63 characters, and must conform to
     * [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
     * Label **values** may be empty, but, if present, must contain 1 to 63
     * characters, and must conform to [RFC
     * 1035](https://www.ietf.org/rfc/rfc1035.txt). No more than 32 labels can be
     * associated with a cluster.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00000010;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The labels to associate with this cluster.
     * Label **keys** must contain 1 to 63 characters, and must conform to
     * [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
     * Label **values** may be empty, but, if present, must contain 1 to 63
     * characters, and must conform to [RFC
     * 1035](https://www.ietf.org/rfc/rfc1035.txt). No more than 32 labels can be
     * associated with a cluster.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00000010;
      return this;
    }

    private com.google.cloud.dataproc.v1.ClusterStatus status_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.ClusterStatus,
            com.google.cloud.dataproc.v1.ClusterStatus.Builder,
            com.google.cloud.dataproc.v1.ClusterStatusOrBuilder>
        statusBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Cluster status.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.ClusterStatus status = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the status field is set.
     */
    public boolean hasStatus() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Cluster status.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.ClusterStatus status = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The status.
     */
    public com.google.cloud.dataproc.v1.ClusterStatus getStatus() {
      if (statusBuilder_ == null) {
        return status_ == null
            ? com.google.cloud.dataproc.v1.ClusterStatus.getDefaultInstance()
            : status_;
      } else {
        return statusBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Cluster status.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.ClusterStatus status = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setStatus(com.google.cloud.dataproc.v1.ClusterStatus value) {
      if (statusBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        status_ = value;
      } else {
        statusBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Cluster status.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.ClusterStatus status = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setStatus(com.google.cloud.dataproc.v1.ClusterStatus.Builder builderForValue) {
      if (statusBuilder_ == null) {
        status_ = builderForValue.build();
      } else {
        statusBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Cluster status.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.ClusterStatus status = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeStatus(com.google.cloud.dataproc.v1.ClusterStatus value) {
      if (statusBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && status_ != null
            && status_ != com.google.cloud.dataproc.v1.ClusterStatus.getDefaultInstance()) {
          getStatusBuilder().mergeFrom(value);
        } else {
          status_ = value;
        }
      } else {
        statusBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Cluster status.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.ClusterStatus status = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearStatus() {
      bitField0_ = (bitField0_ & ~0x00000020);
      status_ = null;
      if (statusBuilder_ != null) {
        statusBuilder_.dispose();
        statusBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Cluster status.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.ClusterStatus status = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.dataproc.v1.ClusterStatus.Builder getStatusBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getStatusFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Cluster status.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.ClusterStatus status = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.dataproc.v1.ClusterStatusOrBuilder getStatusOrBuilder() {
      if (statusBuilder_ != null) {
        return statusBuilder_.getMessageOrBuilder();
      } else {
        return status_ == null
            ? com.google.cloud.dataproc.v1.ClusterStatus.getDefaultInstance()
            : status_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Cluster status.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.ClusterStatus status = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.ClusterStatus,
            com.google.cloud.dataproc.v1.ClusterStatus.Builder,
            com.google.cloud.dataproc.v1.ClusterStatusOrBuilder>
        getStatusFieldBuilder() {
      if (statusBuilder_ == null) {
        statusBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataproc.v1.ClusterStatus,
                com.google.cloud.dataproc.v1.ClusterStatus.Builder,
                com.google.cloud.dataproc.v1.ClusterStatusOrBuilder>(
                getStatus(), getParentForChildren(), isClean());
        status_ = null;
      }
      return statusBuilder_;
    }

    private java.util.List<com.google.cloud.dataproc.v1.ClusterStatus> statusHistory_ =
        java.util.Collections.emptyList();

    private void ensureStatusHistoryIsMutable() {
      if (!((bitField0_ & 0x00000040) != 0)) {
        statusHistory_ =
            new java.util.ArrayList<com.google.cloud.dataproc.v1.ClusterStatus>(statusHistory_);
        bitField0_ |= 0x00000040;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dataproc.v1.ClusterStatus,
            com.google.cloud.dataproc.v1.ClusterStatus.Builder,
            com.google.cloud.dataproc.v1.ClusterStatusOrBuilder>
        statusHistoryBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. The previous cluster status.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.ClusterStatus status_history = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.dataproc.v1.ClusterStatus> getStatusHistoryList() {
      if (statusHistoryBuilder_ == null) {
        return java.util.Collections.unmodifiableList(statusHistory_);
      } else {
        return statusHistoryBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The previous cluster status.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.ClusterStatus status_history = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public int getStatusHistoryCount() {
      if (statusHistoryBuilder_ == null) {
        return statusHistory_.size();
      } else {
        return statusHistoryBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The previous cluster status.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.ClusterStatus status_history = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.dataproc.v1.ClusterStatus getStatusHistory(int index) {
      if (statusHistoryBuilder_ == null) {
        return statusHistory_.get(index);
      } else {
        return statusHistoryBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The previous cluster status.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.ClusterStatus status_history = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setStatusHistory(int index, com.google.cloud.dataproc.v1.ClusterStatus value) {
      if (statusHistoryBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureStatusHistoryIsMutable();
        statusHistory_.set(index, value);
        onChanged();
      } else {
        statusHistoryBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The previous cluster status.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.ClusterStatus status_history = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setStatusHistory(
        int index, com.google.cloud.dataproc.v1.ClusterStatus.Builder builderForValue) {
      if (statusHistoryBuilder_ == null) {
        ensureStatusHistoryIsMutable();
        statusHistory_.set(index, builderForValue.build());
        onChanged();
      } else {
        statusHistoryBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The previous cluster status.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.ClusterStatus status_history = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addStatusHistory(com.google.cloud.dataproc.v1.ClusterStatus value) {
      if (statusHistoryBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureStatusHistoryIsMutable();
        statusHistory_.add(value);
        onChanged();
      } else {
        statusHistoryBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The previous cluster status.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.ClusterStatus status_history = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addStatusHistory(int index, com.google.cloud.dataproc.v1.ClusterStatus value) {
      if (statusHistoryBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureStatusHistoryIsMutable();
        statusHistory_.add(index, value);
        onChanged();
      } else {
        statusHistoryBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The previous cluster status.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.ClusterStatus status_history = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addStatusHistory(
        com.google.cloud.dataproc.v1.ClusterStatus.Builder builderForValue) {
      if (statusHistoryBuilder_ == null) {
        ensureStatusHistoryIsMutable();
        statusHistory_.add(builderForValue.build());
        onChanged();
      } else {
        statusHistoryBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The previous cluster status.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.ClusterStatus status_history = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addStatusHistory(
        int index, com.google.cloud.dataproc.v1.ClusterStatus.Builder builderForValue) {
      if (statusHistoryBuilder_ == null) {
        ensureStatusHistoryIsMutable();
        statusHistory_.add(index, builderForValue.build());
        onChanged();
      } else {
        statusHistoryBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The previous cluster status.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.ClusterStatus status_history = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAllStatusHistory(
        java.lang.Iterable<? extends com.google.cloud.dataproc.v1.ClusterStatus> values) {
      if (statusHistoryBuilder_ == null) {
        ensureStatusHistoryIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, statusHistory_);
        onChanged();
      } else {
        statusHistoryBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The previous cluster status.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.ClusterStatus status_history = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearStatusHistory() {
      if (statusHistoryBuilder_ == null) {
        statusHistory_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000040);
        onChanged();
      } else {
        statusHistoryBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The previous cluster status.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.ClusterStatus status_history = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removeStatusHistory(int index) {
      if (statusHistoryBuilder_ == null) {
        ensureStatusHistoryIsMutable();
        statusHistory_.remove(index);
        onChanged();
      } else {
        statusHistoryBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The previous cluster status.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.ClusterStatus status_history = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.dataproc.v1.ClusterStatus.Builder getStatusHistoryBuilder(int index) {
      return getStatusHistoryFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. The previous cluster status.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.ClusterStatus status_history = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.dataproc.v1.ClusterStatusOrBuilder getStatusHistoryOrBuilder(
        int index) {
      if (statusHistoryBuilder_ == null) {
        return statusHistory_.get(index);
      } else {
        return statusHistoryBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The previous cluster status.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.ClusterStatus status_history = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.dataproc.v1.ClusterStatusOrBuilder>
        getStatusHistoryOrBuilderList() {
      if (statusHistoryBuilder_ != null) {
        return statusHistoryBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(statusHistory_);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The previous cluster status.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.ClusterStatus status_history = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.dataproc.v1.ClusterStatus.Builder addStatusHistoryBuilder() {
      return getStatusHistoryFieldBuilder()
          .addBuilder(com.google.cloud.dataproc.v1.ClusterStatus.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. The previous cluster status.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.ClusterStatus status_history = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.dataproc.v1.ClusterStatus.Builder addStatusHistoryBuilder(int index) {
      return getStatusHistoryFieldBuilder()
          .addBuilder(index, com.google.cloud.dataproc.v1.ClusterStatus.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. The previous cluster status.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.ClusterStatus status_history = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.dataproc.v1.ClusterStatus.Builder>
        getStatusHistoryBuilderList() {
      return getStatusHistoryFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dataproc.v1.ClusterStatus,
            com.google.cloud.dataproc.v1.ClusterStatus.Builder,
            com.google.cloud.dataproc.v1.ClusterStatusOrBuilder>
        getStatusHistoryFieldBuilder() {
      if (statusHistoryBuilder_ == null) {
        statusHistoryBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.dataproc.v1.ClusterStatus,
                com.google.cloud.dataproc.v1.ClusterStatus.Builder,
                com.google.cloud.dataproc.v1.ClusterStatusOrBuilder>(
                statusHistory_,
                ((bitField0_ & 0x00000040) != 0),
                getParentForChildren(),
                isClean());
        statusHistory_ = null;
      }
      return statusHistoryBuilder_;
    }

    private java.lang.Object clusterUuid_ = "";
    /**
     *
     *
     * <pre>
     * Output only. A cluster UUID (Unique Universal Identifier). Dataproc
     * generates this value when it creates the cluster.
     * </pre>
     *
     * <code>string cluster_uuid = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The clusterUuid.
     */
    public java.lang.String getClusterUuid() {
      java.lang.Object ref = clusterUuid_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        clusterUuid_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A cluster UUID (Unique Universal Identifier). Dataproc
     * generates this value when it creates the cluster.
     * </pre>
     *
     * <code>string cluster_uuid = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for clusterUuid.
     */
    public com.google.protobuf.ByteString getClusterUuidBytes() {
      java.lang.Object ref = clusterUuid_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        clusterUuid_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A cluster UUID (Unique Universal Identifier). Dataproc
     * generates this value when it creates the cluster.
     * </pre>
     *
     * <code>string cluster_uuid = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The clusterUuid to set.
     * @return This builder for chaining.
     */
    public Builder setClusterUuid(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      clusterUuid_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A cluster UUID (Unique Universal Identifier). Dataproc
     * generates this value when it creates the cluster.
     * </pre>
     *
     * <code>string cluster_uuid = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearClusterUuid() {
      clusterUuid_ = getDefaultInstance().getClusterUuid();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A cluster UUID (Unique Universal Identifier). Dataproc
     * generates this value when it creates the cluster.
     * </pre>
     *
     * <code>string cluster_uuid = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for clusterUuid to set.
     * @return This builder for chaining.
     */
    public Builder setClusterUuidBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      clusterUuid_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    private com.google.cloud.dataproc.v1.ClusterMetrics metrics_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.ClusterMetrics,
            com.google.cloud.dataproc.v1.ClusterMetrics.Builder,
            com.google.cloud.dataproc.v1.ClusterMetricsOrBuilder>
        metricsBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Contains cluster daemon metrics such as HDFS and YARN stats.
     *
     * **Beta Feature**: This report is available for testing purposes only. It
     * may be changed before final release.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.ClusterMetrics metrics = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the metrics field is set.
     */
    public boolean hasMetrics() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Contains cluster daemon metrics such as HDFS and YARN stats.
     *
     * **Beta Feature**: This report is available for testing purposes only. It
     * may be changed before final release.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.ClusterMetrics metrics = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The metrics.
     */
    public com.google.cloud.dataproc.v1.ClusterMetrics getMetrics() {
      if (metricsBuilder_ == null) {
        return metrics_ == null
            ? com.google.cloud.dataproc.v1.ClusterMetrics.getDefaultInstance()
            : metrics_;
      } else {
        return metricsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Contains cluster daemon metrics such as HDFS and YARN stats.
     *
     * **Beta Feature**: This report is available for testing purposes only. It
     * may be changed before final release.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.ClusterMetrics metrics = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setMetrics(com.google.cloud.dataproc.v1.ClusterMetrics value) {
      if (metricsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        metrics_ = value;
      } else {
        metricsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Contains cluster daemon metrics such as HDFS and YARN stats.
     *
     * **Beta Feature**: This report is available for testing purposes only. It
     * may be changed before final release.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.ClusterMetrics metrics = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setMetrics(com.google.cloud.dataproc.v1.ClusterMetrics.Builder builderForValue) {
      if (metricsBuilder_ == null) {
        metrics_ = builderForValue.build();
      } else {
        metricsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Contains cluster daemon metrics such as HDFS and YARN stats.
     *
     * **Beta Feature**: This report is available for testing purposes only. It
     * may be changed before final release.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.ClusterMetrics metrics = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeMetrics(com.google.cloud.dataproc.v1.ClusterMetrics value) {
      if (metricsBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && metrics_ != null
            && metrics_ != com.google.cloud.dataproc.v1.ClusterMetrics.getDefaultInstance()) {
          getMetricsBuilder().mergeFrom(value);
        } else {
          metrics_ = value;
        }
      } else {
        metricsBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Contains cluster daemon metrics such as HDFS and YARN stats.
     *
     * **Beta Feature**: This report is available for testing purposes only. It
     * may be changed before final release.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.ClusterMetrics metrics = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearMetrics() {
      bitField0_ = (bitField0_ & ~0x00000100);
      metrics_ = null;
      if (metricsBuilder_ != null) {
        metricsBuilder_.dispose();
        metricsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Contains cluster daemon metrics such as HDFS and YARN stats.
     *
     * **Beta Feature**: This report is available for testing purposes only. It
     * may be changed before final release.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.ClusterMetrics metrics = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.dataproc.v1.ClusterMetrics.Builder getMetricsBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return getMetricsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Contains cluster daemon metrics such as HDFS and YARN stats.
     *
     * **Beta Feature**: This report is available for testing purposes only. It
     * may be changed before final release.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.ClusterMetrics metrics = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.dataproc.v1.ClusterMetricsOrBuilder getMetricsOrBuilder() {
      if (metricsBuilder_ != null) {
        return metricsBuilder_.getMessageOrBuilder();
      } else {
        return metrics_ == null
            ? com.google.cloud.dataproc.v1.ClusterMetrics.getDefaultInstance()
            : metrics_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Contains cluster daemon metrics such as HDFS and YARN stats.
     *
     * **Beta Feature**: This report is available for testing purposes only. It
     * may be changed before final release.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.ClusterMetrics metrics = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.ClusterMetrics,
            com.google.cloud.dataproc.v1.ClusterMetrics.Builder,
            com.google.cloud.dataproc.v1.ClusterMetricsOrBuilder>
        getMetricsFieldBuilder() {
      if (metricsBuilder_ == null) {
        metricsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataproc.v1.ClusterMetrics,
                com.google.cloud.dataproc.v1.ClusterMetrics.Builder,
                com.google.cloud.dataproc.v1.ClusterMetricsOrBuilder>(
                getMetrics(), getParentForChildren(), isClean());
        metrics_ = null;
      }
      return metricsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dataproc.v1.Cluster)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dataproc.v1.Cluster)
  private static final com.google.cloud.dataproc.v1.Cluster DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dataproc.v1.Cluster();
  }

  public static com.google.cloud.dataproc.v1.Cluster getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Cluster> PARSER =
      new com.google.protobuf.AbstractParser<Cluster>() {
        @java.lang.Override
        public Cluster parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Cluster> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Cluster> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dataproc.v1.Cluster getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
