/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dataproc/v1/operations.proto

package com.google.cloud.dataproc.v1;

/**
 *
 *
 * <pre>
 * Metadata describing the operation.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dataproc.v1.ClusterOperationMetadata}
 */
public final class ClusterOperationMetadata extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dataproc.v1.ClusterOperationMetadata)
    ClusterOperationMetadataOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ClusterOperationMetadata.newBuilder() to construct.
  private ClusterOperationMetadata(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ClusterOperationMetadata() {
    clusterName_ = "";
    clusterUuid_ = "";
    statusHistory_ = java.util.Collections.emptyList();
    operationType_ = "";
    description_ = "";
    warnings_ = com.google.protobuf.LazyStringArrayList.emptyList();
    childOperationIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ClusterOperationMetadata();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dataproc.v1.OperationsProto
        .internal_static_google_cloud_dataproc_v1_ClusterOperationMetadata_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 13:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dataproc.v1.OperationsProto
        .internal_static_google_cloud_dataproc_v1_ClusterOperationMetadata_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dataproc.v1.ClusterOperationMetadata.class,
            com.google.cloud.dataproc.v1.ClusterOperationMetadata.Builder.class);
  }

  public static final int CLUSTER_NAME_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private volatile java.lang.Object clusterName_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Name of the cluster for the operation.
   * </pre>
   *
   * <code>string cluster_name = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The clusterName.
   */
  @java.lang.Override
  public java.lang.String getClusterName() {
    java.lang.Object ref = clusterName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      clusterName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Name of the cluster for the operation.
   * </pre>
   *
   * <code>string cluster_name = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for clusterName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getClusterNameBytes() {
    java.lang.Object ref = clusterName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      clusterName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CLUSTER_UUID_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private volatile java.lang.Object clusterUuid_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Cluster UUID for the operation.
   * </pre>
   *
   * <code>string cluster_uuid = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The clusterUuid.
   */
  @java.lang.Override
  public java.lang.String getClusterUuid() {
    java.lang.Object ref = clusterUuid_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      clusterUuid_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Cluster UUID for the operation.
   * </pre>
   *
   * <code>string cluster_uuid = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for clusterUuid.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getClusterUuidBytes() {
    java.lang.Object ref = clusterUuid_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      clusterUuid_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STATUS_FIELD_NUMBER = 9;
  private com.google.cloud.dataproc.v1.ClusterOperationStatus status_;
  /**
   *
   *
   * <pre>
   * Output only. Current operation status.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.ClusterOperationStatus status = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the status field is set.
   */
  @java.lang.Override
  public boolean hasStatus() {
    return status_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Current operation status.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.ClusterOperationStatus status = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The status.
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.ClusterOperationStatus getStatus() {
    return status_ == null
        ? com.google.cloud.dataproc.v1.ClusterOperationStatus.getDefaultInstance()
        : status_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Current operation status.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.ClusterOperationStatus status = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.ClusterOperationStatusOrBuilder getStatusOrBuilder() {
    return status_ == null
        ? com.google.cloud.dataproc.v1.ClusterOperationStatus.getDefaultInstance()
        : status_;
  }

  public static final int STATUS_HISTORY_FIELD_NUMBER = 10;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.dataproc.v1.ClusterOperationStatus> statusHistory_;
  /**
   *
   *
   * <pre>
   * Output only. The previous operation status.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dataproc.v1.ClusterOperationStatus status_history = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.dataproc.v1.ClusterOperationStatus>
      getStatusHistoryList() {
    return statusHistory_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The previous operation status.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dataproc.v1.ClusterOperationStatus status_history = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.dataproc.v1.ClusterOperationStatusOrBuilder>
      getStatusHistoryOrBuilderList() {
    return statusHistory_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The previous operation status.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dataproc.v1.ClusterOperationStatus status_history = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public int getStatusHistoryCount() {
    return statusHistory_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. The previous operation status.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dataproc.v1.ClusterOperationStatus status_history = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.ClusterOperationStatus getStatusHistory(int index) {
    return statusHistory_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. The previous operation status.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dataproc.v1.ClusterOperationStatus status_history = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.ClusterOperationStatusOrBuilder getStatusHistoryOrBuilder(
      int index) {
    return statusHistory_.get(index);
  }

  public static final int OPERATION_TYPE_FIELD_NUMBER = 11;

  @SuppressWarnings("serial")
  private volatile java.lang.Object operationType_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The operation type.
   * </pre>
   *
   * <code>string operation_type = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The operationType.
   */
  @java.lang.Override
  public java.lang.String getOperationType() {
    java.lang.Object ref = operationType_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      operationType_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The operation type.
   * </pre>
   *
   * <code>string operation_type = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for operationType.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getOperationTypeBytes() {
    java.lang.Object ref = operationType_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      operationType_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 12;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Short description of operation.
   * </pre>
   *
   * <code>string description = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Short description of operation.
   * </pre>
   *
   * <code>string description = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LABELS_FIELD_NUMBER = 13;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.dataproc.v1.OperationsProto
                .internal_static_google_cloud_dataproc_v1_ClusterOperationMetadata_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Output only. Labels associated with the operation
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * Output only. Labels associated with the operation
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * Output only. Labels associated with the operation
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Output only. Labels associated with the operation
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int WARNINGS_FIELD_NUMBER = 14;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList warnings_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Output only. Errors encountered during operation execution.
   * </pre>
   *
   * <code>repeated string warnings = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return A list containing the warnings.
   */
  public com.google.protobuf.ProtocolStringList getWarningsList() {
    return warnings_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Errors encountered during operation execution.
   * </pre>
   *
   * <code>repeated string warnings = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The count of warnings.
   */
  public int getWarningsCount() {
    return warnings_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. Errors encountered during operation execution.
   * </pre>
   *
   * <code>repeated string warnings = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @param index The index of the element to return.
   * @return The warnings at the given index.
   */
  public java.lang.String getWarnings(int index) {
    return warnings_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. Errors encountered during operation execution.
   * </pre>
   *
   * <code>repeated string warnings = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the warnings at the given index.
   */
  public com.google.protobuf.ByteString getWarningsBytes(int index) {
    return warnings_.getByteString(index);
  }

  public static final int CHILD_OPERATION_IDS_FIELD_NUMBER = 15;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList childOperationIds_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Output only. Child operation ids
   * </pre>
   *
   * <code>repeated string child_operation_ids = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return A list containing the childOperationIds.
   */
  public com.google.protobuf.ProtocolStringList getChildOperationIdsList() {
    return childOperationIds_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Child operation ids
   * </pre>
   *
   * <code>repeated string child_operation_ids = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The count of childOperationIds.
   */
  public int getChildOperationIdsCount() {
    return childOperationIds_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. Child operation ids
   * </pre>
   *
   * <code>repeated string child_operation_ids = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @param index The index of the element to return.
   * @return The childOperationIds at the given index.
   */
  public java.lang.String getChildOperationIds(int index) {
    return childOperationIds_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. Child operation ids
   * </pre>
   *
   * <code>repeated string child_operation_ids = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the childOperationIds at the given index.
   */
  public com.google.protobuf.ByteString getChildOperationIdsBytes(int index) {
    return childOperationIds_.getByteString(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(clusterName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, clusterName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(clusterUuid_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, clusterUuid_);
    }
    if (status_ != null) {
      output.writeMessage(9, getStatus());
    }
    for (int i = 0; i < statusHistory_.size(); i++) {
      output.writeMessage(10, statusHistory_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(operationType_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 11, operationType_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 12, description_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 13);
    for (int i = 0; i < warnings_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 14, warnings_.getRaw(i));
    }
    for (int i = 0; i < childOperationIds_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 15, childOperationIds_.getRaw(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(clusterName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, clusterName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(clusterUuid_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, clusterUuid_);
    }
    if (status_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getStatus());
    }
    for (int i = 0; i < statusHistory_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, statusHistory_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(operationType_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(11, operationType_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(12, description_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(13, labels__);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < warnings_.size(); i++) {
        dataSize += computeStringSizeNoTag(warnings_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getWarningsList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < childOperationIds_.size(); i++) {
        dataSize += computeStringSizeNoTag(childOperationIds_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getChildOperationIdsList().size();
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dataproc.v1.ClusterOperationMetadata)) {
      return super.equals(obj);
    }
    com.google.cloud.dataproc.v1.ClusterOperationMetadata other =
        (com.google.cloud.dataproc.v1.ClusterOperationMetadata) obj;

    if (!getClusterName().equals(other.getClusterName())) return false;
    if (!getClusterUuid().equals(other.getClusterUuid())) return false;
    if (hasStatus() != other.hasStatus()) return false;
    if (hasStatus()) {
      if (!getStatus().equals(other.getStatus())) return false;
    }
    if (!getStatusHistoryList().equals(other.getStatusHistoryList())) return false;
    if (!getOperationType().equals(other.getOperationType())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (!getWarningsList().equals(other.getWarningsList())) return false;
    if (!getChildOperationIdsList().equals(other.getChildOperationIdsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + CLUSTER_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getClusterName().hashCode();
    hash = (37 * hash) + CLUSTER_UUID_FIELD_NUMBER;
    hash = (53 * hash) + getClusterUuid().hashCode();
    if (hasStatus()) {
      hash = (37 * hash) + STATUS_FIELD_NUMBER;
      hash = (53 * hash) + getStatus().hashCode();
    }
    if (getStatusHistoryCount() > 0) {
      hash = (37 * hash) + STATUS_HISTORY_FIELD_NUMBER;
      hash = (53 * hash) + getStatusHistoryList().hashCode();
    }
    hash = (37 * hash) + OPERATION_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + getOperationType().hashCode();
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    if (getWarningsCount() > 0) {
      hash = (37 * hash) + WARNINGS_FIELD_NUMBER;
      hash = (53 * hash) + getWarningsList().hashCode();
    }
    if (getChildOperationIdsCount() > 0) {
      hash = (37 * hash) + CHILD_OPERATION_IDS_FIELD_NUMBER;
      hash = (53 * hash) + getChildOperationIdsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dataproc.v1.ClusterOperationMetadata parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1.ClusterOperationMetadata parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.ClusterOperationMetadata parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1.ClusterOperationMetadata parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.ClusterOperationMetadata parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1.ClusterOperationMetadata parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.ClusterOperationMetadata parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1.ClusterOperationMetadata parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.ClusterOperationMetadata parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1.ClusterOperationMetadata parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.ClusterOperationMetadata parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1.ClusterOperationMetadata parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.dataproc.v1.ClusterOperationMetadata prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Metadata describing the operation.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dataproc.v1.ClusterOperationMetadata}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dataproc.v1.ClusterOperationMetadata)
      com.google.cloud.dataproc.v1.ClusterOperationMetadataOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dataproc.v1.OperationsProto
          .internal_static_google_cloud_dataproc_v1_ClusterOperationMetadata_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 13:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 13:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dataproc.v1.OperationsProto
          .internal_static_google_cloud_dataproc_v1_ClusterOperationMetadata_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dataproc.v1.ClusterOperationMetadata.class,
              com.google.cloud.dataproc.v1.ClusterOperationMetadata.Builder.class);
    }

    // Construct using com.google.cloud.dataproc.v1.ClusterOperationMetadata.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      clusterName_ = "";
      clusterUuid_ = "";
      status_ = null;
      if (statusBuilder_ != null) {
        statusBuilder_.dispose();
        statusBuilder_ = null;
      }
      if (statusHistoryBuilder_ == null) {
        statusHistory_ = java.util.Collections.emptyList();
      } else {
        statusHistory_ = null;
        statusHistoryBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000008);
      operationType_ = "";
      description_ = "";
      internalGetMutableLabels().clear();
      warnings_ = com.google.protobuf.LazyStringArrayList.emptyList();
      childOperationIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dataproc.v1.OperationsProto
          .internal_static_google_cloud_dataproc_v1_ClusterOperationMetadata_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.ClusterOperationMetadata getDefaultInstanceForType() {
      return com.google.cloud.dataproc.v1.ClusterOperationMetadata.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.ClusterOperationMetadata build() {
      com.google.cloud.dataproc.v1.ClusterOperationMetadata result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.ClusterOperationMetadata buildPartial() {
      com.google.cloud.dataproc.v1.ClusterOperationMetadata result =
          new com.google.cloud.dataproc.v1.ClusterOperationMetadata(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.dataproc.v1.ClusterOperationMetadata result) {
      if (statusHistoryBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)) {
          statusHistory_ = java.util.Collections.unmodifiableList(statusHistory_);
          bitField0_ = (bitField0_ & ~0x00000008);
        }
        result.statusHistory_ = statusHistory_;
      } else {
        result.statusHistory_ = statusHistoryBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.dataproc.v1.ClusterOperationMetadata result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.clusterName_ = clusterName_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.clusterUuid_ = clusterUuid_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.status_ = statusBuilder_ == null ? status_ : statusBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.operationType_ = operationType_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.description_ = description_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.labels_ = internalGetLabels();
        result.labels_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        warnings_.makeImmutable();
        result.warnings_ = warnings_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        childOperationIds_.makeImmutable();
        result.childOperationIds_ = childOperationIds_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dataproc.v1.ClusterOperationMetadata) {
        return mergeFrom((com.google.cloud.dataproc.v1.ClusterOperationMetadata) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dataproc.v1.ClusterOperationMetadata other) {
      if (other == com.google.cloud.dataproc.v1.ClusterOperationMetadata.getDefaultInstance())
        return this;
      if (!other.getClusterName().isEmpty()) {
        clusterName_ = other.clusterName_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getClusterUuid().isEmpty()) {
        clusterUuid_ = other.clusterUuid_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasStatus()) {
        mergeStatus(other.getStatus());
      }
      if (statusHistoryBuilder_ == null) {
        if (!other.statusHistory_.isEmpty()) {
          if (statusHistory_.isEmpty()) {
            statusHistory_ = other.statusHistory_;
            bitField0_ = (bitField0_ & ~0x00000008);
          } else {
            ensureStatusHistoryIsMutable();
            statusHistory_.addAll(other.statusHistory_);
          }
          onChanged();
        }
      } else {
        if (!other.statusHistory_.isEmpty()) {
          if (statusHistoryBuilder_.isEmpty()) {
            statusHistoryBuilder_.dispose();
            statusHistoryBuilder_ = null;
            statusHistory_ = other.statusHistory_;
            bitField0_ = (bitField0_ & ~0x00000008);
            statusHistoryBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getStatusHistoryFieldBuilder()
                    : null;
          } else {
            statusHistoryBuilder_.addAllMessages(other.statusHistory_);
          }
        }
      }
      if (!other.getOperationType().isEmpty()) {
        operationType_ = other.operationType_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      bitField0_ |= 0x00000040;
      if (!other.warnings_.isEmpty()) {
        if (warnings_.isEmpty()) {
          warnings_ = other.warnings_;
          bitField0_ |= 0x00000080;
        } else {
          ensureWarningsIsMutable();
          warnings_.addAll(other.warnings_);
        }
        onChanged();
      }
      if (!other.childOperationIds_.isEmpty()) {
        if (childOperationIds_.isEmpty()) {
          childOperationIds_ = other.childOperationIds_;
          bitField0_ |= 0x00000100;
        } else {
          ensureChildOperationIdsIsMutable();
          childOperationIds_.addAll(other.childOperationIds_);
        }
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 58:
              {
                clusterName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 58
            case 66:
              {
                clusterUuid_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 66
            case 74:
              {
                input.readMessage(getStatusFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 74
            case 82:
              {
                com.google.cloud.dataproc.v1.ClusterOperationStatus m =
                    input.readMessage(
                        com.google.cloud.dataproc.v1.ClusterOperationStatus.parser(),
                        extensionRegistry);
                if (statusHistoryBuilder_ == null) {
                  ensureStatusHistoryIsMutable();
                  statusHistory_.add(m);
                } else {
                  statusHistoryBuilder_.addMessage(m);
                }
                break;
              } // case 82
            case 90:
              {
                operationType_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 90
            case 98:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 98
            case 106:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                bitField0_ |= 0x00000040;
                break;
              } // case 106
            case 114:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureWarningsIsMutable();
                warnings_.add(s);
                break;
              } // case 114
            case 122:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureChildOperationIdsIsMutable();
                childOperationIds_.add(s);
                break;
              } // case 122
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object clusterName_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Name of the cluster for the operation.
     * </pre>
     *
     * <code>string cluster_name = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The clusterName.
     */
    public java.lang.String getClusterName() {
      java.lang.Object ref = clusterName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        clusterName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Name of the cluster for the operation.
     * </pre>
     *
     * <code>string cluster_name = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for clusterName.
     */
    public com.google.protobuf.ByteString getClusterNameBytes() {
      java.lang.Object ref = clusterName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        clusterName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Name of the cluster for the operation.
     * </pre>
     *
     * <code>string cluster_name = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The clusterName to set.
     * @return This builder for chaining.
     */
    public Builder setClusterName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      clusterName_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Name of the cluster for the operation.
     * </pre>
     *
     * <code>string cluster_name = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearClusterName() {
      clusterName_ = getDefaultInstance().getClusterName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Name of the cluster for the operation.
     * </pre>
     *
     * <code>string cluster_name = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for clusterName to set.
     * @return This builder for chaining.
     */
    public Builder setClusterNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      clusterName_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object clusterUuid_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Cluster UUID for the operation.
     * </pre>
     *
     * <code>string cluster_uuid = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The clusterUuid.
     */
    public java.lang.String getClusterUuid() {
      java.lang.Object ref = clusterUuid_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        clusterUuid_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Cluster UUID for the operation.
     * </pre>
     *
     * <code>string cluster_uuid = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for clusterUuid.
     */
    public com.google.protobuf.ByteString getClusterUuidBytes() {
      java.lang.Object ref = clusterUuid_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        clusterUuid_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Cluster UUID for the operation.
     * </pre>
     *
     * <code>string cluster_uuid = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The clusterUuid to set.
     * @return This builder for chaining.
     */
    public Builder setClusterUuid(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      clusterUuid_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Cluster UUID for the operation.
     * </pre>
     *
     * <code>string cluster_uuid = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearClusterUuid() {
      clusterUuid_ = getDefaultInstance().getClusterUuid();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Cluster UUID for the operation.
     * </pre>
     *
     * <code>string cluster_uuid = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for clusterUuid to set.
     * @return This builder for chaining.
     */
    public Builder setClusterUuidBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      clusterUuid_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.cloud.dataproc.v1.ClusterOperationStatus status_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.ClusterOperationStatus,
            com.google.cloud.dataproc.v1.ClusterOperationStatus.Builder,
            com.google.cloud.dataproc.v1.ClusterOperationStatusOrBuilder>
        statusBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Current operation status.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.ClusterOperationStatus status = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the status field is set.
     */
    public boolean hasStatus() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Current operation status.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.ClusterOperationStatus status = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The status.
     */
    public com.google.cloud.dataproc.v1.ClusterOperationStatus getStatus() {
      if (statusBuilder_ == null) {
        return status_ == null
            ? com.google.cloud.dataproc.v1.ClusterOperationStatus.getDefaultInstance()
            : status_;
      } else {
        return statusBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Current operation status.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.ClusterOperationStatus status = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setStatus(com.google.cloud.dataproc.v1.ClusterOperationStatus value) {
      if (statusBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        status_ = value;
      } else {
        statusBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Current operation status.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.ClusterOperationStatus status = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setStatus(
        com.google.cloud.dataproc.v1.ClusterOperationStatus.Builder builderForValue) {
      if (statusBuilder_ == null) {
        status_ = builderForValue.build();
      } else {
        statusBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Current operation status.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.ClusterOperationStatus status = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeStatus(com.google.cloud.dataproc.v1.ClusterOperationStatus value) {
      if (statusBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && status_ != null
            && status_
                != com.google.cloud.dataproc.v1.ClusterOperationStatus.getDefaultInstance()) {
          getStatusBuilder().mergeFrom(value);
        } else {
          status_ = value;
        }
      } else {
        statusBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Current operation status.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.ClusterOperationStatus status = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearStatus() {
      bitField0_ = (bitField0_ & ~0x00000004);
      status_ = null;
      if (statusBuilder_ != null) {
        statusBuilder_.dispose();
        statusBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Current operation status.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.ClusterOperationStatus status = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.dataproc.v1.ClusterOperationStatus.Builder getStatusBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getStatusFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Current operation status.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.ClusterOperationStatus status = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.dataproc.v1.ClusterOperationStatusOrBuilder getStatusOrBuilder() {
      if (statusBuilder_ != null) {
        return statusBuilder_.getMessageOrBuilder();
      } else {
        return status_ == null
            ? com.google.cloud.dataproc.v1.ClusterOperationStatus.getDefaultInstance()
            : status_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Current operation status.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.ClusterOperationStatus status = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.ClusterOperationStatus,
            com.google.cloud.dataproc.v1.ClusterOperationStatus.Builder,
            com.google.cloud.dataproc.v1.ClusterOperationStatusOrBuilder>
        getStatusFieldBuilder() {
      if (statusBuilder_ == null) {
        statusBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataproc.v1.ClusterOperationStatus,
                com.google.cloud.dataproc.v1.ClusterOperationStatus.Builder,
                com.google.cloud.dataproc.v1.ClusterOperationStatusOrBuilder>(
                getStatus(), getParentForChildren(), isClean());
        status_ = null;
      }
      return statusBuilder_;
    }

    private java.util.List<com.google.cloud.dataproc.v1.ClusterOperationStatus> statusHistory_ =
        java.util.Collections.emptyList();

    private void ensureStatusHistoryIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        statusHistory_ =
            new java.util.ArrayList<com.google.cloud.dataproc.v1.ClusterOperationStatus>(
                statusHistory_);
        bitField0_ |= 0x00000008;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dataproc.v1.ClusterOperationStatus,
            com.google.cloud.dataproc.v1.ClusterOperationStatus.Builder,
            com.google.cloud.dataproc.v1.ClusterOperationStatusOrBuilder>
        statusHistoryBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. The previous operation status.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.ClusterOperationStatus status_history = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.dataproc.v1.ClusterOperationStatus>
        getStatusHistoryList() {
      if (statusHistoryBuilder_ == null) {
        return java.util.Collections.unmodifiableList(statusHistory_);
      } else {
        return statusHistoryBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The previous operation status.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.ClusterOperationStatus status_history = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public int getStatusHistoryCount() {
      if (statusHistoryBuilder_ == null) {
        return statusHistory_.size();
      } else {
        return statusHistoryBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The previous operation status.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.ClusterOperationStatus status_history = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.dataproc.v1.ClusterOperationStatus getStatusHistory(int index) {
      if (statusHistoryBuilder_ == null) {
        return statusHistory_.get(index);
      } else {
        return statusHistoryBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The previous operation status.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.ClusterOperationStatus status_history = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setStatusHistory(
        int index, com.google.cloud.dataproc.v1.ClusterOperationStatus value) {
      if (statusHistoryBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureStatusHistoryIsMutable();
        statusHistory_.set(index, value);
        onChanged();
      } else {
        statusHistoryBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The previous operation status.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.ClusterOperationStatus status_history = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setStatusHistory(
        int index, com.google.cloud.dataproc.v1.ClusterOperationStatus.Builder builderForValue) {
      if (statusHistoryBuilder_ == null) {
        ensureStatusHistoryIsMutable();
        statusHistory_.set(index, builderForValue.build());
        onChanged();
      } else {
        statusHistoryBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The previous operation status.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.ClusterOperationStatus status_history = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addStatusHistory(com.google.cloud.dataproc.v1.ClusterOperationStatus value) {
      if (statusHistoryBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureStatusHistoryIsMutable();
        statusHistory_.add(value);
        onChanged();
      } else {
        statusHistoryBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The previous operation status.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.ClusterOperationStatus status_history = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addStatusHistory(
        int index, com.google.cloud.dataproc.v1.ClusterOperationStatus value) {
      if (statusHistoryBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureStatusHistoryIsMutable();
        statusHistory_.add(index, value);
        onChanged();
      } else {
        statusHistoryBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The previous operation status.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.ClusterOperationStatus status_history = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addStatusHistory(
        com.google.cloud.dataproc.v1.ClusterOperationStatus.Builder builderForValue) {
      if (statusHistoryBuilder_ == null) {
        ensureStatusHistoryIsMutable();
        statusHistory_.add(builderForValue.build());
        onChanged();
      } else {
        statusHistoryBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The previous operation status.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.ClusterOperationStatus status_history = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addStatusHistory(
        int index, com.google.cloud.dataproc.v1.ClusterOperationStatus.Builder builderForValue) {
      if (statusHistoryBuilder_ == null) {
        ensureStatusHistoryIsMutable();
        statusHistory_.add(index, builderForValue.build());
        onChanged();
      } else {
        statusHistoryBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The previous operation status.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.ClusterOperationStatus status_history = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAllStatusHistory(
        java.lang.Iterable<? extends com.google.cloud.dataproc.v1.ClusterOperationStatus> values) {
      if (statusHistoryBuilder_ == null) {
        ensureStatusHistoryIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, statusHistory_);
        onChanged();
      } else {
        statusHistoryBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The previous operation status.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.ClusterOperationStatus status_history = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearStatusHistory() {
      if (statusHistoryBuilder_ == null) {
        statusHistory_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
      } else {
        statusHistoryBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The previous operation status.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.ClusterOperationStatus status_history = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removeStatusHistory(int index) {
      if (statusHistoryBuilder_ == null) {
        ensureStatusHistoryIsMutable();
        statusHistory_.remove(index);
        onChanged();
      } else {
        statusHistoryBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The previous operation status.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.ClusterOperationStatus status_history = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.dataproc.v1.ClusterOperationStatus.Builder getStatusHistoryBuilder(
        int index) {
      return getStatusHistoryFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. The previous operation status.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.ClusterOperationStatus status_history = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.dataproc.v1.ClusterOperationStatusOrBuilder getStatusHistoryOrBuilder(
        int index) {
      if (statusHistoryBuilder_ == null) {
        return statusHistory_.get(index);
      } else {
        return statusHistoryBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The previous operation status.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.ClusterOperationStatus status_history = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.dataproc.v1.ClusterOperationStatusOrBuilder>
        getStatusHistoryOrBuilderList() {
      if (statusHistoryBuilder_ != null) {
        return statusHistoryBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(statusHistory_);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The previous operation status.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.ClusterOperationStatus status_history = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.dataproc.v1.ClusterOperationStatus.Builder addStatusHistoryBuilder() {
      return getStatusHistoryFieldBuilder()
          .addBuilder(com.google.cloud.dataproc.v1.ClusterOperationStatus.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. The previous operation status.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.ClusterOperationStatus status_history = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.dataproc.v1.ClusterOperationStatus.Builder addStatusHistoryBuilder(
        int index) {
      return getStatusHistoryFieldBuilder()
          .addBuilder(
              index, com.google.cloud.dataproc.v1.ClusterOperationStatus.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. The previous operation status.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.ClusterOperationStatus status_history = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.dataproc.v1.ClusterOperationStatus.Builder>
        getStatusHistoryBuilderList() {
      return getStatusHistoryFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dataproc.v1.ClusterOperationStatus,
            com.google.cloud.dataproc.v1.ClusterOperationStatus.Builder,
            com.google.cloud.dataproc.v1.ClusterOperationStatusOrBuilder>
        getStatusHistoryFieldBuilder() {
      if (statusHistoryBuilder_ == null) {
        statusHistoryBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.dataproc.v1.ClusterOperationStatus,
                com.google.cloud.dataproc.v1.ClusterOperationStatus.Builder,
                com.google.cloud.dataproc.v1.ClusterOperationStatusOrBuilder>(
                statusHistory_,
                ((bitField0_ & 0x00000008) != 0),
                getParentForChildren(),
                isClean());
        statusHistory_ = null;
      }
      return statusHistoryBuilder_;
    }

    private java.lang.Object operationType_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The operation type.
     * </pre>
     *
     * <code>string operation_type = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The operationType.
     */
    public java.lang.String getOperationType() {
      java.lang.Object ref = operationType_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        operationType_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The operation type.
     * </pre>
     *
     * <code>string operation_type = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for operationType.
     */
    public com.google.protobuf.ByteString getOperationTypeBytes() {
      java.lang.Object ref = operationType_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        operationType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The operation type.
     * </pre>
     *
     * <code>string operation_type = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The operationType to set.
     * @return This builder for chaining.
     */
    public Builder setOperationType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      operationType_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The operation type.
     * </pre>
     *
     * <code>string operation_type = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearOperationType() {
      operationType_ = getDefaultInstance().getOperationType();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The operation type.
     * </pre>
     *
     * <code>string operation_type = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for operationType to set.
     * @return This builder for chaining.
     */
    public Builder setOperationTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      operationType_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Short description of operation.
     * </pre>
     *
     * <code>string description = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Short description of operation.
     * </pre>
     *
     * <code>string description = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Short description of operation.
     * </pre>
     *
     * <code>string description = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Short description of operation.
     * </pre>
     *
     * <code>string description = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Short description of operation.
     * </pre>
     *
     * <code>string description = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Output only. Labels associated with the operation
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * Output only. Labels associated with the operation
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * Output only. Labels associated with the operation
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Output only. Labels associated with the operation
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      bitField0_ = (bitField0_ & ~0x00000040);
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Labels associated with the operation
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      bitField0_ |= 0x00000040;
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Output only. Labels associated with the operation
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00000040;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Labels associated with the operation
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00000040;
      return this;
    }

    private com.google.protobuf.LazyStringArrayList warnings_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureWarningsIsMutable() {
      if (!warnings_.isModifiable()) {
        warnings_ = new com.google.protobuf.LazyStringArrayList(warnings_);
      }
      bitField0_ |= 0x00000080;
    }
    /**
     *
     *
     * <pre>
     * Output only. Errors encountered during operation execution.
     * </pre>
     *
     * <code>repeated string warnings = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return A list containing the warnings.
     */
    public com.google.protobuf.ProtocolStringList getWarningsList() {
      warnings_.makeImmutable();
      return warnings_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Errors encountered during operation execution.
     * </pre>
     *
     * <code>repeated string warnings = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The count of warnings.
     */
    public int getWarningsCount() {
      return warnings_.size();
    }
    /**
     *
     *
     * <pre>
     * Output only. Errors encountered during operation execution.
     * </pre>
     *
     * <code>repeated string warnings = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param index The index of the element to return.
     * @return The warnings at the given index.
     */
    public java.lang.String getWarnings(int index) {
      return warnings_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. Errors encountered during operation execution.
     * </pre>
     *
     * <code>repeated string warnings = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the warnings at the given index.
     */
    public com.google.protobuf.ByteString getWarningsBytes(int index) {
      return warnings_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. Errors encountered during operation execution.
     * </pre>
     *
     * <code>repeated string warnings = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param index The index to set the value at.
     * @param value The warnings to set.
     * @return This builder for chaining.
     */
    public Builder setWarnings(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureWarningsIsMutable();
      warnings_.set(index, value);
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Errors encountered during operation execution.
     * </pre>
     *
     * <code>repeated string warnings = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The warnings to add.
     * @return This builder for chaining.
     */
    public Builder addWarnings(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureWarningsIsMutable();
      warnings_.add(value);
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Errors encountered during operation execution.
     * </pre>
     *
     * <code>repeated string warnings = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param values The warnings to add.
     * @return This builder for chaining.
     */
    public Builder addAllWarnings(java.lang.Iterable<java.lang.String> values) {
      ensureWarningsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, warnings_);
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Errors encountered during operation execution.
     * </pre>
     *
     * <code>repeated string warnings = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearWarnings() {
      warnings_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000080);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Errors encountered during operation execution.
     * </pre>
     *
     * <code>repeated string warnings = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes of the warnings to add.
     * @return This builder for chaining.
     */
    public Builder addWarningsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureWarningsIsMutable();
      warnings_.add(value);
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList childOperationIds_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureChildOperationIdsIsMutable() {
      if (!childOperationIds_.isModifiable()) {
        childOperationIds_ = new com.google.protobuf.LazyStringArrayList(childOperationIds_);
      }
      bitField0_ |= 0x00000100;
    }
    /**
     *
     *
     * <pre>
     * Output only. Child operation ids
     * </pre>
     *
     * <code>repeated string child_operation_ids = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return A list containing the childOperationIds.
     */
    public com.google.protobuf.ProtocolStringList getChildOperationIdsList() {
      childOperationIds_.makeImmutable();
      return childOperationIds_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Child operation ids
     * </pre>
     *
     * <code>repeated string child_operation_ids = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The count of childOperationIds.
     */
    public int getChildOperationIdsCount() {
      return childOperationIds_.size();
    }
    /**
     *
     *
     * <pre>
     * Output only. Child operation ids
     * </pre>
     *
     * <code>repeated string child_operation_ids = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param index The index of the element to return.
     * @return The childOperationIds at the given index.
     */
    public java.lang.String getChildOperationIds(int index) {
      return childOperationIds_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. Child operation ids
     * </pre>
     *
     * <code>repeated string child_operation_ids = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the childOperationIds at the given index.
     */
    public com.google.protobuf.ByteString getChildOperationIdsBytes(int index) {
      return childOperationIds_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. Child operation ids
     * </pre>
     *
     * <code>repeated string child_operation_ids = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The childOperationIds to set.
     * @return This builder for chaining.
     */
    public Builder setChildOperationIds(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureChildOperationIdsIsMutable();
      childOperationIds_.set(index, value);
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Child operation ids
     * </pre>
     *
     * <code>repeated string child_operation_ids = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The childOperationIds to add.
     * @return This builder for chaining.
     */
    public Builder addChildOperationIds(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureChildOperationIdsIsMutable();
      childOperationIds_.add(value);
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Child operation ids
     * </pre>
     *
     * <code>repeated string child_operation_ids = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param values The childOperationIds to add.
     * @return This builder for chaining.
     */
    public Builder addAllChildOperationIds(java.lang.Iterable<java.lang.String> values) {
      ensureChildOperationIdsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, childOperationIds_);
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Child operation ids
     * </pre>
     *
     * <code>repeated string child_operation_ids = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearChildOperationIds() {
      childOperationIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000100);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Child operation ids
     * </pre>
     *
     * <code>repeated string child_operation_ids = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The bytes of the childOperationIds to add.
     * @return This builder for chaining.
     */
    public Builder addChildOperationIdsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureChildOperationIdsIsMutable();
      childOperationIds_.add(value);
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dataproc.v1.ClusterOperationMetadata)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dataproc.v1.ClusterOperationMetadata)
  private static final com.google.cloud.dataproc.v1.ClusterOperationMetadata DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dataproc.v1.ClusterOperationMetadata();
  }

  public static com.google.cloud.dataproc.v1.ClusterOperationMetadata getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ClusterOperationMetadata> PARSER =
      new com.google.protobuf.AbstractParser<ClusterOperationMetadata>() {
        @java.lang.Override
        public ClusterOperationMetadata parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ClusterOperationMetadata> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ClusterOperationMetadata> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dataproc.v1.ClusterOperationMetadata getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
