/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dataproc/v1/clusters.proto

package com.google.cloud.dataproc.v1;

/**
 *
 *
 * <pre>
 * Dataproc metric config.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dataproc.v1.DataprocMetricConfig}
 */
public final class DataprocMetricConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dataproc.v1.DataprocMetricConfig)
    DataprocMetricConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use DataprocMetricConfig.newBuilder() to construct.
  private DataprocMetricConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private DataprocMetricConfig() {
    metrics_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new DataprocMetricConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dataproc.v1.ClustersProto
        .internal_static_google_cloud_dataproc_v1_DataprocMetricConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dataproc.v1.ClustersProto
        .internal_static_google_cloud_dataproc_v1_DataprocMetricConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dataproc.v1.DataprocMetricConfig.class,
            com.google.cloud.dataproc.v1.DataprocMetricConfig.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * A source for the collection of Dataproc custom metrics (see [Custom
   * metrics]
   * (https://cloud.google.com//dataproc/docs/guides/dataproc-metrics#custom_metrics)).
   * </pre>
   *
   * Protobuf enum {@code google.cloud.dataproc.v1.DataprocMetricConfig.MetricSource}
   */
  public enum MetricSource implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Required unspecified metric source.
     * </pre>
     *
     * <code>METRIC_SOURCE_UNSPECIFIED = 0;</code>
     */
    METRIC_SOURCE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Monitoring agent metrics. If this source is enabled,
     * Dataproc enables the monitoring agent in Compute Engine,
     * and collects monitoring agent metrics, which are published
     * with an `agent.googleapis.com` prefix.
     * </pre>
     *
     * <code>MONITORING_AGENT_DEFAULTS = 1;</code>
     */
    MONITORING_AGENT_DEFAULTS(1),
    /**
     *
     *
     * <pre>
     * HDFS metric source.
     * </pre>
     *
     * <code>HDFS = 2;</code>
     */
    HDFS(2),
    /**
     *
     *
     * <pre>
     * Spark metric source.
     * </pre>
     *
     * <code>SPARK = 3;</code>
     */
    SPARK(3),
    /**
     *
     *
     * <pre>
     * YARN metric source.
     * </pre>
     *
     * <code>YARN = 4;</code>
     */
    YARN(4),
    /**
     *
     *
     * <pre>
     * Spark History Server metric source.
     * </pre>
     *
     * <code>SPARK_HISTORY_SERVER = 5;</code>
     */
    SPARK_HISTORY_SERVER(5),
    /**
     *
     *
     * <pre>
     * Hiveserver2 metric source.
     * </pre>
     *
     * <code>HIVESERVER2 = 6;</code>
     */
    HIVESERVER2(6),
    /**
     *
     *
     * <pre>
     * hivemetastore metric source
     * </pre>
     *
     * <code>HIVEMETASTORE = 7;</code>
     */
    HIVEMETASTORE(7),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Required unspecified metric source.
     * </pre>
     *
     * <code>METRIC_SOURCE_UNSPECIFIED = 0;</code>
     */
    public static final int METRIC_SOURCE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Monitoring agent metrics. If this source is enabled,
     * Dataproc enables the monitoring agent in Compute Engine,
     * and collects monitoring agent metrics, which are published
     * with an `agent.googleapis.com` prefix.
     * </pre>
     *
     * <code>MONITORING_AGENT_DEFAULTS = 1;</code>
     */
    public static final int MONITORING_AGENT_DEFAULTS_VALUE = 1;
    /**
     *
     *
     * <pre>
     * HDFS metric source.
     * </pre>
     *
     * <code>HDFS = 2;</code>
     */
    public static final int HDFS_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Spark metric source.
     * </pre>
     *
     * <code>SPARK = 3;</code>
     */
    public static final int SPARK_VALUE = 3;
    /**
     *
     *
     * <pre>
     * YARN metric source.
     * </pre>
     *
     * <code>YARN = 4;</code>
     */
    public static final int YARN_VALUE = 4;
    /**
     *
     *
     * <pre>
     * Spark History Server metric source.
     * </pre>
     *
     * <code>SPARK_HISTORY_SERVER = 5;</code>
     */
    public static final int SPARK_HISTORY_SERVER_VALUE = 5;
    /**
     *
     *
     * <pre>
     * Hiveserver2 metric source.
     * </pre>
     *
     * <code>HIVESERVER2 = 6;</code>
     */
    public static final int HIVESERVER2_VALUE = 6;
    /**
     *
     *
     * <pre>
     * hivemetastore metric source
     * </pre>
     *
     * <code>HIVEMETASTORE = 7;</code>
     */
    public static final int HIVEMETASTORE_VALUE = 7;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static MetricSource valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static MetricSource forNumber(int value) {
      switch (value) {
        case 0:
          return METRIC_SOURCE_UNSPECIFIED;
        case 1:
          return MONITORING_AGENT_DEFAULTS;
        case 2:
          return HDFS;
        case 3:
          return SPARK;
        case 4:
          return YARN;
        case 5:
          return SPARK_HISTORY_SERVER;
        case 6:
          return HIVESERVER2;
        case 7:
          return HIVEMETASTORE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<MetricSource> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<MetricSource> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<MetricSource>() {
          public MetricSource findValueByNumber(int number) {
            return MetricSource.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.dataproc.v1.DataprocMetricConfig.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final MetricSource[] VALUES = values();

    public static MetricSource valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private MetricSource(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.dataproc.v1.DataprocMetricConfig.MetricSource)
  }

  public interface MetricOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dataproc.v1.DataprocMetricConfig.Metric)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. A standard set of metrics is collected unless `metricOverrides`
     * are specified for the metric source (see [Custom metrics]
     * (https://cloud.google.com/dataproc/docs/guides/dataproc-metrics#custom_metrics)
     * for more information).
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.DataprocMetricConfig.MetricSource metric_source = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The enum numeric value on the wire for metricSource.
     */
    int getMetricSourceValue();
    /**
     *
     *
     * <pre>
     * Required. A standard set of metrics is collected unless `metricOverrides`
     * are specified for the metric source (see [Custom metrics]
     * (https://cloud.google.com/dataproc/docs/guides/dataproc-metrics#custom_metrics)
     * for more information).
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.DataprocMetricConfig.MetricSource metric_source = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The metricSource.
     */
    com.google.cloud.dataproc.v1.DataprocMetricConfig.MetricSource getMetricSource();

    /**
     *
     *
     * <pre>
     * Optional. Specify one or more [Custom metrics]
     * (https://cloud.google.com/dataproc/docs/guides/dataproc-metrics#custom_metrics)
     * to collect for the metric course (for the `SPARK` metric source (any
     * [Spark metric]
     * (https://spark.apache.org/docs/latest/monitoring.html#metrics) can be
     * specified).
     *
     * Provide metrics in the following format:
     * &lt;code&gt;&lt;var&gt;METRIC_SOURCE&lt;/var&gt;:&lt;var&gt;INSTANCE&lt;/var&gt;:&lt;var&gt;GROUP&lt;/var&gt;:&lt;var&gt;METRIC&lt;/var&gt;&lt;/code&gt;
     * Use camelcase as appropriate.
     *
     * Examples:
     *
     * ```
     * yarn:ResourceManager:QueueMetrics:AppsCompleted
     * spark:driver:DAGScheduler:job.allJobs
     * sparkHistoryServer:JVM:Memory:NonHeapMemoryUsage.committed
     * hiveserver2:JVM:Memory:NonHeapMemoryUsage.used
     * ```
     *
     * Notes:
     *
     * * Only the specified overridden metrics are collected for the
     *   metric source. For example, if one or more `spark:executive` metrics
     *   are listed as metric overrides, other `SPARK` metrics are not
     *   collected. The collection of the metrics for other enabled custom
     *   metric sources is unaffected. For example, if both `SPARK` andd `YARN`
     *   metric sources are enabled, and overrides are provided for Spark
     *   metrics only, all YARN metrics are collected.
     * </pre>
     *
     * <code>repeated string metric_overrides = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return A list containing the metricOverrides.
     */
    java.util.List<java.lang.String> getMetricOverridesList();
    /**
     *
     *
     * <pre>
     * Optional. Specify one or more [Custom metrics]
     * (https://cloud.google.com/dataproc/docs/guides/dataproc-metrics#custom_metrics)
     * to collect for the metric course (for the `SPARK` metric source (any
     * [Spark metric]
     * (https://spark.apache.org/docs/latest/monitoring.html#metrics) can be
     * specified).
     *
     * Provide metrics in the following format:
     * &lt;code&gt;&lt;var&gt;METRIC_SOURCE&lt;/var&gt;:&lt;var&gt;INSTANCE&lt;/var&gt;:&lt;var&gt;GROUP&lt;/var&gt;:&lt;var&gt;METRIC&lt;/var&gt;&lt;/code&gt;
     * Use camelcase as appropriate.
     *
     * Examples:
     *
     * ```
     * yarn:ResourceManager:QueueMetrics:AppsCompleted
     * spark:driver:DAGScheduler:job.allJobs
     * sparkHistoryServer:JVM:Memory:NonHeapMemoryUsage.committed
     * hiveserver2:JVM:Memory:NonHeapMemoryUsage.used
     * ```
     *
     * Notes:
     *
     * * Only the specified overridden metrics are collected for the
     *   metric source. For example, if one or more `spark:executive` metrics
     *   are listed as metric overrides, other `SPARK` metrics are not
     *   collected. The collection of the metrics for other enabled custom
     *   metric sources is unaffected. For example, if both `SPARK` andd `YARN`
     *   metric sources are enabled, and overrides are provided for Spark
     *   metrics only, all YARN metrics are collected.
     * </pre>
     *
     * <code>repeated string metric_overrides = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The count of metricOverrides.
     */
    int getMetricOverridesCount();
    /**
     *
     *
     * <pre>
     * Optional. Specify one or more [Custom metrics]
     * (https://cloud.google.com/dataproc/docs/guides/dataproc-metrics#custom_metrics)
     * to collect for the metric course (for the `SPARK` metric source (any
     * [Spark metric]
     * (https://spark.apache.org/docs/latest/monitoring.html#metrics) can be
     * specified).
     *
     * Provide metrics in the following format:
     * &lt;code&gt;&lt;var&gt;METRIC_SOURCE&lt;/var&gt;:&lt;var&gt;INSTANCE&lt;/var&gt;:&lt;var&gt;GROUP&lt;/var&gt;:&lt;var&gt;METRIC&lt;/var&gt;&lt;/code&gt;
     * Use camelcase as appropriate.
     *
     * Examples:
     *
     * ```
     * yarn:ResourceManager:QueueMetrics:AppsCompleted
     * spark:driver:DAGScheduler:job.allJobs
     * sparkHistoryServer:JVM:Memory:NonHeapMemoryUsage.committed
     * hiveserver2:JVM:Memory:NonHeapMemoryUsage.used
     * ```
     *
     * Notes:
     *
     * * Only the specified overridden metrics are collected for the
     *   metric source. For example, if one or more `spark:executive` metrics
     *   are listed as metric overrides, other `SPARK` metrics are not
     *   collected. The collection of the metrics for other enabled custom
     *   metric sources is unaffected. For example, if both `SPARK` andd `YARN`
     *   metric sources are enabled, and overrides are provided for Spark
     *   metrics only, all YARN metrics are collected.
     * </pre>
     *
     * <code>repeated string metric_overrides = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the element to return.
     * @return The metricOverrides at the given index.
     */
    java.lang.String getMetricOverrides(int index);
    /**
     *
     *
     * <pre>
     * Optional. Specify one or more [Custom metrics]
     * (https://cloud.google.com/dataproc/docs/guides/dataproc-metrics#custom_metrics)
     * to collect for the metric course (for the `SPARK` metric source (any
     * [Spark metric]
     * (https://spark.apache.org/docs/latest/monitoring.html#metrics) can be
     * specified).
     *
     * Provide metrics in the following format:
     * &lt;code&gt;&lt;var&gt;METRIC_SOURCE&lt;/var&gt;:&lt;var&gt;INSTANCE&lt;/var&gt;:&lt;var&gt;GROUP&lt;/var&gt;:&lt;var&gt;METRIC&lt;/var&gt;&lt;/code&gt;
     * Use camelcase as appropriate.
     *
     * Examples:
     *
     * ```
     * yarn:ResourceManager:QueueMetrics:AppsCompleted
     * spark:driver:DAGScheduler:job.allJobs
     * sparkHistoryServer:JVM:Memory:NonHeapMemoryUsage.committed
     * hiveserver2:JVM:Memory:NonHeapMemoryUsage.used
     * ```
     *
     * Notes:
     *
     * * Only the specified overridden metrics are collected for the
     *   metric source. For example, if one or more `spark:executive` metrics
     *   are listed as metric overrides, other `SPARK` metrics are not
     *   collected. The collection of the metrics for other enabled custom
     *   metric sources is unaffected. For example, if both `SPARK` andd `YARN`
     *   metric sources are enabled, and overrides are provided for Spark
     *   metrics only, all YARN metrics are collected.
     * </pre>
     *
     * <code>repeated string metric_overrides = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the metricOverrides at the given index.
     */
    com.google.protobuf.ByteString getMetricOverridesBytes(int index);
  }
  /**
   *
   *
   * <pre>
   * A Dataproc custom metric.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dataproc.v1.DataprocMetricConfig.Metric}
   */
  public static final class Metric extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dataproc.v1.DataprocMetricConfig.Metric)
      MetricOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Metric.newBuilder() to construct.
    private Metric(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Metric() {
      metricSource_ = 0;
      metricOverrides_ = com.google.protobuf.LazyStringArrayList.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Metric();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dataproc.v1.ClustersProto
          .internal_static_google_cloud_dataproc_v1_DataprocMetricConfig_Metric_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dataproc.v1.ClustersProto
          .internal_static_google_cloud_dataproc_v1_DataprocMetricConfig_Metric_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dataproc.v1.DataprocMetricConfig.Metric.class,
              com.google.cloud.dataproc.v1.DataprocMetricConfig.Metric.Builder.class);
    }

    public static final int METRIC_SOURCE_FIELD_NUMBER = 1;
    private int metricSource_ = 0;
    /**
     *
     *
     * <pre>
     * Required. A standard set of metrics is collected unless `metricOverrides`
     * are specified for the metric source (see [Custom metrics]
     * (https://cloud.google.com/dataproc/docs/guides/dataproc-metrics#custom_metrics)
     * for more information).
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.DataprocMetricConfig.MetricSource metric_source = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The enum numeric value on the wire for metricSource.
     */
    @java.lang.Override
    public int getMetricSourceValue() {
      return metricSource_;
    }
    /**
     *
     *
     * <pre>
     * Required. A standard set of metrics is collected unless `metricOverrides`
     * are specified for the metric source (see [Custom metrics]
     * (https://cloud.google.com/dataproc/docs/guides/dataproc-metrics#custom_metrics)
     * for more information).
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.DataprocMetricConfig.MetricSource metric_source = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The metricSource.
     */
    @java.lang.Override
    public com.google.cloud.dataproc.v1.DataprocMetricConfig.MetricSource getMetricSource() {
      com.google.cloud.dataproc.v1.DataprocMetricConfig.MetricSource result =
          com.google.cloud.dataproc.v1.DataprocMetricConfig.MetricSource.forNumber(metricSource_);
      return result == null
          ? com.google.cloud.dataproc.v1.DataprocMetricConfig.MetricSource.UNRECOGNIZED
          : result;
    }

    public static final int METRIC_OVERRIDES_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList metricOverrides_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    /**
     *
     *
     * <pre>
     * Optional. Specify one or more [Custom metrics]
     * (https://cloud.google.com/dataproc/docs/guides/dataproc-metrics#custom_metrics)
     * to collect for the metric course (for the `SPARK` metric source (any
     * [Spark metric]
     * (https://spark.apache.org/docs/latest/monitoring.html#metrics) can be
     * specified).
     *
     * Provide metrics in the following format:
     * &lt;code&gt;&lt;var&gt;METRIC_SOURCE&lt;/var&gt;:&lt;var&gt;INSTANCE&lt;/var&gt;:&lt;var&gt;GROUP&lt;/var&gt;:&lt;var&gt;METRIC&lt;/var&gt;&lt;/code&gt;
     * Use camelcase as appropriate.
     *
     * Examples:
     *
     * ```
     * yarn:ResourceManager:QueueMetrics:AppsCompleted
     * spark:driver:DAGScheduler:job.allJobs
     * sparkHistoryServer:JVM:Memory:NonHeapMemoryUsage.committed
     * hiveserver2:JVM:Memory:NonHeapMemoryUsage.used
     * ```
     *
     * Notes:
     *
     * * Only the specified overridden metrics are collected for the
     *   metric source. For example, if one or more `spark:executive` metrics
     *   are listed as metric overrides, other `SPARK` metrics are not
     *   collected. The collection of the metrics for other enabled custom
     *   metric sources is unaffected. For example, if both `SPARK` andd `YARN`
     *   metric sources are enabled, and overrides are provided for Spark
     *   metrics only, all YARN metrics are collected.
     * </pre>
     *
     * <code>repeated string metric_overrides = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return A list containing the metricOverrides.
     */
    public com.google.protobuf.ProtocolStringList getMetricOverridesList() {
      return metricOverrides_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Specify one or more [Custom metrics]
     * (https://cloud.google.com/dataproc/docs/guides/dataproc-metrics#custom_metrics)
     * to collect for the metric course (for the `SPARK` metric source (any
     * [Spark metric]
     * (https://spark.apache.org/docs/latest/monitoring.html#metrics) can be
     * specified).
     *
     * Provide metrics in the following format:
     * &lt;code&gt;&lt;var&gt;METRIC_SOURCE&lt;/var&gt;:&lt;var&gt;INSTANCE&lt;/var&gt;:&lt;var&gt;GROUP&lt;/var&gt;:&lt;var&gt;METRIC&lt;/var&gt;&lt;/code&gt;
     * Use camelcase as appropriate.
     *
     * Examples:
     *
     * ```
     * yarn:ResourceManager:QueueMetrics:AppsCompleted
     * spark:driver:DAGScheduler:job.allJobs
     * sparkHistoryServer:JVM:Memory:NonHeapMemoryUsage.committed
     * hiveserver2:JVM:Memory:NonHeapMemoryUsage.used
     * ```
     *
     * Notes:
     *
     * * Only the specified overridden metrics are collected for the
     *   metric source. For example, if one or more `spark:executive` metrics
     *   are listed as metric overrides, other `SPARK` metrics are not
     *   collected. The collection of the metrics for other enabled custom
     *   metric sources is unaffected. For example, if both `SPARK` andd `YARN`
     *   metric sources are enabled, and overrides are provided for Spark
     *   metrics only, all YARN metrics are collected.
     * </pre>
     *
     * <code>repeated string metric_overrides = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The count of metricOverrides.
     */
    public int getMetricOverridesCount() {
      return metricOverrides_.size();
    }
    /**
     *
     *
     * <pre>
     * Optional. Specify one or more [Custom metrics]
     * (https://cloud.google.com/dataproc/docs/guides/dataproc-metrics#custom_metrics)
     * to collect for the metric course (for the `SPARK` metric source (any
     * [Spark metric]
     * (https://spark.apache.org/docs/latest/monitoring.html#metrics) can be
     * specified).
     *
     * Provide metrics in the following format:
     * &lt;code&gt;&lt;var&gt;METRIC_SOURCE&lt;/var&gt;:&lt;var&gt;INSTANCE&lt;/var&gt;:&lt;var&gt;GROUP&lt;/var&gt;:&lt;var&gt;METRIC&lt;/var&gt;&lt;/code&gt;
     * Use camelcase as appropriate.
     *
     * Examples:
     *
     * ```
     * yarn:ResourceManager:QueueMetrics:AppsCompleted
     * spark:driver:DAGScheduler:job.allJobs
     * sparkHistoryServer:JVM:Memory:NonHeapMemoryUsage.committed
     * hiveserver2:JVM:Memory:NonHeapMemoryUsage.used
     * ```
     *
     * Notes:
     *
     * * Only the specified overridden metrics are collected for the
     *   metric source. For example, if one or more `spark:executive` metrics
     *   are listed as metric overrides, other `SPARK` metrics are not
     *   collected. The collection of the metrics for other enabled custom
     *   metric sources is unaffected. For example, if both `SPARK` andd `YARN`
     *   metric sources are enabled, and overrides are provided for Spark
     *   metrics only, all YARN metrics are collected.
     * </pre>
     *
     * <code>repeated string metric_overrides = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the element to return.
     * @return The metricOverrides at the given index.
     */
    public java.lang.String getMetricOverrides(int index) {
      return metricOverrides_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. Specify one or more [Custom metrics]
     * (https://cloud.google.com/dataproc/docs/guides/dataproc-metrics#custom_metrics)
     * to collect for the metric course (for the `SPARK` metric source (any
     * [Spark metric]
     * (https://spark.apache.org/docs/latest/monitoring.html#metrics) can be
     * specified).
     *
     * Provide metrics in the following format:
     * &lt;code&gt;&lt;var&gt;METRIC_SOURCE&lt;/var&gt;:&lt;var&gt;INSTANCE&lt;/var&gt;:&lt;var&gt;GROUP&lt;/var&gt;:&lt;var&gt;METRIC&lt;/var&gt;&lt;/code&gt;
     * Use camelcase as appropriate.
     *
     * Examples:
     *
     * ```
     * yarn:ResourceManager:QueueMetrics:AppsCompleted
     * spark:driver:DAGScheduler:job.allJobs
     * sparkHistoryServer:JVM:Memory:NonHeapMemoryUsage.committed
     * hiveserver2:JVM:Memory:NonHeapMemoryUsage.used
     * ```
     *
     * Notes:
     *
     * * Only the specified overridden metrics are collected for the
     *   metric source. For example, if one or more `spark:executive` metrics
     *   are listed as metric overrides, other `SPARK` metrics are not
     *   collected. The collection of the metrics for other enabled custom
     *   metric sources is unaffected. For example, if both `SPARK` andd `YARN`
     *   metric sources are enabled, and overrides are provided for Spark
     *   metrics only, all YARN metrics are collected.
     * </pre>
     *
     * <code>repeated string metric_overrides = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the metricOverrides at the given index.
     */
    public com.google.protobuf.ByteString getMetricOverridesBytes(int index) {
      return metricOverrides_.getByteString(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (metricSource_
          != com.google.cloud.dataproc.v1.DataprocMetricConfig.MetricSource
              .METRIC_SOURCE_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(1, metricSource_);
      }
      for (int i = 0; i < metricOverrides_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, metricOverrides_.getRaw(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (metricSource_
          != com.google.cloud.dataproc.v1.DataprocMetricConfig.MetricSource
              .METRIC_SOURCE_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, metricSource_);
      }
      {
        int dataSize = 0;
        for (int i = 0; i < metricOverrides_.size(); i++) {
          dataSize += computeStringSizeNoTag(metricOverrides_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getMetricOverridesList().size();
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.dataproc.v1.DataprocMetricConfig.Metric)) {
        return super.equals(obj);
      }
      com.google.cloud.dataproc.v1.DataprocMetricConfig.Metric other =
          (com.google.cloud.dataproc.v1.DataprocMetricConfig.Metric) obj;

      if (metricSource_ != other.metricSource_) return false;
      if (!getMetricOverridesList().equals(other.getMetricOverridesList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + METRIC_SOURCE_FIELD_NUMBER;
      hash = (53 * hash) + metricSource_;
      if (getMetricOverridesCount() > 0) {
        hash = (37 * hash) + METRIC_OVERRIDES_FIELD_NUMBER;
        hash = (53 * hash) + getMetricOverridesList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dataproc.v1.DataprocMetricConfig.Metric parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dataproc.v1.DataprocMetricConfig.Metric parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dataproc.v1.DataprocMetricConfig.Metric parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dataproc.v1.DataprocMetricConfig.Metric parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dataproc.v1.DataprocMetricConfig.Metric parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dataproc.v1.DataprocMetricConfig.Metric parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dataproc.v1.DataprocMetricConfig.Metric parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dataproc.v1.DataprocMetricConfig.Metric parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dataproc.v1.DataprocMetricConfig.Metric parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dataproc.v1.DataprocMetricConfig.Metric parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dataproc.v1.DataprocMetricConfig.Metric parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dataproc.v1.DataprocMetricConfig.Metric parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dataproc.v1.DataprocMetricConfig.Metric prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A Dataproc custom metric.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dataproc.v1.DataprocMetricConfig.Metric}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dataproc.v1.DataprocMetricConfig.Metric)
        com.google.cloud.dataproc.v1.DataprocMetricConfig.MetricOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dataproc.v1.ClustersProto
            .internal_static_google_cloud_dataproc_v1_DataprocMetricConfig_Metric_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dataproc.v1.ClustersProto
            .internal_static_google_cloud_dataproc_v1_DataprocMetricConfig_Metric_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dataproc.v1.DataprocMetricConfig.Metric.class,
                com.google.cloud.dataproc.v1.DataprocMetricConfig.Metric.Builder.class);
      }

      // Construct using com.google.cloud.dataproc.v1.DataprocMetricConfig.Metric.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        metricSource_ = 0;
        metricOverrides_ = com.google.protobuf.LazyStringArrayList.emptyList();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dataproc.v1.ClustersProto
            .internal_static_google_cloud_dataproc_v1_DataprocMetricConfig_Metric_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dataproc.v1.DataprocMetricConfig.Metric getDefaultInstanceForType() {
        return com.google.cloud.dataproc.v1.DataprocMetricConfig.Metric.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dataproc.v1.DataprocMetricConfig.Metric build() {
        com.google.cloud.dataproc.v1.DataprocMetricConfig.Metric result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dataproc.v1.DataprocMetricConfig.Metric buildPartial() {
        com.google.cloud.dataproc.v1.DataprocMetricConfig.Metric result =
            new com.google.cloud.dataproc.v1.DataprocMetricConfig.Metric(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloud.dataproc.v1.DataprocMetricConfig.Metric result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.metricSource_ = metricSource_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          metricOverrides_.makeImmutable();
          result.metricOverrides_ = metricOverrides_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.dataproc.v1.DataprocMetricConfig.Metric) {
          return mergeFrom((com.google.cloud.dataproc.v1.DataprocMetricConfig.Metric) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.dataproc.v1.DataprocMetricConfig.Metric other) {
        if (other == com.google.cloud.dataproc.v1.DataprocMetricConfig.Metric.getDefaultInstance())
          return this;
        if (other.metricSource_ != 0) {
          setMetricSourceValue(other.getMetricSourceValue());
        }
        if (!other.metricOverrides_.isEmpty()) {
          if (metricOverrides_.isEmpty()) {
            metricOverrides_ = other.metricOverrides_;
            bitField0_ |= 0x00000002;
          } else {
            ensureMetricOverridesIsMutable();
            metricOverrides_.addAll(other.metricOverrides_);
          }
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  metricSource_ = input.readEnum();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 18:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureMetricOverridesIsMutable();
                  metricOverrides_.add(s);
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int metricSource_ = 0;
      /**
       *
       *
       * <pre>
       * Required. A standard set of metrics is collected unless `metricOverrides`
       * are specified for the metric source (see [Custom metrics]
       * (https://cloud.google.com/dataproc/docs/guides/dataproc-metrics#custom_metrics)
       * for more information).
       * </pre>
       *
       * <code>
       * .google.cloud.dataproc.v1.DataprocMetricConfig.MetricSource metric_source = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The enum numeric value on the wire for metricSource.
       */
      @java.lang.Override
      public int getMetricSourceValue() {
        return metricSource_;
      }
      /**
       *
       *
       * <pre>
       * Required. A standard set of metrics is collected unless `metricOverrides`
       * are specified for the metric source (see [Custom metrics]
       * (https://cloud.google.com/dataproc/docs/guides/dataproc-metrics#custom_metrics)
       * for more information).
       * </pre>
       *
       * <code>
       * .google.cloud.dataproc.v1.DataprocMetricConfig.MetricSource metric_source = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @param value The enum numeric value on the wire for metricSource to set.
       * @return This builder for chaining.
       */
      public Builder setMetricSourceValue(int value) {
        metricSource_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. A standard set of metrics is collected unless `metricOverrides`
       * are specified for the metric source (see [Custom metrics]
       * (https://cloud.google.com/dataproc/docs/guides/dataproc-metrics#custom_metrics)
       * for more information).
       * </pre>
       *
       * <code>
       * .google.cloud.dataproc.v1.DataprocMetricConfig.MetricSource metric_source = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The metricSource.
       */
      @java.lang.Override
      public com.google.cloud.dataproc.v1.DataprocMetricConfig.MetricSource getMetricSource() {
        com.google.cloud.dataproc.v1.DataprocMetricConfig.MetricSource result =
            com.google.cloud.dataproc.v1.DataprocMetricConfig.MetricSource.forNumber(metricSource_);
        return result == null
            ? com.google.cloud.dataproc.v1.DataprocMetricConfig.MetricSource.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * Required. A standard set of metrics is collected unless `metricOverrides`
       * are specified for the metric source (see [Custom metrics]
       * (https://cloud.google.com/dataproc/docs/guides/dataproc-metrics#custom_metrics)
       * for more information).
       * </pre>
       *
       * <code>
       * .google.cloud.dataproc.v1.DataprocMetricConfig.MetricSource metric_source = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @param value The metricSource to set.
       * @return This builder for chaining.
       */
      public Builder setMetricSource(
          com.google.cloud.dataproc.v1.DataprocMetricConfig.MetricSource value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        metricSource_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. A standard set of metrics is collected unless `metricOverrides`
       * are specified for the metric source (see [Custom metrics]
       * (https://cloud.google.com/dataproc/docs/guides/dataproc-metrics#custom_metrics)
       * for more information).
       * </pre>
       *
       * <code>
       * .google.cloud.dataproc.v1.DataprocMetricConfig.MetricSource metric_source = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMetricSource() {
        bitField0_ = (bitField0_ & ~0x00000001);
        metricSource_ = 0;
        onChanged();
        return this;
      }

      private com.google.protobuf.LazyStringArrayList metricOverrides_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureMetricOverridesIsMutable() {
        if (!metricOverrides_.isModifiable()) {
          metricOverrides_ = new com.google.protobuf.LazyStringArrayList(metricOverrides_);
        }
        bitField0_ |= 0x00000002;
      }
      /**
       *
       *
       * <pre>
       * Optional. Specify one or more [Custom metrics]
       * (https://cloud.google.com/dataproc/docs/guides/dataproc-metrics#custom_metrics)
       * to collect for the metric course (for the `SPARK` metric source (any
       * [Spark metric]
       * (https://spark.apache.org/docs/latest/monitoring.html#metrics) can be
       * specified).
       *
       * Provide metrics in the following format:
       * &lt;code&gt;&lt;var&gt;METRIC_SOURCE&lt;/var&gt;:&lt;var&gt;INSTANCE&lt;/var&gt;:&lt;var&gt;GROUP&lt;/var&gt;:&lt;var&gt;METRIC&lt;/var&gt;&lt;/code&gt;
       * Use camelcase as appropriate.
       *
       * Examples:
       *
       * ```
       * yarn:ResourceManager:QueueMetrics:AppsCompleted
       * spark:driver:DAGScheduler:job.allJobs
       * sparkHistoryServer:JVM:Memory:NonHeapMemoryUsage.committed
       * hiveserver2:JVM:Memory:NonHeapMemoryUsage.used
       * ```
       *
       * Notes:
       *
       * * Only the specified overridden metrics are collected for the
       *   metric source. For example, if one or more `spark:executive` metrics
       *   are listed as metric overrides, other `SPARK` metrics are not
       *   collected. The collection of the metrics for other enabled custom
       *   metric sources is unaffected. For example, if both `SPARK` andd `YARN`
       *   metric sources are enabled, and overrides are provided for Spark
       *   metrics only, all YARN metrics are collected.
       * </pre>
       *
       * <code>repeated string metric_overrides = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return A list containing the metricOverrides.
       */
      public com.google.protobuf.ProtocolStringList getMetricOverridesList() {
        metricOverrides_.makeImmutable();
        return metricOverrides_;
      }
      /**
       *
       *
       * <pre>
       * Optional. Specify one or more [Custom metrics]
       * (https://cloud.google.com/dataproc/docs/guides/dataproc-metrics#custom_metrics)
       * to collect for the metric course (for the `SPARK` metric source (any
       * [Spark metric]
       * (https://spark.apache.org/docs/latest/monitoring.html#metrics) can be
       * specified).
       *
       * Provide metrics in the following format:
       * &lt;code&gt;&lt;var&gt;METRIC_SOURCE&lt;/var&gt;:&lt;var&gt;INSTANCE&lt;/var&gt;:&lt;var&gt;GROUP&lt;/var&gt;:&lt;var&gt;METRIC&lt;/var&gt;&lt;/code&gt;
       * Use camelcase as appropriate.
       *
       * Examples:
       *
       * ```
       * yarn:ResourceManager:QueueMetrics:AppsCompleted
       * spark:driver:DAGScheduler:job.allJobs
       * sparkHistoryServer:JVM:Memory:NonHeapMemoryUsage.committed
       * hiveserver2:JVM:Memory:NonHeapMemoryUsage.used
       * ```
       *
       * Notes:
       *
       * * Only the specified overridden metrics are collected for the
       *   metric source. For example, if one or more `spark:executive` metrics
       *   are listed as metric overrides, other `SPARK` metrics are not
       *   collected. The collection of the metrics for other enabled custom
       *   metric sources is unaffected. For example, if both `SPARK` andd `YARN`
       *   metric sources are enabled, and overrides are provided for Spark
       *   metrics only, all YARN metrics are collected.
       * </pre>
       *
       * <code>repeated string metric_overrides = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The count of metricOverrides.
       */
      public int getMetricOverridesCount() {
        return metricOverrides_.size();
      }
      /**
       *
       *
       * <pre>
       * Optional. Specify one or more [Custom metrics]
       * (https://cloud.google.com/dataproc/docs/guides/dataproc-metrics#custom_metrics)
       * to collect for the metric course (for the `SPARK` metric source (any
       * [Spark metric]
       * (https://spark.apache.org/docs/latest/monitoring.html#metrics) can be
       * specified).
       *
       * Provide metrics in the following format:
       * &lt;code&gt;&lt;var&gt;METRIC_SOURCE&lt;/var&gt;:&lt;var&gt;INSTANCE&lt;/var&gt;:&lt;var&gt;GROUP&lt;/var&gt;:&lt;var&gt;METRIC&lt;/var&gt;&lt;/code&gt;
       * Use camelcase as appropriate.
       *
       * Examples:
       *
       * ```
       * yarn:ResourceManager:QueueMetrics:AppsCompleted
       * spark:driver:DAGScheduler:job.allJobs
       * sparkHistoryServer:JVM:Memory:NonHeapMemoryUsage.committed
       * hiveserver2:JVM:Memory:NonHeapMemoryUsage.used
       * ```
       *
       * Notes:
       *
       * * Only the specified overridden metrics are collected for the
       *   metric source. For example, if one or more `spark:executive` metrics
       *   are listed as metric overrides, other `SPARK` metrics are not
       *   collected. The collection of the metrics for other enabled custom
       *   metric sources is unaffected. For example, if both `SPARK` andd `YARN`
       *   metric sources are enabled, and overrides are provided for Spark
       *   metrics only, all YARN metrics are collected.
       * </pre>
       *
       * <code>repeated string metric_overrides = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param index The index of the element to return.
       * @return The metricOverrides at the given index.
       */
      public java.lang.String getMetricOverrides(int index) {
        return metricOverrides_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Optional. Specify one or more [Custom metrics]
       * (https://cloud.google.com/dataproc/docs/guides/dataproc-metrics#custom_metrics)
       * to collect for the metric course (for the `SPARK` metric source (any
       * [Spark metric]
       * (https://spark.apache.org/docs/latest/monitoring.html#metrics) can be
       * specified).
       *
       * Provide metrics in the following format:
       * &lt;code&gt;&lt;var&gt;METRIC_SOURCE&lt;/var&gt;:&lt;var&gt;INSTANCE&lt;/var&gt;:&lt;var&gt;GROUP&lt;/var&gt;:&lt;var&gt;METRIC&lt;/var&gt;&lt;/code&gt;
       * Use camelcase as appropriate.
       *
       * Examples:
       *
       * ```
       * yarn:ResourceManager:QueueMetrics:AppsCompleted
       * spark:driver:DAGScheduler:job.allJobs
       * sparkHistoryServer:JVM:Memory:NonHeapMemoryUsage.committed
       * hiveserver2:JVM:Memory:NonHeapMemoryUsage.used
       * ```
       *
       * Notes:
       *
       * * Only the specified overridden metrics are collected for the
       *   metric source. For example, if one or more `spark:executive` metrics
       *   are listed as metric overrides, other `SPARK` metrics are not
       *   collected. The collection of the metrics for other enabled custom
       *   metric sources is unaffected. For example, if both `SPARK` andd `YARN`
       *   metric sources are enabled, and overrides are provided for Spark
       *   metrics only, all YARN metrics are collected.
       * </pre>
       *
       * <code>repeated string metric_overrides = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the metricOverrides at the given index.
       */
      public com.google.protobuf.ByteString getMetricOverridesBytes(int index) {
        return metricOverrides_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * Optional. Specify one or more [Custom metrics]
       * (https://cloud.google.com/dataproc/docs/guides/dataproc-metrics#custom_metrics)
       * to collect for the metric course (for the `SPARK` metric source (any
       * [Spark metric]
       * (https://spark.apache.org/docs/latest/monitoring.html#metrics) can be
       * specified).
       *
       * Provide metrics in the following format:
       * &lt;code&gt;&lt;var&gt;METRIC_SOURCE&lt;/var&gt;:&lt;var&gt;INSTANCE&lt;/var&gt;:&lt;var&gt;GROUP&lt;/var&gt;:&lt;var&gt;METRIC&lt;/var&gt;&lt;/code&gt;
       * Use camelcase as appropriate.
       *
       * Examples:
       *
       * ```
       * yarn:ResourceManager:QueueMetrics:AppsCompleted
       * spark:driver:DAGScheduler:job.allJobs
       * sparkHistoryServer:JVM:Memory:NonHeapMemoryUsage.committed
       * hiveserver2:JVM:Memory:NonHeapMemoryUsage.used
       * ```
       *
       * Notes:
       *
       * * Only the specified overridden metrics are collected for the
       *   metric source. For example, if one or more `spark:executive` metrics
       *   are listed as metric overrides, other `SPARK` metrics are not
       *   collected. The collection of the metrics for other enabled custom
       *   metric sources is unaffected. For example, if both `SPARK` andd `YARN`
       *   metric sources are enabled, and overrides are provided for Spark
       *   metrics only, all YARN metrics are collected.
       * </pre>
       *
       * <code>repeated string metric_overrides = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param index The index to set the value at.
       * @param value The metricOverrides to set.
       * @return This builder for chaining.
       */
      public Builder setMetricOverrides(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMetricOverridesIsMutable();
        metricOverrides_.set(index, value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Specify one or more [Custom metrics]
       * (https://cloud.google.com/dataproc/docs/guides/dataproc-metrics#custom_metrics)
       * to collect for the metric course (for the `SPARK` metric source (any
       * [Spark metric]
       * (https://spark.apache.org/docs/latest/monitoring.html#metrics) can be
       * specified).
       *
       * Provide metrics in the following format:
       * &lt;code&gt;&lt;var&gt;METRIC_SOURCE&lt;/var&gt;:&lt;var&gt;INSTANCE&lt;/var&gt;:&lt;var&gt;GROUP&lt;/var&gt;:&lt;var&gt;METRIC&lt;/var&gt;&lt;/code&gt;
       * Use camelcase as appropriate.
       *
       * Examples:
       *
       * ```
       * yarn:ResourceManager:QueueMetrics:AppsCompleted
       * spark:driver:DAGScheduler:job.allJobs
       * sparkHistoryServer:JVM:Memory:NonHeapMemoryUsage.committed
       * hiveserver2:JVM:Memory:NonHeapMemoryUsage.used
       * ```
       *
       * Notes:
       *
       * * Only the specified overridden metrics are collected for the
       *   metric source. For example, if one or more `spark:executive` metrics
       *   are listed as metric overrides, other `SPARK` metrics are not
       *   collected. The collection of the metrics for other enabled custom
       *   metric sources is unaffected. For example, if both `SPARK` andd `YARN`
       *   metric sources are enabled, and overrides are provided for Spark
       *   metrics only, all YARN metrics are collected.
       * </pre>
       *
       * <code>repeated string metric_overrides = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param value The metricOverrides to add.
       * @return This builder for chaining.
       */
      public Builder addMetricOverrides(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMetricOverridesIsMutable();
        metricOverrides_.add(value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Specify one or more [Custom metrics]
       * (https://cloud.google.com/dataproc/docs/guides/dataproc-metrics#custom_metrics)
       * to collect for the metric course (for the `SPARK` metric source (any
       * [Spark metric]
       * (https://spark.apache.org/docs/latest/monitoring.html#metrics) can be
       * specified).
       *
       * Provide metrics in the following format:
       * &lt;code&gt;&lt;var&gt;METRIC_SOURCE&lt;/var&gt;:&lt;var&gt;INSTANCE&lt;/var&gt;:&lt;var&gt;GROUP&lt;/var&gt;:&lt;var&gt;METRIC&lt;/var&gt;&lt;/code&gt;
       * Use camelcase as appropriate.
       *
       * Examples:
       *
       * ```
       * yarn:ResourceManager:QueueMetrics:AppsCompleted
       * spark:driver:DAGScheduler:job.allJobs
       * sparkHistoryServer:JVM:Memory:NonHeapMemoryUsage.committed
       * hiveserver2:JVM:Memory:NonHeapMemoryUsage.used
       * ```
       *
       * Notes:
       *
       * * Only the specified overridden metrics are collected for the
       *   metric source. For example, if one or more `spark:executive` metrics
       *   are listed as metric overrides, other `SPARK` metrics are not
       *   collected. The collection of the metrics for other enabled custom
       *   metric sources is unaffected. For example, if both `SPARK` andd `YARN`
       *   metric sources are enabled, and overrides are provided for Spark
       *   metrics only, all YARN metrics are collected.
       * </pre>
       *
       * <code>repeated string metric_overrides = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param values The metricOverrides to add.
       * @return This builder for chaining.
       */
      public Builder addAllMetricOverrides(java.lang.Iterable<java.lang.String> values) {
        ensureMetricOverridesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, metricOverrides_);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Specify one or more [Custom metrics]
       * (https://cloud.google.com/dataproc/docs/guides/dataproc-metrics#custom_metrics)
       * to collect for the metric course (for the `SPARK` metric source (any
       * [Spark metric]
       * (https://spark.apache.org/docs/latest/monitoring.html#metrics) can be
       * specified).
       *
       * Provide metrics in the following format:
       * &lt;code&gt;&lt;var&gt;METRIC_SOURCE&lt;/var&gt;:&lt;var&gt;INSTANCE&lt;/var&gt;:&lt;var&gt;GROUP&lt;/var&gt;:&lt;var&gt;METRIC&lt;/var&gt;&lt;/code&gt;
       * Use camelcase as appropriate.
       *
       * Examples:
       *
       * ```
       * yarn:ResourceManager:QueueMetrics:AppsCompleted
       * spark:driver:DAGScheduler:job.allJobs
       * sparkHistoryServer:JVM:Memory:NonHeapMemoryUsage.committed
       * hiveserver2:JVM:Memory:NonHeapMemoryUsage.used
       * ```
       *
       * Notes:
       *
       * * Only the specified overridden metrics are collected for the
       *   metric source. For example, if one or more `spark:executive` metrics
       *   are listed as metric overrides, other `SPARK` metrics are not
       *   collected. The collection of the metrics for other enabled custom
       *   metric sources is unaffected. For example, if both `SPARK` andd `YARN`
       *   metric sources are enabled, and overrides are provided for Spark
       *   metrics only, all YARN metrics are collected.
       * </pre>
       *
       * <code>repeated string metric_overrides = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMetricOverrides() {
        metricOverrides_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        ;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Specify one or more [Custom metrics]
       * (https://cloud.google.com/dataproc/docs/guides/dataproc-metrics#custom_metrics)
       * to collect for the metric course (for the `SPARK` metric source (any
       * [Spark metric]
       * (https://spark.apache.org/docs/latest/monitoring.html#metrics) can be
       * specified).
       *
       * Provide metrics in the following format:
       * &lt;code&gt;&lt;var&gt;METRIC_SOURCE&lt;/var&gt;:&lt;var&gt;INSTANCE&lt;/var&gt;:&lt;var&gt;GROUP&lt;/var&gt;:&lt;var&gt;METRIC&lt;/var&gt;&lt;/code&gt;
       * Use camelcase as appropriate.
       *
       * Examples:
       *
       * ```
       * yarn:ResourceManager:QueueMetrics:AppsCompleted
       * spark:driver:DAGScheduler:job.allJobs
       * sparkHistoryServer:JVM:Memory:NonHeapMemoryUsage.committed
       * hiveserver2:JVM:Memory:NonHeapMemoryUsage.used
       * ```
       *
       * Notes:
       *
       * * Only the specified overridden metrics are collected for the
       *   metric source. For example, if one or more `spark:executive` metrics
       *   are listed as metric overrides, other `SPARK` metrics are not
       *   collected. The collection of the metrics for other enabled custom
       *   metric sources is unaffected. For example, if both `SPARK` andd `YARN`
       *   metric sources are enabled, and overrides are provided for Spark
       *   metrics only, all YARN metrics are collected.
       * </pre>
       *
       * <code>repeated string metric_overrides = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param value The bytes of the metricOverrides to add.
       * @return This builder for chaining.
       */
      public Builder addMetricOverridesBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureMetricOverridesIsMutable();
        metricOverrides_.add(value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dataproc.v1.DataprocMetricConfig.Metric)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dataproc.v1.DataprocMetricConfig.Metric)
    private static final com.google.cloud.dataproc.v1.DataprocMetricConfig.Metric DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.dataproc.v1.DataprocMetricConfig.Metric();
    }

    public static com.google.cloud.dataproc.v1.DataprocMetricConfig.Metric getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Metric> PARSER =
        new com.google.protobuf.AbstractParser<Metric>() {
          @java.lang.Override
          public Metric parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Metric> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Metric> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.DataprocMetricConfig.Metric getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int METRICS_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.dataproc.v1.DataprocMetricConfig.Metric> metrics_;
  /**
   *
   *
   * <pre>
   * Required. Metrics sources to enable.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dataproc.v1.DataprocMetricConfig.Metric metrics = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.dataproc.v1.DataprocMetricConfig.Metric> getMetricsList() {
    return metrics_;
  }
  /**
   *
   *
   * <pre>
   * Required. Metrics sources to enable.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dataproc.v1.DataprocMetricConfig.Metric metrics = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.dataproc.v1.DataprocMetricConfig.MetricOrBuilder>
      getMetricsOrBuilderList() {
    return metrics_;
  }
  /**
   *
   *
   * <pre>
   * Required. Metrics sources to enable.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dataproc.v1.DataprocMetricConfig.Metric metrics = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public int getMetricsCount() {
    return metrics_.size();
  }
  /**
   *
   *
   * <pre>
   * Required. Metrics sources to enable.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dataproc.v1.DataprocMetricConfig.Metric metrics = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.DataprocMetricConfig.Metric getMetrics(int index) {
    return metrics_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Required. Metrics sources to enable.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dataproc.v1.DataprocMetricConfig.Metric metrics = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.DataprocMetricConfig.MetricOrBuilder getMetricsOrBuilder(
      int index) {
    return metrics_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < metrics_.size(); i++) {
      output.writeMessage(1, metrics_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < metrics_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, metrics_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dataproc.v1.DataprocMetricConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.dataproc.v1.DataprocMetricConfig other =
        (com.google.cloud.dataproc.v1.DataprocMetricConfig) obj;

    if (!getMetricsList().equals(other.getMetricsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getMetricsCount() > 0) {
      hash = (37 * hash) + METRICS_FIELD_NUMBER;
      hash = (53 * hash) + getMetricsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dataproc.v1.DataprocMetricConfig parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1.DataprocMetricConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.DataprocMetricConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1.DataprocMetricConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.DataprocMetricConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1.DataprocMetricConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.DataprocMetricConfig parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1.DataprocMetricConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.DataprocMetricConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1.DataprocMetricConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.DataprocMetricConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1.DataprocMetricConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.dataproc.v1.DataprocMetricConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Dataproc metric config.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dataproc.v1.DataprocMetricConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dataproc.v1.DataprocMetricConfig)
      com.google.cloud.dataproc.v1.DataprocMetricConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dataproc.v1.ClustersProto
          .internal_static_google_cloud_dataproc_v1_DataprocMetricConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dataproc.v1.ClustersProto
          .internal_static_google_cloud_dataproc_v1_DataprocMetricConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dataproc.v1.DataprocMetricConfig.class,
              com.google.cloud.dataproc.v1.DataprocMetricConfig.Builder.class);
    }

    // Construct using com.google.cloud.dataproc.v1.DataprocMetricConfig.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (metricsBuilder_ == null) {
        metrics_ = java.util.Collections.emptyList();
      } else {
        metrics_ = null;
        metricsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dataproc.v1.ClustersProto
          .internal_static_google_cloud_dataproc_v1_DataprocMetricConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.DataprocMetricConfig getDefaultInstanceForType() {
      return com.google.cloud.dataproc.v1.DataprocMetricConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.DataprocMetricConfig build() {
      com.google.cloud.dataproc.v1.DataprocMetricConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.DataprocMetricConfig buildPartial() {
      com.google.cloud.dataproc.v1.DataprocMetricConfig result =
          new com.google.cloud.dataproc.v1.DataprocMetricConfig(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.dataproc.v1.DataprocMetricConfig result) {
      if (metricsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          metrics_ = java.util.Collections.unmodifiableList(metrics_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.metrics_ = metrics_;
      } else {
        result.metrics_ = metricsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.dataproc.v1.DataprocMetricConfig result) {
      int from_bitField0_ = bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dataproc.v1.DataprocMetricConfig) {
        return mergeFrom((com.google.cloud.dataproc.v1.DataprocMetricConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dataproc.v1.DataprocMetricConfig other) {
      if (other == com.google.cloud.dataproc.v1.DataprocMetricConfig.getDefaultInstance())
        return this;
      if (metricsBuilder_ == null) {
        if (!other.metrics_.isEmpty()) {
          if (metrics_.isEmpty()) {
            metrics_ = other.metrics_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureMetricsIsMutable();
            metrics_.addAll(other.metrics_);
          }
          onChanged();
        }
      } else {
        if (!other.metrics_.isEmpty()) {
          if (metricsBuilder_.isEmpty()) {
            metricsBuilder_.dispose();
            metricsBuilder_ = null;
            metrics_ = other.metrics_;
            bitField0_ = (bitField0_ & ~0x00000001);
            metricsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getMetricsFieldBuilder()
                    : null;
          } else {
            metricsBuilder_.addAllMessages(other.metrics_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.cloud.dataproc.v1.DataprocMetricConfig.Metric m =
                    input.readMessage(
                        com.google.cloud.dataproc.v1.DataprocMetricConfig.Metric.parser(),
                        extensionRegistry);
                if (metricsBuilder_ == null) {
                  ensureMetricsIsMutable();
                  metrics_.add(m);
                } else {
                  metricsBuilder_.addMessage(m);
                }
                break;
              } // case 10
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.cloud.dataproc.v1.DataprocMetricConfig.Metric> metrics_ =
        java.util.Collections.emptyList();

    private void ensureMetricsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        metrics_ =
            new java.util.ArrayList<com.google.cloud.dataproc.v1.DataprocMetricConfig.Metric>(
                metrics_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dataproc.v1.DataprocMetricConfig.Metric,
            com.google.cloud.dataproc.v1.DataprocMetricConfig.Metric.Builder,
            com.google.cloud.dataproc.v1.DataprocMetricConfig.MetricOrBuilder>
        metricsBuilder_;

    /**
     *
     *
     * <pre>
     * Required. Metrics sources to enable.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.DataprocMetricConfig.Metric metrics = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<com.google.cloud.dataproc.v1.DataprocMetricConfig.Metric>
        getMetricsList() {
      if (metricsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(metrics_);
      } else {
        return metricsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Metrics sources to enable.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.DataprocMetricConfig.Metric metrics = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public int getMetricsCount() {
      if (metricsBuilder_ == null) {
        return metrics_.size();
      } else {
        return metricsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Metrics sources to enable.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.DataprocMetricConfig.Metric metrics = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.dataproc.v1.DataprocMetricConfig.Metric getMetrics(int index) {
      if (metricsBuilder_ == null) {
        return metrics_.get(index);
      } else {
        return metricsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Metrics sources to enable.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.DataprocMetricConfig.Metric metrics = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setMetrics(
        int index, com.google.cloud.dataproc.v1.DataprocMetricConfig.Metric value) {
      if (metricsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMetricsIsMutable();
        metrics_.set(index, value);
        onChanged();
      } else {
        metricsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Metrics sources to enable.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.DataprocMetricConfig.Metric metrics = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setMetrics(
        int index,
        com.google.cloud.dataproc.v1.DataprocMetricConfig.Metric.Builder builderForValue) {
      if (metricsBuilder_ == null) {
        ensureMetricsIsMutable();
        metrics_.set(index, builderForValue.build());
        onChanged();
      } else {
        metricsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Metrics sources to enable.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.DataprocMetricConfig.Metric metrics = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addMetrics(com.google.cloud.dataproc.v1.DataprocMetricConfig.Metric value) {
      if (metricsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMetricsIsMutable();
        metrics_.add(value);
        onChanged();
      } else {
        metricsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Metrics sources to enable.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.DataprocMetricConfig.Metric metrics = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addMetrics(
        int index, com.google.cloud.dataproc.v1.DataprocMetricConfig.Metric value) {
      if (metricsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMetricsIsMutable();
        metrics_.add(index, value);
        onChanged();
      } else {
        metricsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Metrics sources to enable.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.DataprocMetricConfig.Metric metrics = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addMetrics(
        com.google.cloud.dataproc.v1.DataprocMetricConfig.Metric.Builder builderForValue) {
      if (metricsBuilder_ == null) {
        ensureMetricsIsMutable();
        metrics_.add(builderForValue.build());
        onChanged();
      } else {
        metricsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Metrics sources to enable.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.DataprocMetricConfig.Metric metrics = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addMetrics(
        int index,
        com.google.cloud.dataproc.v1.DataprocMetricConfig.Metric.Builder builderForValue) {
      if (metricsBuilder_ == null) {
        ensureMetricsIsMutable();
        metrics_.add(index, builderForValue.build());
        onChanged();
      } else {
        metricsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Metrics sources to enable.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.DataprocMetricConfig.Metric metrics = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addAllMetrics(
        java.lang.Iterable<? extends com.google.cloud.dataproc.v1.DataprocMetricConfig.Metric>
            values) {
      if (metricsBuilder_ == null) {
        ensureMetricsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, metrics_);
        onChanged();
      } else {
        metricsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Metrics sources to enable.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.DataprocMetricConfig.Metric metrics = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearMetrics() {
      if (metricsBuilder_ == null) {
        metrics_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        metricsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Metrics sources to enable.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.DataprocMetricConfig.Metric metrics = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder removeMetrics(int index) {
      if (metricsBuilder_ == null) {
        ensureMetricsIsMutable();
        metrics_.remove(index);
        onChanged();
      } else {
        metricsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Metrics sources to enable.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.DataprocMetricConfig.Metric metrics = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.dataproc.v1.DataprocMetricConfig.Metric.Builder getMetricsBuilder(
        int index) {
      return getMetricsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Required. Metrics sources to enable.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.DataprocMetricConfig.Metric metrics = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.dataproc.v1.DataprocMetricConfig.MetricOrBuilder getMetricsOrBuilder(
        int index) {
      if (metricsBuilder_ == null) {
        return metrics_.get(index);
      } else {
        return metricsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Metrics sources to enable.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.DataprocMetricConfig.Metric metrics = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.dataproc.v1.DataprocMetricConfig.MetricOrBuilder>
        getMetricsOrBuilderList() {
      if (metricsBuilder_ != null) {
        return metricsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(metrics_);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Metrics sources to enable.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.DataprocMetricConfig.Metric metrics = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.dataproc.v1.DataprocMetricConfig.Metric.Builder addMetricsBuilder() {
      return getMetricsFieldBuilder()
          .addBuilder(
              com.google.cloud.dataproc.v1.DataprocMetricConfig.Metric.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Required. Metrics sources to enable.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.DataprocMetricConfig.Metric metrics = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.dataproc.v1.DataprocMetricConfig.Metric.Builder addMetricsBuilder(
        int index) {
      return getMetricsFieldBuilder()
          .addBuilder(
              index, com.google.cloud.dataproc.v1.DataprocMetricConfig.Metric.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Required. Metrics sources to enable.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.DataprocMetricConfig.Metric metrics = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<com.google.cloud.dataproc.v1.DataprocMetricConfig.Metric.Builder>
        getMetricsBuilderList() {
      return getMetricsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dataproc.v1.DataprocMetricConfig.Metric,
            com.google.cloud.dataproc.v1.DataprocMetricConfig.Metric.Builder,
            com.google.cloud.dataproc.v1.DataprocMetricConfig.MetricOrBuilder>
        getMetricsFieldBuilder() {
      if (metricsBuilder_ == null) {
        metricsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.dataproc.v1.DataprocMetricConfig.Metric,
                com.google.cloud.dataproc.v1.DataprocMetricConfig.Metric.Builder,
                com.google.cloud.dataproc.v1.DataprocMetricConfig.MetricOrBuilder>(
                metrics_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        metrics_ = null;
      }
      return metricsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dataproc.v1.DataprocMetricConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dataproc.v1.DataprocMetricConfig)
  private static final com.google.cloud.dataproc.v1.DataprocMetricConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dataproc.v1.DataprocMetricConfig();
  }

  public static com.google.cloud.dataproc.v1.DataprocMetricConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<DataprocMetricConfig> PARSER =
      new com.google.protobuf.AbstractParser<DataprocMetricConfig>() {
        @java.lang.Override
        public DataprocMetricConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<DataprocMetricConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<DataprocMetricConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dataproc.v1.DataprocMetricConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
