/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dataproc/v1/clusters.proto

package com.google.cloud.dataproc.v1;

/**
 *
 *
 * <pre>
 * A request to collect cluster diagnostic information.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dataproc.v1.DiagnoseClusterRequest}
 */
public final class DiagnoseClusterRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dataproc.v1.DiagnoseClusterRequest)
    DiagnoseClusterRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use DiagnoseClusterRequest.newBuilder() to construct.
  private DiagnoseClusterRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private DiagnoseClusterRequest() {
    projectId_ = "";
    region_ = "";
    clusterName_ = "";
    tarballGcsDir_ = "";
    jobs_ = com.google.protobuf.LazyStringArrayList.emptyList();
    yarnApplicationIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new DiagnoseClusterRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dataproc.v1.ClustersProto
        .internal_static_google_cloud_dataproc_v1_DiagnoseClusterRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dataproc.v1.ClustersProto
        .internal_static_google_cloud_dataproc_v1_DiagnoseClusterRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dataproc.v1.DiagnoseClusterRequest.class,
            com.google.cloud.dataproc.v1.DiagnoseClusterRequest.Builder.class);
  }

  public static final int PROJECT_ID_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object projectId_ = "";
  /**
   *
   *
   * <pre>
   * Required. The ID of the Google Cloud Platform project that the cluster
   * belongs to.
   * </pre>
   *
   * <code>string project_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The projectId.
   */
  @java.lang.Override
  public java.lang.String getProjectId() {
    java.lang.Object ref = projectId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      projectId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The ID of the Google Cloud Platform project that the cluster
   * belongs to.
   * </pre>
   *
   * <code>string project_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for projectId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getProjectIdBytes() {
    java.lang.Object ref = projectId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      projectId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int REGION_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object region_ = "";
  /**
   *
   *
   * <pre>
   * Required. The Dataproc region in which to handle the request.
   * </pre>
   *
   * <code>string region = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The region.
   */
  @java.lang.Override
  public java.lang.String getRegion() {
    java.lang.Object ref = region_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      region_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The Dataproc region in which to handle the request.
   * </pre>
   *
   * <code>string region = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for region.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRegionBytes() {
    java.lang.Object ref = region_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      region_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CLUSTER_NAME_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object clusterName_ = "";
  /**
   *
   *
   * <pre>
   * Required. The cluster name.
   * </pre>
   *
   * <code>string cluster_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The clusterName.
   */
  @java.lang.Override
  public java.lang.String getClusterName() {
    java.lang.Object ref = clusterName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      clusterName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The cluster name.
   * </pre>
   *
   * <code>string cluster_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for clusterName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getClusterNameBytes() {
    java.lang.Object ref = clusterName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      clusterName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TARBALL_GCS_DIR_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object tarballGcsDir_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The output Cloud Storage directory for the diagnostic
   * tarball. If not specified, a task-specific directory in the cluster's
   * staging bucket will be used.
   * </pre>
   *
   * <code>string tarball_gcs_dir = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The tarballGcsDir.
   */
  @java.lang.Override
  public java.lang.String getTarballGcsDir() {
    java.lang.Object ref = tarballGcsDir_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      tarballGcsDir_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The output Cloud Storage directory for the diagnostic
   * tarball. If not specified, a task-specific directory in the cluster's
   * staging bucket will be used.
   * </pre>
   *
   * <code>string tarball_gcs_dir = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for tarballGcsDir.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTarballGcsDirBytes() {
    java.lang.Object ref = tarballGcsDir_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      tarballGcsDir_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DIAGNOSIS_INTERVAL_FIELD_NUMBER = 6;
  private com.google.type.Interval diagnosisInterval_;
  /**
   *
   *
   * <pre>
   * Optional. Time interval in which diagnosis should be carried out on the
   * cluster.
   * </pre>
   *
   * <code>.google.type.Interval diagnosis_interval = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the diagnosisInterval field is set.
   */
  @java.lang.Override
  public boolean hasDiagnosisInterval() {
    return diagnosisInterval_ != null;
  }
  /**
   *
   *
   * <pre>
   * Optional. Time interval in which diagnosis should be carried out on the
   * cluster.
   * </pre>
   *
   * <code>.google.type.Interval diagnosis_interval = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The diagnosisInterval.
   */
  @java.lang.Override
  public com.google.type.Interval getDiagnosisInterval() {
    return diagnosisInterval_ == null
        ? com.google.type.Interval.getDefaultInstance()
        : diagnosisInterval_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Time interval in which diagnosis should be carried out on the
   * cluster.
   * </pre>
   *
   * <code>.google.type.Interval diagnosis_interval = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.type.IntervalOrBuilder getDiagnosisIntervalOrBuilder() {
    return diagnosisInterval_ == null
        ? com.google.type.Interval.getDefaultInstance()
        : diagnosisInterval_;
  }

  public static final int JOBS_FIELD_NUMBER = 10;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList jobs_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Optional. Specifies a list of jobs on which diagnosis is to be performed.
   * Format: projects/{project}/regions/{region}/jobs/{job}
   * </pre>
   *
   * <code>repeated string jobs = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return A list containing the jobs.
   */
  public com.google.protobuf.ProtocolStringList getJobsList() {
    return jobs_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Specifies a list of jobs on which diagnosis is to be performed.
   * Format: projects/{project}/regions/{region}/jobs/{job}
   * </pre>
   *
   * <code>repeated string jobs = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The count of jobs.
   */
  public int getJobsCount() {
    return jobs_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. Specifies a list of jobs on which diagnosis is to be performed.
   * Format: projects/{project}/regions/{region}/jobs/{job}
   * </pre>
   *
   * <code>repeated string jobs = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the element to return.
   * @return The jobs at the given index.
   */
  public java.lang.String getJobs(int index) {
    return jobs_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. Specifies a list of jobs on which diagnosis is to be performed.
   * Format: projects/{project}/regions/{region}/jobs/{job}
   * </pre>
   *
   * <code>repeated string jobs = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the jobs at the given index.
   */
  public com.google.protobuf.ByteString getJobsBytes(int index) {
    return jobs_.getByteString(index);
  }

  public static final int YARN_APPLICATION_IDS_FIELD_NUMBER = 11;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList yarnApplicationIds_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Optional. Specifies a list of yarn applications on which diagnosis is to be
   * performed.
   * </pre>
   *
   * <code>repeated string yarn_application_ids = 11 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return A list containing the yarnApplicationIds.
   */
  public com.google.protobuf.ProtocolStringList getYarnApplicationIdsList() {
    return yarnApplicationIds_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Specifies a list of yarn applications on which diagnosis is to be
   * performed.
   * </pre>
   *
   * <code>repeated string yarn_application_ids = 11 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The count of yarnApplicationIds.
   */
  public int getYarnApplicationIdsCount() {
    return yarnApplicationIds_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. Specifies a list of yarn applications on which diagnosis is to be
   * performed.
   * </pre>
   *
   * <code>repeated string yarn_application_ids = 11 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @param index The index of the element to return.
   * @return The yarnApplicationIds at the given index.
   */
  public java.lang.String getYarnApplicationIds(int index) {
    return yarnApplicationIds_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. Specifies a list of yarn applications on which diagnosis is to be
   * performed.
   * </pre>
   *
   * <code>repeated string yarn_application_ids = 11 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the yarnApplicationIds at the given index.
   */
  public com.google.protobuf.ByteString getYarnApplicationIdsBytes(int index) {
    return yarnApplicationIds_.getByteString(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(projectId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, projectId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(clusterName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, clusterName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(region_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, region_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(tarballGcsDir_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, tarballGcsDir_);
    }
    if (diagnosisInterval_ != null) {
      output.writeMessage(6, getDiagnosisInterval());
    }
    for (int i = 0; i < jobs_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 10, jobs_.getRaw(i));
    }
    for (int i = 0; i < yarnApplicationIds_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 11, yarnApplicationIds_.getRaw(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(projectId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, projectId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(clusterName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, clusterName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(region_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, region_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(tarballGcsDir_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, tarballGcsDir_);
    }
    if (diagnosisInterval_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getDiagnosisInterval());
    }
    {
      int dataSize = 0;
      for (int i = 0; i < jobs_.size(); i++) {
        dataSize += computeStringSizeNoTag(jobs_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getJobsList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < yarnApplicationIds_.size(); i++) {
        dataSize += computeStringSizeNoTag(yarnApplicationIds_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getYarnApplicationIdsList().size();
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dataproc.v1.DiagnoseClusterRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.dataproc.v1.DiagnoseClusterRequest other =
        (com.google.cloud.dataproc.v1.DiagnoseClusterRequest) obj;

    if (!getProjectId().equals(other.getProjectId())) return false;
    if (!getRegion().equals(other.getRegion())) return false;
    if (!getClusterName().equals(other.getClusterName())) return false;
    if (!getTarballGcsDir().equals(other.getTarballGcsDir())) return false;
    if (hasDiagnosisInterval() != other.hasDiagnosisInterval()) return false;
    if (hasDiagnosisInterval()) {
      if (!getDiagnosisInterval().equals(other.getDiagnosisInterval())) return false;
    }
    if (!getJobsList().equals(other.getJobsList())) return false;
    if (!getYarnApplicationIdsList().equals(other.getYarnApplicationIdsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PROJECT_ID_FIELD_NUMBER;
    hash = (53 * hash) + getProjectId().hashCode();
    hash = (37 * hash) + REGION_FIELD_NUMBER;
    hash = (53 * hash) + getRegion().hashCode();
    hash = (37 * hash) + CLUSTER_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getClusterName().hashCode();
    hash = (37 * hash) + TARBALL_GCS_DIR_FIELD_NUMBER;
    hash = (53 * hash) + getTarballGcsDir().hashCode();
    if (hasDiagnosisInterval()) {
      hash = (37 * hash) + DIAGNOSIS_INTERVAL_FIELD_NUMBER;
      hash = (53 * hash) + getDiagnosisInterval().hashCode();
    }
    if (getJobsCount() > 0) {
      hash = (37 * hash) + JOBS_FIELD_NUMBER;
      hash = (53 * hash) + getJobsList().hashCode();
    }
    if (getYarnApplicationIdsCount() > 0) {
      hash = (37 * hash) + YARN_APPLICATION_IDS_FIELD_NUMBER;
      hash = (53 * hash) + getYarnApplicationIdsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dataproc.v1.DiagnoseClusterRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1.DiagnoseClusterRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.DiagnoseClusterRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1.DiagnoseClusterRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.DiagnoseClusterRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1.DiagnoseClusterRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.DiagnoseClusterRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1.DiagnoseClusterRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.DiagnoseClusterRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1.DiagnoseClusterRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.DiagnoseClusterRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1.DiagnoseClusterRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.dataproc.v1.DiagnoseClusterRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A request to collect cluster diagnostic information.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dataproc.v1.DiagnoseClusterRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dataproc.v1.DiagnoseClusterRequest)
      com.google.cloud.dataproc.v1.DiagnoseClusterRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dataproc.v1.ClustersProto
          .internal_static_google_cloud_dataproc_v1_DiagnoseClusterRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dataproc.v1.ClustersProto
          .internal_static_google_cloud_dataproc_v1_DiagnoseClusterRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dataproc.v1.DiagnoseClusterRequest.class,
              com.google.cloud.dataproc.v1.DiagnoseClusterRequest.Builder.class);
    }

    // Construct using com.google.cloud.dataproc.v1.DiagnoseClusterRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      projectId_ = "";
      region_ = "";
      clusterName_ = "";
      tarballGcsDir_ = "";
      diagnosisInterval_ = null;
      if (diagnosisIntervalBuilder_ != null) {
        diagnosisIntervalBuilder_.dispose();
        diagnosisIntervalBuilder_ = null;
      }
      jobs_ = com.google.protobuf.LazyStringArrayList.emptyList();
      yarnApplicationIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dataproc.v1.ClustersProto
          .internal_static_google_cloud_dataproc_v1_DiagnoseClusterRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.DiagnoseClusterRequest getDefaultInstanceForType() {
      return com.google.cloud.dataproc.v1.DiagnoseClusterRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.DiagnoseClusterRequest build() {
      com.google.cloud.dataproc.v1.DiagnoseClusterRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.DiagnoseClusterRequest buildPartial() {
      com.google.cloud.dataproc.v1.DiagnoseClusterRequest result =
          new com.google.cloud.dataproc.v1.DiagnoseClusterRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.dataproc.v1.DiagnoseClusterRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.projectId_ = projectId_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.region_ = region_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.clusterName_ = clusterName_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.tarballGcsDir_ = tarballGcsDir_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.diagnosisInterval_ =
            diagnosisIntervalBuilder_ == null
                ? diagnosisInterval_
                : diagnosisIntervalBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        jobs_.makeImmutable();
        result.jobs_ = jobs_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        yarnApplicationIds_.makeImmutable();
        result.yarnApplicationIds_ = yarnApplicationIds_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dataproc.v1.DiagnoseClusterRequest) {
        return mergeFrom((com.google.cloud.dataproc.v1.DiagnoseClusterRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dataproc.v1.DiagnoseClusterRequest other) {
      if (other == com.google.cloud.dataproc.v1.DiagnoseClusterRequest.getDefaultInstance())
        return this;
      if (!other.getProjectId().isEmpty()) {
        projectId_ = other.projectId_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getRegion().isEmpty()) {
        region_ = other.region_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getClusterName().isEmpty()) {
        clusterName_ = other.clusterName_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getTarballGcsDir().isEmpty()) {
        tarballGcsDir_ = other.tarballGcsDir_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.hasDiagnosisInterval()) {
        mergeDiagnosisInterval(other.getDiagnosisInterval());
      }
      if (!other.jobs_.isEmpty()) {
        if (jobs_.isEmpty()) {
          jobs_ = other.jobs_;
          bitField0_ |= 0x00000020;
        } else {
          ensureJobsIsMutable();
          jobs_.addAll(other.jobs_);
        }
        onChanged();
      }
      if (!other.yarnApplicationIds_.isEmpty()) {
        if (yarnApplicationIds_.isEmpty()) {
          yarnApplicationIds_ = other.yarnApplicationIds_;
          bitField0_ |= 0x00000040;
        } else {
          ensureYarnApplicationIdsIsMutable();
          yarnApplicationIds_.addAll(other.yarnApplicationIds_);
        }
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                projectId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                clusterName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 18
            case 26:
              {
                region_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 26
            case 34:
              {
                tarballGcsDir_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 50:
              {
                input.readMessage(
                    getDiagnosisIntervalFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 50
            case 82:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureJobsIsMutable();
                jobs_.add(s);
                break;
              } // case 82
            case 90:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureYarnApplicationIdsIsMutable();
                yarnApplicationIds_.add(s);
                break;
              } // case 90
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object projectId_ = "";
    /**
     *
     *
     * <pre>
     * Required. The ID of the Google Cloud Platform project that the cluster
     * belongs to.
     * </pre>
     *
     * <code>string project_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The projectId.
     */
    public java.lang.String getProjectId() {
      java.lang.Object ref = projectId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        projectId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The ID of the Google Cloud Platform project that the cluster
     * belongs to.
     * </pre>
     *
     * <code>string project_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for projectId.
     */
    public com.google.protobuf.ByteString getProjectIdBytes() {
      java.lang.Object ref = projectId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        projectId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The ID of the Google Cloud Platform project that the cluster
     * belongs to.
     * </pre>
     *
     * <code>string project_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The projectId to set.
     * @return This builder for chaining.
     */
    public Builder setProjectId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      projectId_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The ID of the Google Cloud Platform project that the cluster
     * belongs to.
     * </pre>
     *
     * <code>string project_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearProjectId() {
      projectId_ = getDefaultInstance().getProjectId();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The ID of the Google Cloud Platform project that the cluster
     * belongs to.
     * </pre>
     *
     * <code>string project_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for projectId to set.
     * @return This builder for chaining.
     */
    public Builder setProjectIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      projectId_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object region_ = "";
    /**
     *
     *
     * <pre>
     * Required. The Dataproc region in which to handle the request.
     * </pre>
     *
     * <code>string region = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The region.
     */
    public java.lang.String getRegion() {
      java.lang.Object ref = region_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        region_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The Dataproc region in which to handle the request.
     * </pre>
     *
     * <code>string region = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for region.
     */
    public com.google.protobuf.ByteString getRegionBytes() {
      java.lang.Object ref = region_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        region_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The Dataproc region in which to handle the request.
     * </pre>
     *
     * <code>string region = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The region to set.
     * @return This builder for chaining.
     */
    public Builder setRegion(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      region_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The Dataproc region in which to handle the request.
     * </pre>
     *
     * <code>string region = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRegion() {
      region_ = getDefaultInstance().getRegion();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The Dataproc region in which to handle the request.
     * </pre>
     *
     * <code>string region = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for region to set.
     * @return This builder for chaining.
     */
    public Builder setRegionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      region_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object clusterName_ = "";
    /**
     *
     *
     * <pre>
     * Required. The cluster name.
     * </pre>
     *
     * <code>string cluster_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The clusterName.
     */
    public java.lang.String getClusterName() {
      java.lang.Object ref = clusterName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        clusterName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The cluster name.
     * </pre>
     *
     * <code>string cluster_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for clusterName.
     */
    public com.google.protobuf.ByteString getClusterNameBytes() {
      java.lang.Object ref = clusterName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        clusterName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The cluster name.
     * </pre>
     *
     * <code>string cluster_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The clusterName to set.
     * @return This builder for chaining.
     */
    public Builder setClusterName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      clusterName_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The cluster name.
     * </pre>
     *
     * <code>string cluster_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearClusterName() {
      clusterName_ = getDefaultInstance().getClusterName();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The cluster name.
     * </pre>
     *
     * <code>string cluster_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for clusterName to set.
     * @return This builder for chaining.
     */
    public Builder setClusterNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      clusterName_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object tarballGcsDir_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The output Cloud Storage directory for the diagnostic
     * tarball. If not specified, a task-specific directory in the cluster's
     * staging bucket will be used.
     * </pre>
     *
     * <code>string tarball_gcs_dir = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The tarballGcsDir.
     */
    public java.lang.String getTarballGcsDir() {
      java.lang.Object ref = tarballGcsDir_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        tarballGcsDir_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The output Cloud Storage directory for the diagnostic
     * tarball. If not specified, a task-specific directory in the cluster's
     * staging bucket will be used.
     * </pre>
     *
     * <code>string tarball_gcs_dir = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for tarballGcsDir.
     */
    public com.google.protobuf.ByteString getTarballGcsDirBytes() {
      java.lang.Object ref = tarballGcsDir_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        tarballGcsDir_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The output Cloud Storage directory for the diagnostic
     * tarball. If not specified, a task-specific directory in the cluster's
     * staging bucket will be used.
     * </pre>
     *
     * <code>string tarball_gcs_dir = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The tarballGcsDir to set.
     * @return This builder for chaining.
     */
    public Builder setTarballGcsDir(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      tarballGcsDir_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The output Cloud Storage directory for the diagnostic
     * tarball. If not specified, a task-specific directory in the cluster's
     * staging bucket will be used.
     * </pre>
     *
     * <code>string tarball_gcs_dir = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTarballGcsDir() {
      tarballGcsDir_ = getDefaultInstance().getTarballGcsDir();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The output Cloud Storage directory for the diagnostic
     * tarball. If not specified, a task-specific directory in the cluster's
     * staging bucket will be used.
     * </pre>
     *
     * <code>string tarball_gcs_dir = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for tarballGcsDir to set.
     * @return This builder for chaining.
     */
    public Builder setTarballGcsDirBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      tarballGcsDir_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private com.google.type.Interval diagnosisInterval_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.type.Interval,
            com.google.type.Interval.Builder,
            com.google.type.IntervalOrBuilder>
        diagnosisIntervalBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Time interval in which diagnosis should be carried out on the
     * cluster.
     * </pre>
     *
     * <code>.google.type.Interval diagnosis_interval = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the diagnosisInterval field is set.
     */
    public boolean hasDiagnosisInterval() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Time interval in which diagnosis should be carried out on the
     * cluster.
     * </pre>
     *
     * <code>.google.type.Interval diagnosis_interval = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The diagnosisInterval.
     */
    public com.google.type.Interval getDiagnosisInterval() {
      if (diagnosisIntervalBuilder_ == null) {
        return diagnosisInterval_ == null
            ? com.google.type.Interval.getDefaultInstance()
            : diagnosisInterval_;
      } else {
        return diagnosisIntervalBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Time interval in which diagnosis should be carried out on the
     * cluster.
     * </pre>
     *
     * <code>.google.type.Interval diagnosis_interval = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setDiagnosisInterval(com.google.type.Interval value) {
      if (diagnosisIntervalBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        diagnosisInterval_ = value;
      } else {
        diagnosisIntervalBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Time interval in which diagnosis should be carried out on the
     * cluster.
     * </pre>
     *
     * <code>.google.type.Interval diagnosis_interval = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setDiagnosisInterval(com.google.type.Interval.Builder builderForValue) {
      if (diagnosisIntervalBuilder_ == null) {
        diagnosisInterval_ = builderForValue.build();
      } else {
        diagnosisIntervalBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Time interval in which diagnosis should be carried out on the
     * cluster.
     * </pre>
     *
     * <code>.google.type.Interval diagnosis_interval = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeDiagnosisInterval(com.google.type.Interval value) {
      if (diagnosisIntervalBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && diagnosisInterval_ != null
            && diagnosisInterval_ != com.google.type.Interval.getDefaultInstance()) {
          getDiagnosisIntervalBuilder().mergeFrom(value);
        } else {
          diagnosisInterval_ = value;
        }
      } else {
        diagnosisIntervalBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Time interval in which diagnosis should be carried out on the
     * cluster.
     * </pre>
     *
     * <code>.google.type.Interval diagnosis_interval = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearDiagnosisInterval() {
      bitField0_ = (bitField0_ & ~0x00000010);
      diagnosisInterval_ = null;
      if (diagnosisIntervalBuilder_ != null) {
        diagnosisIntervalBuilder_.dispose();
        diagnosisIntervalBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Time interval in which diagnosis should be carried out on the
     * cluster.
     * </pre>
     *
     * <code>.google.type.Interval diagnosis_interval = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.type.Interval.Builder getDiagnosisIntervalBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getDiagnosisIntervalFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Time interval in which diagnosis should be carried out on the
     * cluster.
     * </pre>
     *
     * <code>.google.type.Interval diagnosis_interval = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.type.IntervalOrBuilder getDiagnosisIntervalOrBuilder() {
      if (diagnosisIntervalBuilder_ != null) {
        return diagnosisIntervalBuilder_.getMessageOrBuilder();
      } else {
        return diagnosisInterval_ == null
            ? com.google.type.Interval.getDefaultInstance()
            : diagnosisInterval_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Time interval in which diagnosis should be carried out on the
     * cluster.
     * </pre>
     *
     * <code>.google.type.Interval diagnosis_interval = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.type.Interval,
            com.google.type.Interval.Builder,
            com.google.type.IntervalOrBuilder>
        getDiagnosisIntervalFieldBuilder() {
      if (diagnosisIntervalBuilder_ == null) {
        diagnosisIntervalBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.type.Interval,
                com.google.type.Interval.Builder,
                com.google.type.IntervalOrBuilder>(
                getDiagnosisInterval(), getParentForChildren(), isClean());
        diagnosisInterval_ = null;
      }
      return diagnosisIntervalBuilder_;
    }

    private com.google.protobuf.LazyStringArrayList jobs_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureJobsIsMutable() {
      if (!jobs_.isModifiable()) {
        jobs_ = new com.google.protobuf.LazyStringArrayList(jobs_);
      }
      bitField0_ |= 0x00000020;
    }
    /**
     *
     *
     * <pre>
     * Optional. Specifies a list of jobs on which diagnosis is to be performed.
     * Format: projects/{project}/regions/{region}/jobs/{job}
     * </pre>
     *
     * <code>repeated string jobs = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return A list containing the jobs.
     */
    public com.google.protobuf.ProtocolStringList getJobsList() {
      jobs_.makeImmutable();
      return jobs_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Specifies a list of jobs on which diagnosis is to be performed.
     * Format: projects/{project}/regions/{region}/jobs/{job}
     * </pre>
     *
     * <code>repeated string jobs = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The count of jobs.
     */
    public int getJobsCount() {
      return jobs_.size();
    }
    /**
     *
     *
     * <pre>
     * Optional. Specifies a list of jobs on which diagnosis is to be performed.
     * Format: projects/{project}/regions/{region}/jobs/{job}
     * </pre>
     *
     * <code>repeated string jobs = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the element to return.
     * @return The jobs at the given index.
     */
    public java.lang.String getJobs(int index) {
      return jobs_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. Specifies a list of jobs on which diagnosis is to be performed.
     * Format: projects/{project}/regions/{region}/jobs/{job}
     * </pre>
     *
     * <code>repeated string jobs = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the jobs at the given index.
     */
    public com.google.protobuf.ByteString getJobsBytes(int index) {
      return jobs_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. Specifies a list of jobs on which diagnosis is to be performed.
     * Format: projects/{project}/regions/{region}/jobs/{job}
     * </pre>
     *
     * <code>repeated string jobs = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index to set the value at.
     * @param value The jobs to set.
     * @return This builder for chaining.
     */
    public Builder setJobs(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureJobsIsMutable();
      jobs_.set(index, value);
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Specifies a list of jobs on which diagnosis is to be performed.
     * Format: projects/{project}/regions/{region}/jobs/{job}
     * </pre>
     *
     * <code>repeated string jobs = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The jobs to add.
     * @return This builder for chaining.
     */
    public Builder addJobs(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureJobsIsMutable();
      jobs_.add(value);
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Specifies a list of jobs on which diagnosis is to be performed.
     * Format: projects/{project}/regions/{region}/jobs/{job}
     * </pre>
     *
     * <code>repeated string jobs = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param values The jobs to add.
     * @return This builder for chaining.
     */
    public Builder addAllJobs(java.lang.Iterable<java.lang.String> values) {
      ensureJobsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, jobs_);
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Specifies a list of jobs on which diagnosis is to be performed.
     * Format: projects/{project}/regions/{region}/jobs/{job}
     * </pre>
     *
     * <code>repeated string jobs = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearJobs() {
      jobs_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000020);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Specifies a list of jobs on which diagnosis is to be performed.
     * Format: projects/{project}/regions/{region}/jobs/{job}
     * </pre>
     *
     * <code>repeated string jobs = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes of the jobs to add.
     * @return This builder for chaining.
     */
    public Builder addJobsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureJobsIsMutable();
      jobs_.add(value);
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList yarnApplicationIds_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureYarnApplicationIdsIsMutable() {
      if (!yarnApplicationIds_.isModifiable()) {
        yarnApplicationIds_ = new com.google.protobuf.LazyStringArrayList(yarnApplicationIds_);
      }
      bitField0_ |= 0x00000040;
    }
    /**
     *
     *
     * <pre>
     * Optional. Specifies a list of yarn applications on which diagnosis is to be
     * performed.
     * </pre>
     *
     * <code>repeated string yarn_application_ids = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return A list containing the yarnApplicationIds.
     */
    public com.google.protobuf.ProtocolStringList getYarnApplicationIdsList() {
      yarnApplicationIds_.makeImmutable();
      return yarnApplicationIds_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Specifies a list of yarn applications on which diagnosis is to be
     * performed.
     * </pre>
     *
     * <code>repeated string yarn_application_ids = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The count of yarnApplicationIds.
     */
    public int getYarnApplicationIdsCount() {
      return yarnApplicationIds_.size();
    }
    /**
     *
     *
     * <pre>
     * Optional. Specifies a list of yarn applications on which diagnosis is to be
     * performed.
     * </pre>
     *
     * <code>repeated string yarn_application_ids = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index of the element to return.
     * @return The yarnApplicationIds at the given index.
     */
    public java.lang.String getYarnApplicationIds(int index) {
      return yarnApplicationIds_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. Specifies a list of yarn applications on which diagnosis is to be
     * performed.
     * </pre>
     *
     * <code>repeated string yarn_application_ids = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the yarnApplicationIds at the given index.
     */
    public com.google.protobuf.ByteString getYarnApplicationIdsBytes(int index) {
      return yarnApplicationIds_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. Specifies a list of yarn applications on which diagnosis is to be
     * performed.
     * </pre>
     *
     * <code>repeated string yarn_application_ids = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The yarnApplicationIds to set.
     * @return This builder for chaining.
     */
    public Builder setYarnApplicationIds(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureYarnApplicationIdsIsMutable();
      yarnApplicationIds_.set(index, value);
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Specifies a list of yarn applications on which diagnosis is to be
     * performed.
     * </pre>
     *
     * <code>repeated string yarn_application_ids = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The yarnApplicationIds to add.
     * @return This builder for chaining.
     */
    public Builder addYarnApplicationIds(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureYarnApplicationIdsIsMutable();
      yarnApplicationIds_.add(value);
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Specifies a list of yarn applications on which diagnosis is to be
     * performed.
     * </pre>
     *
     * <code>repeated string yarn_application_ids = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param values The yarnApplicationIds to add.
     * @return This builder for chaining.
     */
    public Builder addAllYarnApplicationIds(java.lang.Iterable<java.lang.String> values) {
      ensureYarnApplicationIdsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, yarnApplicationIds_);
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Specifies a list of yarn applications on which diagnosis is to be
     * performed.
     * </pre>
     *
     * <code>repeated string yarn_application_ids = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearYarnApplicationIds() {
      yarnApplicationIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000040);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Specifies a list of yarn applications on which diagnosis is to be
     * performed.
     * </pre>
     *
     * <code>repeated string yarn_application_ids = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The bytes of the yarnApplicationIds to add.
     * @return This builder for chaining.
     */
    public Builder addYarnApplicationIdsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureYarnApplicationIdsIsMutable();
      yarnApplicationIds_.add(value);
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dataproc.v1.DiagnoseClusterRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dataproc.v1.DiagnoseClusterRequest)
  private static final com.google.cloud.dataproc.v1.DiagnoseClusterRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dataproc.v1.DiagnoseClusterRequest();
  }

  public static com.google.cloud.dataproc.v1.DiagnoseClusterRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<DiagnoseClusterRequest> PARSER =
      new com.google.protobuf.AbstractParser<DiagnoseClusterRequest>() {
        @java.lang.Override
        public DiagnoseClusterRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<DiagnoseClusterRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<DiagnoseClusterRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dataproc.v1.DiagnoseClusterRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
