/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dataproc/v1/clusters.proto

package com.google.cloud.dataproc.v1;

/**
 *
 *
 * <pre>
 * Endpoint config for this cluster
 * </pre>
 *
 * Protobuf type {@code google.cloud.dataproc.v1.EndpointConfig}
 */
public final class EndpointConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dataproc.v1.EndpointConfig)
    EndpointConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use EndpointConfig.newBuilder() to construct.
  private EndpointConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private EndpointConfig() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new EndpointConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dataproc.v1.ClustersProto
        .internal_static_google_cloud_dataproc_v1_EndpointConfig_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 1:
        return internalGetHttpPorts();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dataproc.v1.ClustersProto
        .internal_static_google_cloud_dataproc_v1_EndpointConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dataproc.v1.EndpointConfig.class,
            com.google.cloud.dataproc.v1.EndpointConfig.Builder.class);
  }

  public static final int HTTP_PORTS_FIELD_NUMBER = 1;

  private static final class HttpPortsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.dataproc.v1.ClustersProto
                .internal_static_google_cloud_dataproc_v1_EndpointConfig_HttpPortsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> httpPorts_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetHttpPorts() {
    if (httpPorts_ == null) {
      return com.google.protobuf.MapField.emptyMapField(HttpPortsDefaultEntryHolder.defaultEntry);
    }
    return httpPorts_;
  }

  public int getHttpPortsCount() {
    return internalGetHttpPorts().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Output only. The map of port descriptions to URLs. Will only be populated
   * if enable_http_port_access is true.
   * </pre>
   *
   * <code>map&lt;string, string&gt; http_ports = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public boolean containsHttpPorts(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetHttpPorts().getMap().containsKey(key);
  }
  /** Use {@link #getHttpPortsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getHttpPorts() {
    return getHttpPortsMap();
  }
  /**
   *
   *
   * <pre>
   * Output only. The map of port descriptions to URLs. Will only be populated
   * if enable_http_port_access is true.
   * </pre>
   *
   * <code>map&lt;string, string&gt; http_ports = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getHttpPortsMap() {
    return internalGetHttpPorts().getMap();
  }
  /**
   *
   *
   * <pre>
   * Output only. The map of port descriptions to URLs. Will only be populated
   * if enable_http_port_access is true.
   * </pre>
   *
   * <code>map&lt;string, string&gt; http_ports = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getHttpPortsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetHttpPorts().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Output only. The map of port descriptions to URLs. Will only be populated
   * if enable_http_port_access is true.
   * </pre>
   *
   * <code>map&lt;string, string&gt; http_ports = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.lang.String getHttpPortsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetHttpPorts().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int ENABLE_HTTP_PORT_ACCESS_FIELD_NUMBER = 2;
  private boolean enableHttpPortAccess_ = false;
  /**
   *
   *
   * <pre>
   * Optional. If true, enable http access to specific ports on the cluster
   * from external sources. Defaults to false.
   * </pre>
   *
   * <code>bool enable_http_port_access = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The enableHttpPortAccess.
   */
  @java.lang.Override
  public boolean getEnableHttpPortAccess() {
    return enableHttpPortAccess_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetHttpPorts(), HttpPortsDefaultEntryHolder.defaultEntry, 1);
    if (enableHttpPortAccess_ != false) {
      output.writeBool(2, enableHttpPortAccess_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetHttpPorts().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> httpPorts__ =
          HttpPortsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, httpPorts__);
    }
    if (enableHttpPortAccess_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(2, enableHttpPortAccess_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dataproc.v1.EndpointConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.dataproc.v1.EndpointConfig other =
        (com.google.cloud.dataproc.v1.EndpointConfig) obj;

    if (!internalGetHttpPorts().equals(other.internalGetHttpPorts())) return false;
    if (getEnableHttpPortAccess() != other.getEnableHttpPortAccess()) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (!internalGetHttpPorts().getMap().isEmpty()) {
      hash = (37 * hash) + HTTP_PORTS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetHttpPorts().hashCode();
    }
    hash = (37 * hash) + ENABLE_HTTP_PORT_ACCESS_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnableHttpPortAccess());
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dataproc.v1.EndpointConfig parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1.EndpointConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.EndpointConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1.EndpointConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.EndpointConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1.EndpointConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.EndpointConfig parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1.EndpointConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.EndpointConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1.EndpointConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.EndpointConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1.EndpointConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.dataproc.v1.EndpointConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Endpoint config for this cluster
   * </pre>
   *
   * Protobuf type {@code google.cloud.dataproc.v1.EndpointConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dataproc.v1.EndpointConfig)
      com.google.cloud.dataproc.v1.EndpointConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dataproc.v1.ClustersProto
          .internal_static_google_cloud_dataproc_v1_EndpointConfig_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 1:
          return internalGetHttpPorts();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 1:
          return internalGetMutableHttpPorts();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dataproc.v1.ClustersProto
          .internal_static_google_cloud_dataproc_v1_EndpointConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dataproc.v1.EndpointConfig.class,
              com.google.cloud.dataproc.v1.EndpointConfig.Builder.class);
    }

    // Construct using com.google.cloud.dataproc.v1.EndpointConfig.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      internalGetMutableHttpPorts().clear();
      enableHttpPortAccess_ = false;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dataproc.v1.ClustersProto
          .internal_static_google_cloud_dataproc_v1_EndpointConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.EndpointConfig getDefaultInstanceForType() {
      return com.google.cloud.dataproc.v1.EndpointConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.EndpointConfig build() {
      com.google.cloud.dataproc.v1.EndpointConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.EndpointConfig buildPartial() {
      com.google.cloud.dataproc.v1.EndpointConfig result =
          new com.google.cloud.dataproc.v1.EndpointConfig(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.dataproc.v1.EndpointConfig result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.httpPorts_ = internalGetHttpPorts();
        result.httpPorts_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.enableHttpPortAccess_ = enableHttpPortAccess_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dataproc.v1.EndpointConfig) {
        return mergeFrom((com.google.cloud.dataproc.v1.EndpointConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dataproc.v1.EndpointConfig other) {
      if (other == com.google.cloud.dataproc.v1.EndpointConfig.getDefaultInstance()) return this;
      internalGetMutableHttpPorts().mergeFrom(other.internalGetHttpPorts());
      bitField0_ |= 0x00000001;
      if (other.getEnableHttpPortAccess() != false) {
        setEnableHttpPortAccess(other.getEnableHttpPortAccess());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> httpPorts__ =
                    input.readMessage(
                        HttpPortsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableHttpPorts()
                    .getMutableMap()
                    .put(httpPorts__.getKey(), httpPorts__.getValue());
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 16:
              {
                enableHttpPortAccess_ = input.readBool();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> httpPorts_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetHttpPorts() {
      if (httpPorts_ == null) {
        return com.google.protobuf.MapField.emptyMapField(HttpPortsDefaultEntryHolder.defaultEntry);
      }
      return httpPorts_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableHttpPorts() {
      if (httpPorts_ == null) {
        httpPorts_ =
            com.google.protobuf.MapField.newMapField(HttpPortsDefaultEntryHolder.defaultEntry);
      }
      if (!httpPorts_.isMutable()) {
        httpPorts_ = httpPorts_.copy();
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return httpPorts_;
    }

    public int getHttpPortsCount() {
      return internalGetHttpPorts().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Output only. The map of port descriptions to URLs. Will only be populated
     * if enable_http_port_access is true.
     * </pre>
     *
     * <code>map&lt;string, string&gt; http_ports = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public boolean containsHttpPorts(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetHttpPorts().getMap().containsKey(key);
    }
    /** Use {@link #getHttpPortsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getHttpPorts() {
      return getHttpPortsMap();
    }
    /**
     *
     *
     * <pre>
     * Output only. The map of port descriptions to URLs. Will only be populated
     * if enable_http_port_access is true.
     * </pre>
     *
     * <code>map&lt;string, string&gt; http_ports = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getHttpPortsMap() {
      return internalGetHttpPorts().getMap();
    }
    /**
     *
     *
     * <pre>
     * Output only. The map of port descriptions to URLs. Will only be populated
     * if enable_http_port_access is true.
     * </pre>
     *
     * <code>map&lt;string, string&gt; http_ports = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getHttpPortsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetHttpPorts().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Output only. The map of port descriptions to URLs. Will only be populated
     * if enable_http_port_access is true.
     * </pre>
     *
     * <code>map&lt;string, string&gt; http_ports = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public java.lang.String getHttpPortsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetHttpPorts().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearHttpPorts() {
      bitField0_ = (bitField0_ & ~0x00000001);
      internalGetMutableHttpPorts().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The map of port descriptions to URLs. Will only be populated
     * if enable_http_port_access is true.
     * </pre>
     *
     * <code>map&lt;string, string&gt; http_ports = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removeHttpPorts(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableHttpPorts().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableHttpPorts() {
      bitField0_ |= 0x00000001;
      return internalGetMutableHttpPorts().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Output only. The map of port descriptions to URLs. Will only be populated
     * if enable_http_port_access is true.
     * </pre>
     *
     * <code>map&lt;string, string&gt; http_ports = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder putHttpPorts(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableHttpPorts().getMutableMap().put(key, value);
      bitField0_ |= 0x00000001;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The map of port descriptions to URLs. Will only be populated
     * if enable_http_port_access is true.
     * </pre>
     *
     * <code>map&lt;string, string&gt; http_ports = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder putAllHttpPorts(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableHttpPorts().getMutableMap().putAll(values);
      bitField0_ |= 0x00000001;
      return this;
    }

    private boolean enableHttpPortAccess_;
    /**
     *
     *
     * <pre>
     * Optional. If true, enable http access to specific ports on the cluster
     * from external sources. Defaults to false.
     * </pre>
     *
     * <code>bool enable_http_port_access = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The enableHttpPortAccess.
     */
    @java.lang.Override
    public boolean getEnableHttpPortAccess() {
      return enableHttpPortAccess_;
    }
    /**
     *
     *
     * <pre>
     * Optional. If true, enable http access to specific ports on the cluster
     * from external sources. Defaults to false.
     * </pre>
     *
     * <code>bool enable_http_port_access = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The enableHttpPortAccess to set.
     * @return This builder for chaining.
     */
    public Builder setEnableHttpPortAccess(boolean value) {

      enableHttpPortAccess_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. If true, enable http access to specific ports on the cluster
     * from external sources. Defaults to false.
     * </pre>
     *
     * <code>bool enable_http_port_access = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEnableHttpPortAccess() {
      bitField0_ = (bitField0_ & ~0x00000002);
      enableHttpPortAccess_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dataproc.v1.EndpointConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dataproc.v1.EndpointConfig)
  private static final com.google.cloud.dataproc.v1.EndpointConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dataproc.v1.EndpointConfig();
  }

  public static com.google.cloud.dataproc.v1.EndpointConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<EndpointConfig> PARSER =
      new com.google.protobuf.AbstractParser<EndpointConfig>() {
        @java.lang.Override
        public EndpointConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<EndpointConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<EndpointConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dataproc.v1.EndpointConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
