/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dataproc/v1/shared.proto

package com.google.cloud.dataproc.v1;

/**
 *
 *
 * <pre>
 * Execution configuration for a workload.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dataproc.v1.ExecutionConfig}
 */
public final class ExecutionConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dataproc.v1.ExecutionConfig)
    ExecutionConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ExecutionConfig.newBuilder() to construct.
  private ExecutionConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ExecutionConfig() {
    serviceAccount_ = "";
    networkTags_ = com.google.protobuf.LazyStringArrayList.emptyList();
    kmsKey_ = "";
    stagingBucket_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ExecutionConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dataproc.v1.SharedProto
        .internal_static_google_cloud_dataproc_v1_ExecutionConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dataproc.v1.SharedProto
        .internal_static_google_cloud_dataproc_v1_ExecutionConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dataproc.v1.ExecutionConfig.class,
            com.google.cloud.dataproc.v1.ExecutionConfig.Builder.class);
  }

  private int networkCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object network_;

  public enum NetworkCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    NETWORK_URI(4),
    SUBNETWORK_URI(5),
    NETWORK_NOT_SET(0);
    private final int value;

    private NetworkCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static NetworkCase valueOf(int value) {
      return forNumber(value);
    }

    public static NetworkCase forNumber(int value) {
      switch (value) {
        case 4:
          return NETWORK_URI;
        case 5:
          return SUBNETWORK_URI;
        case 0:
          return NETWORK_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public NetworkCase getNetworkCase() {
    return NetworkCase.forNumber(networkCase_);
  }

  public static final int SERVICE_ACCOUNT_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object serviceAccount_ = "";
  /**
   *
   *
   * <pre>
   * Optional. Service account that used to execute workload.
   * </pre>
   *
   * <code>string service_account = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The serviceAccount.
   */
  @java.lang.Override
  public java.lang.String getServiceAccount() {
    java.lang.Object ref = serviceAccount_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      serviceAccount_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. Service account that used to execute workload.
   * </pre>
   *
   * <code>string service_account = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for serviceAccount.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getServiceAccountBytes() {
    java.lang.Object ref = serviceAccount_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      serviceAccount_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NETWORK_URI_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * Optional. Network URI to connect workload to.
   * </pre>
   *
   * <code>string network_uri = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return Whether the networkUri field is set.
   */
  public boolean hasNetworkUri() {
    return networkCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * Optional. Network URI to connect workload to.
   * </pre>
   *
   * <code>string network_uri = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The networkUri.
   */
  public java.lang.String getNetworkUri() {
    java.lang.Object ref = "";
    if (networkCase_ == 4) {
      ref = network_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (networkCase_ == 4) {
        network_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. Network URI to connect workload to.
   * </pre>
   *
   * <code>string network_uri = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for networkUri.
   */
  public com.google.protobuf.ByteString getNetworkUriBytes() {
    java.lang.Object ref = "";
    if (networkCase_ == 4) {
      ref = network_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (networkCase_ == 4) {
        network_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SUBNETWORK_URI_FIELD_NUMBER = 5;
  /**
   *
   *
   * <pre>
   * Optional. Subnetwork URI to connect workload to.
   * </pre>
   *
   * <code>string subnetwork_uri = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return Whether the subnetworkUri field is set.
   */
  public boolean hasSubnetworkUri() {
    return networkCase_ == 5;
  }
  /**
   *
   *
   * <pre>
   * Optional. Subnetwork URI to connect workload to.
   * </pre>
   *
   * <code>string subnetwork_uri = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The subnetworkUri.
   */
  public java.lang.String getSubnetworkUri() {
    java.lang.Object ref = "";
    if (networkCase_ == 5) {
      ref = network_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (networkCase_ == 5) {
        network_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. Subnetwork URI to connect workload to.
   * </pre>
   *
   * <code>string subnetwork_uri = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for subnetworkUri.
   */
  public com.google.protobuf.ByteString getSubnetworkUriBytes() {
    java.lang.Object ref = "";
    if (networkCase_ == 5) {
      ref = network_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (networkCase_ == 5) {
        network_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NETWORK_TAGS_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList networkTags_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Optional. Tags used for network traffic control.
   * </pre>
   *
   * <code>repeated string network_tags = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return A list containing the networkTags.
   */
  public com.google.protobuf.ProtocolStringList getNetworkTagsList() {
    return networkTags_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Tags used for network traffic control.
   * </pre>
   *
   * <code>repeated string network_tags = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The count of networkTags.
   */
  public int getNetworkTagsCount() {
    return networkTags_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. Tags used for network traffic control.
   * </pre>
   *
   * <code>repeated string network_tags = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the element to return.
   * @return The networkTags at the given index.
   */
  public java.lang.String getNetworkTags(int index) {
    return networkTags_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. Tags used for network traffic control.
   * </pre>
   *
   * <code>repeated string network_tags = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the networkTags at the given index.
   */
  public com.google.protobuf.ByteString getNetworkTagsBytes(int index) {
    return networkTags_.getByteString(index);
  }

  public static final int KMS_KEY_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private volatile java.lang.Object kmsKey_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The Cloud KMS key to use for encryption.
   * </pre>
   *
   * <code>string kms_key = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The kmsKey.
   */
  @java.lang.Override
  public java.lang.String getKmsKey() {
    java.lang.Object ref = kmsKey_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      kmsKey_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The Cloud KMS key to use for encryption.
   * </pre>
   *
   * <code>string kms_key = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for kmsKey.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getKmsKeyBytes() {
    java.lang.Object ref = kmsKey_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      kmsKey_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TTL_FIELD_NUMBER = 9;
  private com.google.protobuf.Duration ttl_;
  /**
   *
   *
   * <pre>
   * Optional. The duration after which the workload will be terminated.
   * When the workload passes this ttl, it will be unconditionally killed
   * without waiting for ongoing work to finish.
   * Minimum value is 10 minutes; maximum value is 14 days (see JSON
   * representation of
   * [Duration](https://developers.google.com/protocol-buffers/docs/proto3#json)).
   * If both ttl and idle_ttl are specified, the conditions are treated as
   * and OR: the workload will be terminated when it has been idle for idle_ttl
   * or when the ttl has passed, whichever comes first.
   * If ttl is not specified for a session, it defaults to 24h.
   * </pre>
   *
   * <code>.google.protobuf.Duration ttl = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return Whether the ttl field is set.
   */
  @java.lang.Override
  public boolean hasTtl() {
    return ttl_ != null;
  }
  /**
   *
   *
   * <pre>
   * Optional. The duration after which the workload will be terminated.
   * When the workload passes this ttl, it will be unconditionally killed
   * without waiting for ongoing work to finish.
   * Minimum value is 10 minutes; maximum value is 14 days (see JSON
   * representation of
   * [Duration](https://developers.google.com/protocol-buffers/docs/proto3#json)).
   * If both ttl and idle_ttl are specified, the conditions are treated as
   * and OR: the workload will be terminated when it has been idle for idle_ttl
   * or when the ttl has passed, whichever comes first.
   * If ttl is not specified for a session, it defaults to 24h.
   * </pre>
   *
   * <code>.google.protobuf.Duration ttl = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The ttl.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getTtl() {
    return ttl_ == null ? com.google.protobuf.Duration.getDefaultInstance() : ttl_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The duration after which the workload will be terminated.
   * When the workload passes this ttl, it will be unconditionally killed
   * without waiting for ongoing work to finish.
   * Minimum value is 10 minutes; maximum value is 14 days (see JSON
   * representation of
   * [Duration](https://developers.google.com/protocol-buffers/docs/proto3#json)).
   * If both ttl and idle_ttl are specified, the conditions are treated as
   * and OR: the workload will be terminated when it has been idle for idle_ttl
   * or when the ttl has passed, whichever comes first.
   * If ttl is not specified for a session, it defaults to 24h.
   * </pre>
   *
   * <code>.google.protobuf.Duration ttl = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getTtlOrBuilder() {
    return ttl_ == null ? com.google.protobuf.Duration.getDefaultInstance() : ttl_;
  }

  public static final int STAGING_BUCKET_FIELD_NUMBER = 10;

  @SuppressWarnings("serial")
  private volatile java.lang.Object stagingBucket_ = "";
  /**
   *
   *
   * <pre>
   * Optional. A Cloud Storage bucket used to stage workload dependencies,
   * config files, and store workload output and other ephemeral data, such as
   * Spark history files. If you do not specify a staging bucket, Cloud Dataproc
   * will determine a Cloud Storage location according to the region where your
   * workload is running, and then create and manage project-level, per-location
   * staging and temporary buckets.
   * **This field requires a Cloud Storage bucket name, not a `gs://...` URI to
   * a Cloud Storage bucket.**
   * </pre>
   *
   * <code>string staging_bucket = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The stagingBucket.
   */
  @java.lang.Override
  public java.lang.String getStagingBucket() {
    java.lang.Object ref = stagingBucket_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      stagingBucket_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. A Cloud Storage bucket used to stage workload dependencies,
   * config files, and store workload output and other ephemeral data, such as
   * Spark history files. If you do not specify a staging bucket, Cloud Dataproc
   * will determine a Cloud Storage location according to the region where your
   * workload is running, and then create and manage project-level, per-location
   * staging and temporary buckets.
   * **This field requires a Cloud Storage bucket name, not a `gs://...` URI to
   * a Cloud Storage bucket.**
   * </pre>
   *
   * <code>string staging_bucket = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for stagingBucket.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getStagingBucketBytes() {
    java.lang.Object ref = stagingBucket_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      stagingBucket_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceAccount_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, serviceAccount_);
    }
    if (networkCase_ == 4) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, network_);
    }
    if (networkCase_ == 5) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, network_);
    }
    for (int i = 0; i < networkTags_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, networkTags_.getRaw(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(kmsKey_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, kmsKey_);
    }
    if (ttl_ != null) {
      output.writeMessage(9, getTtl());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(stagingBucket_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 10, stagingBucket_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceAccount_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, serviceAccount_);
    }
    if (networkCase_ == 4) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, network_);
    }
    if (networkCase_ == 5) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, network_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < networkTags_.size(); i++) {
        dataSize += computeStringSizeNoTag(networkTags_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getNetworkTagsList().size();
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(kmsKey_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, kmsKey_);
    }
    if (ttl_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getTtl());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(stagingBucket_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(10, stagingBucket_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dataproc.v1.ExecutionConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.dataproc.v1.ExecutionConfig other =
        (com.google.cloud.dataproc.v1.ExecutionConfig) obj;

    if (!getServiceAccount().equals(other.getServiceAccount())) return false;
    if (!getNetworkTagsList().equals(other.getNetworkTagsList())) return false;
    if (!getKmsKey().equals(other.getKmsKey())) return false;
    if (hasTtl() != other.hasTtl()) return false;
    if (hasTtl()) {
      if (!getTtl().equals(other.getTtl())) return false;
    }
    if (!getStagingBucket().equals(other.getStagingBucket())) return false;
    if (!getNetworkCase().equals(other.getNetworkCase())) return false;
    switch (networkCase_) {
      case 4:
        if (!getNetworkUri().equals(other.getNetworkUri())) return false;
        break;
      case 5:
        if (!getSubnetworkUri().equals(other.getSubnetworkUri())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + SERVICE_ACCOUNT_FIELD_NUMBER;
    hash = (53 * hash) + getServiceAccount().hashCode();
    if (getNetworkTagsCount() > 0) {
      hash = (37 * hash) + NETWORK_TAGS_FIELD_NUMBER;
      hash = (53 * hash) + getNetworkTagsList().hashCode();
    }
    hash = (37 * hash) + KMS_KEY_FIELD_NUMBER;
    hash = (53 * hash) + getKmsKey().hashCode();
    if (hasTtl()) {
      hash = (37 * hash) + TTL_FIELD_NUMBER;
      hash = (53 * hash) + getTtl().hashCode();
    }
    hash = (37 * hash) + STAGING_BUCKET_FIELD_NUMBER;
    hash = (53 * hash) + getStagingBucket().hashCode();
    switch (networkCase_) {
      case 4:
        hash = (37 * hash) + NETWORK_URI_FIELD_NUMBER;
        hash = (53 * hash) + getNetworkUri().hashCode();
        break;
      case 5:
        hash = (37 * hash) + SUBNETWORK_URI_FIELD_NUMBER;
        hash = (53 * hash) + getSubnetworkUri().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dataproc.v1.ExecutionConfig parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1.ExecutionConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.ExecutionConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1.ExecutionConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.ExecutionConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1.ExecutionConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.ExecutionConfig parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1.ExecutionConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.ExecutionConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1.ExecutionConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.ExecutionConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1.ExecutionConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.dataproc.v1.ExecutionConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Execution configuration for a workload.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dataproc.v1.ExecutionConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dataproc.v1.ExecutionConfig)
      com.google.cloud.dataproc.v1.ExecutionConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dataproc.v1.SharedProto
          .internal_static_google_cloud_dataproc_v1_ExecutionConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dataproc.v1.SharedProto
          .internal_static_google_cloud_dataproc_v1_ExecutionConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dataproc.v1.ExecutionConfig.class,
              com.google.cloud.dataproc.v1.ExecutionConfig.Builder.class);
    }

    // Construct using com.google.cloud.dataproc.v1.ExecutionConfig.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      serviceAccount_ = "";
      networkTags_ = com.google.protobuf.LazyStringArrayList.emptyList();
      kmsKey_ = "";
      ttl_ = null;
      if (ttlBuilder_ != null) {
        ttlBuilder_.dispose();
        ttlBuilder_ = null;
      }
      stagingBucket_ = "";
      networkCase_ = 0;
      network_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dataproc.v1.SharedProto
          .internal_static_google_cloud_dataproc_v1_ExecutionConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.ExecutionConfig getDefaultInstanceForType() {
      return com.google.cloud.dataproc.v1.ExecutionConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.ExecutionConfig build() {
      com.google.cloud.dataproc.v1.ExecutionConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.ExecutionConfig buildPartial() {
      com.google.cloud.dataproc.v1.ExecutionConfig result =
          new com.google.cloud.dataproc.v1.ExecutionConfig(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.dataproc.v1.ExecutionConfig result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.serviceAccount_ = serviceAccount_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        networkTags_.makeImmutable();
        result.networkTags_ = networkTags_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.kmsKey_ = kmsKey_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.ttl_ = ttlBuilder_ == null ? ttl_ : ttlBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.stagingBucket_ = stagingBucket_;
      }
    }

    private void buildPartialOneofs(com.google.cloud.dataproc.v1.ExecutionConfig result) {
      result.networkCase_ = networkCase_;
      result.network_ = this.network_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dataproc.v1.ExecutionConfig) {
        return mergeFrom((com.google.cloud.dataproc.v1.ExecutionConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dataproc.v1.ExecutionConfig other) {
      if (other == com.google.cloud.dataproc.v1.ExecutionConfig.getDefaultInstance()) return this;
      if (!other.getServiceAccount().isEmpty()) {
        serviceAccount_ = other.serviceAccount_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.networkTags_.isEmpty()) {
        if (networkTags_.isEmpty()) {
          networkTags_ = other.networkTags_;
          bitField0_ |= 0x00000008;
        } else {
          ensureNetworkTagsIsMutable();
          networkTags_.addAll(other.networkTags_);
        }
        onChanged();
      }
      if (!other.getKmsKey().isEmpty()) {
        kmsKey_ = other.kmsKey_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (other.hasTtl()) {
        mergeTtl(other.getTtl());
      }
      if (!other.getStagingBucket().isEmpty()) {
        stagingBucket_ = other.stagingBucket_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      switch (other.getNetworkCase()) {
        case NETWORK_URI:
          {
            networkCase_ = 4;
            network_ = other.network_;
            onChanged();
            break;
          }
        case SUBNETWORK_URI:
          {
            networkCase_ = 5;
            network_ = other.network_;
            onChanged();
            break;
          }
        case NETWORK_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 18:
              {
                serviceAccount_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 18
            case 34:
              {
                java.lang.String s = input.readStringRequireUtf8();
                networkCase_ = 4;
                network_ = s;
                break;
              } // case 34
            case 42:
              {
                java.lang.String s = input.readStringRequireUtf8();
                networkCase_ = 5;
                network_ = s;
                break;
              } // case 42
            case 50:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureNetworkTagsIsMutable();
                networkTags_.add(s);
                break;
              } // case 50
            case 58:
              {
                kmsKey_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 58
            case 74:
              {
                input.readMessage(getTtlFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 74
            case 82:
              {
                stagingBucket_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 82
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int networkCase_ = 0;
    private java.lang.Object network_;

    public NetworkCase getNetworkCase() {
      return NetworkCase.forNumber(networkCase_);
    }

    public Builder clearNetwork() {
      networkCase_ = 0;
      network_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object serviceAccount_ = "";
    /**
     *
     *
     * <pre>
     * Optional. Service account that used to execute workload.
     * </pre>
     *
     * <code>string service_account = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The serviceAccount.
     */
    public java.lang.String getServiceAccount() {
      java.lang.Object ref = serviceAccount_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        serviceAccount_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Service account that used to execute workload.
     * </pre>
     *
     * <code>string service_account = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for serviceAccount.
     */
    public com.google.protobuf.ByteString getServiceAccountBytes() {
      java.lang.Object ref = serviceAccount_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        serviceAccount_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Service account that used to execute workload.
     * </pre>
     *
     * <code>string service_account = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The serviceAccount to set.
     * @return This builder for chaining.
     */
    public Builder setServiceAccount(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      serviceAccount_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Service account that used to execute workload.
     * </pre>
     *
     * <code>string service_account = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearServiceAccount() {
      serviceAccount_ = getDefaultInstance().getServiceAccount();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Service account that used to execute workload.
     * </pre>
     *
     * <code>string service_account = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for serviceAccount to set.
     * @return This builder for chaining.
     */
    public Builder setServiceAccountBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      serviceAccount_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Network URI to connect workload to.
     * </pre>
     *
     * <code>string network_uri = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return Whether the networkUri field is set.
     */
    @java.lang.Override
    public boolean hasNetworkUri() {
      return networkCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * Optional. Network URI to connect workload to.
     * </pre>
     *
     * <code>string network_uri = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The networkUri.
     */
    @java.lang.Override
    public java.lang.String getNetworkUri() {
      java.lang.Object ref = "";
      if (networkCase_ == 4) {
        ref = network_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (networkCase_ == 4) {
          network_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Network URI to connect workload to.
     * </pre>
     *
     * <code>string network_uri = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for networkUri.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getNetworkUriBytes() {
      java.lang.Object ref = "";
      if (networkCase_ == 4) {
        ref = network_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (networkCase_ == 4) {
          network_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Network URI to connect workload to.
     * </pre>
     *
     * <code>string network_uri = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The networkUri to set.
     * @return This builder for chaining.
     */
    public Builder setNetworkUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      networkCase_ = 4;
      network_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Network URI to connect workload to.
     * </pre>
     *
     * <code>string network_uri = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNetworkUri() {
      if (networkCase_ == 4) {
        networkCase_ = 0;
        network_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Network URI to connect workload to.
     * </pre>
     *
     * <code>string network_uri = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for networkUri to set.
     * @return This builder for chaining.
     */
    public Builder setNetworkUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      networkCase_ = 4;
      network_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Subnetwork URI to connect workload to.
     * </pre>
     *
     * <code>string subnetwork_uri = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return Whether the subnetworkUri field is set.
     */
    @java.lang.Override
    public boolean hasSubnetworkUri() {
      return networkCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * Optional. Subnetwork URI to connect workload to.
     * </pre>
     *
     * <code>string subnetwork_uri = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The subnetworkUri.
     */
    @java.lang.Override
    public java.lang.String getSubnetworkUri() {
      java.lang.Object ref = "";
      if (networkCase_ == 5) {
        ref = network_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (networkCase_ == 5) {
          network_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Subnetwork URI to connect workload to.
     * </pre>
     *
     * <code>string subnetwork_uri = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for subnetworkUri.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getSubnetworkUriBytes() {
      java.lang.Object ref = "";
      if (networkCase_ == 5) {
        ref = network_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (networkCase_ == 5) {
          network_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Subnetwork URI to connect workload to.
     * </pre>
     *
     * <code>string subnetwork_uri = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The subnetworkUri to set.
     * @return This builder for chaining.
     */
    public Builder setSubnetworkUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      networkCase_ = 5;
      network_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Subnetwork URI to connect workload to.
     * </pre>
     *
     * <code>string subnetwork_uri = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSubnetworkUri() {
      if (networkCase_ == 5) {
        networkCase_ = 0;
        network_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Subnetwork URI to connect workload to.
     * </pre>
     *
     * <code>string subnetwork_uri = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for subnetworkUri to set.
     * @return This builder for chaining.
     */
    public Builder setSubnetworkUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      networkCase_ = 5;
      network_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList networkTags_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureNetworkTagsIsMutable() {
      if (!networkTags_.isModifiable()) {
        networkTags_ = new com.google.protobuf.LazyStringArrayList(networkTags_);
      }
      bitField0_ |= 0x00000008;
    }
    /**
     *
     *
     * <pre>
     * Optional. Tags used for network traffic control.
     * </pre>
     *
     * <code>repeated string network_tags = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return A list containing the networkTags.
     */
    public com.google.protobuf.ProtocolStringList getNetworkTagsList() {
      networkTags_.makeImmutable();
      return networkTags_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Tags used for network traffic control.
     * </pre>
     *
     * <code>repeated string network_tags = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The count of networkTags.
     */
    public int getNetworkTagsCount() {
      return networkTags_.size();
    }
    /**
     *
     *
     * <pre>
     * Optional. Tags used for network traffic control.
     * </pre>
     *
     * <code>repeated string network_tags = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the element to return.
     * @return The networkTags at the given index.
     */
    public java.lang.String getNetworkTags(int index) {
      return networkTags_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. Tags used for network traffic control.
     * </pre>
     *
     * <code>repeated string network_tags = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the networkTags at the given index.
     */
    public com.google.protobuf.ByteString getNetworkTagsBytes(int index) {
      return networkTags_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. Tags used for network traffic control.
     * </pre>
     *
     * <code>repeated string network_tags = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index to set the value at.
     * @param value The networkTags to set.
     * @return This builder for chaining.
     */
    public Builder setNetworkTags(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureNetworkTagsIsMutable();
      networkTags_.set(index, value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Tags used for network traffic control.
     * </pre>
     *
     * <code>repeated string network_tags = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The networkTags to add.
     * @return This builder for chaining.
     */
    public Builder addNetworkTags(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureNetworkTagsIsMutable();
      networkTags_.add(value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Tags used for network traffic control.
     * </pre>
     *
     * <code>repeated string network_tags = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param values The networkTags to add.
     * @return This builder for chaining.
     */
    public Builder addAllNetworkTags(java.lang.Iterable<java.lang.String> values) {
      ensureNetworkTagsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, networkTags_);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Tags used for network traffic control.
     * </pre>
     *
     * <code>repeated string network_tags = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNetworkTags() {
      networkTags_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000008);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Tags used for network traffic control.
     * </pre>
     *
     * <code>repeated string network_tags = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes of the networkTags to add.
     * @return This builder for chaining.
     */
    public Builder addNetworkTagsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureNetworkTagsIsMutable();
      networkTags_.add(value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object kmsKey_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The Cloud KMS key to use for encryption.
     * </pre>
     *
     * <code>string kms_key = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The kmsKey.
     */
    public java.lang.String getKmsKey() {
      java.lang.Object ref = kmsKey_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        kmsKey_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The Cloud KMS key to use for encryption.
     * </pre>
     *
     * <code>string kms_key = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for kmsKey.
     */
    public com.google.protobuf.ByteString getKmsKeyBytes() {
      java.lang.Object ref = kmsKey_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        kmsKey_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The Cloud KMS key to use for encryption.
     * </pre>
     *
     * <code>string kms_key = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The kmsKey to set.
     * @return This builder for chaining.
     */
    public Builder setKmsKey(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      kmsKey_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The Cloud KMS key to use for encryption.
     * </pre>
     *
     * <code>string kms_key = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearKmsKey() {
      kmsKey_ = getDefaultInstance().getKmsKey();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The Cloud KMS key to use for encryption.
     * </pre>
     *
     * <code>string kms_key = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for kmsKey to set.
     * @return This builder for chaining.
     */
    public Builder setKmsKeyBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      kmsKey_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private com.google.protobuf.Duration ttl_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        ttlBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. The duration after which the workload will be terminated.
     * When the workload passes this ttl, it will be unconditionally killed
     * without waiting for ongoing work to finish.
     * Minimum value is 10 minutes; maximum value is 14 days (see JSON
     * representation of
     * [Duration](https://developers.google.com/protocol-buffers/docs/proto3#json)).
     * If both ttl and idle_ttl are specified, the conditions are treated as
     * and OR: the workload will be terminated when it has been idle for idle_ttl
     * or when the ttl has passed, whichever comes first.
     * If ttl is not specified for a session, it defaults to 24h.
     * </pre>
     *
     * <code>.google.protobuf.Duration ttl = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return Whether the ttl field is set.
     */
    public boolean hasTtl() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. The duration after which the workload will be terminated.
     * When the workload passes this ttl, it will be unconditionally killed
     * without waiting for ongoing work to finish.
     * Minimum value is 10 minutes; maximum value is 14 days (see JSON
     * representation of
     * [Duration](https://developers.google.com/protocol-buffers/docs/proto3#json)).
     * If both ttl and idle_ttl are specified, the conditions are treated as
     * and OR: the workload will be terminated when it has been idle for idle_ttl
     * or when the ttl has passed, whichever comes first.
     * If ttl is not specified for a session, it defaults to 24h.
     * </pre>
     *
     * <code>.google.protobuf.Duration ttl = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The ttl.
     */
    public com.google.protobuf.Duration getTtl() {
      if (ttlBuilder_ == null) {
        return ttl_ == null ? com.google.protobuf.Duration.getDefaultInstance() : ttl_;
      } else {
        return ttlBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The duration after which the workload will be terminated.
     * When the workload passes this ttl, it will be unconditionally killed
     * without waiting for ongoing work to finish.
     * Minimum value is 10 minutes; maximum value is 14 days (see JSON
     * representation of
     * [Duration](https://developers.google.com/protocol-buffers/docs/proto3#json)).
     * If both ttl and idle_ttl are specified, the conditions are treated as
     * and OR: the workload will be terminated when it has been idle for idle_ttl
     * or when the ttl has passed, whichever comes first.
     * If ttl is not specified for a session, it defaults to 24h.
     * </pre>
     *
     * <code>.google.protobuf.Duration ttl = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder setTtl(com.google.protobuf.Duration value) {
      if (ttlBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ttl_ = value;
      } else {
        ttlBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The duration after which the workload will be terminated.
     * When the workload passes this ttl, it will be unconditionally killed
     * without waiting for ongoing work to finish.
     * Minimum value is 10 minutes; maximum value is 14 days (see JSON
     * representation of
     * [Duration](https://developers.google.com/protocol-buffers/docs/proto3#json)).
     * If both ttl and idle_ttl are specified, the conditions are treated as
     * and OR: the workload will be terminated when it has been idle for idle_ttl
     * or when the ttl has passed, whichever comes first.
     * If ttl is not specified for a session, it defaults to 24h.
     * </pre>
     *
     * <code>.google.protobuf.Duration ttl = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder setTtl(com.google.protobuf.Duration.Builder builderForValue) {
      if (ttlBuilder_ == null) {
        ttl_ = builderForValue.build();
      } else {
        ttlBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The duration after which the workload will be terminated.
     * When the workload passes this ttl, it will be unconditionally killed
     * without waiting for ongoing work to finish.
     * Minimum value is 10 minutes; maximum value is 14 days (see JSON
     * representation of
     * [Duration](https://developers.google.com/protocol-buffers/docs/proto3#json)).
     * If both ttl and idle_ttl are specified, the conditions are treated as
     * and OR: the workload will be terminated when it has been idle for idle_ttl
     * or when the ttl has passed, whichever comes first.
     * If ttl is not specified for a session, it defaults to 24h.
     * </pre>
     *
     * <code>.google.protobuf.Duration ttl = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder mergeTtl(com.google.protobuf.Duration value) {
      if (ttlBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && ttl_ != null
            && ttl_ != com.google.protobuf.Duration.getDefaultInstance()) {
          getTtlBuilder().mergeFrom(value);
        } else {
          ttl_ = value;
        }
      } else {
        ttlBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The duration after which the workload will be terminated.
     * When the workload passes this ttl, it will be unconditionally killed
     * without waiting for ongoing work to finish.
     * Minimum value is 10 minutes; maximum value is 14 days (see JSON
     * representation of
     * [Duration](https://developers.google.com/protocol-buffers/docs/proto3#json)).
     * If both ttl and idle_ttl are specified, the conditions are treated as
     * and OR: the workload will be terminated when it has been idle for idle_ttl
     * or when the ttl has passed, whichever comes first.
     * If ttl is not specified for a session, it defaults to 24h.
     * </pre>
     *
     * <code>.google.protobuf.Duration ttl = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder clearTtl() {
      bitField0_ = (bitField0_ & ~0x00000020);
      ttl_ = null;
      if (ttlBuilder_ != null) {
        ttlBuilder_.dispose();
        ttlBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The duration after which the workload will be terminated.
     * When the workload passes this ttl, it will be unconditionally killed
     * without waiting for ongoing work to finish.
     * Minimum value is 10 minutes; maximum value is 14 days (see JSON
     * representation of
     * [Duration](https://developers.google.com/protocol-buffers/docs/proto3#json)).
     * If both ttl and idle_ttl are specified, the conditions are treated as
     * and OR: the workload will be terminated when it has been idle for idle_ttl
     * or when the ttl has passed, whichever comes first.
     * If ttl is not specified for a session, it defaults to 24h.
     * </pre>
     *
     * <code>.google.protobuf.Duration ttl = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public com.google.protobuf.Duration.Builder getTtlBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getTtlFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. The duration after which the workload will be terminated.
     * When the workload passes this ttl, it will be unconditionally killed
     * without waiting for ongoing work to finish.
     * Minimum value is 10 minutes; maximum value is 14 days (see JSON
     * representation of
     * [Duration](https://developers.google.com/protocol-buffers/docs/proto3#json)).
     * If both ttl and idle_ttl are specified, the conditions are treated as
     * and OR: the workload will be terminated when it has been idle for idle_ttl
     * or when the ttl has passed, whichever comes first.
     * If ttl is not specified for a session, it defaults to 24h.
     * </pre>
     *
     * <code>.google.protobuf.Duration ttl = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public com.google.protobuf.DurationOrBuilder getTtlOrBuilder() {
      if (ttlBuilder_ != null) {
        return ttlBuilder_.getMessageOrBuilder();
      } else {
        return ttl_ == null ? com.google.protobuf.Duration.getDefaultInstance() : ttl_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The duration after which the workload will be terminated.
     * When the workload passes this ttl, it will be unconditionally killed
     * without waiting for ongoing work to finish.
     * Minimum value is 10 minutes; maximum value is 14 days (see JSON
     * representation of
     * [Duration](https://developers.google.com/protocol-buffers/docs/proto3#json)).
     * If both ttl and idle_ttl are specified, the conditions are treated as
     * and OR: the workload will be terminated when it has been idle for idle_ttl
     * or when the ttl has passed, whichever comes first.
     * If ttl is not specified for a session, it defaults to 24h.
     * </pre>
     *
     * <code>.google.protobuf.Duration ttl = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getTtlFieldBuilder() {
      if (ttlBuilder_ == null) {
        ttlBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(getTtl(), getParentForChildren(), isClean());
        ttl_ = null;
      }
      return ttlBuilder_;
    }

    private java.lang.Object stagingBucket_ = "";
    /**
     *
     *
     * <pre>
     * Optional. A Cloud Storage bucket used to stage workload dependencies,
     * config files, and store workload output and other ephemeral data, such as
     * Spark history files. If you do not specify a staging bucket, Cloud Dataproc
     * will determine a Cloud Storage location according to the region where your
     * workload is running, and then create and manage project-level, per-location
     * staging and temporary buckets.
     * **This field requires a Cloud Storage bucket name, not a `gs://...` URI to
     * a Cloud Storage bucket.**
     * </pre>
     *
     * <code>string staging_bucket = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The stagingBucket.
     */
    public java.lang.String getStagingBucket() {
      java.lang.Object ref = stagingBucket_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        stagingBucket_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A Cloud Storage bucket used to stage workload dependencies,
     * config files, and store workload output and other ephemeral data, such as
     * Spark history files. If you do not specify a staging bucket, Cloud Dataproc
     * will determine a Cloud Storage location according to the region where your
     * workload is running, and then create and manage project-level, per-location
     * staging and temporary buckets.
     * **This field requires a Cloud Storage bucket name, not a `gs://...` URI to
     * a Cloud Storage bucket.**
     * </pre>
     *
     * <code>string staging_bucket = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for stagingBucket.
     */
    public com.google.protobuf.ByteString getStagingBucketBytes() {
      java.lang.Object ref = stagingBucket_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        stagingBucket_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A Cloud Storage bucket used to stage workload dependencies,
     * config files, and store workload output and other ephemeral data, such as
     * Spark history files. If you do not specify a staging bucket, Cloud Dataproc
     * will determine a Cloud Storage location according to the region where your
     * workload is running, and then create and manage project-level, per-location
     * staging and temporary buckets.
     * **This field requires a Cloud Storage bucket name, not a `gs://...` URI to
     * a Cloud Storage bucket.**
     * </pre>
     *
     * <code>string staging_bucket = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The stagingBucket to set.
     * @return This builder for chaining.
     */
    public Builder setStagingBucket(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      stagingBucket_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A Cloud Storage bucket used to stage workload dependencies,
     * config files, and store workload output and other ephemeral data, such as
     * Spark history files. If you do not specify a staging bucket, Cloud Dataproc
     * will determine a Cloud Storage location according to the region where your
     * workload is running, and then create and manage project-level, per-location
     * staging and temporary buckets.
     * **This field requires a Cloud Storage bucket name, not a `gs://...` URI to
     * a Cloud Storage bucket.**
     * </pre>
     *
     * <code>string staging_bucket = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStagingBucket() {
      stagingBucket_ = getDefaultInstance().getStagingBucket();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A Cloud Storage bucket used to stage workload dependencies,
     * config files, and store workload output and other ephemeral data, such as
     * Spark history files. If you do not specify a staging bucket, Cloud Dataproc
     * will determine a Cloud Storage location according to the region where your
     * workload is running, and then create and manage project-level, per-location
     * staging and temporary buckets.
     * **This field requires a Cloud Storage bucket name, not a `gs://...` URI to
     * a Cloud Storage bucket.**
     * </pre>
     *
     * <code>string staging_bucket = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for stagingBucket to set.
     * @return This builder for chaining.
     */
    public Builder setStagingBucketBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      stagingBucket_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dataproc.v1.ExecutionConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dataproc.v1.ExecutionConfig)
  private static final com.google.cloud.dataproc.v1.ExecutionConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dataproc.v1.ExecutionConfig();
  }

  public static com.google.cloud.dataproc.v1.ExecutionConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ExecutionConfig> PARSER =
      new com.google.protobuf.AbstractParser<ExecutionConfig>() {
        @java.lang.Override
        public ExecutionConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ExecutionConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ExecutionConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dataproc.v1.ExecutionConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
