/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dataproc/v1/shared.proto

package com.google.cloud.dataproc.v1;

public interface ExecutionConfigOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.dataproc.v1.ExecutionConfig)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Optional. Service account that used to execute workload.
   * </pre>
   *
   * <code>string service_account = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The serviceAccount.
   */
  java.lang.String getServiceAccount();
  /**
   *
   *
   * <pre>
   * Optional. Service account that used to execute workload.
   * </pre>
   *
   * <code>string service_account = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for serviceAccount.
   */
  com.google.protobuf.ByteString getServiceAccountBytes();

  /**
   *
   *
   * <pre>
   * Optional. Network URI to connect workload to.
   * </pre>
   *
   * <code>string network_uri = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return Whether the networkUri field is set.
   */
  boolean hasNetworkUri();
  /**
   *
   *
   * <pre>
   * Optional. Network URI to connect workload to.
   * </pre>
   *
   * <code>string network_uri = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The networkUri.
   */
  java.lang.String getNetworkUri();
  /**
   *
   *
   * <pre>
   * Optional. Network URI to connect workload to.
   * </pre>
   *
   * <code>string network_uri = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for networkUri.
   */
  com.google.protobuf.ByteString getNetworkUriBytes();

  /**
   *
   *
   * <pre>
   * Optional. Subnetwork URI to connect workload to.
   * </pre>
   *
   * <code>string subnetwork_uri = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return Whether the subnetworkUri field is set.
   */
  boolean hasSubnetworkUri();
  /**
   *
   *
   * <pre>
   * Optional. Subnetwork URI to connect workload to.
   * </pre>
   *
   * <code>string subnetwork_uri = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The subnetworkUri.
   */
  java.lang.String getSubnetworkUri();
  /**
   *
   *
   * <pre>
   * Optional. Subnetwork URI to connect workload to.
   * </pre>
   *
   * <code>string subnetwork_uri = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for subnetworkUri.
   */
  com.google.protobuf.ByteString getSubnetworkUriBytes();

  /**
   *
   *
   * <pre>
   * Optional. Tags used for network traffic control.
   * </pre>
   *
   * <code>repeated string network_tags = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return A list containing the networkTags.
   */
  java.util.List<java.lang.String> getNetworkTagsList();
  /**
   *
   *
   * <pre>
   * Optional. Tags used for network traffic control.
   * </pre>
   *
   * <code>repeated string network_tags = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The count of networkTags.
   */
  int getNetworkTagsCount();
  /**
   *
   *
   * <pre>
   * Optional. Tags used for network traffic control.
   * </pre>
   *
   * <code>repeated string network_tags = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the element to return.
   * @return The networkTags at the given index.
   */
  java.lang.String getNetworkTags(int index);
  /**
   *
   *
   * <pre>
   * Optional. Tags used for network traffic control.
   * </pre>
   *
   * <code>repeated string network_tags = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the networkTags at the given index.
   */
  com.google.protobuf.ByteString getNetworkTagsBytes(int index);

  /**
   *
   *
   * <pre>
   * Optional. The Cloud KMS key to use for encryption.
   * </pre>
   *
   * <code>string kms_key = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The kmsKey.
   */
  java.lang.String getKmsKey();
  /**
   *
   *
   * <pre>
   * Optional. The Cloud KMS key to use for encryption.
   * </pre>
   *
   * <code>string kms_key = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for kmsKey.
   */
  com.google.protobuf.ByteString getKmsKeyBytes();

  /**
   *
   *
   * <pre>
   * Optional. The duration after which the workload will be terminated.
   * When the workload passes this ttl, it will be unconditionally killed
   * without waiting for ongoing work to finish.
   * Minimum value is 10 minutes; maximum value is 14 days (see JSON
   * representation of
   * [Duration](https://developers.google.com/protocol-buffers/docs/proto3#json)).
   * If both ttl and idle_ttl are specified, the conditions are treated as
   * and OR: the workload will be terminated when it has been idle for idle_ttl
   * or when the ttl has passed, whichever comes first.
   * If ttl is not specified for a session, it defaults to 24h.
   * </pre>
   *
   * <code>.google.protobuf.Duration ttl = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return Whether the ttl field is set.
   */
  boolean hasTtl();
  /**
   *
   *
   * <pre>
   * Optional. The duration after which the workload will be terminated.
   * When the workload passes this ttl, it will be unconditionally killed
   * without waiting for ongoing work to finish.
   * Minimum value is 10 minutes; maximum value is 14 days (see JSON
   * representation of
   * [Duration](https://developers.google.com/protocol-buffers/docs/proto3#json)).
   * If both ttl and idle_ttl are specified, the conditions are treated as
   * and OR: the workload will be terminated when it has been idle for idle_ttl
   * or when the ttl has passed, whichever comes first.
   * If ttl is not specified for a session, it defaults to 24h.
   * </pre>
   *
   * <code>.google.protobuf.Duration ttl = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The ttl.
   */
  com.google.protobuf.Duration getTtl();
  /**
   *
   *
   * <pre>
   * Optional. The duration after which the workload will be terminated.
   * When the workload passes this ttl, it will be unconditionally killed
   * without waiting for ongoing work to finish.
   * Minimum value is 10 minutes; maximum value is 14 days (see JSON
   * representation of
   * [Duration](https://developers.google.com/protocol-buffers/docs/proto3#json)).
   * If both ttl and idle_ttl are specified, the conditions are treated as
   * and OR: the workload will be terminated when it has been idle for idle_ttl
   * or when the ttl has passed, whichever comes first.
   * If ttl is not specified for a session, it defaults to 24h.
   * </pre>
   *
   * <code>.google.protobuf.Duration ttl = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  com.google.protobuf.DurationOrBuilder getTtlOrBuilder();

  /**
   *
   *
   * <pre>
   * Optional. A Cloud Storage bucket used to stage workload dependencies,
   * config files, and store workload output and other ephemeral data, such as
   * Spark history files. If you do not specify a staging bucket, Cloud Dataproc
   * will determine a Cloud Storage location according to the region where your
   * workload is running, and then create and manage project-level, per-location
   * staging and temporary buckets.
   * **This field requires a Cloud Storage bucket name, not a `gs://...` URI to
   * a Cloud Storage bucket.**
   * </pre>
   *
   * <code>string staging_bucket = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The stagingBucket.
   */
  java.lang.String getStagingBucket();
  /**
   *
   *
   * <pre>
   * Optional. A Cloud Storage bucket used to stage workload dependencies,
   * config files, and store workload output and other ephemeral data, such as
   * Spark history files. If you do not specify a staging bucket, Cloud Dataproc
   * will determine a Cloud Storage location according to the region where your
   * workload is running, and then create and manage project-level, per-location
   * staging and temporary buckets.
   * **This field requires a Cloud Storage bucket name, not a `gs://...` URI to
   * a Cloud Storage bucket.**
   * </pre>
   *
   * <code>string staging_bucket = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for stagingBucket.
   */
  com.google.protobuf.ByteString getStagingBucketBytes();

  com.google.cloud.dataproc.v1.ExecutionConfig.NetworkCase getNetworkCase();
}
