/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dataproc/v1/clusters.proto

package com.google.cloud.dataproc.v1;

/**
 *
 *
 * <pre>
 * Common config settings for resources of Compute Engine cluster
 * instances, applicable to all instances in the cluster.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dataproc.v1.GceClusterConfig}
 */
public final class GceClusterConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dataproc.v1.GceClusterConfig)
    GceClusterConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use GceClusterConfig.newBuilder() to construct.
  private GceClusterConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private GceClusterConfig() {
    zoneUri_ = "";
    networkUri_ = "";
    subnetworkUri_ = "";
    privateIpv6GoogleAccess_ = 0;
    serviceAccount_ = "";
    serviceAccountScopes_ = com.google.protobuf.LazyStringArrayList.emptyList();
    tags_ = com.google.protobuf.LazyStringArrayList.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new GceClusterConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dataproc.v1.ClustersProto
        .internal_static_google_cloud_dataproc_v1_GceClusterConfig_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 5:
        return internalGetMetadata();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dataproc.v1.ClustersProto
        .internal_static_google_cloud_dataproc_v1_GceClusterConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dataproc.v1.GceClusterConfig.class,
            com.google.cloud.dataproc.v1.GceClusterConfig.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * `PrivateIpv6GoogleAccess` controls whether and how Dataproc cluster nodes
   * can communicate with Google Services through gRPC over IPv6.
   * These values are directly mapped to corresponding values in the
   * [Compute Engine Instance
   * fields](https://cloud.google.com/compute/docs/reference/rest/v1/instances).
   * </pre>
   *
   * Protobuf enum {@code google.cloud.dataproc.v1.GceClusterConfig.PrivateIpv6GoogleAccess}
   */
  public enum PrivateIpv6GoogleAccess implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * If unspecified, Compute Engine default behavior will apply, which
     * is the same as
     * [INHERIT_FROM_SUBNETWORK][google.cloud.dataproc.v1.GceClusterConfig.PrivateIpv6GoogleAccess.INHERIT_FROM_SUBNETWORK].
     * </pre>
     *
     * <code>PRIVATE_IPV6_GOOGLE_ACCESS_UNSPECIFIED = 0;</code>
     */
    PRIVATE_IPV6_GOOGLE_ACCESS_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Private access to and from Google Services configuration
     * inherited from the subnetwork configuration. This is the
     * default Compute Engine behavior.
     * </pre>
     *
     * <code>INHERIT_FROM_SUBNETWORK = 1;</code>
     */
    INHERIT_FROM_SUBNETWORK(1),
    /**
     *
     *
     * <pre>
     * Enables outbound private IPv6 access to Google Services from the Dataproc
     * cluster.
     * </pre>
     *
     * <code>OUTBOUND = 2;</code>
     */
    OUTBOUND(2),
    /**
     *
     *
     * <pre>
     * Enables bidirectional private IPv6 access between Google Services and the
     * Dataproc cluster.
     * </pre>
     *
     * <code>BIDIRECTIONAL = 3;</code>
     */
    BIDIRECTIONAL(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * If unspecified, Compute Engine default behavior will apply, which
     * is the same as
     * [INHERIT_FROM_SUBNETWORK][google.cloud.dataproc.v1.GceClusterConfig.PrivateIpv6GoogleAccess.INHERIT_FROM_SUBNETWORK].
     * </pre>
     *
     * <code>PRIVATE_IPV6_GOOGLE_ACCESS_UNSPECIFIED = 0;</code>
     */
    public static final int PRIVATE_IPV6_GOOGLE_ACCESS_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Private access to and from Google Services configuration
     * inherited from the subnetwork configuration. This is the
     * default Compute Engine behavior.
     * </pre>
     *
     * <code>INHERIT_FROM_SUBNETWORK = 1;</code>
     */
    public static final int INHERIT_FROM_SUBNETWORK_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Enables outbound private IPv6 access to Google Services from the Dataproc
     * cluster.
     * </pre>
     *
     * <code>OUTBOUND = 2;</code>
     */
    public static final int OUTBOUND_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Enables bidirectional private IPv6 access between Google Services and the
     * Dataproc cluster.
     * </pre>
     *
     * <code>BIDIRECTIONAL = 3;</code>
     */
    public static final int BIDIRECTIONAL_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static PrivateIpv6GoogleAccess valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static PrivateIpv6GoogleAccess forNumber(int value) {
      switch (value) {
        case 0:
          return PRIVATE_IPV6_GOOGLE_ACCESS_UNSPECIFIED;
        case 1:
          return INHERIT_FROM_SUBNETWORK;
        case 2:
          return OUTBOUND;
        case 3:
          return BIDIRECTIONAL;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<PrivateIpv6GoogleAccess>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<PrivateIpv6GoogleAccess>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<PrivateIpv6GoogleAccess>() {
              public PrivateIpv6GoogleAccess findValueByNumber(int number) {
                return PrivateIpv6GoogleAccess.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.dataproc.v1.GceClusterConfig.getDescriptor().getEnumTypes().get(0);
    }

    private static final PrivateIpv6GoogleAccess[] VALUES = values();

    public static PrivateIpv6GoogleAccess valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private PrivateIpv6GoogleAccess(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.dataproc.v1.GceClusterConfig.PrivateIpv6GoogleAccess)
  }

  private int bitField0_;
  public static final int ZONE_URI_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object zoneUri_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The Compute Engine zone where the Dataproc cluster will be
   * located. If omitted, the service will pick a zone in the cluster's Compute
   * Engine region. On a get request, zone will always be present.
   *
   * A full URL, partial URI, or short name are valid. Examples:
   *
   * * `https://www.googleapis.com/compute/v1/projects/[project_id]/zones/[zone]`
   * * `projects/[project_id]/zones/[zone]`
   * * `[zone]`
   * </pre>
   *
   * <code>string zone_uri = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The zoneUri.
   */
  @java.lang.Override
  public java.lang.String getZoneUri() {
    java.lang.Object ref = zoneUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      zoneUri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The Compute Engine zone where the Dataproc cluster will be
   * located. If omitted, the service will pick a zone in the cluster's Compute
   * Engine region. On a get request, zone will always be present.
   *
   * A full URL, partial URI, or short name are valid. Examples:
   *
   * * `https://www.googleapis.com/compute/v1/projects/[project_id]/zones/[zone]`
   * * `projects/[project_id]/zones/[zone]`
   * * `[zone]`
   * </pre>
   *
   * <code>string zone_uri = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for zoneUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getZoneUriBytes() {
    java.lang.Object ref = zoneUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      zoneUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NETWORK_URI_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object networkUri_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The Compute Engine network to be used for machine
   * communications. Cannot be specified with subnetwork_uri. If neither
   * `network_uri` nor `subnetwork_uri` is specified, the "default" network of
   * the project is used, if it exists. Cannot be a "Custom Subnet Network" (see
   * [Using Subnetworks](https://cloud.google.com/compute/docs/subnetworks) for
   * more information).
   *
   * A full URL, partial URI, or short name are valid. Examples:
   *
   * * `https://www.googleapis.com/compute/v1/projects/[project_id]/global/networks/default`
   * * `projects/[project_id]/global/networks/default`
   * * `default`
   * </pre>
   *
   * <code>string network_uri = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The networkUri.
   */
  @java.lang.Override
  public java.lang.String getNetworkUri() {
    java.lang.Object ref = networkUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      networkUri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The Compute Engine network to be used for machine
   * communications. Cannot be specified with subnetwork_uri. If neither
   * `network_uri` nor `subnetwork_uri` is specified, the "default" network of
   * the project is used, if it exists. Cannot be a "Custom Subnet Network" (see
   * [Using Subnetworks](https://cloud.google.com/compute/docs/subnetworks) for
   * more information).
   *
   * A full URL, partial URI, or short name are valid. Examples:
   *
   * * `https://www.googleapis.com/compute/v1/projects/[project_id]/global/networks/default`
   * * `projects/[project_id]/global/networks/default`
   * * `default`
   * </pre>
   *
   * <code>string network_uri = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for networkUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNetworkUriBytes() {
    java.lang.Object ref = networkUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      networkUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SUBNETWORK_URI_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object subnetworkUri_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The Compute Engine subnetwork to be used for machine
   * communications. Cannot be specified with network_uri.
   *
   * A full URL, partial URI, or short name are valid. Examples:
   *
   * * `https://www.googleapis.com/compute/v1/projects/[project_id]/regions/[region]/subnetworks/sub0`
   * * `projects/[project_id]/regions/[region]/subnetworks/sub0`
   * * `sub0`
   * </pre>
   *
   * <code>string subnetwork_uri = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The subnetworkUri.
   */
  @java.lang.Override
  public java.lang.String getSubnetworkUri() {
    java.lang.Object ref = subnetworkUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      subnetworkUri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The Compute Engine subnetwork to be used for machine
   * communications. Cannot be specified with network_uri.
   *
   * A full URL, partial URI, or short name are valid. Examples:
   *
   * * `https://www.googleapis.com/compute/v1/projects/[project_id]/regions/[region]/subnetworks/sub0`
   * * `projects/[project_id]/regions/[region]/subnetworks/sub0`
   * * `sub0`
   * </pre>
   *
   * <code>string subnetwork_uri = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for subnetworkUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSubnetworkUriBytes() {
    java.lang.Object ref = subnetworkUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      subnetworkUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int INTERNAL_IP_ONLY_FIELD_NUMBER = 7;
  private boolean internalIpOnly_ = false;
  /**
   *
   *
   * <pre>
   * Optional. If true, all instances in the cluster will only have internal IP
   * addresses. By default, clusters are not restricted to internal IP
   * addresses, and will have ephemeral external IP addresses assigned to each
   * instance. This `internal_ip_only` restriction can only be enabled for
   * subnetwork enabled networks, and all off-cluster dependencies must be
   * configured to be accessible without external IP addresses.
   * </pre>
   *
   * <code>optional bool internal_ip_only = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return Whether the internalIpOnly field is set.
   */
  @java.lang.Override
  public boolean hasInternalIpOnly() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. If true, all instances in the cluster will only have internal IP
   * addresses. By default, clusters are not restricted to internal IP
   * addresses, and will have ephemeral external IP addresses assigned to each
   * instance. This `internal_ip_only` restriction can only be enabled for
   * subnetwork enabled networks, and all off-cluster dependencies must be
   * configured to be accessible without external IP addresses.
   * </pre>
   *
   * <code>optional bool internal_ip_only = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The internalIpOnly.
   */
  @java.lang.Override
  public boolean getInternalIpOnly() {
    return internalIpOnly_;
  }

  public static final int PRIVATE_IPV6_GOOGLE_ACCESS_FIELD_NUMBER = 12;
  private int privateIpv6GoogleAccess_ = 0;
  /**
   *
   *
   * <pre>
   * Optional. The type of IPv6 access for a cluster.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.GceClusterConfig.PrivateIpv6GoogleAccess private_ipv6_google_access = 12 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The enum numeric value on the wire for privateIpv6GoogleAccess.
   */
  @java.lang.Override
  public int getPrivateIpv6GoogleAccessValue() {
    return privateIpv6GoogleAccess_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The type of IPv6 access for a cluster.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.GceClusterConfig.PrivateIpv6GoogleAccess private_ipv6_google_access = 12 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The privateIpv6GoogleAccess.
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.GceClusterConfig.PrivateIpv6GoogleAccess
      getPrivateIpv6GoogleAccess() {
    com.google.cloud.dataproc.v1.GceClusterConfig.PrivateIpv6GoogleAccess result =
        com.google.cloud.dataproc.v1.GceClusterConfig.PrivateIpv6GoogleAccess.forNumber(
            privateIpv6GoogleAccess_);
    return result == null
        ? com.google.cloud.dataproc.v1.GceClusterConfig.PrivateIpv6GoogleAccess.UNRECOGNIZED
        : result;
  }

  public static final int SERVICE_ACCOUNT_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private volatile java.lang.Object serviceAccount_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The [Dataproc service
   * account](https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/service-accounts#service_accounts_in_dataproc)
   * (also see [VM Data Plane
   * identity](https://cloud.google.com/dataproc/docs/concepts/iam/dataproc-principals#vm_service_account_data_plane_identity))
   * used by Dataproc cluster VM instances to access Google Cloud Platform
   * services.
   *
   * If not specified, the
   * [Compute Engine default service
   * account](https://cloud.google.com/compute/docs/access/service-accounts#default_service_account)
   * is used.
   * </pre>
   *
   * <code>string service_account = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The serviceAccount.
   */
  @java.lang.Override
  public java.lang.String getServiceAccount() {
    java.lang.Object ref = serviceAccount_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      serviceAccount_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The [Dataproc service
   * account](https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/service-accounts#service_accounts_in_dataproc)
   * (also see [VM Data Plane
   * identity](https://cloud.google.com/dataproc/docs/concepts/iam/dataproc-principals#vm_service_account_data_plane_identity))
   * used by Dataproc cluster VM instances to access Google Cloud Platform
   * services.
   *
   * If not specified, the
   * [Compute Engine default service
   * account](https://cloud.google.com/compute/docs/access/service-accounts#default_service_account)
   * is used.
   * </pre>
   *
   * <code>string service_account = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for serviceAccount.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getServiceAccountBytes() {
    java.lang.Object ref = serviceAccount_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      serviceAccount_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SERVICE_ACCOUNT_SCOPES_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList serviceAccountScopes_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Optional. The URIs of service account scopes to be included in
   * Compute Engine instances. The following base set of scopes is always
   * included:
   *
   * * https://www.googleapis.com/auth/cloud.useraccounts.readonly
   * * https://www.googleapis.com/auth/devstorage.read_write
   * * https://www.googleapis.com/auth/logging.write
   *
   * If no scopes are specified, the following defaults are also provided:
   *
   * * https://www.googleapis.com/auth/bigquery
   * * https://www.googleapis.com/auth/bigtable.admin.table
   * * https://www.googleapis.com/auth/bigtable.data
   * * https://www.googleapis.com/auth/devstorage.full_control
   * </pre>
   *
   * <code>repeated string service_account_scopes = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return A list containing the serviceAccountScopes.
   */
  public com.google.protobuf.ProtocolStringList getServiceAccountScopesList() {
    return serviceAccountScopes_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The URIs of service account scopes to be included in
   * Compute Engine instances. The following base set of scopes is always
   * included:
   *
   * * https://www.googleapis.com/auth/cloud.useraccounts.readonly
   * * https://www.googleapis.com/auth/devstorage.read_write
   * * https://www.googleapis.com/auth/logging.write
   *
   * If no scopes are specified, the following defaults are also provided:
   *
   * * https://www.googleapis.com/auth/bigquery
   * * https://www.googleapis.com/auth/bigtable.admin.table
   * * https://www.googleapis.com/auth/bigtable.data
   * * https://www.googleapis.com/auth/devstorage.full_control
   * </pre>
   *
   * <code>repeated string service_account_scopes = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The count of serviceAccountScopes.
   */
  public int getServiceAccountScopesCount() {
    return serviceAccountScopes_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. The URIs of service account scopes to be included in
   * Compute Engine instances. The following base set of scopes is always
   * included:
   *
   * * https://www.googleapis.com/auth/cloud.useraccounts.readonly
   * * https://www.googleapis.com/auth/devstorage.read_write
   * * https://www.googleapis.com/auth/logging.write
   *
   * If no scopes are specified, the following defaults are also provided:
   *
   * * https://www.googleapis.com/auth/bigquery
   * * https://www.googleapis.com/auth/bigtable.admin.table
   * * https://www.googleapis.com/auth/bigtable.data
   * * https://www.googleapis.com/auth/devstorage.full_control
   * </pre>
   *
   * <code>repeated string service_account_scopes = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @param index The index of the element to return.
   * @return The serviceAccountScopes at the given index.
   */
  public java.lang.String getServiceAccountScopes(int index) {
    return serviceAccountScopes_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. The URIs of service account scopes to be included in
   * Compute Engine instances. The following base set of scopes is always
   * included:
   *
   * * https://www.googleapis.com/auth/cloud.useraccounts.readonly
   * * https://www.googleapis.com/auth/devstorage.read_write
   * * https://www.googleapis.com/auth/logging.write
   *
   * If no scopes are specified, the following defaults are also provided:
   *
   * * https://www.googleapis.com/auth/bigquery
   * * https://www.googleapis.com/auth/bigtable.admin.table
   * * https://www.googleapis.com/auth/bigtable.data
   * * https://www.googleapis.com/auth/devstorage.full_control
   * </pre>
   *
   * <code>repeated string service_account_scopes = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the serviceAccountScopes at the given index.
   */
  public com.google.protobuf.ByteString getServiceAccountScopesBytes(int index) {
    return serviceAccountScopes_.getByteString(index);
  }

  public static final int TAGS_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList tags_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * The Compute Engine tags to add to all instances (see [Tagging
   * instances](https://cloud.google.com/compute/docs/label-or-tag-resources#tags)).
   * </pre>
   *
   * <code>repeated string tags = 4;</code>
   *
   * @return A list containing the tags.
   */
  public com.google.protobuf.ProtocolStringList getTagsList() {
    return tags_;
  }
  /**
   *
   *
   * <pre>
   * The Compute Engine tags to add to all instances (see [Tagging
   * instances](https://cloud.google.com/compute/docs/label-or-tag-resources#tags)).
   * </pre>
   *
   * <code>repeated string tags = 4;</code>
   *
   * @return The count of tags.
   */
  public int getTagsCount() {
    return tags_.size();
  }
  /**
   *
   *
   * <pre>
   * The Compute Engine tags to add to all instances (see [Tagging
   * instances](https://cloud.google.com/compute/docs/label-or-tag-resources#tags)).
   * </pre>
   *
   * <code>repeated string tags = 4;</code>
   *
   * @param index The index of the element to return.
   * @return The tags at the given index.
   */
  public java.lang.String getTags(int index) {
    return tags_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The Compute Engine tags to add to all instances (see [Tagging
   * instances](https://cloud.google.com/compute/docs/label-or-tag-resources#tags)).
   * </pre>
   *
   * <code>repeated string tags = 4;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the tags at the given index.
   */
  public com.google.protobuf.ByteString getTagsBytes(int index) {
    return tags_.getByteString(index);
  }

  public static final int METADATA_FIELD_NUMBER = 5;

  private static final class MetadataDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.dataproc.v1.ClustersProto
                .internal_static_google_cloud_dataproc_v1_GceClusterConfig_MetadataEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> metadata_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetMetadata() {
    if (metadata_ == null) {
      return com.google.protobuf.MapField.emptyMapField(MetadataDefaultEntryHolder.defaultEntry);
    }
    return metadata_;
  }

  public int getMetadataCount() {
    return internalGetMetadata().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Optional. The Compute Engine metadata entries to add to all instances (see
   * [Project and instance
   * metadata](https://cloud.google.com/compute/docs/storing-retrieving-metadata#project_and_instance_metadata)).
   * </pre>
   *
   * <code>map&lt;string, string&gt; metadata = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public boolean containsMetadata(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetMetadata().getMap().containsKey(key);
  }
  /** Use {@link #getMetadataMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getMetadata() {
    return getMetadataMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. The Compute Engine metadata entries to add to all instances (see
   * [Project and instance
   * metadata](https://cloud.google.com/compute/docs/storing-retrieving-metadata#project_and_instance_metadata)).
   * </pre>
   *
   * <code>map&lt;string, string&gt; metadata = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getMetadataMap() {
    return internalGetMetadata().getMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. The Compute Engine metadata entries to add to all instances (see
   * [Project and instance
   * metadata](https://cloud.google.com/compute/docs/storing-retrieving-metadata#project_and_instance_metadata)).
   * </pre>
   *
   * <code>map&lt;string, string&gt; metadata = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getMetadataOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetMetadata().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Optional. The Compute Engine metadata entries to add to all instances (see
   * [Project and instance
   * metadata](https://cloud.google.com/compute/docs/storing-retrieving-metadata#project_and_instance_metadata)).
   * </pre>
   *
   * <code>map&lt;string, string&gt; metadata = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public java.lang.String getMetadataOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetMetadata().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int RESERVATION_AFFINITY_FIELD_NUMBER = 11;
  private com.google.cloud.dataproc.v1.ReservationAffinity reservationAffinity_;
  /**
   *
   *
   * <pre>
   * Optional. Reservation Affinity for consuming Zonal reservation.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.ReservationAffinity reservation_affinity = 11 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the reservationAffinity field is set.
   */
  @java.lang.Override
  public boolean hasReservationAffinity() {
    return reservationAffinity_ != null;
  }
  /**
   *
   *
   * <pre>
   * Optional. Reservation Affinity for consuming Zonal reservation.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.ReservationAffinity reservation_affinity = 11 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The reservationAffinity.
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.ReservationAffinity getReservationAffinity() {
    return reservationAffinity_ == null
        ? com.google.cloud.dataproc.v1.ReservationAffinity.getDefaultInstance()
        : reservationAffinity_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Reservation Affinity for consuming Zonal reservation.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.ReservationAffinity reservation_affinity = 11 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.ReservationAffinityOrBuilder
      getReservationAffinityOrBuilder() {
    return reservationAffinity_ == null
        ? com.google.cloud.dataproc.v1.ReservationAffinity.getDefaultInstance()
        : reservationAffinity_;
  }

  public static final int NODE_GROUP_AFFINITY_FIELD_NUMBER = 13;
  private com.google.cloud.dataproc.v1.NodeGroupAffinity nodeGroupAffinity_;
  /**
   *
   *
   * <pre>
   * Optional. Node Group Affinity for sole-tenant clusters.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.NodeGroupAffinity node_group_affinity = 13 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the nodeGroupAffinity field is set.
   */
  @java.lang.Override
  public boolean hasNodeGroupAffinity() {
    return nodeGroupAffinity_ != null;
  }
  /**
   *
   *
   * <pre>
   * Optional. Node Group Affinity for sole-tenant clusters.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.NodeGroupAffinity node_group_affinity = 13 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The nodeGroupAffinity.
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.NodeGroupAffinity getNodeGroupAffinity() {
    return nodeGroupAffinity_ == null
        ? com.google.cloud.dataproc.v1.NodeGroupAffinity.getDefaultInstance()
        : nodeGroupAffinity_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Node Group Affinity for sole-tenant clusters.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.NodeGroupAffinity node_group_affinity = 13 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.NodeGroupAffinityOrBuilder getNodeGroupAffinityOrBuilder() {
    return nodeGroupAffinity_ == null
        ? com.google.cloud.dataproc.v1.NodeGroupAffinity.getDefaultInstance()
        : nodeGroupAffinity_;
  }

  public static final int SHIELDED_INSTANCE_CONFIG_FIELD_NUMBER = 14;
  private com.google.cloud.dataproc.v1.ShieldedInstanceConfig shieldedInstanceConfig_;
  /**
   *
   *
   * <pre>
   * Optional. Shielded Instance Config for clusters using [Compute Engine
   * Shielded
   * VMs](https://cloud.google.com/security/shielded-cloud/shielded-vm).
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.ShieldedInstanceConfig shielded_instance_config = 14 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the shieldedInstanceConfig field is set.
   */
  @java.lang.Override
  public boolean hasShieldedInstanceConfig() {
    return shieldedInstanceConfig_ != null;
  }
  /**
   *
   *
   * <pre>
   * Optional. Shielded Instance Config for clusters using [Compute Engine
   * Shielded
   * VMs](https://cloud.google.com/security/shielded-cloud/shielded-vm).
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.ShieldedInstanceConfig shielded_instance_config = 14 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The shieldedInstanceConfig.
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.ShieldedInstanceConfig getShieldedInstanceConfig() {
    return shieldedInstanceConfig_ == null
        ? com.google.cloud.dataproc.v1.ShieldedInstanceConfig.getDefaultInstance()
        : shieldedInstanceConfig_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Shielded Instance Config for clusters using [Compute Engine
   * Shielded
   * VMs](https://cloud.google.com/security/shielded-cloud/shielded-vm).
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.ShieldedInstanceConfig shielded_instance_config = 14 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.ShieldedInstanceConfigOrBuilder
      getShieldedInstanceConfigOrBuilder() {
    return shieldedInstanceConfig_ == null
        ? com.google.cloud.dataproc.v1.ShieldedInstanceConfig.getDefaultInstance()
        : shieldedInstanceConfig_;
  }

  public static final int CONFIDENTIAL_INSTANCE_CONFIG_FIELD_NUMBER = 15;
  private com.google.cloud.dataproc.v1.ConfidentialInstanceConfig confidentialInstanceConfig_;
  /**
   *
   *
   * <pre>
   * Optional. Confidential Instance Config for clusters using [Confidential
   * VMs](https://cloud.google.com/compute/confidential-vm/docs).
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.ConfidentialInstanceConfig confidential_instance_config = 15 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the confidentialInstanceConfig field is set.
   */
  @java.lang.Override
  public boolean hasConfidentialInstanceConfig() {
    return confidentialInstanceConfig_ != null;
  }
  /**
   *
   *
   * <pre>
   * Optional. Confidential Instance Config for clusters using [Confidential
   * VMs](https://cloud.google.com/compute/confidential-vm/docs).
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.ConfidentialInstanceConfig confidential_instance_config = 15 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The confidentialInstanceConfig.
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.ConfidentialInstanceConfig getConfidentialInstanceConfig() {
    return confidentialInstanceConfig_ == null
        ? com.google.cloud.dataproc.v1.ConfidentialInstanceConfig.getDefaultInstance()
        : confidentialInstanceConfig_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Confidential Instance Config for clusters using [Confidential
   * VMs](https://cloud.google.com/compute/confidential-vm/docs).
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.ConfidentialInstanceConfig confidential_instance_config = 15 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.ConfidentialInstanceConfigOrBuilder
      getConfidentialInstanceConfigOrBuilder() {
    return confidentialInstanceConfig_ == null
        ? com.google.cloud.dataproc.v1.ConfidentialInstanceConfig.getDefaultInstance()
        : confidentialInstanceConfig_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(zoneUri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, zoneUri_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(networkUri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, networkUri_);
    }
    for (int i = 0; i < serviceAccountScopes_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 3, serviceAccountScopes_.getRaw(i));
    }
    for (int i = 0; i < tags_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, tags_.getRaw(i));
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetMetadata(), MetadataDefaultEntryHolder.defaultEntry, 5);
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(subnetworkUri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, subnetworkUri_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeBool(7, internalIpOnly_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceAccount_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, serviceAccount_);
    }
    if (reservationAffinity_ != null) {
      output.writeMessage(11, getReservationAffinity());
    }
    if (privateIpv6GoogleAccess_
        != com.google.cloud.dataproc.v1.GceClusterConfig.PrivateIpv6GoogleAccess
            .PRIVATE_IPV6_GOOGLE_ACCESS_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(12, privateIpv6GoogleAccess_);
    }
    if (nodeGroupAffinity_ != null) {
      output.writeMessage(13, getNodeGroupAffinity());
    }
    if (shieldedInstanceConfig_ != null) {
      output.writeMessage(14, getShieldedInstanceConfig());
    }
    if (confidentialInstanceConfig_ != null) {
      output.writeMessage(15, getConfidentialInstanceConfig());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(zoneUri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, zoneUri_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(networkUri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, networkUri_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < serviceAccountScopes_.size(); i++) {
        dataSize += computeStringSizeNoTag(serviceAccountScopes_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getServiceAccountScopesList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < tags_.size(); i++) {
        dataSize += computeStringSizeNoTag(tags_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getTagsList().size();
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetMetadata().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> metadata__ =
          MetadataDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, metadata__);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(subnetworkUri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, subnetworkUri_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(7, internalIpOnly_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceAccount_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, serviceAccount_);
    }
    if (reservationAffinity_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(11, getReservationAffinity());
    }
    if (privateIpv6GoogleAccess_
        != com.google.cloud.dataproc.v1.GceClusterConfig.PrivateIpv6GoogleAccess
            .PRIVATE_IPV6_GOOGLE_ACCESS_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(12, privateIpv6GoogleAccess_);
    }
    if (nodeGroupAffinity_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(13, getNodeGroupAffinity());
    }
    if (shieldedInstanceConfig_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(14, getShieldedInstanceConfig());
    }
    if (confidentialInstanceConfig_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              15, getConfidentialInstanceConfig());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dataproc.v1.GceClusterConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.dataproc.v1.GceClusterConfig other =
        (com.google.cloud.dataproc.v1.GceClusterConfig) obj;

    if (!getZoneUri().equals(other.getZoneUri())) return false;
    if (!getNetworkUri().equals(other.getNetworkUri())) return false;
    if (!getSubnetworkUri().equals(other.getSubnetworkUri())) return false;
    if (hasInternalIpOnly() != other.hasInternalIpOnly()) return false;
    if (hasInternalIpOnly()) {
      if (getInternalIpOnly() != other.getInternalIpOnly()) return false;
    }
    if (privateIpv6GoogleAccess_ != other.privateIpv6GoogleAccess_) return false;
    if (!getServiceAccount().equals(other.getServiceAccount())) return false;
    if (!getServiceAccountScopesList().equals(other.getServiceAccountScopesList())) return false;
    if (!getTagsList().equals(other.getTagsList())) return false;
    if (!internalGetMetadata().equals(other.internalGetMetadata())) return false;
    if (hasReservationAffinity() != other.hasReservationAffinity()) return false;
    if (hasReservationAffinity()) {
      if (!getReservationAffinity().equals(other.getReservationAffinity())) return false;
    }
    if (hasNodeGroupAffinity() != other.hasNodeGroupAffinity()) return false;
    if (hasNodeGroupAffinity()) {
      if (!getNodeGroupAffinity().equals(other.getNodeGroupAffinity())) return false;
    }
    if (hasShieldedInstanceConfig() != other.hasShieldedInstanceConfig()) return false;
    if (hasShieldedInstanceConfig()) {
      if (!getShieldedInstanceConfig().equals(other.getShieldedInstanceConfig())) return false;
    }
    if (hasConfidentialInstanceConfig() != other.hasConfidentialInstanceConfig()) return false;
    if (hasConfidentialInstanceConfig()) {
      if (!getConfidentialInstanceConfig().equals(other.getConfidentialInstanceConfig()))
        return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + ZONE_URI_FIELD_NUMBER;
    hash = (53 * hash) + getZoneUri().hashCode();
    hash = (37 * hash) + NETWORK_URI_FIELD_NUMBER;
    hash = (53 * hash) + getNetworkUri().hashCode();
    hash = (37 * hash) + SUBNETWORK_URI_FIELD_NUMBER;
    hash = (53 * hash) + getSubnetworkUri().hashCode();
    if (hasInternalIpOnly()) {
      hash = (37 * hash) + INTERNAL_IP_ONLY_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getInternalIpOnly());
    }
    hash = (37 * hash) + PRIVATE_IPV6_GOOGLE_ACCESS_FIELD_NUMBER;
    hash = (53 * hash) + privateIpv6GoogleAccess_;
    hash = (37 * hash) + SERVICE_ACCOUNT_FIELD_NUMBER;
    hash = (53 * hash) + getServiceAccount().hashCode();
    if (getServiceAccountScopesCount() > 0) {
      hash = (37 * hash) + SERVICE_ACCOUNT_SCOPES_FIELD_NUMBER;
      hash = (53 * hash) + getServiceAccountScopesList().hashCode();
    }
    if (getTagsCount() > 0) {
      hash = (37 * hash) + TAGS_FIELD_NUMBER;
      hash = (53 * hash) + getTagsList().hashCode();
    }
    if (!internalGetMetadata().getMap().isEmpty()) {
      hash = (37 * hash) + METADATA_FIELD_NUMBER;
      hash = (53 * hash) + internalGetMetadata().hashCode();
    }
    if (hasReservationAffinity()) {
      hash = (37 * hash) + RESERVATION_AFFINITY_FIELD_NUMBER;
      hash = (53 * hash) + getReservationAffinity().hashCode();
    }
    if (hasNodeGroupAffinity()) {
      hash = (37 * hash) + NODE_GROUP_AFFINITY_FIELD_NUMBER;
      hash = (53 * hash) + getNodeGroupAffinity().hashCode();
    }
    if (hasShieldedInstanceConfig()) {
      hash = (37 * hash) + SHIELDED_INSTANCE_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getShieldedInstanceConfig().hashCode();
    }
    if (hasConfidentialInstanceConfig()) {
      hash = (37 * hash) + CONFIDENTIAL_INSTANCE_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getConfidentialInstanceConfig().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dataproc.v1.GceClusterConfig parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1.GceClusterConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.GceClusterConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1.GceClusterConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.GceClusterConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1.GceClusterConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.GceClusterConfig parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1.GceClusterConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.GceClusterConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1.GceClusterConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.GceClusterConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1.GceClusterConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.dataproc.v1.GceClusterConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Common config settings for resources of Compute Engine cluster
   * instances, applicable to all instances in the cluster.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dataproc.v1.GceClusterConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dataproc.v1.GceClusterConfig)
      com.google.cloud.dataproc.v1.GceClusterConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dataproc.v1.ClustersProto
          .internal_static_google_cloud_dataproc_v1_GceClusterConfig_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 5:
          return internalGetMetadata();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 5:
          return internalGetMutableMetadata();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dataproc.v1.ClustersProto
          .internal_static_google_cloud_dataproc_v1_GceClusterConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dataproc.v1.GceClusterConfig.class,
              com.google.cloud.dataproc.v1.GceClusterConfig.Builder.class);
    }

    // Construct using com.google.cloud.dataproc.v1.GceClusterConfig.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      zoneUri_ = "";
      networkUri_ = "";
      subnetworkUri_ = "";
      internalIpOnly_ = false;
      privateIpv6GoogleAccess_ = 0;
      serviceAccount_ = "";
      serviceAccountScopes_ = com.google.protobuf.LazyStringArrayList.emptyList();
      tags_ = com.google.protobuf.LazyStringArrayList.emptyList();
      internalGetMutableMetadata().clear();
      reservationAffinity_ = null;
      if (reservationAffinityBuilder_ != null) {
        reservationAffinityBuilder_.dispose();
        reservationAffinityBuilder_ = null;
      }
      nodeGroupAffinity_ = null;
      if (nodeGroupAffinityBuilder_ != null) {
        nodeGroupAffinityBuilder_.dispose();
        nodeGroupAffinityBuilder_ = null;
      }
      shieldedInstanceConfig_ = null;
      if (shieldedInstanceConfigBuilder_ != null) {
        shieldedInstanceConfigBuilder_.dispose();
        shieldedInstanceConfigBuilder_ = null;
      }
      confidentialInstanceConfig_ = null;
      if (confidentialInstanceConfigBuilder_ != null) {
        confidentialInstanceConfigBuilder_.dispose();
        confidentialInstanceConfigBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dataproc.v1.ClustersProto
          .internal_static_google_cloud_dataproc_v1_GceClusterConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.GceClusterConfig getDefaultInstanceForType() {
      return com.google.cloud.dataproc.v1.GceClusterConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.GceClusterConfig build() {
      com.google.cloud.dataproc.v1.GceClusterConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.GceClusterConfig buildPartial() {
      com.google.cloud.dataproc.v1.GceClusterConfig result =
          new com.google.cloud.dataproc.v1.GceClusterConfig(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.dataproc.v1.GceClusterConfig result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.zoneUri_ = zoneUri_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.networkUri_ = networkUri_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.subnetworkUri_ = subnetworkUri_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.internalIpOnly_ = internalIpOnly_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.privateIpv6GoogleAccess_ = privateIpv6GoogleAccess_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.serviceAccount_ = serviceAccount_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        serviceAccountScopes_.makeImmutable();
        result.serviceAccountScopes_ = serviceAccountScopes_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        tags_.makeImmutable();
        result.tags_ = tags_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.metadata_ = internalGetMetadata();
        result.metadata_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.reservationAffinity_ =
            reservationAffinityBuilder_ == null
                ? reservationAffinity_
                : reservationAffinityBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.nodeGroupAffinity_ =
            nodeGroupAffinityBuilder_ == null
                ? nodeGroupAffinity_
                : nodeGroupAffinityBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.shieldedInstanceConfig_ =
            shieldedInstanceConfigBuilder_ == null
                ? shieldedInstanceConfig_
                : shieldedInstanceConfigBuilder_.build();
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.confidentialInstanceConfig_ =
            confidentialInstanceConfigBuilder_ == null
                ? confidentialInstanceConfig_
                : confidentialInstanceConfigBuilder_.build();
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dataproc.v1.GceClusterConfig) {
        return mergeFrom((com.google.cloud.dataproc.v1.GceClusterConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dataproc.v1.GceClusterConfig other) {
      if (other == com.google.cloud.dataproc.v1.GceClusterConfig.getDefaultInstance()) return this;
      if (!other.getZoneUri().isEmpty()) {
        zoneUri_ = other.zoneUri_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getNetworkUri().isEmpty()) {
        networkUri_ = other.networkUri_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getSubnetworkUri().isEmpty()) {
        subnetworkUri_ = other.subnetworkUri_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasInternalIpOnly()) {
        setInternalIpOnly(other.getInternalIpOnly());
      }
      if (other.privateIpv6GoogleAccess_ != 0) {
        setPrivateIpv6GoogleAccessValue(other.getPrivateIpv6GoogleAccessValue());
      }
      if (!other.getServiceAccount().isEmpty()) {
        serviceAccount_ = other.serviceAccount_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (!other.serviceAccountScopes_.isEmpty()) {
        if (serviceAccountScopes_.isEmpty()) {
          serviceAccountScopes_ = other.serviceAccountScopes_;
          bitField0_ |= 0x00000040;
        } else {
          ensureServiceAccountScopesIsMutable();
          serviceAccountScopes_.addAll(other.serviceAccountScopes_);
        }
        onChanged();
      }
      if (!other.tags_.isEmpty()) {
        if (tags_.isEmpty()) {
          tags_ = other.tags_;
          bitField0_ |= 0x00000080;
        } else {
          ensureTagsIsMutable();
          tags_.addAll(other.tags_);
        }
        onChanged();
      }
      internalGetMutableMetadata().mergeFrom(other.internalGetMetadata());
      bitField0_ |= 0x00000100;
      if (other.hasReservationAffinity()) {
        mergeReservationAffinity(other.getReservationAffinity());
      }
      if (other.hasNodeGroupAffinity()) {
        mergeNodeGroupAffinity(other.getNodeGroupAffinity());
      }
      if (other.hasShieldedInstanceConfig()) {
        mergeShieldedInstanceConfig(other.getShieldedInstanceConfig());
      }
      if (other.hasConfidentialInstanceConfig()) {
        mergeConfidentialInstanceConfig(other.getConfidentialInstanceConfig());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                zoneUri_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                networkUri_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureServiceAccountScopesIsMutable();
                serviceAccountScopes_.add(s);
                break;
              } // case 26
            case 34:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureTagsIsMutable();
                tags_.add(s);
                break;
              } // case 34
            case 42:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> metadata__ =
                    input.readMessage(
                        MetadataDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableMetadata()
                    .getMutableMap()
                    .put(metadata__.getKey(), metadata__.getValue());
                bitField0_ |= 0x00000100;
                break;
              } // case 42
            case 50:
              {
                subnetworkUri_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 50
            case 56:
              {
                internalIpOnly_ = input.readBool();
                bitField0_ |= 0x00000008;
                break;
              } // case 56
            case 66:
              {
                serviceAccount_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 66
            case 90:
              {
                input.readMessage(
                    getReservationAffinityFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000200;
                break;
              } // case 90
            case 96:
              {
                privateIpv6GoogleAccess_ = input.readEnum();
                bitField0_ |= 0x00000010;
                break;
              } // case 96
            case 106:
              {
                input.readMessage(
                    getNodeGroupAffinityFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000400;
                break;
              } // case 106
            case 114:
              {
                input.readMessage(
                    getShieldedInstanceConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000800;
                break;
              } // case 114
            case 122:
              {
                input.readMessage(
                    getConfidentialInstanceConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00001000;
                break;
              } // case 122
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object zoneUri_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The Compute Engine zone where the Dataproc cluster will be
     * located. If omitted, the service will pick a zone in the cluster's Compute
     * Engine region. On a get request, zone will always be present.
     *
     * A full URL, partial URI, or short name are valid. Examples:
     *
     * * `https://www.googleapis.com/compute/v1/projects/[project_id]/zones/[zone]`
     * * `projects/[project_id]/zones/[zone]`
     * * `[zone]`
     * </pre>
     *
     * <code>string zone_uri = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The zoneUri.
     */
    public java.lang.String getZoneUri() {
      java.lang.Object ref = zoneUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        zoneUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The Compute Engine zone where the Dataproc cluster will be
     * located. If omitted, the service will pick a zone in the cluster's Compute
     * Engine region. On a get request, zone will always be present.
     *
     * A full URL, partial URI, or short name are valid. Examples:
     *
     * * `https://www.googleapis.com/compute/v1/projects/[project_id]/zones/[zone]`
     * * `projects/[project_id]/zones/[zone]`
     * * `[zone]`
     * </pre>
     *
     * <code>string zone_uri = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for zoneUri.
     */
    public com.google.protobuf.ByteString getZoneUriBytes() {
      java.lang.Object ref = zoneUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        zoneUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The Compute Engine zone where the Dataproc cluster will be
     * located. If omitted, the service will pick a zone in the cluster's Compute
     * Engine region. On a get request, zone will always be present.
     *
     * A full URL, partial URI, or short name are valid. Examples:
     *
     * * `https://www.googleapis.com/compute/v1/projects/[project_id]/zones/[zone]`
     * * `projects/[project_id]/zones/[zone]`
     * * `[zone]`
     * </pre>
     *
     * <code>string zone_uri = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The zoneUri to set.
     * @return This builder for chaining.
     */
    public Builder setZoneUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      zoneUri_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The Compute Engine zone where the Dataproc cluster will be
     * located. If omitted, the service will pick a zone in the cluster's Compute
     * Engine region. On a get request, zone will always be present.
     *
     * A full URL, partial URI, or short name are valid. Examples:
     *
     * * `https://www.googleapis.com/compute/v1/projects/[project_id]/zones/[zone]`
     * * `projects/[project_id]/zones/[zone]`
     * * `[zone]`
     * </pre>
     *
     * <code>string zone_uri = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearZoneUri() {
      zoneUri_ = getDefaultInstance().getZoneUri();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The Compute Engine zone where the Dataproc cluster will be
     * located. If omitted, the service will pick a zone in the cluster's Compute
     * Engine region. On a get request, zone will always be present.
     *
     * A full URL, partial URI, or short name are valid. Examples:
     *
     * * `https://www.googleapis.com/compute/v1/projects/[project_id]/zones/[zone]`
     * * `projects/[project_id]/zones/[zone]`
     * * `[zone]`
     * </pre>
     *
     * <code>string zone_uri = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for zoneUri to set.
     * @return This builder for chaining.
     */
    public Builder setZoneUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      zoneUri_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object networkUri_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The Compute Engine network to be used for machine
     * communications. Cannot be specified with subnetwork_uri. If neither
     * `network_uri` nor `subnetwork_uri` is specified, the "default" network of
     * the project is used, if it exists. Cannot be a "Custom Subnet Network" (see
     * [Using Subnetworks](https://cloud.google.com/compute/docs/subnetworks) for
     * more information).
     *
     * A full URL, partial URI, or short name are valid. Examples:
     *
     * * `https://www.googleapis.com/compute/v1/projects/[project_id]/global/networks/default`
     * * `projects/[project_id]/global/networks/default`
     * * `default`
     * </pre>
     *
     * <code>string network_uri = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The networkUri.
     */
    public java.lang.String getNetworkUri() {
      java.lang.Object ref = networkUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        networkUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The Compute Engine network to be used for machine
     * communications. Cannot be specified with subnetwork_uri. If neither
     * `network_uri` nor `subnetwork_uri` is specified, the "default" network of
     * the project is used, if it exists. Cannot be a "Custom Subnet Network" (see
     * [Using Subnetworks](https://cloud.google.com/compute/docs/subnetworks) for
     * more information).
     *
     * A full URL, partial URI, or short name are valid. Examples:
     *
     * * `https://www.googleapis.com/compute/v1/projects/[project_id]/global/networks/default`
     * * `projects/[project_id]/global/networks/default`
     * * `default`
     * </pre>
     *
     * <code>string network_uri = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for networkUri.
     */
    public com.google.protobuf.ByteString getNetworkUriBytes() {
      java.lang.Object ref = networkUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        networkUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The Compute Engine network to be used for machine
     * communications. Cannot be specified with subnetwork_uri. If neither
     * `network_uri` nor `subnetwork_uri` is specified, the "default" network of
     * the project is used, if it exists. Cannot be a "Custom Subnet Network" (see
     * [Using Subnetworks](https://cloud.google.com/compute/docs/subnetworks) for
     * more information).
     *
     * A full URL, partial URI, or short name are valid. Examples:
     *
     * * `https://www.googleapis.com/compute/v1/projects/[project_id]/global/networks/default`
     * * `projects/[project_id]/global/networks/default`
     * * `default`
     * </pre>
     *
     * <code>string network_uri = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The networkUri to set.
     * @return This builder for chaining.
     */
    public Builder setNetworkUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      networkUri_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The Compute Engine network to be used for machine
     * communications. Cannot be specified with subnetwork_uri. If neither
     * `network_uri` nor `subnetwork_uri` is specified, the "default" network of
     * the project is used, if it exists. Cannot be a "Custom Subnet Network" (see
     * [Using Subnetworks](https://cloud.google.com/compute/docs/subnetworks) for
     * more information).
     *
     * A full URL, partial URI, or short name are valid. Examples:
     *
     * * `https://www.googleapis.com/compute/v1/projects/[project_id]/global/networks/default`
     * * `projects/[project_id]/global/networks/default`
     * * `default`
     * </pre>
     *
     * <code>string network_uri = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNetworkUri() {
      networkUri_ = getDefaultInstance().getNetworkUri();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The Compute Engine network to be used for machine
     * communications. Cannot be specified with subnetwork_uri. If neither
     * `network_uri` nor `subnetwork_uri` is specified, the "default" network of
     * the project is used, if it exists. Cannot be a "Custom Subnet Network" (see
     * [Using Subnetworks](https://cloud.google.com/compute/docs/subnetworks) for
     * more information).
     *
     * A full URL, partial URI, or short name are valid. Examples:
     *
     * * `https://www.googleapis.com/compute/v1/projects/[project_id]/global/networks/default`
     * * `projects/[project_id]/global/networks/default`
     * * `default`
     * </pre>
     *
     * <code>string network_uri = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for networkUri to set.
     * @return This builder for chaining.
     */
    public Builder setNetworkUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      networkUri_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object subnetworkUri_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The Compute Engine subnetwork to be used for machine
     * communications. Cannot be specified with network_uri.
     *
     * A full URL, partial URI, or short name are valid. Examples:
     *
     * * `https://www.googleapis.com/compute/v1/projects/[project_id]/regions/[region]/subnetworks/sub0`
     * * `projects/[project_id]/regions/[region]/subnetworks/sub0`
     * * `sub0`
     * </pre>
     *
     * <code>string subnetwork_uri = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The subnetworkUri.
     */
    public java.lang.String getSubnetworkUri() {
      java.lang.Object ref = subnetworkUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        subnetworkUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The Compute Engine subnetwork to be used for machine
     * communications. Cannot be specified with network_uri.
     *
     * A full URL, partial URI, or short name are valid. Examples:
     *
     * * `https://www.googleapis.com/compute/v1/projects/[project_id]/regions/[region]/subnetworks/sub0`
     * * `projects/[project_id]/regions/[region]/subnetworks/sub0`
     * * `sub0`
     * </pre>
     *
     * <code>string subnetwork_uri = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for subnetworkUri.
     */
    public com.google.protobuf.ByteString getSubnetworkUriBytes() {
      java.lang.Object ref = subnetworkUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        subnetworkUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The Compute Engine subnetwork to be used for machine
     * communications. Cannot be specified with network_uri.
     *
     * A full URL, partial URI, or short name are valid. Examples:
     *
     * * `https://www.googleapis.com/compute/v1/projects/[project_id]/regions/[region]/subnetworks/sub0`
     * * `projects/[project_id]/regions/[region]/subnetworks/sub0`
     * * `sub0`
     * </pre>
     *
     * <code>string subnetwork_uri = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The subnetworkUri to set.
     * @return This builder for chaining.
     */
    public Builder setSubnetworkUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      subnetworkUri_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The Compute Engine subnetwork to be used for machine
     * communications. Cannot be specified with network_uri.
     *
     * A full URL, partial URI, or short name are valid. Examples:
     *
     * * `https://www.googleapis.com/compute/v1/projects/[project_id]/regions/[region]/subnetworks/sub0`
     * * `projects/[project_id]/regions/[region]/subnetworks/sub0`
     * * `sub0`
     * </pre>
     *
     * <code>string subnetwork_uri = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSubnetworkUri() {
      subnetworkUri_ = getDefaultInstance().getSubnetworkUri();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The Compute Engine subnetwork to be used for machine
     * communications. Cannot be specified with network_uri.
     *
     * A full URL, partial URI, or short name are valid. Examples:
     *
     * * `https://www.googleapis.com/compute/v1/projects/[project_id]/regions/[region]/subnetworks/sub0`
     * * `projects/[project_id]/regions/[region]/subnetworks/sub0`
     * * `sub0`
     * </pre>
     *
     * <code>string subnetwork_uri = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for subnetworkUri to set.
     * @return This builder for chaining.
     */
    public Builder setSubnetworkUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      subnetworkUri_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private boolean internalIpOnly_;
    /**
     *
     *
     * <pre>
     * Optional. If true, all instances in the cluster will only have internal IP
     * addresses. By default, clusters are not restricted to internal IP
     * addresses, and will have ephemeral external IP addresses assigned to each
     * instance. This `internal_ip_only` restriction can only be enabled for
     * subnetwork enabled networks, and all off-cluster dependencies must be
     * configured to be accessible without external IP addresses.
     * </pre>
     *
     * <code>optional bool internal_ip_only = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return Whether the internalIpOnly field is set.
     */
    @java.lang.Override
    public boolean hasInternalIpOnly() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. If true, all instances in the cluster will only have internal IP
     * addresses. By default, clusters are not restricted to internal IP
     * addresses, and will have ephemeral external IP addresses assigned to each
     * instance. This `internal_ip_only` restriction can only be enabled for
     * subnetwork enabled networks, and all off-cluster dependencies must be
     * configured to be accessible without external IP addresses.
     * </pre>
     *
     * <code>optional bool internal_ip_only = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The internalIpOnly.
     */
    @java.lang.Override
    public boolean getInternalIpOnly() {
      return internalIpOnly_;
    }
    /**
     *
     *
     * <pre>
     * Optional. If true, all instances in the cluster will only have internal IP
     * addresses. By default, clusters are not restricted to internal IP
     * addresses, and will have ephemeral external IP addresses assigned to each
     * instance. This `internal_ip_only` restriction can only be enabled for
     * subnetwork enabled networks, and all off-cluster dependencies must be
     * configured to be accessible without external IP addresses.
     * </pre>
     *
     * <code>optional bool internal_ip_only = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The internalIpOnly to set.
     * @return This builder for chaining.
     */
    public Builder setInternalIpOnly(boolean value) {

      internalIpOnly_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. If true, all instances in the cluster will only have internal IP
     * addresses. By default, clusters are not restricted to internal IP
     * addresses, and will have ephemeral external IP addresses assigned to each
     * instance. This `internal_ip_only` restriction can only be enabled for
     * subnetwork enabled networks, and all off-cluster dependencies must be
     * configured to be accessible without external IP addresses.
     * </pre>
     *
     * <code>optional bool internal_ip_only = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearInternalIpOnly() {
      bitField0_ = (bitField0_ & ~0x00000008);
      internalIpOnly_ = false;
      onChanged();
      return this;
    }

    private int privateIpv6GoogleAccess_ = 0;
    /**
     *
     *
     * <pre>
     * Optional. The type of IPv6 access for a cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.GceClusterConfig.PrivateIpv6GoogleAccess private_ipv6_google_access = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enum numeric value on the wire for privateIpv6GoogleAccess.
     */
    @java.lang.Override
    public int getPrivateIpv6GoogleAccessValue() {
      return privateIpv6GoogleAccess_;
    }
    /**
     *
     *
     * <pre>
     * Optional. The type of IPv6 access for a cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.GceClusterConfig.PrivateIpv6GoogleAccess private_ipv6_google_access = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The enum numeric value on the wire for privateIpv6GoogleAccess to set.
     * @return This builder for chaining.
     */
    public Builder setPrivateIpv6GoogleAccessValue(int value) {
      privateIpv6GoogleAccess_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The type of IPv6 access for a cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.GceClusterConfig.PrivateIpv6GoogleAccess private_ipv6_google_access = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The privateIpv6GoogleAccess.
     */
    @java.lang.Override
    public com.google.cloud.dataproc.v1.GceClusterConfig.PrivateIpv6GoogleAccess
        getPrivateIpv6GoogleAccess() {
      com.google.cloud.dataproc.v1.GceClusterConfig.PrivateIpv6GoogleAccess result =
          com.google.cloud.dataproc.v1.GceClusterConfig.PrivateIpv6GoogleAccess.forNumber(
              privateIpv6GoogleAccess_);
      return result == null
          ? com.google.cloud.dataproc.v1.GceClusterConfig.PrivateIpv6GoogleAccess.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Optional. The type of IPv6 access for a cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.GceClusterConfig.PrivateIpv6GoogleAccess private_ipv6_google_access = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The privateIpv6GoogleAccess to set.
     * @return This builder for chaining.
     */
    public Builder setPrivateIpv6GoogleAccess(
        com.google.cloud.dataproc.v1.GceClusterConfig.PrivateIpv6GoogleAccess value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000010;
      privateIpv6GoogleAccess_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The type of IPv6 access for a cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.GceClusterConfig.PrivateIpv6GoogleAccess private_ipv6_google_access = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPrivateIpv6GoogleAccess() {
      bitField0_ = (bitField0_ & ~0x00000010);
      privateIpv6GoogleAccess_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object serviceAccount_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The [Dataproc service
     * account](https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/service-accounts#service_accounts_in_dataproc)
     * (also see [VM Data Plane
     * identity](https://cloud.google.com/dataproc/docs/concepts/iam/dataproc-principals#vm_service_account_data_plane_identity))
     * used by Dataproc cluster VM instances to access Google Cloud Platform
     * services.
     *
     * If not specified, the
     * [Compute Engine default service
     * account](https://cloud.google.com/compute/docs/access/service-accounts#default_service_account)
     * is used.
     * </pre>
     *
     * <code>string service_account = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The serviceAccount.
     */
    public java.lang.String getServiceAccount() {
      java.lang.Object ref = serviceAccount_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        serviceAccount_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The [Dataproc service
     * account](https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/service-accounts#service_accounts_in_dataproc)
     * (also see [VM Data Plane
     * identity](https://cloud.google.com/dataproc/docs/concepts/iam/dataproc-principals#vm_service_account_data_plane_identity))
     * used by Dataproc cluster VM instances to access Google Cloud Platform
     * services.
     *
     * If not specified, the
     * [Compute Engine default service
     * account](https://cloud.google.com/compute/docs/access/service-accounts#default_service_account)
     * is used.
     * </pre>
     *
     * <code>string service_account = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for serviceAccount.
     */
    public com.google.protobuf.ByteString getServiceAccountBytes() {
      java.lang.Object ref = serviceAccount_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        serviceAccount_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The [Dataproc service
     * account](https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/service-accounts#service_accounts_in_dataproc)
     * (also see [VM Data Plane
     * identity](https://cloud.google.com/dataproc/docs/concepts/iam/dataproc-principals#vm_service_account_data_plane_identity))
     * used by Dataproc cluster VM instances to access Google Cloud Platform
     * services.
     *
     * If not specified, the
     * [Compute Engine default service
     * account](https://cloud.google.com/compute/docs/access/service-accounts#default_service_account)
     * is used.
     * </pre>
     *
     * <code>string service_account = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The serviceAccount to set.
     * @return This builder for chaining.
     */
    public Builder setServiceAccount(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      serviceAccount_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The [Dataproc service
     * account](https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/service-accounts#service_accounts_in_dataproc)
     * (also see [VM Data Plane
     * identity](https://cloud.google.com/dataproc/docs/concepts/iam/dataproc-principals#vm_service_account_data_plane_identity))
     * used by Dataproc cluster VM instances to access Google Cloud Platform
     * services.
     *
     * If not specified, the
     * [Compute Engine default service
     * account](https://cloud.google.com/compute/docs/access/service-accounts#default_service_account)
     * is used.
     * </pre>
     *
     * <code>string service_account = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearServiceAccount() {
      serviceAccount_ = getDefaultInstance().getServiceAccount();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The [Dataproc service
     * account](https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/service-accounts#service_accounts_in_dataproc)
     * (also see [VM Data Plane
     * identity](https://cloud.google.com/dataproc/docs/concepts/iam/dataproc-principals#vm_service_account_data_plane_identity))
     * used by Dataproc cluster VM instances to access Google Cloud Platform
     * services.
     *
     * If not specified, the
     * [Compute Engine default service
     * account](https://cloud.google.com/compute/docs/access/service-accounts#default_service_account)
     * is used.
     * </pre>
     *
     * <code>string service_account = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for serviceAccount to set.
     * @return This builder for chaining.
     */
    public Builder setServiceAccountBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      serviceAccount_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList serviceAccountScopes_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureServiceAccountScopesIsMutable() {
      if (!serviceAccountScopes_.isModifiable()) {
        serviceAccountScopes_ = new com.google.protobuf.LazyStringArrayList(serviceAccountScopes_);
      }
      bitField0_ |= 0x00000040;
    }
    /**
     *
     *
     * <pre>
     * Optional. The URIs of service account scopes to be included in
     * Compute Engine instances. The following base set of scopes is always
     * included:
     *
     * * https://www.googleapis.com/auth/cloud.useraccounts.readonly
     * * https://www.googleapis.com/auth/devstorage.read_write
     * * https://www.googleapis.com/auth/logging.write
     *
     * If no scopes are specified, the following defaults are also provided:
     *
     * * https://www.googleapis.com/auth/bigquery
     * * https://www.googleapis.com/auth/bigtable.admin.table
     * * https://www.googleapis.com/auth/bigtable.data
     * * https://www.googleapis.com/auth/devstorage.full_control
     * </pre>
     *
     * <code>repeated string service_account_scopes = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return A list containing the serviceAccountScopes.
     */
    public com.google.protobuf.ProtocolStringList getServiceAccountScopesList() {
      serviceAccountScopes_.makeImmutable();
      return serviceAccountScopes_;
    }
    /**
     *
     *
     * <pre>
     * Optional. The URIs of service account scopes to be included in
     * Compute Engine instances. The following base set of scopes is always
     * included:
     *
     * * https://www.googleapis.com/auth/cloud.useraccounts.readonly
     * * https://www.googleapis.com/auth/devstorage.read_write
     * * https://www.googleapis.com/auth/logging.write
     *
     * If no scopes are specified, the following defaults are also provided:
     *
     * * https://www.googleapis.com/auth/bigquery
     * * https://www.googleapis.com/auth/bigtable.admin.table
     * * https://www.googleapis.com/auth/bigtable.data
     * * https://www.googleapis.com/auth/devstorage.full_control
     * </pre>
     *
     * <code>repeated string service_account_scopes = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The count of serviceAccountScopes.
     */
    public int getServiceAccountScopesCount() {
      return serviceAccountScopes_.size();
    }
    /**
     *
     *
     * <pre>
     * Optional. The URIs of service account scopes to be included in
     * Compute Engine instances. The following base set of scopes is always
     * included:
     *
     * * https://www.googleapis.com/auth/cloud.useraccounts.readonly
     * * https://www.googleapis.com/auth/devstorage.read_write
     * * https://www.googleapis.com/auth/logging.write
     *
     * If no scopes are specified, the following defaults are also provided:
     *
     * * https://www.googleapis.com/auth/bigquery
     * * https://www.googleapis.com/auth/bigtable.admin.table
     * * https://www.googleapis.com/auth/bigtable.data
     * * https://www.googleapis.com/auth/devstorage.full_control
     * </pre>
     *
     * <code>repeated string service_account_scopes = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index of the element to return.
     * @return The serviceAccountScopes at the given index.
     */
    public java.lang.String getServiceAccountScopes(int index) {
      return serviceAccountScopes_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. The URIs of service account scopes to be included in
     * Compute Engine instances. The following base set of scopes is always
     * included:
     *
     * * https://www.googleapis.com/auth/cloud.useraccounts.readonly
     * * https://www.googleapis.com/auth/devstorage.read_write
     * * https://www.googleapis.com/auth/logging.write
     *
     * If no scopes are specified, the following defaults are also provided:
     *
     * * https://www.googleapis.com/auth/bigquery
     * * https://www.googleapis.com/auth/bigtable.admin.table
     * * https://www.googleapis.com/auth/bigtable.data
     * * https://www.googleapis.com/auth/devstorage.full_control
     * </pre>
     *
     * <code>repeated string service_account_scopes = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the serviceAccountScopes at the given index.
     */
    public com.google.protobuf.ByteString getServiceAccountScopesBytes(int index) {
      return serviceAccountScopes_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. The URIs of service account scopes to be included in
     * Compute Engine instances. The following base set of scopes is always
     * included:
     *
     * * https://www.googleapis.com/auth/cloud.useraccounts.readonly
     * * https://www.googleapis.com/auth/devstorage.read_write
     * * https://www.googleapis.com/auth/logging.write
     *
     * If no scopes are specified, the following defaults are also provided:
     *
     * * https://www.googleapis.com/auth/bigquery
     * * https://www.googleapis.com/auth/bigtable.admin.table
     * * https://www.googleapis.com/auth/bigtable.data
     * * https://www.googleapis.com/auth/devstorage.full_control
     * </pre>
     *
     * <code>repeated string service_account_scopes = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The serviceAccountScopes to set.
     * @return This builder for chaining.
     */
    public Builder setServiceAccountScopes(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureServiceAccountScopesIsMutable();
      serviceAccountScopes_.set(index, value);
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The URIs of service account scopes to be included in
     * Compute Engine instances. The following base set of scopes is always
     * included:
     *
     * * https://www.googleapis.com/auth/cloud.useraccounts.readonly
     * * https://www.googleapis.com/auth/devstorage.read_write
     * * https://www.googleapis.com/auth/logging.write
     *
     * If no scopes are specified, the following defaults are also provided:
     *
     * * https://www.googleapis.com/auth/bigquery
     * * https://www.googleapis.com/auth/bigtable.admin.table
     * * https://www.googleapis.com/auth/bigtable.data
     * * https://www.googleapis.com/auth/devstorage.full_control
     * </pre>
     *
     * <code>repeated string service_account_scopes = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The serviceAccountScopes to add.
     * @return This builder for chaining.
     */
    public Builder addServiceAccountScopes(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureServiceAccountScopesIsMutable();
      serviceAccountScopes_.add(value);
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The URIs of service account scopes to be included in
     * Compute Engine instances. The following base set of scopes is always
     * included:
     *
     * * https://www.googleapis.com/auth/cloud.useraccounts.readonly
     * * https://www.googleapis.com/auth/devstorage.read_write
     * * https://www.googleapis.com/auth/logging.write
     *
     * If no scopes are specified, the following defaults are also provided:
     *
     * * https://www.googleapis.com/auth/bigquery
     * * https://www.googleapis.com/auth/bigtable.admin.table
     * * https://www.googleapis.com/auth/bigtable.data
     * * https://www.googleapis.com/auth/devstorage.full_control
     * </pre>
     *
     * <code>repeated string service_account_scopes = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param values The serviceAccountScopes to add.
     * @return This builder for chaining.
     */
    public Builder addAllServiceAccountScopes(java.lang.Iterable<java.lang.String> values) {
      ensureServiceAccountScopesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, serviceAccountScopes_);
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The URIs of service account scopes to be included in
     * Compute Engine instances. The following base set of scopes is always
     * included:
     *
     * * https://www.googleapis.com/auth/cloud.useraccounts.readonly
     * * https://www.googleapis.com/auth/devstorage.read_write
     * * https://www.googleapis.com/auth/logging.write
     *
     * If no scopes are specified, the following defaults are also provided:
     *
     * * https://www.googleapis.com/auth/bigquery
     * * https://www.googleapis.com/auth/bigtable.admin.table
     * * https://www.googleapis.com/auth/bigtable.data
     * * https://www.googleapis.com/auth/devstorage.full_control
     * </pre>
     *
     * <code>repeated string service_account_scopes = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearServiceAccountScopes() {
      serviceAccountScopes_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000040);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The URIs of service account scopes to be included in
     * Compute Engine instances. The following base set of scopes is always
     * included:
     *
     * * https://www.googleapis.com/auth/cloud.useraccounts.readonly
     * * https://www.googleapis.com/auth/devstorage.read_write
     * * https://www.googleapis.com/auth/logging.write
     *
     * If no scopes are specified, the following defaults are also provided:
     *
     * * https://www.googleapis.com/auth/bigquery
     * * https://www.googleapis.com/auth/bigtable.admin.table
     * * https://www.googleapis.com/auth/bigtable.data
     * * https://www.googleapis.com/auth/devstorage.full_control
     * </pre>
     *
     * <code>repeated string service_account_scopes = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The bytes of the serviceAccountScopes to add.
     * @return This builder for chaining.
     */
    public Builder addServiceAccountScopesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureServiceAccountScopesIsMutable();
      serviceAccountScopes_.add(value);
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList tags_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureTagsIsMutable() {
      if (!tags_.isModifiable()) {
        tags_ = new com.google.protobuf.LazyStringArrayList(tags_);
      }
      bitField0_ |= 0x00000080;
    }
    /**
     *
     *
     * <pre>
     * The Compute Engine tags to add to all instances (see [Tagging
     * instances](https://cloud.google.com/compute/docs/label-or-tag-resources#tags)).
     * </pre>
     *
     * <code>repeated string tags = 4;</code>
     *
     * @return A list containing the tags.
     */
    public com.google.protobuf.ProtocolStringList getTagsList() {
      tags_.makeImmutable();
      return tags_;
    }
    /**
     *
     *
     * <pre>
     * The Compute Engine tags to add to all instances (see [Tagging
     * instances](https://cloud.google.com/compute/docs/label-or-tag-resources#tags)).
     * </pre>
     *
     * <code>repeated string tags = 4;</code>
     *
     * @return The count of tags.
     */
    public int getTagsCount() {
      return tags_.size();
    }
    /**
     *
     *
     * <pre>
     * The Compute Engine tags to add to all instances (see [Tagging
     * instances](https://cloud.google.com/compute/docs/label-or-tag-resources#tags)).
     * </pre>
     *
     * <code>repeated string tags = 4;</code>
     *
     * @param index The index of the element to return.
     * @return The tags at the given index.
     */
    public java.lang.String getTags(int index) {
      return tags_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The Compute Engine tags to add to all instances (see [Tagging
     * instances](https://cloud.google.com/compute/docs/label-or-tag-resources#tags)).
     * </pre>
     *
     * <code>repeated string tags = 4;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the tags at the given index.
     */
    public com.google.protobuf.ByteString getTagsBytes(int index) {
      return tags_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * The Compute Engine tags to add to all instances (see [Tagging
     * instances](https://cloud.google.com/compute/docs/label-or-tag-resources#tags)).
     * </pre>
     *
     * <code>repeated string tags = 4;</code>
     *
     * @param index The index to set the value at.
     * @param value The tags to set.
     * @return This builder for chaining.
     */
    public Builder setTags(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureTagsIsMutable();
      tags_.set(index, value);
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Compute Engine tags to add to all instances (see [Tagging
     * instances](https://cloud.google.com/compute/docs/label-or-tag-resources#tags)).
     * </pre>
     *
     * <code>repeated string tags = 4;</code>
     *
     * @param value The tags to add.
     * @return This builder for chaining.
     */
    public Builder addTags(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureTagsIsMutable();
      tags_.add(value);
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Compute Engine tags to add to all instances (see [Tagging
     * instances](https://cloud.google.com/compute/docs/label-or-tag-resources#tags)).
     * </pre>
     *
     * <code>repeated string tags = 4;</code>
     *
     * @param values The tags to add.
     * @return This builder for chaining.
     */
    public Builder addAllTags(java.lang.Iterable<java.lang.String> values) {
      ensureTagsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, tags_);
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Compute Engine tags to add to all instances (see [Tagging
     * instances](https://cloud.google.com/compute/docs/label-or-tag-resources#tags)).
     * </pre>
     *
     * <code>repeated string tags = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTags() {
      tags_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000080);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Compute Engine tags to add to all instances (see [Tagging
     * instances](https://cloud.google.com/compute/docs/label-or-tag-resources#tags)).
     * </pre>
     *
     * <code>repeated string tags = 4;</code>
     *
     * @param value The bytes of the tags to add.
     * @return This builder for chaining.
     */
    public Builder addTagsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureTagsIsMutable();
      tags_.add(value);
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> metadata_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetMetadata() {
      if (metadata_ == null) {
        return com.google.protobuf.MapField.emptyMapField(MetadataDefaultEntryHolder.defaultEntry);
      }
      return metadata_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableMetadata() {
      if (metadata_ == null) {
        metadata_ =
            com.google.protobuf.MapField.newMapField(MetadataDefaultEntryHolder.defaultEntry);
      }
      if (!metadata_.isMutable()) {
        metadata_ = metadata_.copy();
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return metadata_;
    }

    public int getMetadataCount() {
      return internalGetMetadata().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Optional. The Compute Engine metadata entries to add to all instances (see
     * [Project and instance
     * metadata](https://cloud.google.com/compute/docs/storing-retrieving-metadata#project_and_instance_metadata)).
     * </pre>
     *
     * <code>map&lt;string, string&gt; metadata = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public boolean containsMetadata(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetMetadata().getMap().containsKey(key);
    }
    /** Use {@link #getMetadataMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMetadata() {
      return getMetadataMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. The Compute Engine metadata entries to add to all instances (see
     * [Project and instance
     * metadata](https://cloud.google.com/compute/docs/storing-retrieving-metadata#project_and_instance_metadata)).
     * </pre>
     *
     * <code>map&lt;string, string&gt; metadata = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getMetadataMap() {
      return internalGetMetadata().getMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. The Compute Engine metadata entries to add to all instances (see
     * [Project and instance
     * metadata](https://cloud.google.com/compute/docs/storing-retrieving-metadata#project_and_instance_metadata)).
     * </pre>
     *
     * <code>map&lt;string, string&gt; metadata = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getMetadataOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetMetadata().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Optional. The Compute Engine metadata entries to add to all instances (see
     * [Project and instance
     * metadata](https://cloud.google.com/compute/docs/storing-retrieving-metadata#project_and_instance_metadata)).
     * </pre>
     *
     * <code>map&lt;string, string&gt; metadata = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.lang.String getMetadataOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetMetadata().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearMetadata() {
      bitField0_ = (bitField0_ & ~0x00000100);
      internalGetMutableMetadata().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The Compute Engine metadata entries to add to all instances (see
     * [Project and instance
     * metadata](https://cloud.google.com/compute/docs/storing-retrieving-metadata#project_and_instance_metadata)).
     * </pre>
     *
     * <code>map&lt;string, string&gt; metadata = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeMetadata(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableMetadata().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableMetadata() {
      bitField0_ |= 0x00000100;
      return internalGetMutableMetadata().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. The Compute Engine metadata entries to add to all instances (see
     * [Project and instance
     * metadata](https://cloud.google.com/compute/docs/storing-retrieving-metadata#project_and_instance_metadata)).
     * </pre>
     *
     * <code>map&lt;string, string&gt; metadata = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder putMetadata(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableMetadata().getMutableMap().put(key, value);
      bitField0_ |= 0x00000100;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The Compute Engine metadata entries to add to all instances (see
     * [Project and instance
     * metadata](https://cloud.google.com/compute/docs/storing-retrieving-metadata#project_and_instance_metadata)).
     * </pre>
     *
     * <code>map&lt;string, string&gt; metadata = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder putAllMetadata(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableMetadata().getMutableMap().putAll(values);
      bitField0_ |= 0x00000100;
      return this;
    }

    private com.google.cloud.dataproc.v1.ReservationAffinity reservationAffinity_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.ReservationAffinity,
            com.google.cloud.dataproc.v1.ReservationAffinity.Builder,
            com.google.cloud.dataproc.v1.ReservationAffinityOrBuilder>
        reservationAffinityBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Reservation Affinity for consuming Zonal reservation.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.ReservationAffinity reservation_affinity = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the reservationAffinity field is set.
     */
    public boolean hasReservationAffinity() {
      return ((bitField0_ & 0x00000200) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Reservation Affinity for consuming Zonal reservation.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.ReservationAffinity reservation_affinity = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The reservationAffinity.
     */
    public com.google.cloud.dataproc.v1.ReservationAffinity getReservationAffinity() {
      if (reservationAffinityBuilder_ == null) {
        return reservationAffinity_ == null
            ? com.google.cloud.dataproc.v1.ReservationAffinity.getDefaultInstance()
            : reservationAffinity_;
      } else {
        return reservationAffinityBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Reservation Affinity for consuming Zonal reservation.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.ReservationAffinity reservation_affinity = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setReservationAffinity(com.google.cloud.dataproc.v1.ReservationAffinity value) {
      if (reservationAffinityBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        reservationAffinity_ = value;
      } else {
        reservationAffinityBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Reservation Affinity for consuming Zonal reservation.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.ReservationAffinity reservation_affinity = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setReservationAffinity(
        com.google.cloud.dataproc.v1.ReservationAffinity.Builder builderForValue) {
      if (reservationAffinityBuilder_ == null) {
        reservationAffinity_ = builderForValue.build();
      } else {
        reservationAffinityBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Reservation Affinity for consuming Zonal reservation.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.ReservationAffinity reservation_affinity = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeReservationAffinity(
        com.google.cloud.dataproc.v1.ReservationAffinity value) {
      if (reservationAffinityBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)
            && reservationAffinity_ != null
            && reservationAffinity_
                != com.google.cloud.dataproc.v1.ReservationAffinity.getDefaultInstance()) {
          getReservationAffinityBuilder().mergeFrom(value);
        } else {
          reservationAffinity_ = value;
        }
      } else {
        reservationAffinityBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Reservation Affinity for consuming Zonal reservation.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.ReservationAffinity reservation_affinity = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearReservationAffinity() {
      bitField0_ = (bitField0_ & ~0x00000200);
      reservationAffinity_ = null;
      if (reservationAffinityBuilder_ != null) {
        reservationAffinityBuilder_.dispose();
        reservationAffinityBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Reservation Affinity for consuming Zonal reservation.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.ReservationAffinity reservation_affinity = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataproc.v1.ReservationAffinity.Builder
        getReservationAffinityBuilder() {
      bitField0_ |= 0x00000200;
      onChanged();
      return getReservationAffinityFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Reservation Affinity for consuming Zonal reservation.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.ReservationAffinity reservation_affinity = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataproc.v1.ReservationAffinityOrBuilder
        getReservationAffinityOrBuilder() {
      if (reservationAffinityBuilder_ != null) {
        return reservationAffinityBuilder_.getMessageOrBuilder();
      } else {
        return reservationAffinity_ == null
            ? com.google.cloud.dataproc.v1.ReservationAffinity.getDefaultInstance()
            : reservationAffinity_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Reservation Affinity for consuming Zonal reservation.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.ReservationAffinity reservation_affinity = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.ReservationAffinity,
            com.google.cloud.dataproc.v1.ReservationAffinity.Builder,
            com.google.cloud.dataproc.v1.ReservationAffinityOrBuilder>
        getReservationAffinityFieldBuilder() {
      if (reservationAffinityBuilder_ == null) {
        reservationAffinityBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataproc.v1.ReservationAffinity,
                com.google.cloud.dataproc.v1.ReservationAffinity.Builder,
                com.google.cloud.dataproc.v1.ReservationAffinityOrBuilder>(
                getReservationAffinity(), getParentForChildren(), isClean());
        reservationAffinity_ = null;
      }
      return reservationAffinityBuilder_;
    }

    private com.google.cloud.dataproc.v1.NodeGroupAffinity nodeGroupAffinity_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.NodeGroupAffinity,
            com.google.cloud.dataproc.v1.NodeGroupAffinity.Builder,
            com.google.cloud.dataproc.v1.NodeGroupAffinityOrBuilder>
        nodeGroupAffinityBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Node Group Affinity for sole-tenant clusters.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.NodeGroupAffinity node_group_affinity = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the nodeGroupAffinity field is set.
     */
    public boolean hasNodeGroupAffinity() {
      return ((bitField0_ & 0x00000400) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Node Group Affinity for sole-tenant clusters.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.NodeGroupAffinity node_group_affinity = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The nodeGroupAffinity.
     */
    public com.google.cloud.dataproc.v1.NodeGroupAffinity getNodeGroupAffinity() {
      if (nodeGroupAffinityBuilder_ == null) {
        return nodeGroupAffinity_ == null
            ? com.google.cloud.dataproc.v1.NodeGroupAffinity.getDefaultInstance()
            : nodeGroupAffinity_;
      } else {
        return nodeGroupAffinityBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Node Group Affinity for sole-tenant clusters.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.NodeGroupAffinity node_group_affinity = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setNodeGroupAffinity(com.google.cloud.dataproc.v1.NodeGroupAffinity value) {
      if (nodeGroupAffinityBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        nodeGroupAffinity_ = value;
      } else {
        nodeGroupAffinityBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Node Group Affinity for sole-tenant clusters.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.NodeGroupAffinity node_group_affinity = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setNodeGroupAffinity(
        com.google.cloud.dataproc.v1.NodeGroupAffinity.Builder builderForValue) {
      if (nodeGroupAffinityBuilder_ == null) {
        nodeGroupAffinity_ = builderForValue.build();
      } else {
        nodeGroupAffinityBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Node Group Affinity for sole-tenant clusters.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.NodeGroupAffinity node_group_affinity = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeNodeGroupAffinity(com.google.cloud.dataproc.v1.NodeGroupAffinity value) {
      if (nodeGroupAffinityBuilder_ == null) {
        if (((bitField0_ & 0x00000400) != 0)
            && nodeGroupAffinity_ != null
            && nodeGroupAffinity_
                != com.google.cloud.dataproc.v1.NodeGroupAffinity.getDefaultInstance()) {
          getNodeGroupAffinityBuilder().mergeFrom(value);
        } else {
          nodeGroupAffinity_ = value;
        }
      } else {
        nodeGroupAffinityBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Node Group Affinity for sole-tenant clusters.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.NodeGroupAffinity node_group_affinity = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearNodeGroupAffinity() {
      bitField0_ = (bitField0_ & ~0x00000400);
      nodeGroupAffinity_ = null;
      if (nodeGroupAffinityBuilder_ != null) {
        nodeGroupAffinityBuilder_.dispose();
        nodeGroupAffinityBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Node Group Affinity for sole-tenant clusters.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.NodeGroupAffinity node_group_affinity = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataproc.v1.NodeGroupAffinity.Builder getNodeGroupAffinityBuilder() {
      bitField0_ |= 0x00000400;
      onChanged();
      return getNodeGroupAffinityFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Node Group Affinity for sole-tenant clusters.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.NodeGroupAffinity node_group_affinity = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataproc.v1.NodeGroupAffinityOrBuilder getNodeGroupAffinityOrBuilder() {
      if (nodeGroupAffinityBuilder_ != null) {
        return nodeGroupAffinityBuilder_.getMessageOrBuilder();
      } else {
        return nodeGroupAffinity_ == null
            ? com.google.cloud.dataproc.v1.NodeGroupAffinity.getDefaultInstance()
            : nodeGroupAffinity_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Node Group Affinity for sole-tenant clusters.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.NodeGroupAffinity node_group_affinity = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.NodeGroupAffinity,
            com.google.cloud.dataproc.v1.NodeGroupAffinity.Builder,
            com.google.cloud.dataproc.v1.NodeGroupAffinityOrBuilder>
        getNodeGroupAffinityFieldBuilder() {
      if (nodeGroupAffinityBuilder_ == null) {
        nodeGroupAffinityBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataproc.v1.NodeGroupAffinity,
                com.google.cloud.dataproc.v1.NodeGroupAffinity.Builder,
                com.google.cloud.dataproc.v1.NodeGroupAffinityOrBuilder>(
                getNodeGroupAffinity(), getParentForChildren(), isClean());
        nodeGroupAffinity_ = null;
      }
      return nodeGroupAffinityBuilder_;
    }

    private com.google.cloud.dataproc.v1.ShieldedInstanceConfig shieldedInstanceConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.ShieldedInstanceConfig,
            com.google.cloud.dataproc.v1.ShieldedInstanceConfig.Builder,
            com.google.cloud.dataproc.v1.ShieldedInstanceConfigOrBuilder>
        shieldedInstanceConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Shielded Instance Config for clusters using [Compute Engine
     * Shielded
     * VMs](https://cloud.google.com/security/shielded-cloud/shielded-vm).
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.ShieldedInstanceConfig shielded_instance_config = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the shieldedInstanceConfig field is set.
     */
    public boolean hasShieldedInstanceConfig() {
      return ((bitField0_ & 0x00000800) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Shielded Instance Config for clusters using [Compute Engine
     * Shielded
     * VMs](https://cloud.google.com/security/shielded-cloud/shielded-vm).
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.ShieldedInstanceConfig shielded_instance_config = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The shieldedInstanceConfig.
     */
    public com.google.cloud.dataproc.v1.ShieldedInstanceConfig getShieldedInstanceConfig() {
      if (shieldedInstanceConfigBuilder_ == null) {
        return shieldedInstanceConfig_ == null
            ? com.google.cloud.dataproc.v1.ShieldedInstanceConfig.getDefaultInstance()
            : shieldedInstanceConfig_;
      } else {
        return shieldedInstanceConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Shielded Instance Config for clusters using [Compute Engine
     * Shielded
     * VMs](https://cloud.google.com/security/shielded-cloud/shielded-vm).
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.ShieldedInstanceConfig shielded_instance_config = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setShieldedInstanceConfig(
        com.google.cloud.dataproc.v1.ShieldedInstanceConfig value) {
      if (shieldedInstanceConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        shieldedInstanceConfig_ = value;
      } else {
        shieldedInstanceConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Shielded Instance Config for clusters using [Compute Engine
     * Shielded
     * VMs](https://cloud.google.com/security/shielded-cloud/shielded-vm).
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.ShieldedInstanceConfig shielded_instance_config = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setShieldedInstanceConfig(
        com.google.cloud.dataproc.v1.ShieldedInstanceConfig.Builder builderForValue) {
      if (shieldedInstanceConfigBuilder_ == null) {
        shieldedInstanceConfig_ = builderForValue.build();
      } else {
        shieldedInstanceConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Shielded Instance Config for clusters using [Compute Engine
     * Shielded
     * VMs](https://cloud.google.com/security/shielded-cloud/shielded-vm).
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.ShieldedInstanceConfig shielded_instance_config = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeShieldedInstanceConfig(
        com.google.cloud.dataproc.v1.ShieldedInstanceConfig value) {
      if (shieldedInstanceConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000800) != 0)
            && shieldedInstanceConfig_ != null
            && shieldedInstanceConfig_
                != com.google.cloud.dataproc.v1.ShieldedInstanceConfig.getDefaultInstance()) {
          getShieldedInstanceConfigBuilder().mergeFrom(value);
        } else {
          shieldedInstanceConfig_ = value;
        }
      } else {
        shieldedInstanceConfigBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Shielded Instance Config for clusters using [Compute Engine
     * Shielded
     * VMs](https://cloud.google.com/security/shielded-cloud/shielded-vm).
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.ShieldedInstanceConfig shielded_instance_config = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearShieldedInstanceConfig() {
      bitField0_ = (bitField0_ & ~0x00000800);
      shieldedInstanceConfig_ = null;
      if (shieldedInstanceConfigBuilder_ != null) {
        shieldedInstanceConfigBuilder_.dispose();
        shieldedInstanceConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Shielded Instance Config for clusters using [Compute Engine
     * Shielded
     * VMs](https://cloud.google.com/security/shielded-cloud/shielded-vm).
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.ShieldedInstanceConfig shielded_instance_config = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataproc.v1.ShieldedInstanceConfig.Builder
        getShieldedInstanceConfigBuilder() {
      bitField0_ |= 0x00000800;
      onChanged();
      return getShieldedInstanceConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Shielded Instance Config for clusters using [Compute Engine
     * Shielded
     * VMs](https://cloud.google.com/security/shielded-cloud/shielded-vm).
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.ShieldedInstanceConfig shielded_instance_config = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataproc.v1.ShieldedInstanceConfigOrBuilder
        getShieldedInstanceConfigOrBuilder() {
      if (shieldedInstanceConfigBuilder_ != null) {
        return shieldedInstanceConfigBuilder_.getMessageOrBuilder();
      } else {
        return shieldedInstanceConfig_ == null
            ? com.google.cloud.dataproc.v1.ShieldedInstanceConfig.getDefaultInstance()
            : shieldedInstanceConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Shielded Instance Config for clusters using [Compute Engine
     * Shielded
     * VMs](https://cloud.google.com/security/shielded-cloud/shielded-vm).
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.ShieldedInstanceConfig shielded_instance_config = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.ShieldedInstanceConfig,
            com.google.cloud.dataproc.v1.ShieldedInstanceConfig.Builder,
            com.google.cloud.dataproc.v1.ShieldedInstanceConfigOrBuilder>
        getShieldedInstanceConfigFieldBuilder() {
      if (shieldedInstanceConfigBuilder_ == null) {
        shieldedInstanceConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataproc.v1.ShieldedInstanceConfig,
                com.google.cloud.dataproc.v1.ShieldedInstanceConfig.Builder,
                com.google.cloud.dataproc.v1.ShieldedInstanceConfigOrBuilder>(
                getShieldedInstanceConfig(), getParentForChildren(), isClean());
        shieldedInstanceConfig_ = null;
      }
      return shieldedInstanceConfigBuilder_;
    }

    private com.google.cloud.dataproc.v1.ConfidentialInstanceConfig confidentialInstanceConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.ConfidentialInstanceConfig,
            com.google.cloud.dataproc.v1.ConfidentialInstanceConfig.Builder,
            com.google.cloud.dataproc.v1.ConfidentialInstanceConfigOrBuilder>
        confidentialInstanceConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Confidential Instance Config for clusters using [Confidential
     * VMs](https://cloud.google.com/compute/confidential-vm/docs).
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.ConfidentialInstanceConfig confidential_instance_config = 15 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the confidentialInstanceConfig field is set.
     */
    public boolean hasConfidentialInstanceConfig() {
      return ((bitField0_ & 0x00001000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Confidential Instance Config for clusters using [Confidential
     * VMs](https://cloud.google.com/compute/confidential-vm/docs).
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.ConfidentialInstanceConfig confidential_instance_config = 15 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The confidentialInstanceConfig.
     */
    public com.google.cloud.dataproc.v1.ConfidentialInstanceConfig getConfidentialInstanceConfig() {
      if (confidentialInstanceConfigBuilder_ == null) {
        return confidentialInstanceConfig_ == null
            ? com.google.cloud.dataproc.v1.ConfidentialInstanceConfig.getDefaultInstance()
            : confidentialInstanceConfig_;
      } else {
        return confidentialInstanceConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Confidential Instance Config for clusters using [Confidential
     * VMs](https://cloud.google.com/compute/confidential-vm/docs).
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.ConfidentialInstanceConfig confidential_instance_config = 15 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setConfidentialInstanceConfig(
        com.google.cloud.dataproc.v1.ConfidentialInstanceConfig value) {
      if (confidentialInstanceConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        confidentialInstanceConfig_ = value;
      } else {
        confidentialInstanceConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Confidential Instance Config for clusters using [Confidential
     * VMs](https://cloud.google.com/compute/confidential-vm/docs).
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.ConfidentialInstanceConfig confidential_instance_config = 15 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setConfidentialInstanceConfig(
        com.google.cloud.dataproc.v1.ConfidentialInstanceConfig.Builder builderForValue) {
      if (confidentialInstanceConfigBuilder_ == null) {
        confidentialInstanceConfig_ = builderForValue.build();
      } else {
        confidentialInstanceConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Confidential Instance Config for clusters using [Confidential
     * VMs](https://cloud.google.com/compute/confidential-vm/docs).
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.ConfidentialInstanceConfig confidential_instance_config = 15 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeConfidentialInstanceConfig(
        com.google.cloud.dataproc.v1.ConfidentialInstanceConfig value) {
      if (confidentialInstanceConfigBuilder_ == null) {
        if (((bitField0_ & 0x00001000) != 0)
            && confidentialInstanceConfig_ != null
            && confidentialInstanceConfig_
                != com.google.cloud.dataproc.v1.ConfidentialInstanceConfig.getDefaultInstance()) {
          getConfidentialInstanceConfigBuilder().mergeFrom(value);
        } else {
          confidentialInstanceConfig_ = value;
        }
      } else {
        confidentialInstanceConfigBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Confidential Instance Config for clusters using [Confidential
     * VMs](https://cloud.google.com/compute/confidential-vm/docs).
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.ConfidentialInstanceConfig confidential_instance_config = 15 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearConfidentialInstanceConfig() {
      bitField0_ = (bitField0_ & ~0x00001000);
      confidentialInstanceConfig_ = null;
      if (confidentialInstanceConfigBuilder_ != null) {
        confidentialInstanceConfigBuilder_.dispose();
        confidentialInstanceConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Confidential Instance Config for clusters using [Confidential
     * VMs](https://cloud.google.com/compute/confidential-vm/docs).
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.ConfidentialInstanceConfig confidential_instance_config = 15 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataproc.v1.ConfidentialInstanceConfig.Builder
        getConfidentialInstanceConfigBuilder() {
      bitField0_ |= 0x00001000;
      onChanged();
      return getConfidentialInstanceConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Confidential Instance Config for clusters using [Confidential
     * VMs](https://cloud.google.com/compute/confidential-vm/docs).
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.ConfidentialInstanceConfig confidential_instance_config = 15 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataproc.v1.ConfidentialInstanceConfigOrBuilder
        getConfidentialInstanceConfigOrBuilder() {
      if (confidentialInstanceConfigBuilder_ != null) {
        return confidentialInstanceConfigBuilder_.getMessageOrBuilder();
      } else {
        return confidentialInstanceConfig_ == null
            ? com.google.cloud.dataproc.v1.ConfidentialInstanceConfig.getDefaultInstance()
            : confidentialInstanceConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Confidential Instance Config for clusters using [Confidential
     * VMs](https://cloud.google.com/compute/confidential-vm/docs).
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.ConfidentialInstanceConfig confidential_instance_config = 15 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.ConfidentialInstanceConfig,
            com.google.cloud.dataproc.v1.ConfidentialInstanceConfig.Builder,
            com.google.cloud.dataproc.v1.ConfidentialInstanceConfigOrBuilder>
        getConfidentialInstanceConfigFieldBuilder() {
      if (confidentialInstanceConfigBuilder_ == null) {
        confidentialInstanceConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataproc.v1.ConfidentialInstanceConfig,
                com.google.cloud.dataproc.v1.ConfidentialInstanceConfig.Builder,
                com.google.cloud.dataproc.v1.ConfidentialInstanceConfigOrBuilder>(
                getConfidentialInstanceConfig(), getParentForChildren(), isClean());
        confidentialInstanceConfig_ = null;
      }
      return confidentialInstanceConfigBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dataproc.v1.GceClusterConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dataproc.v1.GceClusterConfig)
  private static final com.google.cloud.dataproc.v1.GceClusterConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dataproc.v1.GceClusterConfig();
  }

  public static com.google.cloud.dataproc.v1.GceClusterConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<GceClusterConfig> PARSER =
      new com.google.protobuf.AbstractParser<GceClusterConfig>() {
        @java.lang.Override
        public GceClusterConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<GceClusterConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<GceClusterConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dataproc.v1.GceClusterConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
