/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dataproc/v1/shared.proto

package com.google.cloud.dataproc.v1;

/**
 *
 *
 * <pre>
 * The configuration of a GKE node pool used by a [Dataproc-on-GKE
 * cluster](https://cloud.google.com/dataproc/docs/concepts/jobs/dataproc-gke#create-a-dataproc-on-gke-cluster).
 * </pre>
 *
 * Protobuf type {@code google.cloud.dataproc.v1.GkeNodePoolConfig}
 */
public final class GkeNodePoolConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dataproc.v1.GkeNodePoolConfig)
    GkeNodePoolConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use GkeNodePoolConfig.newBuilder() to construct.
  private GkeNodePoolConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private GkeNodePoolConfig() {
    locations_ = com.google.protobuf.LazyStringArrayList.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new GkeNodePoolConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dataproc.v1.SharedProto
        .internal_static_google_cloud_dataproc_v1_GkeNodePoolConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dataproc.v1.SharedProto
        .internal_static_google_cloud_dataproc_v1_GkeNodePoolConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dataproc.v1.GkeNodePoolConfig.class,
            com.google.cloud.dataproc.v1.GkeNodePoolConfig.Builder.class);
  }

  public interface GkeNodeConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Optional. The name of a Compute Engine [machine
     * type](https://cloud.google.com/compute/docs/machine-types).
     * </pre>
     *
     * <code>string machine_type = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The machineType.
     */
    java.lang.String getMachineType();
    /**
     *
     *
     * <pre>
     * Optional. The name of a Compute Engine [machine
     * type](https://cloud.google.com/compute/docs/machine-types).
     * </pre>
     *
     * <code>string machine_type = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for machineType.
     */
    com.google.protobuf.ByteString getMachineTypeBytes();

    /**
     *
     *
     * <pre>
     * Optional. The number of local SSD disks to attach to the node, which is
     * limited by the maximum number of disks allowable per zone (see [Adding
     * Local SSDs](https://cloud.google.com/compute/docs/disks/local-ssd)).
     * </pre>
     *
     * <code>int32 local_ssd_count = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The localSsdCount.
     */
    int getLocalSsdCount();

    /**
     *
     *
     * <pre>
     * Optional. Whether the nodes are created as legacy [preemptible VM
     * instances] (https://cloud.google.com/compute/docs/instances/preemptible).
     * Also see
     * [Spot][google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig.spot]
     * VMs, preemptible VM instances without a maximum lifetime. Legacy and Spot
     * preemptible nodes cannot be used in a node pool with the `CONTROLLER`
     * [role]
     * (/dataproc/docs/reference/rest/v1/projects.regions.clusters#role)
     * or in the DEFAULT node pool if the CONTROLLER role is not assigned (the
     * DEFAULT node pool will assume the CONTROLLER role).
     * </pre>
     *
     * <code>bool preemptible = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The preemptible.
     */
    boolean getPreemptible();

    /**
     *
     *
     * <pre>
     * Optional. A list of [hardware
     * accelerators](https://cloud.google.com/compute/docs/gpus) to attach to
     * each node.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig accelerators = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    java.util.List<com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig>
        getAcceleratorsList();
    /**
     *
     *
     * <pre>
     * Optional. A list of [hardware
     * accelerators](https://cloud.google.com/compute/docs/gpus) to attach to
     * each node.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig accelerators = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig getAccelerators(
        int index);
    /**
     *
     *
     * <pre>
     * Optional. A list of [hardware
     * accelerators](https://cloud.google.com/compute/docs/gpus) to attach to
     * each node.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig accelerators = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    int getAcceleratorsCount();
    /**
     *
     *
     * <pre>
     * Optional. A list of [hardware
     * accelerators](https://cloud.google.com/compute/docs/gpus) to attach to
     * each node.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig accelerators = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    java.util.List<
            ? extends
                com.google.cloud.dataproc.v1.GkeNodePoolConfig
                    .GkeNodePoolAcceleratorConfigOrBuilder>
        getAcceleratorsOrBuilderList();
    /**
     *
     *
     * <pre>
     * Optional. A list of [hardware
     * accelerators](https://cloud.google.com/compute/docs/gpus) to attach to
     * each node.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig accelerators = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfigOrBuilder
        getAcceleratorsOrBuilder(int index);

    /**
     *
     *
     * <pre>
     * Optional. [Minimum CPU
     * platform](https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform)
     * to be used by this instance. The instance may be scheduled on the
     * specified or a newer CPU platform. Specify the friendly names of CPU
     * platforms, such as "Intel Haswell"` or Intel Sandy Bridge".
     * </pre>
     *
     * <code>string min_cpu_platform = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The minCpuPlatform.
     */
    java.lang.String getMinCpuPlatform();
    /**
     *
     *
     * <pre>
     * Optional. [Minimum CPU
     * platform](https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform)
     * to be used by this instance. The instance may be scheduled on the
     * specified or a newer CPU platform. Specify the friendly names of CPU
     * platforms, such as "Intel Haswell"` or Intel Sandy Bridge".
     * </pre>
     *
     * <code>string min_cpu_platform = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for minCpuPlatform.
     */
    com.google.protobuf.ByteString getMinCpuPlatformBytes();

    /**
     *
     *
     * <pre>
     * Optional. The [Customer Managed Encryption Key (CMEK)]
     * (https://cloud.google.com/kubernetes-engine/docs/how-to/using-cmek)
     * used to encrypt the boot disk attached to each node in the node pool.
     * Specify the key using the following format:
     * &lt;code&gt;projects/&lt;var&gt;KEY_PROJECT_ID&lt;/var&gt;/locations/&lt;var&gt;LOCATION&lt;/var&gt;/keyRings/&lt;var&gt;RING_NAME&lt;/var&gt;/cryptoKeys/&lt;var&gt;KEY_NAME&lt;/var&gt;&lt;/code&gt;.
     * </pre>
     *
     * <code>string boot_disk_kms_key = 23 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bootDiskKmsKey.
     */
    java.lang.String getBootDiskKmsKey();
    /**
     *
     *
     * <pre>
     * Optional. The [Customer Managed Encryption Key (CMEK)]
     * (https://cloud.google.com/kubernetes-engine/docs/how-to/using-cmek)
     * used to encrypt the boot disk attached to each node in the node pool.
     * Specify the key using the following format:
     * &lt;code&gt;projects/&lt;var&gt;KEY_PROJECT_ID&lt;/var&gt;/locations/&lt;var&gt;LOCATION&lt;/var&gt;/keyRings/&lt;var&gt;RING_NAME&lt;/var&gt;/cryptoKeys/&lt;var&gt;KEY_NAME&lt;/var&gt;&lt;/code&gt;.
     * </pre>
     *
     * <code>string boot_disk_kms_key = 23 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for bootDiskKmsKey.
     */
    com.google.protobuf.ByteString getBootDiskKmsKeyBytes();

    /**
     *
     *
     * <pre>
     * Optional. Whether the nodes are created as [Spot VM instances]
     * (https://cloud.google.com/compute/docs/instances/spot).
     * Spot VMs are the latest update to legacy
     * [preemptible
     * VMs][google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig.preemptible].
     * Spot VMs do not have a maximum lifetime. Legacy and Spot preemptible
     * nodes cannot be used in a node pool with the `CONTROLLER`
     * [role](/dataproc/docs/reference/rest/v1/projects.regions.clusters#role)
     * or in the DEFAULT node pool if the CONTROLLER role is not assigned (the
     * DEFAULT node pool will assume the CONTROLLER role).
     * </pre>
     *
     * <code>bool spot = 32 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The spot.
     */
    boolean getSpot();
  }
  /**
   *
   *
   * <pre>
   * Parameters that describe cluster nodes.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig}
   */
  public static final class GkeNodeConfig extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig)
      GkeNodeConfigOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use GkeNodeConfig.newBuilder() to construct.
    private GkeNodeConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private GkeNodeConfig() {
      machineType_ = "";
      accelerators_ = java.util.Collections.emptyList();
      minCpuPlatform_ = "";
      bootDiskKmsKey_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new GkeNodeConfig();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dataproc.v1.SharedProto
          .internal_static_google_cloud_dataproc_v1_GkeNodePoolConfig_GkeNodeConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dataproc.v1.SharedProto
          .internal_static_google_cloud_dataproc_v1_GkeNodePoolConfig_GkeNodeConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig.class,
              com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig.Builder.class);
    }

    public static final int MACHINE_TYPE_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object machineType_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The name of a Compute Engine [machine
     * type](https://cloud.google.com/compute/docs/machine-types).
     * </pre>
     *
     * <code>string machine_type = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The machineType.
     */
    @java.lang.Override
    public java.lang.String getMachineType() {
      java.lang.Object ref = machineType_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        machineType_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The name of a Compute Engine [machine
     * type](https://cloud.google.com/compute/docs/machine-types).
     * </pre>
     *
     * <code>string machine_type = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for machineType.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getMachineTypeBytes() {
      java.lang.Object ref = machineType_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        machineType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int LOCAL_SSD_COUNT_FIELD_NUMBER = 7;
    private int localSsdCount_ = 0;
    /**
     *
     *
     * <pre>
     * Optional. The number of local SSD disks to attach to the node, which is
     * limited by the maximum number of disks allowable per zone (see [Adding
     * Local SSDs](https://cloud.google.com/compute/docs/disks/local-ssd)).
     * </pre>
     *
     * <code>int32 local_ssd_count = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The localSsdCount.
     */
    @java.lang.Override
    public int getLocalSsdCount() {
      return localSsdCount_;
    }

    public static final int PREEMPTIBLE_FIELD_NUMBER = 10;
    private boolean preemptible_ = false;
    /**
     *
     *
     * <pre>
     * Optional. Whether the nodes are created as legacy [preemptible VM
     * instances] (https://cloud.google.com/compute/docs/instances/preemptible).
     * Also see
     * [Spot][google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig.spot]
     * VMs, preemptible VM instances without a maximum lifetime. Legacy and Spot
     * preemptible nodes cannot be used in a node pool with the `CONTROLLER`
     * [role]
     * (/dataproc/docs/reference/rest/v1/projects.regions.clusters#role)
     * or in the DEFAULT node pool if the CONTROLLER role is not assigned (the
     * DEFAULT node pool will assume the CONTROLLER role).
     * </pre>
     *
     * <code>bool preemptible = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The preemptible.
     */
    @java.lang.Override
    public boolean getPreemptible() {
      return preemptible_;
    }

    public static final int ACCELERATORS_FIELD_NUMBER = 11;

    @SuppressWarnings("serial")
    private java.util.List<
            com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig>
        accelerators_;
    /**
     *
     *
     * <pre>
     * Optional. A list of [hardware
     * accelerators](https://cloud.google.com/compute/docs/gpus) to attach to
     * each node.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig accelerators = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig>
        getAcceleratorsList() {
      return accelerators_;
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of [hardware
     * accelerators](https://cloud.google.com/compute/docs/gpus) to attach to
     * each node.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig accelerators = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends
                com.google.cloud.dataproc.v1.GkeNodePoolConfig
                    .GkeNodePoolAcceleratorConfigOrBuilder>
        getAcceleratorsOrBuilderList() {
      return accelerators_;
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of [hardware
     * accelerators](https://cloud.google.com/compute/docs/gpus) to attach to
     * each node.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig accelerators = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public int getAcceleratorsCount() {
      return accelerators_.size();
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of [hardware
     * accelerators](https://cloud.google.com/compute/docs/gpus) to attach to
     * each node.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig accelerators = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig
        getAccelerators(int index) {
      return accelerators_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of [hardware
     * accelerators](https://cloud.google.com/compute/docs/gpus) to attach to
     * each node.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig accelerators = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfigOrBuilder
        getAcceleratorsOrBuilder(int index) {
      return accelerators_.get(index);
    }

    public static final int MIN_CPU_PLATFORM_FIELD_NUMBER = 13;

    @SuppressWarnings("serial")
    private volatile java.lang.Object minCpuPlatform_ = "";
    /**
     *
     *
     * <pre>
     * Optional. [Minimum CPU
     * platform](https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform)
     * to be used by this instance. The instance may be scheduled on the
     * specified or a newer CPU platform. Specify the friendly names of CPU
     * platforms, such as "Intel Haswell"` or Intel Sandy Bridge".
     * </pre>
     *
     * <code>string min_cpu_platform = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The minCpuPlatform.
     */
    @java.lang.Override
    public java.lang.String getMinCpuPlatform() {
      java.lang.Object ref = minCpuPlatform_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        minCpuPlatform_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. [Minimum CPU
     * platform](https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform)
     * to be used by this instance. The instance may be scheduled on the
     * specified or a newer CPU platform. Specify the friendly names of CPU
     * platforms, such as "Intel Haswell"` or Intel Sandy Bridge".
     * </pre>
     *
     * <code>string min_cpu_platform = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for minCpuPlatform.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getMinCpuPlatformBytes() {
      java.lang.Object ref = minCpuPlatform_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        minCpuPlatform_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int BOOT_DISK_KMS_KEY_FIELD_NUMBER = 23;

    @SuppressWarnings("serial")
    private volatile java.lang.Object bootDiskKmsKey_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The [Customer Managed Encryption Key (CMEK)]
     * (https://cloud.google.com/kubernetes-engine/docs/how-to/using-cmek)
     * used to encrypt the boot disk attached to each node in the node pool.
     * Specify the key using the following format:
     * &lt;code&gt;projects/&lt;var&gt;KEY_PROJECT_ID&lt;/var&gt;/locations/&lt;var&gt;LOCATION&lt;/var&gt;/keyRings/&lt;var&gt;RING_NAME&lt;/var&gt;/cryptoKeys/&lt;var&gt;KEY_NAME&lt;/var&gt;&lt;/code&gt;.
     * </pre>
     *
     * <code>string boot_disk_kms_key = 23 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bootDiskKmsKey.
     */
    @java.lang.Override
    public java.lang.String getBootDiskKmsKey() {
      java.lang.Object ref = bootDiskKmsKey_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        bootDiskKmsKey_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The [Customer Managed Encryption Key (CMEK)]
     * (https://cloud.google.com/kubernetes-engine/docs/how-to/using-cmek)
     * used to encrypt the boot disk attached to each node in the node pool.
     * Specify the key using the following format:
     * &lt;code&gt;projects/&lt;var&gt;KEY_PROJECT_ID&lt;/var&gt;/locations/&lt;var&gt;LOCATION&lt;/var&gt;/keyRings/&lt;var&gt;RING_NAME&lt;/var&gt;/cryptoKeys/&lt;var&gt;KEY_NAME&lt;/var&gt;&lt;/code&gt;.
     * </pre>
     *
     * <code>string boot_disk_kms_key = 23 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for bootDiskKmsKey.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getBootDiskKmsKeyBytes() {
      java.lang.Object ref = bootDiskKmsKey_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        bootDiskKmsKey_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int SPOT_FIELD_NUMBER = 32;
    private boolean spot_ = false;
    /**
     *
     *
     * <pre>
     * Optional. Whether the nodes are created as [Spot VM instances]
     * (https://cloud.google.com/compute/docs/instances/spot).
     * Spot VMs are the latest update to legacy
     * [preemptible
     * VMs][google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig.preemptible].
     * Spot VMs do not have a maximum lifetime. Legacy and Spot preemptible
     * nodes cannot be used in a node pool with the `CONTROLLER`
     * [role](/dataproc/docs/reference/rest/v1/projects.regions.clusters#role)
     * or in the DEFAULT node pool if the CONTROLLER role is not assigned (the
     * DEFAULT node pool will assume the CONTROLLER role).
     * </pre>
     *
     * <code>bool spot = 32 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The spot.
     */
    @java.lang.Override
    public boolean getSpot() {
      return spot_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(machineType_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, machineType_);
      }
      if (localSsdCount_ != 0) {
        output.writeInt32(7, localSsdCount_);
      }
      if (preemptible_ != false) {
        output.writeBool(10, preemptible_);
      }
      for (int i = 0; i < accelerators_.size(); i++) {
        output.writeMessage(11, accelerators_.get(i));
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(minCpuPlatform_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 13, minCpuPlatform_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(bootDiskKmsKey_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 23, bootDiskKmsKey_);
      }
      if (spot_ != false) {
        output.writeBool(32, spot_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(machineType_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, machineType_);
      }
      if (localSsdCount_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(7, localSsdCount_);
      }
      if (preemptible_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(10, preemptible_);
      }
      for (int i = 0; i < accelerators_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(11, accelerators_.get(i));
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(minCpuPlatform_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(13, minCpuPlatform_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(bootDiskKmsKey_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(23, bootDiskKmsKey_);
      }
      if (spot_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(32, spot_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig)) {
        return super.equals(obj);
      }
      com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig other =
          (com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig) obj;

      if (!getMachineType().equals(other.getMachineType())) return false;
      if (getLocalSsdCount() != other.getLocalSsdCount()) return false;
      if (getPreemptible() != other.getPreemptible()) return false;
      if (!getAcceleratorsList().equals(other.getAcceleratorsList())) return false;
      if (!getMinCpuPlatform().equals(other.getMinCpuPlatform())) return false;
      if (!getBootDiskKmsKey().equals(other.getBootDiskKmsKey())) return false;
      if (getSpot() != other.getSpot()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + MACHINE_TYPE_FIELD_NUMBER;
      hash = (53 * hash) + getMachineType().hashCode();
      hash = (37 * hash) + LOCAL_SSD_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + getLocalSsdCount();
      hash = (37 * hash) + PREEMPTIBLE_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getPreemptible());
      if (getAcceleratorsCount() > 0) {
        hash = (37 * hash) + ACCELERATORS_FIELD_NUMBER;
        hash = (53 * hash) + getAcceleratorsList().hashCode();
      }
      hash = (37 * hash) + MIN_CPU_PLATFORM_FIELD_NUMBER;
      hash = (53 * hash) + getMinCpuPlatform().hashCode();
      hash = (37 * hash) + BOOT_DISK_KMS_KEY_FIELD_NUMBER;
      hash = (53 * hash) + getBootDiskKmsKey().hashCode();
      hash = (37 * hash) + SPOT_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getSpot());
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Parameters that describe cluster nodes.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig)
        com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dataproc.v1.SharedProto
            .internal_static_google_cloud_dataproc_v1_GkeNodePoolConfig_GkeNodeConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dataproc.v1.SharedProto
            .internal_static_google_cloud_dataproc_v1_GkeNodePoolConfig_GkeNodeConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig.class,
                com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig.Builder.class);
      }

      // Construct using com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        machineType_ = "";
        localSsdCount_ = 0;
        preemptible_ = false;
        if (acceleratorsBuilder_ == null) {
          accelerators_ = java.util.Collections.emptyList();
        } else {
          accelerators_ = null;
          acceleratorsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000008);
        minCpuPlatform_ = "";
        bootDiskKmsKey_ = "";
        spot_ = false;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dataproc.v1.SharedProto
            .internal_static_google_cloud_dataproc_v1_GkeNodePoolConfig_GkeNodeConfig_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig
          getDefaultInstanceForType() {
        return com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig build() {
        com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig buildPartial() {
        com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig result =
            new com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig result) {
        if (acceleratorsBuilder_ == null) {
          if (((bitField0_ & 0x00000008) != 0)) {
            accelerators_ = java.util.Collections.unmodifiableList(accelerators_);
            bitField0_ = (bitField0_ & ~0x00000008);
          }
          result.accelerators_ = accelerators_;
        } else {
          result.accelerators_ = acceleratorsBuilder_.build();
        }
      }

      private void buildPartial0(
          com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.machineType_ = machineType_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.localSsdCount_ = localSsdCount_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.preemptible_ = preemptible_;
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.minCpuPlatform_ = minCpuPlatform_;
        }
        if (((from_bitField0_ & 0x00000020) != 0)) {
          result.bootDiskKmsKey_ = bootDiskKmsKey_;
        }
        if (((from_bitField0_ & 0x00000040) != 0)) {
          result.spot_ = spot_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig) {
          return mergeFrom((com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig other) {
        if (other
            == com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig.getDefaultInstance())
          return this;
        if (!other.getMachineType().isEmpty()) {
          machineType_ = other.machineType_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (other.getLocalSsdCount() != 0) {
          setLocalSsdCount(other.getLocalSsdCount());
        }
        if (other.getPreemptible() != false) {
          setPreemptible(other.getPreemptible());
        }
        if (acceleratorsBuilder_ == null) {
          if (!other.accelerators_.isEmpty()) {
            if (accelerators_.isEmpty()) {
              accelerators_ = other.accelerators_;
              bitField0_ = (bitField0_ & ~0x00000008);
            } else {
              ensureAcceleratorsIsMutable();
              accelerators_.addAll(other.accelerators_);
            }
            onChanged();
          }
        } else {
          if (!other.accelerators_.isEmpty()) {
            if (acceleratorsBuilder_.isEmpty()) {
              acceleratorsBuilder_.dispose();
              acceleratorsBuilder_ = null;
              accelerators_ = other.accelerators_;
              bitField0_ = (bitField0_ & ~0x00000008);
              acceleratorsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getAcceleratorsFieldBuilder()
                      : null;
            } else {
              acceleratorsBuilder_.addAllMessages(other.accelerators_);
            }
          }
        }
        if (!other.getMinCpuPlatform().isEmpty()) {
          minCpuPlatform_ = other.minCpuPlatform_;
          bitField0_ |= 0x00000010;
          onChanged();
        }
        if (!other.getBootDiskKmsKey().isEmpty()) {
          bootDiskKmsKey_ = other.bootDiskKmsKey_;
          bitField0_ |= 0x00000020;
          onChanged();
        }
        if (other.getSpot() != false) {
          setSpot(other.getSpot());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  machineType_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 56:
                {
                  localSsdCount_ = input.readInt32();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 56
              case 80:
                {
                  preemptible_ = input.readBool();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 80
              case 90:
                {
                  com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig m =
                      input.readMessage(
                          com.google.cloud.dataproc.v1.GkeNodePoolConfig
                              .GkeNodePoolAcceleratorConfig.parser(),
                          extensionRegistry);
                  if (acceleratorsBuilder_ == null) {
                    ensureAcceleratorsIsMutable();
                    accelerators_.add(m);
                  } else {
                    acceleratorsBuilder_.addMessage(m);
                  }
                  break;
                } // case 90
              case 106:
                {
                  minCpuPlatform_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000010;
                  break;
                } // case 106
              case 186:
                {
                  bootDiskKmsKey_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000020;
                  break;
                } // case 186
              case 256:
                {
                  spot_ = input.readBool();
                  bitField0_ |= 0x00000040;
                  break;
                } // case 256
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object machineType_ = "";
      /**
       *
       *
       * <pre>
       * Optional. The name of a Compute Engine [machine
       * type](https://cloud.google.com/compute/docs/machine-types).
       * </pre>
       *
       * <code>string machine_type = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The machineType.
       */
      public java.lang.String getMachineType() {
        java.lang.Object ref = machineType_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          machineType_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The name of a Compute Engine [machine
       * type](https://cloud.google.com/compute/docs/machine-types).
       * </pre>
       *
       * <code>string machine_type = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for machineType.
       */
      public com.google.protobuf.ByteString getMachineTypeBytes() {
        java.lang.Object ref = machineType_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          machineType_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The name of a Compute Engine [machine
       * type](https://cloud.google.com/compute/docs/machine-types).
       * </pre>
       *
       * <code>string machine_type = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The machineType to set.
       * @return This builder for chaining.
       */
      public Builder setMachineType(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        machineType_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The name of a Compute Engine [machine
       * type](https://cloud.google.com/compute/docs/machine-types).
       * </pre>
       *
       * <code>string machine_type = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMachineType() {
        machineType_ = getDefaultInstance().getMachineType();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The name of a Compute Engine [machine
       * type](https://cloud.google.com/compute/docs/machine-types).
       * </pre>
       *
       * <code>string machine_type = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The bytes for machineType to set.
       * @return This builder for chaining.
       */
      public Builder setMachineTypeBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        machineType_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private int localSsdCount_;
      /**
       *
       *
       * <pre>
       * Optional. The number of local SSD disks to attach to the node, which is
       * limited by the maximum number of disks allowable per zone (see [Adding
       * Local SSDs](https://cloud.google.com/compute/docs/disks/local-ssd)).
       * </pre>
       *
       * <code>int32 local_ssd_count = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The localSsdCount.
       */
      @java.lang.Override
      public int getLocalSsdCount() {
        return localSsdCount_;
      }
      /**
       *
       *
       * <pre>
       * Optional. The number of local SSD disks to attach to the node, which is
       * limited by the maximum number of disks allowable per zone (see [Adding
       * Local SSDs](https://cloud.google.com/compute/docs/disks/local-ssd)).
       * </pre>
       *
       * <code>int32 local_ssd_count = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The localSsdCount to set.
       * @return This builder for chaining.
       */
      public Builder setLocalSsdCount(int value) {

        localSsdCount_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The number of local SSD disks to attach to the node, which is
       * limited by the maximum number of disks allowable per zone (see [Adding
       * Local SSDs](https://cloud.google.com/compute/docs/disks/local-ssd)).
       * </pre>
       *
       * <code>int32 local_ssd_count = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearLocalSsdCount() {
        bitField0_ = (bitField0_ & ~0x00000002);
        localSsdCount_ = 0;
        onChanged();
        return this;
      }

      private boolean preemptible_;
      /**
       *
       *
       * <pre>
       * Optional. Whether the nodes are created as legacy [preemptible VM
       * instances] (https://cloud.google.com/compute/docs/instances/preemptible).
       * Also see
       * [Spot][google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig.spot]
       * VMs, preemptible VM instances without a maximum lifetime. Legacy and Spot
       * preemptible nodes cannot be used in a node pool with the `CONTROLLER`
       * [role]
       * (/dataproc/docs/reference/rest/v1/projects.regions.clusters#role)
       * or in the DEFAULT node pool if the CONTROLLER role is not assigned (the
       * DEFAULT node pool will assume the CONTROLLER role).
       * </pre>
       *
       * <code>bool preemptible = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The preemptible.
       */
      @java.lang.Override
      public boolean getPreemptible() {
        return preemptible_;
      }
      /**
       *
       *
       * <pre>
       * Optional. Whether the nodes are created as legacy [preemptible VM
       * instances] (https://cloud.google.com/compute/docs/instances/preemptible).
       * Also see
       * [Spot][google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig.spot]
       * VMs, preemptible VM instances without a maximum lifetime. Legacy and Spot
       * preemptible nodes cannot be used in a node pool with the `CONTROLLER`
       * [role]
       * (/dataproc/docs/reference/rest/v1/projects.regions.clusters#role)
       * or in the DEFAULT node pool if the CONTROLLER role is not assigned (the
       * DEFAULT node pool will assume the CONTROLLER role).
       * </pre>
       *
       * <code>bool preemptible = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The preemptible to set.
       * @return This builder for chaining.
       */
      public Builder setPreemptible(boolean value) {

        preemptible_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Whether the nodes are created as legacy [preemptible VM
       * instances] (https://cloud.google.com/compute/docs/instances/preemptible).
       * Also see
       * [Spot][google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig.spot]
       * VMs, preemptible VM instances without a maximum lifetime. Legacy and Spot
       * preemptible nodes cannot be used in a node pool with the `CONTROLLER`
       * [role]
       * (/dataproc/docs/reference/rest/v1/projects.regions.clusters#role)
       * or in the DEFAULT node pool if the CONTROLLER role is not assigned (the
       * DEFAULT node pool will assume the CONTROLLER role).
       * </pre>
       *
       * <code>bool preemptible = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPreemptible() {
        bitField0_ = (bitField0_ & ~0x00000004);
        preemptible_ = false;
        onChanged();
        return this;
      }

      private java.util.List<
              com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig>
          accelerators_ = java.util.Collections.emptyList();

      private void ensureAcceleratorsIsMutable() {
        if (!((bitField0_ & 0x00000008) != 0)) {
          accelerators_ =
              new java.util.ArrayList<
                  com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig>(
                  accelerators_);
          bitField0_ |= 0x00000008;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig,
              com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig.Builder,
              com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfigOrBuilder>
          acceleratorsBuilder_;

      /**
       *
       *
       * <pre>
       * Optional. A list of [hardware
       * accelerators](https://cloud.google.com/compute/docs/gpus) to attach to
       * each node.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig accelerators = 11 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public java.util.List<
              com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig>
          getAcceleratorsList() {
        if (acceleratorsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(accelerators_);
        } else {
          return acceleratorsBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. A list of [hardware
       * accelerators](https://cloud.google.com/compute/docs/gpus) to attach to
       * each node.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig accelerators = 11 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public int getAcceleratorsCount() {
        if (acceleratorsBuilder_ == null) {
          return accelerators_.size();
        } else {
          return acceleratorsBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. A list of [hardware
       * accelerators](https://cloud.google.com/compute/docs/gpus) to attach to
       * each node.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig accelerators = 11 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig
          getAccelerators(int index) {
        if (acceleratorsBuilder_ == null) {
          return accelerators_.get(index);
        } else {
          return acceleratorsBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. A list of [hardware
       * accelerators](https://cloud.google.com/compute/docs/gpus) to attach to
       * each node.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig accelerators = 11 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setAccelerators(
          int index,
          com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig value) {
        if (acceleratorsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureAcceleratorsIsMutable();
          accelerators_.set(index, value);
          onChanged();
        } else {
          acceleratorsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. A list of [hardware
       * accelerators](https://cloud.google.com/compute/docs/gpus) to attach to
       * each node.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig accelerators = 11 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setAccelerators(
          int index,
          com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig.Builder
              builderForValue) {
        if (acceleratorsBuilder_ == null) {
          ensureAcceleratorsIsMutable();
          accelerators_.set(index, builderForValue.build());
          onChanged();
        } else {
          acceleratorsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. A list of [hardware
       * accelerators](https://cloud.google.com/compute/docs/gpus) to attach to
       * each node.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig accelerators = 11 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder addAccelerators(
          com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig value) {
        if (acceleratorsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureAcceleratorsIsMutable();
          accelerators_.add(value);
          onChanged();
        } else {
          acceleratorsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. A list of [hardware
       * accelerators](https://cloud.google.com/compute/docs/gpus) to attach to
       * each node.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig accelerators = 11 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder addAccelerators(
          int index,
          com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig value) {
        if (acceleratorsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureAcceleratorsIsMutable();
          accelerators_.add(index, value);
          onChanged();
        } else {
          acceleratorsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. A list of [hardware
       * accelerators](https://cloud.google.com/compute/docs/gpus) to attach to
       * each node.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig accelerators = 11 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder addAccelerators(
          com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig.Builder
              builderForValue) {
        if (acceleratorsBuilder_ == null) {
          ensureAcceleratorsIsMutable();
          accelerators_.add(builderForValue.build());
          onChanged();
        } else {
          acceleratorsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. A list of [hardware
       * accelerators](https://cloud.google.com/compute/docs/gpus) to attach to
       * each node.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig accelerators = 11 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder addAccelerators(
          int index,
          com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig.Builder
              builderForValue) {
        if (acceleratorsBuilder_ == null) {
          ensureAcceleratorsIsMutable();
          accelerators_.add(index, builderForValue.build());
          onChanged();
        } else {
          acceleratorsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. A list of [hardware
       * accelerators](https://cloud.google.com/compute/docs/gpus) to attach to
       * each node.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig accelerators = 11 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder addAllAccelerators(
          java.lang.Iterable<
                  ? extends
                      com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig>
              values) {
        if (acceleratorsBuilder_ == null) {
          ensureAcceleratorsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, accelerators_);
          onChanged();
        } else {
          acceleratorsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. A list of [hardware
       * accelerators](https://cloud.google.com/compute/docs/gpus) to attach to
       * each node.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig accelerators = 11 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder clearAccelerators() {
        if (acceleratorsBuilder_ == null) {
          accelerators_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000008);
          onChanged();
        } else {
          acceleratorsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. A list of [hardware
       * accelerators](https://cloud.google.com/compute/docs/gpus) to attach to
       * each node.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig accelerators = 11 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder removeAccelerators(int index) {
        if (acceleratorsBuilder_ == null) {
          ensureAcceleratorsIsMutable();
          accelerators_.remove(index);
          onChanged();
        } else {
          acceleratorsBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. A list of [hardware
       * accelerators](https://cloud.google.com/compute/docs/gpus) to attach to
       * each node.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig accelerators = 11 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig.Builder
          getAcceleratorsBuilder(int index) {
        return getAcceleratorsFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * Optional. A list of [hardware
       * accelerators](https://cloud.google.com/compute/docs/gpus) to attach to
       * each node.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig accelerators = 11 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfigOrBuilder
          getAcceleratorsOrBuilder(int index) {
        if (acceleratorsBuilder_ == null) {
          return accelerators_.get(index);
        } else {
          return acceleratorsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. A list of [hardware
       * accelerators](https://cloud.google.com/compute/docs/gpus) to attach to
       * each node.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig accelerators = 11 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public java.util.List<
              ? extends
                  com.google.cloud.dataproc.v1.GkeNodePoolConfig
                      .GkeNodePoolAcceleratorConfigOrBuilder>
          getAcceleratorsOrBuilderList() {
        if (acceleratorsBuilder_ != null) {
          return acceleratorsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(accelerators_);
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. A list of [hardware
       * accelerators](https://cloud.google.com/compute/docs/gpus) to attach to
       * each node.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig accelerators = 11 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig.Builder
          addAcceleratorsBuilder() {
        return getAcceleratorsFieldBuilder()
            .addBuilder(
                com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Optional. A list of [hardware
       * accelerators](https://cloud.google.com/compute/docs/gpus) to attach to
       * each node.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig accelerators = 11 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig.Builder
          addAcceleratorsBuilder(int index) {
        return getAcceleratorsFieldBuilder()
            .addBuilder(
                index,
                com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Optional. A list of [hardware
       * accelerators](https://cloud.google.com/compute/docs/gpus) to attach to
       * each node.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig accelerators = 11 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public java.util.List<
              com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig.Builder>
          getAcceleratorsBuilderList() {
        return getAcceleratorsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig,
              com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig.Builder,
              com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfigOrBuilder>
          getAcceleratorsFieldBuilder() {
        if (acceleratorsBuilder_ == null) {
          acceleratorsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig,
                  com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig
                      .Builder,
                  com.google.cloud.dataproc.v1.GkeNodePoolConfig
                      .GkeNodePoolAcceleratorConfigOrBuilder>(
                  accelerators_,
                  ((bitField0_ & 0x00000008) != 0),
                  getParentForChildren(),
                  isClean());
          accelerators_ = null;
        }
        return acceleratorsBuilder_;
      }

      private java.lang.Object minCpuPlatform_ = "";
      /**
       *
       *
       * <pre>
       * Optional. [Minimum CPU
       * platform](https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform)
       * to be used by this instance. The instance may be scheduled on the
       * specified or a newer CPU platform. Specify the friendly names of CPU
       * platforms, such as "Intel Haswell"` or Intel Sandy Bridge".
       * </pre>
       *
       * <code>string min_cpu_platform = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The minCpuPlatform.
       */
      public java.lang.String getMinCpuPlatform() {
        java.lang.Object ref = minCpuPlatform_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          minCpuPlatform_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. [Minimum CPU
       * platform](https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform)
       * to be used by this instance. The instance may be scheduled on the
       * specified or a newer CPU platform. Specify the friendly names of CPU
       * platforms, such as "Intel Haswell"` or Intel Sandy Bridge".
       * </pre>
       *
       * <code>string min_cpu_platform = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for minCpuPlatform.
       */
      public com.google.protobuf.ByteString getMinCpuPlatformBytes() {
        java.lang.Object ref = minCpuPlatform_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          minCpuPlatform_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. [Minimum CPU
       * platform](https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform)
       * to be used by this instance. The instance may be scheduled on the
       * specified or a newer CPU platform. Specify the friendly names of CPU
       * platforms, such as "Intel Haswell"` or Intel Sandy Bridge".
       * </pre>
       *
       * <code>string min_cpu_platform = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The minCpuPlatform to set.
       * @return This builder for chaining.
       */
      public Builder setMinCpuPlatform(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        minCpuPlatform_ = value;
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. [Minimum CPU
       * platform](https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform)
       * to be used by this instance. The instance may be scheduled on the
       * specified or a newer CPU platform. Specify the friendly names of CPU
       * platforms, such as "Intel Haswell"` or Intel Sandy Bridge".
       * </pre>
       *
       * <code>string min_cpu_platform = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMinCpuPlatform() {
        minCpuPlatform_ = getDefaultInstance().getMinCpuPlatform();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. [Minimum CPU
       * platform](https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform)
       * to be used by this instance. The instance may be scheduled on the
       * specified or a newer CPU platform. Specify the friendly names of CPU
       * platforms, such as "Intel Haswell"` or Intel Sandy Bridge".
       * </pre>
       *
       * <code>string min_cpu_platform = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The bytes for minCpuPlatform to set.
       * @return This builder for chaining.
       */
      public Builder setMinCpuPlatformBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        minCpuPlatform_ = value;
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }

      private java.lang.Object bootDiskKmsKey_ = "";
      /**
       *
       *
       * <pre>
       * Optional. The [Customer Managed Encryption Key (CMEK)]
       * (https://cloud.google.com/kubernetes-engine/docs/how-to/using-cmek)
       * used to encrypt the boot disk attached to each node in the node pool.
       * Specify the key using the following format:
       * &lt;code&gt;projects/&lt;var&gt;KEY_PROJECT_ID&lt;/var&gt;/locations/&lt;var&gt;LOCATION&lt;/var&gt;/keyRings/&lt;var&gt;RING_NAME&lt;/var&gt;/cryptoKeys/&lt;var&gt;KEY_NAME&lt;/var&gt;&lt;/code&gt;.
       * </pre>
       *
       * <code>string boot_disk_kms_key = 23 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bootDiskKmsKey.
       */
      public java.lang.String getBootDiskKmsKey() {
        java.lang.Object ref = bootDiskKmsKey_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          bootDiskKmsKey_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The [Customer Managed Encryption Key (CMEK)]
       * (https://cloud.google.com/kubernetes-engine/docs/how-to/using-cmek)
       * used to encrypt the boot disk attached to each node in the node pool.
       * Specify the key using the following format:
       * &lt;code&gt;projects/&lt;var&gt;KEY_PROJECT_ID&lt;/var&gt;/locations/&lt;var&gt;LOCATION&lt;/var&gt;/keyRings/&lt;var&gt;RING_NAME&lt;/var&gt;/cryptoKeys/&lt;var&gt;KEY_NAME&lt;/var&gt;&lt;/code&gt;.
       * </pre>
       *
       * <code>string boot_disk_kms_key = 23 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for bootDiskKmsKey.
       */
      public com.google.protobuf.ByteString getBootDiskKmsKeyBytes() {
        java.lang.Object ref = bootDiskKmsKey_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          bootDiskKmsKey_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The [Customer Managed Encryption Key (CMEK)]
       * (https://cloud.google.com/kubernetes-engine/docs/how-to/using-cmek)
       * used to encrypt the boot disk attached to each node in the node pool.
       * Specify the key using the following format:
       * &lt;code&gt;projects/&lt;var&gt;KEY_PROJECT_ID&lt;/var&gt;/locations/&lt;var&gt;LOCATION&lt;/var&gt;/keyRings/&lt;var&gt;RING_NAME&lt;/var&gt;/cryptoKeys/&lt;var&gt;KEY_NAME&lt;/var&gt;&lt;/code&gt;.
       * </pre>
       *
       * <code>string boot_disk_kms_key = 23 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The bootDiskKmsKey to set.
       * @return This builder for chaining.
       */
      public Builder setBootDiskKmsKey(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bootDiskKmsKey_ = value;
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The [Customer Managed Encryption Key (CMEK)]
       * (https://cloud.google.com/kubernetes-engine/docs/how-to/using-cmek)
       * used to encrypt the boot disk attached to each node in the node pool.
       * Specify the key using the following format:
       * &lt;code&gt;projects/&lt;var&gt;KEY_PROJECT_ID&lt;/var&gt;/locations/&lt;var&gt;LOCATION&lt;/var&gt;/keyRings/&lt;var&gt;RING_NAME&lt;/var&gt;/cryptoKeys/&lt;var&gt;KEY_NAME&lt;/var&gt;&lt;/code&gt;.
       * </pre>
       *
       * <code>string boot_disk_kms_key = 23 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearBootDiskKmsKey() {
        bootDiskKmsKey_ = getDefaultInstance().getBootDiskKmsKey();
        bitField0_ = (bitField0_ & ~0x00000020);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The [Customer Managed Encryption Key (CMEK)]
       * (https://cloud.google.com/kubernetes-engine/docs/how-to/using-cmek)
       * used to encrypt the boot disk attached to each node in the node pool.
       * Specify the key using the following format:
       * &lt;code&gt;projects/&lt;var&gt;KEY_PROJECT_ID&lt;/var&gt;/locations/&lt;var&gt;LOCATION&lt;/var&gt;/keyRings/&lt;var&gt;RING_NAME&lt;/var&gt;/cryptoKeys/&lt;var&gt;KEY_NAME&lt;/var&gt;&lt;/code&gt;.
       * </pre>
       *
       * <code>string boot_disk_kms_key = 23 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The bytes for bootDiskKmsKey to set.
       * @return This builder for chaining.
       */
      public Builder setBootDiskKmsKeyBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        bootDiskKmsKey_ = value;
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }

      private boolean spot_;
      /**
       *
       *
       * <pre>
       * Optional. Whether the nodes are created as [Spot VM instances]
       * (https://cloud.google.com/compute/docs/instances/spot).
       * Spot VMs are the latest update to legacy
       * [preemptible
       * VMs][google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig.preemptible].
       * Spot VMs do not have a maximum lifetime. Legacy and Spot preemptible
       * nodes cannot be used in a node pool with the `CONTROLLER`
       * [role](/dataproc/docs/reference/rest/v1/projects.regions.clusters#role)
       * or in the DEFAULT node pool if the CONTROLLER role is not assigned (the
       * DEFAULT node pool will assume the CONTROLLER role).
       * </pre>
       *
       * <code>bool spot = 32 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The spot.
       */
      @java.lang.Override
      public boolean getSpot() {
        return spot_;
      }
      /**
       *
       *
       * <pre>
       * Optional. Whether the nodes are created as [Spot VM instances]
       * (https://cloud.google.com/compute/docs/instances/spot).
       * Spot VMs are the latest update to legacy
       * [preemptible
       * VMs][google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig.preemptible].
       * Spot VMs do not have a maximum lifetime. Legacy and Spot preemptible
       * nodes cannot be used in a node pool with the `CONTROLLER`
       * [role](/dataproc/docs/reference/rest/v1/projects.regions.clusters#role)
       * or in the DEFAULT node pool if the CONTROLLER role is not assigned (the
       * DEFAULT node pool will assume the CONTROLLER role).
       * </pre>
       *
       * <code>bool spot = 32 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The spot to set.
       * @return This builder for chaining.
       */
      public Builder setSpot(boolean value) {

        spot_ = value;
        bitField0_ |= 0x00000040;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Whether the nodes are created as [Spot VM instances]
       * (https://cloud.google.com/compute/docs/instances/spot).
       * Spot VMs are the latest update to legacy
       * [preemptible
       * VMs][google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig.preemptible].
       * Spot VMs do not have a maximum lifetime. Legacy and Spot preemptible
       * nodes cannot be used in a node pool with the `CONTROLLER`
       * [role](/dataproc/docs/reference/rest/v1/projects.regions.clusters#role)
       * or in the DEFAULT node pool if the CONTROLLER role is not assigned (the
       * DEFAULT node pool will assume the CONTROLLER role).
       * </pre>
       *
       * <code>bool spot = 32 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearSpot() {
        bitField0_ = (bitField0_ & ~0x00000040);
        spot_ = false;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig)
    private static final com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig();
    }

    public static com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<GkeNodeConfig> PARSER =
        new com.google.protobuf.AbstractParser<GkeNodeConfig>() {
          @java.lang.Override
          public GkeNodeConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<GkeNodeConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<GkeNodeConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface GkeNodePoolAcceleratorConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The number of accelerator cards exposed to an instance.
     * </pre>
     *
     * <code>int64 accelerator_count = 1;</code>
     *
     * @return The acceleratorCount.
     */
    long getAcceleratorCount();

    /**
     *
     *
     * <pre>
     * The accelerator type resource namename (see GPUs on Compute Engine).
     * </pre>
     *
     * <code>string accelerator_type = 2;</code>
     *
     * @return The acceleratorType.
     */
    java.lang.String getAcceleratorType();
    /**
     *
     *
     * <pre>
     * The accelerator type resource namename (see GPUs on Compute Engine).
     * </pre>
     *
     * <code>string accelerator_type = 2;</code>
     *
     * @return The bytes for acceleratorType.
     */
    com.google.protobuf.ByteString getAcceleratorTypeBytes();

    /**
     *
     *
     * <pre>
     * Size of partitions to create on the GPU. Valid values are described in
     * the NVIDIA [mig user
     * guide](https://docs.nvidia.com/datacenter/tesla/mig-user-guide/#partitioning).
     * </pre>
     *
     * <code>string gpu_partition_size = 3;</code>
     *
     * @return The gpuPartitionSize.
     */
    java.lang.String getGpuPartitionSize();
    /**
     *
     *
     * <pre>
     * Size of partitions to create on the GPU. Valid values are described in
     * the NVIDIA [mig user
     * guide](https://docs.nvidia.com/datacenter/tesla/mig-user-guide/#partitioning).
     * </pre>
     *
     * <code>string gpu_partition_size = 3;</code>
     *
     * @return The bytes for gpuPartitionSize.
     */
    com.google.protobuf.ByteString getGpuPartitionSizeBytes();
  }
  /**
   *
   *
   * <pre>
   * A GkeNodeConfigAcceleratorConfig represents a Hardware Accelerator request
   * for a node pool.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig}
   */
  public static final class GkeNodePoolAcceleratorConfig
      extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig)
      GkeNodePoolAcceleratorConfigOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use GkeNodePoolAcceleratorConfig.newBuilder() to construct.
    private GkeNodePoolAcceleratorConfig(
        com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private GkeNodePoolAcceleratorConfig() {
      acceleratorType_ = "";
      gpuPartitionSize_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new GkeNodePoolAcceleratorConfig();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dataproc.v1.SharedProto
          .internal_static_google_cloud_dataproc_v1_GkeNodePoolConfig_GkeNodePoolAcceleratorConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dataproc.v1.SharedProto
          .internal_static_google_cloud_dataproc_v1_GkeNodePoolConfig_GkeNodePoolAcceleratorConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig.class,
              com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig.Builder
                  .class);
    }

    public static final int ACCELERATOR_COUNT_FIELD_NUMBER = 1;
    private long acceleratorCount_ = 0L;
    /**
     *
     *
     * <pre>
     * The number of accelerator cards exposed to an instance.
     * </pre>
     *
     * <code>int64 accelerator_count = 1;</code>
     *
     * @return The acceleratorCount.
     */
    @java.lang.Override
    public long getAcceleratorCount() {
      return acceleratorCount_;
    }

    public static final int ACCELERATOR_TYPE_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object acceleratorType_ = "";
    /**
     *
     *
     * <pre>
     * The accelerator type resource namename (see GPUs on Compute Engine).
     * </pre>
     *
     * <code>string accelerator_type = 2;</code>
     *
     * @return The acceleratorType.
     */
    @java.lang.Override
    public java.lang.String getAcceleratorType() {
      java.lang.Object ref = acceleratorType_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        acceleratorType_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The accelerator type resource namename (see GPUs on Compute Engine).
     * </pre>
     *
     * <code>string accelerator_type = 2;</code>
     *
     * @return The bytes for acceleratorType.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getAcceleratorTypeBytes() {
      java.lang.Object ref = acceleratorType_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        acceleratorType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int GPU_PARTITION_SIZE_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private volatile java.lang.Object gpuPartitionSize_ = "";
    /**
     *
     *
     * <pre>
     * Size of partitions to create on the GPU. Valid values are described in
     * the NVIDIA [mig user
     * guide](https://docs.nvidia.com/datacenter/tesla/mig-user-guide/#partitioning).
     * </pre>
     *
     * <code>string gpu_partition_size = 3;</code>
     *
     * @return The gpuPartitionSize.
     */
    @java.lang.Override
    public java.lang.String getGpuPartitionSize() {
      java.lang.Object ref = gpuPartitionSize_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        gpuPartitionSize_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Size of partitions to create on the GPU. Valid values are described in
     * the NVIDIA [mig user
     * guide](https://docs.nvidia.com/datacenter/tesla/mig-user-guide/#partitioning).
     * </pre>
     *
     * <code>string gpu_partition_size = 3;</code>
     *
     * @return The bytes for gpuPartitionSize.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getGpuPartitionSizeBytes() {
      java.lang.Object ref = gpuPartitionSize_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        gpuPartitionSize_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (acceleratorCount_ != 0L) {
        output.writeInt64(1, acceleratorCount_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(acceleratorType_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, acceleratorType_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(gpuPartitionSize_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, gpuPartitionSize_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (acceleratorCount_ != 0L) {
        size += com.google.protobuf.CodedOutputStream.computeInt64Size(1, acceleratorCount_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(acceleratorType_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, acceleratorType_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(gpuPartitionSize_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, gpuPartitionSize_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig)) {
        return super.equals(obj);
      }
      com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig other =
          (com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig) obj;

      if (getAcceleratorCount() != other.getAcceleratorCount()) return false;
      if (!getAcceleratorType().equals(other.getAcceleratorType())) return false;
      if (!getGpuPartitionSize().equals(other.getGpuPartitionSize())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + ACCELERATOR_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getAcceleratorCount());
      hash = (37 * hash) + ACCELERATOR_TYPE_FIELD_NUMBER;
      hash = (53 * hash) + getAcceleratorType().hashCode();
      hash = (37 * hash) + GPU_PARTITION_SIZE_FIELD_NUMBER;
      hash = (53 * hash) + getGpuPartitionSize().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A GkeNodeConfigAcceleratorConfig represents a Hardware Accelerator request
     * for a node pool.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig)
        com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dataproc.v1.SharedProto
            .internal_static_google_cloud_dataproc_v1_GkeNodePoolConfig_GkeNodePoolAcceleratorConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dataproc.v1.SharedProto
            .internal_static_google_cloud_dataproc_v1_GkeNodePoolConfig_GkeNodePoolAcceleratorConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig.class,
                com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        acceleratorCount_ = 0L;
        acceleratorType_ = "";
        gpuPartitionSize_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dataproc.v1.SharedProto
            .internal_static_google_cloud_dataproc_v1_GkeNodePoolConfig_GkeNodePoolAcceleratorConfig_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig
          getDefaultInstanceForType() {
        return com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig build() {
        com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig
          buildPartial() {
        com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig result =
            new com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.acceleratorCount_ = acceleratorCount_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.acceleratorType_ = acceleratorType_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.gpuPartitionSize_ = gpuPartitionSize_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig) {
          return mergeFrom(
              (com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig other) {
        if (other
            == com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig
                .getDefaultInstance()) return this;
        if (other.getAcceleratorCount() != 0L) {
          setAcceleratorCount(other.getAcceleratorCount());
        }
        if (!other.getAcceleratorType().isEmpty()) {
          acceleratorType_ = other.acceleratorType_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (!other.getGpuPartitionSize().isEmpty()) {
          gpuPartitionSize_ = other.gpuPartitionSize_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  acceleratorCount_ = input.readInt64();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 18:
                {
                  acceleratorType_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  gpuPartitionSize_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private long acceleratorCount_;
      /**
       *
       *
       * <pre>
       * The number of accelerator cards exposed to an instance.
       * </pre>
       *
       * <code>int64 accelerator_count = 1;</code>
       *
       * @return The acceleratorCount.
       */
      @java.lang.Override
      public long getAcceleratorCount() {
        return acceleratorCount_;
      }
      /**
       *
       *
       * <pre>
       * The number of accelerator cards exposed to an instance.
       * </pre>
       *
       * <code>int64 accelerator_count = 1;</code>
       *
       * @param value The acceleratorCount to set.
       * @return This builder for chaining.
       */
      public Builder setAcceleratorCount(long value) {

        acceleratorCount_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The number of accelerator cards exposed to an instance.
       * </pre>
       *
       * <code>int64 accelerator_count = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAcceleratorCount() {
        bitField0_ = (bitField0_ & ~0x00000001);
        acceleratorCount_ = 0L;
        onChanged();
        return this;
      }

      private java.lang.Object acceleratorType_ = "";
      /**
       *
       *
       * <pre>
       * The accelerator type resource namename (see GPUs on Compute Engine).
       * </pre>
       *
       * <code>string accelerator_type = 2;</code>
       *
       * @return The acceleratorType.
       */
      public java.lang.String getAcceleratorType() {
        java.lang.Object ref = acceleratorType_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          acceleratorType_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The accelerator type resource namename (see GPUs on Compute Engine).
       * </pre>
       *
       * <code>string accelerator_type = 2;</code>
       *
       * @return The bytes for acceleratorType.
       */
      public com.google.protobuf.ByteString getAcceleratorTypeBytes() {
        java.lang.Object ref = acceleratorType_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          acceleratorType_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The accelerator type resource namename (see GPUs on Compute Engine).
       * </pre>
       *
       * <code>string accelerator_type = 2;</code>
       *
       * @param value The acceleratorType to set.
       * @return This builder for chaining.
       */
      public Builder setAcceleratorType(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        acceleratorType_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The accelerator type resource namename (see GPUs on Compute Engine).
       * </pre>
       *
       * <code>string accelerator_type = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAcceleratorType() {
        acceleratorType_ = getDefaultInstance().getAcceleratorType();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The accelerator type resource namename (see GPUs on Compute Engine).
       * </pre>
       *
       * <code>string accelerator_type = 2;</code>
       *
       * @param value The bytes for acceleratorType to set.
       * @return This builder for chaining.
       */
      public Builder setAcceleratorTypeBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        acceleratorType_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private java.lang.Object gpuPartitionSize_ = "";
      /**
       *
       *
       * <pre>
       * Size of partitions to create on the GPU. Valid values are described in
       * the NVIDIA [mig user
       * guide](https://docs.nvidia.com/datacenter/tesla/mig-user-guide/#partitioning).
       * </pre>
       *
       * <code>string gpu_partition_size = 3;</code>
       *
       * @return The gpuPartitionSize.
       */
      public java.lang.String getGpuPartitionSize() {
        java.lang.Object ref = gpuPartitionSize_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          gpuPartitionSize_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Size of partitions to create on the GPU. Valid values are described in
       * the NVIDIA [mig user
       * guide](https://docs.nvidia.com/datacenter/tesla/mig-user-guide/#partitioning).
       * </pre>
       *
       * <code>string gpu_partition_size = 3;</code>
       *
       * @return The bytes for gpuPartitionSize.
       */
      public com.google.protobuf.ByteString getGpuPartitionSizeBytes() {
        java.lang.Object ref = gpuPartitionSize_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          gpuPartitionSize_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Size of partitions to create on the GPU. Valid values are described in
       * the NVIDIA [mig user
       * guide](https://docs.nvidia.com/datacenter/tesla/mig-user-guide/#partitioning).
       * </pre>
       *
       * <code>string gpu_partition_size = 3;</code>
       *
       * @param value The gpuPartitionSize to set.
       * @return This builder for chaining.
       */
      public Builder setGpuPartitionSize(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        gpuPartitionSize_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Size of partitions to create on the GPU. Valid values are described in
       * the NVIDIA [mig user
       * guide](https://docs.nvidia.com/datacenter/tesla/mig-user-guide/#partitioning).
       * </pre>
       *
       * <code>string gpu_partition_size = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearGpuPartitionSize() {
        gpuPartitionSize_ = getDefaultInstance().getGpuPartitionSize();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Size of partitions to create on the GPU. Valid values are described in
       * the NVIDIA [mig user
       * guide](https://docs.nvidia.com/datacenter/tesla/mig-user-guide/#partitioning).
       * </pre>
       *
       * <code>string gpu_partition_size = 3;</code>
       *
       * @param value The bytes for gpuPartitionSize to set.
       * @return This builder for chaining.
       */
      public Builder setGpuPartitionSizeBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        gpuPartitionSize_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig)
    private static final com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig();
    }

    public static com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<GkeNodePoolAcceleratorConfig> PARSER =
        new com.google.protobuf.AbstractParser<GkeNodePoolAcceleratorConfig>() {
          @java.lang.Override
          public GkeNodePoolAcceleratorConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<GkeNodePoolAcceleratorConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<GkeNodePoolAcceleratorConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface GkeNodePoolAutoscalingConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The minimum number of nodes in the node pool. Must be &gt;= 0 and &lt;=
     * max_node_count.
     * </pre>
     *
     * <code>int32 min_node_count = 2;</code>
     *
     * @return The minNodeCount.
     */
    int getMinNodeCount();

    /**
     *
     *
     * <pre>
     * The maximum number of nodes in the node pool. Must be &gt;= min_node_count,
     * and must be &gt; 0.
     * **Note:** Quota must be sufficient to scale up the cluster.
     * </pre>
     *
     * <code>int32 max_node_count = 3;</code>
     *
     * @return The maxNodeCount.
     */
    int getMaxNodeCount();
  }
  /**
   *
   *
   * <pre>
   * GkeNodePoolAutoscaling contains information the cluster autoscaler needs to
   * adjust the size of the node pool to the current cluster usage.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig}
   */
  public static final class GkeNodePoolAutoscalingConfig
      extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig)
      GkeNodePoolAutoscalingConfigOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use GkeNodePoolAutoscalingConfig.newBuilder() to construct.
    private GkeNodePoolAutoscalingConfig(
        com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private GkeNodePoolAutoscalingConfig() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new GkeNodePoolAutoscalingConfig();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dataproc.v1.SharedProto
          .internal_static_google_cloud_dataproc_v1_GkeNodePoolConfig_GkeNodePoolAutoscalingConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dataproc.v1.SharedProto
          .internal_static_google_cloud_dataproc_v1_GkeNodePoolConfig_GkeNodePoolAutoscalingConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig.class,
              com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig.Builder
                  .class);
    }

    public static final int MIN_NODE_COUNT_FIELD_NUMBER = 2;
    private int minNodeCount_ = 0;
    /**
     *
     *
     * <pre>
     * The minimum number of nodes in the node pool. Must be &gt;= 0 and &lt;=
     * max_node_count.
     * </pre>
     *
     * <code>int32 min_node_count = 2;</code>
     *
     * @return The minNodeCount.
     */
    @java.lang.Override
    public int getMinNodeCount() {
      return minNodeCount_;
    }

    public static final int MAX_NODE_COUNT_FIELD_NUMBER = 3;
    private int maxNodeCount_ = 0;
    /**
     *
     *
     * <pre>
     * The maximum number of nodes in the node pool. Must be &gt;= min_node_count,
     * and must be &gt; 0.
     * **Note:** Quota must be sufficient to scale up the cluster.
     * </pre>
     *
     * <code>int32 max_node_count = 3;</code>
     *
     * @return The maxNodeCount.
     */
    @java.lang.Override
    public int getMaxNodeCount() {
      return maxNodeCount_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (minNodeCount_ != 0) {
        output.writeInt32(2, minNodeCount_);
      }
      if (maxNodeCount_ != 0) {
        output.writeInt32(3, maxNodeCount_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (minNodeCount_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, minNodeCount_);
      }
      if (maxNodeCount_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(3, maxNodeCount_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig)) {
        return super.equals(obj);
      }
      com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig other =
          (com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig) obj;

      if (getMinNodeCount() != other.getMinNodeCount()) return false;
      if (getMaxNodeCount() != other.getMaxNodeCount()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + MIN_NODE_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + getMinNodeCount();
      hash = (37 * hash) + MAX_NODE_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + getMaxNodeCount();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * GkeNodePoolAutoscaling contains information the cluster autoscaler needs to
     * adjust the size of the node pool to the current cluster usage.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig)
        com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dataproc.v1.SharedProto
            .internal_static_google_cloud_dataproc_v1_GkeNodePoolConfig_GkeNodePoolAutoscalingConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dataproc.v1.SharedProto
            .internal_static_google_cloud_dataproc_v1_GkeNodePoolConfig_GkeNodePoolAutoscalingConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig.class,
                com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        minNodeCount_ = 0;
        maxNodeCount_ = 0;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dataproc.v1.SharedProto
            .internal_static_google_cloud_dataproc_v1_GkeNodePoolConfig_GkeNodePoolAutoscalingConfig_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig
          getDefaultInstanceForType() {
        return com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig build() {
        com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig
          buildPartial() {
        com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig result =
            new com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.minNodeCount_ = minNodeCount_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.maxNodeCount_ = maxNodeCount_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig) {
          return mergeFrom(
              (com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig other) {
        if (other
            == com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig
                .getDefaultInstance()) return this;
        if (other.getMinNodeCount() != 0) {
          setMinNodeCount(other.getMinNodeCount());
        }
        if (other.getMaxNodeCount() != 0) {
          setMaxNodeCount(other.getMaxNodeCount());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 16:
                {
                  minNodeCount_ = input.readInt32();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 16
              case 24:
                {
                  maxNodeCount_ = input.readInt32();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 24
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int minNodeCount_;
      /**
       *
       *
       * <pre>
       * The minimum number of nodes in the node pool. Must be &gt;= 0 and &lt;=
       * max_node_count.
       * </pre>
       *
       * <code>int32 min_node_count = 2;</code>
       *
       * @return The minNodeCount.
       */
      @java.lang.Override
      public int getMinNodeCount() {
        return minNodeCount_;
      }
      /**
       *
       *
       * <pre>
       * The minimum number of nodes in the node pool. Must be &gt;= 0 and &lt;=
       * max_node_count.
       * </pre>
       *
       * <code>int32 min_node_count = 2;</code>
       *
       * @param value The minNodeCount to set.
       * @return This builder for chaining.
       */
      public Builder setMinNodeCount(int value) {

        minNodeCount_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The minimum number of nodes in the node pool. Must be &gt;= 0 and &lt;=
       * max_node_count.
       * </pre>
       *
       * <code>int32 min_node_count = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMinNodeCount() {
        bitField0_ = (bitField0_ & ~0x00000001);
        minNodeCount_ = 0;
        onChanged();
        return this;
      }

      private int maxNodeCount_;
      /**
       *
       *
       * <pre>
       * The maximum number of nodes in the node pool. Must be &gt;= min_node_count,
       * and must be &gt; 0.
       * **Note:** Quota must be sufficient to scale up the cluster.
       * </pre>
       *
       * <code>int32 max_node_count = 3;</code>
       *
       * @return The maxNodeCount.
       */
      @java.lang.Override
      public int getMaxNodeCount() {
        return maxNodeCount_;
      }
      /**
       *
       *
       * <pre>
       * The maximum number of nodes in the node pool. Must be &gt;= min_node_count,
       * and must be &gt; 0.
       * **Note:** Quota must be sufficient to scale up the cluster.
       * </pre>
       *
       * <code>int32 max_node_count = 3;</code>
       *
       * @param value The maxNodeCount to set.
       * @return This builder for chaining.
       */
      public Builder setMaxNodeCount(int value) {

        maxNodeCount_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The maximum number of nodes in the node pool. Must be &gt;= min_node_count,
       * and must be &gt; 0.
       * **Note:** Quota must be sufficient to scale up the cluster.
       * </pre>
       *
       * <code>int32 max_node_count = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMaxNodeCount() {
        bitField0_ = (bitField0_ & ~0x00000002);
        maxNodeCount_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig)
    private static final com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig();
    }

    public static com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<GkeNodePoolAutoscalingConfig> PARSER =
        new com.google.protobuf.AbstractParser<GkeNodePoolAutoscalingConfig>() {
          @java.lang.Override
          public GkeNodePoolAutoscalingConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<GkeNodePoolAutoscalingConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<GkeNodePoolAutoscalingConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int CONFIG_FIELD_NUMBER = 2;
  private com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig config_;
  /**
   *
   *
   * <pre>
   * Optional. The node pool configuration.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig config = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the config field is set.
   */
  @java.lang.Override
  public boolean hasConfig() {
    return config_ != null;
  }
  /**
   *
   *
   * <pre>
   * Optional. The node pool configuration.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig config = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The config.
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig getConfig() {
    return config_ == null
        ? com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig.getDefaultInstance()
        : config_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The node pool configuration.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig config = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfigOrBuilder
      getConfigOrBuilder() {
    return config_ == null
        ? com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig.getDefaultInstance()
        : config_;
  }

  public static final int LOCATIONS_FIELD_NUMBER = 13;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList locations_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Optional. The list of Compute Engine
   * [zones](https://cloud.google.com/compute/docs/zones#available) where
   * node pool nodes associated with a Dataproc on GKE virtual cluster
   * will be located.
   *
   * **Note:** All node pools associated with a virtual cluster
   * must be located in the same region as the virtual cluster, and they must
   * be located in the same zone within that region.
   *
   * If a location is not specified during node pool creation, Dataproc on GKE
   * will choose the zone.
   * </pre>
   *
   * <code>repeated string locations = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return A list containing the locations.
   */
  public com.google.protobuf.ProtocolStringList getLocationsList() {
    return locations_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The list of Compute Engine
   * [zones](https://cloud.google.com/compute/docs/zones#available) where
   * node pool nodes associated with a Dataproc on GKE virtual cluster
   * will be located.
   *
   * **Note:** All node pools associated with a virtual cluster
   * must be located in the same region as the virtual cluster, and they must
   * be located in the same zone within that region.
   *
   * If a location is not specified during node pool creation, Dataproc on GKE
   * will choose the zone.
   * </pre>
   *
   * <code>repeated string locations = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The count of locations.
   */
  public int getLocationsCount() {
    return locations_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. The list of Compute Engine
   * [zones](https://cloud.google.com/compute/docs/zones#available) where
   * node pool nodes associated with a Dataproc on GKE virtual cluster
   * will be located.
   *
   * **Note:** All node pools associated with a virtual cluster
   * must be located in the same region as the virtual cluster, and they must
   * be located in the same zone within that region.
   *
   * If a location is not specified during node pool creation, Dataproc on GKE
   * will choose the zone.
   * </pre>
   *
   * <code>repeated string locations = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the element to return.
   * @return The locations at the given index.
   */
  public java.lang.String getLocations(int index) {
    return locations_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. The list of Compute Engine
   * [zones](https://cloud.google.com/compute/docs/zones#available) where
   * node pool nodes associated with a Dataproc on GKE virtual cluster
   * will be located.
   *
   * **Note:** All node pools associated with a virtual cluster
   * must be located in the same region as the virtual cluster, and they must
   * be located in the same zone within that region.
   *
   * If a location is not specified during node pool creation, Dataproc on GKE
   * will choose the zone.
   * </pre>
   *
   * <code>repeated string locations = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the locations at the given index.
   */
  public com.google.protobuf.ByteString getLocationsBytes(int index) {
    return locations_.getByteString(index);
  }

  public static final int AUTOSCALING_FIELD_NUMBER = 4;
  private com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig autoscaling_;
  /**
   *
   *
   * <pre>
   * Optional. The autoscaler configuration for this node pool. The autoscaler
   * is enabled only when a valid configuration is present.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig autoscaling = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the autoscaling field is set.
   */
  @java.lang.Override
  public boolean hasAutoscaling() {
    return autoscaling_ != null;
  }
  /**
   *
   *
   * <pre>
   * Optional. The autoscaler configuration for this node pool. The autoscaler
   * is enabled only when a valid configuration is present.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig autoscaling = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The autoscaling.
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig
      getAutoscaling() {
    return autoscaling_ == null
        ? com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig
            .getDefaultInstance()
        : autoscaling_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The autoscaler configuration for this node pool. The autoscaler
   * is enabled only when a valid configuration is present.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig autoscaling = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfigOrBuilder
      getAutoscalingOrBuilder() {
    return autoscaling_ == null
        ? com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig
            .getDefaultInstance()
        : autoscaling_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (config_ != null) {
      output.writeMessage(2, getConfig());
    }
    if (autoscaling_ != null) {
      output.writeMessage(4, getAutoscaling());
    }
    for (int i = 0; i < locations_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 13, locations_.getRaw(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (config_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getConfig());
    }
    if (autoscaling_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getAutoscaling());
    }
    {
      int dataSize = 0;
      for (int i = 0; i < locations_.size(); i++) {
        dataSize += computeStringSizeNoTag(locations_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getLocationsList().size();
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dataproc.v1.GkeNodePoolConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.dataproc.v1.GkeNodePoolConfig other =
        (com.google.cloud.dataproc.v1.GkeNodePoolConfig) obj;

    if (hasConfig() != other.hasConfig()) return false;
    if (hasConfig()) {
      if (!getConfig().equals(other.getConfig())) return false;
    }
    if (!getLocationsList().equals(other.getLocationsList())) return false;
    if (hasAutoscaling() != other.hasAutoscaling()) return false;
    if (hasAutoscaling()) {
      if (!getAutoscaling().equals(other.getAutoscaling())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasConfig()) {
      hash = (37 * hash) + CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getConfig().hashCode();
    }
    if (getLocationsCount() > 0) {
      hash = (37 * hash) + LOCATIONS_FIELD_NUMBER;
      hash = (53 * hash) + getLocationsList().hashCode();
    }
    if (hasAutoscaling()) {
      hash = (37 * hash) + AUTOSCALING_FIELD_NUMBER;
      hash = (53 * hash) + getAutoscaling().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dataproc.v1.GkeNodePoolConfig parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1.GkeNodePoolConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.GkeNodePoolConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1.GkeNodePoolConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.GkeNodePoolConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1.GkeNodePoolConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.GkeNodePoolConfig parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1.GkeNodePoolConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.GkeNodePoolConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1.GkeNodePoolConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.GkeNodePoolConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1.GkeNodePoolConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.dataproc.v1.GkeNodePoolConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The configuration of a GKE node pool used by a [Dataproc-on-GKE
   * cluster](https://cloud.google.com/dataproc/docs/concepts/jobs/dataproc-gke#create-a-dataproc-on-gke-cluster).
   * </pre>
   *
   * Protobuf type {@code google.cloud.dataproc.v1.GkeNodePoolConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dataproc.v1.GkeNodePoolConfig)
      com.google.cloud.dataproc.v1.GkeNodePoolConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dataproc.v1.SharedProto
          .internal_static_google_cloud_dataproc_v1_GkeNodePoolConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dataproc.v1.SharedProto
          .internal_static_google_cloud_dataproc_v1_GkeNodePoolConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dataproc.v1.GkeNodePoolConfig.class,
              com.google.cloud.dataproc.v1.GkeNodePoolConfig.Builder.class);
    }

    // Construct using com.google.cloud.dataproc.v1.GkeNodePoolConfig.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      config_ = null;
      if (configBuilder_ != null) {
        configBuilder_.dispose();
        configBuilder_ = null;
      }
      locations_ = com.google.protobuf.LazyStringArrayList.emptyList();
      autoscaling_ = null;
      if (autoscalingBuilder_ != null) {
        autoscalingBuilder_.dispose();
        autoscalingBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dataproc.v1.SharedProto
          .internal_static_google_cloud_dataproc_v1_GkeNodePoolConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.GkeNodePoolConfig getDefaultInstanceForType() {
      return com.google.cloud.dataproc.v1.GkeNodePoolConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.GkeNodePoolConfig build() {
      com.google.cloud.dataproc.v1.GkeNodePoolConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.GkeNodePoolConfig buildPartial() {
      com.google.cloud.dataproc.v1.GkeNodePoolConfig result =
          new com.google.cloud.dataproc.v1.GkeNodePoolConfig(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.dataproc.v1.GkeNodePoolConfig result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.config_ = configBuilder_ == null ? config_ : configBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        locations_.makeImmutable();
        result.locations_ = locations_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.autoscaling_ =
            autoscalingBuilder_ == null ? autoscaling_ : autoscalingBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dataproc.v1.GkeNodePoolConfig) {
        return mergeFrom((com.google.cloud.dataproc.v1.GkeNodePoolConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dataproc.v1.GkeNodePoolConfig other) {
      if (other == com.google.cloud.dataproc.v1.GkeNodePoolConfig.getDefaultInstance()) return this;
      if (other.hasConfig()) {
        mergeConfig(other.getConfig());
      }
      if (!other.locations_.isEmpty()) {
        if (locations_.isEmpty()) {
          locations_ = other.locations_;
          bitField0_ |= 0x00000002;
        } else {
          ensureLocationsIsMutable();
          locations_.addAll(other.locations_);
        }
        onChanged();
      }
      if (other.hasAutoscaling()) {
        mergeAutoscaling(other.getAutoscaling());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 18:
              {
                input.readMessage(getConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 18
            case 34:
              {
                input.readMessage(getAutoscalingFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 34
            case 106:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureLocationsIsMutable();
                locations_.add(s);
                break;
              } // case 106
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig config_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig,
            com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig.Builder,
            com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfigOrBuilder>
        configBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. The node pool configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig config = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the config field is set.
     */
    public boolean hasConfig() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. The node pool configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig config = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The config.
     */
    public com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig getConfig() {
      if (configBuilder_ == null) {
        return config_ == null
            ? com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig.getDefaultInstance()
            : config_;
      } else {
        return configBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The node pool configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig config = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setConfig(com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig value) {
      if (configBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        config_ = value;
      } else {
        configBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The node pool configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig config = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setConfig(
        com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig.Builder builderForValue) {
      if (configBuilder_ == null) {
        config_ = builderForValue.build();
      } else {
        configBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The node pool configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig config = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeConfig(com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig value) {
      if (configBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && config_ != null
            && config_
                != com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig
                    .getDefaultInstance()) {
          getConfigBuilder().mergeFrom(value);
        } else {
          config_ = value;
        }
      } else {
        configBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The node pool configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig config = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearConfig() {
      bitField0_ = (bitField0_ & ~0x00000001);
      config_ = null;
      if (configBuilder_ != null) {
        configBuilder_.dispose();
        configBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The node pool configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig config = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig.Builder getConfigBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. The node pool configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig config = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfigOrBuilder
        getConfigOrBuilder() {
      if (configBuilder_ != null) {
        return configBuilder_.getMessageOrBuilder();
      } else {
        return config_ == null
            ? com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig.getDefaultInstance()
            : config_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The node pool configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig config = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig,
            com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig.Builder,
            com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfigOrBuilder>
        getConfigFieldBuilder() {
      if (configBuilder_ == null) {
        configBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig,
                com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig.Builder,
                com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfigOrBuilder>(
                getConfig(), getParentForChildren(), isClean());
        config_ = null;
      }
      return configBuilder_;
    }

    private com.google.protobuf.LazyStringArrayList locations_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureLocationsIsMutable() {
      if (!locations_.isModifiable()) {
        locations_ = new com.google.protobuf.LazyStringArrayList(locations_);
      }
      bitField0_ |= 0x00000002;
    }
    /**
     *
     *
     * <pre>
     * Optional. The list of Compute Engine
     * [zones](https://cloud.google.com/compute/docs/zones#available) where
     * node pool nodes associated with a Dataproc on GKE virtual cluster
     * will be located.
     *
     * **Note:** All node pools associated with a virtual cluster
     * must be located in the same region as the virtual cluster, and they must
     * be located in the same zone within that region.
     *
     * If a location is not specified during node pool creation, Dataproc on GKE
     * will choose the zone.
     * </pre>
     *
     * <code>repeated string locations = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return A list containing the locations.
     */
    public com.google.protobuf.ProtocolStringList getLocationsList() {
      locations_.makeImmutable();
      return locations_;
    }
    /**
     *
     *
     * <pre>
     * Optional. The list of Compute Engine
     * [zones](https://cloud.google.com/compute/docs/zones#available) where
     * node pool nodes associated with a Dataproc on GKE virtual cluster
     * will be located.
     *
     * **Note:** All node pools associated with a virtual cluster
     * must be located in the same region as the virtual cluster, and they must
     * be located in the same zone within that region.
     *
     * If a location is not specified during node pool creation, Dataproc on GKE
     * will choose the zone.
     * </pre>
     *
     * <code>repeated string locations = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The count of locations.
     */
    public int getLocationsCount() {
      return locations_.size();
    }
    /**
     *
     *
     * <pre>
     * Optional. The list of Compute Engine
     * [zones](https://cloud.google.com/compute/docs/zones#available) where
     * node pool nodes associated with a Dataproc on GKE virtual cluster
     * will be located.
     *
     * **Note:** All node pools associated with a virtual cluster
     * must be located in the same region as the virtual cluster, and they must
     * be located in the same zone within that region.
     *
     * If a location is not specified during node pool creation, Dataproc on GKE
     * will choose the zone.
     * </pre>
     *
     * <code>repeated string locations = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the element to return.
     * @return The locations at the given index.
     */
    public java.lang.String getLocations(int index) {
      return locations_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. The list of Compute Engine
     * [zones](https://cloud.google.com/compute/docs/zones#available) where
     * node pool nodes associated with a Dataproc on GKE virtual cluster
     * will be located.
     *
     * **Note:** All node pools associated with a virtual cluster
     * must be located in the same region as the virtual cluster, and they must
     * be located in the same zone within that region.
     *
     * If a location is not specified during node pool creation, Dataproc on GKE
     * will choose the zone.
     * </pre>
     *
     * <code>repeated string locations = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the locations at the given index.
     */
    public com.google.protobuf.ByteString getLocationsBytes(int index) {
      return locations_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. The list of Compute Engine
     * [zones](https://cloud.google.com/compute/docs/zones#available) where
     * node pool nodes associated with a Dataproc on GKE virtual cluster
     * will be located.
     *
     * **Note:** All node pools associated with a virtual cluster
     * must be located in the same region as the virtual cluster, and they must
     * be located in the same zone within that region.
     *
     * If a location is not specified during node pool creation, Dataproc on GKE
     * will choose the zone.
     * </pre>
     *
     * <code>repeated string locations = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index to set the value at.
     * @param value The locations to set.
     * @return This builder for chaining.
     */
    public Builder setLocations(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureLocationsIsMutable();
      locations_.set(index, value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The list of Compute Engine
     * [zones](https://cloud.google.com/compute/docs/zones#available) where
     * node pool nodes associated with a Dataproc on GKE virtual cluster
     * will be located.
     *
     * **Note:** All node pools associated with a virtual cluster
     * must be located in the same region as the virtual cluster, and they must
     * be located in the same zone within that region.
     *
     * If a location is not specified during node pool creation, Dataproc on GKE
     * will choose the zone.
     * </pre>
     *
     * <code>repeated string locations = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The locations to add.
     * @return This builder for chaining.
     */
    public Builder addLocations(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureLocationsIsMutable();
      locations_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The list of Compute Engine
     * [zones](https://cloud.google.com/compute/docs/zones#available) where
     * node pool nodes associated with a Dataproc on GKE virtual cluster
     * will be located.
     *
     * **Note:** All node pools associated with a virtual cluster
     * must be located in the same region as the virtual cluster, and they must
     * be located in the same zone within that region.
     *
     * If a location is not specified during node pool creation, Dataproc on GKE
     * will choose the zone.
     * </pre>
     *
     * <code>repeated string locations = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param values The locations to add.
     * @return This builder for chaining.
     */
    public Builder addAllLocations(java.lang.Iterable<java.lang.String> values) {
      ensureLocationsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, locations_);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The list of Compute Engine
     * [zones](https://cloud.google.com/compute/docs/zones#available) where
     * node pool nodes associated with a Dataproc on GKE virtual cluster
     * will be located.
     *
     * **Note:** All node pools associated with a virtual cluster
     * must be located in the same region as the virtual cluster, and they must
     * be located in the same zone within that region.
     *
     * If a location is not specified during node pool creation, Dataproc on GKE
     * will choose the zone.
     * </pre>
     *
     * <code>repeated string locations = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLocations() {
      locations_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000002);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The list of Compute Engine
     * [zones](https://cloud.google.com/compute/docs/zones#available) where
     * node pool nodes associated with a Dataproc on GKE virtual cluster
     * will be located.
     *
     * **Note:** All node pools associated with a virtual cluster
     * must be located in the same region as the virtual cluster, and they must
     * be located in the same zone within that region.
     *
     * If a location is not specified during node pool creation, Dataproc on GKE
     * will choose the zone.
     * </pre>
     *
     * <code>repeated string locations = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes of the locations to add.
     * @return This builder for chaining.
     */
    public Builder addLocationsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureLocationsIsMutable();
      locations_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig
        autoscaling_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig,
            com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig.Builder,
            com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfigOrBuilder>
        autoscalingBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. The autoscaler configuration for this node pool. The autoscaler
     * is enabled only when a valid configuration is present.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig autoscaling = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the autoscaling field is set.
     */
    public boolean hasAutoscaling() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. The autoscaler configuration for this node pool. The autoscaler
     * is enabled only when a valid configuration is present.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig autoscaling = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The autoscaling.
     */
    public com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig
        getAutoscaling() {
      if (autoscalingBuilder_ == null) {
        return autoscaling_ == null
            ? com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig
                .getDefaultInstance()
            : autoscaling_;
      } else {
        return autoscalingBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The autoscaler configuration for this node pool. The autoscaler
     * is enabled only when a valid configuration is present.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig autoscaling = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setAutoscaling(
        com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig value) {
      if (autoscalingBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        autoscaling_ = value;
      } else {
        autoscalingBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The autoscaler configuration for this node pool. The autoscaler
     * is enabled only when a valid configuration is present.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig autoscaling = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setAutoscaling(
        com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig.Builder
            builderForValue) {
      if (autoscalingBuilder_ == null) {
        autoscaling_ = builderForValue.build();
      } else {
        autoscalingBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The autoscaler configuration for this node pool. The autoscaler
     * is enabled only when a valid configuration is present.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig autoscaling = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeAutoscaling(
        com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig value) {
      if (autoscalingBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && autoscaling_ != null
            && autoscaling_
                != com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig
                    .getDefaultInstance()) {
          getAutoscalingBuilder().mergeFrom(value);
        } else {
          autoscaling_ = value;
        }
      } else {
        autoscalingBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The autoscaler configuration for this node pool. The autoscaler
     * is enabled only when a valid configuration is present.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig autoscaling = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearAutoscaling() {
      bitField0_ = (bitField0_ & ~0x00000004);
      autoscaling_ = null;
      if (autoscalingBuilder_ != null) {
        autoscalingBuilder_.dispose();
        autoscalingBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The autoscaler configuration for this node pool. The autoscaler
     * is enabled only when a valid configuration is present.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig autoscaling = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig.Builder
        getAutoscalingBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getAutoscalingFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. The autoscaler configuration for this node pool. The autoscaler
     * is enabled only when a valid configuration is present.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig autoscaling = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfigOrBuilder
        getAutoscalingOrBuilder() {
      if (autoscalingBuilder_ != null) {
        return autoscalingBuilder_.getMessageOrBuilder();
      } else {
        return autoscaling_ == null
            ? com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig
                .getDefaultInstance()
            : autoscaling_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The autoscaler configuration for this node pool. The autoscaler
     * is enabled only when a valid configuration is present.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig autoscaling = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig,
            com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig.Builder,
            com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfigOrBuilder>
        getAutoscalingFieldBuilder() {
      if (autoscalingBuilder_ == null) {
        autoscalingBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig,
                com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig.Builder,
                com.google.cloud.dataproc.v1.GkeNodePoolConfig
                    .GkeNodePoolAutoscalingConfigOrBuilder>(
                getAutoscaling(), getParentForChildren(), isClean());
        autoscaling_ = null;
      }
      return autoscalingBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dataproc.v1.GkeNodePoolConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dataproc.v1.GkeNodePoolConfig)
  private static final com.google.cloud.dataproc.v1.GkeNodePoolConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dataproc.v1.GkeNodePoolConfig();
  }

  public static com.google.cloud.dataproc.v1.GkeNodePoolConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<GkeNodePoolConfig> PARSER =
      new com.google.protobuf.AbstractParser<GkeNodePoolConfig>() {
        @java.lang.Override
        public GkeNodePoolConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<GkeNodePoolConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<GkeNodePoolConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dataproc.v1.GkeNodePoolConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
