/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dataproc/v1/clusters.proto

package com.google.cloud.dataproc.v1;

/**
 *
 *
 * <pre>
 * Dataproc Node Group.
 * **The Dataproc `NodeGroup` resource is not related to the
 * Dataproc [NodeGroupAffinity][google.cloud.dataproc.v1.NodeGroupAffinity]
 * resource.**
 * </pre>
 *
 * Protobuf type {@code google.cloud.dataproc.v1.NodeGroup}
 */
public final class NodeGroup extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dataproc.v1.NodeGroup)
    NodeGroupOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use NodeGroup.newBuilder() to construct.
  private NodeGroup(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private NodeGroup() {
    name_ = "";
    roles_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new NodeGroup();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dataproc.v1.ClustersProto
        .internal_static_google_cloud_dataproc_v1_NodeGroup_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 4:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dataproc.v1.ClustersProto
        .internal_static_google_cloud_dataproc_v1_NodeGroup_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dataproc.v1.NodeGroup.class,
            com.google.cloud.dataproc.v1.NodeGroup.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Node pool roles.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.dataproc.v1.NodeGroup.Role}
   */
  public enum Role implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Required unspecified role.
     * </pre>
     *
     * <code>ROLE_UNSPECIFIED = 0;</code>
     */
    ROLE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Job drivers run on the node pool.
     * </pre>
     *
     * <code>DRIVER = 1;</code>
     */
    DRIVER(1),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Required unspecified role.
     * </pre>
     *
     * <code>ROLE_UNSPECIFIED = 0;</code>
     */
    public static final int ROLE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Job drivers run on the node pool.
     * </pre>
     *
     * <code>DRIVER = 1;</code>
     */
    public static final int DRIVER_VALUE = 1;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Role valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Role forNumber(int value) {
      switch (value) {
        case 0:
          return ROLE_UNSPECIFIED;
        case 1:
          return DRIVER;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Role> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Role> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Role>() {
          public Role findValueByNumber(int number) {
            return Role.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.dataproc.v1.NodeGroup.getDescriptor().getEnumTypes().get(0);
    }

    private static final Role[] VALUES = values();

    public static Role valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Role(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.dataproc.v1.NodeGroup.Role)
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * The Node group [resource name](https://aip.dev/122).
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The Node group [resource name](https://aip.dev/122).
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ROLES_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<java.lang.Integer> roles_;

  private static final com.google.protobuf.Internal.ListAdapter.Converter<
          java.lang.Integer, com.google.cloud.dataproc.v1.NodeGroup.Role>
      roles_converter_ =
          new com.google.protobuf.Internal.ListAdapter.Converter<
              java.lang.Integer, com.google.cloud.dataproc.v1.NodeGroup.Role>() {
            public com.google.cloud.dataproc.v1.NodeGroup.Role convert(java.lang.Integer from) {
              com.google.cloud.dataproc.v1.NodeGroup.Role result =
                  com.google.cloud.dataproc.v1.NodeGroup.Role.forNumber(from);
              return result == null
                  ? com.google.cloud.dataproc.v1.NodeGroup.Role.UNRECOGNIZED
                  : result;
            }
          };
  /**
   *
   *
   * <pre>
   * Required. Node group roles.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dataproc.v1.NodeGroup.Role roles = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return A list containing the roles.
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.dataproc.v1.NodeGroup.Role> getRolesList() {
    return new com.google.protobuf.Internal.ListAdapter<
        java.lang.Integer, com.google.cloud.dataproc.v1.NodeGroup.Role>(roles_, roles_converter_);
  }
  /**
   *
   *
   * <pre>
   * Required. Node group roles.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dataproc.v1.NodeGroup.Role roles = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The count of roles.
   */
  @java.lang.Override
  public int getRolesCount() {
    return roles_.size();
  }
  /**
   *
   *
   * <pre>
   * Required. Node group roles.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dataproc.v1.NodeGroup.Role roles = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @param index The index of the element to return.
   * @return The roles at the given index.
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.NodeGroup.Role getRoles(int index) {
    return roles_converter_.convert(roles_.get(index));
  }
  /**
   *
   *
   * <pre>
   * Required. Node group roles.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dataproc.v1.NodeGroup.Role roles = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return A list containing the enum numeric values on the wire for roles.
   */
  @java.lang.Override
  public java.util.List<java.lang.Integer> getRolesValueList() {
    return roles_;
  }
  /**
   *
   *
   * <pre>
   * Required. Node group roles.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dataproc.v1.NodeGroup.Role roles = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @param index The index of the value to return.
   * @return The enum numeric value on the wire of roles at the given index.
   */
  @java.lang.Override
  public int getRolesValue(int index) {
    return roles_.get(index);
  }

  private int rolesMemoizedSerializedSize;

  public static final int NODE_GROUP_CONFIG_FIELD_NUMBER = 3;
  private com.google.cloud.dataproc.v1.InstanceGroupConfig nodeGroupConfig_;
  /**
   *
   *
   * <pre>
   * Optional. The node group instance group configuration.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.InstanceGroupConfig node_group_config = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the nodeGroupConfig field is set.
   */
  @java.lang.Override
  public boolean hasNodeGroupConfig() {
    return nodeGroupConfig_ != null;
  }
  /**
   *
   *
   * <pre>
   * Optional. The node group instance group configuration.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.InstanceGroupConfig node_group_config = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The nodeGroupConfig.
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.InstanceGroupConfig getNodeGroupConfig() {
    return nodeGroupConfig_ == null
        ? com.google.cloud.dataproc.v1.InstanceGroupConfig.getDefaultInstance()
        : nodeGroupConfig_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The node group instance group configuration.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.InstanceGroupConfig node_group_config = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.InstanceGroupConfigOrBuilder getNodeGroupConfigOrBuilder() {
    return nodeGroupConfig_ == null
        ? com.google.cloud.dataproc.v1.InstanceGroupConfig.getDefaultInstance()
        : nodeGroupConfig_;
  }

  public static final int LABELS_FIELD_NUMBER = 4;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.dataproc.v1.ClustersProto
                .internal_static_google_cloud_dataproc_v1_NodeGroup_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Optional. Node group labels.
   *
   * * Label **keys** must consist of from 1 to 63 characters and conform to
   *   [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
   * * Label **values** can be empty. If specified, they must consist of from
   *   1 to 63 characters and conform to [RFC 1035]
   *   (https://www.ietf.org/rfc/rfc1035.txt).
   * * The node group must have no more than 32 labels.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. Node group labels.
   *
   * * Label **keys** must consist of from 1 to 63 characters and conform to
   *   [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
   * * Label **values** can be empty. If specified, they must consist of from
   *   1 to 63 characters and conform to [RFC 1035]
   *   (https://www.ietf.org/rfc/rfc1035.txt).
   * * The node group must have no more than 32 labels.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. Node group labels.
   *
   * * Label **keys** must consist of from 1 to 63 characters and conform to
   *   [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
   * * Label **values** can be empty. If specified, they must consist of from
   *   1 to 63 characters and conform to [RFC 1035]
   *   (https://www.ietf.org/rfc/rfc1035.txt).
   * * The node group must have no more than 32 labels.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Optional. Node group labels.
   *
   * * Label **keys** must consist of from 1 to 63 characters and conform to
   *   [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
   * * Label **values** can be empty. If specified, they must consist of from
   *   1 to 63 characters and conform to [RFC 1035]
   *   (https://www.ietf.org/rfc/rfc1035.txt).
   * * The node group must have no more than 32 labels.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    getSerializedSize();
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (getRolesList().size() > 0) {
      output.writeUInt32NoTag(18);
      output.writeUInt32NoTag(rolesMemoizedSerializedSize);
    }
    for (int i = 0; i < roles_.size(); i++) {
      output.writeEnumNoTag(roles_.get(i));
    }
    if (nodeGroupConfig_ != null) {
      output.writeMessage(3, getNodeGroupConfig());
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 4);
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < roles_.size(); i++) {
        dataSize += com.google.protobuf.CodedOutputStream.computeEnumSizeNoTag(roles_.get(i));
      }
      size += dataSize;
      if (!getRolesList().isEmpty()) {
        size += 1;
        size += com.google.protobuf.CodedOutputStream.computeUInt32SizeNoTag(dataSize);
      }
      rolesMemoizedSerializedSize = dataSize;
    }
    if (nodeGroupConfig_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getNodeGroupConfig());
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, labels__);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dataproc.v1.NodeGroup)) {
      return super.equals(obj);
    }
    com.google.cloud.dataproc.v1.NodeGroup other = (com.google.cloud.dataproc.v1.NodeGroup) obj;

    if (!getName().equals(other.getName())) return false;
    if (!roles_.equals(other.roles_)) return false;
    if (hasNodeGroupConfig() != other.hasNodeGroupConfig()) return false;
    if (hasNodeGroupConfig()) {
      if (!getNodeGroupConfig().equals(other.getNodeGroupConfig())) return false;
    }
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (getRolesCount() > 0) {
      hash = (37 * hash) + ROLES_FIELD_NUMBER;
      hash = (53 * hash) + roles_.hashCode();
    }
    if (hasNodeGroupConfig()) {
      hash = (37 * hash) + NODE_GROUP_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getNodeGroupConfig().hashCode();
    }
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dataproc.v1.NodeGroup parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1.NodeGroup parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.NodeGroup parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1.NodeGroup parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.NodeGroup parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1.NodeGroup parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.NodeGroup parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1.NodeGroup parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.NodeGroup parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1.NodeGroup parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.NodeGroup parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1.NodeGroup parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.dataproc.v1.NodeGroup prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Dataproc Node Group.
   * **The Dataproc `NodeGroup` resource is not related to the
   * Dataproc [NodeGroupAffinity][google.cloud.dataproc.v1.NodeGroupAffinity]
   * resource.**
   * </pre>
   *
   * Protobuf type {@code google.cloud.dataproc.v1.NodeGroup}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dataproc.v1.NodeGroup)
      com.google.cloud.dataproc.v1.NodeGroupOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dataproc.v1.ClustersProto
          .internal_static_google_cloud_dataproc_v1_NodeGroup_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 4:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 4:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dataproc.v1.ClustersProto
          .internal_static_google_cloud_dataproc_v1_NodeGroup_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dataproc.v1.NodeGroup.class,
              com.google.cloud.dataproc.v1.NodeGroup.Builder.class);
    }

    // Construct using com.google.cloud.dataproc.v1.NodeGroup.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      roles_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000002);
      nodeGroupConfig_ = null;
      if (nodeGroupConfigBuilder_ != null) {
        nodeGroupConfigBuilder_.dispose();
        nodeGroupConfigBuilder_ = null;
      }
      internalGetMutableLabels().clear();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dataproc.v1.ClustersProto
          .internal_static_google_cloud_dataproc_v1_NodeGroup_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.NodeGroup getDefaultInstanceForType() {
      return com.google.cloud.dataproc.v1.NodeGroup.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.NodeGroup build() {
      com.google.cloud.dataproc.v1.NodeGroup result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.NodeGroup buildPartial() {
      com.google.cloud.dataproc.v1.NodeGroup result =
          new com.google.cloud.dataproc.v1.NodeGroup(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.dataproc.v1.NodeGroup result) {
      if (((bitField0_ & 0x00000002) != 0)) {
        roles_ = java.util.Collections.unmodifiableList(roles_);
        bitField0_ = (bitField0_ & ~0x00000002);
      }
      result.roles_ = roles_;
    }

    private void buildPartial0(com.google.cloud.dataproc.v1.NodeGroup result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.nodeGroupConfig_ =
            nodeGroupConfigBuilder_ == null ? nodeGroupConfig_ : nodeGroupConfigBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.labels_ = internalGetLabels();
        result.labels_.makeImmutable();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dataproc.v1.NodeGroup) {
        return mergeFrom((com.google.cloud.dataproc.v1.NodeGroup) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dataproc.v1.NodeGroup other) {
      if (other == com.google.cloud.dataproc.v1.NodeGroup.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.roles_.isEmpty()) {
        if (roles_.isEmpty()) {
          roles_ = other.roles_;
          bitField0_ = (bitField0_ & ~0x00000002);
        } else {
          ensureRolesIsMutable();
          roles_.addAll(other.roles_);
        }
        onChanged();
      }
      if (other.hasNodeGroupConfig()) {
        mergeNodeGroupConfig(other.getNodeGroupConfig());
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      bitField0_ |= 0x00000008;
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 16:
              {
                int tmpRaw = input.readEnum();
                ensureRolesIsMutable();
                roles_.add(tmpRaw);
                break;
              } // case 16
            case 18:
              {
                int length = input.readRawVarint32();
                int oldLimit = input.pushLimit(length);
                while (input.getBytesUntilLimit() > 0) {
                  int tmpRaw = input.readEnum();
                  ensureRolesIsMutable();
                  roles_.add(tmpRaw);
                }
                input.popLimit(oldLimit);
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getNodeGroupConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The Node group [resource name](https://aip.dev/122).
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The Node group [resource name](https://aip.dev/122).
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The Node group [resource name](https://aip.dev/122).
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Node group [resource name](https://aip.dev/122).
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Node group [resource name](https://aip.dev/122).
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.util.List<java.lang.Integer> roles_ = java.util.Collections.emptyList();

    private void ensureRolesIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        roles_ = new java.util.ArrayList<java.lang.Integer>(roles_);
        bitField0_ |= 0x00000002;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Node group roles.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.NodeGroup.Role roles = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return A list containing the roles.
     */
    public java.util.List<com.google.cloud.dataproc.v1.NodeGroup.Role> getRolesList() {
      return new com.google.protobuf.Internal.ListAdapter<
          java.lang.Integer, com.google.cloud.dataproc.v1.NodeGroup.Role>(roles_, roles_converter_);
    }
    /**
     *
     *
     * <pre>
     * Required. Node group roles.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.NodeGroup.Role roles = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The count of roles.
     */
    public int getRolesCount() {
      return roles_.size();
    }
    /**
     *
     *
     * <pre>
     * Required. Node group roles.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.NodeGroup.Role roles = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param index The index of the element to return.
     * @return The roles at the given index.
     */
    public com.google.cloud.dataproc.v1.NodeGroup.Role getRoles(int index) {
      return roles_converter_.convert(roles_.get(index));
    }
    /**
     *
     *
     * <pre>
     * Required. Node group roles.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.NodeGroup.Role roles = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The roles to set.
     * @return This builder for chaining.
     */
    public Builder setRoles(int index, com.google.cloud.dataproc.v1.NodeGroup.Role value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureRolesIsMutable();
      roles_.set(index, value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Node group roles.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.NodeGroup.Role roles = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The roles to add.
     * @return This builder for chaining.
     */
    public Builder addRoles(com.google.cloud.dataproc.v1.NodeGroup.Role value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureRolesIsMutable();
      roles_.add(value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Node group roles.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.NodeGroup.Role roles = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param values The roles to add.
     * @return This builder for chaining.
     */
    public Builder addAllRoles(
        java.lang.Iterable<? extends com.google.cloud.dataproc.v1.NodeGroup.Role> values) {
      ensureRolesIsMutable();
      for (com.google.cloud.dataproc.v1.NodeGroup.Role value : values) {
        roles_.add(value.getNumber());
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Node group roles.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.NodeGroup.Role roles = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRoles() {
      roles_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Node group roles.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.NodeGroup.Role roles = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return A list containing the enum numeric values on the wire for roles.
     */
    public java.util.List<java.lang.Integer> getRolesValueList() {
      return java.util.Collections.unmodifiableList(roles_);
    }
    /**
     *
     *
     * <pre>
     * Required. Node group roles.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.NodeGroup.Role roles = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of roles at the given index.
     */
    public int getRolesValue(int index) {
      return roles_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Required. Node group roles.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.NodeGroup.Role roles = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The enum numeric value on the wire for roles to set.
     * @return This builder for chaining.
     */
    public Builder setRolesValue(int index, int value) {
      ensureRolesIsMutable();
      roles_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Node group roles.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.NodeGroup.Role roles = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The enum numeric value on the wire for roles to add.
     * @return This builder for chaining.
     */
    public Builder addRolesValue(int value) {
      ensureRolesIsMutable();
      roles_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Node group roles.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.NodeGroup.Role roles = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param values The enum numeric values on the wire for roles to add.
     * @return This builder for chaining.
     */
    public Builder addAllRolesValue(java.lang.Iterable<java.lang.Integer> values) {
      ensureRolesIsMutable();
      for (int value : values) {
        roles_.add(value);
      }
      onChanged();
      return this;
    }

    private com.google.cloud.dataproc.v1.InstanceGroupConfig nodeGroupConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.InstanceGroupConfig,
            com.google.cloud.dataproc.v1.InstanceGroupConfig.Builder,
            com.google.cloud.dataproc.v1.InstanceGroupConfigOrBuilder>
        nodeGroupConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. The node group instance group configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.InstanceGroupConfig node_group_config = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the nodeGroupConfig field is set.
     */
    public boolean hasNodeGroupConfig() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. The node group instance group configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.InstanceGroupConfig node_group_config = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The nodeGroupConfig.
     */
    public com.google.cloud.dataproc.v1.InstanceGroupConfig getNodeGroupConfig() {
      if (nodeGroupConfigBuilder_ == null) {
        return nodeGroupConfig_ == null
            ? com.google.cloud.dataproc.v1.InstanceGroupConfig.getDefaultInstance()
            : nodeGroupConfig_;
      } else {
        return nodeGroupConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The node group instance group configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.InstanceGroupConfig node_group_config = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setNodeGroupConfig(com.google.cloud.dataproc.v1.InstanceGroupConfig value) {
      if (nodeGroupConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        nodeGroupConfig_ = value;
      } else {
        nodeGroupConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The node group instance group configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.InstanceGroupConfig node_group_config = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setNodeGroupConfig(
        com.google.cloud.dataproc.v1.InstanceGroupConfig.Builder builderForValue) {
      if (nodeGroupConfigBuilder_ == null) {
        nodeGroupConfig_ = builderForValue.build();
      } else {
        nodeGroupConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The node group instance group configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.InstanceGroupConfig node_group_config = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeNodeGroupConfig(com.google.cloud.dataproc.v1.InstanceGroupConfig value) {
      if (nodeGroupConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && nodeGroupConfig_ != null
            && nodeGroupConfig_
                != com.google.cloud.dataproc.v1.InstanceGroupConfig.getDefaultInstance()) {
          getNodeGroupConfigBuilder().mergeFrom(value);
        } else {
          nodeGroupConfig_ = value;
        }
      } else {
        nodeGroupConfigBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The node group instance group configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.InstanceGroupConfig node_group_config = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearNodeGroupConfig() {
      bitField0_ = (bitField0_ & ~0x00000004);
      nodeGroupConfig_ = null;
      if (nodeGroupConfigBuilder_ != null) {
        nodeGroupConfigBuilder_.dispose();
        nodeGroupConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The node group instance group configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.InstanceGroupConfig node_group_config = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataproc.v1.InstanceGroupConfig.Builder getNodeGroupConfigBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getNodeGroupConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. The node group instance group configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.InstanceGroupConfig node_group_config = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataproc.v1.InstanceGroupConfigOrBuilder getNodeGroupConfigOrBuilder() {
      if (nodeGroupConfigBuilder_ != null) {
        return nodeGroupConfigBuilder_.getMessageOrBuilder();
      } else {
        return nodeGroupConfig_ == null
            ? com.google.cloud.dataproc.v1.InstanceGroupConfig.getDefaultInstance()
            : nodeGroupConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The node group instance group configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.InstanceGroupConfig node_group_config = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.InstanceGroupConfig,
            com.google.cloud.dataproc.v1.InstanceGroupConfig.Builder,
            com.google.cloud.dataproc.v1.InstanceGroupConfigOrBuilder>
        getNodeGroupConfigFieldBuilder() {
      if (nodeGroupConfigBuilder_ == null) {
        nodeGroupConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataproc.v1.InstanceGroupConfig,
                com.google.cloud.dataproc.v1.InstanceGroupConfig.Builder,
                com.google.cloud.dataproc.v1.InstanceGroupConfigOrBuilder>(
                getNodeGroupConfig(), getParentForChildren(), isClean());
        nodeGroupConfig_ = null;
      }
      return nodeGroupConfigBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Optional. Node group labels.
     *
     * * Label **keys** must consist of from 1 to 63 characters and conform to
     *   [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
     * * Label **values** can be empty. If specified, they must consist of from
     *   1 to 63 characters and conform to [RFC 1035]
     *   (https://www.ietf.org/rfc/rfc1035.txt).
     * * The node group must have no more than 32 labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. Node group labels.
     *
     * * Label **keys** must consist of from 1 to 63 characters and conform to
     *   [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
     * * Label **values** can be empty. If specified, they must consist of from
     *   1 to 63 characters and conform to [RFC 1035]
     *   (https://www.ietf.org/rfc/rfc1035.txt).
     * * The node group must have no more than 32 labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. Node group labels.
     *
     * * Label **keys** must consist of from 1 to 63 characters and conform to
     *   [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
     * * Label **values** can be empty. If specified, they must consist of from
     *   1 to 63 characters and conform to [RFC 1035]
     *   (https://www.ietf.org/rfc/rfc1035.txt).
     * * The node group must have no more than 32 labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Optional. Node group labels.
     *
     * * Label **keys** must consist of from 1 to 63 characters and conform to
     *   [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
     * * Label **values** can be empty. If specified, they must consist of from
     *   1 to 63 characters and conform to [RFC 1035]
     *   (https://www.ietf.org/rfc/rfc1035.txt).
     * * The node group must have no more than 32 labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      bitField0_ = (bitField0_ & ~0x00000008);
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Node group labels.
     *
     * * Label **keys** must consist of from 1 to 63 characters and conform to
     *   [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
     * * Label **values** can be empty. If specified, they must consist of from
     *   1 to 63 characters and conform to [RFC 1035]
     *   (https://www.ietf.org/rfc/rfc1035.txt).
     * * The node group must have no more than 32 labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      bitField0_ |= 0x00000008;
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. Node group labels.
     *
     * * Label **keys** must consist of from 1 to 63 characters and conform to
     *   [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
     * * Label **values** can be empty. If specified, they must consist of from
     *   1 to 63 characters and conform to [RFC 1035]
     *   (https://www.ietf.org/rfc/rfc1035.txt).
     * * The node group must have no more than 32 labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00000008;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Node group labels.
     *
     * * Label **keys** must consist of from 1 to 63 characters and conform to
     *   [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
     * * Label **values** can be empty. If specified, they must consist of from
     *   1 to 63 characters and conform to [RFC 1035]
     *   (https://www.ietf.org/rfc/rfc1035.txt).
     * * The node group must have no more than 32 labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00000008;
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dataproc.v1.NodeGroup)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dataproc.v1.NodeGroup)
  private static final com.google.cloud.dataproc.v1.NodeGroup DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dataproc.v1.NodeGroup();
  }

  public static com.google.cloud.dataproc.v1.NodeGroup getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<NodeGroup> PARSER =
      new com.google.protobuf.AbstractParser<NodeGroup>() {
        @java.lang.Override
        public NodeGroup parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<NodeGroup> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<NodeGroup> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dataproc.v1.NodeGroup getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
