/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dataproc/v1/shared.proto

package com.google.cloud.dataproc.v1;

/**
 *
 *
 * <pre>
 * Runtime information about workload execution.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dataproc.v1.RuntimeInfo}
 */
public final class RuntimeInfo extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dataproc.v1.RuntimeInfo)
    RuntimeInfoOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use RuntimeInfo.newBuilder() to construct.
  private RuntimeInfo(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private RuntimeInfo() {
    outputUri_ = "";
    diagnosticOutputUri_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new RuntimeInfo();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dataproc.v1.SharedProto
        .internal_static_google_cloud_dataproc_v1_RuntimeInfo_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 1:
        return internalGetEndpoints();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dataproc.v1.SharedProto
        .internal_static_google_cloud_dataproc_v1_RuntimeInfo_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dataproc.v1.RuntimeInfo.class,
            com.google.cloud.dataproc.v1.RuntimeInfo.Builder.class);
  }

  public static final int ENDPOINTS_FIELD_NUMBER = 1;

  private static final class EndpointsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.dataproc.v1.SharedProto
                .internal_static_google_cloud_dataproc_v1_RuntimeInfo_EndpointsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> endpoints_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetEndpoints() {
    if (endpoints_ == null) {
      return com.google.protobuf.MapField.emptyMapField(EndpointsDefaultEntryHolder.defaultEntry);
    }
    return endpoints_;
  }

  public int getEndpointsCount() {
    return internalGetEndpoints().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Output only. Map of remote access endpoints (such as web interfaces and
   * APIs) to their URIs.
   * </pre>
   *
   * <code>map&lt;string, string&gt; endpoints = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public boolean containsEndpoints(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetEndpoints().getMap().containsKey(key);
  }
  /** Use {@link #getEndpointsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getEndpoints() {
    return getEndpointsMap();
  }
  /**
   *
   *
   * <pre>
   * Output only. Map of remote access endpoints (such as web interfaces and
   * APIs) to their URIs.
   * </pre>
   *
   * <code>map&lt;string, string&gt; endpoints = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getEndpointsMap() {
    return internalGetEndpoints().getMap();
  }
  /**
   *
   *
   * <pre>
   * Output only. Map of remote access endpoints (such as web interfaces and
   * APIs) to their URIs.
   * </pre>
   *
   * <code>map&lt;string, string&gt; endpoints = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getEndpointsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetEndpoints().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Output only. Map of remote access endpoints (such as web interfaces and
   * APIs) to their URIs.
   * </pre>
   *
   * <code>map&lt;string, string&gt; endpoints = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.lang.String getEndpointsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetEndpoints().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int OUTPUT_URI_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object outputUri_ = "";
  /**
   *
   *
   * <pre>
   * Output only. A URI pointing to the location of the stdout and stderr of the
   * workload.
   * </pre>
   *
   * <code>string output_uri = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The outputUri.
   */
  @java.lang.Override
  public java.lang.String getOutputUri() {
    java.lang.Object ref = outputUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      outputUri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. A URI pointing to the location of the stdout and stderr of the
   * workload.
   * </pre>
   *
   * <code>string output_uri = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for outputUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getOutputUriBytes() {
    java.lang.Object ref = outputUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      outputUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DIAGNOSTIC_OUTPUT_URI_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object diagnosticOutputUri_ = "";
  /**
   *
   *
   * <pre>
   * Output only. A URI pointing to the location of the diagnostics tarball.
   * </pre>
   *
   * <code>string diagnostic_output_uri = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The diagnosticOutputUri.
   */
  @java.lang.Override
  public java.lang.String getDiagnosticOutputUri() {
    java.lang.Object ref = diagnosticOutputUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      diagnosticOutputUri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. A URI pointing to the location of the diagnostics tarball.
   * </pre>
   *
   * <code>string diagnostic_output_uri = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for diagnosticOutputUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDiagnosticOutputUriBytes() {
    java.lang.Object ref = diagnosticOutputUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      diagnosticOutputUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int APPROXIMATE_USAGE_FIELD_NUMBER = 6;
  private com.google.cloud.dataproc.v1.UsageMetrics approximateUsage_;
  /**
   *
   *
   * <pre>
   * Output only. Approximate workload resource usage calculated after workload
   * finishes (see [Dataproc Serverless pricing]
   * (https://cloud.google.com/dataproc-serverless/pricing)).
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.UsageMetrics approximate_usage = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the approximateUsage field is set.
   */
  @java.lang.Override
  public boolean hasApproximateUsage() {
    return approximateUsage_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Approximate workload resource usage calculated after workload
   * finishes (see [Dataproc Serverless pricing]
   * (https://cloud.google.com/dataproc-serverless/pricing)).
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.UsageMetrics approximate_usage = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The approximateUsage.
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.UsageMetrics getApproximateUsage() {
    return approximateUsage_ == null
        ? com.google.cloud.dataproc.v1.UsageMetrics.getDefaultInstance()
        : approximateUsage_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Approximate workload resource usage calculated after workload
   * finishes (see [Dataproc Serverless pricing]
   * (https://cloud.google.com/dataproc-serverless/pricing)).
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.UsageMetrics approximate_usage = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.UsageMetricsOrBuilder getApproximateUsageOrBuilder() {
    return approximateUsage_ == null
        ? com.google.cloud.dataproc.v1.UsageMetrics.getDefaultInstance()
        : approximateUsage_;
  }

  public static final int CURRENT_USAGE_FIELD_NUMBER = 7;
  private com.google.cloud.dataproc.v1.UsageSnapshot currentUsage_;
  /**
   *
   *
   * <pre>
   * Output only. Snapshot of current workload resource usage.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.UsageSnapshot current_usage = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the currentUsage field is set.
   */
  @java.lang.Override
  public boolean hasCurrentUsage() {
    return currentUsage_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Snapshot of current workload resource usage.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.UsageSnapshot current_usage = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The currentUsage.
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.UsageSnapshot getCurrentUsage() {
    return currentUsage_ == null
        ? com.google.cloud.dataproc.v1.UsageSnapshot.getDefaultInstance()
        : currentUsage_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Snapshot of current workload resource usage.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.UsageSnapshot current_usage = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.UsageSnapshotOrBuilder getCurrentUsageOrBuilder() {
    return currentUsage_ == null
        ? com.google.cloud.dataproc.v1.UsageSnapshot.getDefaultInstance()
        : currentUsage_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetEndpoints(), EndpointsDefaultEntryHolder.defaultEntry, 1);
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(outputUri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, outputUri_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(diagnosticOutputUri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, diagnosticOutputUri_);
    }
    if (approximateUsage_ != null) {
      output.writeMessage(6, getApproximateUsage());
    }
    if (currentUsage_ != null) {
      output.writeMessage(7, getCurrentUsage());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetEndpoints().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> endpoints__ =
          EndpointsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, endpoints__);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(outputUri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, outputUri_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(diagnosticOutputUri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, diagnosticOutputUri_);
    }
    if (approximateUsage_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getApproximateUsage());
    }
    if (currentUsage_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getCurrentUsage());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dataproc.v1.RuntimeInfo)) {
      return super.equals(obj);
    }
    com.google.cloud.dataproc.v1.RuntimeInfo other = (com.google.cloud.dataproc.v1.RuntimeInfo) obj;

    if (!internalGetEndpoints().equals(other.internalGetEndpoints())) return false;
    if (!getOutputUri().equals(other.getOutputUri())) return false;
    if (!getDiagnosticOutputUri().equals(other.getDiagnosticOutputUri())) return false;
    if (hasApproximateUsage() != other.hasApproximateUsage()) return false;
    if (hasApproximateUsage()) {
      if (!getApproximateUsage().equals(other.getApproximateUsage())) return false;
    }
    if (hasCurrentUsage() != other.hasCurrentUsage()) return false;
    if (hasCurrentUsage()) {
      if (!getCurrentUsage().equals(other.getCurrentUsage())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (!internalGetEndpoints().getMap().isEmpty()) {
      hash = (37 * hash) + ENDPOINTS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetEndpoints().hashCode();
    }
    hash = (37 * hash) + OUTPUT_URI_FIELD_NUMBER;
    hash = (53 * hash) + getOutputUri().hashCode();
    hash = (37 * hash) + DIAGNOSTIC_OUTPUT_URI_FIELD_NUMBER;
    hash = (53 * hash) + getDiagnosticOutputUri().hashCode();
    if (hasApproximateUsage()) {
      hash = (37 * hash) + APPROXIMATE_USAGE_FIELD_NUMBER;
      hash = (53 * hash) + getApproximateUsage().hashCode();
    }
    if (hasCurrentUsage()) {
      hash = (37 * hash) + CURRENT_USAGE_FIELD_NUMBER;
      hash = (53 * hash) + getCurrentUsage().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dataproc.v1.RuntimeInfo parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1.RuntimeInfo parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.RuntimeInfo parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1.RuntimeInfo parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.RuntimeInfo parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1.RuntimeInfo parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.RuntimeInfo parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1.RuntimeInfo parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.RuntimeInfo parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1.RuntimeInfo parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.RuntimeInfo parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1.RuntimeInfo parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.dataproc.v1.RuntimeInfo prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Runtime information about workload execution.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dataproc.v1.RuntimeInfo}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dataproc.v1.RuntimeInfo)
      com.google.cloud.dataproc.v1.RuntimeInfoOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dataproc.v1.SharedProto
          .internal_static_google_cloud_dataproc_v1_RuntimeInfo_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 1:
          return internalGetEndpoints();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 1:
          return internalGetMutableEndpoints();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dataproc.v1.SharedProto
          .internal_static_google_cloud_dataproc_v1_RuntimeInfo_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dataproc.v1.RuntimeInfo.class,
              com.google.cloud.dataproc.v1.RuntimeInfo.Builder.class);
    }

    // Construct using com.google.cloud.dataproc.v1.RuntimeInfo.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      internalGetMutableEndpoints().clear();
      outputUri_ = "";
      diagnosticOutputUri_ = "";
      approximateUsage_ = null;
      if (approximateUsageBuilder_ != null) {
        approximateUsageBuilder_.dispose();
        approximateUsageBuilder_ = null;
      }
      currentUsage_ = null;
      if (currentUsageBuilder_ != null) {
        currentUsageBuilder_.dispose();
        currentUsageBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dataproc.v1.SharedProto
          .internal_static_google_cloud_dataproc_v1_RuntimeInfo_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.RuntimeInfo getDefaultInstanceForType() {
      return com.google.cloud.dataproc.v1.RuntimeInfo.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.RuntimeInfo build() {
      com.google.cloud.dataproc.v1.RuntimeInfo result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.RuntimeInfo buildPartial() {
      com.google.cloud.dataproc.v1.RuntimeInfo result =
          new com.google.cloud.dataproc.v1.RuntimeInfo(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.dataproc.v1.RuntimeInfo result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.endpoints_ = internalGetEndpoints();
        result.endpoints_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.outputUri_ = outputUri_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.diagnosticOutputUri_ = diagnosticOutputUri_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.approximateUsage_ =
            approximateUsageBuilder_ == null ? approximateUsage_ : approximateUsageBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.currentUsage_ =
            currentUsageBuilder_ == null ? currentUsage_ : currentUsageBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dataproc.v1.RuntimeInfo) {
        return mergeFrom((com.google.cloud.dataproc.v1.RuntimeInfo) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dataproc.v1.RuntimeInfo other) {
      if (other == com.google.cloud.dataproc.v1.RuntimeInfo.getDefaultInstance()) return this;
      internalGetMutableEndpoints().mergeFrom(other.internalGetEndpoints());
      bitField0_ |= 0x00000001;
      if (!other.getOutputUri().isEmpty()) {
        outputUri_ = other.outputUri_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getDiagnosticOutputUri().isEmpty()) {
        diagnosticOutputUri_ = other.diagnosticOutputUri_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasApproximateUsage()) {
        mergeApproximateUsage(other.getApproximateUsage());
      }
      if (other.hasCurrentUsage()) {
        mergeCurrentUsage(other.getCurrentUsage());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> endpoints__ =
                    input.readMessage(
                        EndpointsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableEndpoints()
                    .getMutableMap()
                    .put(endpoints__.getKey(), endpoints__.getValue());
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                outputUri_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                diagnosticOutputUri_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 50:
              {
                input.readMessage(
                    getApproximateUsageFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getCurrentUsageFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 58
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> endpoints_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetEndpoints() {
      if (endpoints_ == null) {
        return com.google.protobuf.MapField.emptyMapField(EndpointsDefaultEntryHolder.defaultEntry);
      }
      return endpoints_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableEndpoints() {
      if (endpoints_ == null) {
        endpoints_ =
            com.google.protobuf.MapField.newMapField(EndpointsDefaultEntryHolder.defaultEntry);
      }
      if (!endpoints_.isMutable()) {
        endpoints_ = endpoints_.copy();
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return endpoints_;
    }

    public int getEndpointsCount() {
      return internalGetEndpoints().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Output only. Map of remote access endpoints (such as web interfaces and
     * APIs) to their URIs.
     * </pre>
     *
     * <code>map&lt;string, string&gt; endpoints = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public boolean containsEndpoints(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetEndpoints().getMap().containsKey(key);
    }
    /** Use {@link #getEndpointsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getEndpoints() {
      return getEndpointsMap();
    }
    /**
     *
     *
     * <pre>
     * Output only. Map of remote access endpoints (such as web interfaces and
     * APIs) to their URIs.
     * </pre>
     *
     * <code>map&lt;string, string&gt; endpoints = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getEndpointsMap() {
      return internalGetEndpoints().getMap();
    }
    /**
     *
     *
     * <pre>
     * Output only. Map of remote access endpoints (such as web interfaces and
     * APIs) to their URIs.
     * </pre>
     *
     * <code>map&lt;string, string&gt; endpoints = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getEndpointsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetEndpoints().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Output only. Map of remote access endpoints (such as web interfaces and
     * APIs) to their URIs.
     * </pre>
     *
     * <code>map&lt;string, string&gt; endpoints = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public java.lang.String getEndpointsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetEndpoints().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearEndpoints() {
      bitField0_ = (bitField0_ & ~0x00000001);
      internalGetMutableEndpoints().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Map of remote access endpoints (such as web interfaces and
     * APIs) to their URIs.
     * </pre>
     *
     * <code>map&lt;string, string&gt; endpoints = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removeEndpoints(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableEndpoints().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableEndpoints() {
      bitField0_ |= 0x00000001;
      return internalGetMutableEndpoints().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Output only. Map of remote access endpoints (such as web interfaces and
     * APIs) to their URIs.
     * </pre>
     *
     * <code>map&lt;string, string&gt; endpoints = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder putEndpoints(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableEndpoints().getMutableMap().put(key, value);
      bitField0_ |= 0x00000001;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Map of remote access endpoints (such as web interfaces and
     * APIs) to their URIs.
     * </pre>
     *
     * <code>map&lt;string, string&gt; endpoints = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder putAllEndpoints(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableEndpoints().getMutableMap().putAll(values);
      bitField0_ |= 0x00000001;
      return this;
    }

    private java.lang.Object outputUri_ = "";
    /**
     *
     *
     * <pre>
     * Output only. A URI pointing to the location of the stdout and stderr of the
     * workload.
     * </pre>
     *
     * <code>string output_uri = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The outputUri.
     */
    public java.lang.String getOutputUri() {
      java.lang.Object ref = outputUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        outputUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A URI pointing to the location of the stdout and stderr of the
     * workload.
     * </pre>
     *
     * <code>string output_uri = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for outputUri.
     */
    public com.google.protobuf.ByteString getOutputUriBytes() {
      java.lang.Object ref = outputUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        outputUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A URI pointing to the location of the stdout and stderr of the
     * workload.
     * </pre>
     *
     * <code>string output_uri = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The outputUri to set.
     * @return This builder for chaining.
     */
    public Builder setOutputUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      outputUri_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A URI pointing to the location of the stdout and stderr of the
     * workload.
     * </pre>
     *
     * <code>string output_uri = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearOutputUri() {
      outputUri_ = getDefaultInstance().getOutputUri();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A URI pointing to the location of the stdout and stderr of the
     * workload.
     * </pre>
     *
     * <code>string output_uri = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for outputUri to set.
     * @return This builder for chaining.
     */
    public Builder setOutputUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      outputUri_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object diagnosticOutputUri_ = "";
    /**
     *
     *
     * <pre>
     * Output only. A URI pointing to the location of the diagnostics tarball.
     * </pre>
     *
     * <code>string diagnostic_output_uri = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The diagnosticOutputUri.
     */
    public java.lang.String getDiagnosticOutputUri() {
      java.lang.Object ref = diagnosticOutputUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        diagnosticOutputUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A URI pointing to the location of the diagnostics tarball.
     * </pre>
     *
     * <code>string diagnostic_output_uri = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for diagnosticOutputUri.
     */
    public com.google.protobuf.ByteString getDiagnosticOutputUriBytes() {
      java.lang.Object ref = diagnosticOutputUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        diagnosticOutputUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A URI pointing to the location of the diagnostics tarball.
     * </pre>
     *
     * <code>string diagnostic_output_uri = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The diagnosticOutputUri to set.
     * @return This builder for chaining.
     */
    public Builder setDiagnosticOutputUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      diagnosticOutputUri_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A URI pointing to the location of the diagnostics tarball.
     * </pre>
     *
     * <code>string diagnostic_output_uri = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDiagnosticOutputUri() {
      diagnosticOutputUri_ = getDefaultInstance().getDiagnosticOutputUri();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A URI pointing to the location of the diagnostics tarball.
     * </pre>
     *
     * <code>string diagnostic_output_uri = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for diagnosticOutputUri to set.
     * @return This builder for chaining.
     */
    public Builder setDiagnosticOutputUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      diagnosticOutputUri_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.cloud.dataproc.v1.UsageMetrics approximateUsage_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.UsageMetrics,
            com.google.cloud.dataproc.v1.UsageMetrics.Builder,
            com.google.cloud.dataproc.v1.UsageMetricsOrBuilder>
        approximateUsageBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Approximate workload resource usage calculated after workload
     * finishes (see [Dataproc Serverless pricing]
     * (https://cloud.google.com/dataproc-serverless/pricing)).
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.UsageMetrics approximate_usage = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the approximateUsage field is set.
     */
    public boolean hasApproximateUsage() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Approximate workload resource usage calculated after workload
     * finishes (see [Dataproc Serverless pricing]
     * (https://cloud.google.com/dataproc-serverless/pricing)).
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.UsageMetrics approximate_usage = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The approximateUsage.
     */
    public com.google.cloud.dataproc.v1.UsageMetrics getApproximateUsage() {
      if (approximateUsageBuilder_ == null) {
        return approximateUsage_ == null
            ? com.google.cloud.dataproc.v1.UsageMetrics.getDefaultInstance()
            : approximateUsage_;
      } else {
        return approximateUsageBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Approximate workload resource usage calculated after workload
     * finishes (see [Dataproc Serverless pricing]
     * (https://cloud.google.com/dataproc-serverless/pricing)).
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.UsageMetrics approximate_usage = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setApproximateUsage(com.google.cloud.dataproc.v1.UsageMetrics value) {
      if (approximateUsageBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        approximateUsage_ = value;
      } else {
        approximateUsageBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Approximate workload resource usage calculated after workload
     * finishes (see [Dataproc Serverless pricing]
     * (https://cloud.google.com/dataproc-serverless/pricing)).
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.UsageMetrics approximate_usage = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setApproximateUsage(
        com.google.cloud.dataproc.v1.UsageMetrics.Builder builderForValue) {
      if (approximateUsageBuilder_ == null) {
        approximateUsage_ = builderForValue.build();
      } else {
        approximateUsageBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Approximate workload resource usage calculated after workload
     * finishes (see [Dataproc Serverless pricing]
     * (https://cloud.google.com/dataproc-serverless/pricing)).
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.UsageMetrics approximate_usage = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeApproximateUsage(com.google.cloud.dataproc.v1.UsageMetrics value) {
      if (approximateUsageBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && approximateUsage_ != null
            && approximateUsage_
                != com.google.cloud.dataproc.v1.UsageMetrics.getDefaultInstance()) {
          getApproximateUsageBuilder().mergeFrom(value);
        } else {
          approximateUsage_ = value;
        }
      } else {
        approximateUsageBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Approximate workload resource usage calculated after workload
     * finishes (see [Dataproc Serverless pricing]
     * (https://cloud.google.com/dataproc-serverless/pricing)).
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.UsageMetrics approximate_usage = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearApproximateUsage() {
      bitField0_ = (bitField0_ & ~0x00000008);
      approximateUsage_ = null;
      if (approximateUsageBuilder_ != null) {
        approximateUsageBuilder_.dispose();
        approximateUsageBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Approximate workload resource usage calculated after workload
     * finishes (see [Dataproc Serverless pricing]
     * (https://cloud.google.com/dataproc-serverless/pricing)).
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.UsageMetrics approximate_usage = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.dataproc.v1.UsageMetrics.Builder getApproximateUsageBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getApproximateUsageFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Approximate workload resource usage calculated after workload
     * finishes (see [Dataproc Serverless pricing]
     * (https://cloud.google.com/dataproc-serverless/pricing)).
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.UsageMetrics approximate_usage = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.dataproc.v1.UsageMetricsOrBuilder getApproximateUsageOrBuilder() {
      if (approximateUsageBuilder_ != null) {
        return approximateUsageBuilder_.getMessageOrBuilder();
      } else {
        return approximateUsage_ == null
            ? com.google.cloud.dataproc.v1.UsageMetrics.getDefaultInstance()
            : approximateUsage_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Approximate workload resource usage calculated after workload
     * finishes (see [Dataproc Serverless pricing]
     * (https://cloud.google.com/dataproc-serverless/pricing)).
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.UsageMetrics approximate_usage = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.UsageMetrics,
            com.google.cloud.dataproc.v1.UsageMetrics.Builder,
            com.google.cloud.dataproc.v1.UsageMetricsOrBuilder>
        getApproximateUsageFieldBuilder() {
      if (approximateUsageBuilder_ == null) {
        approximateUsageBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataproc.v1.UsageMetrics,
                com.google.cloud.dataproc.v1.UsageMetrics.Builder,
                com.google.cloud.dataproc.v1.UsageMetricsOrBuilder>(
                getApproximateUsage(), getParentForChildren(), isClean());
        approximateUsage_ = null;
      }
      return approximateUsageBuilder_;
    }

    private com.google.cloud.dataproc.v1.UsageSnapshot currentUsage_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.UsageSnapshot,
            com.google.cloud.dataproc.v1.UsageSnapshot.Builder,
            com.google.cloud.dataproc.v1.UsageSnapshotOrBuilder>
        currentUsageBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Snapshot of current workload resource usage.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.UsageSnapshot current_usage = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the currentUsage field is set.
     */
    public boolean hasCurrentUsage() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Snapshot of current workload resource usage.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.UsageSnapshot current_usage = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The currentUsage.
     */
    public com.google.cloud.dataproc.v1.UsageSnapshot getCurrentUsage() {
      if (currentUsageBuilder_ == null) {
        return currentUsage_ == null
            ? com.google.cloud.dataproc.v1.UsageSnapshot.getDefaultInstance()
            : currentUsage_;
      } else {
        return currentUsageBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Snapshot of current workload resource usage.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.UsageSnapshot current_usage = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCurrentUsage(com.google.cloud.dataproc.v1.UsageSnapshot value) {
      if (currentUsageBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        currentUsage_ = value;
      } else {
        currentUsageBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Snapshot of current workload resource usage.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.UsageSnapshot current_usage = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCurrentUsage(
        com.google.cloud.dataproc.v1.UsageSnapshot.Builder builderForValue) {
      if (currentUsageBuilder_ == null) {
        currentUsage_ = builderForValue.build();
      } else {
        currentUsageBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Snapshot of current workload resource usage.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.UsageSnapshot current_usage = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCurrentUsage(com.google.cloud.dataproc.v1.UsageSnapshot value) {
      if (currentUsageBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && currentUsage_ != null
            && currentUsage_ != com.google.cloud.dataproc.v1.UsageSnapshot.getDefaultInstance()) {
          getCurrentUsageBuilder().mergeFrom(value);
        } else {
          currentUsage_ = value;
        }
      } else {
        currentUsageBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Snapshot of current workload resource usage.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.UsageSnapshot current_usage = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCurrentUsage() {
      bitField0_ = (bitField0_ & ~0x00000010);
      currentUsage_ = null;
      if (currentUsageBuilder_ != null) {
        currentUsageBuilder_.dispose();
        currentUsageBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Snapshot of current workload resource usage.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.UsageSnapshot current_usage = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.dataproc.v1.UsageSnapshot.Builder getCurrentUsageBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getCurrentUsageFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Snapshot of current workload resource usage.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.UsageSnapshot current_usage = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.dataproc.v1.UsageSnapshotOrBuilder getCurrentUsageOrBuilder() {
      if (currentUsageBuilder_ != null) {
        return currentUsageBuilder_.getMessageOrBuilder();
      } else {
        return currentUsage_ == null
            ? com.google.cloud.dataproc.v1.UsageSnapshot.getDefaultInstance()
            : currentUsage_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Snapshot of current workload resource usage.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.UsageSnapshot current_usage = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.UsageSnapshot,
            com.google.cloud.dataproc.v1.UsageSnapshot.Builder,
            com.google.cloud.dataproc.v1.UsageSnapshotOrBuilder>
        getCurrentUsageFieldBuilder() {
      if (currentUsageBuilder_ == null) {
        currentUsageBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataproc.v1.UsageSnapshot,
                com.google.cloud.dataproc.v1.UsageSnapshot.Builder,
                com.google.cloud.dataproc.v1.UsageSnapshotOrBuilder>(
                getCurrentUsage(), getParentForChildren(), isClean());
        currentUsage_ = null;
      }
      return currentUsageBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dataproc.v1.RuntimeInfo)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dataproc.v1.RuntimeInfo)
  private static final com.google.cloud.dataproc.v1.RuntimeInfo DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dataproc.v1.RuntimeInfo();
  }

  public static com.google.cloud.dataproc.v1.RuntimeInfo getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<RuntimeInfo> PARSER =
      new com.google.protobuf.AbstractParser<RuntimeInfo>() {
        @java.lang.Override
        public RuntimeInfo parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<RuntimeInfo> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<RuntimeInfo> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dataproc.v1.RuntimeInfo getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
