/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dataproc/v1/batches.proto

package com.google.cloud.dataproc.v1;

public interface SparkRBatchOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.dataproc.v1.SparkRBatch)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Required. The HCFS URI of the main R file to use as the driver.
   * Must be a `.R` or `.r` file.
   * </pre>
   *
   * <code>string main_r_file_uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The mainRFileUri.
   */
  java.lang.String getMainRFileUri();
  /**
   *
   *
   * <pre>
   * Required. The HCFS URI of the main R file to use as the driver.
   * Must be a `.R` or `.r` file.
   * </pre>
   *
   * <code>string main_r_file_uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for mainRFileUri.
   */
  com.google.protobuf.ByteString getMainRFileUriBytes();

  /**
   *
   *
   * <pre>
   * Optional. The arguments to pass to the Spark driver. Do not include
   * arguments that can be set as batch properties, such as `--conf`, since a
   * collision can occur that causes an incorrect batch submission.
   * </pre>
   *
   * <code>repeated string args = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return A list containing the args.
   */
  java.util.List<java.lang.String> getArgsList();
  /**
   *
   *
   * <pre>
   * Optional. The arguments to pass to the Spark driver. Do not include
   * arguments that can be set as batch properties, such as `--conf`, since a
   * collision can occur that causes an incorrect batch submission.
   * </pre>
   *
   * <code>repeated string args = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The count of args.
   */
  int getArgsCount();
  /**
   *
   *
   * <pre>
   * Optional. The arguments to pass to the Spark driver. Do not include
   * arguments that can be set as batch properties, such as `--conf`, since a
   * collision can occur that causes an incorrect batch submission.
   * </pre>
   *
   * <code>repeated string args = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the element to return.
   * @return The args at the given index.
   */
  java.lang.String getArgs(int index);
  /**
   *
   *
   * <pre>
   * Optional. The arguments to pass to the Spark driver. Do not include
   * arguments that can be set as batch properties, such as `--conf`, since a
   * collision can occur that causes an incorrect batch submission.
   * </pre>
   *
   * <code>repeated string args = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the args at the given index.
   */
  com.google.protobuf.ByteString getArgsBytes(int index);

  /**
   *
   *
   * <pre>
   * Optional. HCFS URIs of files to be placed in the working directory of
   * each executor.
   * </pre>
   *
   * <code>repeated string file_uris = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return A list containing the fileUris.
   */
  java.util.List<java.lang.String> getFileUrisList();
  /**
   *
   *
   * <pre>
   * Optional. HCFS URIs of files to be placed in the working directory of
   * each executor.
   * </pre>
   *
   * <code>repeated string file_uris = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The count of fileUris.
   */
  int getFileUrisCount();
  /**
   *
   *
   * <pre>
   * Optional. HCFS URIs of files to be placed in the working directory of
   * each executor.
   * </pre>
   *
   * <code>repeated string file_uris = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the element to return.
   * @return The fileUris at the given index.
   */
  java.lang.String getFileUris(int index);
  /**
   *
   *
   * <pre>
   * Optional. HCFS URIs of files to be placed in the working directory of
   * each executor.
   * </pre>
   *
   * <code>repeated string file_uris = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the fileUris at the given index.
   */
  com.google.protobuf.ByteString getFileUrisBytes(int index);

  /**
   *
   *
   * <pre>
   * Optional. HCFS URIs of archives to be extracted into the working directory
   * of each executor. Supported file types:
   * `.jar`, `.tar`, `.tar.gz`, `.tgz`, and `.zip`.
   * </pre>
   *
   * <code>repeated string archive_uris = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return A list containing the archiveUris.
   */
  java.util.List<java.lang.String> getArchiveUrisList();
  /**
   *
   *
   * <pre>
   * Optional. HCFS URIs of archives to be extracted into the working directory
   * of each executor. Supported file types:
   * `.jar`, `.tar`, `.tar.gz`, `.tgz`, and `.zip`.
   * </pre>
   *
   * <code>repeated string archive_uris = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The count of archiveUris.
   */
  int getArchiveUrisCount();
  /**
   *
   *
   * <pre>
   * Optional. HCFS URIs of archives to be extracted into the working directory
   * of each executor. Supported file types:
   * `.jar`, `.tar`, `.tar.gz`, `.tgz`, and `.zip`.
   * </pre>
   *
   * <code>repeated string archive_uris = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the element to return.
   * @return The archiveUris at the given index.
   */
  java.lang.String getArchiveUris(int index);
  /**
   *
   *
   * <pre>
   * Optional. HCFS URIs of archives to be extracted into the working directory
   * of each executor. Supported file types:
   * `.jar`, `.tar`, `.tar.gz`, `.tgz`, and `.zip`.
   * </pre>
   *
   * <code>repeated string archive_uris = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the archiveUris at the given index.
   */
  com.google.protobuf.ByteString getArchiveUrisBytes(int index);
}
