/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dataproc/v1/clusters.proto

package com.google.cloud.dataproc.v1;

/**
 *
 *
 * <pre>
 * A request to update a cluster.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dataproc.v1.UpdateClusterRequest}
 */
public final class UpdateClusterRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dataproc.v1.UpdateClusterRequest)
    UpdateClusterRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use UpdateClusterRequest.newBuilder() to construct.
  private UpdateClusterRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private UpdateClusterRequest() {
    projectId_ = "";
    region_ = "";
    clusterName_ = "";
    requestId_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new UpdateClusterRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dataproc.v1.ClustersProto
        .internal_static_google_cloud_dataproc_v1_UpdateClusterRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dataproc.v1.ClustersProto
        .internal_static_google_cloud_dataproc_v1_UpdateClusterRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dataproc.v1.UpdateClusterRequest.class,
            com.google.cloud.dataproc.v1.UpdateClusterRequest.Builder.class);
  }

  public static final int PROJECT_ID_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object projectId_ = "";
  /**
   *
   *
   * <pre>
   * Required. The ID of the Google Cloud Platform project the
   * cluster belongs to.
   * </pre>
   *
   * <code>string project_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The projectId.
   */
  @java.lang.Override
  public java.lang.String getProjectId() {
    java.lang.Object ref = projectId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      projectId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The ID of the Google Cloud Platform project the
   * cluster belongs to.
   * </pre>
   *
   * <code>string project_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for projectId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getProjectIdBytes() {
    java.lang.Object ref = projectId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      projectId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int REGION_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object region_ = "";
  /**
   *
   *
   * <pre>
   * Required. The Dataproc region in which to handle the request.
   * </pre>
   *
   * <code>string region = 5 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The region.
   */
  @java.lang.Override
  public java.lang.String getRegion() {
    java.lang.Object ref = region_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      region_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The Dataproc region in which to handle the request.
   * </pre>
   *
   * <code>string region = 5 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for region.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRegionBytes() {
    java.lang.Object ref = region_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      region_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CLUSTER_NAME_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object clusterName_ = "";
  /**
   *
   *
   * <pre>
   * Required. The cluster name.
   * </pre>
   *
   * <code>string cluster_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The clusterName.
   */
  @java.lang.Override
  public java.lang.String getClusterName() {
    java.lang.Object ref = clusterName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      clusterName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The cluster name.
   * </pre>
   *
   * <code>string cluster_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for clusterName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getClusterNameBytes() {
    java.lang.Object ref = clusterName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      clusterName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CLUSTER_FIELD_NUMBER = 3;
  private com.google.cloud.dataproc.v1.Cluster cluster_;
  /**
   *
   *
   * <pre>
   * Required. The changes to the cluster.
   * </pre>
   *
   * <code>.google.cloud.dataproc.v1.Cluster cluster = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the cluster field is set.
   */
  @java.lang.Override
  public boolean hasCluster() {
    return cluster_ != null;
  }
  /**
   *
   *
   * <pre>
   * Required. The changes to the cluster.
   * </pre>
   *
   * <code>.google.cloud.dataproc.v1.Cluster cluster = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The cluster.
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.Cluster getCluster() {
    return cluster_ == null ? com.google.cloud.dataproc.v1.Cluster.getDefaultInstance() : cluster_;
  }
  /**
   *
   *
   * <pre>
   * Required. The changes to the cluster.
   * </pre>
   *
   * <code>.google.cloud.dataproc.v1.Cluster cluster = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.ClusterOrBuilder getClusterOrBuilder() {
    return cluster_ == null ? com.google.cloud.dataproc.v1.Cluster.getDefaultInstance() : cluster_;
  }

  public static final int GRACEFUL_DECOMMISSION_TIMEOUT_FIELD_NUMBER = 6;
  private com.google.protobuf.Duration gracefulDecommissionTimeout_;
  /**
   *
   *
   * <pre>
   * Optional. Timeout for graceful YARN decommissioning. Graceful
   * decommissioning allows removing nodes from the cluster without
   * interrupting jobs in progress. Timeout specifies how long to wait for jobs
   * in progress to finish before forcefully removing nodes (and potentially
   * interrupting jobs). Default timeout is 0 (for forceful decommission), and
   * the maximum allowed timeout is 1 day. (see JSON representation of
   * [Duration](https://developers.google.com/protocol-buffers/docs/proto3#json)).
   *
   * Only supported on Dataproc image versions 1.2 and higher.
   * </pre>
   *
   * <code>
   * .google.protobuf.Duration graceful_decommission_timeout = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the gracefulDecommissionTimeout field is set.
   */
  @java.lang.Override
  public boolean hasGracefulDecommissionTimeout() {
    return gracefulDecommissionTimeout_ != null;
  }
  /**
   *
   *
   * <pre>
   * Optional. Timeout for graceful YARN decommissioning. Graceful
   * decommissioning allows removing nodes from the cluster without
   * interrupting jobs in progress. Timeout specifies how long to wait for jobs
   * in progress to finish before forcefully removing nodes (and potentially
   * interrupting jobs). Default timeout is 0 (for forceful decommission), and
   * the maximum allowed timeout is 1 day. (see JSON representation of
   * [Duration](https://developers.google.com/protocol-buffers/docs/proto3#json)).
   *
   * Only supported on Dataproc image versions 1.2 and higher.
   * </pre>
   *
   * <code>
   * .google.protobuf.Duration graceful_decommission_timeout = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The gracefulDecommissionTimeout.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getGracefulDecommissionTimeout() {
    return gracefulDecommissionTimeout_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : gracefulDecommissionTimeout_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Timeout for graceful YARN decommissioning. Graceful
   * decommissioning allows removing nodes from the cluster without
   * interrupting jobs in progress. Timeout specifies how long to wait for jobs
   * in progress to finish before forcefully removing nodes (and potentially
   * interrupting jobs). Default timeout is 0 (for forceful decommission), and
   * the maximum allowed timeout is 1 day. (see JSON representation of
   * [Duration](https://developers.google.com/protocol-buffers/docs/proto3#json)).
   *
   * Only supported on Dataproc image versions 1.2 and higher.
   * </pre>
   *
   * <code>
   * .google.protobuf.Duration graceful_decommission_timeout = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getGracefulDecommissionTimeoutOrBuilder() {
    return gracefulDecommissionTimeout_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : gracefulDecommissionTimeout_;
  }

  public static final int UPDATE_MASK_FIELD_NUMBER = 4;
  private com.google.protobuf.FieldMask updateMask_;
  /**
   *
   *
   * <pre>
   * Required. Specifies the path, relative to `Cluster`, of
   * the field to update. For example, to change the number of workers
   * in a cluster to 5, the `update_mask` parameter would be
   * specified as `config.worker_config.num_instances`,
   * and the `PATCH` request body would specify the new value, as follows:
   *
   *     {
   *       "config":{
   *         "workerConfig":{
   *           "numInstances":"5"
   *         }
   *       }
   *     }
   * Similarly, to change the number of preemptible workers in a cluster to 5,
   * the `update_mask` parameter would be
   * `config.secondary_worker_config.num_instances`, and the `PATCH` request
   * body would be set as follows:
   *
   *     {
   *       "config":{
   *         "secondaryWorkerConfig":{
   *           "numInstances":"5"
   *         }
   *       }
   *     }
   * &lt;strong&gt;Note:&lt;/strong&gt; Currently, only the following fields can be updated:
   *
   *  &lt;table&gt;
   *  &lt;tbody&gt;
   *  &lt;tr&gt;
   *  &lt;td&gt;&lt;strong&gt;Mask&lt;/strong&gt;&lt;/td&gt;
   *  &lt;td&gt;&lt;strong&gt;Purpose&lt;/strong&gt;&lt;/td&gt;
   *  &lt;/tr&gt;
   *  &lt;tr&gt;
   *  &lt;td&gt;&lt;strong&gt;&lt;em&gt;labels&lt;/em&gt;&lt;/strong&gt;&lt;/td&gt;
   *  &lt;td&gt;Update labels&lt;/td&gt;
   *  &lt;/tr&gt;
   *  &lt;tr&gt;
   *  &lt;td&gt;&lt;strong&gt;&lt;em&gt;config.worker_config.num_instances&lt;/em&gt;&lt;/strong&gt;&lt;/td&gt;
   *  &lt;td&gt;Resize primary worker group&lt;/td&gt;
   *  &lt;/tr&gt;
   *  &lt;tr&gt;
   *  &lt;td&gt;&lt;strong&gt;&lt;em&gt;config.secondary_worker_config.num_instances&lt;/em&gt;&lt;/strong&gt;&lt;/td&gt;
   *  &lt;td&gt;Resize secondary worker group&lt;/td&gt;
   *  &lt;/tr&gt;
   *  &lt;tr&gt;
   *  &lt;td&gt;config.autoscaling_config.policy_uri&lt;/td&gt;&lt;td&gt;Use, stop using, or
   *  change autoscaling policies&lt;/td&gt;
   *  &lt;/tr&gt;
   *  &lt;/tbody&gt;
   *  &lt;/table&gt;
   * </pre>
   *
   * <code>.google.protobuf.FieldMask update_mask = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the updateMask field is set.
   */
  @java.lang.Override
  public boolean hasUpdateMask() {
    return updateMask_ != null;
  }
  /**
   *
   *
   * <pre>
   * Required. Specifies the path, relative to `Cluster`, of
   * the field to update. For example, to change the number of workers
   * in a cluster to 5, the `update_mask` parameter would be
   * specified as `config.worker_config.num_instances`,
   * and the `PATCH` request body would specify the new value, as follows:
   *
   *     {
   *       "config":{
   *         "workerConfig":{
   *           "numInstances":"5"
   *         }
   *       }
   *     }
   * Similarly, to change the number of preemptible workers in a cluster to 5,
   * the `update_mask` parameter would be
   * `config.secondary_worker_config.num_instances`, and the `PATCH` request
   * body would be set as follows:
   *
   *     {
   *       "config":{
   *         "secondaryWorkerConfig":{
   *           "numInstances":"5"
   *         }
   *       }
   *     }
   * &lt;strong&gt;Note:&lt;/strong&gt; Currently, only the following fields can be updated:
   *
   *  &lt;table&gt;
   *  &lt;tbody&gt;
   *  &lt;tr&gt;
   *  &lt;td&gt;&lt;strong&gt;Mask&lt;/strong&gt;&lt;/td&gt;
   *  &lt;td&gt;&lt;strong&gt;Purpose&lt;/strong&gt;&lt;/td&gt;
   *  &lt;/tr&gt;
   *  &lt;tr&gt;
   *  &lt;td&gt;&lt;strong&gt;&lt;em&gt;labels&lt;/em&gt;&lt;/strong&gt;&lt;/td&gt;
   *  &lt;td&gt;Update labels&lt;/td&gt;
   *  &lt;/tr&gt;
   *  &lt;tr&gt;
   *  &lt;td&gt;&lt;strong&gt;&lt;em&gt;config.worker_config.num_instances&lt;/em&gt;&lt;/strong&gt;&lt;/td&gt;
   *  &lt;td&gt;Resize primary worker group&lt;/td&gt;
   *  &lt;/tr&gt;
   *  &lt;tr&gt;
   *  &lt;td&gt;&lt;strong&gt;&lt;em&gt;config.secondary_worker_config.num_instances&lt;/em&gt;&lt;/strong&gt;&lt;/td&gt;
   *  &lt;td&gt;Resize secondary worker group&lt;/td&gt;
   *  &lt;/tr&gt;
   *  &lt;tr&gt;
   *  &lt;td&gt;config.autoscaling_config.policy_uri&lt;/td&gt;&lt;td&gt;Use, stop using, or
   *  change autoscaling policies&lt;/td&gt;
   *  &lt;/tr&gt;
   *  &lt;/tbody&gt;
   *  &lt;/table&gt;
   * </pre>
   *
   * <code>.google.protobuf.FieldMask update_mask = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The updateMask.
   */
  @java.lang.Override
  public com.google.protobuf.FieldMask getUpdateMask() {
    return updateMask_ == null ? com.google.protobuf.FieldMask.getDefaultInstance() : updateMask_;
  }
  /**
   *
   *
   * <pre>
   * Required. Specifies the path, relative to `Cluster`, of
   * the field to update. For example, to change the number of workers
   * in a cluster to 5, the `update_mask` parameter would be
   * specified as `config.worker_config.num_instances`,
   * and the `PATCH` request body would specify the new value, as follows:
   *
   *     {
   *       "config":{
   *         "workerConfig":{
   *           "numInstances":"5"
   *         }
   *       }
   *     }
   * Similarly, to change the number of preemptible workers in a cluster to 5,
   * the `update_mask` parameter would be
   * `config.secondary_worker_config.num_instances`, and the `PATCH` request
   * body would be set as follows:
   *
   *     {
   *       "config":{
   *         "secondaryWorkerConfig":{
   *           "numInstances":"5"
   *         }
   *       }
   *     }
   * &lt;strong&gt;Note:&lt;/strong&gt; Currently, only the following fields can be updated:
   *
   *  &lt;table&gt;
   *  &lt;tbody&gt;
   *  &lt;tr&gt;
   *  &lt;td&gt;&lt;strong&gt;Mask&lt;/strong&gt;&lt;/td&gt;
   *  &lt;td&gt;&lt;strong&gt;Purpose&lt;/strong&gt;&lt;/td&gt;
   *  &lt;/tr&gt;
   *  &lt;tr&gt;
   *  &lt;td&gt;&lt;strong&gt;&lt;em&gt;labels&lt;/em&gt;&lt;/strong&gt;&lt;/td&gt;
   *  &lt;td&gt;Update labels&lt;/td&gt;
   *  &lt;/tr&gt;
   *  &lt;tr&gt;
   *  &lt;td&gt;&lt;strong&gt;&lt;em&gt;config.worker_config.num_instances&lt;/em&gt;&lt;/strong&gt;&lt;/td&gt;
   *  &lt;td&gt;Resize primary worker group&lt;/td&gt;
   *  &lt;/tr&gt;
   *  &lt;tr&gt;
   *  &lt;td&gt;&lt;strong&gt;&lt;em&gt;config.secondary_worker_config.num_instances&lt;/em&gt;&lt;/strong&gt;&lt;/td&gt;
   *  &lt;td&gt;Resize secondary worker group&lt;/td&gt;
   *  &lt;/tr&gt;
   *  &lt;tr&gt;
   *  &lt;td&gt;config.autoscaling_config.policy_uri&lt;/td&gt;&lt;td&gt;Use, stop using, or
   *  change autoscaling policies&lt;/td&gt;
   *  &lt;/tr&gt;
   *  &lt;/tbody&gt;
   *  &lt;/table&gt;
   * </pre>
   *
   * <code>.google.protobuf.FieldMask update_mask = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.FieldMaskOrBuilder getUpdateMaskOrBuilder() {
    return updateMask_ == null ? com.google.protobuf.FieldMask.getDefaultInstance() : updateMask_;
  }

  public static final int REQUEST_ID_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private volatile java.lang.Object requestId_ = "";
  /**
   *
   *
   * <pre>
   * Optional. A unique ID used to identify the request. If the server
   * receives two
   * [UpdateClusterRequest](https://cloud.google.com/dataproc/docs/reference/rpc/google.cloud.dataproc.v1#google.cloud.dataproc.v1.UpdateClusterRequest)s
   * with the same id, then the second request will be ignored and the
   * first [google.longrunning.Operation][google.longrunning.Operation] created
   * and stored in the backend is returned.
   *
   * It is recommended to always set this value to a
   * [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier).
   *
   * The ID must contain only letters (a-z, A-Z), numbers (0-9),
   * underscores (_), and hyphens (-). The maximum length is 40 characters.
   * </pre>
   *
   * <code>string request_id = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The requestId.
   */
  @java.lang.Override
  public java.lang.String getRequestId() {
    java.lang.Object ref = requestId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      requestId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. A unique ID used to identify the request. If the server
   * receives two
   * [UpdateClusterRequest](https://cloud.google.com/dataproc/docs/reference/rpc/google.cloud.dataproc.v1#google.cloud.dataproc.v1.UpdateClusterRequest)s
   * with the same id, then the second request will be ignored and the
   * first [google.longrunning.Operation][google.longrunning.Operation] created
   * and stored in the backend is returned.
   *
   * It is recommended to always set this value to a
   * [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier).
   *
   * The ID must contain only letters (a-z, A-Z), numbers (0-9),
   * underscores (_), and hyphens (-). The maximum length is 40 characters.
   * </pre>
   *
   * <code>string request_id = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for requestId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRequestIdBytes() {
    java.lang.Object ref = requestId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      requestId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(projectId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, projectId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(clusterName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, clusterName_);
    }
    if (cluster_ != null) {
      output.writeMessage(3, getCluster());
    }
    if (updateMask_ != null) {
      output.writeMessage(4, getUpdateMask());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(region_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, region_);
    }
    if (gracefulDecommissionTimeout_ != null) {
      output.writeMessage(6, getGracefulDecommissionTimeout());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(requestId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, requestId_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(projectId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, projectId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(clusterName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, clusterName_);
    }
    if (cluster_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getCluster());
    }
    if (updateMask_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getUpdateMask());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(region_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, region_);
    }
    if (gracefulDecommissionTimeout_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              6, getGracefulDecommissionTimeout());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(requestId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, requestId_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dataproc.v1.UpdateClusterRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.dataproc.v1.UpdateClusterRequest other =
        (com.google.cloud.dataproc.v1.UpdateClusterRequest) obj;

    if (!getProjectId().equals(other.getProjectId())) return false;
    if (!getRegion().equals(other.getRegion())) return false;
    if (!getClusterName().equals(other.getClusterName())) return false;
    if (hasCluster() != other.hasCluster()) return false;
    if (hasCluster()) {
      if (!getCluster().equals(other.getCluster())) return false;
    }
    if (hasGracefulDecommissionTimeout() != other.hasGracefulDecommissionTimeout()) return false;
    if (hasGracefulDecommissionTimeout()) {
      if (!getGracefulDecommissionTimeout().equals(other.getGracefulDecommissionTimeout()))
        return false;
    }
    if (hasUpdateMask() != other.hasUpdateMask()) return false;
    if (hasUpdateMask()) {
      if (!getUpdateMask().equals(other.getUpdateMask())) return false;
    }
    if (!getRequestId().equals(other.getRequestId())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PROJECT_ID_FIELD_NUMBER;
    hash = (53 * hash) + getProjectId().hashCode();
    hash = (37 * hash) + REGION_FIELD_NUMBER;
    hash = (53 * hash) + getRegion().hashCode();
    hash = (37 * hash) + CLUSTER_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getClusterName().hashCode();
    if (hasCluster()) {
      hash = (37 * hash) + CLUSTER_FIELD_NUMBER;
      hash = (53 * hash) + getCluster().hashCode();
    }
    if (hasGracefulDecommissionTimeout()) {
      hash = (37 * hash) + GRACEFUL_DECOMMISSION_TIMEOUT_FIELD_NUMBER;
      hash = (53 * hash) + getGracefulDecommissionTimeout().hashCode();
    }
    if (hasUpdateMask()) {
      hash = (37 * hash) + UPDATE_MASK_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateMask().hashCode();
    }
    hash = (37 * hash) + REQUEST_ID_FIELD_NUMBER;
    hash = (53 * hash) + getRequestId().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dataproc.v1.UpdateClusterRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1.UpdateClusterRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.UpdateClusterRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1.UpdateClusterRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.UpdateClusterRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1.UpdateClusterRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.UpdateClusterRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1.UpdateClusterRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.UpdateClusterRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1.UpdateClusterRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.UpdateClusterRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1.UpdateClusterRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.dataproc.v1.UpdateClusterRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A request to update a cluster.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dataproc.v1.UpdateClusterRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dataproc.v1.UpdateClusterRequest)
      com.google.cloud.dataproc.v1.UpdateClusterRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dataproc.v1.ClustersProto
          .internal_static_google_cloud_dataproc_v1_UpdateClusterRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dataproc.v1.ClustersProto
          .internal_static_google_cloud_dataproc_v1_UpdateClusterRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dataproc.v1.UpdateClusterRequest.class,
              com.google.cloud.dataproc.v1.UpdateClusterRequest.Builder.class);
    }

    // Construct using com.google.cloud.dataproc.v1.UpdateClusterRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      projectId_ = "";
      region_ = "";
      clusterName_ = "";
      cluster_ = null;
      if (clusterBuilder_ != null) {
        clusterBuilder_.dispose();
        clusterBuilder_ = null;
      }
      gracefulDecommissionTimeout_ = null;
      if (gracefulDecommissionTimeoutBuilder_ != null) {
        gracefulDecommissionTimeoutBuilder_.dispose();
        gracefulDecommissionTimeoutBuilder_ = null;
      }
      updateMask_ = null;
      if (updateMaskBuilder_ != null) {
        updateMaskBuilder_.dispose();
        updateMaskBuilder_ = null;
      }
      requestId_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dataproc.v1.ClustersProto
          .internal_static_google_cloud_dataproc_v1_UpdateClusterRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.UpdateClusterRequest getDefaultInstanceForType() {
      return com.google.cloud.dataproc.v1.UpdateClusterRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.UpdateClusterRequest build() {
      com.google.cloud.dataproc.v1.UpdateClusterRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.UpdateClusterRequest buildPartial() {
      com.google.cloud.dataproc.v1.UpdateClusterRequest result =
          new com.google.cloud.dataproc.v1.UpdateClusterRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.dataproc.v1.UpdateClusterRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.projectId_ = projectId_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.region_ = region_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.clusterName_ = clusterName_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.cluster_ = clusterBuilder_ == null ? cluster_ : clusterBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.gracefulDecommissionTimeout_ =
            gracefulDecommissionTimeoutBuilder_ == null
                ? gracefulDecommissionTimeout_
                : gracefulDecommissionTimeoutBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.updateMask_ = updateMaskBuilder_ == null ? updateMask_ : updateMaskBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.requestId_ = requestId_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dataproc.v1.UpdateClusterRequest) {
        return mergeFrom((com.google.cloud.dataproc.v1.UpdateClusterRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dataproc.v1.UpdateClusterRequest other) {
      if (other == com.google.cloud.dataproc.v1.UpdateClusterRequest.getDefaultInstance())
        return this;
      if (!other.getProjectId().isEmpty()) {
        projectId_ = other.projectId_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getRegion().isEmpty()) {
        region_ = other.region_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getClusterName().isEmpty()) {
        clusterName_ = other.clusterName_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasCluster()) {
        mergeCluster(other.getCluster());
      }
      if (other.hasGracefulDecommissionTimeout()) {
        mergeGracefulDecommissionTimeout(other.getGracefulDecommissionTimeout());
      }
      if (other.hasUpdateMask()) {
        mergeUpdateMask(other.getUpdateMask());
      }
      if (!other.getRequestId().isEmpty()) {
        requestId_ = other.requestId_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                projectId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                clusterName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getClusterFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getUpdateMaskFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 34
            case 42:
              {
                region_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(
                    getGracefulDecommissionTimeoutFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 50
            case 58:
              {
                requestId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object projectId_ = "";
    /**
     *
     *
     * <pre>
     * Required. The ID of the Google Cloud Platform project the
     * cluster belongs to.
     * </pre>
     *
     * <code>string project_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The projectId.
     */
    public java.lang.String getProjectId() {
      java.lang.Object ref = projectId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        projectId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The ID of the Google Cloud Platform project the
     * cluster belongs to.
     * </pre>
     *
     * <code>string project_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for projectId.
     */
    public com.google.protobuf.ByteString getProjectIdBytes() {
      java.lang.Object ref = projectId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        projectId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The ID of the Google Cloud Platform project the
     * cluster belongs to.
     * </pre>
     *
     * <code>string project_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The projectId to set.
     * @return This builder for chaining.
     */
    public Builder setProjectId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      projectId_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The ID of the Google Cloud Platform project the
     * cluster belongs to.
     * </pre>
     *
     * <code>string project_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearProjectId() {
      projectId_ = getDefaultInstance().getProjectId();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The ID of the Google Cloud Platform project the
     * cluster belongs to.
     * </pre>
     *
     * <code>string project_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for projectId to set.
     * @return This builder for chaining.
     */
    public Builder setProjectIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      projectId_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object region_ = "";
    /**
     *
     *
     * <pre>
     * Required. The Dataproc region in which to handle the request.
     * </pre>
     *
     * <code>string region = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The region.
     */
    public java.lang.String getRegion() {
      java.lang.Object ref = region_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        region_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The Dataproc region in which to handle the request.
     * </pre>
     *
     * <code>string region = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for region.
     */
    public com.google.protobuf.ByteString getRegionBytes() {
      java.lang.Object ref = region_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        region_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The Dataproc region in which to handle the request.
     * </pre>
     *
     * <code>string region = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The region to set.
     * @return This builder for chaining.
     */
    public Builder setRegion(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      region_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The Dataproc region in which to handle the request.
     * </pre>
     *
     * <code>string region = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRegion() {
      region_ = getDefaultInstance().getRegion();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The Dataproc region in which to handle the request.
     * </pre>
     *
     * <code>string region = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for region to set.
     * @return This builder for chaining.
     */
    public Builder setRegionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      region_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object clusterName_ = "";
    /**
     *
     *
     * <pre>
     * Required. The cluster name.
     * </pre>
     *
     * <code>string cluster_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The clusterName.
     */
    public java.lang.String getClusterName() {
      java.lang.Object ref = clusterName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        clusterName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The cluster name.
     * </pre>
     *
     * <code>string cluster_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for clusterName.
     */
    public com.google.protobuf.ByteString getClusterNameBytes() {
      java.lang.Object ref = clusterName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        clusterName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The cluster name.
     * </pre>
     *
     * <code>string cluster_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The clusterName to set.
     * @return This builder for chaining.
     */
    public Builder setClusterName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      clusterName_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The cluster name.
     * </pre>
     *
     * <code>string cluster_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearClusterName() {
      clusterName_ = getDefaultInstance().getClusterName();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The cluster name.
     * </pre>
     *
     * <code>string cluster_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for clusterName to set.
     * @return This builder for chaining.
     */
    public Builder setClusterNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      clusterName_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.cloud.dataproc.v1.Cluster cluster_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.Cluster,
            com.google.cloud.dataproc.v1.Cluster.Builder,
            com.google.cloud.dataproc.v1.ClusterOrBuilder>
        clusterBuilder_;
    /**
     *
     *
     * <pre>
     * Required. The changes to the cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.Cluster cluster = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the cluster field is set.
     */
    public boolean hasCluster() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. The changes to the cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.Cluster cluster = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The cluster.
     */
    public com.google.cloud.dataproc.v1.Cluster getCluster() {
      if (clusterBuilder_ == null) {
        return cluster_ == null
            ? com.google.cloud.dataproc.v1.Cluster.getDefaultInstance()
            : cluster_;
      } else {
        return clusterBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The changes to the cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.Cluster cluster = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setCluster(com.google.cloud.dataproc.v1.Cluster value) {
      if (clusterBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        cluster_ = value;
      } else {
        clusterBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The changes to the cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.Cluster cluster = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setCluster(com.google.cloud.dataproc.v1.Cluster.Builder builderForValue) {
      if (clusterBuilder_ == null) {
        cluster_ = builderForValue.build();
      } else {
        clusterBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The changes to the cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.Cluster cluster = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeCluster(com.google.cloud.dataproc.v1.Cluster value) {
      if (clusterBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && cluster_ != null
            && cluster_ != com.google.cloud.dataproc.v1.Cluster.getDefaultInstance()) {
          getClusterBuilder().mergeFrom(value);
        } else {
          cluster_ = value;
        }
      } else {
        clusterBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The changes to the cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.Cluster cluster = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearCluster() {
      bitField0_ = (bitField0_ & ~0x00000008);
      cluster_ = null;
      if (clusterBuilder_ != null) {
        clusterBuilder_.dispose();
        clusterBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The changes to the cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.Cluster cluster = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.dataproc.v1.Cluster.Builder getClusterBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getClusterFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. The changes to the cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.Cluster cluster = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.dataproc.v1.ClusterOrBuilder getClusterOrBuilder() {
      if (clusterBuilder_ != null) {
        return clusterBuilder_.getMessageOrBuilder();
      } else {
        return cluster_ == null
            ? com.google.cloud.dataproc.v1.Cluster.getDefaultInstance()
            : cluster_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The changes to the cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.Cluster cluster = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.Cluster,
            com.google.cloud.dataproc.v1.Cluster.Builder,
            com.google.cloud.dataproc.v1.ClusterOrBuilder>
        getClusterFieldBuilder() {
      if (clusterBuilder_ == null) {
        clusterBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataproc.v1.Cluster,
                com.google.cloud.dataproc.v1.Cluster.Builder,
                com.google.cloud.dataproc.v1.ClusterOrBuilder>(
                getCluster(), getParentForChildren(), isClean());
        cluster_ = null;
      }
      return clusterBuilder_;
    }

    private com.google.protobuf.Duration gracefulDecommissionTimeout_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        gracefulDecommissionTimeoutBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Timeout for graceful YARN decommissioning. Graceful
     * decommissioning allows removing nodes from the cluster without
     * interrupting jobs in progress. Timeout specifies how long to wait for jobs
     * in progress to finish before forcefully removing nodes (and potentially
     * interrupting jobs). Default timeout is 0 (for forceful decommission), and
     * the maximum allowed timeout is 1 day. (see JSON representation of
     * [Duration](https://developers.google.com/protocol-buffers/docs/proto3#json)).
     *
     * Only supported on Dataproc image versions 1.2 and higher.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration graceful_decommission_timeout = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the gracefulDecommissionTimeout field is set.
     */
    public boolean hasGracefulDecommissionTimeout() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Timeout for graceful YARN decommissioning. Graceful
     * decommissioning allows removing nodes from the cluster without
     * interrupting jobs in progress. Timeout specifies how long to wait for jobs
     * in progress to finish before forcefully removing nodes (and potentially
     * interrupting jobs). Default timeout is 0 (for forceful decommission), and
     * the maximum allowed timeout is 1 day. (see JSON representation of
     * [Duration](https://developers.google.com/protocol-buffers/docs/proto3#json)).
     *
     * Only supported on Dataproc image versions 1.2 and higher.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration graceful_decommission_timeout = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The gracefulDecommissionTimeout.
     */
    public com.google.protobuf.Duration getGracefulDecommissionTimeout() {
      if (gracefulDecommissionTimeoutBuilder_ == null) {
        return gracefulDecommissionTimeout_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : gracefulDecommissionTimeout_;
      } else {
        return gracefulDecommissionTimeoutBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Timeout for graceful YARN decommissioning. Graceful
     * decommissioning allows removing nodes from the cluster without
     * interrupting jobs in progress. Timeout specifies how long to wait for jobs
     * in progress to finish before forcefully removing nodes (and potentially
     * interrupting jobs). Default timeout is 0 (for forceful decommission), and
     * the maximum allowed timeout is 1 day. (see JSON representation of
     * [Duration](https://developers.google.com/protocol-buffers/docs/proto3#json)).
     *
     * Only supported on Dataproc image versions 1.2 and higher.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration graceful_decommission_timeout = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setGracefulDecommissionTimeout(com.google.protobuf.Duration value) {
      if (gracefulDecommissionTimeoutBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        gracefulDecommissionTimeout_ = value;
      } else {
        gracefulDecommissionTimeoutBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Timeout for graceful YARN decommissioning. Graceful
     * decommissioning allows removing nodes from the cluster without
     * interrupting jobs in progress. Timeout specifies how long to wait for jobs
     * in progress to finish before forcefully removing nodes (and potentially
     * interrupting jobs). Default timeout is 0 (for forceful decommission), and
     * the maximum allowed timeout is 1 day. (see JSON representation of
     * [Duration](https://developers.google.com/protocol-buffers/docs/proto3#json)).
     *
     * Only supported on Dataproc image versions 1.2 and higher.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration graceful_decommission_timeout = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setGracefulDecommissionTimeout(
        com.google.protobuf.Duration.Builder builderForValue) {
      if (gracefulDecommissionTimeoutBuilder_ == null) {
        gracefulDecommissionTimeout_ = builderForValue.build();
      } else {
        gracefulDecommissionTimeoutBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Timeout for graceful YARN decommissioning. Graceful
     * decommissioning allows removing nodes from the cluster without
     * interrupting jobs in progress. Timeout specifies how long to wait for jobs
     * in progress to finish before forcefully removing nodes (and potentially
     * interrupting jobs). Default timeout is 0 (for forceful decommission), and
     * the maximum allowed timeout is 1 day. (see JSON representation of
     * [Duration](https://developers.google.com/protocol-buffers/docs/proto3#json)).
     *
     * Only supported on Dataproc image versions 1.2 and higher.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration graceful_decommission_timeout = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeGracefulDecommissionTimeout(com.google.protobuf.Duration value) {
      if (gracefulDecommissionTimeoutBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && gracefulDecommissionTimeout_ != null
            && gracefulDecommissionTimeout_ != com.google.protobuf.Duration.getDefaultInstance()) {
          getGracefulDecommissionTimeoutBuilder().mergeFrom(value);
        } else {
          gracefulDecommissionTimeout_ = value;
        }
      } else {
        gracefulDecommissionTimeoutBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Timeout for graceful YARN decommissioning. Graceful
     * decommissioning allows removing nodes from the cluster without
     * interrupting jobs in progress. Timeout specifies how long to wait for jobs
     * in progress to finish before forcefully removing nodes (and potentially
     * interrupting jobs). Default timeout is 0 (for forceful decommission), and
     * the maximum allowed timeout is 1 day. (see JSON representation of
     * [Duration](https://developers.google.com/protocol-buffers/docs/proto3#json)).
     *
     * Only supported on Dataproc image versions 1.2 and higher.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration graceful_decommission_timeout = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearGracefulDecommissionTimeout() {
      bitField0_ = (bitField0_ & ~0x00000010);
      gracefulDecommissionTimeout_ = null;
      if (gracefulDecommissionTimeoutBuilder_ != null) {
        gracefulDecommissionTimeoutBuilder_.dispose();
        gracefulDecommissionTimeoutBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Timeout for graceful YARN decommissioning. Graceful
     * decommissioning allows removing nodes from the cluster without
     * interrupting jobs in progress. Timeout specifies how long to wait for jobs
     * in progress to finish before forcefully removing nodes (and potentially
     * interrupting jobs). Default timeout is 0 (for forceful decommission), and
     * the maximum allowed timeout is 1 day. (see JSON representation of
     * [Duration](https://developers.google.com/protocol-buffers/docs/proto3#json)).
     *
     * Only supported on Dataproc image versions 1.2 and higher.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration graceful_decommission_timeout = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.Duration.Builder getGracefulDecommissionTimeoutBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getGracefulDecommissionTimeoutFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Timeout for graceful YARN decommissioning. Graceful
     * decommissioning allows removing nodes from the cluster without
     * interrupting jobs in progress. Timeout specifies how long to wait for jobs
     * in progress to finish before forcefully removing nodes (and potentially
     * interrupting jobs). Default timeout is 0 (for forceful decommission), and
     * the maximum allowed timeout is 1 day. (see JSON representation of
     * [Duration](https://developers.google.com/protocol-buffers/docs/proto3#json)).
     *
     * Only supported on Dataproc image versions 1.2 and higher.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration graceful_decommission_timeout = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.DurationOrBuilder getGracefulDecommissionTimeoutOrBuilder() {
      if (gracefulDecommissionTimeoutBuilder_ != null) {
        return gracefulDecommissionTimeoutBuilder_.getMessageOrBuilder();
      } else {
        return gracefulDecommissionTimeout_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : gracefulDecommissionTimeout_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Timeout for graceful YARN decommissioning. Graceful
     * decommissioning allows removing nodes from the cluster without
     * interrupting jobs in progress. Timeout specifies how long to wait for jobs
     * in progress to finish before forcefully removing nodes (and potentially
     * interrupting jobs). Default timeout is 0 (for forceful decommission), and
     * the maximum allowed timeout is 1 day. (see JSON representation of
     * [Duration](https://developers.google.com/protocol-buffers/docs/proto3#json)).
     *
     * Only supported on Dataproc image versions 1.2 and higher.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration graceful_decommission_timeout = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getGracefulDecommissionTimeoutFieldBuilder() {
      if (gracefulDecommissionTimeoutBuilder_ == null) {
        gracefulDecommissionTimeoutBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getGracefulDecommissionTimeout(), getParentForChildren(), isClean());
        gracefulDecommissionTimeout_ = null;
      }
      return gracefulDecommissionTimeoutBuilder_;
    }

    private com.google.protobuf.FieldMask updateMask_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.FieldMask,
            com.google.protobuf.FieldMask.Builder,
            com.google.protobuf.FieldMaskOrBuilder>
        updateMaskBuilder_;
    /**
     *
     *
     * <pre>
     * Required. Specifies the path, relative to `Cluster`, of
     * the field to update. For example, to change the number of workers
     * in a cluster to 5, the `update_mask` parameter would be
     * specified as `config.worker_config.num_instances`,
     * and the `PATCH` request body would specify the new value, as follows:
     *
     *     {
     *       "config":{
     *         "workerConfig":{
     *           "numInstances":"5"
     *         }
     *       }
     *     }
     * Similarly, to change the number of preemptible workers in a cluster to 5,
     * the `update_mask` parameter would be
     * `config.secondary_worker_config.num_instances`, and the `PATCH` request
     * body would be set as follows:
     *
     *     {
     *       "config":{
     *         "secondaryWorkerConfig":{
     *           "numInstances":"5"
     *         }
     *       }
     *     }
     * &lt;strong&gt;Note:&lt;/strong&gt; Currently, only the following fields can be updated:
     *
     *  &lt;table&gt;
     *  &lt;tbody&gt;
     *  &lt;tr&gt;
     *  &lt;td&gt;&lt;strong&gt;Mask&lt;/strong&gt;&lt;/td&gt;
     *  &lt;td&gt;&lt;strong&gt;Purpose&lt;/strong&gt;&lt;/td&gt;
     *  &lt;/tr&gt;
     *  &lt;tr&gt;
     *  &lt;td&gt;&lt;strong&gt;&lt;em&gt;labels&lt;/em&gt;&lt;/strong&gt;&lt;/td&gt;
     *  &lt;td&gt;Update labels&lt;/td&gt;
     *  &lt;/tr&gt;
     *  &lt;tr&gt;
     *  &lt;td&gt;&lt;strong&gt;&lt;em&gt;config.worker_config.num_instances&lt;/em&gt;&lt;/strong&gt;&lt;/td&gt;
     *  &lt;td&gt;Resize primary worker group&lt;/td&gt;
     *  &lt;/tr&gt;
     *  &lt;tr&gt;
     *  &lt;td&gt;&lt;strong&gt;&lt;em&gt;config.secondary_worker_config.num_instances&lt;/em&gt;&lt;/strong&gt;&lt;/td&gt;
     *  &lt;td&gt;Resize secondary worker group&lt;/td&gt;
     *  &lt;/tr&gt;
     *  &lt;tr&gt;
     *  &lt;td&gt;config.autoscaling_config.policy_uri&lt;/td&gt;&lt;td&gt;Use, stop using, or
     *  change autoscaling policies&lt;/td&gt;
     *  &lt;/tr&gt;
     *  &lt;/tbody&gt;
     *  &lt;/table&gt;
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the updateMask field is set.
     */
    public boolean hasUpdateMask() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. Specifies the path, relative to `Cluster`, of
     * the field to update. For example, to change the number of workers
     * in a cluster to 5, the `update_mask` parameter would be
     * specified as `config.worker_config.num_instances`,
     * and the `PATCH` request body would specify the new value, as follows:
     *
     *     {
     *       "config":{
     *         "workerConfig":{
     *           "numInstances":"5"
     *         }
     *       }
     *     }
     * Similarly, to change the number of preemptible workers in a cluster to 5,
     * the `update_mask` parameter would be
     * `config.secondary_worker_config.num_instances`, and the `PATCH` request
     * body would be set as follows:
     *
     *     {
     *       "config":{
     *         "secondaryWorkerConfig":{
     *           "numInstances":"5"
     *         }
     *       }
     *     }
     * &lt;strong&gt;Note:&lt;/strong&gt; Currently, only the following fields can be updated:
     *
     *  &lt;table&gt;
     *  &lt;tbody&gt;
     *  &lt;tr&gt;
     *  &lt;td&gt;&lt;strong&gt;Mask&lt;/strong&gt;&lt;/td&gt;
     *  &lt;td&gt;&lt;strong&gt;Purpose&lt;/strong&gt;&lt;/td&gt;
     *  &lt;/tr&gt;
     *  &lt;tr&gt;
     *  &lt;td&gt;&lt;strong&gt;&lt;em&gt;labels&lt;/em&gt;&lt;/strong&gt;&lt;/td&gt;
     *  &lt;td&gt;Update labels&lt;/td&gt;
     *  &lt;/tr&gt;
     *  &lt;tr&gt;
     *  &lt;td&gt;&lt;strong&gt;&lt;em&gt;config.worker_config.num_instances&lt;/em&gt;&lt;/strong&gt;&lt;/td&gt;
     *  &lt;td&gt;Resize primary worker group&lt;/td&gt;
     *  &lt;/tr&gt;
     *  &lt;tr&gt;
     *  &lt;td&gt;&lt;strong&gt;&lt;em&gt;config.secondary_worker_config.num_instances&lt;/em&gt;&lt;/strong&gt;&lt;/td&gt;
     *  &lt;td&gt;Resize secondary worker group&lt;/td&gt;
     *  &lt;/tr&gt;
     *  &lt;tr&gt;
     *  &lt;td&gt;config.autoscaling_config.policy_uri&lt;/td&gt;&lt;td&gt;Use, stop using, or
     *  change autoscaling policies&lt;/td&gt;
     *  &lt;/tr&gt;
     *  &lt;/tbody&gt;
     *  &lt;/table&gt;
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The updateMask.
     */
    public com.google.protobuf.FieldMask getUpdateMask() {
      if (updateMaskBuilder_ == null) {
        return updateMask_ == null
            ? com.google.protobuf.FieldMask.getDefaultInstance()
            : updateMask_;
      } else {
        return updateMaskBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Specifies the path, relative to `Cluster`, of
     * the field to update. For example, to change the number of workers
     * in a cluster to 5, the `update_mask` parameter would be
     * specified as `config.worker_config.num_instances`,
     * and the `PATCH` request body would specify the new value, as follows:
     *
     *     {
     *       "config":{
     *         "workerConfig":{
     *           "numInstances":"5"
     *         }
     *       }
     *     }
     * Similarly, to change the number of preemptible workers in a cluster to 5,
     * the `update_mask` parameter would be
     * `config.secondary_worker_config.num_instances`, and the `PATCH` request
     * body would be set as follows:
     *
     *     {
     *       "config":{
     *         "secondaryWorkerConfig":{
     *           "numInstances":"5"
     *         }
     *       }
     *     }
     * &lt;strong&gt;Note:&lt;/strong&gt; Currently, only the following fields can be updated:
     *
     *  &lt;table&gt;
     *  &lt;tbody&gt;
     *  &lt;tr&gt;
     *  &lt;td&gt;&lt;strong&gt;Mask&lt;/strong&gt;&lt;/td&gt;
     *  &lt;td&gt;&lt;strong&gt;Purpose&lt;/strong&gt;&lt;/td&gt;
     *  &lt;/tr&gt;
     *  &lt;tr&gt;
     *  &lt;td&gt;&lt;strong&gt;&lt;em&gt;labels&lt;/em&gt;&lt;/strong&gt;&lt;/td&gt;
     *  &lt;td&gt;Update labels&lt;/td&gt;
     *  &lt;/tr&gt;
     *  &lt;tr&gt;
     *  &lt;td&gt;&lt;strong&gt;&lt;em&gt;config.worker_config.num_instances&lt;/em&gt;&lt;/strong&gt;&lt;/td&gt;
     *  &lt;td&gt;Resize primary worker group&lt;/td&gt;
     *  &lt;/tr&gt;
     *  &lt;tr&gt;
     *  &lt;td&gt;&lt;strong&gt;&lt;em&gt;config.secondary_worker_config.num_instances&lt;/em&gt;&lt;/strong&gt;&lt;/td&gt;
     *  &lt;td&gt;Resize secondary worker group&lt;/td&gt;
     *  &lt;/tr&gt;
     *  &lt;tr&gt;
     *  &lt;td&gt;config.autoscaling_config.policy_uri&lt;/td&gt;&lt;td&gt;Use, stop using, or
     *  change autoscaling policies&lt;/td&gt;
     *  &lt;/tr&gt;
     *  &lt;/tbody&gt;
     *  &lt;/table&gt;
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setUpdateMask(com.google.protobuf.FieldMask value) {
      if (updateMaskBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateMask_ = value;
      } else {
        updateMaskBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Specifies the path, relative to `Cluster`, of
     * the field to update. For example, to change the number of workers
     * in a cluster to 5, the `update_mask` parameter would be
     * specified as `config.worker_config.num_instances`,
     * and the `PATCH` request body would specify the new value, as follows:
     *
     *     {
     *       "config":{
     *         "workerConfig":{
     *           "numInstances":"5"
     *         }
     *       }
     *     }
     * Similarly, to change the number of preemptible workers in a cluster to 5,
     * the `update_mask` parameter would be
     * `config.secondary_worker_config.num_instances`, and the `PATCH` request
     * body would be set as follows:
     *
     *     {
     *       "config":{
     *         "secondaryWorkerConfig":{
     *           "numInstances":"5"
     *         }
     *       }
     *     }
     * &lt;strong&gt;Note:&lt;/strong&gt; Currently, only the following fields can be updated:
     *
     *  &lt;table&gt;
     *  &lt;tbody&gt;
     *  &lt;tr&gt;
     *  &lt;td&gt;&lt;strong&gt;Mask&lt;/strong&gt;&lt;/td&gt;
     *  &lt;td&gt;&lt;strong&gt;Purpose&lt;/strong&gt;&lt;/td&gt;
     *  &lt;/tr&gt;
     *  &lt;tr&gt;
     *  &lt;td&gt;&lt;strong&gt;&lt;em&gt;labels&lt;/em&gt;&lt;/strong&gt;&lt;/td&gt;
     *  &lt;td&gt;Update labels&lt;/td&gt;
     *  &lt;/tr&gt;
     *  &lt;tr&gt;
     *  &lt;td&gt;&lt;strong&gt;&lt;em&gt;config.worker_config.num_instances&lt;/em&gt;&lt;/strong&gt;&lt;/td&gt;
     *  &lt;td&gt;Resize primary worker group&lt;/td&gt;
     *  &lt;/tr&gt;
     *  &lt;tr&gt;
     *  &lt;td&gt;&lt;strong&gt;&lt;em&gt;config.secondary_worker_config.num_instances&lt;/em&gt;&lt;/strong&gt;&lt;/td&gt;
     *  &lt;td&gt;Resize secondary worker group&lt;/td&gt;
     *  &lt;/tr&gt;
     *  &lt;tr&gt;
     *  &lt;td&gt;config.autoscaling_config.policy_uri&lt;/td&gt;&lt;td&gt;Use, stop using, or
     *  change autoscaling policies&lt;/td&gt;
     *  &lt;/tr&gt;
     *  &lt;/tbody&gt;
     *  &lt;/table&gt;
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setUpdateMask(com.google.protobuf.FieldMask.Builder builderForValue) {
      if (updateMaskBuilder_ == null) {
        updateMask_ = builderForValue.build();
      } else {
        updateMaskBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Specifies the path, relative to `Cluster`, of
     * the field to update. For example, to change the number of workers
     * in a cluster to 5, the `update_mask` parameter would be
     * specified as `config.worker_config.num_instances`,
     * and the `PATCH` request body would specify the new value, as follows:
     *
     *     {
     *       "config":{
     *         "workerConfig":{
     *           "numInstances":"5"
     *         }
     *       }
     *     }
     * Similarly, to change the number of preemptible workers in a cluster to 5,
     * the `update_mask` parameter would be
     * `config.secondary_worker_config.num_instances`, and the `PATCH` request
     * body would be set as follows:
     *
     *     {
     *       "config":{
     *         "secondaryWorkerConfig":{
     *           "numInstances":"5"
     *         }
     *       }
     *     }
     * &lt;strong&gt;Note:&lt;/strong&gt; Currently, only the following fields can be updated:
     *
     *  &lt;table&gt;
     *  &lt;tbody&gt;
     *  &lt;tr&gt;
     *  &lt;td&gt;&lt;strong&gt;Mask&lt;/strong&gt;&lt;/td&gt;
     *  &lt;td&gt;&lt;strong&gt;Purpose&lt;/strong&gt;&lt;/td&gt;
     *  &lt;/tr&gt;
     *  &lt;tr&gt;
     *  &lt;td&gt;&lt;strong&gt;&lt;em&gt;labels&lt;/em&gt;&lt;/strong&gt;&lt;/td&gt;
     *  &lt;td&gt;Update labels&lt;/td&gt;
     *  &lt;/tr&gt;
     *  &lt;tr&gt;
     *  &lt;td&gt;&lt;strong&gt;&lt;em&gt;config.worker_config.num_instances&lt;/em&gt;&lt;/strong&gt;&lt;/td&gt;
     *  &lt;td&gt;Resize primary worker group&lt;/td&gt;
     *  &lt;/tr&gt;
     *  &lt;tr&gt;
     *  &lt;td&gt;&lt;strong&gt;&lt;em&gt;config.secondary_worker_config.num_instances&lt;/em&gt;&lt;/strong&gt;&lt;/td&gt;
     *  &lt;td&gt;Resize secondary worker group&lt;/td&gt;
     *  &lt;/tr&gt;
     *  &lt;tr&gt;
     *  &lt;td&gt;config.autoscaling_config.policy_uri&lt;/td&gt;&lt;td&gt;Use, stop using, or
     *  change autoscaling policies&lt;/td&gt;
     *  &lt;/tr&gt;
     *  &lt;/tbody&gt;
     *  &lt;/table&gt;
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeUpdateMask(com.google.protobuf.FieldMask value) {
      if (updateMaskBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && updateMask_ != null
            && updateMask_ != com.google.protobuf.FieldMask.getDefaultInstance()) {
          getUpdateMaskBuilder().mergeFrom(value);
        } else {
          updateMask_ = value;
        }
      } else {
        updateMaskBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Specifies the path, relative to `Cluster`, of
     * the field to update. For example, to change the number of workers
     * in a cluster to 5, the `update_mask` parameter would be
     * specified as `config.worker_config.num_instances`,
     * and the `PATCH` request body would specify the new value, as follows:
     *
     *     {
     *       "config":{
     *         "workerConfig":{
     *           "numInstances":"5"
     *         }
     *       }
     *     }
     * Similarly, to change the number of preemptible workers in a cluster to 5,
     * the `update_mask` parameter would be
     * `config.secondary_worker_config.num_instances`, and the `PATCH` request
     * body would be set as follows:
     *
     *     {
     *       "config":{
     *         "secondaryWorkerConfig":{
     *           "numInstances":"5"
     *         }
     *       }
     *     }
     * &lt;strong&gt;Note:&lt;/strong&gt; Currently, only the following fields can be updated:
     *
     *  &lt;table&gt;
     *  &lt;tbody&gt;
     *  &lt;tr&gt;
     *  &lt;td&gt;&lt;strong&gt;Mask&lt;/strong&gt;&lt;/td&gt;
     *  &lt;td&gt;&lt;strong&gt;Purpose&lt;/strong&gt;&lt;/td&gt;
     *  &lt;/tr&gt;
     *  &lt;tr&gt;
     *  &lt;td&gt;&lt;strong&gt;&lt;em&gt;labels&lt;/em&gt;&lt;/strong&gt;&lt;/td&gt;
     *  &lt;td&gt;Update labels&lt;/td&gt;
     *  &lt;/tr&gt;
     *  &lt;tr&gt;
     *  &lt;td&gt;&lt;strong&gt;&lt;em&gt;config.worker_config.num_instances&lt;/em&gt;&lt;/strong&gt;&lt;/td&gt;
     *  &lt;td&gt;Resize primary worker group&lt;/td&gt;
     *  &lt;/tr&gt;
     *  &lt;tr&gt;
     *  &lt;td&gt;&lt;strong&gt;&lt;em&gt;config.secondary_worker_config.num_instances&lt;/em&gt;&lt;/strong&gt;&lt;/td&gt;
     *  &lt;td&gt;Resize secondary worker group&lt;/td&gt;
     *  &lt;/tr&gt;
     *  &lt;tr&gt;
     *  &lt;td&gt;config.autoscaling_config.policy_uri&lt;/td&gt;&lt;td&gt;Use, stop using, or
     *  change autoscaling policies&lt;/td&gt;
     *  &lt;/tr&gt;
     *  &lt;/tbody&gt;
     *  &lt;/table&gt;
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearUpdateMask() {
      bitField0_ = (bitField0_ & ~0x00000020);
      updateMask_ = null;
      if (updateMaskBuilder_ != null) {
        updateMaskBuilder_.dispose();
        updateMaskBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Specifies the path, relative to `Cluster`, of
     * the field to update. For example, to change the number of workers
     * in a cluster to 5, the `update_mask` parameter would be
     * specified as `config.worker_config.num_instances`,
     * and the `PATCH` request body would specify the new value, as follows:
     *
     *     {
     *       "config":{
     *         "workerConfig":{
     *           "numInstances":"5"
     *         }
     *       }
     *     }
     * Similarly, to change the number of preemptible workers in a cluster to 5,
     * the `update_mask` parameter would be
     * `config.secondary_worker_config.num_instances`, and the `PATCH` request
     * body would be set as follows:
     *
     *     {
     *       "config":{
     *         "secondaryWorkerConfig":{
     *           "numInstances":"5"
     *         }
     *       }
     *     }
     * &lt;strong&gt;Note:&lt;/strong&gt; Currently, only the following fields can be updated:
     *
     *  &lt;table&gt;
     *  &lt;tbody&gt;
     *  &lt;tr&gt;
     *  &lt;td&gt;&lt;strong&gt;Mask&lt;/strong&gt;&lt;/td&gt;
     *  &lt;td&gt;&lt;strong&gt;Purpose&lt;/strong&gt;&lt;/td&gt;
     *  &lt;/tr&gt;
     *  &lt;tr&gt;
     *  &lt;td&gt;&lt;strong&gt;&lt;em&gt;labels&lt;/em&gt;&lt;/strong&gt;&lt;/td&gt;
     *  &lt;td&gt;Update labels&lt;/td&gt;
     *  &lt;/tr&gt;
     *  &lt;tr&gt;
     *  &lt;td&gt;&lt;strong&gt;&lt;em&gt;config.worker_config.num_instances&lt;/em&gt;&lt;/strong&gt;&lt;/td&gt;
     *  &lt;td&gt;Resize primary worker group&lt;/td&gt;
     *  &lt;/tr&gt;
     *  &lt;tr&gt;
     *  &lt;td&gt;&lt;strong&gt;&lt;em&gt;config.secondary_worker_config.num_instances&lt;/em&gt;&lt;/strong&gt;&lt;/td&gt;
     *  &lt;td&gt;Resize secondary worker group&lt;/td&gt;
     *  &lt;/tr&gt;
     *  &lt;tr&gt;
     *  &lt;td&gt;config.autoscaling_config.policy_uri&lt;/td&gt;&lt;td&gt;Use, stop using, or
     *  change autoscaling policies&lt;/td&gt;
     *  &lt;/tr&gt;
     *  &lt;/tbody&gt;
     *  &lt;/table&gt;
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.protobuf.FieldMask.Builder getUpdateMaskBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getUpdateMaskFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. Specifies the path, relative to `Cluster`, of
     * the field to update. For example, to change the number of workers
     * in a cluster to 5, the `update_mask` parameter would be
     * specified as `config.worker_config.num_instances`,
     * and the `PATCH` request body would specify the new value, as follows:
     *
     *     {
     *       "config":{
     *         "workerConfig":{
     *           "numInstances":"5"
     *         }
     *       }
     *     }
     * Similarly, to change the number of preemptible workers in a cluster to 5,
     * the `update_mask` parameter would be
     * `config.secondary_worker_config.num_instances`, and the `PATCH` request
     * body would be set as follows:
     *
     *     {
     *       "config":{
     *         "secondaryWorkerConfig":{
     *           "numInstances":"5"
     *         }
     *       }
     *     }
     * &lt;strong&gt;Note:&lt;/strong&gt; Currently, only the following fields can be updated:
     *
     *  &lt;table&gt;
     *  &lt;tbody&gt;
     *  &lt;tr&gt;
     *  &lt;td&gt;&lt;strong&gt;Mask&lt;/strong&gt;&lt;/td&gt;
     *  &lt;td&gt;&lt;strong&gt;Purpose&lt;/strong&gt;&lt;/td&gt;
     *  &lt;/tr&gt;
     *  &lt;tr&gt;
     *  &lt;td&gt;&lt;strong&gt;&lt;em&gt;labels&lt;/em&gt;&lt;/strong&gt;&lt;/td&gt;
     *  &lt;td&gt;Update labels&lt;/td&gt;
     *  &lt;/tr&gt;
     *  &lt;tr&gt;
     *  &lt;td&gt;&lt;strong&gt;&lt;em&gt;config.worker_config.num_instances&lt;/em&gt;&lt;/strong&gt;&lt;/td&gt;
     *  &lt;td&gt;Resize primary worker group&lt;/td&gt;
     *  &lt;/tr&gt;
     *  &lt;tr&gt;
     *  &lt;td&gt;&lt;strong&gt;&lt;em&gt;config.secondary_worker_config.num_instances&lt;/em&gt;&lt;/strong&gt;&lt;/td&gt;
     *  &lt;td&gt;Resize secondary worker group&lt;/td&gt;
     *  &lt;/tr&gt;
     *  &lt;tr&gt;
     *  &lt;td&gt;config.autoscaling_config.policy_uri&lt;/td&gt;&lt;td&gt;Use, stop using, or
     *  change autoscaling policies&lt;/td&gt;
     *  &lt;/tr&gt;
     *  &lt;/tbody&gt;
     *  &lt;/table&gt;
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.protobuf.FieldMaskOrBuilder getUpdateMaskOrBuilder() {
      if (updateMaskBuilder_ != null) {
        return updateMaskBuilder_.getMessageOrBuilder();
      } else {
        return updateMask_ == null
            ? com.google.protobuf.FieldMask.getDefaultInstance()
            : updateMask_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Specifies the path, relative to `Cluster`, of
     * the field to update. For example, to change the number of workers
     * in a cluster to 5, the `update_mask` parameter would be
     * specified as `config.worker_config.num_instances`,
     * and the `PATCH` request body would specify the new value, as follows:
     *
     *     {
     *       "config":{
     *         "workerConfig":{
     *           "numInstances":"5"
     *         }
     *       }
     *     }
     * Similarly, to change the number of preemptible workers in a cluster to 5,
     * the `update_mask` parameter would be
     * `config.secondary_worker_config.num_instances`, and the `PATCH` request
     * body would be set as follows:
     *
     *     {
     *       "config":{
     *         "secondaryWorkerConfig":{
     *           "numInstances":"5"
     *         }
     *       }
     *     }
     * &lt;strong&gt;Note:&lt;/strong&gt; Currently, only the following fields can be updated:
     *
     *  &lt;table&gt;
     *  &lt;tbody&gt;
     *  &lt;tr&gt;
     *  &lt;td&gt;&lt;strong&gt;Mask&lt;/strong&gt;&lt;/td&gt;
     *  &lt;td&gt;&lt;strong&gt;Purpose&lt;/strong&gt;&lt;/td&gt;
     *  &lt;/tr&gt;
     *  &lt;tr&gt;
     *  &lt;td&gt;&lt;strong&gt;&lt;em&gt;labels&lt;/em&gt;&lt;/strong&gt;&lt;/td&gt;
     *  &lt;td&gt;Update labels&lt;/td&gt;
     *  &lt;/tr&gt;
     *  &lt;tr&gt;
     *  &lt;td&gt;&lt;strong&gt;&lt;em&gt;config.worker_config.num_instances&lt;/em&gt;&lt;/strong&gt;&lt;/td&gt;
     *  &lt;td&gt;Resize primary worker group&lt;/td&gt;
     *  &lt;/tr&gt;
     *  &lt;tr&gt;
     *  &lt;td&gt;&lt;strong&gt;&lt;em&gt;config.secondary_worker_config.num_instances&lt;/em&gt;&lt;/strong&gt;&lt;/td&gt;
     *  &lt;td&gt;Resize secondary worker group&lt;/td&gt;
     *  &lt;/tr&gt;
     *  &lt;tr&gt;
     *  &lt;td&gt;config.autoscaling_config.policy_uri&lt;/td&gt;&lt;td&gt;Use, stop using, or
     *  change autoscaling policies&lt;/td&gt;
     *  &lt;/tr&gt;
     *  &lt;/tbody&gt;
     *  &lt;/table&gt;
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.FieldMask,
            com.google.protobuf.FieldMask.Builder,
            com.google.protobuf.FieldMaskOrBuilder>
        getUpdateMaskFieldBuilder() {
      if (updateMaskBuilder_ == null) {
        updateMaskBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.FieldMask,
                com.google.protobuf.FieldMask.Builder,
                com.google.protobuf.FieldMaskOrBuilder>(
                getUpdateMask(), getParentForChildren(), isClean());
        updateMask_ = null;
      }
      return updateMaskBuilder_;
    }

    private java.lang.Object requestId_ = "";
    /**
     *
     *
     * <pre>
     * Optional. A unique ID used to identify the request. If the server
     * receives two
     * [UpdateClusterRequest](https://cloud.google.com/dataproc/docs/reference/rpc/google.cloud.dataproc.v1#google.cloud.dataproc.v1.UpdateClusterRequest)s
     * with the same id, then the second request will be ignored and the
     * first [google.longrunning.Operation][google.longrunning.Operation] created
     * and stored in the backend is returned.
     *
     * It is recommended to always set this value to a
     * [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier).
     *
     * The ID must contain only letters (a-z, A-Z), numbers (0-9),
     * underscores (_), and hyphens (-). The maximum length is 40 characters.
     * </pre>
     *
     * <code>string request_id = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The requestId.
     */
    public java.lang.String getRequestId() {
      java.lang.Object ref = requestId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        requestId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A unique ID used to identify the request. If the server
     * receives two
     * [UpdateClusterRequest](https://cloud.google.com/dataproc/docs/reference/rpc/google.cloud.dataproc.v1#google.cloud.dataproc.v1.UpdateClusterRequest)s
     * with the same id, then the second request will be ignored and the
     * first [google.longrunning.Operation][google.longrunning.Operation] created
     * and stored in the backend is returned.
     *
     * It is recommended to always set this value to a
     * [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier).
     *
     * The ID must contain only letters (a-z, A-Z), numbers (0-9),
     * underscores (_), and hyphens (-). The maximum length is 40 characters.
     * </pre>
     *
     * <code>string request_id = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for requestId.
     */
    public com.google.protobuf.ByteString getRequestIdBytes() {
      java.lang.Object ref = requestId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        requestId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A unique ID used to identify the request. If the server
     * receives two
     * [UpdateClusterRequest](https://cloud.google.com/dataproc/docs/reference/rpc/google.cloud.dataproc.v1#google.cloud.dataproc.v1.UpdateClusterRequest)s
     * with the same id, then the second request will be ignored and the
     * first [google.longrunning.Operation][google.longrunning.Operation] created
     * and stored in the backend is returned.
     *
     * It is recommended to always set this value to a
     * [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier).
     *
     * The ID must contain only letters (a-z, A-Z), numbers (0-9),
     * underscores (_), and hyphens (-). The maximum length is 40 characters.
     * </pre>
     *
     * <code>string request_id = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The requestId to set.
     * @return This builder for chaining.
     */
    public Builder setRequestId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      requestId_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A unique ID used to identify the request. If the server
     * receives two
     * [UpdateClusterRequest](https://cloud.google.com/dataproc/docs/reference/rpc/google.cloud.dataproc.v1#google.cloud.dataproc.v1.UpdateClusterRequest)s
     * with the same id, then the second request will be ignored and the
     * first [google.longrunning.Operation][google.longrunning.Operation] created
     * and stored in the backend is returned.
     *
     * It is recommended to always set this value to a
     * [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier).
     *
     * The ID must contain only letters (a-z, A-Z), numbers (0-9),
     * underscores (_), and hyphens (-). The maximum length is 40 characters.
     * </pre>
     *
     * <code>string request_id = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRequestId() {
      requestId_ = getDefaultInstance().getRequestId();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A unique ID used to identify the request. If the server
     * receives two
     * [UpdateClusterRequest](https://cloud.google.com/dataproc/docs/reference/rpc/google.cloud.dataproc.v1#google.cloud.dataproc.v1.UpdateClusterRequest)s
     * with the same id, then the second request will be ignored and the
     * first [google.longrunning.Operation][google.longrunning.Operation] created
     * and stored in the backend is returned.
     *
     * It is recommended to always set this value to a
     * [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier).
     *
     * The ID must contain only letters (a-z, A-Z), numbers (0-9),
     * underscores (_), and hyphens (-). The maximum length is 40 characters.
     * </pre>
     *
     * <code>string request_id = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for requestId to set.
     * @return This builder for chaining.
     */
    public Builder setRequestIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      requestId_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dataproc.v1.UpdateClusterRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dataproc.v1.UpdateClusterRequest)
  private static final com.google.cloud.dataproc.v1.UpdateClusterRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dataproc.v1.UpdateClusterRequest();
  }

  public static com.google.cloud.dataproc.v1.UpdateClusterRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<UpdateClusterRequest> PARSER =
      new com.google.protobuf.AbstractParser<UpdateClusterRequest>() {
        @java.lang.Override
        public UpdateClusterRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<UpdateClusterRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<UpdateClusterRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dataproc.v1.UpdateClusterRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
