/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dataproc/v1/clusters.proto

package com.google.cloud.dataproc.v1;

/**
 *
 *
 * <pre>
 * The Dataproc cluster config for a cluster that does not directly control the
 * underlying compute resources, such as a [Dataproc-on-GKE
 * cluster](https://cloud.google.com/dataproc/docs/guides/dpgke/dataproc-gke-overview).
 * </pre>
 *
 * Protobuf type {@code google.cloud.dataproc.v1.VirtualClusterConfig}
 */
public final class VirtualClusterConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dataproc.v1.VirtualClusterConfig)
    VirtualClusterConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use VirtualClusterConfig.newBuilder() to construct.
  private VirtualClusterConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private VirtualClusterConfig() {
    stagingBucket_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new VirtualClusterConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dataproc.v1.ClustersProto
        .internal_static_google_cloud_dataproc_v1_VirtualClusterConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dataproc.v1.ClustersProto
        .internal_static_google_cloud_dataproc_v1_VirtualClusterConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dataproc.v1.VirtualClusterConfig.class,
            com.google.cloud.dataproc.v1.VirtualClusterConfig.Builder.class);
  }

  private int infrastructureConfigCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object infrastructureConfig_;

  public enum InfrastructureConfigCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    KUBERNETES_CLUSTER_CONFIG(6),
    INFRASTRUCTURECONFIG_NOT_SET(0);
    private final int value;

    private InfrastructureConfigCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static InfrastructureConfigCase valueOf(int value) {
      return forNumber(value);
    }

    public static InfrastructureConfigCase forNumber(int value) {
      switch (value) {
        case 6:
          return KUBERNETES_CLUSTER_CONFIG;
        case 0:
          return INFRASTRUCTURECONFIG_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public InfrastructureConfigCase getInfrastructureConfigCase() {
    return InfrastructureConfigCase.forNumber(infrastructureConfigCase_);
  }

  public static final int STAGING_BUCKET_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object stagingBucket_ = "";
  /**
   *
   *
   * <pre>
   * Optional. A Cloud Storage bucket used to stage job
   * dependencies, config files, and job driver console output.
   * If you do not specify a staging bucket, Cloud
   * Dataproc will determine a Cloud Storage location (US,
   * ASIA, or EU) for your cluster's staging bucket according to the
   * Compute Engine zone where your cluster is deployed, and then create
   * and manage this project-level, per-location bucket (see
   * [Dataproc staging and temp
   * buckets](https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/staging-bucket)).
   * **This field requires a Cloud Storage bucket name, not a `gs://...` URI to
   * a Cloud Storage bucket.**
   * </pre>
   *
   * <code>string staging_bucket = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The stagingBucket.
   */
  @java.lang.Override
  public java.lang.String getStagingBucket() {
    java.lang.Object ref = stagingBucket_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      stagingBucket_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. A Cloud Storage bucket used to stage job
   * dependencies, config files, and job driver console output.
   * If you do not specify a staging bucket, Cloud
   * Dataproc will determine a Cloud Storage location (US,
   * ASIA, or EU) for your cluster's staging bucket according to the
   * Compute Engine zone where your cluster is deployed, and then create
   * and manage this project-level, per-location bucket (see
   * [Dataproc staging and temp
   * buckets](https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/staging-bucket)).
   * **This field requires a Cloud Storage bucket name, not a `gs://...` URI to
   * a Cloud Storage bucket.**
   * </pre>
   *
   * <code>string staging_bucket = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for stagingBucket.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getStagingBucketBytes() {
    java.lang.Object ref = stagingBucket_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      stagingBucket_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int KUBERNETES_CLUSTER_CONFIG_FIELD_NUMBER = 6;
  /**
   *
   *
   * <pre>
   * Required. The configuration for running the Dataproc cluster on
   * Kubernetes.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.KubernetesClusterConfig kubernetes_cluster_config = 6 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the kubernetesClusterConfig field is set.
   */
  @java.lang.Override
  public boolean hasKubernetesClusterConfig() {
    return infrastructureConfigCase_ == 6;
  }
  /**
   *
   *
   * <pre>
   * Required. The configuration for running the Dataproc cluster on
   * Kubernetes.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.KubernetesClusterConfig kubernetes_cluster_config = 6 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The kubernetesClusterConfig.
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.KubernetesClusterConfig getKubernetesClusterConfig() {
    if (infrastructureConfigCase_ == 6) {
      return (com.google.cloud.dataproc.v1.KubernetesClusterConfig) infrastructureConfig_;
    }
    return com.google.cloud.dataproc.v1.KubernetesClusterConfig.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Required. The configuration for running the Dataproc cluster on
   * Kubernetes.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.KubernetesClusterConfig kubernetes_cluster_config = 6 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.KubernetesClusterConfigOrBuilder
      getKubernetesClusterConfigOrBuilder() {
    if (infrastructureConfigCase_ == 6) {
      return (com.google.cloud.dataproc.v1.KubernetesClusterConfig) infrastructureConfig_;
    }
    return com.google.cloud.dataproc.v1.KubernetesClusterConfig.getDefaultInstance();
  }

  public static final int AUXILIARY_SERVICES_CONFIG_FIELD_NUMBER = 7;
  private com.google.cloud.dataproc.v1.AuxiliaryServicesConfig auxiliaryServicesConfig_;
  /**
   *
   *
   * <pre>
   * Optional. Configuration of auxiliary services used by this cluster.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.AuxiliaryServicesConfig auxiliary_services_config = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the auxiliaryServicesConfig field is set.
   */
  @java.lang.Override
  public boolean hasAuxiliaryServicesConfig() {
    return auxiliaryServicesConfig_ != null;
  }
  /**
   *
   *
   * <pre>
   * Optional. Configuration of auxiliary services used by this cluster.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.AuxiliaryServicesConfig auxiliary_services_config = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The auxiliaryServicesConfig.
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.AuxiliaryServicesConfig getAuxiliaryServicesConfig() {
    return auxiliaryServicesConfig_ == null
        ? com.google.cloud.dataproc.v1.AuxiliaryServicesConfig.getDefaultInstance()
        : auxiliaryServicesConfig_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Configuration of auxiliary services used by this cluster.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.AuxiliaryServicesConfig auxiliary_services_config = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.AuxiliaryServicesConfigOrBuilder
      getAuxiliaryServicesConfigOrBuilder() {
    return auxiliaryServicesConfig_ == null
        ? com.google.cloud.dataproc.v1.AuxiliaryServicesConfig.getDefaultInstance()
        : auxiliaryServicesConfig_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(stagingBucket_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, stagingBucket_);
    }
    if (infrastructureConfigCase_ == 6) {
      output.writeMessage(
          6, (com.google.cloud.dataproc.v1.KubernetesClusterConfig) infrastructureConfig_);
    }
    if (auxiliaryServicesConfig_ != null) {
      output.writeMessage(7, getAuxiliaryServicesConfig());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(stagingBucket_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, stagingBucket_);
    }
    if (infrastructureConfigCase_ == 6) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              6, (com.google.cloud.dataproc.v1.KubernetesClusterConfig) infrastructureConfig_);
    }
    if (auxiliaryServicesConfig_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(7, getAuxiliaryServicesConfig());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dataproc.v1.VirtualClusterConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.dataproc.v1.VirtualClusterConfig other =
        (com.google.cloud.dataproc.v1.VirtualClusterConfig) obj;

    if (!getStagingBucket().equals(other.getStagingBucket())) return false;
    if (hasAuxiliaryServicesConfig() != other.hasAuxiliaryServicesConfig()) return false;
    if (hasAuxiliaryServicesConfig()) {
      if (!getAuxiliaryServicesConfig().equals(other.getAuxiliaryServicesConfig())) return false;
    }
    if (!getInfrastructureConfigCase().equals(other.getInfrastructureConfigCase())) return false;
    switch (infrastructureConfigCase_) {
      case 6:
        if (!getKubernetesClusterConfig().equals(other.getKubernetesClusterConfig())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + STAGING_BUCKET_FIELD_NUMBER;
    hash = (53 * hash) + getStagingBucket().hashCode();
    if (hasAuxiliaryServicesConfig()) {
      hash = (37 * hash) + AUXILIARY_SERVICES_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getAuxiliaryServicesConfig().hashCode();
    }
    switch (infrastructureConfigCase_) {
      case 6:
        hash = (37 * hash) + KUBERNETES_CLUSTER_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getKubernetesClusterConfig().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dataproc.v1.VirtualClusterConfig parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1.VirtualClusterConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.VirtualClusterConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1.VirtualClusterConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.VirtualClusterConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1.VirtualClusterConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.VirtualClusterConfig parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1.VirtualClusterConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.VirtualClusterConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1.VirtualClusterConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.VirtualClusterConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1.VirtualClusterConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.dataproc.v1.VirtualClusterConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The Dataproc cluster config for a cluster that does not directly control the
   * underlying compute resources, such as a [Dataproc-on-GKE
   * cluster](https://cloud.google.com/dataproc/docs/guides/dpgke/dataproc-gke-overview).
   * </pre>
   *
   * Protobuf type {@code google.cloud.dataproc.v1.VirtualClusterConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dataproc.v1.VirtualClusterConfig)
      com.google.cloud.dataproc.v1.VirtualClusterConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dataproc.v1.ClustersProto
          .internal_static_google_cloud_dataproc_v1_VirtualClusterConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dataproc.v1.ClustersProto
          .internal_static_google_cloud_dataproc_v1_VirtualClusterConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dataproc.v1.VirtualClusterConfig.class,
              com.google.cloud.dataproc.v1.VirtualClusterConfig.Builder.class);
    }

    // Construct using com.google.cloud.dataproc.v1.VirtualClusterConfig.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      stagingBucket_ = "";
      if (kubernetesClusterConfigBuilder_ != null) {
        kubernetesClusterConfigBuilder_.clear();
      }
      auxiliaryServicesConfig_ = null;
      if (auxiliaryServicesConfigBuilder_ != null) {
        auxiliaryServicesConfigBuilder_.dispose();
        auxiliaryServicesConfigBuilder_ = null;
      }
      infrastructureConfigCase_ = 0;
      infrastructureConfig_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dataproc.v1.ClustersProto
          .internal_static_google_cloud_dataproc_v1_VirtualClusterConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.VirtualClusterConfig getDefaultInstanceForType() {
      return com.google.cloud.dataproc.v1.VirtualClusterConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.VirtualClusterConfig build() {
      com.google.cloud.dataproc.v1.VirtualClusterConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.VirtualClusterConfig buildPartial() {
      com.google.cloud.dataproc.v1.VirtualClusterConfig result =
          new com.google.cloud.dataproc.v1.VirtualClusterConfig(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.dataproc.v1.VirtualClusterConfig result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.stagingBucket_ = stagingBucket_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.auxiliaryServicesConfig_ =
            auxiliaryServicesConfigBuilder_ == null
                ? auxiliaryServicesConfig_
                : auxiliaryServicesConfigBuilder_.build();
      }
    }

    private void buildPartialOneofs(com.google.cloud.dataproc.v1.VirtualClusterConfig result) {
      result.infrastructureConfigCase_ = infrastructureConfigCase_;
      result.infrastructureConfig_ = this.infrastructureConfig_;
      if (infrastructureConfigCase_ == 6 && kubernetesClusterConfigBuilder_ != null) {
        result.infrastructureConfig_ = kubernetesClusterConfigBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dataproc.v1.VirtualClusterConfig) {
        return mergeFrom((com.google.cloud.dataproc.v1.VirtualClusterConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dataproc.v1.VirtualClusterConfig other) {
      if (other == com.google.cloud.dataproc.v1.VirtualClusterConfig.getDefaultInstance())
        return this;
      if (!other.getStagingBucket().isEmpty()) {
        stagingBucket_ = other.stagingBucket_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasAuxiliaryServicesConfig()) {
        mergeAuxiliaryServicesConfig(other.getAuxiliaryServicesConfig());
      }
      switch (other.getInfrastructureConfigCase()) {
        case KUBERNETES_CLUSTER_CONFIG:
          {
            mergeKubernetesClusterConfig(other.getKubernetesClusterConfig());
            break;
          }
        case INFRASTRUCTURECONFIG_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                stagingBucket_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 50:
              {
                input.readMessage(
                    getKubernetesClusterConfigFieldBuilder().getBuilder(), extensionRegistry);
                infrastructureConfigCase_ = 6;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(
                    getAuxiliaryServicesConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 58
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int infrastructureConfigCase_ = 0;
    private java.lang.Object infrastructureConfig_;

    public InfrastructureConfigCase getInfrastructureConfigCase() {
      return InfrastructureConfigCase.forNumber(infrastructureConfigCase_);
    }

    public Builder clearInfrastructureConfig() {
      infrastructureConfigCase_ = 0;
      infrastructureConfig_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object stagingBucket_ = "";
    /**
     *
     *
     * <pre>
     * Optional. A Cloud Storage bucket used to stage job
     * dependencies, config files, and job driver console output.
     * If you do not specify a staging bucket, Cloud
     * Dataproc will determine a Cloud Storage location (US,
     * ASIA, or EU) for your cluster's staging bucket according to the
     * Compute Engine zone where your cluster is deployed, and then create
     * and manage this project-level, per-location bucket (see
     * [Dataproc staging and temp
     * buckets](https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/staging-bucket)).
     * **This field requires a Cloud Storage bucket name, not a `gs://...` URI to
     * a Cloud Storage bucket.**
     * </pre>
     *
     * <code>string staging_bucket = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The stagingBucket.
     */
    public java.lang.String getStagingBucket() {
      java.lang.Object ref = stagingBucket_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        stagingBucket_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A Cloud Storage bucket used to stage job
     * dependencies, config files, and job driver console output.
     * If you do not specify a staging bucket, Cloud
     * Dataproc will determine a Cloud Storage location (US,
     * ASIA, or EU) for your cluster's staging bucket according to the
     * Compute Engine zone where your cluster is deployed, and then create
     * and manage this project-level, per-location bucket (see
     * [Dataproc staging and temp
     * buckets](https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/staging-bucket)).
     * **This field requires a Cloud Storage bucket name, not a `gs://...` URI to
     * a Cloud Storage bucket.**
     * </pre>
     *
     * <code>string staging_bucket = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for stagingBucket.
     */
    public com.google.protobuf.ByteString getStagingBucketBytes() {
      java.lang.Object ref = stagingBucket_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        stagingBucket_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A Cloud Storage bucket used to stage job
     * dependencies, config files, and job driver console output.
     * If you do not specify a staging bucket, Cloud
     * Dataproc will determine a Cloud Storage location (US,
     * ASIA, or EU) for your cluster's staging bucket according to the
     * Compute Engine zone where your cluster is deployed, and then create
     * and manage this project-level, per-location bucket (see
     * [Dataproc staging and temp
     * buckets](https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/staging-bucket)).
     * **This field requires a Cloud Storage bucket name, not a `gs://...` URI to
     * a Cloud Storage bucket.**
     * </pre>
     *
     * <code>string staging_bucket = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The stagingBucket to set.
     * @return This builder for chaining.
     */
    public Builder setStagingBucket(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      stagingBucket_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A Cloud Storage bucket used to stage job
     * dependencies, config files, and job driver console output.
     * If you do not specify a staging bucket, Cloud
     * Dataproc will determine a Cloud Storage location (US,
     * ASIA, or EU) for your cluster's staging bucket according to the
     * Compute Engine zone where your cluster is deployed, and then create
     * and manage this project-level, per-location bucket (see
     * [Dataproc staging and temp
     * buckets](https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/staging-bucket)).
     * **This field requires a Cloud Storage bucket name, not a `gs://...` URI to
     * a Cloud Storage bucket.**
     * </pre>
     *
     * <code>string staging_bucket = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStagingBucket() {
      stagingBucket_ = getDefaultInstance().getStagingBucket();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A Cloud Storage bucket used to stage job
     * dependencies, config files, and job driver console output.
     * If you do not specify a staging bucket, Cloud
     * Dataproc will determine a Cloud Storage location (US,
     * ASIA, or EU) for your cluster's staging bucket according to the
     * Compute Engine zone where your cluster is deployed, and then create
     * and manage this project-level, per-location bucket (see
     * [Dataproc staging and temp
     * buckets](https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/staging-bucket)).
     * **This field requires a Cloud Storage bucket name, not a `gs://...` URI to
     * a Cloud Storage bucket.**
     * </pre>
     *
     * <code>string staging_bucket = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for stagingBucket to set.
     * @return This builder for chaining.
     */
    public Builder setStagingBucketBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      stagingBucket_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.KubernetesClusterConfig,
            com.google.cloud.dataproc.v1.KubernetesClusterConfig.Builder,
            com.google.cloud.dataproc.v1.KubernetesClusterConfigOrBuilder>
        kubernetesClusterConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Required. The configuration for running the Dataproc cluster on
     * Kubernetes.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.KubernetesClusterConfig kubernetes_cluster_config = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the kubernetesClusterConfig field is set.
     */
    @java.lang.Override
    public boolean hasKubernetesClusterConfig() {
      return infrastructureConfigCase_ == 6;
    }
    /**
     *
     *
     * <pre>
     * Required. The configuration for running the Dataproc cluster on
     * Kubernetes.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.KubernetesClusterConfig kubernetes_cluster_config = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The kubernetesClusterConfig.
     */
    @java.lang.Override
    public com.google.cloud.dataproc.v1.KubernetesClusterConfig getKubernetesClusterConfig() {
      if (kubernetesClusterConfigBuilder_ == null) {
        if (infrastructureConfigCase_ == 6) {
          return (com.google.cloud.dataproc.v1.KubernetesClusterConfig) infrastructureConfig_;
        }
        return com.google.cloud.dataproc.v1.KubernetesClusterConfig.getDefaultInstance();
      } else {
        if (infrastructureConfigCase_ == 6) {
          return kubernetesClusterConfigBuilder_.getMessage();
        }
        return com.google.cloud.dataproc.v1.KubernetesClusterConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The configuration for running the Dataproc cluster on
     * Kubernetes.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.KubernetesClusterConfig kubernetes_cluster_config = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setKubernetesClusterConfig(
        com.google.cloud.dataproc.v1.KubernetesClusterConfig value) {
      if (kubernetesClusterConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        infrastructureConfig_ = value;
        onChanged();
      } else {
        kubernetesClusterConfigBuilder_.setMessage(value);
      }
      infrastructureConfigCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The configuration for running the Dataproc cluster on
     * Kubernetes.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.KubernetesClusterConfig kubernetes_cluster_config = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setKubernetesClusterConfig(
        com.google.cloud.dataproc.v1.KubernetesClusterConfig.Builder builderForValue) {
      if (kubernetesClusterConfigBuilder_ == null) {
        infrastructureConfig_ = builderForValue.build();
        onChanged();
      } else {
        kubernetesClusterConfigBuilder_.setMessage(builderForValue.build());
      }
      infrastructureConfigCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The configuration for running the Dataproc cluster on
     * Kubernetes.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.KubernetesClusterConfig kubernetes_cluster_config = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeKubernetesClusterConfig(
        com.google.cloud.dataproc.v1.KubernetesClusterConfig value) {
      if (kubernetesClusterConfigBuilder_ == null) {
        if (infrastructureConfigCase_ == 6
            && infrastructureConfig_
                != com.google.cloud.dataproc.v1.KubernetesClusterConfig.getDefaultInstance()) {
          infrastructureConfig_ =
              com.google.cloud.dataproc.v1.KubernetesClusterConfig.newBuilder(
                      (com.google.cloud.dataproc.v1.KubernetesClusterConfig) infrastructureConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          infrastructureConfig_ = value;
        }
        onChanged();
      } else {
        if (infrastructureConfigCase_ == 6) {
          kubernetesClusterConfigBuilder_.mergeFrom(value);
        } else {
          kubernetesClusterConfigBuilder_.setMessage(value);
        }
      }
      infrastructureConfigCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The configuration for running the Dataproc cluster on
     * Kubernetes.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.KubernetesClusterConfig kubernetes_cluster_config = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearKubernetesClusterConfig() {
      if (kubernetesClusterConfigBuilder_ == null) {
        if (infrastructureConfigCase_ == 6) {
          infrastructureConfigCase_ = 0;
          infrastructureConfig_ = null;
          onChanged();
        }
      } else {
        if (infrastructureConfigCase_ == 6) {
          infrastructureConfigCase_ = 0;
          infrastructureConfig_ = null;
        }
        kubernetesClusterConfigBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The configuration for running the Dataproc cluster on
     * Kubernetes.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.KubernetesClusterConfig kubernetes_cluster_config = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.dataproc.v1.KubernetesClusterConfig.Builder
        getKubernetesClusterConfigBuilder() {
      return getKubernetesClusterConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. The configuration for running the Dataproc cluster on
     * Kubernetes.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.KubernetesClusterConfig kubernetes_cluster_config = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dataproc.v1.KubernetesClusterConfigOrBuilder
        getKubernetesClusterConfigOrBuilder() {
      if ((infrastructureConfigCase_ == 6) && (kubernetesClusterConfigBuilder_ != null)) {
        return kubernetesClusterConfigBuilder_.getMessageOrBuilder();
      } else {
        if (infrastructureConfigCase_ == 6) {
          return (com.google.cloud.dataproc.v1.KubernetesClusterConfig) infrastructureConfig_;
        }
        return com.google.cloud.dataproc.v1.KubernetesClusterConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The configuration for running the Dataproc cluster on
     * Kubernetes.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.KubernetesClusterConfig kubernetes_cluster_config = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.KubernetesClusterConfig,
            com.google.cloud.dataproc.v1.KubernetesClusterConfig.Builder,
            com.google.cloud.dataproc.v1.KubernetesClusterConfigOrBuilder>
        getKubernetesClusterConfigFieldBuilder() {
      if (kubernetesClusterConfigBuilder_ == null) {
        if (!(infrastructureConfigCase_ == 6)) {
          infrastructureConfig_ =
              com.google.cloud.dataproc.v1.KubernetesClusterConfig.getDefaultInstance();
        }
        kubernetesClusterConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataproc.v1.KubernetesClusterConfig,
                com.google.cloud.dataproc.v1.KubernetesClusterConfig.Builder,
                com.google.cloud.dataproc.v1.KubernetesClusterConfigOrBuilder>(
                (com.google.cloud.dataproc.v1.KubernetesClusterConfig) infrastructureConfig_,
                getParentForChildren(),
                isClean());
        infrastructureConfig_ = null;
      }
      infrastructureConfigCase_ = 6;
      onChanged();
      return kubernetesClusterConfigBuilder_;
    }

    private com.google.cloud.dataproc.v1.AuxiliaryServicesConfig auxiliaryServicesConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.AuxiliaryServicesConfig,
            com.google.cloud.dataproc.v1.AuxiliaryServicesConfig.Builder,
            com.google.cloud.dataproc.v1.AuxiliaryServicesConfigOrBuilder>
        auxiliaryServicesConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Configuration of auxiliary services used by this cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.AuxiliaryServicesConfig auxiliary_services_config = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the auxiliaryServicesConfig field is set.
     */
    public boolean hasAuxiliaryServicesConfig() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Configuration of auxiliary services used by this cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.AuxiliaryServicesConfig auxiliary_services_config = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The auxiliaryServicesConfig.
     */
    public com.google.cloud.dataproc.v1.AuxiliaryServicesConfig getAuxiliaryServicesConfig() {
      if (auxiliaryServicesConfigBuilder_ == null) {
        return auxiliaryServicesConfig_ == null
            ? com.google.cloud.dataproc.v1.AuxiliaryServicesConfig.getDefaultInstance()
            : auxiliaryServicesConfig_;
      } else {
        return auxiliaryServicesConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Configuration of auxiliary services used by this cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.AuxiliaryServicesConfig auxiliary_services_config = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setAuxiliaryServicesConfig(
        com.google.cloud.dataproc.v1.AuxiliaryServicesConfig value) {
      if (auxiliaryServicesConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        auxiliaryServicesConfig_ = value;
      } else {
        auxiliaryServicesConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Configuration of auxiliary services used by this cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.AuxiliaryServicesConfig auxiliary_services_config = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setAuxiliaryServicesConfig(
        com.google.cloud.dataproc.v1.AuxiliaryServicesConfig.Builder builderForValue) {
      if (auxiliaryServicesConfigBuilder_ == null) {
        auxiliaryServicesConfig_ = builderForValue.build();
      } else {
        auxiliaryServicesConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Configuration of auxiliary services used by this cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.AuxiliaryServicesConfig auxiliary_services_config = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeAuxiliaryServicesConfig(
        com.google.cloud.dataproc.v1.AuxiliaryServicesConfig value) {
      if (auxiliaryServicesConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && auxiliaryServicesConfig_ != null
            && auxiliaryServicesConfig_
                != com.google.cloud.dataproc.v1.AuxiliaryServicesConfig.getDefaultInstance()) {
          getAuxiliaryServicesConfigBuilder().mergeFrom(value);
        } else {
          auxiliaryServicesConfig_ = value;
        }
      } else {
        auxiliaryServicesConfigBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Configuration of auxiliary services used by this cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.AuxiliaryServicesConfig auxiliary_services_config = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearAuxiliaryServicesConfig() {
      bitField0_ = (bitField0_ & ~0x00000004);
      auxiliaryServicesConfig_ = null;
      if (auxiliaryServicesConfigBuilder_ != null) {
        auxiliaryServicesConfigBuilder_.dispose();
        auxiliaryServicesConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Configuration of auxiliary services used by this cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.AuxiliaryServicesConfig auxiliary_services_config = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataproc.v1.AuxiliaryServicesConfig.Builder
        getAuxiliaryServicesConfigBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getAuxiliaryServicesConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Configuration of auxiliary services used by this cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.AuxiliaryServicesConfig auxiliary_services_config = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataproc.v1.AuxiliaryServicesConfigOrBuilder
        getAuxiliaryServicesConfigOrBuilder() {
      if (auxiliaryServicesConfigBuilder_ != null) {
        return auxiliaryServicesConfigBuilder_.getMessageOrBuilder();
      } else {
        return auxiliaryServicesConfig_ == null
            ? com.google.cloud.dataproc.v1.AuxiliaryServicesConfig.getDefaultInstance()
            : auxiliaryServicesConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Configuration of auxiliary services used by this cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.AuxiliaryServicesConfig auxiliary_services_config = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.AuxiliaryServicesConfig,
            com.google.cloud.dataproc.v1.AuxiliaryServicesConfig.Builder,
            com.google.cloud.dataproc.v1.AuxiliaryServicesConfigOrBuilder>
        getAuxiliaryServicesConfigFieldBuilder() {
      if (auxiliaryServicesConfigBuilder_ == null) {
        auxiliaryServicesConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataproc.v1.AuxiliaryServicesConfig,
                com.google.cloud.dataproc.v1.AuxiliaryServicesConfig.Builder,
                com.google.cloud.dataproc.v1.AuxiliaryServicesConfigOrBuilder>(
                getAuxiliaryServicesConfig(), getParentForChildren(), isClean());
        auxiliaryServicesConfig_ = null;
      }
      return auxiliaryServicesConfigBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dataproc.v1.VirtualClusterConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dataproc.v1.VirtualClusterConfig)
  private static final com.google.cloud.dataproc.v1.VirtualClusterConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dataproc.v1.VirtualClusterConfig();
  }

  public static com.google.cloud.dataproc.v1.VirtualClusterConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<VirtualClusterConfig> PARSER =
      new com.google.protobuf.AbstractParser<VirtualClusterConfig>() {
        @java.lang.Override
        public VirtualClusterConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<VirtualClusterConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<VirtualClusterConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dataproc.v1.VirtualClusterConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
