/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dataproc/v1/workflow_templates.proto

package com.google.cloud.dataproc.v1;

/**
 *
 *
 * <pre>
 * A Dataproc workflow template resource.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dataproc.v1.WorkflowTemplate}
 */
public final class WorkflowTemplate extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dataproc.v1.WorkflowTemplate)
    WorkflowTemplateOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use WorkflowTemplate.newBuilder() to construct.
  private WorkflowTemplate(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private WorkflowTemplate() {
    id_ = "";
    name_ = "";
    jobs_ = java.util.Collections.emptyList();
    parameters_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new WorkflowTemplate();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dataproc.v1.WorkflowTemplatesProto
        .internal_static_google_cloud_dataproc_v1_WorkflowTemplate_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 6:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dataproc.v1.WorkflowTemplatesProto
        .internal_static_google_cloud_dataproc_v1_WorkflowTemplate_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dataproc.v1.WorkflowTemplate.class,
            com.google.cloud.dataproc.v1.WorkflowTemplate.Builder.class);
  }

  public static final int ID_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object id_ = "";
  /**
   * <code>string id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The id.
   */
  @java.lang.Override
  public java.lang.String getId() {
    java.lang.Object ref = id_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      id_ = s;
      return s;
    }
  }
  /**
   * <code>string id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for id.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getIdBytes() {
    java.lang.Object ref = id_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      id_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The resource name of the workflow template, as described
   * in https://cloud.google.com/apis/design/resource_names.
   *
   * * For `projects.regions.workflowTemplates`, the resource name of the
   *   template has the following format:
   *   `projects/{project_id}/regions/{region}/workflowTemplates/{template_id}`
   *
   * * For `projects.locations.workflowTemplates`, the resource name of the
   *   template has the following format:
   *   `projects/{project_id}/locations/{location}/workflowTemplates/{template_id}`
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The resource name of the workflow template, as described
   * in https://cloud.google.com/apis/design/resource_names.
   *
   * * For `projects.regions.workflowTemplates`, the resource name of the
   *   template has the following format:
   *   `projects/{project_id}/regions/{region}/workflowTemplates/{template_id}`
   *
   * * For `projects.locations.workflowTemplates`, the resource name of the
   *   template has the following format:
   *   `projects/{project_id}/locations/{location}/workflowTemplates/{template_id}`
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int VERSION_FIELD_NUMBER = 3;
  private int version_ = 0;
  /**
   *
   *
   * <pre>
   * Optional. Used to perform a consistent read-modify-write.
   *
   * This field should be left blank for a `CreateWorkflowTemplate` request. It
   * is required for an `UpdateWorkflowTemplate` request, and must match the
   * current server version. A typical update template flow would fetch the
   * current template with a `GetWorkflowTemplate` request, which will return
   * the current template with the `version` field filled in with the
   * current server version. The user updates other fields in the template,
   * then returns it as part of the `UpdateWorkflowTemplate` request.
   * </pre>
   *
   * <code>int32 version = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The version.
   */
  @java.lang.Override
  public int getVersion() {
    return version_;
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 4;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. The time template was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time template was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time template was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 5;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. The time template was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return updateTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time template was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time template was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int LABELS_FIELD_NUMBER = 6;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.dataproc.v1.WorkflowTemplatesProto
                .internal_static_google_cloud_dataproc_v1_WorkflowTemplate_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Optional. The labels to associate with this template. These labels
   * will be propagated to all jobs and clusters created by the workflow
   * instance.
   *
   * Label **keys** must contain 1 to 63 characters, and must conform to
   * [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
   *
   * Label **values** may be empty, but, if present, must contain 1 to 63
   * characters, and must conform to
   * [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
   *
   * No more than 32 labels can be associated with a template.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. The labels to associate with this template. These labels
   * will be propagated to all jobs and clusters created by the workflow
   * instance.
   *
   * Label **keys** must contain 1 to 63 characters, and must conform to
   * [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
   *
   * Label **values** may be empty, but, if present, must contain 1 to 63
   * characters, and must conform to
   * [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
   *
   * No more than 32 labels can be associated with a template.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. The labels to associate with this template. These labels
   * will be propagated to all jobs and clusters created by the workflow
   * instance.
   *
   * Label **keys** must contain 1 to 63 characters, and must conform to
   * [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
   *
   * Label **values** may be empty, but, if present, must contain 1 to 63
   * characters, and must conform to
   * [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
   *
   * No more than 32 labels can be associated with a template.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Optional. The labels to associate with this template. These labels
   * will be propagated to all jobs and clusters created by the workflow
   * instance.
   *
   * Label **keys** must contain 1 to 63 characters, and must conform to
   * [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
   *
   * Label **values** may be empty, but, if present, must contain 1 to 63
   * characters, and must conform to
   * [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
   *
   * No more than 32 labels can be associated with a template.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int PLACEMENT_FIELD_NUMBER = 7;
  private com.google.cloud.dataproc.v1.WorkflowTemplatePlacement placement_;
  /**
   *
   *
   * <pre>
   * Required. WorkflowTemplate scheduling information.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.WorkflowTemplatePlacement placement = 7 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the placement field is set.
   */
  @java.lang.Override
  public boolean hasPlacement() {
    return placement_ != null;
  }
  /**
   *
   *
   * <pre>
   * Required. WorkflowTemplate scheduling information.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.WorkflowTemplatePlacement placement = 7 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The placement.
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.WorkflowTemplatePlacement getPlacement() {
    return placement_ == null
        ? com.google.cloud.dataproc.v1.WorkflowTemplatePlacement.getDefaultInstance()
        : placement_;
  }
  /**
   *
   *
   * <pre>
   * Required. WorkflowTemplate scheduling information.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.WorkflowTemplatePlacement placement = 7 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.WorkflowTemplatePlacementOrBuilder getPlacementOrBuilder() {
    return placement_ == null
        ? com.google.cloud.dataproc.v1.WorkflowTemplatePlacement.getDefaultInstance()
        : placement_;
  }

  public static final int JOBS_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.dataproc.v1.OrderedJob> jobs_;
  /**
   *
   *
   * <pre>
   * Required. The Directed Acyclic Graph of Jobs to submit.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dataproc.v1.OrderedJob jobs = 8 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.dataproc.v1.OrderedJob> getJobsList() {
    return jobs_;
  }
  /**
   *
   *
   * <pre>
   * Required. The Directed Acyclic Graph of Jobs to submit.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dataproc.v1.OrderedJob jobs = 8 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.dataproc.v1.OrderedJobOrBuilder>
      getJobsOrBuilderList() {
    return jobs_;
  }
  /**
   *
   *
   * <pre>
   * Required. The Directed Acyclic Graph of Jobs to submit.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dataproc.v1.OrderedJob jobs = 8 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public int getJobsCount() {
    return jobs_.size();
  }
  /**
   *
   *
   * <pre>
   * Required. The Directed Acyclic Graph of Jobs to submit.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dataproc.v1.OrderedJob jobs = 8 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.OrderedJob getJobs(int index) {
    return jobs_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Required. The Directed Acyclic Graph of Jobs to submit.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dataproc.v1.OrderedJob jobs = 8 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.OrderedJobOrBuilder getJobsOrBuilder(int index) {
    return jobs_.get(index);
  }

  public static final int PARAMETERS_FIELD_NUMBER = 9;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.dataproc.v1.TemplateParameter> parameters_;
  /**
   *
   *
   * <pre>
   * Optional. Template parameters whose values are substituted into the
   * template. Values for parameters must be provided when the template is
   * instantiated.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dataproc.v1.TemplateParameter parameters = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.dataproc.v1.TemplateParameter> getParametersList() {
    return parameters_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Template parameters whose values are substituted into the
   * template. Values for parameters must be provided when the template is
   * instantiated.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dataproc.v1.TemplateParameter parameters = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.dataproc.v1.TemplateParameterOrBuilder>
      getParametersOrBuilderList() {
    return parameters_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Template parameters whose values are substituted into the
   * template. Values for parameters must be provided when the template is
   * instantiated.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dataproc.v1.TemplateParameter parameters = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public int getParametersCount() {
    return parameters_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. Template parameters whose values are substituted into the
   * template. Values for parameters must be provided when the template is
   * instantiated.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dataproc.v1.TemplateParameter parameters = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.TemplateParameter getParameters(int index) {
    return parameters_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. Template parameters whose values are substituted into the
   * template. Values for parameters must be provided when the template is
   * instantiated.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dataproc.v1.TemplateParameter parameters = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.TemplateParameterOrBuilder getParametersOrBuilder(int index) {
    return parameters_.get(index);
  }

  public static final int DAG_TIMEOUT_FIELD_NUMBER = 10;
  private com.google.protobuf.Duration dagTimeout_;
  /**
   *
   *
   * <pre>
   * Optional. Timeout duration for the DAG of jobs, expressed in seconds (see
   * [JSON representation of
   * duration](https://developers.google.com/protocol-buffers/docs/proto3#json)).
   * The timeout duration must be from 10 minutes ("600s") to 24 hours
   * ("86400s"). The timer begins when the first job is submitted. If the
   * workflow is running at the end of the timeout period, any remaining jobs
   * are cancelled, the workflow is ended, and if the workflow was running on a
   * [managed
   * cluster](/dataproc/docs/concepts/workflows/using-workflows#configuring_or_selecting_a_cluster),
   * the cluster is deleted.
   * </pre>
   *
   * <code>.google.protobuf.Duration dag_timeout = 10 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the dagTimeout field is set.
   */
  @java.lang.Override
  public boolean hasDagTimeout() {
    return dagTimeout_ != null;
  }
  /**
   *
   *
   * <pre>
   * Optional. Timeout duration for the DAG of jobs, expressed in seconds (see
   * [JSON representation of
   * duration](https://developers.google.com/protocol-buffers/docs/proto3#json)).
   * The timeout duration must be from 10 minutes ("600s") to 24 hours
   * ("86400s"). The timer begins when the first job is submitted. If the
   * workflow is running at the end of the timeout period, any remaining jobs
   * are cancelled, the workflow is ended, and if the workflow was running on a
   * [managed
   * cluster](/dataproc/docs/concepts/workflows/using-workflows#configuring_or_selecting_a_cluster),
   * the cluster is deleted.
   * </pre>
   *
   * <code>.google.protobuf.Duration dag_timeout = 10 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The dagTimeout.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getDagTimeout() {
    return dagTimeout_ == null ? com.google.protobuf.Duration.getDefaultInstance() : dagTimeout_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Timeout duration for the DAG of jobs, expressed in seconds (see
   * [JSON representation of
   * duration](https://developers.google.com/protocol-buffers/docs/proto3#json)).
   * The timeout duration must be from 10 minutes ("600s") to 24 hours
   * ("86400s"). The timer begins when the first job is submitted. If the
   * workflow is running at the end of the timeout period, any remaining jobs
   * are cancelled, the workflow is ended, and if the workflow was running on a
   * [managed
   * cluster](/dataproc/docs/concepts/workflows/using-workflows#configuring_or_selecting_a_cluster),
   * the cluster is deleted.
   * </pre>
   *
   * <code>.google.protobuf.Duration dag_timeout = 10 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getDagTimeoutOrBuilder() {
    return dagTimeout_ == null ? com.google.protobuf.Duration.getDefaultInstance() : dagTimeout_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(id_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, id_);
    }
    if (version_ != 0) {
      output.writeInt32(3, version_);
    }
    if (createTime_ != null) {
      output.writeMessage(4, getCreateTime());
    }
    if (updateTime_ != null) {
      output.writeMessage(5, getUpdateTime());
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 6);
    if (placement_ != null) {
      output.writeMessage(7, getPlacement());
    }
    for (int i = 0; i < jobs_.size(); i++) {
      output.writeMessage(8, jobs_.get(i));
    }
    for (int i = 0; i < parameters_.size(); i++) {
      output.writeMessage(9, parameters_.get(i));
    }
    if (dagTimeout_ != null) {
      output.writeMessage(10, getDagTimeout());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(id_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, id_);
    }
    if (version_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(3, version_);
    }
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getCreateTime());
    }
    if (updateTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getUpdateTime());
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, labels__);
    }
    if (placement_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getPlacement());
    }
    for (int i = 0; i < jobs_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, jobs_.get(i));
    }
    for (int i = 0; i < parameters_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, parameters_.get(i));
    }
    if (dagTimeout_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, getDagTimeout());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dataproc.v1.WorkflowTemplate)) {
      return super.equals(obj);
    }
    com.google.cloud.dataproc.v1.WorkflowTemplate other =
        (com.google.cloud.dataproc.v1.WorkflowTemplate) obj;

    if (!getId().equals(other.getId())) return false;
    if (!getName().equals(other.getName())) return false;
    if (getVersion() != other.getVersion()) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (hasPlacement() != other.hasPlacement()) return false;
    if (hasPlacement()) {
      if (!getPlacement().equals(other.getPlacement())) return false;
    }
    if (!getJobsList().equals(other.getJobsList())) return false;
    if (!getParametersList().equals(other.getParametersList())) return false;
    if (hasDagTimeout() != other.hasDagTimeout()) return false;
    if (hasDagTimeout()) {
      if (!getDagTimeout().equals(other.getDagTimeout())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + ID_FIELD_NUMBER;
    hash = (53 * hash) + getId().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + VERSION_FIELD_NUMBER;
    hash = (53 * hash) + getVersion();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    if (hasPlacement()) {
      hash = (37 * hash) + PLACEMENT_FIELD_NUMBER;
      hash = (53 * hash) + getPlacement().hashCode();
    }
    if (getJobsCount() > 0) {
      hash = (37 * hash) + JOBS_FIELD_NUMBER;
      hash = (53 * hash) + getJobsList().hashCode();
    }
    if (getParametersCount() > 0) {
      hash = (37 * hash) + PARAMETERS_FIELD_NUMBER;
      hash = (53 * hash) + getParametersList().hashCode();
    }
    if (hasDagTimeout()) {
      hash = (37 * hash) + DAG_TIMEOUT_FIELD_NUMBER;
      hash = (53 * hash) + getDagTimeout().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dataproc.v1.WorkflowTemplate parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1.WorkflowTemplate parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.WorkflowTemplate parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1.WorkflowTemplate parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.WorkflowTemplate parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1.WorkflowTemplate parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.WorkflowTemplate parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1.WorkflowTemplate parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.WorkflowTemplate parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1.WorkflowTemplate parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.WorkflowTemplate parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1.WorkflowTemplate parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.dataproc.v1.WorkflowTemplate prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A Dataproc workflow template resource.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dataproc.v1.WorkflowTemplate}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dataproc.v1.WorkflowTemplate)
      com.google.cloud.dataproc.v1.WorkflowTemplateOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dataproc.v1.WorkflowTemplatesProto
          .internal_static_google_cloud_dataproc_v1_WorkflowTemplate_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 6:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 6:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dataproc.v1.WorkflowTemplatesProto
          .internal_static_google_cloud_dataproc_v1_WorkflowTemplate_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dataproc.v1.WorkflowTemplate.class,
              com.google.cloud.dataproc.v1.WorkflowTemplate.Builder.class);
    }

    // Construct using com.google.cloud.dataproc.v1.WorkflowTemplate.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      id_ = "";
      name_ = "";
      version_ = 0;
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      internalGetMutableLabels().clear();
      placement_ = null;
      if (placementBuilder_ != null) {
        placementBuilder_.dispose();
        placementBuilder_ = null;
      }
      if (jobsBuilder_ == null) {
        jobs_ = java.util.Collections.emptyList();
      } else {
        jobs_ = null;
        jobsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000080);
      if (parametersBuilder_ == null) {
        parameters_ = java.util.Collections.emptyList();
      } else {
        parameters_ = null;
        parametersBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000100);
      dagTimeout_ = null;
      if (dagTimeoutBuilder_ != null) {
        dagTimeoutBuilder_.dispose();
        dagTimeoutBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dataproc.v1.WorkflowTemplatesProto
          .internal_static_google_cloud_dataproc_v1_WorkflowTemplate_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.WorkflowTemplate getDefaultInstanceForType() {
      return com.google.cloud.dataproc.v1.WorkflowTemplate.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.WorkflowTemplate build() {
      com.google.cloud.dataproc.v1.WorkflowTemplate result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.WorkflowTemplate buildPartial() {
      com.google.cloud.dataproc.v1.WorkflowTemplate result =
          new com.google.cloud.dataproc.v1.WorkflowTemplate(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.dataproc.v1.WorkflowTemplate result) {
      if (jobsBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)) {
          jobs_ = java.util.Collections.unmodifiableList(jobs_);
          bitField0_ = (bitField0_ & ~0x00000080);
        }
        result.jobs_ = jobs_;
      } else {
        result.jobs_ = jobsBuilder_.build();
      }
      if (parametersBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)) {
          parameters_ = java.util.Collections.unmodifiableList(parameters_);
          bitField0_ = (bitField0_ & ~0x00000100);
        }
        result.parameters_ = parameters_;
      } else {
        result.parameters_ = parametersBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.dataproc.v1.WorkflowTemplate result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.id_ = id_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.version_ = version_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.labels_ = internalGetLabels();
        result.labels_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.placement_ = placementBuilder_ == null ? placement_ : placementBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.dagTimeout_ = dagTimeoutBuilder_ == null ? dagTimeout_ : dagTimeoutBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dataproc.v1.WorkflowTemplate) {
        return mergeFrom((com.google.cloud.dataproc.v1.WorkflowTemplate) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dataproc.v1.WorkflowTemplate other) {
      if (other == com.google.cloud.dataproc.v1.WorkflowTemplate.getDefaultInstance()) return this;
      if (!other.getId().isEmpty()) {
        id_ = other.id_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.getVersion() != 0) {
        setVersion(other.getVersion());
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      bitField0_ |= 0x00000020;
      if (other.hasPlacement()) {
        mergePlacement(other.getPlacement());
      }
      if (jobsBuilder_ == null) {
        if (!other.jobs_.isEmpty()) {
          if (jobs_.isEmpty()) {
            jobs_ = other.jobs_;
            bitField0_ = (bitField0_ & ~0x00000080);
          } else {
            ensureJobsIsMutable();
            jobs_.addAll(other.jobs_);
          }
          onChanged();
        }
      } else {
        if (!other.jobs_.isEmpty()) {
          if (jobsBuilder_.isEmpty()) {
            jobsBuilder_.dispose();
            jobsBuilder_ = null;
            jobs_ = other.jobs_;
            bitField0_ = (bitField0_ & ~0x00000080);
            jobsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getJobsFieldBuilder()
                    : null;
          } else {
            jobsBuilder_.addAllMessages(other.jobs_);
          }
        }
      }
      if (parametersBuilder_ == null) {
        if (!other.parameters_.isEmpty()) {
          if (parameters_.isEmpty()) {
            parameters_ = other.parameters_;
            bitField0_ = (bitField0_ & ~0x00000100);
          } else {
            ensureParametersIsMutable();
            parameters_.addAll(other.parameters_);
          }
          onChanged();
        }
      } else {
        if (!other.parameters_.isEmpty()) {
          if (parametersBuilder_.isEmpty()) {
            parametersBuilder_.dispose();
            parametersBuilder_ = null;
            parameters_ = other.parameters_;
            bitField0_ = (bitField0_ & ~0x00000100);
            parametersBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getParametersFieldBuilder()
                    : null;
          } else {
            parametersBuilder_.addAllMessages(other.parameters_);
          }
        }
      }
      if (other.hasDagTimeout()) {
        mergeDagTimeout(other.getDagTimeout());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 10
            case 18:
              {
                id_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 18
            case 24:
              {
                version_ = input.readInt32();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 34:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getPlacementFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            case 66:
              {
                com.google.cloud.dataproc.v1.OrderedJob m =
                    input.readMessage(
                        com.google.cloud.dataproc.v1.OrderedJob.parser(), extensionRegistry);
                if (jobsBuilder_ == null) {
                  ensureJobsIsMutable();
                  jobs_.add(m);
                } else {
                  jobsBuilder_.addMessage(m);
                }
                break;
              } // case 66
            case 74:
              {
                com.google.cloud.dataproc.v1.TemplateParameter m =
                    input.readMessage(
                        com.google.cloud.dataproc.v1.TemplateParameter.parser(), extensionRegistry);
                if (parametersBuilder_ == null) {
                  ensureParametersIsMutable();
                  parameters_.add(m);
                } else {
                  parametersBuilder_.addMessage(m);
                }
                break;
              } // case 74
            case 82:
              {
                input.readMessage(getDagTimeoutFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000200;
                break;
              } // case 82
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object id_ = "";
    /**
     * <code>string id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The id.
     */
    public java.lang.String getId() {
      java.lang.Object ref = id_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        id_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <code>string id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for id.
     */
    public com.google.protobuf.ByteString getIdBytes() {
      java.lang.Object ref = id_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        id_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <code>string id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The id to set.
     * @return This builder for chaining.
     */
    public Builder setId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      id_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     * <code>string id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearId() {
      id_ = getDefaultInstance().getId();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     * <code>string id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for id to set.
     * @return This builder for chaining.
     */
    public Builder setIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      id_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the workflow template, as described
     * in https://cloud.google.com/apis/design/resource_names.
     *
     * * For `projects.regions.workflowTemplates`, the resource name of the
     *   template has the following format:
     *   `projects/{project_id}/regions/{region}/workflowTemplates/{template_id}`
     *
     * * For `projects.locations.workflowTemplates`, the resource name of the
     *   template has the following format:
     *   `projects/{project_id}/locations/{location}/workflowTemplates/{template_id}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the workflow template, as described
     * in https://cloud.google.com/apis/design/resource_names.
     *
     * * For `projects.regions.workflowTemplates`, the resource name of the
     *   template has the following format:
     *   `projects/{project_id}/regions/{region}/workflowTemplates/{template_id}`
     *
     * * For `projects.locations.workflowTemplates`, the resource name of the
     *   template has the following format:
     *   `projects/{project_id}/locations/{location}/workflowTemplates/{template_id}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the workflow template, as described
     * in https://cloud.google.com/apis/design/resource_names.
     *
     * * For `projects.regions.workflowTemplates`, the resource name of the
     *   template has the following format:
     *   `projects/{project_id}/regions/{region}/workflowTemplates/{template_id}`
     *
     * * For `projects.locations.workflowTemplates`, the resource name of the
     *   template has the following format:
     *   `projects/{project_id}/locations/{location}/workflowTemplates/{template_id}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the workflow template, as described
     * in https://cloud.google.com/apis/design/resource_names.
     *
     * * For `projects.regions.workflowTemplates`, the resource name of the
     *   template has the following format:
     *   `projects/{project_id}/regions/{region}/workflowTemplates/{template_id}`
     *
     * * For `projects.locations.workflowTemplates`, the resource name of the
     *   template has the following format:
     *   `projects/{project_id}/locations/{location}/workflowTemplates/{template_id}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the workflow template, as described
     * in https://cloud.google.com/apis/design/resource_names.
     *
     * * For `projects.regions.workflowTemplates`, the resource name of the
     *   template has the following format:
     *   `projects/{project_id}/regions/{region}/workflowTemplates/{template_id}`
     *
     * * For `projects.locations.workflowTemplates`, the resource name of the
     *   template has the following format:
     *   `projects/{project_id}/locations/{location}/workflowTemplates/{template_id}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private int version_;
    /**
     *
     *
     * <pre>
     * Optional. Used to perform a consistent read-modify-write.
     *
     * This field should be left blank for a `CreateWorkflowTemplate` request. It
     * is required for an `UpdateWorkflowTemplate` request, and must match the
     * current server version. A typical update template flow would fetch the
     * current template with a `GetWorkflowTemplate` request, which will return
     * the current template with the `version` field filled in with the
     * current server version. The user updates other fields in the template,
     * then returns it as part of the `UpdateWorkflowTemplate` request.
     * </pre>
     *
     * <code>int32 version = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The version.
     */
    @java.lang.Override
    public int getVersion() {
      return version_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Used to perform a consistent read-modify-write.
     *
     * This field should be left blank for a `CreateWorkflowTemplate` request. It
     * is required for an `UpdateWorkflowTemplate` request, and must match the
     * current server version. A typical update template flow would fetch the
     * current template with a `GetWorkflowTemplate` request, which will return
     * the current template with the `version` field filled in with the
     * current server version. The user updates other fields in the template,
     * then returns it as part of the `UpdateWorkflowTemplate` request.
     * </pre>
     *
     * <code>int32 version = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The version to set.
     * @return This builder for chaining.
     */
    public Builder setVersion(int value) {

      version_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Used to perform a consistent read-modify-write.
     *
     * This field should be left blank for a `CreateWorkflowTemplate` request. It
     * is required for an `UpdateWorkflowTemplate` request, and must match the
     * current server version. A typical update template flow would fetch the
     * current template with a `GetWorkflowTemplate` request, which will return
     * the current template with the `version` field filled in with the
     * current server version. The user updates other fields in the template,
     * then returns it as part of the `UpdateWorkflowTemplate` request.
     * </pre>
     *
     * <code>int32 version = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearVersion() {
      bitField0_ = (bitField0_ & ~0x00000004);
      version_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The time template was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The time template was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time template was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time template was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time template was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time template was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000008);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time template was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The time template was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time template was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The time template was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The time template was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time template was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time template was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time template was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time template was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000010);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time template was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The time template was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time template was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Optional. The labels to associate with this template. These labels
     * will be propagated to all jobs and clusters created by the workflow
     * instance.
     *
     * Label **keys** must contain 1 to 63 characters, and must conform to
     * [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
     *
     * Label **values** may be empty, but, if present, must contain 1 to 63
     * characters, and must conform to
     * [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
     *
     * No more than 32 labels can be associated with a template.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. The labels to associate with this template. These labels
     * will be propagated to all jobs and clusters created by the workflow
     * instance.
     *
     * Label **keys** must contain 1 to 63 characters, and must conform to
     * [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
     *
     * Label **values** may be empty, but, if present, must contain 1 to 63
     * characters, and must conform to
     * [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
     *
     * No more than 32 labels can be associated with a template.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. The labels to associate with this template. These labels
     * will be propagated to all jobs and clusters created by the workflow
     * instance.
     *
     * Label **keys** must contain 1 to 63 characters, and must conform to
     * [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
     *
     * Label **values** may be empty, but, if present, must contain 1 to 63
     * characters, and must conform to
     * [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
     *
     * No more than 32 labels can be associated with a template.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Optional. The labels to associate with this template. These labels
     * will be propagated to all jobs and clusters created by the workflow
     * instance.
     *
     * Label **keys** must contain 1 to 63 characters, and must conform to
     * [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
     *
     * Label **values** may be empty, but, if present, must contain 1 to 63
     * characters, and must conform to
     * [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
     *
     * No more than 32 labels can be associated with a template.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      bitField0_ = (bitField0_ & ~0x00000020);
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The labels to associate with this template. These labels
     * will be propagated to all jobs and clusters created by the workflow
     * instance.
     *
     * Label **keys** must contain 1 to 63 characters, and must conform to
     * [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
     *
     * Label **values** may be empty, but, if present, must contain 1 to 63
     * characters, and must conform to
     * [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
     *
     * No more than 32 labels can be associated with a template.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      bitField0_ |= 0x00000020;
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. The labels to associate with this template. These labels
     * will be propagated to all jobs and clusters created by the workflow
     * instance.
     *
     * Label **keys** must contain 1 to 63 characters, and must conform to
     * [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
     *
     * Label **values** may be empty, but, if present, must contain 1 to 63
     * characters, and must conform to
     * [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
     *
     * No more than 32 labels can be associated with a template.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00000020;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The labels to associate with this template. These labels
     * will be propagated to all jobs and clusters created by the workflow
     * instance.
     *
     * Label **keys** must contain 1 to 63 characters, and must conform to
     * [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
     *
     * Label **values** may be empty, but, if present, must contain 1 to 63
     * characters, and must conform to
     * [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
     *
     * No more than 32 labels can be associated with a template.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00000020;
      return this;
    }

    private com.google.cloud.dataproc.v1.WorkflowTemplatePlacement placement_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.WorkflowTemplatePlacement,
            com.google.cloud.dataproc.v1.WorkflowTemplatePlacement.Builder,
            com.google.cloud.dataproc.v1.WorkflowTemplatePlacementOrBuilder>
        placementBuilder_;
    /**
     *
     *
     * <pre>
     * Required. WorkflowTemplate scheduling information.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.WorkflowTemplatePlacement placement = 7 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the placement field is set.
     */
    public boolean hasPlacement() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. WorkflowTemplate scheduling information.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.WorkflowTemplatePlacement placement = 7 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The placement.
     */
    public com.google.cloud.dataproc.v1.WorkflowTemplatePlacement getPlacement() {
      if (placementBuilder_ == null) {
        return placement_ == null
            ? com.google.cloud.dataproc.v1.WorkflowTemplatePlacement.getDefaultInstance()
            : placement_;
      } else {
        return placementBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. WorkflowTemplate scheduling information.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.WorkflowTemplatePlacement placement = 7 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setPlacement(com.google.cloud.dataproc.v1.WorkflowTemplatePlacement value) {
      if (placementBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        placement_ = value;
      } else {
        placementBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. WorkflowTemplate scheduling information.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.WorkflowTemplatePlacement placement = 7 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setPlacement(
        com.google.cloud.dataproc.v1.WorkflowTemplatePlacement.Builder builderForValue) {
      if (placementBuilder_ == null) {
        placement_ = builderForValue.build();
      } else {
        placementBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. WorkflowTemplate scheduling information.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.WorkflowTemplatePlacement placement = 7 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergePlacement(com.google.cloud.dataproc.v1.WorkflowTemplatePlacement value) {
      if (placementBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && placement_ != null
            && placement_
                != com.google.cloud.dataproc.v1.WorkflowTemplatePlacement.getDefaultInstance()) {
          getPlacementBuilder().mergeFrom(value);
        } else {
          placement_ = value;
        }
      } else {
        placementBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. WorkflowTemplate scheduling information.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.WorkflowTemplatePlacement placement = 7 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearPlacement() {
      bitField0_ = (bitField0_ & ~0x00000040);
      placement_ = null;
      if (placementBuilder_ != null) {
        placementBuilder_.dispose();
        placementBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. WorkflowTemplate scheduling information.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.WorkflowTemplatePlacement placement = 7 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.dataproc.v1.WorkflowTemplatePlacement.Builder getPlacementBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getPlacementFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. WorkflowTemplate scheduling information.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.WorkflowTemplatePlacement placement = 7 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.dataproc.v1.WorkflowTemplatePlacementOrBuilder getPlacementOrBuilder() {
      if (placementBuilder_ != null) {
        return placementBuilder_.getMessageOrBuilder();
      } else {
        return placement_ == null
            ? com.google.cloud.dataproc.v1.WorkflowTemplatePlacement.getDefaultInstance()
            : placement_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. WorkflowTemplate scheduling information.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.WorkflowTemplatePlacement placement = 7 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.WorkflowTemplatePlacement,
            com.google.cloud.dataproc.v1.WorkflowTemplatePlacement.Builder,
            com.google.cloud.dataproc.v1.WorkflowTemplatePlacementOrBuilder>
        getPlacementFieldBuilder() {
      if (placementBuilder_ == null) {
        placementBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataproc.v1.WorkflowTemplatePlacement,
                com.google.cloud.dataproc.v1.WorkflowTemplatePlacement.Builder,
                com.google.cloud.dataproc.v1.WorkflowTemplatePlacementOrBuilder>(
                getPlacement(), getParentForChildren(), isClean());
        placement_ = null;
      }
      return placementBuilder_;
    }

    private java.util.List<com.google.cloud.dataproc.v1.OrderedJob> jobs_ =
        java.util.Collections.emptyList();

    private void ensureJobsIsMutable() {
      if (!((bitField0_ & 0x00000080) != 0)) {
        jobs_ = new java.util.ArrayList<com.google.cloud.dataproc.v1.OrderedJob>(jobs_);
        bitField0_ |= 0x00000080;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dataproc.v1.OrderedJob,
            com.google.cloud.dataproc.v1.OrderedJob.Builder,
            com.google.cloud.dataproc.v1.OrderedJobOrBuilder>
        jobsBuilder_;

    /**
     *
     *
     * <pre>
     * Required. The Directed Acyclic Graph of Jobs to submit.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.OrderedJob jobs = 8 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<com.google.cloud.dataproc.v1.OrderedJob> getJobsList() {
      if (jobsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(jobs_);
      } else {
        return jobsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The Directed Acyclic Graph of Jobs to submit.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.OrderedJob jobs = 8 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public int getJobsCount() {
      if (jobsBuilder_ == null) {
        return jobs_.size();
      } else {
        return jobsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The Directed Acyclic Graph of Jobs to submit.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.OrderedJob jobs = 8 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.dataproc.v1.OrderedJob getJobs(int index) {
      if (jobsBuilder_ == null) {
        return jobs_.get(index);
      } else {
        return jobsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The Directed Acyclic Graph of Jobs to submit.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.OrderedJob jobs = 8 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setJobs(int index, com.google.cloud.dataproc.v1.OrderedJob value) {
      if (jobsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureJobsIsMutable();
        jobs_.set(index, value);
        onChanged();
      } else {
        jobsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The Directed Acyclic Graph of Jobs to submit.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.OrderedJob jobs = 8 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setJobs(
        int index, com.google.cloud.dataproc.v1.OrderedJob.Builder builderForValue) {
      if (jobsBuilder_ == null) {
        ensureJobsIsMutable();
        jobs_.set(index, builderForValue.build());
        onChanged();
      } else {
        jobsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The Directed Acyclic Graph of Jobs to submit.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.OrderedJob jobs = 8 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addJobs(com.google.cloud.dataproc.v1.OrderedJob value) {
      if (jobsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureJobsIsMutable();
        jobs_.add(value);
        onChanged();
      } else {
        jobsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The Directed Acyclic Graph of Jobs to submit.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.OrderedJob jobs = 8 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addJobs(int index, com.google.cloud.dataproc.v1.OrderedJob value) {
      if (jobsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureJobsIsMutable();
        jobs_.add(index, value);
        onChanged();
      } else {
        jobsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The Directed Acyclic Graph of Jobs to submit.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.OrderedJob jobs = 8 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addJobs(com.google.cloud.dataproc.v1.OrderedJob.Builder builderForValue) {
      if (jobsBuilder_ == null) {
        ensureJobsIsMutable();
        jobs_.add(builderForValue.build());
        onChanged();
      } else {
        jobsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The Directed Acyclic Graph of Jobs to submit.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.OrderedJob jobs = 8 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addJobs(
        int index, com.google.cloud.dataproc.v1.OrderedJob.Builder builderForValue) {
      if (jobsBuilder_ == null) {
        ensureJobsIsMutable();
        jobs_.add(index, builderForValue.build());
        onChanged();
      } else {
        jobsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The Directed Acyclic Graph of Jobs to submit.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.OrderedJob jobs = 8 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addAllJobs(
        java.lang.Iterable<? extends com.google.cloud.dataproc.v1.OrderedJob> values) {
      if (jobsBuilder_ == null) {
        ensureJobsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, jobs_);
        onChanged();
      } else {
        jobsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The Directed Acyclic Graph of Jobs to submit.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.OrderedJob jobs = 8 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearJobs() {
      if (jobsBuilder_ == null) {
        jobs_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000080);
        onChanged();
      } else {
        jobsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The Directed Acyclic Graph of Jobs to submit.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.OrderedJob jobs = 8 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder removeJobs(int index) {
      if (jobsBuilder_ == null) {
        ensureJobsIsMutable();
        jobs_.remove(index);
        onChanged();
      } else {
        jobsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The Directed Acyclic Graph of Jobs to submit.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.OrderedJob jobs = 8 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.dataproc.v1.OrderedJob.Builder getJobsBuilder(int index) {
      return getJobsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Required. The Directed Acyclic Graph of Jobs to submit.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.OrderedJob jobs = 8 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.dataproc.v1.OrderedJobOrBuilder getJobsOrBuilder(int index) {
      if (jobsBuilder_ == null) {
        return jobs_.get(index);
      } else {
        return jobsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The Directed Acyclic Graph of Jobs to submit.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.OrderedJob jobs = 8 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.dataproc.v1.OrderedJobOrBuilder>
        getJobsOrBuilderList() {
      if (jobsBuilder_ != null) {
        return jobsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(jobs_);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The Directed Acyclic Graph of Jobs to submit.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.OrderedJob jobs = 8 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.dataproc.v1.OrderedJob.Builder addJobsBuilder() {
      return getJobsFieldBuilder()
          .addBuilder(com.google.cloud.dataproc.v1.OrderedJob.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Required. The Directed Acyclic Graph of Jobs to submit.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.OrderedJob jobs = 8 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.dataproc.v1.OrderedJob.Builder addJobsBuilder(int index) {
      return getJobsFieldBuilder()
          .addBuilder(index, com.google.cloud.dataproc.v1.OrderedJob.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Required. The Directed Acyclic Graph of Jobs to submit.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.OrderedJob jobs = 8 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<com.google.cloud.dataproc.v1.OrderedJob.Builder> getJobsBuilderList() {
      return getJobsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dataproc.v1.OrderedJob,
            com.google.cloud.dataproc.v1.OrderedJob.Builder,
            com.google.cloud.dataproc.v1.OrderedJobOrBuilder>
        getJobsFieldBuilder() {
      if (jobsBuilder_ == null) {
        jobsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.dataproc.v1.OrderedJob,
                com.google.cloud.dataproc.v1.OrderedJob.Builder,
                com.google.cloud.dataproc.v1.OrderedJobOrBuilder>(
                jobs_, ((bitField0_ & 0x00000080) != 0), getParentForChildren(), isClean());
        jobs_ = null;
      }
      return jobsBuilder_;
    }

    private java.util.List<com.google.cloud.dataproc.v1.TemplateParameter> parameters_ =
        java.util.Collections.emptyList();

    private void ensureParametersIsMutable() {
      if (!((bitField0_ & 0x00000100) != 0)) {
        parameters_ =
            new java.util.ArrayList<com.google.cloud.dataproc.v1.TemplateParameter>(parameters_);
        bitField0_ |= 0x00000100;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dataproc.v1.TemplateParameter,
            com.google.cloud.dataproc.v1.TemplateParameter.Builder,
            com.google.cloud.dataproc.v1.TemplateParameterOrBuilder>
        parametersBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Template parameters whose values are substituted into the
     * template. Values for parameters must be provided when the template is
     * instantiated.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.TemplateParameter parameters = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.dataproc.v1.TemplateParameter> getParametersList() {
      if (parametersBuilder_ == null) {
        return java.util.Collections.unmodifiableList(parameters_);
      } else {
        return parametersBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Template parameters whose values are substituted into the
     * template. Values for parameters must be provided when the template is
     * instantiated.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.TemplateParameter parameters = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public int getParametersCount() {
      if (parametersBuilder_ == null) {
        return parameters_.size();
      } else {
        return parametersBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Template parameters whose values are substituted into the
     * template. Values for parameters must be provided when the template is
     * instantiated.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.TemplateParameter parameters = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataproc.v1.TemplateParameter getParameters(int index) {
      if (parametersBuilder_ == null) {
        return parameters_.get(index);
      } else {
        return parametersBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Template parameters whose values are substituted into the
     * template. Values for parameters must be provided when the template is
     * instantiated.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.TemplateParameter parameters = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setParameters(int index, com.google.cloud.dataproc.v1.TemplateParameter value) {
      if (parametersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureParametersIsMutable();
        parameters_.set(index, value);
        onChanged();
      } else {
        parametersBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Template parameters whose values are substituted into the
     * template. Values for parameters must be provided when the template is
     * instantiated.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.TemplateParameter parameters = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setParameters(
        int index, com.google.cloud.dataproc.v1.TemplateParameter.Builder builderForValue) {
      if (parametersBuilder_ == null) {
        ensureParametersIsMutable();
        parameters_.set(index, builderForValue.build());
        onChanged();
      } else {
        parametersBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Template parameters whose values are substituted into the
     * template. Values for parameters must be provided when the template is
     * instantiated.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.TemplateParameter parameters = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addParameters(com.google.cloud.dataproc.v1.TemplateParameter value) {
      if (parametersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureParametersIsMutable();
        parameters_.add(value);
        onChanged();
      } else {
        parametersBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Template parameters whose values are substituted into the
     * template. Values for parameters must be provided when the template is
     * instantiated.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.TemplateParameter parameters = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addParameters(int index, com.google.cloud.dataproc.v1.TemplateParameter value) {
      if (parametersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureParametersIsMutable();
        parameters_.add(index, value);
        onChanged();
      } else {
        parametersBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Template parameters whose values are substituted into the
     * template. Values for parameters must be provided when the template is
     * instantiated.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.TemplateParameter parameters = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addParameters(
        com.google.cloud.dataproc.v1.TemplateParameter.Builder builderForValue) {
      if (parametersBuilder_ == null) {
        ensureParametersIsMutable();
        parameters_.add(builderForValue.build());
        onChanged();
      } else {
        parametersBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Template parameters whose values are substituted into the
     * template. Values for parameters must be provided when the template is
     * instantiated.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.TemplateParameter parameters = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addParameters(
        int index, com.google.cloud.dataproc.v1.TemplateParameter.Builder builderForValue) {
      if (parametersBuilder_ == null) {
        ensureParametersIsMutable();
        parameters_.add(index, builderForValue.build());
        onChanged();
      } else {
        parametersBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Template parameters whose values are substituted into the
     * template. Values for parameters must be provided when the template is
     * instantiated.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.TemplateParameter parameters = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAllParameters(
        java.lang.Iterable<? extends com.google.cloud.dataproc.v1.TemplateParameter> values) {
      if (parametersBuilder_ == null) {
        ensureParametersIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, parameters_);
        onChanged();
      } else {
        parametersBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Template parameters whose values are substituted into the
     * template. Values for parameters must be provided when the template is
     * instantiated.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.TemplateParameter parameters = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearParameters() {
      if (parametersBuilder_ == null) {
        parameters_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000100);
        onChanged();
      } else {
        parametersBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Template parameters whose values are substituted into the
     * template. Values for parameters must be provided when the template is
     * instantiated.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.TemplateParameter parameters = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeParameters(int index) {
      if (parametersBuilder_ == null) {
        ensureParametersIsMutable();
        parameters_.remove(index);
        onChanged();
      } else {
        parametersBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Template parameters whose values are substituted into the
     * template. Values for parameters must be provided when the template is
     * instantiated.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.TemplateParameter parameters = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataproc.v1.TemplateParameter.Builder getParametersBuilder(int index) {
      return getParametersFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. Template parameters whose values are substituted into the
     * template. Values for parameters must be provided when the template is
     * instantiated.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.TemplateParameter parameters = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataproc.v1.TemplateParameterOrBuilder getParametersOrBuilder(
        int index) {
      if (parametersBuilder_ == null) {
        return parameters_.get(index);
      } else {
        return parametersBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Template parameters whose values are substituted into the
     * template. Values for parameters must be provided when the template is
     * instantiated.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.TemplateParameter parameters = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.dataproc.v1.TemplateParameterOrBuilder>
        getParametersOrBuilderList() {
      if (parametersBuilder_ != null) {
        return parametersBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(parameters_);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Template parameters whose values are substituted into the
     * template. Values for parameters must be provided when the template is
     * instantiated.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.TemplateParameter parameters = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataproc.v1.TemplateParameter.Builder addParametersBuilder() {
      return getParametersFieldBuilder()
          .addBuilder(com.google.cloud.dataproc.v1.TemplateParameter.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. Template parameters whose values are substituted into the
     * template. Values for parameters must be provided when the template is
     * instantiated.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.TemplateParameter parameters = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataproc.v1.TemplateParameter.Builder addParametersBuilder(int index) {
      return getParametersFieldBuilder()
          .addBuilder(index, com.google.cloud.dataproc.v1.TemplateParameter.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. Template parameters whose values are substituted into the
     * template. Values for parameters must be provided when the template is
     * instantiated.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.TemplateParameter parameters = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.dataproc.v1.TemplateParameter.Builder>
        getParametersBuilderList() {
      return getParametersFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dataproc.v1.TemplateParameter,
            com.google.cloud.dataproc.v1.TemplateParameter.Builder,
            com.google.cloud.dataproc.v1.TemplateParameterOrBuilder>
        getParametersFieldBuilder() {
      if (parametersBuilder_ == null) {
        parametersBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.dataproc.v1.TemplateParameter,
                com.google.cloud.dataproc.v1.TemplateParameter.Builder,
                com.google.cloud.dataproc.v1.TemplateParameterOrBuilder>(
                parameters_, ((bitField0_ & 0x00000100) != 0), getParentForChildren(), isClean());
        parameters_ = null;
      }
      return parametersBuilder_;
    }

    private com.google.protobuf.Duration dagTimeout_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        dagTimeoutBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Timeout duration for the DAG of jobs, expressed in seconds (see
     * [JSON representation of
     * duration](https://developers.google.com/protocol-buffers/docs/proto3#json)).
     * The timeout duration must be from 10 minutes ("600s") to 24 hours
     * ("86400s"). The timer begins when the first job is submitted. If the
     * workflow is running at the end of the timeout period, any remaining jobs
     * are cancelled, the workflow is ended, and if the workflow was running on a
     * [managed
     * cluster](/dataproc/docs/concepts/workflows/using-workflows#configuring_or_selecting_a_cluster),
     * the cluster is deleted.
     * </pre>
     *
     * <code>.google.protobuf.Duration dag_timeout = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the dagTimeout field is set.
     */
    public boolean hasDagTimeout() {
      return ((bitField0_ & 0x00000200) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Timeout duration for the DAG of jobs, expressed in seconds (see
     * [JSON representation of
     * duration](https://developers.google.com/protocol-buffers/docs/proto3#json)).
     * The timeout duration must be from 10 minutes ("600s") to 24 hours
     * ("86400s"). The timer begins when the first job is submitted. If the
     * workflow is running at the end of the timeout period, any remaining jobs
     * are cancelled, the workflow is ended, and if the workflow was running on a
     * [managed
     * cluster](/dataproc/docs/concepts/workflows/using-workflows#configuring_or_selecting_a_cluster),
     * the cluster is deleted.
     * </pre>
     *
     * <code>.google.protobuf.Duration dag_timeout = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The dagTimeout.
     */
    public com.google.protobuf.Duration getDagTimeout() {
      if (dagTimeoutBuilder_ == null) {
        return dagTimeout_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : dagTimeout_;
      } else {
        return dagTimeoutBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Timeout duration for the DAG of jobs, expressed in seconds (see
     * [JSON representation of
     * duration](https://developers.google.com/protocol-buffers/docs/proto3#json)).
     * The timeout duration must be from 10 minutes ("600s") to 24 hours
     * ("86400s"). The timer begins when the first job is submitted. If the
     * workflow is running at the end of the timeout period, any remaining jobs
     * are cancelled, the workflow is ended, and if the workflow was running on a
     * [managed
     * cluster](/dataproc/docs/concepts/workflows/using-workflows#configuring_or_selecting_a_cluster),
     * the cluster is deleted.
     * </pre>
     *
     * <code>.google.protobuf.Duration dag_timeout = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setDagTimeout(com.google.protobuf.Duration value) {
      if (dagTimeoutBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        dagTimeout_ = value;
      } else {
        dagTimeoutBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Timeout duration for the DAG of jobs, expressed in seconds (see
     * [JSON representation of
     * duration](https://developers.google.com/protocol-buffers/docs/proto3#json)).
     * The timeout duration must be from 10 minutes ("600s") to 24 hours
     * ("86400s"). The timer begins when the first job is submitted. If the
     * workflow is running at the end of the timeout period, any remaining jobs
     * are cancelled, the workflow is ended, and if the workflow was running on a
     * [managed
     * cluster](/dataproc/docs/concepts/workflows/using-workflows#configuring_or_selecting_a_cluster),
     * the cluster is deleted.
     * </pre>
     *
     * <code>.google.protobuf.Duration dag_timeout = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setDagTimeout(com.google.protobuf.Duration.Builder builderForValue) {
      if (dagTimeoutBuilder_ == null) {
        dagTimeout_ = builderForValue.build();
      } else {
        dagTimeoutBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Timeout duration for the DAG of jobs, expressed in seconds (see
     * [JSON representation of
     * duration](https://developers.google.com/protocol-buffers/docs/proto3#json)).
     * The timeout duration must be from 10 minutes ("600s") to 24 hours
     * ("86400s"). The timer begins when the first job is submitted. If the
     * workflow is running at the end of the timeout period, any remaining jobs
     * are cancelled, the workflow is ended, and if the workflow was running on a
     * [managed
     * cluster](/dataproc/docs/concepts/workflows/using-workflows#configuring_or_selecting_a_cluster),
     * the cluster is deleted.
     * </pre>
     *
     * <code>.google.protobuf.Duration dag_timeout = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeDagTimeout(com.google.protobuf.Duration value) {
      if (dagTimeoutBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)
            && dagTimeout_ != null
            && dagTimeout_ != com.google.protobuf.Duration.getDefaultInstance()) {
          getDagTimeoutBuilder().mergeFrom(value);
        } else {
          dagTimeout_ = value;
        }
      } else {
        dagTimeoutBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Timeout duration for the DAG of jobs, expressed in seconds (see
     * [JSON representation of
     * duration](https://developers.google.com/protocol-buffers/docs/proto3#json)).
     * The timeout duration must be from 10 minutes ("600s") to 24 hours
     * ("86400s"). The timer begins when the first job is submitted. If the
     * workflow is running at the end of the timeout period, any remaining jobs
     * are cancelled, the workflow is ended, and if the workflow was running on a
     * [managed
     * cluster](/dataproc/docs/concepts/workflows/using-workflows#configuring_or_selecting_a_cluster),
     * the cluster is deleted.
     * </pre>
     *
     * <code>.google.protobuf.Duration dag_timeout = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearDagTimeout() {
      bitField0_ = (bitField0_ & ~0x00000200);
      dagTimeout_ = null;
      if (dagTimeoutBuilder_ != null) {
        dagTimeoutBuilder_.dispose();
        dagTimeoutBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Timeout duration for the DAG of jobs, expressed in seconds (see
     * [JSON representation of
     * duration](https://developers.google.com/protocol-buffers/docs/proto3#json)).
     * The timeout duration must be from 10 minutes ("600s") to 24 hours
     * ("86400s"). The timer begins when the first job is submitted. If the
     * workflow is running at the end of the timeout period, any remaining jobs
     * are cancelled, the workflow is ended, and if the workflow was running on a
     * [managed
     * cluster](/dataproc/docs/concepts/workflows/using-workflows#configuring_or_selecting_a_cluster),
     * the cluster is deleted.
     * </pre>
     *
     * <code>.google.protobuf.Duration dag_timeout = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.Duration.Builder getDagTimeoutBuilder() {
      bitField0_ |= 0x00000200;
      onChanged();
      return getDagTimeoutFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Timeout duration for the DAG of jobs, expressed in seconds (see
     * [JSON representation of
     * duration](https://developers.google.com/protocol-buffers/docs/proto3#json)).
     * The timeout duration must be from 10 minutes ("600s") to 24 hours
     * ("86400s"). The timer begins when the first job is submitted. If the
     * workflow is running at the end of the timeout period, any remaining jobs
     * are cancelled, the workflow is ended, and if the workflow was running on a
     * [managed
     * cluster](/dataproc/docs/concepts/workflows/using-workflows#configuring_or_selecting_a_cluster),
     * the cluster is deleted.
     * </pre>
     *
     * <code>.google.protobuf.Duration dag_timeout = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.DurationOrBuilder getDagTimeoutOrBuilder() {
      if (dagTimeoutBuilder_ != null) {
        return dagTimeoutBuilder_.getMessageOrBuilder();
      } else {
        return dagTimeout_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : dagTimeout_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Timeout duration for the DAG of jobs, expressed in seconds (see
     * [JSON representation of
     * duration](https://developers.google.com/protocol-buffers/docs/proto3#json)).
     * The timeout duration must be from 10 minutes ("600s") to 24 hours
     * ("86400s"). The timer begins when the first job is submitted. If the
     * workflow is running at the end of the timeout period, any remaining jobs
     * are cancelled, the workflow is ended, and if the workflow was running on a
     * [managed
     * cluster](/dataproc/docs/concepts/workflows/using-workflows#configuring_or_selecting_a_cluster),
     * the cluster is deleted.
     * </pre>
     *
     * <code>.google.protobuf.Duration dag_timeout = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getDagTimeoutFieldBuilder() {
      if (dagTimeoutBuilder_ == null) {
        dagTimeoutBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getDagTimeout(), getParentForChildren(), isClean());
        dagTimeout_ = null;
      }
      return dagTimeoutBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dataproc.v1.WorkflowTemplate)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dataproc.v1.WorkflowTemplate)
  private static final com.google.cloud.dataproc.v1.WorkflowTemplate DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dataproc.v1.WorkflowTemplate();
  }

  public static com.google.cloud.dataproc.v1.WorkflowTemplate getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<WorkflowTemplate> PARSER =
      new com.google.protobuf.AbstractParser<WorkflowTemplate>() {
        @java.lang.Override
        public WorkflowTemplate parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<WorkflowTemplate> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<WorkflowTemplate> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dataproc.v1.WorkflowTemplate getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
