/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dataproc/v1/operations.proto

package com.google.cloud.dataproc.v1;

/**
 *
 *
 * <pre>
 * Metadata describing the Batch operation.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dataproc.v1.BatchOperationMetadata}
 */
public final class BatchOperationMetadata extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dataproc.v1.BatchOperationMetadata)
    BatchOperationMetadataOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use BatchOperationMetadata.newBuilder() to construct.
  private BatchOperationMetadata(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private BatchOperationMetadata() {
    batch_ = "";
    batchUuid_ = "";
    operationType_ = 0;
    description_ = "";
    warnings_ = com.google.protobuf.LazyStringArrayList.EMPTY;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new BatchOperationMetadata();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dataproc.v1.OperationsProto
        .internal_static_google_cloud_dataproc_v1_BatchOperationMetadata_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 8:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dataproc.v1.OperationsProto
        .internal_static_google_cloud_dataproc_v1_BatchOperationMetadata_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dataproc.v1.BatchOperationMetadata.class,
            com.google.cloud.dataproc.v1.BatchOperationMetadata.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Operation type for Batch resources
   * </pre>
   *
   * Protobuf enum {@code google.cloud.dataproc.v1.BatchOperationMetadata.BatchOperationType}
   */
  public enum BatchOperationType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Batch operation type is unknown.
     * </pre>
     *
     * <code>BATCH_OPERATION_TYPE_UNSPECIFIED = 0;</code>
     */
    BATCH_OPERATION_TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Batch operation type.
     * </pre>
     *
     * <code>BATCH = 1;</code>
     */
    BATCH(1),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Batch operation type is unknown.
     * </pre>
     *
     * <code>BATCH_OPERATION_TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int BATCH_OPERATION_TYPE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Batch operation type.
     * </pre>
     *
     * <code>BATCH = 1;</code>
     */
    public static final int BATCH_VALUE = 1;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static BatchOperationType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static BatchOperationType forNumber(int value) {
      switch (value) {
        case 0:
          return BATCH_OPERATION_TYPE_UNSPECIFIED;
        case 1:
          return BATCH;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<BatchOperationType>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<BatchOperationType>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<BatchOperationType>() {
              public BatchOperationType findValueByNumber(int number) {
                return BatchOperationType.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.dataproc.v1.BatchOperationMetadata.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final BatchOperationType[] VALUES = values();

    public static BatchOperationType valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private BatchOperationType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.dataproc.v1.BatchOperationMetadata.BatchOperationType)
  }

  public static final int BATCH_FIELD_NUMBER = 1;
  private volatile java.lang.Object batch_;
  /**
   *
   *
   * <pre>
   * Name of the batch for the operation.
   * </pre>
   *
   * <code>string batch = 1;</code>
   *
   * @return The batch.
   */
  @java.lang.Override
  public java.lang.String getBatch() {
    java.lang.Object ref = batch_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      batch_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Name of the batch for the operation.
   * </pre>
   *
   * <code>string batch = 1;</code>
   *
   * @return The bytes for batch.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getBatchBytes() {
    java.lang.Object ref = batch_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      batch_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int BATCH_UUID_FIELD_NUMBER = 2;
  private volatile java.lang.Object batchUuid_;
  /**
   *
   *
   * <pre>
   * Batch UUID for the operation.
   * </pre>
   *
   * <code>string batch_uuid = 2;</code>
   *
   * @return The batchUuid.
   */
  @java.lang.Override
  public java.lang.String getBatchUuid() {
    java.lang.Object ref = batchUuid_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      batchUuid_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Batch UUID for the operation.
   * </pre>
   *
   * <code>string batch_uuid = 2;</code>
   *
   * @return The bytes for batchUuid.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getBatchUuidBytes() {
    java.lang.Object ref = batchUuid_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      batchUuid_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 3;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * The time when the operation was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3;</code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * The time when the operation was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3;</code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * The time when the operation was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return getCreateTime();
  }

  public static final int DONE_TIME_FIELD_NUMBER = 4;
  private com.google.protobuf.Timestamp doneTime_;
  /**
   *
   *
   * <pre>
   * The time when the operation finished.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp done_time = 4;</code>
   *
   * @return Whether the doneTime field is set.
   */
  @java.lang.Override
  public boolean hasDoneTime() {
    return doneTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * The time when the operation finished.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp done_time = 4;</code>
   *
   * @return The doneTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getDoneTime() {
    return doneTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : doneTime_;
  }
  /**
   *
   *
   * <pre>
   * The time when the operation finished.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp done_time = 4;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getDoneTimeOrBuilder() {
    return getDoneTime();
  }

  public static final int OPERATION_TYPE_FIELD_NUMBER = 6;
  private int operationType_;
  /**
   *
   *
   * <pre>
   * The operation type.
   * </pre>
   *
   * <code>.google.cloud.dataproc.v1.BatchOperationMetadata.BatchOperationType operation_type = 6;
   * </code>
   *
   * @return The enum numeric value on the wire for operationType.
   */
  @java.lang.Override
  public int getOperationTypeValue() {
    return operationType_;
  }
  /**
   *
   *
   * <pre>
   * The operation type.
   * </pre>
   *
   * <code>.google.cloud.dataproc.v1.BatchOperationMetadata.BatchOperationType operation_type = 6;
   * </code>
   *
   * @return The operationType.
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.BatchOperationMetadata.BatchOperationType getOperationType() {
    @SuppressWarnings("deprecation")
    com.google.cloud.dataproc.v1.BatchOperationMetadata.BatchOperationType result =
        com.google.cloud.dataproc.v1.BatchOperationMetadata.BatchOperationType.valueOf(
            operationType_);
    return result == null
        ? com.google.cloud.dataproc.v1.BatchOperationMetadata.BatchOperationType.UNRECOGNIZED
        : result;
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 7;
  private volatile java.lang.Object description_;
  /**
   *
   *
   * <pre>
   * Short description of the operation.
   * </pre>
   *
   * <code>string description = 7;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Short description of the operation.
   * </pre>
   *
   * <code>string description = 7;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LABELS_FIELD_NUMBER = 8;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.dataproc.v1.OperationsProto
                .internal_static_google_cloud_dataproc_v1_BatchOperationMetadata_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Labels associated with the operation.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 8;</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * Labels associated with the operation.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 8;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * Labels associated with the operation.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 8;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrDefault(java.lang.String key, java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Labels associated with the operation.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 8;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int WARNINGS_FIELD_NUMBER = 9;
  private com.google.protobuf.LazyStringList warnings_;
  /**
   *
   *
   * <pre>
   * Warnings encountered during operation execution.
   * </pre>
   *
   * <code>repeated string warnings = 9;</code>
   *
   * @return A list containing the warnings.
   */
  public com.google.protobuf.ProtocolStringList getWarningsList() {
    return warnings_;
  }
  /**
   *
   *
   * <pre>
   * Warnings encountered during operation execution.
   * </pre>
   *
   * <code>repeated string warnings = 9;</code>
   *
   * @return The count of warnings.
   */
  public int getWarningsCount() {
    return warnings_.size();
  }
  /**
   *
   *
   * <pre>
   * Warnings encountered during operation execution.
   * </pre>
   *
   * <code>repeated string warnings = 9;</code>
   *
   * @param index The index of the element to return.
   * @return The warnings at the given index.
   */
  public java.lang.String getWarnings(int index) {
    return warnings_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Warnings encountered during operation execution.
   * </pre>
   *
   * <code>repeated string warnings = 9;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the warnings at the given index.
   */
  public com.google.protobuf.ByteString getWarningsBytes(int index) {
    return warnings_.getByteString(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(batch_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, batch_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(batchUuid_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, batchUuid_);
    }
    if (createTime_ != null) {
      output.writeMessage(3, getCreateTime());
    }
    if (doneTime_ != null) {
      output.writeMessage(4, getDoneTime());
    }
    if (operationType_
        != com.google.cloud.dataproc.v1.BatchOperationMetadata.BatchOperationType
            .BATCH_OPERATION_TYPE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(6, operationType_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, description_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 8);
    for (int i = 0; i < warnings_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 9, warnings_.getRaw(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(batch_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, batch_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(batchUuid_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, batchUuid_);
    }
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getCreateTime());
    }
    if (doneTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getDoneTime());
    }
    if (operationType_
        != com.google.cloud.dataproc.v1.BatchOperationMetadata.BatchOperationType
            .BATCH_OPERATION_TYPE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(6, operationType_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, description_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, labels__);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < warnings_.size(); i++) {
        dataSize += computeStringSizeNoTag(warnings_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getWarningsList().size();
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dataproc.v1.BatchOperationMetadata)) {
      return super.equals(obj);
    }
    com.google.cloud.dataproc.v1.BatchOperationMetadata other =
        (com.google.cloud.dataproc.v1.BatchOperationMetadata) obj;

    if (!getBatch().equals(other.getBatch())) return false;
    if (!getBatchUuid().equals(other.getBatchUuid())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasDoneTime() != other.hasDoneTime()) return false;
    if (hasDoneTime()) {
      if (!getDoneTime().equals(other.getDoneTime())) return false;
    }
    if (operationType_ != other.operationType_) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (!getWarningsList().equals(other.getWarningsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + BATCH_FIELD_NUMBER;
    hash = (53 * hash) + getBatch().hashCode();
    hash = (37 * hash) + BATCH_UUID_FIELD_NUMBER;
    hash = (53 * hash) + getBatchUuid().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasDoneTime()) {
      hash = (37 * hash) + DONE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getDoneTime().hashCode();
    }
    hash = (37 * hash) + OPERATION_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + operationType_;
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    if (getWarningsCount() > 0) {
      hash = (37 * hash) + WARNINGS_FIELD_NUMBER;
      hash = (53 * hash) + getWarningsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dataproc.v1.BatchOperationMetadata parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1.BatchOperationMetadata parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.BatchOperationMetadata parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1.BatchOperationMetadata parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.BatchOperationMetadata parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1.BatchOperationMetadata parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.BatchOperationMetadata parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1.BatchOperationMetadata parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.BatchOperationMetadata parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1.BatchOperationMetadata parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.BatchOperationMetadata parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1.BatchOperationMetadata parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.dataproc.v1.BatchOperationMetadata prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Metadata describing the Batch operation.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dataproc.v1.BatchOperationMetadata}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dataproc.v1.BatchOperationMetadata)
      com.google.cloud.dataproc.v1.BatchOperationMetadataOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dataproc.v1.OperationsProto
          .internal_static_google_cloud_dataproc_v1_BatchOperationMetadata_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 8:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 8:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dataproc.v1.OperationsProto
          .internal_static_google_cloud_dataproc_v1_BatchOperationMetadata_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dataproc.v1.BatchOperationMetadata.class,
              com.google.cloud.dataproc.v1.BatchOperationMetadata.Builder.class);
    }

    // Construct using com.google.cloud.dataproc.v1.BatchOperationMetadata.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      batch_ = "";

      batchUuid_ = "";

      if (createTimeBuilder_ == null) {
        createTime_ = null;
      } else {
        createTime_ = null;
        createTimeBuilder_ = null;
      }
      if (doneTimeBuilder_ == null) {
        doneTime_ = null;
      } else {
        doneTime_ = null;
        doneTimeBuilder_ = null;
      }
      operationType_ = 0;

      description_ = "";

      internalGetMutableLabels().clear();
      warnings_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000002);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dataproc.v1.OperationsProto
          .internal_static_google_cloud_dataproc_v1_BatchOperationMetadata_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.BatchOperationMetadata getDefaultInstanceForType() {
      return com.google.cloud.dataproc.v1.BatchOperationMetadata.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.BatchOperationMetadata build() {
      com.google.cloud.dataproc.v1.BatchOperationMetadata result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.BatchOperationMetadata buildPartial() {
      com.google.cloud.dataproc.v1.BatchOperationMetadata result =
          new com.google.cloud.dataproc.v1.BatchOperationMetadata(this);
      int from_bitField0_ = bitField0_;
      result.batch_ = batch_;
      result.batchUuid_ = batchUuid_;
      if (createTimeBuilder_ == null) {
        result.createTime_ = createTime_;
      } else {
        result.createTime_ = createTimeBuilder_.build();
      }
      if (doneTimeBuilder_ == null) {
        result.doneTime_ = doneTime_;
      } else {
        result.doneTime_ = doneTimeBuilder_.build();
      }
      result.operationType_ = operationType_;
      result.description_ = description_;
      result.labels_ = internalGetLabels();
      result.labels_.makeImmutable();
      if (((bitField0_ & 0x00000002) != 0)) {
        warnings_ = warnings_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000002);
      }
      result.warnings_ = warnings_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dataproc.v1.BatchOperationMetadata) {
        return mergeFrom((com.google.cloud.dataproc.v1.BatchOperationMetadata) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dataproc.v1.BatchOperationMetadata other) {
      if (other == com.google.cloud.dataproc.v1.BatchOperationMetadata.getDefaultInstance())
        return this;
      if (!other.getBatch().isEmpty()) {
        batch_ = other.batch_;
        onChanged();
      }
      if (!other.getBatchUuid().isEmpty()) {
        batchUuid_ = other.batchUuid_;
        onChanged();
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasDoneTime()) {
        mergeDoneTime(other.getDoneTime());
      }
      if (other.operationType_ != 0) {
        setOperationTypeValue(other.getOperationTypeValue());
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        onChanged();
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      if (!other.warnings_.isEmpty()) {
        if (warnings_.isEmpty()) {
          warnings_ = other.warnings_;
          bitField0_ = (bitField0_ & ~0x00000002);
        } else {
          ensureWarningsIsMutable();
          warnings_.addAll(other.warnings_);
        }
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                batch_ = input.readStringRequireUtf8();

                break;
              } // case 10
            case 18:
              {
                batchUuid_ = input.readStringRequireUtf8();

                break;
              } // case 18
            case 26:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 26
            case 34:
              {
                input.readMessage(getDoneTimeFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 34
            case 48:
              {
                operationType_ = input.readEnum();

                break;
              } // case 48
            case 58:
              {
                description_ = input.readStringRequireUtf8();

                break;
              } // case 58
            case 66:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                break;
              } // case 66
            case 74:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureWarningsIsMutable();
                warnings_.add(s);
                break;
              } // case 74
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object batch_ = "";
    /**
     *
     *
     * <pre>
     * Name of the batch for the operation.
     * </pre>
     *
     * <code>string batch = 1;</code>
     *
     * @return The batch.
     */
    public java.lang.String getBatch() {
      java.lang.Object ref = batch_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        batch_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of the batch for the operation.
     * </pre>
     *
     * <code>string batch = 1;</code>
     *
     * @return The bytes for batch.
     */
    public com.google.protobuf.ByteString getBatchBytes() {
      java.lang.Object ref = batch_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        batch_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of the batch for the operation.
     * </pre>
     *
     * <code>string batch = 1;</code>
     *
     * @param value The batch to set.
     * @return This builder for chaining.
     */
    public Builder setBatch(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      batch_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name of the batch for the operation.
     * </pre>
     *
     * <code>string batch = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBatch() {

      batch_ = getDefaultInstance().getBatch();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name of the batch for the operation.
     * </pre>
     *
     * <code>string batch = 1;</code>
     *
     * @param value The bytes for batch to set.
     * @return This builder for chaining.
     */
    public Builder setBatchBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      batch_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object batchUuid_ = "";
    /**
     *
     *
     * <pre>
     * Batch UUID for the operation.
     * </pre>
     *
     * <code>string batch_uuid = 2;</code>
     *
     * @return The batchUuid.
     */
    public java.lang.String getBatchUuid() {
      java.lang.Object ref = batchUuid_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        batchUuid_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Batch UUID for the operation.
     * </pre>
     *
     * <code>string batch_uuid = 2;</code>
     *
     * @return The bytes for batchUuid.
     */
    public com.google.protobuf.ByteString getBatchUuidBytes() {
      java.lang.Object ref = batchUuid_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        batchUuid_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Batch UUID for the operation.
     * </pre>
     *
     * <code>string batch_uuid = 2;</code>
     *
     * @param value The batchUuid to set.
     * @return This builder for chaining.
     */
    public Builder setBatchUuid(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      batchUuid_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Batch UUID for the operation.
     * </pre>
     *
     * <code>string batch_uuid = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBatchUuid() {

      batchUuid_ = getDefaultInstance().getBatchUuid();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Batch UUID for the operation.
     * </pre>
     *
     * <code>string batch_uuid = 2;</code>
     *
     * @param value The bytes for batchUuid to set.
     * @return This builder for chaining.
     */
    public Builder setBatchUuidBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      batchUuid_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * The time when the operation was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 3;</code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return createTimeBuilder_ != null || createTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * The time when the operation was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 3;</code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The time when the operation was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 3;</code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
        onChanged();
      } else {
        createTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The time when the operation was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 3;</code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
        onChanged();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The time when the operation was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 3;</code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (createTime_ != null) {
          createTime_ =
              com.google.protobuf.Timestamp.newBuilder(createTime_).mergeFrom(value).buildPartial();
        } else {
          createTime_ = value;
        }
        onChanged();
      } else {
        createTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The time when the operation was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 3;</code>
     */
    public Builder clearCreateTime() {
      if (createTimeBuilder_ == null) {
        createTime_ = null;
        onChanged();
      } else {
        createTime_ = null;
        createTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The time when the operation was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 3;</code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {

      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The time when the operation was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 3;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * The time when the operation was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp doneTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        doneTimeBuilder_;
    /**
     *
     *
     * <pre>
     * The time when the operation finished.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp done_time = 4;</code>
     *
     * @return Whether the doneTime field is set.
     */
    public boolean hasDoneTime() {
      return doneTimeBuilder_ != null || doneTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * The time when the operation finished.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp done_time = 4;</code>
     *
     * @return The doneTime.
     */
    public com.google.protobuf.Timestamp getDoneTime() {
      if (doneTimeBuilder_ == null) {
        return doneTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : doneTime_;
      } else {
        return doneTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The time when the operation finished.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp done_time = 4;</code>
     */
    public Builder setDoneTime(com.google.protobuf.Timestamp value) {
      if (doneTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        doneTime_ = value;
        onChanged();
      } else {
        doneTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The time when the operation finished.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp done_time = 4;</code>
     */
    public Builder setDoneTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (doneTimeBuilder_ == null) {
        doneTime_ = builderForValue.build();
        onChanged();
      } else {
        doneTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The time when the operation finished.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp done_time = 4;</code>
     */
    public Builder mergeDoneTime(com.google.protobuf.Timestamp value) {
      if (doneTimeBuilder_ == null) {
        if (doneTime_ != null) {
          doneTime_ =
              com.google.protobuf.Timestamp.newBuilder(doneTime_).mergeFrom(value).buildPartial();
        } else {
          doneTime_ = value;
        }
        onChanged();
      } else {
        doneTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The time when the operation finished.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp done_time = 4;</code>
     */
    public Builder clearDoneTime() {
      if (doneTimeBuilder_ == null) {
        doneTime_ = null;
        onChanged();
      } else {
        doneTime_ = null;
        doneTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The time when the operation finished.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp done_time = 4;</code>
     */
    public com.google.protobuf.Timestamp.Builder getDoneTimeBuilder() {

      onChanged();
      return getDoneTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The time when the operation finished.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp done_time = 4;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getDoneTimeOrBuilder() {
      if (doneTimeBuilder_ != null) {
        return doneTimeBuilder_.getMessageOrBuilder();
      } else {
        return doneTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : doneTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * The time when the operation finished.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp done_time = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getDoneTimeFieldBuilder() {
      if (doneTimeBuilder_ == null) {
        doneTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getDoneTime(), getParentForChildren(), isClean());
        doneTime_ = null;
      }
      return doneTimeBuilder_;
    }

    private int operationType_ = 0;
    /**
     *
     *
     * <pre>
     * The operation type.
     * </pre>
     *
     * <code>.google.cloud.dataproc.v1.BatchOperationMetadata.BatchOperationType operation_type = 6;
     * </code>
     *
     * @return The enum numeric value on the wire for operationType.
     */
    @java.lang.Override
    public int getOperationTypeValue() {
      return operationType_;
    }
    /**
     *
     *
     * <pre>
     * The operation type.
     * </pre>
     *
     * <code>.google.cloud.dataproc.v1.BatchOperationMetadata.BatchOperationType operation_type = 6;
     * </code>
     *
     * @param value The enum numeric value on the wire for operationType to set.
     * @return This builder for chaining.
     */
    public Builder setOperationTypeValue(int value) {

      operationType_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The operation type.
     * </pre>
     *
     * <code>.google.cloud.dataproc.v1.BatchOperationMetadata.BatchOperationType operation_type = 6;
     * </code>
     *
     * @return The operationType.
     */
    @java.lang.Override
    public com.google.cloud.dataproc.v1.BatchOperationMetadata.BatchOperationType
        getOperationType() {
      @SuppressWarnings("deprecation")
      com.google.cloud.dataproc.v1.BatchOperationMetadata.BatchOperationType result =
          com.google.cloud.dataproc.v1.BatchOperationMetadata.BatchOperationType.valueOf(
              operationType_);
      return result == null
          ? com.google.cloud.dataproc.v1.BatchOperationMetadata.BatchOperationType.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * The operation type.
     * </pre>
     *
     * <code>.google.cloud.dataproc.v1.BatchOperationMetadata.BatchOperationType operation_type = 6;
     * </code>
     *
     * @param value The operationType to set.
     * @return This builder for chaining.
     */
    public Builder setOperationType(
        com.google.cloud.dataproc.v1.BatchOperationMetadata.BatchOperationType value) {
      if (value == null) {
        throw new NullPointerException();
      }

      operationType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The operation type.
     * </pre>
     *
     * <code>.google.cloud.dataproc.v1.BatchOperationMetadata.BatchOperationType operation_type = 6;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearOperationType() {

      operationType_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * Short description of the operation.
     * </pre>
     *
     * <code>string description = 7;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Short description of the operation.
     * </pre>
     *
     * <code>string description = 7;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Short description of the operation.
     * </pre>
     *
     * <code>string description = 7;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      description_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Short description of the operation.
     * </pre>
     *
     * <code>string description = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {

      description_ = getDefaultInstance().getDescription();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Short description of the operation.
     * </pre>
     *
     * <code>string description = 7;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      description_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      onChanged();
      ;
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Labels associated with the operation.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 8;</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * Labels associated with the operation.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 8;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * Labels associated with the operation.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 8;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrDefault(
        java.lang.String key, java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Labels associated with the operation.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 8;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Labels associated with the operation.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 8;</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Labels associated with the operation.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 8;</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }

      internalGetMutableLabels().getMutableMap().put(key, value);
      return this;
    }
    /**
     *
     *
     * <pre>
     * Labels associated with the operation.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 8;</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      return this;
    }

    private com.google.protobuf.LazyStringList warnings_ =
        com.google.protobuf.LazyStringArrayList.EMPTY;

    private void ensureWarningsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        warnings_ = new com.google.protobuf.LazyStringArrayList(warnings_);
        bitField0_ |= 0x00000002;
      }
    }
    /**
     *
     *
     * <pre>
     * Warnings encountered during operation execution.
     * </pre>
     *
     * <code>repeated string warnings = 9;</code>
     *
     * @return A list containing the warnings.
     */
    public com.google.protobuf.ProtocolStringList getWarningsList() {
      return warnings_.getUnmodifiableView();
    }
    /**
     *
     *
     * <pre>
     * Warnings encountered during operation execution.
     * </pre>
     *
     * <code>repeated string warnings = 9;</code>
     *
     * @return The count of warnings.
     */
    public int getWarningsCount() {
      return warnings_.size();
    }
    /**
     *
     *
     * <pre>
     * Warnings encountered during operation execution.
     * </pre>
     *
     * <code>repeated string warnings = 9;</code>
     *
     * @param index The index of the element to return.
     * @return The warnings at the given index.
     */
    public java.lang.String getWarnings(int index) {
      return warnings_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Warnings encountered during operation execution.
     * </pre>
     *
     * <code>repeated string warnings = 9;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the warnings at the given index.
     */
    public com.google.protobuf.ByteString getWarningsBytes(int index) {
      return warnings_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Warnings encountered during operation execution.
     * </pre>
     *
     * <code>repeated string warnings = 9;</code>
     *
     * @param index The index to set the value at.
     * @param value The warnings to set.
     * @return This builder for chaining.
     */
    public Builder setWarnings(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureWarningsIsMutable();
      warnings_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Warnings encountered during operation execution.
     * </pre>
     *
     * <code>repeated string warnings = 9;</code>
     *
     * @param value The warnings to add.
     * @return This builder for chaining.
     */
    public Builder addWarnings(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureWarningsIsMutable();
      warnings_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Warnings encountered during operation execution.
     * </pre>
     *
     * <code>repeated string warnings = 9;</code>
     *
     * @param values The warnings to add.
     * @return This builder for chaining.
     */
    public Builder addAllWarnings(java.lang.Iterable<java.lang.String> values) {
      ensureWarningsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, warnings_);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Warnings encountered during operation execution.
     * </pre>
     *
     * <code>repeated string warnings = 9;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearWarnings() {
      warnings_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Warnings encountered during operation execution.
     * </pre>
     *
     * <code>repeated string warnings = 9;</code>
     *
     * @param value The bytes of the warnings to add.
     * @return This builder for chaining.
     */
    public Builder addWarningsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureWarningsIsMutable();
      warnings_.add(value);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dataproc.v1.BatchOperationMetadata)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dataproc.v1.BatchOperationMetadata)
  private static final com.google.cloud.dataproc.v1.BatchOperationMetadata DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dataproc.v1.BatchOperationMetadata();
  }

  public static com.google.cloud.dataproc.v1.BatchOperationMetadata getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<BatchOperationMetadata> PARSER =
      new com.google.protobuf.AbstractParser<BatchOperationMetadata>() {
        @java.lang.Override
        public BatchOperationMetadata parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<BatchOperationMetadata> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<BatchOperationMetadata> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dataproc.v1.BatchOperationMetadata getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
