/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dataproc/v1/clusters.proto

package com.google.cloud.dataproc.v1;

/**
 *
 *
 * <pre>
 * The status of a cluster and its instances.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dataproc.v1.ClusterStatus}
 */
public final class ClusterStatus extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dataproc.v1.ClusterStatus)
    ClusterStatusOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ClusterStatus.newBuilder() to construct.
  private ClusterStatus(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ClusterStatus() {
    state_ = 0;
    detail_ = "";
    substate_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ClusterStatus();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dataproc.v1.ClustersProto
        .internal_static_google_cloud_dataproc_v1_ClusterStatus_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dataproc.v1.ClustersProto
        .internal_static_google_cloud_dataproc_v1_ClusterStatus_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dataproc.v1.ClusterStatus.class,
            com.google.cloud.dataproc.v1.ClusterStatus.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The cluster state.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.dataproc.v1.ClusterStatus.State}
   */
  public enum State implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * The cluster state is unknown.
     * </pre>
     *
     * <code>UNKNOWN = 0;</code>
     */
    UNKNOWN(0),
    /**
     *
     *
     * <pre>
     * The cluster is being created and set up. It is not ready for use.
     * </pre>
     *
     * <code>CREATING = 1;</code>
     */
    CREATING(1),
    /**
     *
     *
     * <pre>
     * The cluster is currently running and healthy. It is ready for use.
     * **Note:** The cluster state changes from "creating" to "running" status
     * after the master node(s), first two primary worker nodes (and the last
     * primary worker node if primary workers &gt; 2) are running.
     * </pre>
     *
     * <code>RUNNING = 2;</code>
     */
    RUNNING(2),
    /**
     *
     *
     * <pre>
     * The cluster encountered an error. It is not ready for use.
     * </pre>
     *
     * <code>ERROR = 3;</code>
     */
    ERROR(3),
    /**
     *
     *
     * <pre>
     * The cluster has encountered an error while being updated. Jobs can
     * be submitted to the cluster, but the cluster cannot be updated.
     * </pre>
     *
     * <code>ERROR_DUE_TO_UPDATE = 9;</code>
     */
    ERROR_DUE_TO_UPDATE(9),
    /**
     *
     *
     * <pre>
     * The cluster is being deleted. It cannot be used.
     * </pre>
     *
     * <code>DELETING = 4;</code>
     */
    DELETING(4),
    /**
     *
     *
     * <pre>
     * The cluster is being updated. It continues to accept and process jobs.
     * </pre>
     *
     * <code>UPDATING = 5;</code>
     */
    UPDATING(5),
    /**
     *
     *
     * <pre>
     * The cluster is being stopped. It cannot be used.
     * </pre>
     *
     * <code>STOPPING = 6;</code>
     */
    STOPPING(6),
    /**
     *
     *
     * <pre>
     * The cluster is currently stopped. It is not ready for use.
     * </pre>
     *
     * <code>STOPPED = 7;</code>
     */
    STOPPED(7),
    /**
     *
     *
     * <pre>
     * The cluster is being started. It is not ready for use.
     * </pre>
     *
     * <code>STARTING = 8;</code>
     */
    STARTING(8),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * The cluster state is unknown.
     * </pre>
     *
     * <code>UNKNOWN = 0;</code>
     */
    public static final int UNKNOWN_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The cluster is being created and set up. It is not ready for use.
     * </pre>
     *
     * <code>CREATING = 1;</code>
     */
    public static final int CREATING_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The cluster is currently running and healthy. It is ready for use.
     * **Note:** The cluster state changes from "creating" to "running" status
     * after the master node(s), first two primary worker nodes (and the last
     * primary worker node if primary workers &gt; 2) are running.
     * </pre>
     *
     * <code>RUNNING = 2;</code>
     */
    public static final int RUNNING_VALUE = 2;
    /**
     *
     *
     * <pre>
     * The cluster encountered an error. It is not ready for use.
     * </pre>
     *
     * <code>ERROR = 3;</code>
     */
    public static final int ERROR_VALUE = 3;
    /**
     *
     *
     * <pre>
     * The cluster has encountered an error while being updated. Jobs can
     * be submitted to the cluster, but the cluster cannot be updated.
     * </pre>
     *
     * <code>ERROR_DUE_TO_UPDATE = 9;</code>
     */
    public static final int ERROR_DUE_TO_UPDATE_VALUE = 9;
    /**
     *
     *
     * <pre>
     * The cluster is being deleted. It cannot be used.
     * </pre>
     *
     * <code>DELETING = 4;</code>
     */
    public static final int DELETING_VALUE = 4;
    /**
     *
     *
     * <pre>
     * The cluster is being updated. It continues to accept and process jobs.
     * </pre>
     *
     * <code>UPDATING = 5;</code>
     */
    public static final int UPDATING_VALUE = 5;
    /**
     *
     *
     * <pre>
     * The cluster is being stopped. It cannot be used.
     * </pre>
     *
     * <code>STOPPING = 6;</code>
     */
    public static final int STOPPING_VALUE = 6;
    /**
     *
     *
     * <pre>
     * The cluster is currently stopped. It is not ready for use.
     * </pre>
     *
     * <code>STOPPED = 7;</code>
     */
    public static final int STOPPED_VALUE = 7;
    /**
     *
     *
     * <pre>
     * The cluster is being started. It is not ready for use.
     * </pre>
     *
     * <code>STARTING = 8;</code>
     */
    public static final int STARTING_VALUE = 8;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static State valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static State forNumber(int value) {
      switch (value) {
        case 0:
          return UNKNOWN;
        case 1:
          return CREATING;
        case 2:
          return RUNNING;
        case 3:
          return ERROR;
        case 9:
          return ERROR_DUE_TO_UPDATE;
        case 4:
          return DELETING;
        case 5:
          return UPDATING;
        case 6:
          return STOPPING;
        case 7:
          return STOPPED;
        case 8:
          return STARTING;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<State>() {
          public State findValueByNumber(int number) {
            return State.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.dataproc.v1.ClusterStatus.getDescriptor().getEnumTypes().get(0);
    }

    private static final State[] VALUES = values();

    public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private State(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.dataproc.v1.ClusterStatus.State)
  }

  /**
   *
   *
   * <pre>
   * The cluster substate.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.dataproc.v1.ClusterStatus.Substate}
   */
  public enum Substate implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * The cluster substate is unknown.
     * </pre>
     *
     * <code>UNSPECIFIED = 0;</code>
     */
    UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The cluster is known to be in an unhealthy state
     * (for example, critical daemons are not running or HDFS capacity is
     * exhausted).
     * Applies to RUNNING state.
     * </pre>
     *
     * <code>UNHEALTHY = 1;</code>
     */
    UNHEALTHY(1),
    /**
     *
     *
     * <pre>
     * The agent-reported status is out of date (may occur if
     * Dataproc loses communication with Agent).
     * Applies to RUNNING state.
     * </pre>
     *
     * <code>STALE_STATUS = 2;</code>
     */
    STALE_STATUS(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * The cluster substate is unknown.
     * </pre>
     *
     * <code>UNSPECIFIED = 0;</code>
     */
    public static final int UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The cluster is known to be in an unhealthy state
     * (for example, critical daemons are not running or HDFS capacity is
     * exhausted).
     * Applies to RUNNING state.
     * </pre>
     *
     * <code>UNHEALTHY = 1;</code>
     */
    public static final int UNHEALTHY_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The agent-reported status is out of date (may occur if
     * Dataproc loses communication with Agent).
     * Applies to RUNNING state.
     * </pre>
     *
     * <code>STALE_STATUS = 2;</code>
     */
    public static final int STALE_STATUS_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Substate valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Substate forNumber(int value) {
      switch (value) {
        case 0:
          return UNSPECIFIED;
        case 1:
          return UNHEALTHY;
        case 2:
          return STALE_STATUS;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Substate> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Substate> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Substate>() {
          public Substate findValueByNumber(int number) {
            return Substate.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.dataproc.v1.ClusterStatus.getDescriptor().getEnumTypes().get(1);
    }

    private static final Substate[] VALUES = values();

    public static Substate valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Substate(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.dataproc.v1.ClusterStatus.Substate)
  }

  public static final int STATE_FIELD_NUMBER = 1;
  private int state_;
  /**
   *
   *
   * <pre>
   * Output only. The cluster's state.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.ClusterStatus.State state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The cluster's state.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.ClusterStatus.State state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.ClusterStatus.State getState() {
    @SuppressWarnings("deprecation")
    com.google.cloud.dataproc.v1.ClusterStatus.State result =
        com.google.cloud.dataproc.v1.ClusterStatus.State.valueOf(state_);
    return result == null ? com.google.cloud.dataproc.v1.ClusterStatus.State.UNRECOGNIZED : result;
  }

  public static final int DETAIL_FIELD_NUMBER = 2;
  private volatile java.lang.Object detail_;
  /**
   *
   *
   * <pre>
   * Optional. Output only. Details of cluster's state.
   * </pre>
   *
   * <code>
   * string detail = 2 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The detail.
   */
  @java.lang.Override
  public java.lang.String getDetail() {
    java.lang.Object ref = detail_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      detail_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. Output only. Details of cluster's state.
   * </pre>
   *
   * <code>
   * string detail = 2 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The bytes for detail.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDetailBytes() {
    java.lang.Object ref = detail_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      detail_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STATE_START_TIME_FIELD_NUMBER = 3;
  private com.google.protobuf.Timestamp stateStartTime_;
  /**
   *
   *
   * <pre>
   * Output only. Time when this state was entered (see JSON representation of
   * [Timestamp](https://developers.google.com/protocol-buffers/docs/proto3#json)).
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp state_start_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the stateStartTime field is set.
   */
  @java.lang.Override
  public boolean hasStateStartTime() {
    return stateStartTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Time when this state was entered (see JSON representation of
   * [Timestamp](https://developers.google.com/protocol-buffers/docs/proto3#json)).
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp state_start_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The stateStartTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getStateStartTime() {
    return stateStartTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : stateStartTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Time when this state was entered (see JSON representation of
   * [Timestamp](https://developers.google.com/protocol-buffers/docs/proto3#json)).
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp state_start_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getStateStartTimeOrBuilder() {
    return getStateStartTime();
  }

  public static final int SUBSTATE_FIELD_NUMBER = 4;
  private int substate_;
  /**
   *
   *
   * <pre>
   * Output only. Additional state information that includes
   * status reported by the agent.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.ClusterStatus.Substate substate = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for substate.
   */
  @java.lang.Override
  public int getSubstateValue() {
    return substate_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Additional state information that includes
   * status reported by the agent.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.ClusterStatus.Substate substate = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The substate.
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.ClusterStatus.Substate getSubstate() {
    @SuppressWarnings("deprecation")
    com.google.cloud.dataproc.v1.ClusterStatus.Substate result =
        com.google.cloud.dataproc.v1.ClusterStatus.Substate.valueOf(substate_);
    return result == null
        ? com.google.cloud.dataproc.v1.ClusterStatus.Substate.UNRECOGNIZED
        : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (state_ != com.google.cloud.dataproc.v1.ClusterStatus.State.UNKNOWN.getNumber()) {
      output.writeEnum(1, state_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(detail_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, detail_);
    }
    if (stateStartTime_ != null) {
      output.writeMessage(3, getStateStartTime());
    }
    if (substate_ != com.google.cloud.dataproc.v1.ClusterStatus.Substate.UNSPECIFIED.getNumber()) {
      output.writeEnum(4, substate_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (state_ != com.google.cloud.dataproc.v1.ClusterStatus.State.UNKNOWN.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, state_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(detail_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, detail_);
    }
    if (stateStartTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getStateStartTime());
    }
    if (substate_ != com.google.cloud.dataproc.v1.ClusterStatus.Substate.UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, substate_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dataproc.v1.ClusterStatus)) {
      return super.equals(obj);
    }
    com.google.cloud.dataproc.v1.ClusterStatus other =
        (com.google.cloud.dataproc.v1.ClusterStatus) obj;

    if (state_ != other.state_) return false;
    if (!getDetail().equals(other.getDetail())) return false;
    if (hasStateStartTime() != other.hasStateStartTime()) return false;
    if (hasStateStartTime()) {
      if (!getStateStartTime().equals(other.getStateStartTime())) return false;
    }
    if (substate_ != other.substate_) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    hash = (37 * hash) + DETAIL_FIELD_NUMBER;
    hash = (53 * hash) + getDetail().hashCode();
    if (hasStateStartTime()) {
      hash = (37 * hash) + STATE_START_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getStateStartTime().hashCode();
    }
    hash = (37 * hash) + SUBSTATE_FIELD_NUMBER;
    hash = (53 * hash) + substate_;
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dataproc.v1.ClusterStatus parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1.ClusterStatus parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.ClusterStatus parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1.ClusterStatus parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.ClusterStatus parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1.ClusterStatus parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.ClusterStatus parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1.ClusterStatus parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.ClusterStatus parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1.ClusterStatus parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.ClusterStatus parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1.ClusterStatus parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.dataproc.v1.ClusterStatus prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The status of a cluster and its instances.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dataproc.v1.ClusterStatus}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dataproc.v1.ClusterStatus)
      com.google.cloud.dataproc.v1.ClusterStatusOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dataproc.v1.ClustersProto
          .internal_static_google_cloud_dataproc_v1_ClusterStatus_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dataproc.v1.ClustersProto
          .internal_static_google_cloud_dataproc_v1_ClusterStatus_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dataproc.v1.ClusterStatus.class,
              com.google.cloud.dataproc.v1.ClusterStatus.Builder.class);
    }

    // Construct using com.google.cloud.dataproc.v1.ClusterStatus.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      state_ = 0;

      detail_ = "";

      if (stateStartTimeBuilder_ == null) {
        stateStartTime_ = null;
      } else {
        stateStartTime_ = null;
        stateStartTimeBuilder_ = null;
      }
      substate_ = 0;

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dataproc.v1.ClustersProto
          .internal_static_google_cloud_dataproc_v1_ClusterStatus_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.ClusterStatus getDefaultInstanceForType() {
      return com.google.cloud.dataproc.v1.ClusterStatus.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.ClusterStatus build() {
      com.google.cloud.dataproc.v1.ClusterStatus result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.ClusterStatus buildPartial() {
      com.google.cloud.dataproc.v1.ClusterStatus result =
          new com.google.cloud.dataproc.v1.ClusterStatus(this);
      result.state_ = state_;
      result.detail_ = detail_;
      if (stateStartTimeBuilder_ == null) {
        result.stateStartTime_ = stateStartTime_;
      } else {
        result.stateStartTime_ = stateStartTimeBuilder_.build();
      }
      result.substate_ = substate_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dataproc.v1.ClusterStatus) {
        return mergeFrom((com.google.cloud.dataproc.v1.ClusterStatus) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dataproc.v1.ClusterStatus other) {
      if (other == com.google.cloud.dataproc.v1.ClusterStatus.getDefaultInstance()) return this;
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (!other.getDetail().isEmpty()) {
        detail_ = other.detail_;
        onChanged();
      }
      if (other.hasStateStartTime()) {
        mergeStateStartTime(other.getStateStartTime());
      }
      if (other.substate_ != 0) {
        setSubstateValue(other.getSubstateValue());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                state_ = input.readEnum();

                break;
              } // case 8
            case 18:
              {
                detail_ = input.readStringRequireUtf8();

                break;
              } // case 18
            case 26:
              {
                input.readMessage(getStateStartTimeFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 26
            case 32:
              {
                substate_ = input.readEnum();

                break;
              } // case 32
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. The cluster's state.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.ClusterStatus.State state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The cluster's state.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.ClusterStatus.State state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {

      state_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The cluster's state.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.ClusterStatus.State state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.dataproc.v1.ClusterStatus.State getState() {
      @SuppressWarnings("deprecation")
      com.google.cloud.dataproc.v1.ClusterStatus.State result =
          com.google.cloud.dataproc.v1.ClusterStatus.State.valueOf(state_);
      return result == null
          ? com.google.cloud.dataproc.v1.ClusterStatus.State.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. The cluster's state.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.ClusterStatus.State state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.cloud.dataproc.v1.ClusterStatus.State value) {
      if (value == null) {
        throw new NullPointerException();
      }

      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The cluster's state.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.ClusterStatus.State state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {

      state_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object detail_ = "";
    /**
     *
     *
     * <pre>
     * Optional. Output only. Details of cluster's state.
     * </pre>
     *
     * <code>
     * string detail = 2 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The detail.
     */
    public java.lang.String getDetail() {
      java.lang.Object ref = detail_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        detail_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Output only. Details of cluster's state.
     * </pre>
     *
     * <code>
     * string detail = 2 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The bytes for detail.
     */
    public com.google.protobuf.ByteString getDetailBytes() {
      java.lang.Object ref = detail_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        detail_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Output only. Details of cluster's state.
     * </pre>
     *
     * <code>
     * string detail = 2 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The detail to set.
     * @return This builder for chaining.
     */
    public Builder setDetail(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      detail_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Output only. Details of cluster's state.
     * </pre>
     *
     * <code>
     * string detail = 2 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDetail() {

      detail_ = getDefaultInstance().getDetail();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Output only. Details of cluster's state.
     * </pre>
     *
     * <code>
     * string detail = 2 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The bytes for detail to set.
     * @return This builder for chaining.
     */
    public Builder setDetailBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      detail_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp stateStartTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        stateStartTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Time when this state was entered (see JSON representation of
     * [Timestamp](https://developers.google.com/protocol-buffers/docs/proto3#json)).
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp state_start_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the stateStartTime field is set.
     */
    public boolean hasStateStartTime() {
      return stateStartTimeBuilder_ != null || stateStartTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when this state was entered (see JSON representation of
     * [Timestamp](https://developers.google.com/protocol-buffers/docs/proto3#json)).
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp state_start_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The stateStartTime.
     */
    public com.google.protobuf.Timestamp getStateStartTime() {
      if (stateStartTimeBuilder_ == null) {
        return stateStartTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : stateStartTime_;
      } else {
        return stateStartTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when this state was entered (see JSON representation of
     * [Timestamp](https://developers.google.com/protocol-buffers/docs/proto3#json)).
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp state_start_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setStateStartTime(com.google.protobuf.Timestamp value) {
      if (stateStartTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        stateStartTime_ = value;
        onChanged();
      } else {
        stateStartTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when this state was entered (see JSON representation of
     * [Timestamp](https://developers.google.com/protocol-buffers/docs/proto3#json)).
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp state_start_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setStateStartTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (stateStartTimeBuilder_ == null) {
        stateStartTime_ = builderForValue.build();
        onChanged();
      } else {
        stateStartTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when this state was entered (see JSON representation of
     * [Timestamp](https://developers.google.com/protocol-buffers/docs/proto3#json)).
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp state_start_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeStateStartTime(com.google.protobuf.Timestamp value) {
      if (stateStartTimeBuilder_ == null) {
        if (stateStartTime_ != null) {
          stateStartTime_ =
              com.google.protobuf.Timestamp.newBuilder(stateStartTime_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          stateStartTime_ = value;
        }
        onChanged();
      } else {
        stateStartTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when this state was entered (see JSON representation of
     * [Timestamp](https://developers.google.com/protocol-buffers/docs/proto3#json)).
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp state_start_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearStateStartTime() {
      if (stateStartTimeBuilder_ == null) {
        stateStartTime_ = null;
        onChanged();
      } else {
        stateStartTime_ = null;
        stateStartTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when this state was entered (see JSON representation of
     * [Timestamp](https://developers.google.com/protocol-buffers/docs/proto3#json)).
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp state_start_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getStateStartTimeBuilder() {

      onChanged();
      return getStateStartTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when this state was entered (see JSON representation of
     * [Timestamp](https://developers.google.com/protocol-buffers/docs/proto3#json)).
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp state_start_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getStateStartTimeOrBuilder() {
      if (stateStartTimeBuilder_ != null) {
        return stateStartTimeBuilder_.getMessageOrBuilder();
      } else {
        return stateStartTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : stateStartTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when this state was entered (see JSON representation of
     * [Timestamp](https://developers.google.com/protocol-buffers/docs/proto3#json)).
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp state_start_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getStateStartTimeFieldBuilder() {
      if (stateStartTimeBuilder_ == null) {
        stateStartTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getStateStartTime(), getParentForChildren(), isClean());
        stateStartTime_ = null;
      }
      return stateStartTimeBuilder_;
    }

    private int substate_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. Additional state information that includes
     * status reported by the agent.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.ClusterStatus.Substate substate = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for substate.
     */
    @java.lang.Override
    public int getSubstateValue() {
      return substate_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Additional state information that includes
     * status reported by the agent.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.ClusterStatus.Substate substate = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for substate to set.
     * @return This builder for chaining.
     */
    public Builder setSubstateValue(int value) {

      substate_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Additional state information that includes
     * status reported by the agent.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.ClusterStatus.Substate substate = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The substate.
     */
    @java.lang.Override
    public com.google.cloud.dataproc.v1.ClusterStatus.Substate getSubstate() {
      @SuppressWarnings("deprecation")
      com.google.cloud.dataproc.v1.ClusterStatus.Substate result =
          com.google.cloud.dataproc.v1.ClusterStatus.Substate.valueOf(substate_);
      return result == null
          ? com.google.cloud.dataproc.v1.ClusterStatus.Substate.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. Additional state information that includes
     * status reported by the agent.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.ClusterStatus.Substate substate = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The substate to set.
     * @return This builder for chaining.
     */
    public Builder setSubstate(com.google.cloud.dataproc.v1.ClusterStatus.Substate value) {
      if (value == null) {
        throw new NullPointerException();
      }

      substate_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Additional state information that includes
     * status reported by the agent.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.ClusterStatus.Substate substate = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSubstate() {

      substate_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dataproc.v1.ClusterStatus)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dataproc.v1.ClusterStatus)
  private static final com.google.cloud.dataproc.v1.ClusterStatus DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dataproc.v1.ClusterStatus();
  }

  public static com.google.cloud.dataproc.v1.ClusterStatus getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ClusterStatus> PARSER =
      new com.google.protobuf.AbstractParser<ClusterStatus>() {
        @java.lang.Override
        public ClusterStatus parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ClusterStatus> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ClusterStatus> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dataproc.v1.ClusterStatus getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
