/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dataproc/v1/shared.proto

package com.google.cloud.dataproc.v1;

/**
 *
 *
 * <pre>
 * The configuration of a GKE NodePool used by a [Dataproc-on-GKE
 * cluster](https://cloud.google.com/dataproc/docs/concepts/jobs/dataproc-gke#create-a-dataproc-on-gke-cluster).
 * </pre>
 *
 * Protobuf type {@code google.cloud.dataproc.v1.GkeNodePoolConfig}
 */
public final class GkeNodePoolConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dataproc.v1.GkeNodePoolConfig)
    GkeNodePoolConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use GkeNodePoolConfig.newBuilder() to construct.
  private GkeNodePoolConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private GkeNodePoolConfig() {
    locations_ = com.google.protobuf.LazyStringArrayList.EMPTY;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new GkeNodePoolConfig();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dataproc.v1.SharedProto
        .internal_static_google_cloud_dataproc_v1_GkeNodePoolConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dataproc.v1.SharedProto
        .internal_static_google_cloud_dataproc_v1_GkeNodePoolConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dataproc.v1.GkeNodePoolConfig.class,
            com.google.cloud.dataproc.v1.GkeNodePoolConfig.Builder.class);
  }

  public interface GkeNodeConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Optional. The name of a Compute Engine [machine
     * type](https://cloud.google.com/compute/docs/machine-types).
     * </pre>
     *
     * <code>string machine_type = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The machineType.
     */
    java.lang.String getMachineType();
    /**
     *
     *
     * <pre>
     * Optional. The name of a Compute Engine [machine
     * type](https://cloud.google.com/compute/docs/machine-types).
     * </pre>
     *
     * <code>string machine_type = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for machineType.
     */
    com.google.protobuf.ByteString getMachineTypeBytes();

    /**
     *
     *
     * <pre>
     * Optional. Whether the nodes are created as [preemptible VM
     * instances](https://cloud.google.com/compute/docs/instances/preemptible).
     * </pre>
     *
     * <code>bool preemptible = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The preemptible.
     */
    boolean getPreemptible();

    /**
     *
     *
     * <pre>
     * Optional. The number of local SSD disks to attach to the node, which is limited by
     * the maximum number of disks allowable per zone (see [Adding Local
     * SSDs](https://cloud.google.com/compute/docs/disks/local-ssd)).
     * </pre>
     *
     * <code>int32 local_ssd_count = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The localSsdCount.
     */
    int getLocalSsdCount();

    /**
     *
     *
     * <pre>
     * Optional. A list of [hardware
     * accelerators](https://cloud.google.com/compute/docs/gpus) to attach to
     * each node.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig accelerators = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    java.util.List<com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig>
        getAcceleratorsList();
    /**
     *
     *
     * <pre>
     * Optional. A list of [hardware
     * accelerators](https://cloud.google.com/compute/docs/gpus) to attach to
     * each node.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig accelerators = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig getAccelerators(
        int index);
    /**
     *
     *
     * <pre>
     * Optional. A list of [hardware
     * accelerators](https://cloud.google.com/compute/docs/gpus) to attach to
     * each node.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig accelerators = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    int getAcceleratorsCount();
    /**
     *
     *
     * <pre>
     * Optional. A list of [hardware
     * accelerators](https://cloud.google.com/compute/docs/gpus) to attach to
     * each node.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig accelerators = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    java.util.List<
            ? extends
                com.google.cloud.dataproc.v1.GkeNodePoolConfig
                    .GkeNodePoolAcceleratorConfigOrBuilder>
        getAcceleratorsOrBuilderList();
    /**
     *
     *
     * <pre>
     * Optional. A list of [hardware
     * accelerators](https://cloud.google.com/compute/docs/gpus) to attach to
     * each node.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig accelerators = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfigOrBuilder
        getAcceleratorsOrBuilder(int index);

    /**
     *
     *
     * <pre>
     * Optional. [Minimum CPU
     * platform](https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform)
     * to be used by this instance. The instance may be scheduled on the
     * specified or a newer CPU platform. Specify the friendly names of CPU
     * platforms, such as "Intel Haswell"` or Intel Sandy Bridge".
     * </pre>
     *
     * <code>string min_cpu_platform = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The minCpuPlatform.
     */
    java.lang.String getMinCpuPlatform();
    /**
     *
     *
     * <pre>
     * Optional. [Minimum CPU
     * platform](https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform)
     * to be used by this instance. The instance may be scheduled on the
     * specified or a newer CPU platform. Specify the friendly names of CPU
     * platforms, such as "Intel Haswell"` or Intel Sandy Bridge".
     * </pre>
     *
     * <code>string min_cpu_platform = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for minCpuPlatform.
     */
    com.google.protobuf.ByteString getMinCpuPlatformBytes();
  }
  /**
   *
   *
   * <pre>
   * Parameters that describe cluster nodes.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig}
   */
  public static final class GkeNodeConfig extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig)
      GkeNodeConfigOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use GkeNodeConfig.newBuilder() to construct.
    private GkeNodeConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private GkeNodeConfig() {
      machineType_ = "";
      accelerators_ = java.util.Collections.emptyList();
      minCpuPlatform_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new GkeNodeConfig();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dataproc.v1.SharedProto
          .internal_static_google_cloud_dataproc_v1_GkeNodePoolConfig_GkeNodeConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dataproc.v1.SharedProto
          .internal_static_google_cloud_dataproc_v1_GkeNodePoolConfig_GkeNodeConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig.class,
              com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig.Builder.class);
    }

    public static final int MACHINE_TYPE_FIELD_NUMBER = 1;
    private volatile java.lang.Object machineType_;
    /**
     *
     *
     * <pre>
     * Optional. The name of a Compute Engine [machine
     * type](https://cloud.google.com/compute/docs/machine-types).
     * </pre>
     *
     * <code>string machine_type = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The machineType.
     */
    @java.lang.Override
    public java.lang.String getMachineType() {
      java.lang.Object ref = machineType_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        machineType_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The name of a Compute Engine [machine
     * type](https://cloud.google.com/compute/docs/machine-types).
     * </pre>
     *
     * <code>string machine_type = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for machineType.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getMachineTypeBytes() {
      java.lang.Object ref = machineType_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        machineType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int PREEMPTIBLE_FIELD_NUMBER = 10;
    private boolean preemptible_;
    /**
     *
     *
     * <pre>
     * Optional. Whether the nodes are created as [preemptible VM
     * instances](https://cloud.google.com/compute/docs/instances/preemptible).
     * </pre>
     *
     * <code>bool preemptible = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The preemptible.
     */
    @java.lang.Override
    public boolean getPreemptible() {
      return preemptible_;
    }

    public static final int LOCAL_SSD_COUNT_FIELD_NUMBER = 7;
    private int localSsdCount_;
    /**
     *
     *
     * <pre>
     * Optional. The number of local SSD disks to attach to the node, which is limited by
     * the maximum number of disks allowable per zone (see [Adding Local
     * SSDs](https://cloud.google.com/compute/docs/disks/local-ssd)).
     * </pre>
     *
     * <code>int32 local_ssd_count = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The localSsdCount.
     */
    @java.lang.Override
    public int getLocalSsdCount() {
      return localSsdCount_;
    }

    public static final int ACCELERATORS_FIELD_NUMBER = 11;
    private java.util.List<
            com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig>
        accelerators_;
    /**
     *
     *
     * <pre>
     * Optional. A list of [hardware
     * accelerators](https://cloud.google.com/compute/docs/gpus) to attach to
     * each node.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig accelerators = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig>
        getAcceleratorsList() {
      return accelerators_;
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of [hardware
     * accelerators](https://cloud.google.com/compute/docs/gpus) to attach to
     * each node.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig accelerators = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends
                com.google.cloud.dataproc.v1.GkeNodePoolConfig
                    .GkeNodePoolAcceleratorConfigOrBuilder>
        getAcceleratorsOrBuilderList() {
      return accelerators_;
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of [hardware
     * accelerators](https://cloud.google.com/compute/docs/gpus) to attach to
     * each node.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig accelerators = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public int getAcceleratorsCount() {
      return accelerators_.size();
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of [hardware
     * accelerators](https://cloud.google.com/compute/docs/gpus) to attach to
     * each node.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig accelerators = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig
        getAccelerators(int index) {
      return accelerators_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of [hardware
     * accelerators](https://cloud.google.com/compute/docs/gpus) to attach to
     * each node.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig accelerators = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfigOrBuilder
        getAcceleratorsOrBuilder(int index) {
      return accelerators_.get(index);
    }

    public static final int MIN_CPU_PLATFORM_FIELD_NUMBER = 13;
    private volatile java.lang.Object minCpuPlatform_;
    /**
     *
     *
     * <pre>
     * Optional. [Minimum CPU
     * platform](https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform)
     * to be used by this instance. The instance may be scheduled on the
     * specified or a newer CPU platform. Specify the friendly names of CPU
     * platforms, such as "Intel Haswell"` or Intel Sandy Bridge".
     * </pre>
     *
     * <code>string min_cpu_platform = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The minCpuPlatform.
     */
    @java.lang.Override
    public java.lang.String getMinCpuPlatform() {
      java.lang.Object ref = minCpuPlatform_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        minCpuPlatform_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. [Minimum CPU
     * platform](https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform)
     * to be used by this instance. The instance may be scheduled on the
     * specified or a newer CPU platform. Specify the friendly names of CPU
     * platforms, such as "Intel Haswell"` or Intel Sandy Bridge".
     * </pre>
     *
     * <code>string min_cpu_platform = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for minCpuPlatform.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getMinCpuPlatformBytes() {
      java.lang.Object ref = minCpuPlatform_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        minCpuPlatform_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(machineType_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, machineType_);
      }
      if (localSsdCount_ != 0) {
        output.writeInt32(7, localSsdCount_);
      }
      if (preemptible_ != false) {
        output.writeBool(10, preemptible_);
      }
      for (int i = 0; i < accelerators_.size(); i++) {
        output.writeMessage(11, accelerators_.get(i));
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(minCpuPlatform_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 13, minCpuPlatform_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(machineType_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, machineType_);
      }
      if (localSsdCount_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(7, localSsdCount_);
      }
      if (preemptible_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(10, preemptible_);
      }
      for (int i = 0; i < accelerators_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(11, accelerators_.get(i));
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(minCpuPlatform_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(13, minCpuPlatform_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig)) {
        return super.equals(obj);
      }
      com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig other =
          (com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig) obj;

      if (!getMachineType().equals(other.getMachineType())) return false;
      if (getPreemptible() != other.getPreemptible()) return false;
      if (getLocalSsdCount() != other.getLocalSsdCount()) return false;
      if (!getAcceleratorsList().equals(other.getAcceleratorsList())) return false;
      if (!getMinCpuPlatform().equals(other.getMinCpuPlatform())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + MACHINE_TYPE_FIELD_NUMBER;
      hash = (53 * hash) + getMachineType().hashCode();
      hash = (37 * hash) + PREEMPTIBLE_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getPreemptible());
      hash = (37 * hash) + LOCAL_SSD_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + getLocalSsdCount();
      if (getAcceleratorsCount() > 0) {
        hash = (37 * hash) + ACCELERATORS_FIELD_NUMBER;
        hash = (53 * hash) + getAcceleratorsList().hashCode();
      }
      hash = (37 * hash) + MIN_CPU_PLATFORM_FIELD_NUMBER;
      hash = (53 * hash) + getMinCpuPlatform().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Parameters that describe cluster nodes.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig)
        com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dataproc.v1.SharedProto
            .internal_static_google_cloud_dataproc_v1_GkeNodePoolConfig_GkeNodeConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dataproc.v1.SharedProto
            .internal_static_google_cloud_dataproc_v1_GkeNodePoolConfig_GkeNodeConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig.class,
                com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig.Builder.class);
      }

      // Construct using com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        machineType_ = "";

        preemptible_ = false;

        localSsdCount_ = 0;

        if (acceleratorsBuilder_ == null) {
          accelerators_ = java.util.Collections.emptyList();
        } else {
          accelerators_ = null;
          acceleratorsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        minCpuPlatform_ = "";

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dataproc.v1.SharedProto
            .internal_static_google_cloud_dataproc_v1_GkeNodePoolConfig_GkeNodeConfig_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig
          getDefaultInstanceForType() {
        return com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig build() {
        com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig buildPartial() {
        com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig result =
            new com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig(this);
        int from_bitField0_ = bitField0_;
        result.machineType_ = machineType_;
        result.preemptible_ = preemptible_;
        result.localSsdCount_ = localSsdCount_;
        if (acceleratorsBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            accelerators_ = java.util.Collections.unmodifiableList(accelerators_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.accelerators_ = accelerators_;
        } else {
          result.accelerators_ = acceleratorsBuilder_.build();
        }
        result.minCpuPlatform_ = minCpuPlatform_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig) {
          return mergeFrom((com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig other) {
        if (other
            == com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig.getDefaultInstance())
          return this;
        if (!other.getMachineType().isEmpty()) {
          machineType_ = other.machineType_;
          onChanged();
        }
        if (other.getPreemptible() != false) {
          setPreemptible(other.getPreemptible());
        }
        if (other.getLocalSsdCount() != 0) {
          setLocalSsdCount(other.getLocalSsdCount());
        }
        if (acceleratorsBuilder_ == null) {
          if (!other.accelerators_.isEmpty()) {
            if (accelerators_.isEmpty()) {
              accelerators_ = other.accelerators_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureAcceleratorsIsMutable();
              accelerators_.addAll(other.accelerators_);
            }
            onChanged();
          }
        } else {
          if (!other.accelerators_.isEmpty()) {
            if (acceleratorsBuilder_.isEmpty()) {
              acceleratorsBuilder_.dispose();
              acceleratorsBuilder_ = null;
              accelerators_ = other.accelerators_;
              bitField0_ = (bitField0_ & ~0x00000001);
              acceleratorsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getAcceleratorsFieldBuilder()
                      : null;
            } else {
              acceleratorsBuilder_.addAllMessages(other.accelerators_);
            }
          }
        }
        if (!other.getMinCpuPlatform().isEmpty()) {
          minCpuPlatform_ = other.minCpuPlatform_;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  machineType_ = input.readStringRequireUtf8();

                  break;
                } // case 10
              case 56:
                {
                  localSsdCount_ = input.readInt32();

                  break;
                } // case 56
              case 80:
                {
                  preemptible_ = input.readBool();

                  break;
                } // case 80
              case 90:
                {
                  com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig m =
                      input.readMessage(
                          com.google.cloud.dataproc.v1.GkeNodePoolConfig
                              .GkeNodePoolAcceleratorConfig.parser(),
                          extensionRegistry);
                  if (acceleratorsBuilder_ == null) {
                    ensureAcceleratorsIsMutable();
                    accelerators_.add(m);
                  } else {
                    acceleratorsBuilder_.addMessage(m);
                  }
                  break;
                } // case 90
              case 106:
                {
                  minCpuPlatform_ = input.readStringRequireUtf8();

                  break;
                } // case 106
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object machineType_ = "";
      /**
       *
       *
       * <pre>
       * Optional. The name of a Compute Engine [machine
       * type](https://cloud.google.com/compute/docs/machine-types).
       * </pre>
       *
       * <code>string machine_type = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The machineType.
       */
      public java.lang.String getMachineType() {
        java.lang.Object ref = machineType_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          machineType_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The name of a Compute Engine [machine
       * type](https://cloud.google.com/compute/docs/machine-types).
       * </pre>
       *
       * <code>string machine_type = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for machineType.
       */
      public com.google.protobuf.ByteString getMachineTypeBytes() {
        java.lang.Object ref = machineType_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          machineType_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The name of a Compute Engine [machine
       * type](https://cloud.google.com/compute/docs/machine-types).
       * </pre>
       *
       * <code>string machine_type = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The machineType to set.
       * @return This builder for chaining.
       */
      public Builder setMachineType(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        machineType_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The name of a Compute Engine [machine
       * type](https://cloud.google.com/compute/docs/machine-types).
       * </pre>
       *
       * <code>string machine_type = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMachineType() {

        machineType_ = getDefaultInstance().getMachineType();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The name of a Compute Engine [machine
       * type](https://cloud.google.com/compute/docs/machine-types).
       * </pre>
       *
       * <code>string machine_type = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The bytes for machineType to set.
       * @return This builder for chaining.
       */
      public Builder setMachineTypeBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        machineType_ = value;
        onChanged();
        return this;
      }

      private boolean preemptible_;
      /**
       *
       *
       * <pre>
       * Optional. Whether the nodes are created as [preemptible VM
       * instances](https://cloud.google.com/compute/docs/instances/preemptible).
       * </pre>
       *
       * <code>bool preemptible = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The preemptible.
       */
      @java.lang.Override
      public boolean getPreemptible() {
        return preemptible_;
      }
      /**
       *
       *
       * <pre>
       * Optional. Whether the nodes are created as [preemptible VM
       * instances](https://cloud.google.com/compute/docs/instances/preemptible).
       * </pre>
       *
       * <code>bool preemptible = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The preemptible to set.
       * @return This builder for chaining.
       */
      public Builder setPreemptible(boolean value) {

        preemptible_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Whether the nodes are created as [preemptible VM
       * instances](https://cloud.google.com/compute/docs/instances/preemptible).
       * </pre>
       *
       * <code>bool preemptible = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPreemptible() {

        preemptible_ = false;
        onChanged();
        return this;
      }

      private int localSsdCount_;
      /**
       *
       *
       * <pre>
       * Optional. The number of local SSD disks to attach to the node, which is limited by
       * the maximum number of disks allowable per zone (see [Adding Local
       * SSDs](https://cloud.google.com/compute/docs/disks/local-ssd)).
       * </pre>
       *
       * <code>int32 local_ssd_count = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The localSsdCount.
       */
      @java.lang.Override
      public int getLocalSsdCount() {
        return localSsdCount_;
      }
      /**
       *
       *
       * <pre>
       * Optional. The number of local SSD disks to attach to the node, which is limited by
       * the maximum number of disks allowable per zone (see [Adding Local
       * SSDs](https://cloud.google.com/compute/docs/disks/local-ssd)).
       * </pre>
       *
       * <code>int32 local_ssd_count = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The localSsdCount to set.
       * @return This builder for chaining.
       */
      public Builder setLocalSsdCount(int value) {

        localSsdCount_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The number of local SSD disks to attach to the node, which is limited by
       * the maximum number of disks allowable per zone (see [Adding Local
       * SSDs](https://cloud.google.com/compute/docs/disks/local-ssd)).
       * </pre>
       *
       * <code>int32 local_ssd_count = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearLocalSsdCount() {

        localSsdCount_ = 0;
        onChanged();
        return this;
      }

      private java.util.List<
              com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig>
          accelerators_ = java.util.Collections.emptyList();

      private void ensureAcceleratorsIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          accelerators_ =
              new java.util.ArrayList<
                  com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig>(
                  accelerators_);
          bitField0_ |= 0x00000001;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig,
              com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig.Builder,
              com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfigOrBuilder>
          acceleratorsBuilder_;

      /**
       *
       *
       * <pre>
       * Optional. A list of [hardware
       * accelerators](https://cloud.google.com/compute/docs/gpus) to attach to
       * each node.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig accelerators = 11 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public java.util.List<
              com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig>
          getAcceleratorsList() {
        if (acceleratorsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(accelerators_);
        } else {
          return acceleratorsBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. A list of [hardware
       * accelerators](https://cloud.google.com/compute/docs/gpus) to attach to
       * each node.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig accelerators = 11 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public int getAcceleratorsCount() {
        if (acceleratorsBuilder_ == null) {
          return accelerators_.size();
        } else {
          return acceleratorsBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. A list of [hardware
       * accelerators](https://cloud.google.com/compute/docs/gpus) to attach to
       * each node.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig accelerators = 11 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig
          getAccelerators(int index) {
        if (acceleratorsBuilder_ == null) {
          return accelerators_.get(index);
        } else {
          return acceleratorsBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. A list of [hardware
       * accelerators](https://cloud.google.com/compute/docs/gpus) to attach to
       * each node.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig accelerators = 11 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setAccelerators(
          int index,
          com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig value) {
        if (acceleratorsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureAcceleratorsIsMutable();
          accelerators_.set(index, value);
          onChanged();
        } else {
          acceleratorsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. A list of [hardware
       * accelerators](https://cloud.google.com/compute/docs/gpus) to attach to
       * each node.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig accelerators = 11 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setAccelerators(
          int index,
          com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig.Builder
              builderForValue) {
        if (acceleratorsBuilder_ == null) {
          ensureAcceleratorsIsMutable();
          accelerators_.set(index, builderForValue.build());
          onChanged();
        } else {
          acceleratorsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. A list of [hardware
       * accelerators](https://cloud.google.com/compute/docs/gpus) to attach to
       * each node.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig accelerators = 11 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder addAccelerators(
          com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig value) {
        if (acceleratorsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureAcceleratorsIsMutable();
          accelerators_.add(value);
          onChanged();
        } else {
          acceleratorsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. A list of [hardware
       * accelerators](https://cloud.google.com/compute/docs/gpus) to attach to
       * each node.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig accelerators = 11 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder addAccelerators(
          int index,
          com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig value) {
        if (acceleratorsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureAcceleratorsIsMutable();
          accelerators_.add(index, value);
          onChanged();
        } else {
          acceleratorsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. A list of [hardware
       * accelerators](https://cloud.google.com/compute/docs/gpus) to attach to
       * each node.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig accelerators = 11 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder addAccelerators(
          com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig.Builder
              builderForValue) {
        if (acceleratorsBuilder_ == null) {
          ensureAcceleratorsIsMutable();
          accelerators_.add(builderForValue.build());
          onChanged();
        } else {
          acceleratorsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. A list of [hardware
       * accelerators](https://cloud.google.com/compute/docs/gpus) to attach to
       * each node.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig accelerators = 11 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder addAccelerators(
          int index,
          com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig.Builder
              builderForValue) {
        if (acceleratorsBuilder_ == null) {
          ensureAcceleratorsIsMutable();
          accelerators_.add(index, builderForValue.build());
          onChanged();
        } else {
          acceleratorsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. A list of [hardware
       * accelerators](https://cloud.google.com/compute/docs/gpus) to attach to
       * each node.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig accelerators = 11 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder addAllAccelerators(
          java.lang.Iterable<
                  ? extends
                      com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig>
              values) {
        if (acceleratorsBuilder_ == null) {
          ensureAcceleratorsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, accelerators_);
          onChanged();
        } else {
          acceleratorsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. A list of [hardware
       * accelerators](https://cloud.google.com/compute/docs/gpus) to attach to
       * each node.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig accelerators = 11 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder clearAccelerators() {
        if (acceleratorsBuilder_ == null) {
          accelerators_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          acceleratorsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. A list of [hardware
       * accelerators](https://cloud.google.com/compute/docs/gpus) to attach to
       * each node.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig accelerators = 11 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder removeAccelerators(int index) {
        if (acceleratorsBuilder_ == null) {
          ensureAcceleratorsIsMutable();
          accelerators_.remove(index);
          onChanged();
        } else {
          acceleratorsBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. A list of [hardware
       * accelerators](https://cloud.google.com/compute/docs/gpus) to attach to
       * each node.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig accelerators = 11 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig.Builder
          getAcceleratorsBuilder(int index) {
        return getAcceleratorsFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * Optional. A list of [hardware
       * accelerators](https://cloud.google.com/compute/docs/gpus) to attach to
       * each node.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig accelerators = 11 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfigOrBuilder
          getAcceleratorsOrBuilder(int index) {
        if (acceleratorsBuilder_ == null) {
          return accelerators_.get(index);
        } else {
          return acceleratorsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. A list of [hardware
       * accelerators](https://cloud.google.com/compute/docs/gpus) to attach to
       * each node.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig accelerators = 11 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public java.util.List<
              ? extends
                  com.google.cloud.dataproc.v1.GkeNodePoolConfig
                      .GkeNodePoolAcceleratorConfigOrBuilder>
          getAcceleratorsOrBuilderList() {
        if (acceleratorsBuilder_ != null) {
          return acceleratorsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(accelerators_);
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. A list of [hardware
       * accelerators](https://cloud.google.com/compute/docs/gpus) to attach to
       * each node.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig accelerators = 11 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig.Builder
          addAcceleratorsBuilder() {
        return getAcceleratorsFieldBuilder()
            .addBuilder(
                com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Optional. A list of [hardware
       * accelerators](https://cloud.google.com/compute/docs/gpus) to attach to
       * each node.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig accelerators = 11 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig.Builder
          addAcceleratorsBuilder(int index) {
        return getAcceleratorsFieldBuilder()
            .addBuilder(
                index,
                com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Optional. A list of [hardware
       * accelerators](https://cloud.google.com/compute/docs/gpus) to attach to
       * each node.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig accelerators = 11 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public java.util.List<
              com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig.Builder>
          getAcceleratorsBuilderList() {
        return getAcceleratorsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig,
              com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig.Builder,
              com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfigOrBuilder>
          getAcceleratorsFieldBuilder() {
        if (acceleratorsBuilder_ == null) {
          acceleratorsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig,
                  com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig
                      .Builder,
                  com.google.cloud.dataproc.v1.GkeNodePoolConfig
                      .GkeNodePoolAcceleratorConfigOrBuilder>(
                  accelerators_,
                  ((bitField0_ & 0x00000001) != 0),
                  getParentForChildren(),
                  isClean());
          accelerators_ = null;
        }
        return acceleratorsBuilder_;
      }

      private java.lang.Object minCpuPlatform_ = "";
      /**
       *
       *
       * <pre>
       * Optional. [Minimum CPU
       * platform](https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform)
       * to be used by this instance. The instance may be scheduled on the
       * specified or a newer CPU platform. Specify the friendly names of CPU
       * platforms, such as "Intel Haswell"` or Intel Sandy Bridge".
       * </pre>
       *
       * <code>string min_cpu_platform = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The minCpuPlatform.
       */
      public java.lang.String getMinCpuPlatform() {
        java.lang.Object ref = minCpuPlatform_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          minCpuPlatform_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. [Minimum CPU
       * platform](https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform)
       * to be used by this instance. The instance may be scheduled on the
       * specified or a newer CPU platform. Specify the friendly names of CPU
       * platforms, such as "Intel Haswell"` or Intel Sandy Bridge".
       * </pre>
       *
       * <code>string min_cpu_platform = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for minCpuPlatform.
       */
      public com.google.protobuf.ByteString getMinCpuPlatformBytes() {
        java.lang.Object ref = minCpuPlatform_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          minCpuPlatform_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. [Minimum CPU
       * platform](https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform)
       * to be used by this instance. The instance may be scheduled on the
       * specified or a newer CPU platform. Specify the friendly names of CPU
       * platforms, such as "Intel Haswell"` or Intel Sandy Bridge".
       * </pre>
       *
       * <code>string min_cpu_platform = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The minCpuPlatform to set.
       * @return This builder for chaining.
       */
      public Builder setMinCpuPlatform(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        minCpuPlatform_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. [Minimum CPU
       * platform](https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform)
       * to be used by this instance. The instance may be scheduled on the
       * specified or a newer CPU platform. Specify the friendly names of CPU
       * platforms, such as "Intel Haswell"` or Intel Sandy Bridge".
       * </pre>
       *
       * <code>string min_cpu_platform = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMinCpuPlatform() {

        minCpuPlatform_ = getDefaultInstance().getMinCpuPlatform();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. [Minimum CPU
       * platform](https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform)
       * to be used by this instance. The instance may be scheduled on the
       * specified or a newer CPU platform. Specify the friendly names of CPU
       * platforms, such as "Intel Haswell"` or Intel Sandy Bridge".
       * </pre>
       *
       * <code>string min_cpu_platform = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The bytes for minCpuPlatform to set.
       * @return This builder for chaining.
       */
      public Builder setMinCpuPlatformBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        minCpuPlatform_ = value;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig)
    private static final com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig();
    }

    public static com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<GkeNodeConfig> PARSER =
        new com.google.protobuf.AbstractParser<GkeNodeConfig>() {
          @java.lang.Override
          public GkeNodeConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<GkeNodeConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<GkeNodeConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface GkeNodePoolAcceleratorConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The number of accelerator cards exposed to an instance.
     * </pre>
     *
     * <code>int64 accelerator_count = 1;</code>
     *
     * @return The acceleratorCount.
     */
    long getAcceleratorCount();

    /**
     *
     *
     * <pre>
     * The accelerator type resource namename (see GPUs on Compute Engine).
     * </pre>
     *
     * <code>string accelerator_type = 2;</code>
     *
     * @return The acceleratorType.
     */
    java.lang.String getAcceleratorType();
    /**
     *
     *
     * <pre>
     * The accelerator type resource namename (see GPUs on Compute Engine).
     * </pre>
     *
     * <code>string accelerator_type = 2;</code>
     *
     * @return The bytes for acceleratorType.
     */
    com.google.protobuf.ByteString getAcceleratorTypeBytes();
  }
  /**
   *
   *
   * <pre>
   * A GkeNodeConfigAcceleratorConfig represents a Hardware Accelerator request
   * for a NodePool.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig}
   */
  public static final class GkeNodePoolAcceleratorConfig
      extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig)
      GkeNodePoolAcceleratorConfigOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use GkeNodePoolAcceleratorConfig.newBuilder() to construct.
    private GkeNodePoolAcceleratorConfig(
        com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private GkeNodePoolAcceleratorConfig() {
      acceleratorType_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new GkeNodePoolAcceleratorConfig();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dataproc.v1.SharedProto
          .internal_static_google_cloud_dataproc_v1_GkeNodePoolConfig_GkeNodePoolAcceleratorConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dataproc.v1.SharedProto
          .internal_static_google_cloud_dataproc_v1_GkeNodePoolConfig_GkeNodePoolAcceleratorConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig.class,
              com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig.Builder
                  .class);
    }

    public static final int ACCELERATOR_COUNT_FIELD_NUMBER = 1;
    private long acceleratorCount_;
    /**
     *
     *
     * <pre>
     * The number of accelerator cards exposed to an instance.
     * </pre>
     *
     * <code>int64 accelerator_count = 1;</code>
     *
     * @return The acceleratorCount.
     */
    @java.lang.Override
    public long getAcceleratorCount() {
      return acceleratorCount_;
    }

    public static final int ACCELERATOR_TYPE_FIELD_NUMBER = 2;
    private volatile java.lang.Object acceleratorType_;
    /**
     *
     *
     * <pre>
     * The accelerator type resource namename (see GPUs on Compute Engine).
     * </pre>
     *
     * <code>string accelerator_type = 2;</code>
     *
     * @return The acceleratorType.
     */
    @java.lang.Override
    public java.lang.String getAcceleratorType() {
      java.lang.Object ref = acceleratorType_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        acceleratorType_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The accelerator type resource namename (see GPUs on Compute Engine).
     * </pre>
     *
     * <code>string accelerator_type = 2;</code>
     *
     * @return The bytes for acceleratorType.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getAcceleratorTypeBytes() {
      java.lang.Object ref = acceleratorType_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        acceleratorType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (acceleratorCount_ != 0L) {
        output.writeInt64(1, acceleratorCount_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(acceleratorType_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, acceleratorType_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (acceleratorCount_ != 0L) {
        size += com.google.protobuf.CodedOutputStream.computeInt64Size(1, acceleratorCount_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(acceleratorType_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, acceleratorType_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig)) {
        return super.equals(obj);
      }
      com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig other =
          (com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig) obj;

      if (getAcceleratorCount() != other.getAcceleratorCount()) return false;
      if (!getAcceleratorType().equals(other.getAcceleratorType())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + ACCELERATOR_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getAcceleratorCount());
      hash = (37 * hash) + ACCELERATOR_TYPE_FIELD_NUMBER;
      hash = (53 * hash) + getAcceleratorType().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A GkeNodeConfigAcceleratorConfig represents a Hardware Accelerator request
     * for a NodePool.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig)
        com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dataproc.v1.SharedProto
            .internal_static_google_cloud_dataproc_v1_GkeNodePoolConfig_GkeNodePoolAcceleratorConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dataproc.v1.SharedProto
            .internal_static_google_cloud_dataproc_v1_GkeNodePoolConfig_GkeNodePoolAcceleratorConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig.class,
                com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        acceleratorCount_ = 0L;

        acceleratorType_ = "";

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dataproc.v1.SharedProto
            .internal_static_google_cloud_dataproc_v1_GkeNodePoolConfig_GkeNodePoolAcceleratorConfig_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig
          getDefaultInstanceForType() {
        return com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig build() {
        com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig
          buildPartial() {
        com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig result =
            new com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig(this);
        result.acceleratorCount_ = acceleratorCount_;
        result.acceleratorType_ = acceleratorType_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig) {
          return mergeFrom(
              (com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig other) {
        if (other
            == com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig
                .getDefaultInstance()) return this;
        if (other.getAcceleratorCount() != 0L) {
          setAcceleratorCount(other.getAcceleratorCount());
        }
        if (!other.getAcceleratorType().isEmpty()) {
          acceleratorType_ = other.acceleratorType_;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  acceleratorCount_ = input.readInt64();

                  break;
                } // case 8
              case 18:
                {
                  acceleratorType_ = input.readStringRequireUtf8();

                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private long acceleratorCount_;
      /**
       *
       *
       * <pre>
       * The number of accelerator cards exposed to an instance.
       * </pre>
       *
       * <code>int64 accelerator_count = 1;</code>
       *
       * @return The acceleratorCount.
       */
      @java.lang.Override
      public long getAcceleratorCount() {
        return acceleratorCount_;
      }
      /**
       *
       *
       * <pre>
       * The number of accelerator cards exposed to an instance.
       * </pre>
       *
       * <code>int64 accelerator_count = 1;</code>
       *
       * @param value The acceleratorCount to set.
       * @return This builder for chaining.
       */
      public Builder setAcceleratorCount(long value) {

        acceleratorCount_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The number of accelerator cards exposed to an instance.
       * </pre>
       *
       * <code>int64 accelerator_count = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAcceleratorCount() {

        acceleratorCount_ = 0L;
        onChanged();
        return this;
      }

      private java.lang.Object acceleratorType_ = "";
      /**
       *
       *
       * <pre>
       * The accelerator type resource namename (see GPUs on Compute Engine).
       * </pre>
       *
       * <code>string accelerator_type = 2;</code>
       *
       * @return The acceleratorType.
       */
      public java.lang.String getAcceleratorType() {
        java.lang.Object ref = acceleratorType_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          acceleratorType_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The accelerator type resource namename (see GPUs on Compute Engine).
       * </pre>
       *
       * <code>string accelerator_type = 2;</code>
       *
       * @return The bytes for acceleratorType.
       */
      public com.google.protobuf.ByteString getAcceleratorTypeBytes() {
        java.lang.Object ref = acceleratorType_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          acceleratorType_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The accelerator type resource namename (see GPUs on Compute Engine).
       * </pre>
       *
       * <code>string accelerator_type = 2;</code>
       *
       * @param value The acceleratorType to set.
       * @return This builder for chaining.
       */
      public Builder setAcceleratorType(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        acceleratorType_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The accelerator type resource namename (see GPUs on Compute Engine).
       * </pre>
       *
       * <code>string accelerator_type = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAcceleratorType() {

        acceleratorType_ = getDefaultInstance().getAcceleratorType();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The accelerator type resource namename (see GPUs on Compute Engine).
       * </pre>
       *
       * <code>string accelerator_type = 2;</code>
       *
       * @param value The bytes for acceleratorType to set.
       * @return This builder for chaining.
       */
      public Builder setAcceleratorTypeBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        acceleratorType_ = value;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig)
    private static final com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig();
    }

    public static com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<GkeNodePoolAcceleratorConfig> PARSER =
        new com.google.protobuf.AbstractParser<GkeNodePoolAcceleratorConfig>() {
          @java.lang.Override
          public GkeNodePoolAcceleratorConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<GkeNodePoolAcceleratorConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<GkeNodePoolAcceleratorConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAcceleratorConfig
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface GkeNodePoolAutoscalingConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The minimum number of nodes in the NodePool. Must be &gt;= 0 and &lt;=
     * max_node_count.
     * </pre>
     *
     * <code>int32 min_node_count = 2;</code>
     *
     * @return The minNodeCount.
     */
    int getMinNodeCount();

    /**
     *
     *
     * <pre>
     * The maximum number of nodes in the NodePool. Must be &gt;= min_node_count.
     * **Note:** Quota must be sufficient to scale up the cluster.
     * </pre>
     *
     * <code>int32 max_node_count = 3;</code>
     *
     * @return The maxNodeCount.
     */
    int getMaxNodeCount();
  }
  /**
   *
   *
   * <pre>
   * GkeNodePoolAutoscaling contains information the cluster autoscaler needs to
   * adjust the size of the node pool to the current cluster usage.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig}
   */
  public static final class GkeNodePoolAutoscalingConfig
      extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig)
      GkeNodePoolAutoscalingConfigOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use GkeNodePoolAutoscalingConfig.newBuilder() to construct.
    private GkeNodePoolAutoscalingConfig(
        com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private GkeNodePoolAutoscalingConfig() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new GkeNodePoolAutoscalingConfig();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dataproc.v1.SharedProto
          .internal_static_google_cloud_dataproc_v1_GkeNodePoolConfig_GkeNodePoolAutoscalingConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dataproc.v1.SharedProto
          .internal_static_google_cloud_dataproc_v1_GkeNodePoolConfig_GkeNodePoolAutoscalingConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig.class,
              com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig.Builder
                  .class);
    }

    public static final int MIN_NODE_COUNT_FIELD_NUMBER = 2;
    private int minNodeCount_;
    /**
     *
     *
     * <pre>
     * The minimum number of nodes in the NodePool. Must be &gt;= 0 and &lt;=
     * max_node_count.
     * </pre>
     *
     * <code>int32 min_node_count = 2;</code>
     *
     * @return The minNodeCount.
     */
    @java.lang.Override
    public int getMinNodeCount() {
      return minNodeCount_;
    }

    public static final int MAX_NODE_COUNT_FIELD_NUMBER = 3;
    private int maxNodeCount_;
    /**
     *
     *
     * <pre>
     * The maximum number of nodes in the NodePool. Must be &gt;= min_node_count.
     * **Note:** Quota must be sufficient to scale up the cluster.
     * </pre>
     *
     * <code>int32 max_node_count = 3;</code>
     *
     * @return The maxNodeCount.
     */
    @java.lang.Override
    public int getMaxNodeCount() {
      return maxNodeCount_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (minNodeCount_ != 0) {
        output.writeInt32(2, minNodeCount_);
      }
      if (maxNodeCount_ != 0) {
        output.writeInt32(3, maxNodeCount_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (minNodeCount_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, minNodeCount_);
      }
      if (maxNodeCount_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(3, maxNodeCount_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig)) {
        return super.equals(obj);
      }
      com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig other =
          (com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig) obj;

      if (getMinNodeCount() != other.getMinNodeCount()) return false;
      if (getMaxNodeCount() != other.getMaxNodeCount()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + MIN_NODE_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + getMinNodeCount();
      hash = (37 * hash) + MAX_NODE_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + getMaxNodeCount();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * GkeNodePoolAutoscaling contains information the cluster autoscaler needs to
     * adjust the size of the node pool to the current cluster usage.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig)
        com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dataproc.v1.SharedProto
            .internal_static_google_cloud_dataproc_v1_GkeNodePoolConfig_GkeNodePoolAutoscalingConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dataproc.v1.SharedProto
            .internal_static_google_cloud_dataproc_v1_GkeNodePoolConfig_GkeNodePoolAutoscalingConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig.class,
                com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        minNodeCount_ = 0;

        maxNodeCount_ = 0;

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dataproc.v1.SharedProto
            .internal_static_google_cloud_dataproc_v1_GkeNodePoolConfig_GkeNodePoolAutoscalingConfig_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig
          getDefaultInstanceForType() {
        return com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig build() {
        com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig
          buildPartial() {
        com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig result =
            new com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig(this);
        result.minNodeCount_ = minNodeCount_;
        result.maxNodeCount_ = maxNodeCount_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig) {
          return mergeFrom(
              (com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig other) {
        if (other
            == com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig
                .getDefaultInstance()) return this;
        if (other.getMinNodeCount() != 0) {
          setMinNodeCount(other.getMinNodeCount());
        }
        if (other.getMaxNodeCount() != 0) {
          setMaxNodeCount(other.getMaxNodeCount());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 16:
                {
                  minNodeCount_ = input.readInt32();

                  break;
                } // case 16
              case 24:
                {
                  maxNodeCount_ = input.readInt32();

                  break;
                } // case 24
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int minNodeCount_;
      /**
       *
       *
       * <pre>
       * The minimum number of nodes in the NodePool. Must be &gt;= 0 and &lt;=
       * max_node_count.
       * </pre>
       *
       * <code>int32 min_node_count = 2;</code>
       *
       * @return The minNodeCount.
       */
      @java.lang.Override
      public int getMinNodeCount() {
        return minNodeCount_;
      }
      /**
       *
       *
       * <pre>
       * The minimum number of nodes in the NodePool. Must be &gt;= 0 and &lt;=
       * max_node_count.
       * </pre>
       *
       * <code>int32 min_node_count = 2;</code>
       *
       * @param value The minNodeCount to set.
       * @return This builder for chaining.
       */
      public Builder setMinNodeCount(int value) {

        minNodeCount_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The minimum number of nodes in the NodePool. Must be &gt;= 0 and &lt;=
       * max_node_count.
       * </pre>
       *
       * <code>int32 min_node_count = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMinNodeCount() {

        minNodeCount_ = 0;
        onChanged();
        return this;
      }

      private int maxNodeCount_;
      /**
       *
       *
       * <pre>
       * The maximum number of nodes in the NodePool. Must be &gt;= min_node_count.
       * **Note:** Quota must be sufficient to scale up the cluster.
       * </pre>
       *
       * <code>int32 max_node_count = 3;</code>
       *
       * @return The maxNodeCount.
       */
      @java.lang.Override
      public int getMaxNodeCount() {
        return maxNodeCount_;
      }
      /**
       *
       *
       * <pre>
       * The maximum number of nodes in the NodePool. Must be &gt;= min_node_count.
       * **Note:** Quota must be sufficient to scale up the cluster.
       * </pre>
       *
       * <code>int32 max_node_count = 3;</code>
       *
       * @param value The maxNodeCount to set.
       * @return This builder for chaining.
       */
      public Builder setMaxNodeCount(int value) {

        maxNodeCount_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The maximum number of nodes in the NodePool. Must be &gt;= min_node_count.
       * **Note:** Quota must be sufficient to scale up the cluster.
       * </pre>
       *
       * <code>int32 max_node_count = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMaxNodeCount() {

        maxNodeCount_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig)
    private static final com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig();
    }

    public static com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<GkeNodePoolAutoscalingConfig> PARSER =
        new com.google.protobuf.AbstractParser<GkeNodePoolAutoscalingConfig>() {
          @java.lang.Override
          public GkeNodePoolAutoscalingConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<GkeNodePoolAutoscalingConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<GkeNodePoolAutoscalingConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int CONFIG_FIELD_NUMBER = 2;
  private com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig config_;
  /**
   *
   *
   * <pre>
   * Optional. The node pool configuration.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig config = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the config field is set.
   */
  @java.lang.Override
  public boolean hasConfig() {
    return config_ != null;
  }
  /**
   *
   *
   * <pre>
   * Optional. The node pool configuration.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig config = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The config.
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig getConfig() {
    return config_ == null
        ? com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig.getDefaultInstance()
        : config_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The node pool configuration.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig config = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfigOrBuilder
      getConfigOrBuilder() {
    return getConfig();
  }

  public static final int LOCATIONS_FIELD_NUMBER = 13;
  private com.google.protobuf.LazyStringList locations_;
  /**
   *
   *
   * <pre>
   * Optional. The list of Compute Engine
   * [zones](https://cloud.google.com/compute/docs/zones#available) where
   * NodePool's nodes will be located.
   * **Note:** Currently, only one zone may be specified.
   * If a location is not specified during NodePool creation, Dataproc will
   * choose a location.
   * </pre>
   *
   * <code>repeated string locations = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return A list containing the locations.
   */
  public com.google.protobuf.ProtocolStringList getLocationsList() {
    return locations_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The list of Compute Engine
   * [zones](https://cloud.google.com/compute/docs/zones#available) where
   * NodePool's nodes will be located.
   * **Note:** Currently, only one zone may be specified.
   * If a location is not specified during NodePool creation, Dataproc will
   * choose a location.
   * </pre>
   *
   * <code>repeated string locations = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The count of locations.
   */
  public int getLocationsCount() {
    return locations_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. The list of Compute Engine
   * [zones](https://cloud.google.com/compute/docs/zones#available) where
   * NodePool's nodes will be located.
   * **Note:** Currently, only one zone may be specified.
   * If a location is not specified during NodePool creation, Dataproc will
   * choose a location.
   * </pre>
   *
   * <code>repeated string locations = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the element to return.
   * @return The locations at the given index.
   */
  public java.lang.String getLocations(int index) {
    return locations_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. The list of Compute Engine
   * [zones](https://cloud.google.com/compute/docs/zones#available) where
   * NodePool's nodes will be located.
   * **Note:** Currently, only one zone may be specified.
   * If a location is not specified during NodePool creation, Dataproc will
   * choose a location.
   * </pre>
   *
   * <code>repeated string locations = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the locations at the given index.
   */
  public com.google.protobuf.ByteString getLocationsBytes(int index) {
    return locations_.getByteString(index);
  }

  public static final int AUTOSCALING_FIELD_NUMBER = 4;
  private com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig autoscaling_;
  /**
   *
   *
   * <pre>
   * Optional. The autoscaler configuration for this NodePool. The autoscaler is enabled
   * only when a valid configuration is present.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig autoscaling = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the autoscaling field is set.
   */
  @java.lang.Override
  public boolean hasAutoscaling() {
    return autoscaling_ != null;
  }
  /**
   *
   *
   * <pre>
   * Optional. The autoscaler configuration for this NodePool. The autoscaler is enabled
   * only when a valid configuration is present.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig autoscaling = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The autoscaling.
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig
      getAutoscaling() {
    return autoscaling_ == null
        ? com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig
            .getDefaultInstance()
        : autoscaling_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The autoscaler configuration for this NodePool. The autoscaler is enabled
   * only when a valid configuration is present.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig autoscaling = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfigOrBuilder
      getAutoscalingOrBuilder() {
    return getAutoscaling();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (config_ != null) {
      output.writeMessage(2, getConfig());
    }
    if (autoscaling_ != null) {
      output.writeMessage(4, getAutoscaling());
    }
    for (int i = 0; i < locations_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 13, locations_.getRaw(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (config_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getConfig());
    }
    if (autoscaling_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getAutoscaling());
    }
    {
      int dataSize = 0;
      for (int i = 0; i < locations_.size(); i++) {
        dataSize += computeStringSizeNoTag(locations_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getLocationsList().size();
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dataproc.v1.GkeNodePoolConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.dataproc.v1.GkeNodePoolConfig other =
        (com.google.cloud.dataproc.v1.GkeNodePoolConfig) obj;

    if (hasConfig() != other.hasConfig()) return false;
    if (hasConfig()) {
      if (!getConfig().equals(other.getConfig())) return false;
    }
    if (!getLocationsList().equals(other.getLocationsList())) return false;
    if (hasAutoscaling() != other.hasAutoscaling()) return false;
    if (hasAutoscaling()) {
      if (!getAutoscaling().equals(other.getAutoscaling())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasConfig()) {
      hash = (37 * hash) + CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getConfig().hashCode();
    }
    if (getLocationsCount() > 0) {
      hash = (37 * hash) + LOCATIONS_FIELD_NUMBER;
      hash = (53 * hash) + getLocationsList().hashCode();
    }
    if (hasAutoscaling()) {
      hash = (37 * hash) + AUTOSCALING_FIELD_NUMBER;
      hash = (53 * hash) + getAutoscaling().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dataproc.v1.GkeNodePoolConfig parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1.GkeNodePoolConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.GkeNodePoolConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1.GkeNodePoolConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.GkeNodePoolConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1.GkeNodePoolConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.GkeNodePoolConfig parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1.GkeNodePoolConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.GkeNodePoolConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1.GkeNodePoolConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.GkeNodePoolConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1.GkeNodePoolConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.dataproc.v1.GkeNodePoolConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The configuration of a GKE NodePool used by a [Dataproc-on-GKE
   * cluster](https://cloud.google.com/dataproc/docs/concepts/jobs/dataproc-gke#create-a-dataproc-on-gke-cluster).
   * </pre>
   *
   * Protobuf type {@code google.cloud.dataproc.v1.GkeNodePoolConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dataproc.v1.GkeNodePoolConfig)
      com.google.cloud.dataproc.v1.GkeNodePoolConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dataproc.v1.SharedProto
          .internal_static_google_cloud_dataproc_v1_GkeNodePoolConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dataproc.v1.SharedProto
          .internal_static_google_cloud_dataproc_v1_GkeNodePoolConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dataproc.v1.GkeNodePoolConfig.class,
              com.google.cloud.dataproc.v1.GkeNodePoolConfig.Builder.class);
    }

    // Construct using com.google.cloud.dataproc.v1.GkeNodePoolConfig.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (configBuilder_ == null) {
        config_ = null;
      } else {
        config_ = null;
        configBuilder_ = null;
      }
      locations_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000001);
      if (autoscalingBuilder_ == null) {
        autoscaling_ = null;
      } else {
        autoscaling_ = null;
        autoscalingBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dataproc.v1.SharedProto
          .internal_static_google_cloud_dataproc_v1_GkeNodePoolConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.GkeNodePoolConfig getDefaultInstanceForType() {
      return com.google.cloud.dataproc.v1.GkeNodePoolConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.GkeNodePoolConfig build() {
      com.google.cloud.dataproc.v1.GkeNodePoolConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.GkeNodePoolConfig buildPartial() {
      com.google.cloud.dataproc.v1.GkeNodePoolConfig result =
          new com.google.cloud.dataproc.v1.GkeNodePoolConfig(this);
      int from_bitField0_ = bitField0_;
      if (configBuilder_ == null) {
        result.config_ = config_;
      } else {
        result.config_ = configBuilder_.build();
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        locations_ = locations_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000001);
      }
      result.locations_ = locations_;
      if (autoscalingBuilder_ == null) {
        result.autoscaling_ = autoscaling_;
      } else {
        result.autoscaling_ = autoscalingBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dataproc.v1.GkeNodePoolConfig) {
        return mergeFrom((com.google.cloud.dataproc.v1.GkeNodePoolConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dataproc.v1.GkeNodePoolConfig other) {
      if (other == com.google.cloud.dataproc.v1.GkeNodePoolConfig.getDefaultInstance()) return this;
      if (other.hasConfig()) {
        mergeConfig(other.getConfig());
      }
      if (!other.locations_.isEmpty()) {
        if (locations_.isEmpty()) {
          locations_ = other.locations_;
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          ensureLocationsIsMutable();
          locations_.addAll(other.locations_);
        }
        onChanged();
      }
      if (other.hasAutoscaling()) {
        mergeAutoscaling(other.getAutoscaling());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 18:
              {
                input.readMessage(getConfigFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 18
            case 34:
              {
                input.readMessage(getAutoscalingFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 34
            case 106:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureLocationsIsMutable();
                locations_.add(s);
                break;
              } // case 106
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig config_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig,
            com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig.Builder,
            com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfigOrBuilder>
        configBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. The node pool configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig config = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the config field is set.
     */
    public boolean hasConfig() {
      return configBuilder_ != null || config_ != null;
    }
    /**
     *
     *
     * <pre>
     * Optional. The node pool configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig config = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The config.
     */
    public com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig getConfig() {
      if (configBuilder_ == null) {
        return config_ == null
            ? com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig.getDefaultInstance()
            : config_;
      } else {
        return configBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The node pool configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig config = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setConfig(com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig value) {
      if (configBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        config_ = value;
        onChanged();
      } else {
        configBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The node pool configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig config = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setConfig(
        com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig.Builder builderForValue) {
      if (configBuilder_ == null) {
        config_ = builderForValue.build();
        onChanged();
      } else {
        configBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The node pool configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig config = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeConfig(com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig value) {
      if (configBuilder_ == null) {
        if (config_ != null) {
          config_ =
              com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig.newBuilder(config_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          config_ = value;
        }
        onChanged();
      } else {
        configBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The node pool configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig config = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearConfig() {
      if (configBuilder_ == null) {
        config_ = null;
        onChanged();
      } else {
        config_ = null;
        configBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The node pool configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig config = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig.Builder getConfigBuilder() {

      onChanged();
      return getConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. The node pool configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig config = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfigOrBuilder
        getConfigOrBuilder() {
      if (configBuilder_ != null) {
        return configBuilder_.getMessageOrBuilder();
      } else {
        return config_ == null
            ? com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig.getDefaultInstance()
            : config_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The node pool configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig config = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig,
            com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig.Builder,
            com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfigOrBuilder>
        getConfigFieldBuilder() {
      if (configBuilder_ == null) {
        configBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig,
                com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfig.Builder,
                com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodeConfigOrBuilder>(
                getConfig(), getParentForChildren(), isClean());
        config_ = null;
      }
      return configBuilder_;
    }

    private com.google.protobuf.LazyStringList locations_ =
        com.google.protobuf.LazyStringArrayList.EMPTY;

    private void ensureLocationsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        locations_ = new com.google.protobuf.LazyStringArrayList(locations_);
        bitField0_ |= 0x00000001;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The list of Compute Engine
     * [zones](https://cloud.google.com/compute/docs/zones#available) where
     * NodePool's nodes will be located.
     * **Note:** Currently, only one zone may be specified.
     * If a location is not specified during NodePool creation, Dataproc will
     * choose a location.
     * </pre>
     *
     * <code>repeated string locations = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return A list containing the locations.
     */
    public com.google.protobuf.ProtocolStringList getLocationsList() {
      return locations_.getUnmodifiableView();
    }
    /**
     *
     *
     * <pre>
     * Optional. The list of Compute Engine
     * [zones](https://cloud.google.com/compute/docs/zones#available) where
     * NodePool's nodes will be located.
     * **Note:** Currently, only one zone may be specified.
     * If a location is not specified during NodePool creation, Dataproc will
     * choose a location.
     * </pre>
     *
     * <code>repeated string locations = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The count of locations.
     */
    public int getLocationsCount() {
      return locations_.size();
    }
    /**
     *
     *
     * <pre>
     * Optional. The list of Compute Engine
     * [zones](https://cloud.google.com/compute/docs/zones#available) where
     * NodePool's nodes will be located.
     * **Note:** Currently, only one zone may be specified.
     * If a location is not specified during NodePool creation, Dataproc will
     * choose a location.
     * </pre>
     *
     * <code>repeated string locations = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the element to return.
     * @return The locations at the given index.
     */
    public java.lang.String getLocations(int index) {
      return locations_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. The list of Compute Engine
     * [zones](https://cloud.google.com/compute/docs/zones#available) where
     * NodePool's nodes will be located.
     * **Note:** Currently, only one zone may be specified.
     * If a location is not specified during NodePool creation, Dataproc will
     * choose a location.
     * </pre>
     *
     * <code>repeated string locations = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the locations at the given index.
     */
    public com.google.protobuf.ByteString getLocationsBytes(int index) {
      return locations_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. The list of Compute Engine
     * [zones](https://cloud.google.com/compute/docs/zones#available) where
     * NodePool's nodes will be located.
     * **Note:** Currently, only one zone may be specified.
     * If a location is not specified during NodePool creation, Dataproc will
     * choose a location.
     * </pre>
     *
     * <code>repeated string locations = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index to set the value at.
     * @param value The locations to set.
     * @return This builder for chaining.
     */
    public Builder setLocations(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureLocationsIsMutable();
      locations_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The list of Compute Engine
     * [zones](https://cloud.google.com/compute/docs/zones#available) where
     * NodePool's nodes will be located.
     * **Note:** Currently, only one zone may be specified.
     * If a location is not specified during NodePool creation, Dataproc will
     * choose a location.
     * </pre>
     *
     * <code>repeated string locations = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The locations to add.
     * @return This builder for chaining.
     */
    public Builder addLocations(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureLocationsIsMutable();
      locations_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The list of Compute Engine
     * [zones](https://cloud.google.com/compute/docs/zones#available) where
     * NodePool's nodes will be located.
     * **Note:** Currently, only one zone may be specified.
     * If a location is not specified during NodePool creation, Dataproc will
     * choose a location.
     * </pre>
     *
     * <code>repeated string locations = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param values The locations to add.
     * @return This builder for chaining.
     */
    public Builder addAllLocations(java.lang.Iterable<java.lang.String> values) {
      ensureLocationsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, locations_);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The list of Compute Engine
     * [zones](https://cloud.google.com/compute/docs/zones#available) where
     * NodePool's nodes will be located.
     * **Note:** Currently, only one zone may be specified.
     * If a location is not specified during NodePool creation, Dataproc will
     * choose a location.
     * </pre>
     *
     * <code>repeated string locations = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLocations() {
      locations_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The list of Compute Engine
     * [zones](https://cloud.google.com/compute/docs/zones#available) where
     * NodePool's nodes will be located.
     * **Note:** Currently, only one zone may be specified.
     * If a location is not specified during NodePool creation, Dataproc will
     * choose a location.
     * </pre>
     *
     * <code>repeated string locations = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes of the locations to add.
     * @return This builder for chaining.
     */
    public Builder addLocationsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureLocationsIsMutable();
      locations_.add(value);
      onChanged();
      return this;
    }

    private com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig
        autoscaling_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig,
            com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig.Builder,
            com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfigOrBuilder>
        autoscalingBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. The autoscaler configuration for this NodePool. The autoscaler is enabled
     * only when a valid configuration is present.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig autoscaling = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the autoscaling field is set.
     */
    public boolean hasAutoscaling() {
      return autoscalingBuilder_ != null || autoscaling_ != null;
    }
    /**
     *
     *
     * <pre>
     * Optional. The autoscaler configuration for this NodePool. The autoscaler is enabled
     * only when a valid configuration is present.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig autoscaling = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The autoscaling.
     */
    public com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig
        getAutoscaling() {
      if (autoscalingBuilder_ == null) {
        return autoscaling_ == null
            ? com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig
                .getDefaultInstance()
            : autoscaling_;
      } else {
        return autoscalingBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The autoscaler configuration for this NodePool. The autoscaler is enabled
     * only when a valid configuration is present.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig autoscaling = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setAutoscaling(
        com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig value) {
      if (autoscalingBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        autoscaling_ = value;
        onChanged();
      } else {
        autoscalingBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The autoscaler configuration for this NodePool. The autoscaler is enabled
     * only when a valid configuration is present.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig autoscaling = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setAutoscaling(
        com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig.Builder
            builderForValue) {
      if (autoscalingBuilder_ == null) {
        autoscaling_ = builderForValue.build();
        onChanged();
      } else {
        autoscalingBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The autoscaler configuration for this NodePool. The autoscaler is enabled
     * only when a valid configuration is present.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig autoscaling = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeAutoscaling(
        com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig value) {
      if (autoscalingBuilder_ == null) {
        if (autoscaling_ != null) {
          autoscaling_ =
              com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig
                  .newBuilder(autoscaling_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          autoscaling_ = value;
        }
        onChanged();
      } else {
        autoscalingBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The autoscaler configuration for this NodePool. The autoscaler is enabled
     * only when a valid configuration is present.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig autoscaling = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearAutoscaling() {
      if (autoscalingBuilder_ == null) {
        autoscaling_ = null;
        onChanged();
      } else {
        autoscaling_ = null;
        autoscalingBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The autoscaler configuration for this NodePool. The autoscaler is enabled
     * only when a valid configuration is present.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig autoscaling = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig.Builder
        getAutoscalingBuilder() {

      onChanged();
      return getAutoscalingFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. The autoscaler configuration for this NodePool. The autoscaler is enabled
     * only when a valid configuration is present.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig autoscaling = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfigOrBuilder
        getAutoscalingOrBuilder() {
      if (autoscalingBuilder_ != null) {
        return autoscalingBuilder_.getMessageOrBuilder();
      } else {
        return autoscaling_ == null
            ? com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig
                .getDefaultInstance()
            : autoscaling_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The autoscaler configuration for this NodePool. The autoscaler is enabled
     * only when a valid configuration is present.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig autoscaling = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig,
            com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig.Builder,
            com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfigOrBuilder>
        getAutoscalingFieldBuilder() {
      if (autoscalingBuilder_ == null) {
        autoscalingBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig,
                com.google.cloud.dataproc.v1.GkeNodePoolConfig.GkeNodePoolAutoscalingConfig.Builder,
                com.google.cloud.dataproc.v1.GkeNodePoolConfig
                    .GkeNodePoolAutoscalingConfigOrBuilder>(
                getAutoscaling(), getParentForChildren(), isClean());
        autoscaling_ = null;
      }
      return autoscalingBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dataproc.v1.GkeNodePoolConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dataproc.v1.GkeNodePoolConfig)
  private static final com.google.cloud.dataproc.v1.GkeNodePoolConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dataproc.v1.GkeNodePoolConfig();
  }

  public static com.google.cloud.dataproc.v1.GkeNodePoolConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<GkeNodePoolConfig> PARSER =
      new com.google.protobuf.AbstractParser<GkeNodePoolConfig>() {
        @java.lang.Override
        public GkeNodePoolConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<GkeNodePoolConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<GkeNodePoolConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dataproc.v1.GkeNodePoolConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
