/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dataproc/v1/shared.proto

package com.google.cloud.dataproc.v1;

/**
 *
 *
 * <pre>
 * GKE NodePools that Dataproc workloads run on.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dataproc.v1.GkeNodePoolTarget}
 */
public final class GkeNodePoolTarget extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dataproc.v1.GkeNodePoolTarget)
    GkeNodePoolTargetOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use GkeNodePoolTarget.newBuilder() to construct.
  private GkeNodePoolTarget(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private GkeNodePoolTarget() {
    nodePool_ = "";
    roles_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new GkeNodePoolTarget();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dataproc.v1.SharedProto
        .internal_static_google_cloud_dataproc_v1_GkeNodePoolTarget_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dataproc.v1.SharedProto
        .internal_static_google_cloud_dataproc_v1_GkeNodePoolTarget_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dataproc.v1.GkeNodePoolTarget.class,
            com.google.cloud.dataproc.v1.GkeNodePoolTarget.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * `Role` specifies whose tasks will run on the NodePool. The roles can be
   * specific to workloads. Exactly one GkeNodePoolTarget within the
   * VirtualCluster must have 'default' role, which is used to run all workloads
   * that are not associated with a NodePool.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.dataproc.v1.GkeNodePoolTarget.Role}
   */
  public enum Role implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Role is unspecified.
     * </pre>
     *
     * <code>ROLE_UNSPECIFIED = 0;</code>
     */
    ROLE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Any roles that are not directly assigned to a NodePool run on the
     * `default` role's NodePool.
     * </pre>
     *
     * <code>DEFAULT = 1;</code>
     */
    DEFAULT(1),
    /**
     *
     *
     * <pre>
     * Run controllers and webhooks.
     * </pre>
     *
     * <code>CONTROLLER = 2;</code>
     */
    CONTROLLER(2),
    /**
     *
     *
     * <pre>
     * Run spark driver.
     * </pre>
     *
     * <code>SPARK_DRIVER = 3;</code>
     */
    SPARK_DRIVER(3),
    /**
     *
     *
     * <pre>
     * Run spark executors.
     * </pre>
     *
     * <code>SPARK_EXECUTOR = 4;</code>
     */
    SPARK_EXECUTOR(4),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Role is unspecified.
     * </pre>
     *
     * <code>ROLE_UNSPECIFIED = 0;</code>
     */
    public static final int ROLE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Any roles that are not directly assigned to a NodePool run on the
     * `default` role's NodePool.
     * </pre>
     *
     * <code>DEFAULT = 1;</code>
     */
    public static final int DEFAULT_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Run controllers and webhooks.
     * </pre>
     *
     * <code>CONTROLLER = 2;</code>
     */
    public static final int CONTROLLER_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Run spark driver.
     * </pre>
     *
     * <code>SPARK_DRIVER = 3;</code>
     */
    public static final int SPARK_DRIVER_VALUE = 3;
    /**
     *
     *
     * <pre>
     * Run spark executors.
     * </pre>
     *
     * <code>SPARK_EXECUTOR = 4;</code>
     */
    public static final int SPARK_EXECUTOR_VALUE = 4;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Role valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Role forNumber(int value) {
      switch (value) {
        case 0:
          return ROLE_UNSPECIFIED;
        case 1:
          return DEFAULT;
        case 2:
          return CONTROLLER;
        case 3:
          return SPARK_DRIVER;
        case 4:
          return SPARK_EXECUTOR;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Role> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Role> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Role>() {
          public Role findValueByNumber(int number) {
            return Role.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.dataproc.v1.GkeNodePoolTarget.getDescriptor().getEnumTypes().get(0);
    }

    private static final Role[] VALUES = values();

    public static Role valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Role(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.dataproc.v1.GkeNodePoolTarget.Role)
  }

  public static final int NODE_POOL_FIELD_NUMBER = 1;
  private volatile java.lang.Object nodePool_;
  /**
   *
   *
   * <pre>
   * Required. The target GKE NodePool.
   * Format:
   * 'projects/{project}/locations/{location}/clusters/{cluster}/nodePools/{node_pool}'
   * </pre>
   *
   * <code>string node_pool = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The nodePool.
   */
  @java.lang.Override
  public java.lang.String getNodePool() {
    java.lang.Object ref = nodePool_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      nodePool_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The target GKE NodePool.
   * Format:
   * 'projects/{project}/locations/{location}/clusters/{cluster}/nodePools/{node_pool}'
   * </pre>
   *
   * <code>string node_pool = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for nodePool.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNodePoolBytes() {
    java.lang.Object ref = nodePool_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      nodePool_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ROLES_FIELD_NUMBER = 2;
  private java.util.List<java.lang.Integer> roles_;
  private static final com.google.protobuf.Internal.ListAdapter.Converter<
          java.lang.Integer, com.google.cloud.dataproc.v1.GkeNodePoolTarget.Role>
      roles_converter_ =
          new com.google.protobuf.Internal.ListAdapter.Converter<
              java.lang.Integer, com.google.cloud.dataproc.v1.GkeNodePoolTarget.Role>() {
            public com.google.cloud.dataproc.v1.GkeNodePoolTarget.Role convert(
                java.lang.Integer from) {
              @SuppressWarnings("deprecation")
              com.google.cloud.dataproc.v1.GkeNodePoolTarget.Role result =
                  com.google.cloud.dataproc.v1.GkeNodePoolTarget.Role.valueOf(from);
              return result == null
                  ? com.google.cloud.dataproc.v1.GkeNodePoolTarget.Role.UNRECOGNIZED
                  : result;
            }
          };
  /**
   *
   *
   * <pre>
   * Required. The types of role for a GKE NodePool
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dataproc.v1.GkeNodePoolTarget.Role roles = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return A list containing the roles.
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.dataproc.v1.GkeNodePoolTarget.Role> getRolesList() {
    return new com.google.protobuf.Internal.ListAdapter<
        java.lang.Integer, com.google.cloud.dataproc.v1.GkeNodePoolTarget.Role>(
        roles_, roles_converter_);
  }
  /**
   *
   *
   * <pre>
   * Required. The types of role for a GKE NodePool
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dataproc.v1.GkeNodePoolTarget.Role roles = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The count of roles.
   */
  @java.lang.Override
  public int getRolesCount() {
    return roles_.size();
  }
  /**
   *
   *
   * <pre>
   * Required. The types of role for a GKE NodePool
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dataproc.v1.GkeNodePoolTarget.Role roles = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @param index The index of the element to return.
   * @return The roles at the given index.
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.GkeNodePoolTarget.Role getRoles(int index) {
    return roles_converter_.convert(roles_.get(index));
  }
  /**
   *
   *
   * <pre>
   * Required. The types of role for a GKE NodePool
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dataproc.v1.GkeNodePoolTarget.Role roles = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return A list containing the enum numeric values on the wire for roles.
   */
  @java.lang.Override
  public java.util.List<java.lang.Integer> getRolesValueList() {
    return roles_;
  }
  /**
   *
   *
   * <pre>
   * Required. The types of role for a GKE NodePool
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dataproc.v1.GkeNodePoolTarget.Role roles = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @param index The index of the value to return.
   * @return The enum numeric value on the wire of roles at the given index.
   */
  @java.lang.Override
  public int getRolesValue(int index) {
    return roles_.get(index);
  }

  private int rolesMemoizedSerializedSize;

  public static final int NODE_POOL_CONFIG_FIELD_NUMBER = 3;
  private com.google.cloud.dataproc.v1.GkeNodePoolConfig nodePoolConfig_;
  /**
   *
   *
   * <pre>
   * Optional. The configuration for the GKE NodePool.
   * If specified, Dataproc attempts to create a NodePool with the
   * specified shape. If one with the same name already exists, it is
   * verified against all specified fields. If a field differs, the
   * virtual cluster creation will fail.
   * If omitted, any NodePool with the specified name is used. If a
   * NodePool with the specified name does not exist, Dataproc create a NodePool
   * with default values.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.GkeNodePoolConfig node_pool_config = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the nodePoolConfig field is set.
   */
  @java.lang.Override
  public boolean hasNodePoolConfig() {
    return nodePoolConfig_ != null;
  }
  /**
   *
   *
   * <pre>
   * Optional. The configuration for the GKE NodePool.
   * If specified, Dataproc attempts to create a NodePool with the
   * specified shape. If one with the same name already exists, it is
   * verified against all specified fields. If a field differs, the
   * virtual cluster creation will fail.
   * If omitted, any NodePool with the specified name is used. If a
   * NodePool with the specified name does not exist, Dataproc create a NodePool
   * with default values.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.GkeNodePoolConfig node_pool_config = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The nodePoolConfig.
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.GkeNodePoolConfig getNodePoolConfig() {
    return nodePoolConfig_ == null
        ? com.google.cloud.dataproc.v1.GkeNodePoolConfig.getDefaultInstance()
        : nodePoolConfig_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The configuration for the GKE NodePool.
   * If specified, Dataproc attempts to create a NodePool with the
   * specified shape. If one with the same name already exists, it is
   * verified against all specified fields. If a field differs, the
   * virtual cluster creation will fail.
   * If omitted, any NodePool with the specified name is used. If a
   * NodePool with the specified name does not exist, Dataproc create a NodePool
   * with default values.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.GkeNodePoolConfig node_pool_config = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.GkeNodePoolConfigOrBuilder getNodePoolConfigOrBuilder() {
    return getNodePoolConfig();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    getSerializedSize();
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(nodePool_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, nodePool_);
    }
    if (getRolesList().size() > 0) {
      output.writeUInt32NoTag(18);
      output.writeUInt32NoTag(rolesMemoizedSerializedSize);
    }
    for (int i = 0; i < roles_.size(); i++) {
      output.writeEnumNoTag(roles_.get(i));
    }
    if (nodePoolConfig_ != null) {
      output.writeMessage(3, getNodePoolConfig());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(nodePool_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, nodePool_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < roles_.size(); i++) {
        dataSize += com.google.protobuf.CodedOutputStream.computeEnumSizeNoTag(roles_.get(i));
      }
      size += dataSize;
      if (!getRolesList().isEmpty()) {
        size += 1;
        size += com.google.protobuf.CodedOutputStream.computeUInt32SizeNoTag(dataSize);
      }
      rolesMemoizedSerializedSize = dataSize;
    }
    if (nodePoolConfig_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getNodePoolConfig());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dataproc.v1.GkeNodePoolTarget)) {
      return super.equals(obj);
    }
    com.google.cloud.dataproc.v1.GkeNodePoolTarget other =
        (com.google.cloud.dataproc.v1.GkeNodePoolTarget) obj;

    if (!getNodePool().equals(other.getNodePool())) return false;
    if (!roles_.equals(other.roles_)) return false;
    if (hasNodePoolConfig() != other.hasNodePoolConfig()) return false;
    if (hasNodePoolConfig()) {
      if (!getNodePoolConfig().equals(other.getNodePoolConfig())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NODE_POOL_FIELD_NUMBER;
    hash = (53 * hash) + getNodePool().hashCode();
    if (getRolesCount() > 0) {
      hash = (37 * hash) + ROLES_FIELD_NUMBER;
      hash = (53 * hash) + roles_.hashCode();
    }
    if (hasNodePoolConfig()) {
      hash = (37 * hash) + NODE_POOL_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getNodePoolConfig().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dataproc.v1.GkeNodePoolTarget parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1.GkeNodePoolTarget parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.GkeNodePoolTarget parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1.GkeNodePoolTarget parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.GkeNodePoolTarget parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1.GkeNodePoolTarget parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.GkeNodePoolTarget parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1.GkeNodePoolTarget parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.GkeNodePoolTarget parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1.GkeNodePoolTarget parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.GkeNodePoolTarget parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1.GkeNodePoolTarget parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.dataproc.v1.GkeNodePoolTarget prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * GKE NodePools that Dataproc workloads run on.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dataproc.v1.GkeNodePoolTarget}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dataproc.v1.GkeNodePoolTarget)
      com.google.cloud.dataproc.v1.GkeNodePoolTargetOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dataproc.v1.SharedProto
          .internal_static_google_cloud_dataproc_v1_GkeNodePoolTarget_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dataproc.v1.SharedProto
          .internal_static_google_cloud_dataproc_v1_GkeNodePoolTarget_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dataproc.v1.GkeNodePoolTarget.class,
              com.google.cloud.dataproc.v1.GkeNodePoolTarget.Builder.class);
    }

    // Construct using com.google.cloud.dataproc.v1.GkeNodePoolTarget.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      nodePool_ = "";

      roles_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000001);
      if (nodePoolConfigBuilder_ == null) {
        nodePoolConfig_ = null;
      } else {
        nodePoolConfig_ = null;
        nodePoolConfigBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dataproc.v1.SharedProto
          .internal_static_google_cloud_dataproc_v1_GkeNodePoolTarget_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.GkeNodePoolTarget getDefaultInstanceForType() {
      return com.google.cloud.dataproc.v1.GkeNodePoolTarget.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.GkeNodePoolTarget build() {
      com.google.cloud.dataproc.v1.GkeNodePoolTarget result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.GkeNodePoolTarget buildPartial() {
      com.google.cloud.dataproc.v1.GkeNodePoolTarget result =
          new com.google.cloud.dataproc.v1.GkeNodePoolTarget(this);
      int from_bitField0_ = bitField0_;
      result.nodePool_ = nodePool_;
      if (((bitField0_ & 0x00000001) != 0)) {
        roles_ = java.util.Collections.unmodifiableList(roles_);
        bitField0_ = (bitField0_ & ~0x00000001);
      }
      result.roles_ = roles_;
      if (nodePoolConfigBuilder_ == null) {
        result.nodePoolConfig_ = nodePoolConfig_;
      } else {
        result.nodePoolConfig_ = nodePoolConfigBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dataproc.v1.GkeNodePoolTarget) {
        return mergeFrom((com.google.cloud.dataproc.v1.GkeNodePoolTarget) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dataproc.v1.GkeNodePoolTarget other) {
      if (other == com.google.cloud.dataproc.v1.GkeNodePoolTarget.getDefaultInstance()) return this;
      if (!other.getNodePool().isEmpty()) {
        nodePool_ = other.nodePool_;
        onChanged();
      }
      if (!other.roles_.isEmpty()) {
        if (roles_.isEmpty()) {
          roles_ = other.roles_;
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          ensureRolesIsMutable();
          roles_.addAll(other.roles_);
        }
        onChanged();
      }
      if (other.hasNodePoolConfig()) {
        mergeNodePoolConfig(other.getNodePoolConfig());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                nodePool_ = input.readStringRequireUtf8();

                break;
              } // case 10
            case 16:
              {
                int tmpRaw = input.readEnum();
                ensureRolesIsMutable();
                roles_.add(tmpRaw);
                break;
              } // case 16
            case 18:
              {
                int length = input.readRawVarint32();
                int oldLimit = input.pushLimit(length);
                while (input.getBytesUntilLimit() > 0) {
                  int tmpRaw = input.readEnum();
                  ensureRolesIsMutable();
                  roles_.add(tmpRaw);
                }
                input.popLimit(oldLimit);
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getNodePoolConfigFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object nodePool_ = "";
    /**
     *
     *
     * <pre>
     * Required. The target GKE NodePool.
     * Format:
     * 'projects/{project}/locations/{location}/clusters/{cluster}/nodePools/{node_pool}'
     * </pre>
     *
     * <code>string node_pool = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The nodePool.
     */
    public java.lang.String getNodePool() {
      java.lang.Object ref = nodePool_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        nodePool_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The target GKE NodePool.
     * Format:
     * 'projects/{project}/locations/{location}/clusters/{cluster}/nodePools/{node_pool}'
     * </pre>
     *
     * <code>string node_pool = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for nodePool.
     */
    public com.google.protobuf.ByteString getNodePoolBytes() {
      java.lang.Object ref = nodePool_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        nodePool_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The target GKE NodePool.
     * Format:
     * 'projects/{project}/locations/{location}/clusters/{cluster}/nodePools/{node_pool}'
     * </pre>
     *
     * <code>string node_pool = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The nodePool to set.
     * @return This builder for chaining.
     */
    public Builder setNodePool(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      nodePool_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The target GKE NodePool.
     * Format:
     * 'projects/{project}/locations/{location}/clusters/{cluster}/nodePools/{node_pool}'
     * </pre>
     *
     * <code>string node_pool = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNodePool() {

      nodePool_ = getDefaultInstance().getNodePool();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The target GKE NodePool.
     * Format:
     * 'projects/{project}/locations/{location}/clusters/{cluster}/nodePools/{node_pool}'
     * </pre>
     *
     * <code>string node_pool = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for nodePool to set.
     * @return This builder for chaining.
     */
    public Builder setNodePoolBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      nodePool_ = value;
      onChanged();
      return this;
    }

    private java.util.List<java.lang.Integer> roles_ = java.util.Collections.emptyList();

    private void ensureRolesIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        roles_ = new java.util.ArrayList<java.lang.Integer>(roles_);
        bitField0_ |= 0x00000001;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The types of role for a GKE NodePool
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.GkeNodePoolTarget.Role roles = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return A list containing the roles.
     */
    public java.util.List<com.google.cloud.dataproc.v1.GkeNodePoolTarget.Role> getRolesList() {
      return new com.google.protobuf.Internal.ListAdapter<
          java.lang.Integer, com.google.cloud.dataproc.v1.GkeNodePoolTarget.Role>(
          roles_, roles_converter_);
    }
    /**
     *
     *
     * <pre>
     * Required. The types of role for a GKE NodePool
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.GkeNodePoolTarget.Role roles = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The count of roles.
     */
    public int getRolesCount() {
      return roles_.size();
    }
    /**
     *
     *
     * <pre>
     * Required. The types of role for a GKE NodePool
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.GkeNodePoolTarget.Role roles = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param index The index of the element to return.
     * @return The roles at the given index.
     */
    public com.google.cloud.dataproc.v1.GkeNodePoolTarget.Role getRoles(int index) {
      return roles_converter_.convert(roles_.get(index));
    }
    /**
     *
     *
     * <pre>
     * Required. The types of role for a GKE NodePool
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.GkeNodePoolTarget.Role roles = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The roles to set.
     * @return This builder for chaining.
     */
    public Builder setRoles(int index, com.google.cloud.dataproc.v1.GkeNodePoolTarget.Role value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureRolesIsMutable();
      roles_.set(index, value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The types of role for a GKE NodePool
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.GkeNodePoolTarget.Role roles = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The roles to add.
     * @return This builder for chaining.
     */
    public Builder addRoles(com.google.cloud.dataproc.v1.GkeNodePoolTarget.Role value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureRolesIsMutable();
      roles_.add(value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The types of role for a GKE NodePool
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.GkeNodePoolTarget.Role roles = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param values The roles to add.
     * @return This builder for chaining.
     */
    public Builder addAllRoles(
        java.lang.Iterable<? extends com.google.cloud.dataproc.v1.GkeNodePoolTarget.Role> values) {
      ensureRolesIsMutable();
      for (com.google.cloud.dataproc.v1.GkeNodePoolTarget.Role value : values) {
        roles_.add(value.getNumber());
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The types of role for a GKE NodePool
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.GkeNodePoolTarget.Role roles = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRoles() {
      roles_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The types of role for a GKE NodePool
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.GkeNodePoolTarget.Role roles = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return A list containing the enum numeric values on the wire for roles.
     */
    public java.util.List<java.lang.Integer> getRolesValueList() {
      return java.util.Collections.unmodifiableList(roles_);
    }
    /**
     *
     *
     * <pre>
     * Required. The types of role for a GKE NodePool
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.GkeNodePoolTarget.Role roles = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of roles at the given index.
     */
    public int getRolesValue(int index) {
      return roles_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Required. The types of role for a GKE NodePool
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.GkeNodePoolTarget.Role roles = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The enum numeric value on the wire for roles to set.
     * @return This builder for chaining.
     */
    public Builder setRolesValue(int index, int value) {
      ensureRolesIsMutable();
      roles_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The types of role for a GKE NodePool
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.GkeNodePoolTarget.Role roles = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The enum numeric value on the wire for roles to add.
     * @return This builder for chaining.
     */
    public Builder addRolesValue(int value) {
      ensureRolesIsMutable();
      roles_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The types of role for a GKE NodePool
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.GkeNodePoolTarget.Role roles = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param values The enum numeric values on the wire for roles to add.
     * @return This builder for chaining.
     */
    public Builder addAllRolesValue(java.lang.Iterable<java.lang.Integer> values) {
      ensureRolesIsMutable();
      for (int value : values) {
        roles_.add(value);
      }
      onChanged();
      return this;
    }

    private com.google.cloud.dataproc.v1.GkeNodePoolConfig nodePoolConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.GkeNodePoolConfig,
            com.google.cloud.dataproc.v1.GkeNodePoolConfig.Builder,
            com.google.cloud.dataproc.v1.GkeNodePoolConfigOrBuilder>
        nodePoolConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. The configuration for the GKE NodePool.
     * If specified, Dataproc attempts to create a NodePool with the
     * specified shape. If one with the same name already exists, it is
     * verified against all specified fields. If a field differs, the
     * virtual cluster creation will fail.
     * If omitted, any NodePool with the specified name is used. If a
     * NodePool with the specified name does not exist, Dataproc create a NodePool
     * with default values.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.GkeNodePoolConfig node_pool_config = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the nodePoolConfig field is set.
     */
    public boolean hasNodePoolConfig() {
      return nodePoolConfigBuilder_ != null || nodePoolConfig_ != null;
    }
    /**
     *
     *
     * <pre>
     * Optional. The configuration for the GKE NodePool.
     * If specified, Dataproc attempts to create a NodePool with the
     * specified shape. If one with the same name already exists, it is
     * verified against all specified fields. If a field differs, the
     * virtual cluster creation will fail.
     * If omitted, any NodePool with the specified name is used. If a
     * NodePool with the specified name does not exist, Dataproc create a NodePool
     * with default values.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.GkeNodePoolConfig node_pool_config = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The nodePoolConfig.
     */
    public com.google.cloud.dataproc.v1.GkeNodePoolConfig getNodePoolConfig() {
      if (nodePoolConfigBuilder_ == null) {
        return nodePoolConfig_ == null
            ? com.google.cloud.dataproc.v1.GkeNodePoolConfig.getDefaultInstance()
            : nodePoolConfig_;
      } else {
        return nodePoolConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The configuration for the GKE NodePool.
     * If specified, Dataproc attempts to create a NodePool with the
     * specified shape. If one with the same name already exists, it is
     * verified against all specified fields. If a field differs, the
     * virtual cluster creation will fail.
     * If omitted, any NodePool with the specified name is used. If a
     * NodePool with the specified name does not exist, Dataproc create a NodePool
     * with default values.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.GkeNodePoolConfig node_pool_config = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setNodePoolConfig(com.google.cloud.dataproc.v1.GkeNodePoolConfig value) {
      if (nodePoolConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        nodePoolConfig_ = value;
        onChanged();
      } else {
        nodePoolConfigBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The configuration for the GKE NodePool.
     * If specified, Dataproc attempts to create a NodePool with the
     * specified shape. If one with the same name already exists, it is
     * verified against all specified fields. If a field differs, the
     * virtual cluster creation will fail.
     * If omitted, any NodePool with the specified name is used. If a
     * NodePool with the specified name does not exist, Dataproc create a NodePool
     * with default values.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.GkeNodePoolConfig node_pool_config = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setNodePoolConfig(
        com.google.cloud.dataproc.v1.GkeNodePoolConfig.Builder builderForValue) {
      if (nodePoolConfigBuilder_ == null) {
        nodePoolConfig_ = builderForValue.build();
        onChanged();
      } else {
        nodePoolConfigBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The configuration for the GKE NodePool.
     * If specified, Dataproc attempts to create a NodePool with the
     * specified shape. If one with the same name already exists, it is
     * verified against all specified fields. If a field differs, the
     * virtual cluster creation will fail.
     * If omitted, any NodePool with the specified name is used. If a
     * NodePool with the specified name does not exist, Dataproc create a NodePool
     * with default values.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.GkeNodePoolConfig node_pool_config = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeNodePoolConfig(com.google.cloud.dataproc.v1.GkeNodePoolConfig value) {
      if (nodePoolConfigBuilder_ == null) {
        if (nodePoolConfig_ != null) {
          nodePoolConfig_ =
              com.google.cloud.dataproc.v1.GkeNodePoolConfig.newBuilder(nodePoolConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          nodePoolConfig_ = value;
        }
        onChanged();
      } else {
        nodePoolConfigBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The configuration for the GKE NodePool.
     * If specified, Dataproc attempts to create a NodePool with the
     * specified shape. If one with the same name already exists, it is
     * verified against all specified fields. If a field differs, the
     * virtual cluster creation will fail.
     * If omitted, any NodePool with the specified name is used. If a
     * NodePool with the specified name does not exist, Dataproc create a NodePool
     * with default values.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.GkeNodePoolConfig node_pool_config = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearNodePoolConfig() {
      if (nodePoolConfigBuilder_ == null) {
        nodePoolConfig_ = null;
        onChanged();
      } else {
        nodePoolConfig_ = null;
        nodePoolConfigBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The configuration for the GKE NodePool.
     * If specified, Dataproc attempts to create a NodePool with the
     * specified shape. If one with the same name already exists, it is
     * verified against all specified fields. If a field differs, the
     * virtual cluster creation will fail.
     * If omitted, any NodePool with the specified name is used. If a
     * NodePool with the specified name does not exist, Dataproc create a NodePool
     * with default values.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.GkeNodePoolConfig node_pool_config = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataproc.v1.GkeNodePoolConfig.Builder getNodePoolConfigBuilder() {

      onChanged();
      return getNodePoolConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. The configuration for the GKE NodePool.
     * If specified, Dataproc attempts to create a NodePool with the
     * specified shape. If one with the same name already exists, it is
     * verified against all specified fields. If a field differs, the
     * virtual cluster creation will fail.
     * If omitted, any NodePool with the specified name is used. If a
     * NodePool with the specified name does not exist, Dataproc create a NodePool
     * with default values.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.GkeNodePoolConfig node_pool_config = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataproc.v1.GkeNodePoolConfigOrBuilder getNodePoolConfigOrBuilder() {
      if (nodePoolConfigBuilder_ != null) {
        return nodePoolConfigBuilder_.getMessageOrBuilder();
      } else {
        return nodePoolConfig_ == null
            ? com.google.cloud.dataproc.v1.GkeNodePoolConfig.getDefaultInstance()
            : nodePoolConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The configuration for the GKE NodePool.
     * If specified, Dataproc attempts to create a NodePool with the
     * specified shape. If one with the same name already exists, it is
     * verified against all specified fields. If a field differs, the
     * virtual cluster creation will fail.
     * If omitted, any NodePool with the specified name is used. If a
     * NodePool with the specified name does not exist, Dataproc create a NodePool
     * with default values.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.GkeNodePoolConfig node_pool_config = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.GkeNodePoolConfig,
            com.google.cloud.dataproc.v1.GkeNodePoolConfig.Builder,
            com.google.cloud.dataproc.v1.GkeNodePoolConfigOrBuilder>
        getNodePoolConfigFieldBuilder() {
      if (nodePoolConfigBuilder_ == null) {
        nodePoolConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataproc.v1.GkeNodePoolConfig,
                com.google.cloud.dataproc.v1.GkeNodePoolConfig.Builder,
                com.google.cloud.dataproc.v1.GkeNodePoolConfigOrBuilder>(
                getNodePoolConfig(), getParentForChildren(), isClean());
        nodePoolConfig_ = null;
      }
      return nodePoolConfigBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dataproc.v1.GkeNodePoolTarget)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dataproc.v1.GkeNodePoolTarget)
  private static final com.google.cloud.dataproc.v1.GkeNodePoolTarget DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dataproc.v1.GkeNodePoolTarget();
  }

  public static com.google.cloud.dataproc.v1.GkeNodePoolTarget getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<GkeNodePoolTarget> PARSER =
      new com.google.protobuf.AbstractParser<GkeNodePoolTarget>() {
        @java.lang.Override
        public GkeNodePoolTarget parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<GkeNodePoolTarget> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<GkeNodePoolTarget> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dataproc.v1.GkeNodePoolTarget getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
