/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dataproc/v1/shared.proto

package com.google.cloud.dataproc.v1;

public interface GkeNodePoolTargetOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.dataproc.v1.GkeNodePoolTarget)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Required. The target GKE NodePool.
   * Format:
   * 'projects/{project}/locations/{location}/clusters/{cluster}/nodePools/{node_pool}'
   * </pre>
   *
   * <code>string node_pool = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The nodePool.
   */
  java.lang.String getNodePool();
  /**
   *
   *
   * <pre>
   * Required. The target GKE NodePool.
   * Format:
   * 'projects/{project}/locations/{location}/clusters/{cluster}/nodePools/{node_pool}'
   * </pre>
   *
   * <code>string node_pool = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for nodePool.
   */
  com.google.protobuf.ByteString getNodePoolBytes();

  /**
   *
   *
   * <pre>
   * Required. The types of role for a GKE NodePool
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dataproc.v1.GkeNodePoolTarget.Role roles = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return A list containing the roles.
   */
  java.util.List<com.google.cloud.dataproc.v1.GkeNodePoolTarget.Role> getRolesList();
  /**
   *
   *
   * <pre>
   * Required. The types of role for a GKE NodePool
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dataproc.v1.GkeNodePoolTarget.Role roles = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The count of roles.
   */
  int getRolesCount();
  /**
   *
   *
   * <pre>
   * Required. The types of role for a GKE NodePool
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dataproc.v1.GkeNodePoolTarget.Role roles = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @param index The index of the element to return.
   * @return The roles at the given index.
   */
  com.google.cloud.dataproc.v1.GkeNodePoolTarget.Role getRoles(int index);
  /**
   *
   *
   * <pre>
   * Required. The types of role for a GKE NodePool
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dataproc.v1.GkeNodePoolTarget.Role roles = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return A list containing the enum numeric values on the wire for roles.
   */
  java.util.List<java.lang.Integer> getRolesValueList();
  /**
   *
   *
   * <pre>
   * Required. The types of role for a GKE NodePool
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dataproc.v1.GkeNodePoolTarget.Role roles = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @param index The index of the value to return.
   * @return The enum numeric value on the wire of roles at the given index.
   */
  int getRolesValue(int index);

  /**
   *
   *
   * <pre>
   * Optional. The configuration for the GKE NodePool.
   * If specified, Dataproc attempts to create a NodePool with the
   * specified shape. If one with the same name already exists, it is
   * verified against all specified fields. If a field differs, the
   * virtual cluster creation will fail.
   * If omitted, any NodePool with the specified name is used. If a
   * NodePool with the specified name does not exist, Dataproc create a NodePool
   * with default values.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.GkeNodePoolConfig node_pool_config = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the nodePoolConfig field is set.
   */
  boolean hasNodePoolConfig();
  /**
   *
   *
   * <pre>
   * Optional. The configuration for the GKE NodePool.
   * If specified, Dataproc attempts to create a NodePool with the
   * specified shape. If one with the same name already exists, it is
   * verified against all specified fields. If a field differs, the
   * virtual cluster creation will fail.
   * If omitted, any NodePool with the specified name is used. If a
   * NodePool with the specified name does not exist, Dataproc create a NodePool
   * with default values.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.GkeNodePoolConfig node_pool_config = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The nodePoolConfig.
   */
  com.google.cloud.dataproc.v1.GkeNodePoolConfig getNodePoolConfig();
  /**
   *
   *
   * <pre>
   * Optional. The configuration for the GKE NodePool.
   * If specified, Dataproc attempts to create a NodePool with the
   * specified shape. If one with the same name already exists, it is
   * verified against all specified fields. If a field differs, the
   * virtual cluster creation will fail.
   * If omitted, any NodePool with the specified name is used. If a
   * NodePool with the specified name does not exist, Dataproc create a NodePool
   * with default values.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.GkeNodePoolConfig node_pool_config = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.cloud.dataproc.v1.GkeNodePoolConfigOrBuilder getNodePoolConfigOrBuilder();
}
