/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dataproc/v1/clusters.proto

package com.google.cloud.dataproc.v1;

/**
 *
 *
 * <pre>
 * The config settings for Compute Engine resources in
 * an instance group, such as a master or worker group.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dataproc.v1.InstanceGroupConfig}
 */
public final class InstanceGroupConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dataproc.v1.InstanceGroupConfig)
    InstanceGroupConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use InstanceGroupConfig.newBuilder() to construct.
  private InstanceGroupConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private InstanceGroupConfig() {
    instanceNames_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    imageUri_ = "";
    machineTypeUri_ = "";
    preemptibility_ = 0;
    accelerators_ = java.util.Collections.emptyList();
    minCpuPlatform_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new InstanceGroupConfig();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dataproc.v1.ClustersProto
        .internal_static_google_cloud_dataproc_v1_InstanceGroupConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dataproc.v1.ClustersProto
        .internal_static_google_cloud_dataproc_v1_InstanceGroupConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dataproc.v1.InstanceGroupConfig.class,
            com.google.cloud.dataproc.v1.InstanceGroupConfig.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Controls the use of
   * [preemptible instances]
   * (https://cloud.google.com/compute/docs/instances/preemptible)
   * within the group.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.dataproc.v1.InstanceGroupConfig.Preemptibility}
   */
  public enum Preemptibility implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Preemptibility is unspecified, the system will choose the
     * appropriate setting for each instance group.
     * </pre>
     *
     * <code>PREEMPTIBILITY_UNSPECIFIED = 0;</code>
     */
    PREEMPTIBILITY_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Instances are non-preemptible.
     * This option is allowed for all instance groups and is the only valid
     * value for Master and Worker instance groups.
     * </pre>
     *
     * <code>NON_PREEMPTIBLE = 1;</code>
     */
    NON_PREEMPTIBLE(1),
    /**
     *
     *
     * <pre>
     * Instances are preemptible.
     * This option is allowed only for secondary worker groups.
     * </pre>
     *
     * <code>PREEMPTIBLE = 2;</code>
     */
    PREEMPTIBLE(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Preemptibility is unspecified, the system will choose the
     * appropriate setting for each instance group.
     * </pre>
     *
     * <code>PREEMPTIBILITY_UNSPECIFIED = 0;</code>
     */
    public static final int PREEMPTIBILITY_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Instances are non-preemptible.
     * This option is allowed for all instance groups and is the only valid
     * value for Master and Worker instance groups.
     * </pre>
     *
     * <code>NON_PREEMPTIBLE = 1;</code>
     */
    public static final int NON_PREEMPTIBLE_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Instances are preemptible.
     * This option is allowed only for secondary worker groups.
     * </pre>
     *
     * <code>PREEMPTIBLE = 2;</code>
     */
    public static final int PREEMPTIBLE_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Preemptibility valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Preemptibility forNumber(int value) {
      switch (value) {
        case 0:
          return PREEMPTIBILITY_UNSPECIFIED;
        case 1:
          return NON_PREEMPTIBLE;
        case 2:
          return PREEMPTIBLE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Preemptibility> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Preemptibility> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Preemptibility>() {
          public Preemptibility findValueByNumber(int number) {
            return Preemptibility.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.dataproc.v1.InstanceGroupConfig.getDescriptor().getEnumTypes().get(0);
    }

    private static final Preemptibility[] VALUES = values();

    public static Preemptibility valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Preemptibility(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.dataproc.v1.InstanceGroupConfig.Preemptibility)
  }

  public static final int NUM_INSTANCES_FIELD_NUMBER = 1;
  private int numInstances_;
  /**
   *
   *
   * <pre>
   * Optional. The number of VM instances in the instance group.
   * For [HA
   * cluster](/dataproc/docs/concepts/configuring-clusters/high-availability)
   * [master_config](#FIELDS.master_config) groups, **must be set to 3**.
   * For standard cluster [master_config](#FIELDS.master_config) groups,
   * **must be set to 1**.
   * </pre>
   *
   * <code>int32 num_instances = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The numInstances.
   */
  @java.lang.Override
  public int getNumInstances() {
    return numInstances_;
  }

  public static final int INSTANCE_NAMES_FIELD_NUMBER = 2;
  private com.google.protobuf.LazyStringList instanceNames_;
  /**
   *
   *
   * <pre>
   * Output only. The list of instance names. Dataproc derives the names
   * from `cluster_name`, `num_instances`, and the instance group.
   * </pre>
   *
   * <code>repeated string instance_names = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return A list containing the instanceNames.
   */
  public com.google.protobuf.ProtocolStringList getInstanceNamesList() {
    return instanceNames_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The list of instance names. Dataproc derives the names
   * from `cluster_name`, `num_instances`, and the instance group.
   * </pre>
   *
   * <code>repeated string instance_names = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The count of instanceNames.
   */
  public int getInstanceNamesCount() {
    return instanceNames_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. The list of instance names. Dataproc derives the names
   * from `cluster_name`, `num_instances`, and the instance group.
   * </pre>
   *
   * <code>repeated string instance_names = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @param index The index of the element to return.
   * @return The instanceNames at the given index.
   */
  public java.lang.String getInstanceNames(int index) {
    return instanceNames_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. The list of instance names. Dataproc derives the names
   * from `cluster_name`, `num_instances`, and the instance group.
   * </pre>
   *
   * <code>repeated string instance_names = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the instanceNames at the given index.
   */
  public com.google.protobuf.ByteString getInstanceNamesBytes(int index) {
    return instanceNames_.getByteString(index);
  }

  public static final int IMAGE_URI_FIELD_NUMBER = 3;
  private volatile java.lang.Object imageUri_;
  /**
   *
   *
   * <pre>
   * Optional. The Compute Engine image resource used for cluster instances.
   * The URI can represent an image or image family.
   * Image examples:
   * * `https://www.googleapis.com/compute/beta/projects/[project_id]/global/images/[image-id]`
   * * `projects/[project_id]/global/images/[image-id]`
   * * `image-id`
   * Image family examples. Dataproc will use the most recent
   * image from the family:
   * * `https://www.googleapis.com/compute/beta/projects/[project_id]/global/images/family/[custom-image-family-name]`
   * * `projects/[project_id]/global/images/family/[custom-image-family-name]`
   * If the URI is unspecified, it will be inferred from
   * `SoftwareConfig.image_version` or the system default.
   * </pre>
   *
   * <code>string image_uri = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The imageUri.
   */
  @java.lang.Override
  public java.lang.String getImageUri() {
    java.lang.Object ref = imageUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      imageUri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The Compute Engine image resource used for cluster instances.
   * The URI can represent an image or image family.
   * Image examples:
   * * `https://www.googleapis.com/compute/beta/projects/[project_id]/global/images/[image-id]`
   * * `projects/[project_id]/global/images/[image-id]`
   * * `image-id`
   * Image family examples. Dataproc will use the most recent
   * image from the family:
   * * `https://www.googleapis.com/compute/beta/projects/[project_id]/global/images/family/[custom-image-family-name]`
   * * `projects/[project_id]/global/images/family/[custom-image-family-name]`
   * If the URI is unspecified, it will be inferred from
   * `SoftwareConfig.image_version` or the system default.
   * </pre>
   *
   * <code>string image_uri = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for imageUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getImageUriBytes() {
    java.lang.Object ref = imageUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      imageUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MACHINE_TYPE_URI_FIELD_NUMBER = 4;
  private volatile java.lang.Object machineTypeUri_;
  /**
   *
   *
   * <pre>
   * Optional. The Compute Engine machine type used for cluster instances.
   * A full URL, partial URI, or short name are valid. Examples:
   * * `https://www.googleapis.com/compute/v1/projects/[project_id]/zones/us-east1-a/machineTypes/n1-standard-2`
   * * `projects/[project_id]/zones/us-east1-a/machineTypes/n1-standard-2`
   * * `n1-standard-2`
   * **Auto Zone Exception**: If you are using the Dataproc
   * [Auto Zone
   * Placement](https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/auto-zone#using_auto_zone_placement)
   * feature, you must use the short name of the machine type
   * resource, for example, `n1-standard-2`.
   * </pre>
   *
   * <code>string machine_type_uri = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The machineTypeUri.
   */
  @java.lang.Override
  public java.lang.String getMachineTypeUri() {
    java.lang.Object ref = machineTypeUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      machineTypeUri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The Compute Engine machine type used for cluster instances.
   * A full URL, partial URI, or short name are valid. Examples:
   * * `https://www.googleapis.com/compute/v1/projects/[project_id]/zones/us-east1-a/machineTypes/n1-standard-2`
   * * `projects/[project_id]/zones/us-east1-a/machineTypes/n1-standard-2`
   * * `n1-standard-2`
   * **Auto Zone Exception**: If you are using the Dataproc
   * [Auto Zone
   * Placement](https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/auto-zone#using_auto_zone_placement)
   * feature, you must use the short name of the machine type
   * resource, for example, `n1-standard-2`.
   * </pre>
   *
   * <code>string machine_type_uri = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for machineTypeUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getMachineTypeUriBytes() {
    java.lang.Object ref = machineTypeUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      machineTypeUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISK_CONFIG_FIELD_NUMBER = 5;
  private com.google.cloud.dataproc.v1.DiskConfig diskConfig_;
  /**
   *
   *
   * <pre>
   * Optional. Disk option config settings.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.DiskConfig disk_config = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the diskConfig field is set.
   */
  @java.lang.Override
  public boolean hasDiskConfig() {
    return diskConfig_ != null;
  }
  /**
   *
   *
   * <pre>
   * Optional. Disk option config settings.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.DiskConfig disk_config = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The diskConfig.
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.DiskConfig getDiskConfig() {
    return diskConfig_ == null
        ? com.google.cloud.dataproc.v1.DiskConfig.getDefaultInstance()
        : diskConfig_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Disk option config settings.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.DiskConfig disk_config = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.DiskConfigOrBuilder getDiskConfigOrBuilder() {
    return getDiskConfig();
  }

  public static final int IS_PREEMPTIBLE_FIELD_NUMBER = 6;
  private boolean isPreemptible_;
  /**
   *
   *
   * <pre>
   * Output only. Specifies that this instance group contains preemptible
   * instances.
   * </pre>
   *
   * <code>bool is_preemptible = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The isPreemptible.
   */
  @java.lang.Override
  public boolean getIsPreemptible() {
    return isPreemptible_;
  }

  public static final int PREEMPTIBILITY_FIELD_NUMBER = 10;
  private int preemptibility_;
  /**
   *
   *
   * <pre>
   * Optional. Specifies the preemptibility of the instance group.
   * The default value for master and worker groups is
   * `NON_PREEMPTIBLE`. This default cannot be changed.
   * The default value for secondary instances is
   * `PREEMPTIBLE`.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.InstanceGroupConfig.Preemptibility preemptibility = 10 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The enum numeric value on the wire for preemptibility.
   */
  @java.lang.Override
  public int getPreemptibilityValue() {
    return preemptibility_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Specifies the preemptibility of the instance group.
   * The default value for master and worker groups is
   * `NON_PREEMPTIBLE`. This default cannot be changed.
   * The default value for secondary instances is
   * `PREEMPTIBLE`.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.InstanceGroupConfig.Preemptibility preemptibility = 10 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The preemptibility.
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.InstanceGroupConfig.Preemptibility getPreemptibility() {
    @SuppressWarnings("deprecation")
    com.google.cloud.dataproc.v1.InstanceGroupConfig.Preemptibility result =
        com.google.cloud.dataproc.v1.InstanceGroupConfig.Preemptibility.valueOf(preemptibility_);
    return result == null
        ? com.google.cloud.dataproc.v1.InstanceGroupConfig.Preemptibility.UNRECOGNIZED
        : result;
  }

  public static final int MANAGED_GROUP_CONFIG_FIELD_NUMBER = 7;
  private com.google.cloud.dataproc.v1.ManagedGroupConfig managedGroupConfig_;
  /**
   *
   *
   * <pre>
   * Output only. The config for Compute Engine Instance Group
   * Manager that manages this group.
   * This is only used for preemptible instance groups.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.ManagedGroupConfig managed_group_config = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the managedGroupConfig field is set.
   */
  @java.lang.Override
  public boolean hasManagedGroupConfig() {
    return managedGroupConfig_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The config for Compute Engine Instance Group
   * Manager that manages this group.
   * This is only used for preemptible instance groups.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.ManagedGroupConfig managed_group_config = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The managedGroupConfig.
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.ManagedGroupConfig getManagedGroupConfig() {
    return managedGroupConfig_ == null
        ? com.google.cloud.dataproc.v1.ManagedGroupConfig.getDefaultInstance()
        : managedGroupConfig_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The config for Compute Engine Instance Group
   * Manager that manages this group.
   * This is only used for preemptible instance groups.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.ManagedGroupConfig managed_group_config = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.ManagedGroupConfigOrBuilder getManagedGroupConfigOrBuilder() {
    return getManagedGroupConfig();
  }

  public static final int ACCELERATORS_FIELD_NUMBER = 8;
  private java.util.List<com.google.cloud.dataproc.v1.AcceleratorConfig> accelerators_;
  /**
   *
   *
   * <pre>
   * Optional. The Compute Engine accelerator configuration for these
   * instances.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dataproc.v1.AcceleratorConfig accelerators = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.dataproc.v1.AcceleratorConfig> getAcceleratorsList() {
    return accelerators_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The Compute Engine accelerator configuration for these
   * instances.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dataproc.v1.AcceleratorConfig accelerators = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.dataproc.v1.AcceleratorConfigOrBuilder>
      getAcceleratorsOrBuilderList() {
    return accelerators_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The Compute Engine accelerator configuration for these
   * instances.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dataproc.v1.AcceleratorConfig accelerators = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public int getAcceleratorsCount() {
    return accelerators_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. The Compute Engine accelerator configuration for these
   * instances.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dataproc.v1.AcceleratorConfig accelerators = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.AcceleratorConfig getAccelerators(int index) {
    return accelerators_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. The Compute Engine accelerator configuration for these
   * instances.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dataproc.v1.AcceleratorConfig accelerators = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.AcceleratorConfigOrBuilder getAcceleratorsOrBuilder(
      int index) {
    return accelerators_.get(index);
  }

  public static final int MIN_CPU_PLATFORM_FIELD_NUMBER = 9;
  private volatile java.lang.Object minCpuPlatform_;
  /**
   *
   *
   * <pre>
   * Optional. Specifies the minimum cpu platform for the Instance Group.
   * See [Dataproc -&gt; Minimum CPU
   * Platform](https://cloud.google.com/dataproc/docs/concepts/compute/dataproc-min-cpu).
   * </pre>
   *
   * <code>string min_cpu_platform = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The minCpuPlatform.
   */
  @java.lang.Override
  public java.lang.String getMinCpuPlatform() {
    java.lang.Object ref = minCpuPlatform_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      minCpuPlatform_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. Specifies the minimum cpu platform for the Instance Group.
   * See [Dataproc -&gt; Minimum CPU
   * Platform](https://cloud.google.com/dataproc/docs/concepts/compute/dataproc-min-cpu).
   * </pre>
   *
   * <code>string min_cpu_platform = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for minCpuPlatform.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getMinCpuPlatformBytes() {
    java.lang.Object ref = minCpuPlatform_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      minCpuPlatform_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (numInstances_ != 0) {
      output.writeInt32(1, numInstances_);
    }
    for (int i = 0; i < instanceNames_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, instanceNames_.getRaw(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(imageUri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, imageUri_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(machineTypeUri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, machineTypeUri_);
    }
    if (diskConfig_ != null) {
      output.writeMessage(5, getDiskConfig());
    }
    if (isPreemptible_ != false) {
      output.writeBool(6, isPreemptible_);
    }
    if (managedGroupConfig_ != null) {
      output.writeMessage(7, getManagedGroupConfig());
    }
    for (int i = 0; i < accelerators_.size(); i++) {
      output.writeMessage(8, accelerators_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(minCpuPlatform_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 9, minCpuPlatform_);
    }
    if (preemptibility_
        != com.google.cloud.dataproc.v1.InstanceGroupConfig.Preemptibility
            .PREEMPTIBILITY_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(10, preemptibility_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (numInstances_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(1, numInstances_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < instanceNames_.size(); i++) {
        dataSize += computeStringSizeNoTag(instanceNames_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getInstanceNamesList().size();
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(imageUri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, imageUri_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(machineTypeUri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, machineTypeUri_);
    }
    if (diskConfig_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getDiskConfig());
    }
    if (isPreemptible_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(6, isPreemptible_);
    }
    if (managedGroupConfig_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getManagedGroupConfig());
    }
    for (int i = 0; i < accelerators_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, accelerators_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(minCpuPlatform_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(9, minCpuPlatform_);
    }
    if (preemptibility_
        != com.google.cloud.dataproc.v1.InstanceGroupConfig.Preemptibility
            .PREEMPTIBILITY_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(10, preemptibility_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dataproc.v1.InstanceGroupConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.dataproc.v1.InstanceGroupConfig other =
        (com.google.cloud.dataproc.v1.InstanceGroupConfig) obj;

    if (getNumInstances() != other.getNumInstances()) return false;
    if (!getInstanceNamesList().equals(other.getInstanceNamesList())) return false;
    if (!getImageUri().equals(other.getImageUri())) return false;
    if (!getMachineTypeUri().equals(other.getMachineTypeUri())) return false;
    if (hasDiskConfig() != other.hasDiskConfig()) return false;
    if (hasDiskConfig()) {
      if (!getDiskConfig().equals(other.getDiskConfig())) return false;
    }
    if (getIsPreemptible() != other.getIsPreemptible()) return false;
    if (preemptibility_ != other.preemptibility_) return false;
    if (hasManagedGroupConfig() != other.hasManagedGroupConfig()) return false;
    if (hasManagedGroupConfig()) {
      if (!getManagedGroupConfig().equals(other.getManagedGroupConfig())) return false;
    }
    if (!getAcceleratorsList().equals(other.getAcceleratorsList())) return false;
    if (!getMinCpuPlatform().equals(other.getMinCpuPlatform())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NUM_INSTANCES_FIELD_NUMBER;
    hash = (53 * hash) + getNumInstances();
    if (getInstanceNamesCount() > 0) {
      hash = (37 * hash) + INSTANCE_NAMES_FIELD_NUMBER;
      hash = (53 * hash) + getInstanceNamesList().hashCode();
    }
    hash = (37 * hash) + IMAGE_URI_FIELD_NUMBER;
    hash = (53 * hash) + getImageUri().hashCode();
    hash = (37 * hash) + MACHINE_TYPE_URI_FIELD_NUMBER;
    hash = (53 * hash) + getMachineTypeUri().hashCode();
    if (hasDiskConfig()) {
      hash = (37 * hash) + DISK_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getDiskConfig().hashCode();
    }
    hash = (37 * hash) + IS_PREEMPTIBLE_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getIsPreemptible());
    hash = (37 * hash) + PREEMPTIBILITY_FIELD_NUMBER;
    hash = (53 * hash) + preemptibility_;
    if (hasManagedGroupConfig()) {
      hash = (37 * hash) + MANAGED_GROUP_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getManagedGroupConfig().hashCode();
    }
    if (getAcceleratorsCount() > 0) {
      hash = (37 * hash) + ACCELERATORS_FIELD_NUMBER;
      hash = (53 * hash) + getAcceleratorsList().hashCode();
    }
    hash = (37 * hash) + MIN_CPU_PLATFORM_FIELD_NUMBER;
    hash = (53 * hash) + getMinCpuPlatform().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dataproc.v1.InstanceGroupConfig parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1.InstanceGroupConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.InstanceGroupConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1.InstanceGroupConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.InstanceGroupConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1.InstanceGroupConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.InstanceGroupConfig parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1.InstanceGroupConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.InstanceGroupConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1.InstanceGroupConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.InstanceGroupConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1.InstanceGroupConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.dataproc.v1.InstanceGroupConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The config settings for Compute Engine resources in
   * an instance group, such as a master or worker group.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dataproc.v1.InstanceGroupConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dataproc.v1.InstanceGroupConfig)
      com.google.cloud.dataproc.v1.InstanceGroupConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dataproc.v1.ClustersProto
          .internal_static_google_cloud_dataproc_v1_InstanceGroupConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dataproc.v1.ClustersProto
          .internal_static_google_cloud_dataproc_v1_InstanceGroupConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dataproc.v1.InstanceGroupConfig.class,
              com.google.cloud.dataproc.v1.InstanceGroupConfig.Builder.class);
    }

    // Construct using com.google.cloud.dataproc.v1.InstanceGroupConfig.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      numInstances_ = 0;

      instanceNames_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000001);
      imageUri_ = "";

      machineTypeUri_ = "";

      if (diskConfigBuilder_ == null) {
        diskConfig_ = null;
      } else {
        diskConfig_ = null;
        diskConfigBuilder_ = null;
      }
      isPreemptible_ = false;

      preemptibility_ = 0;

      if (managedGroupConfigBuilder_ == null) {
        managedGroupConfig_ = null;
      } else {
        managedGroupConfig_ = null;
        managedGroupConfigBuilder_ = null;
      }
      if (acceleratorsBuilder_ == null) {
        accelerators_ = java.util.Collections.emptyList();
      } else {
        accelerators_ = null;
        acceleratorsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      minCpuPlatform_ = "";

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dataproc.v1.ClustersProto
          .internal_static_google_cloud_dataproc_v1_InstanceGroupConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.InstanceGroupConfig getDefaultInstanceForType() {
      return com.google.cloud.dataproc.v1.InstanceGroupConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.InstanceGroupConfig build() {
      com.google.cloud.dataproc.v1.InstanceGroupConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.InstanceGroupConfig buildPartial() {
      com.google.cloud.dataproc.v1.InstanceGroupConfig result =
          new com.google.cloud.dataproc.v1.InstanceGroupConfig(this);
      int from_bitField0_ = bitField0_;
      result.numInstances_ = numInstances_;
      if (((bitField0_ & 0x00000001) != 0)) {
        instanceNames_ = instanceNames_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000001);
      }
      result.instanceNames_ = instanceNames_;
      result.imageUri_ = imageUri_;
      result.machineTypeUri_ = machineTypeUri_;
      if (diskConfigBuilder_ == null) {
        result.diskConfig_ = diskConfig_;
      } else {
        result.diskConfig_ = diskConfigBuilder_.build();
      }
      result.isPreemptible_ = isPreemptible_;
      result.preemptibility_ = preemptibility_;
      if (managedGroupConfigBuilder_ == null) {
        result.managedGroupConfig_ = managedGroupConfig_;
      } else {
        result.managedGroupConfig_ = managedGroupConfigBuilder_.build();
      }
      if (acceleratorsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          accelerators_ = java.util.Collections.unmodifiableList(accelerators_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.accelerators_ = accelerators_;
      } else {
        result.accelerators_ = acceleratorsBuilder_.build();
      }
      result.minCpuPlatform_ = minCpuPlatform_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dataproc.v1.InstanceGroupConfig) {
        return mergeFrom((com.google.cloud.dataproc.v1.InstanceGroupConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dataproc.v1.InstanceGroupConfig other) {
      if (other == com.google.cloud.dataproc.v1.InstanceGroupConfig.getDefaultInstance())
        return this;
      if (other.getNumInstances() != 0) {
        setNumInstances(other.getNumInstances());
      }
      if (!other.instanceNames_.isEmpty()) {
        if (instanceNames_.isEmpty()) {
          instanceNames_ = other.instanceNames_;
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          ensureInstanceNamesIsMutable();
          instanceNames_.addAll(other.instanceNames_);
        }
        onChanged();
      }
      if (!other.getImageUri().isEmpty()) {
        imageUri_ = other.imageUri_;
        onChanged();
      }
      if (!other.getMachineTypeUri().isEmpty()) {
        machineTypeUri_ = other.machineTypeUri_;
        onChanged();
      }
      if (other.hasDiskConfig()) {
        mergeDiskConfig(other.getDiskConfig());
      }
      if (other.getIsPreemptible() != false) {
        setIsPreemptible(other.getIsPreemptible());
      }
      if (other.preemptibility_ != 0) {
        setPreemptibilityValue(other.getPreemptibilityValue());
      }
      if (other.hasManagedGroupConfig()) {
        mergeManagedGroupConfig(other.getManagedGroupConfig());
      }
      if (acceleratorsBuilder_ == null) {
        if (!other.accelerators_.isEmpty()) {
          if (accelerators_.isEmpty()) {
            accelerators_ = other.accelerators_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureAcceleratorsIsMutable();
            accelerators_.addAll(other.accelerators_);
          }
          onChanged();
        }
      } else {
        if (!other.accelerators_.isEmpty()) {
          if (acceleratorsBuilder_.isEmpty()) {
            acceleratorsBuilder_.dispose();
            acceleratorsBuilder_ = null;
            accelerators_ = other.accelerators_;
            bitField0_ = (bitField0_ & ~0x00000002);
            acceleratorsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getAcceleratorsFieldBuilder()
                    : null;
          } else {
            acceleratorsBuilder_.addAllMessages(other.accelerators_);
          }
        }
      }
      if (!other.getMinCpuPlatform().isEmpty()) {
        minCpuPlatform_ = other.minCpuPlatform_;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                numInstances_ = input.readInt32();

                break;
              } // case 8
            case 18:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureInstanceNamesIsMutable();
                instanceNames_.add(s);
                break;
              } // case 18
            case 26:
              {
                imageUri_ = input.readStringRequireUtf8();

                break;
              } // case 26
            case 34:
              {
                machineTypeUri_ = input.readStringRequireUtf8();

                break;
              } // case 34
            case 42:
              {
                input.readMessage(getDiskConfigFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 42
            case 48:
              {
                isPreemptible_ = input.readBool();

                break;
              } // case 48
            case 58:
              {
                input.readMessage(
                    getManagedGroupConfigFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 58
            case 66:
              {
                com.google.cloud.dataproc.v1.AcceleratorConfig m =
                    input.readMessage(
                        com.google.cloud.dataproc.v1.AcceleratorConfig.parser(), extensionRegistry);
                if (acceleratorsBuilder_ == null) {
                  ensureAcceleratorsIsMutable();
                  accelerators_.add(m);
                } else {
                  acceleratorsBuilder_.addMessage(m);
                }
                break;
              } // case 66
            case 74:
              {
                minCpuPlatform_ = input.readStringRequireUtf8();

                break;
              } // case 74
            case 80:
              {
                preemptibility_ = input.readEnum();

                break;
              } // case 80
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private int numInstances_;
    /**
     *
     *
     * <pre>
     * Optional. The number of VM instances in the instance group.
     * For [HA
     * cluster](/dataproc/docs/concepts/configuring-clusters/high-availability)
     * [master_config](#FIELDS.master_config) groups, **must be set to 3**.
     * For standard cluster [master_config](#FIELDS.master_config) groups,
     * **must be set to 1**.
     * </pre>
     *
     * <code>int32 num_instances = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The numInstances.
     */
    @java.lang.Override
    public int getNumInstances() {
      return numInstances_;
    }
    /**
     *
     *
     * <pre>
     * Optional. The number of VM instances in the instance group.
     * For [HA
     * cluster](/dataproc/docs/concepts/configuring-clusters/high-availability)
     * [master_config](#FIELDS.master_config) groups, **must be set to 3**.
     * For standard cluster [master_config](#FIELDS.master_config) groups,
     * **must be set to 1**.
     * </pre>
     *
     * <code>int32 num_instances = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The numInstances to set.
     * @return This builder for chaining.
     */
    public Builder setNumInstances(int value) {

      numInstances_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The number of VM instances in the instance group.
     * For [HA
     * cluster](/dataproc/docs/concepts/configuring-clusters/high-availability)
     * [master_config](#FIELDS.master_config) groups, **must be set to 3**.
     * For standard cluster [master_config](#FIELDS.master_config) groups,
     * **must be set to 1**.
     * </pre>
     *
     * <code>int32 num_instances = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNumInstances() {

      numInstances_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringList instanceNames_ =
        com.google.protobuf.LazyStringArrayList.EMPTY;

    private void ensureInstanceNamesIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        instanceNames_ = new com.google.protobuf.LazyStringArrayList(instanceNames_);
        bitField0_ |= 0x00000001;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The list of instance names. Dataproc derives the names
     * from `cluster_name`, `num_instances`, and the instance group.
     * </pre>
     *
     * <code>repeated string instance_names = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return A list containing the instanceNames.
     */
    public com.google.protobuf.ProtocolStringList getInstanceNamesList() {
      return instanceNames_.getUnmodifiableView();
    }
    /**
     *
     *
     * <pre>
     * Output only. The list of instance names. Dataproc derives the names
     * from `cluster_name`, `num_instances`, and the instance group.
     * </pre>
     *
     * <code>repeated string instance_names = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The count of instanceNames.
     */
    public int getInstanceNamesCount() {
      return instanceNames_.size();
    }
    /**
     *
     *
     * <pre>
     * Output only. The list of instance names. Dataproc derives the names
     * from `cluster_name`, `num_instances`, and the instance group.
     * </pre>
     *
     * <code>repeated string instance_names = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param index The index of the element to return.
     * @return The instanceNames at the given index.
     */
    public java.lang.String getInstanceNames(int index) {
      return instanceNames_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. The list of instance names. Dataproc derives the names
     * from `cluster_name`, `num_instances`, and the instance group.
     * </pre>
     *
     * <code>repeated string instance_names = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the instanceNames at the given index.
     */
    public com.google.protobuf.ByteString getInstanceNamesBytes(int index) {
      return instanceNames_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. The list of instance names. Dataproc derives the names
     * from `cluster_name`, `num_instances`, and the instance group.
     * </pre>
     *
     * <code>repeated string instance_names = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param index The index to set the value at.
     * @param value The instanceNames to set.
     * @return This builder for chaining.
     */
    public Builder setInstanceNames(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureInstanceNamesIsMutable();
      instanceNames_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The list of instance names. Dataproc derives the names
     * from `cluster_name`, `num_instances`, and the instance group.
     * </pre>
     *
     * <code>repeated string instance_names = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The instanceNames to add.
     * @return This builder for chaining.
     */
    public Builder addInstanceNames(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureInstanceNamesIsMutable();
      instanceNames_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The list of instance names. Dataproc derives the names
     * from `cluster_name`, `num_instances`, and the instance group.
     * </pre>
     *
     * <code>repeated string instance_names = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param values The instanceNames to add.
     * @return This builder for chaining.
     */
    public Builder addAllInstanceNames(java.lang.Iterable<java.lang.String> values) {
      ensureInstanceNamesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, instanceNames_);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The list of instance names. Dataproc derives the names
     * from `cluster_name`, `num_instances`, and the instance group.
     * </pre>
     *
     * <code>repeated string instance_names = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearInstanceNames() {
      instanceNames_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The list of instance names. Dataproc derives the names
     * from `cluster_name`, `num_instances`, and the instance group.
     * </pre>
     *
     * <code>repeated string instance_names = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes of the instanceNames to add.
     * @return This builder for chaining.
     */
    public Builder addInstanceNamesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureInstanceNamesIsMutable();
      instanceNames_.add(value);
      onChanged();
      return this;
    }

    private java.lang.Object imageUri_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The Compute Engine image resource used for cluster instances.
     * The URI can represent an image or image family.
     * Image examples:
     * * `https://www.googleapis.com/compute/beta/projects/[project_id]/global/images/[image-id]`
     * * `projects/[project_id]/global/images/[image-id]`
     * * `image-id`
     * Image family examples. Dataproc will use the most recent
     * image from the family:
     * * `https://www.googleapis.com/compute/beta/projects/[project_id]/global/images/family/[custom-image-family-name]`
     * * `projects/[project_id]/global/images/family/[custom-image-family-name]`
     * If the URI is unspecified, it will be inferred from
     * `SoftwareConfig.image_version` or the system default.
     * </pre>
     *
     * <code>string image_uri = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The imageUri.
     */
    public java.lang.String getImageUri() {
      java.lang.Object ref = imageUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        imageUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The Compute Engine image resource used for cluster instances.
     * The URI can represent an image or image family.
     * Image examples:
     * * `https://www.googleapis.com/compute/beta/projects/[project_id]/global/images/[image-id]`
     * * `projects/[project_id]/global/images/[image-id]`
     * * `image-id`
     * Image family examples. Dataproc will use the most recent
     * image from the family:
     * * `https://www.googleapis.com/compute/beta/projects/[project_id]/global/images/family/[custom-image-family-name]`
     * * `projects/[project_id]/global/images/family/[custom-image-family-name]`
     * If the URI is unspecified, it will be inferred from
     * `SoftwareConfig.image_version` or the system default.
     * </pre>
     *
     * <code>string image_uri = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for imageUri.
     */
    public com.google.protobuf.ByteString getImageUriBytes() {
      java.lang.Object ref = imageUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        imageUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The Compute Engine image resource used for cluster instances.
     * The URI can represent an image or image family.
     * Image examples:
     * * `https://www.googleapis.com/compute/beta/projects/[project_id]/global/images/[image-id]`
     * * `projects/[project_id]/global/images/[image-id]`
     * * `image-id`
     * Image family examples. Dataproc will use the most recent
     * image from the family:
     * * `https://www.googleapis.com/compute/beta/projects/[project_id]/global/images/family/[custom-image-family-name]`
     * * `projects/[project_id]/global/images/family/[custom-image-family-name]`
     * If the URI is unspecified, it will be inferred from
     * `SoftwareConfig.image_version` or the system default.
     * </pre>
     *
     * <code>string image_uri = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The imageUri to set.
     * @return This builder for chaining.
     */
    public Builder setImageUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      imageUri_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The Compute Engine image resource used for cluster instances.
     * The URI can represent an image or image family.
     * Image examples:
     * * `https://www.googleapis.com/compute/beta/projects/[project_id]/global/images/[image-id]`
     * * `projects/[project_id]/global/images/[image-id]`
     * * `image-id`
     * Image family examples. Dataproc will use the most recent
     * image from the family:
     * * `https://www.googleapis.com/compute/beta/projects/[project_id]/global/images/family/[custom-image-family-name]`
     * * `projects/[project_id]/global/images/family/[custom-image-family-name]`
     * If the URI is unspecified, it will be inferred from
     * `SoftwareConfig.image_version` or the system default.
     * </pre>
     *
     * <code>string image_uri = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearImageUri() {

      imageUri_ = getDefaultInstance().getImageUri();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The Compute Engine image resource used for cluster instances.
     * The URI can represent an image or image family.
     * Image examples:
     * * `https://www.googleapis.com/compute/beta/projects/[project_id]/global/images/[image-id]`
     * * `projects/[project_id]/global/images/[image-id]`
     * * `image-id`
     * Image family examples. Dataproc will use the most recent
     * image from the family:
     * * `https://www.googleapis.com/compute/beta/projects/[project_id]/global/images/family/[custom-image-family-name]`
     * * `projects/[project_id]/global/images/family/[custom-image-family-name]`
     * If the URI is unspecified, it will be inferred from
     * `SoftwareConfig.image_version` or the system default.
     * </pre>
     *
     * <code>string image_uri = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for imageUri to set.
     * @return This builder for chaining.
     */
    public Builder setImageUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      imageUri_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object machineTypeUri_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The Compute Engine machine type used for cluster instances.
     * A full URL, partial URI, or short name are valid. Examples:
     * * `https://www.googleapis.com/compute/v1/projects/[project_id]/zones/us-east1-a/machineTypes/n1-standard-2`
     * * `projects/[project_id]/zones/us-east1-a/machineTypes/n1-standard-2`
     * * `n1-standard-2`
     * **Auto Zone Exception**: If you are using the Dataproc
     * [Auto Zone
     * Placement](https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/auto-zone#using_auto_zone_placement)
     * feature, you must use the short name of the machine type
     * resource, for example, `n1-standard-2`.
     * </pre>
     *
     * <code>string machine_type_uri = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The machineTypeUri.
     */
    public java.lang.String getMachineTypeUri() {
      java.lang.Object ref = machineTypeUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        machineTypeUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The Compute Engine machine type used for cluster instances.
     * A full URL, partial URI, or short name are valid. Examples:
     * * `https://www.googleapis.com/compute/v1/projects/[project_id]/zones/us-east1-a/machineTypes/n1-standard-2`
     * * `projects/[project_id]/zones/us-east1-a/machineTypes/n1-standard-2`
     * * `n1-standard-2`
     * **Auto Zone Exception**: If you are using the Dataproc
     * [Auto Zone
     * Placement](https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/auto-zone#using_auto_zone_placement)
     * feature, you must use the short name of the machine type
     * resource, for example, `n1-standard-2`.
     * </pre>
     *
     * <code>string machine_type_uri = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for machineTypeUri.
     */
    public com.google.protobuf.ByteString getMachineTypeUriBytes() {
      java.lang.Object ref = machineTypeUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        machineTypeUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The Compute Engine machine type used for cluster instances.
     * A full URL, partial URI, or short name are valid. Examples:
     * * `https://www.googleapis.com/compute/v1/projects/[project_id]/zones/us-east1-a/machineTypes/n1-standard-2`
     * * `projects/[project_id]/zones/us-east1-a/machineTypes/n1-standard-2`
     * * `n1-standard-2`
     * **Auto Zone Exception**: If you are using the Dataproc
     * [Auto Zone
     * Placement](https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/auto-zone#using_auto_zone_placement)
     * feature, you must use the short name of the machine type
     * resource, for example, `n1-standard-2`.
     * </pre>
     *
     * <code>string machine_type_uri = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The machineTypeUri to set.
     * @return This builder for chaining.
     */
    public Builder setMachineTypeUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      machineTypeUri_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The Compute Engine machine type used for cluster instances.
     * A full URL, partial URI, or short name are valid. Examples:
     * * `https://www.googleapis.com/compute/v1/projects/[project_id]/zones/us-east1-a/machineTypes/n1-standard-2`
     * * `projects/[project_id]/zones/us-east1-a/machineTypes/n1-standard-2`
     * * `n1-standard-2`
     * **Auto Zone Exception**: If you are using the Dataproc
     * [Auto Zone
     * Placement](https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/auto-zone#using_auto_zone_placement)
     * feature, you must use the short name of the machine type
     * resource, for example, `n1-standard-2`.
     * </pre>
     *
     * <code>string machine_type_uri = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMachineTypeUri() {

      machineTypeUri_ = getDefaultInstance().getMachineTypeUri();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The Compute Engine machine type used for cluster instances.
     * A full URL, partial URI, or short name are valid. Examples:
     * * `https://www.googleapis.com/compute/v1/projects/[project_id]/zones/us-east1-a/machineTypes/n1-standard-2`
     * * `projects/[project_id]/zones/us-east1-a/machineTypes/n1-standard-2`
     * * `n1-standard-2`
     * **Auto Zone Exception**: If you are using the Dataproc
     * [Auto Zone
     * Placement](https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/auto-zone#using_auto_zone_placement)
     * feature, you must use the short name of the machine type
     * resource, for example, `n1-standard-2`.
     * </pre>
     *
     * <code>string machine_type_uri = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for machineTypeUri to set.
     * @return This builder for chaining.
     */
    public Builder setMachineTypeUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      machineTypeUri_ = value;
      onChanged();
      return this;
    }

    private com.google.cloud.dataproc.v1.DiskConfig diskConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.DiskConfig,
            com.google.cloud.dataproc.v1.DiskConfig.Builder,
            com.google.cloud.dataproc.v1.DiskConfigOrBuilder>
        diskConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Disk option config settings.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.DiskConfig disk_config = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the diskConfig field is set.
     */
    public boolean hasDiskConfig() {
      return diskConfigBuilder_ != null || diskConfig_ != null;
    }
    /**
     *
     *
     * <pre>
     * Optional. Disk option config settings.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.DiskConfig disk_config = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The diskConfig.
     */
    public com.google.cloud.dataproc.v1.DiskConfig getDiskConfig() {
      if (diskConfigBuilder_ == null) {
        return diskConfig_ == null
            ? com.google.cloud.dataproc.v1.DiskConfig.getDefaultInstance()
            : diskConfig_;
      } else {
        return diskConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Disk option config settings.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.DiskConfig disk_config = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setDiskConfig(com.google.cloud.dataproc.v1.DiskConfig value) {
      if (diskConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        diskConfig_ = value;
        onChanged();
      } else {
        diskConfigBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Disk option config settings.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.DiskConfig disk_config = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setDiskConfig(com.google.cloud.dataproc.v1.DiskConfig.Builder builderForValue) {
      if (diskConfigBuilder_ == null) {
        diskConfig_ = builderForValue.build();
        onChanged();
      } else {
        diskConfigBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Disk option config settings.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.DiskConfig disk_config = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeDiskConfig(com.google.cloud.dataproc.v1.DiskConfig value) {
      if (diskConfigBuilder_ == null) {
        if (diskConfig_ != null) {
          diskConfig_ =
              com.google.cloud.dataproc.v1.DiskConfig.newBuilder(diskConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          diskConfig_ = value;
        }
        onChanged();
      } else {
        diskConfigBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Disk option config settings.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.DiskConfig disk_config = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearDiskConfig() {
      if (diskConfigBuilder_ == null) {
        diskConfig_ = null;
        onChanged();
      } else {
        diskConfig_ = null;
        diskConfigBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Disk option config settings.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.DiskConfig disk_config = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataproc.v1.DiskConfig.Builder getDiskConfigBuilder() {

      onChanged();
      return getDiskConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Disk option config settings.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.DiskConfig disk_config = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataproc.v1.DiskConfigOrBuilder getDiskConfigOrBuilder() {
      if (diskConfigBuilder_ != null) {
        return diskConfigBuilder_.getMessageOrBuilder();
      } else {
        return diskConfig_ == null
            ? com.google.cloud.dataproc.v1.DiskConfig.getDefaultInstance()
            : diskConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Disk option config settings.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.DiskConfig disk_config = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.DiskConfig,
            com.google.cloud.dataproc.v1.DiskConfig.Builder,
            com.google.cloud.dataproc.v1.DiskConfigOrBuilder>
        getDiskConfigFieldBuilder() {
      if (diskConfigBuilder_ == null) {
        diskConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataproc.v1.DiskConfig,
                com.google.cloud.dataproc.v1.DiskConfig.Builder,
                com.google.cloud.dataproc.v1.DiskConfigOrBuilder>(
                getDiskConfig(), getParentForChildren(), isClean());
        diskConfig_ = null;
      }
      return diskConfigBuilder_;
    }

    private boolean isPreemptible_;
    /**
     *
     *
     * <pre>
     * Output only. Specifies that this instance group contains preemptible
     * instances.
     * </pre>
     *
     * <code>bool is_preemptible = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The isPreemptible.
     */
    @java.lang.Override
    public boolean getIsPreemptible() {
      return isPreemptible_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Specifies that this instance group contains preemptible
     * instances.
     * </pre>
     *
     * <code>bool is_preemptible = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The isPreemptible to set.
     * @return This builder for chaining.
     */
    public Builder setIsPreemptible(boolean value) {

      isPreemptible_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Specifies that this instance group contains preemptible
     * instances.
     * </pre>
     *
     * <code>bool is_preemptible = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIsPreemptible() {

      isPreemptible_ = false;
      onChanged();
      return this;
    }

    private int preemptibility_ = 0;
    /**
     *
     *
     * <pre>
     * Optional. Specifies the preemptibility of the instance group.
     * The default value for master and worker groups is
     * `NON_PREEMPTIBLE`. This default cannot be changed.
     * The default value for secondary instances is
     * `PREEMPTIBLE`.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.InstanceGroupConfig.Preemptibility preemptibility = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enum numeric value on the wire for preemptibility.
     */
    @java.lang.Override
    public int getPreemptibilityValue() {
      return preemptibility_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Specifies the preemptibility of the instance group.
     * The default value for master and worker groups is
     * `NON_PREEMPTIBLE`. This default cannot be changed.
     * The default value for secondary instances is
     * `PREEMPTIBLE`.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.InstanceGroupConfig.Preemptibility preemptibility = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The enum numeric value on the wire for preemptibility to set.
     * @return This builder for chaining.
     */
    public Builder setPreemptibilityValue(int value) {

      preemptibility_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Specifies the preemptibility of the instance group.
     * The default value for master and worker groups is
     * `NON_PREEMPTIBLE`. This default cannot be changed.
     * The default value for secondary instances is
     * `PREEMPTIBLE`.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.InstanceGroupConfig.Preemptibility preemptibility = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The preemptibility.
     */
    @java.lang.Override
    public com.google.cloud.dataproc.v1.InstanceGroupConfig.Preemptibility getPreemptibility() {
      @SuppressWarnings("deprecation")
      com.google.cloud.dataproc.v1.InstanceGroupConfig.Preemptibility result =
          com.google.cloud.dataproc.v1.InstanceGroupConfig.Preemptibility.valueOf(preemptibility_);
      return result == null
          ? com.google.cloud.dataproc.v1.InstanceGroupConfig.Preemptibility.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Optional. Specifies the preemptibility of the instance group.
     * The default value for master and worker groups is
     * `NON_PREEMPTIBLE`. This default cannot be changed.
     * The default value for secondary instances is
     * `PREEMPTIBLE`.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.InstanceGroupConfig.Preemptibility preemptibility = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The preemptibility to set.
     * @return This builder for chaining.
     */
    public Builder setPreemptibility(
        com.google.cloud.dataproc.v1.InstanceGroupConfig.Preemptibility value) {
      if (value == null) {
        throw new NullPointerException();
      }

      preemptibility_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Specifies the preemptibility of the instance group.
     * The default value for master and worker groups is
     * `NON_PREEMPTIBLE`. This default cannot be changed.
     * The default value for secondary instances is
     * `PREEMPTIBLE`.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.InstanceGroupConfig.Preemptibility preemptibility = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPreemptibility() {

      preemptibility_ = 0;
      onChanged();
      return this;
    }

    private com.google.cloud.dataproc.v1.ManagedGroupConfig managedGroupConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.ManagedGroupConfig,
            com.google.cloud.dataproc.v1.ManagedGroupConfig.Builder,
            com.google.cloud.dataproc.v1.ManagedGroupConfigOrBuilder>
        managedGroupConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The config for Compute Engine Instance Group
     * Manager that manages this group.
     * This is only used for preemptible instance groups.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.ManagedGroupConfig managed_group_config = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the managedGroupConfig field is set.
     */
    public boolean hasManagedGroupConfig() {
      return managedGroupConfigBuilder_ != null || managedGroupConfig_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. The config for Compute Engine Instance Group
     * Manager that manages this group.
     * This is only used for preemptible instance groups.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.ManagedGroupConfig managed_group_config = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The managedGroupConfig.
     */
    public com.google.cloud.dataproc.v1.ManagedGroupConfig getManagedGroupConfig() {
      if (managedGroupConfigBuilder_ == null) {
        return managedGroupConfig_ == null
            ? com.google.cloud.dataproc.v1.ManagedGroupConfig.getDefaultInstance()
            : managedGroupConfig_;
      } else {
        return managedGroupConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The config for Compute Engine Instance Group
     * Manager that manages this group.
     * This is only used for preemptible instance groups.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.ManagedGroupConfig managed_group_config = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setManagedGroupConfig(com.google.cloud.dataproc.v1.ManagedGroupConfig value) {
      if (managedGroupConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        managedGroupConfig_ = value;
        onChanged();
      } else {
        managedGroupConfigBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The config for Compute Engine Instance Group
     * Manager that manages this group.
     * This is only used for preemptible instance groups.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.ManagedGroupConfig managed_group_config = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setManagedGroupConfig(
        com.google.cloud.dataproc.v1.ManagedGroupConfig.Builder builderForValue) {
      if (managedGroupConfigBuilder_ == null) {
        managedGroupConfig_ = builderForValue.build();
        onChanged();
      } else {
        managedGroupConfigBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The config for Compute Engine Instance Group
     * Manager that manages this group.
     * This is only used for preemptible instance groups.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.ManagedGroupConfig managed_group_config = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeManagedGroupConfig(com.google.cloud.dataproc.v1.ManagedGroupConfig value) {
      if (managedGroupConfigBuilder_ == null) {
        if (managedGroupConfig_ != null) {
          managedGroupConfig_ =
              com.google.cloud.dataproc.v1.ManagedGroupConfig.newBuilder(managedGroupConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          managedGroupConfig_ = value;
        }
        onChanged();
      } else {
        managedGroupConfigBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The config for Compute Engine Instance Group
     * Manager that manages this group.
     * This is only used for preemptible instance groups.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.ManagedGroupConfig managed_group_config = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearManagedGroupConfig() {
      if (managedGroupConfigBuilder_ == null) {
        managedGroupConfig_ = null;
        onChanged();
      } else {
        managedGroupConfig_ = null;
        managedGroupConfigBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The config for Compute Engine Instance Group
     * Manager that manages this group.
     * This is only used for preemptible instance groups.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.ManagedGroupConfig managed_group_config = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.dataproc.v1.ManagedGroupConfig.Builder getManagedGroupConfigBuilder() {

      onChanged();
      return getManagedGroupConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The config for Compute Engine Instance Group
     * Manager that manages this group.
     * This is only used for preemptible instance groups.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.ManagedGroupConfig managed_group_config = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.dataproc.v1.ManagedGroupConfigOrBuilder
        getManagedGroupConfigOrBuilder() {
      if (managedGroupConfigBuilder_ != null) {
        return managedGroupConfigBuilder_.getMessageOrBuilder();
      } else {
        return managedGroupConfig_ == null
            ? com.google.cloud.dataproc.v1.ManagedGroupConfig.getDefaultInstance()
            : managedGroupConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The config for Compute Engine Instance Group
     * Manager that manages this group.
     * This is only used for preemptible instance groups.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.ManagedGroupConfig managed_group_config = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.ManagedGroupConfig,
            com.google.cloud.dataproc.v1.ManagedGroupConfig.Builder,
            com.google.cloud.dataproc.v1.ManagedGroupConfigOrBuilder>
        getManagedGroupConfigFieldBuilder() {
      if (managedGroupConfigBuilder_ == null) {
        managedGroupConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataproc.v1.ManagedGroupConfig,
                com.google.cloud.dataproc.v1.ManagedGroupConfig.Builder,
                com.google.cloud.dataproc.v1.ManagedGroupConfigOrBuilder>(
                getManagedGroupConfig(), getParentForChildren(), isClean());
        managedGroupConfig_ = null;
      }
      return managedGroupConfigBuilder_;
    }

    private java.util.List<com.google.cloud.dataproc.v1.AcceleratorConfig> accelerators_ =
        java.util.Collections.emptyList();

    private void ensureAcceleratorsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        accelerators_ =
            new java.util.ArrayList<com.google.cloud.dataproc.v1.AcceleratorConfig>(accelerators_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dataproc.v1.AcceleratorConfig,
            com.google.cloud.dataproc.v1.AcceleratorConfig.Builder,
            com.google.cloud.dataproc.v1.AcceleratorConfigOrBuilder>
        acceleratorsBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. The Compute Engine accelerator configuration for these
     * instances.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.AcceleratorConfig accelerators = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.dataproc.v1.AcceleratorConfig> getAcceleratorsList() {
      if (acceleratorsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(accelerators_);
      } else {
        return acceleratorsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The Compute Engine accelerator configuration for these
     * instances.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.AcceleratorConfig accelerators = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public int getAcceleratorsCount() {
      if (acceleratorsBuilder_ == null) {
        return accelerators_.size();
      } else {
        return acceleratorsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The Compute Engine accelerator configuration for these
     * instances.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.AcceleratorConfig accelerators = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataproc.v1.AcceleratorConfig getAccelerators(int index) {
      if (acceleratorsBuilder_ == null) {
        return accelerators_.get(index);
      } else {
        return acceleratorsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The Compute Engine accelerator configuration for these
     * instances.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.AcceleratorConfig accelerators = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setAccelerators(
        int index, com.google.cloud.dataproc.v1.AcceleratorConfig value) {
      if (acceleratorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAcceleratorsIsMutable();
        accelerators_.set(index, value);
        onChanged();
      } else {
        acceleratorsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The Compute Engine accelerator configuration for these
     * instances.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.AcceleratorConfig accelerators = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setAccelerators(
        int index, com.google.cloud.dataproc.v1.AcceleratorConfig.Builder builderForValue) {
      if (acceleratorsBuilder_ == null) {
        ensureAcceleratorsIsMutable();
        accelerators_.set(index, builderForValue.build());
        onChanged();
      } else {
        acceleratorsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The Compute Engine accelerator configuration for these
     * instances.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.AcceleratorConfig accelerators = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAccelerators(com.google.cloud.dataproc.v1.AcceleratorConfig value) {
      if (acceleratorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAcceleratorsIsMutable();
        accelerators_.add(value);
        onChanged();
      } else {
        acceleratorsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The Compute Engine accelerator configuration for these
     * instances.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.AcceleratorConfig accelerators = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAccelerators(
        int index, com.google.cloud.dataproc.v1.AcceleratorConfig value) {
      if (acceleratorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAcceleratorsIsMutable();
        accelerators_.add(index, value);
        onChanged();
      } else {
        acceleratorsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The Compute Engine accelerator configuration for these
     * instances.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.AcceleratorConfig accelerators = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAccelerators(
        com.google.cloud.dataproc.v1.AcceleratorConfig.Builder builderForValue) {
      if (acceleratorsBuilder_ == null) {
        ensureAcceleratorsIsMutable();
        accelerators_.add(builderForValue.build());
        onChanged();
      } else {
        acceleratorsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The Compute Engine accelerator configuration for these
     * instances.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.AcceleratorConfig accelerators = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAccelerators(
        int index, com.google.cloud.dataproc.v1.AcceleratorConfig.Builder builderForValue) {
      if (acceleratorsBuilder_ == null) {
        ensureAcceleratorsIsMutable();
        accelerators_.add(index, builderForValue.build());
        onChanged();
      } else {
        acceleratorsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The Compute Engine accelerator configuration for these
     * instances.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.AcceleratorConfig accelerators = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAllAccelerators(
        java.lang.Iterable<? extends com.google.cloud.dataproc.v1.AcceleratorConfig> values) {
      if (acceleratorsBuilder_ == null) {
        ensureAcceleratorsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, accelerators_);
        onChanged();
      } else {
        acceleratorsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The Compute Engine accelerator configuration for these
     * instances.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.AcceleratorConfig accelerators = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearAccelerators() {
      if (acceleratorsBuilder_ == null) {
        accelerators_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        acceleratorsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The Compute Engine accelerator configuration for these
     * instances.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.AcceleratorConfig accelerators = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeAccelerators(int index) {
      if (acceleratorsBuilder_ == null) {
        ensureAcceleratorsIsMutable();
        accelerators_.remove(index);
        onChanged();
      } else {
        acceleratorsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The Compute Engine accelerator configuration for these
     * instances.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.AcceleratorConfig accelerators = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataproc.v1.AcceleratorConfig.Builder getAcceleratorsBuilder(
        int index) {
      return getAcceleratorsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. The Compute Engine accelerator configuration for these
     * instances.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.AcceleratorConfig accelerators = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataproc.v1.AcceleratorConfigOrBuilder getAcceleratorsOrBuilder(
        int index) {
      if (acceleratorsBuilder_ == null) {
        return accelerators_.get(index);
      } else {
        return acceleratorsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The Compute Engine accelerator configuration for these
     * instances.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.AcceleratorConfig accelerators = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.dataproc.v1.AcceleratorConfigOrBuilder>
        getAcceleratorsOrBuilderList() {
      if (acceleratorsBuilder_ != null) {
        return acceleratorsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(accelerators_);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The Compute Engine accelerator configuration for these
     * instances.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.AcceleratorConfig accelerators = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataproc.v1.AcceleratorConfig.Builder addAcceleratorsBuilder() {
      return getAcceleratorsFieldBuilder()
          .addBuilder(com.google.cloud.dataproc.v1.AcceleratorConfig.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. The Compute Engine accelerator configuration for these
     * instances.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.AcceleratorConfig accelerators = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataproc.v1.AcceleratorConfig.Builder addAcceleratorsBuilder(
        int index) {
      return getAcceleratorsFieldBuilder()
          .addBuilder(index, com.google.cloud.dataproc.v1.AcceleratorConfig.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. The Compute Engine accelerator configuration for these
     * instances.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.AcceleratorConfig accelerators = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.dataproc.v1.AcceleratorConfig.Builder>
        getAcceleratorsBuilderList() {
      return getAcceleratorsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dataproc.v1.AcceleratorConfig,
            com.google.cloud.dataproc.v1.AcceleratorConfig.Builder,
            com.google.cloud.dataproc.v1.AcceleratorConfigOrBuilder>
        getAcceleratorsFieldBuilder() {
      if (acceleratorsBuilder_ == null) {
        acceleratorsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.dataproc.v1.AcceleratorConfig,
                com.google.cloud.dataproc.v1.AcceleratorConfig.Builder,
                com.google.cloud.dataproc.v1.AcceleratorConfigOrBuilder>(
                accelerators_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
        accelerators_ = null;
      }
      return acceleratorsBuilder_;
    }

    private java.lang.Object minCpuPlatform_ = "";
    /**
     *
     *
     * <pre>
     * Optional. Specifies the minimum cpu platform for the Instance Group.
     * See [Dataproc -&gt; Minimum CPU
     * Platform](https://cloud.google.com/dataproc/docs/concepts/compute/dataproc-min-cpu).
     * </pre>
     *
     * <code>string min_cpu_platform = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The minCpuPlatform.
     */
    public java.lang.String getMinCpuPlatform() {
      java.lang.Object ref = minCpuPlatform_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        minCpuPlatform_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Specifies the minimum cpu platform for the Instance Group.
     * See [Dataproc -&gt; Minimum CPU
     * Platform](https://cloud.google.com/dataproc/docs/concepts/compute/dataproc-min-cpu).
     * </pre>
     *
     * <code>string min_cpu_platform = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for minCpuPlatform.
     */
    public com.google.protobuf.ByteString getMinCpuPlatformBytes() {
      java.lang.Object ref = minCpuPlatform_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        minCpuPlatform_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Specifies the minimum cpu platform for the Instance Group.
     * See [Dataproc -&gt; Minimum CPU
     * Platform](https://cloud.google.com/dataproc/docs/concepts/compute/dataproc-min-cpu).
     * </pre>
     *
     * <code>string min_cpu_platform = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The minCpuPlatform to set.
     * @return This builder for chaining.
     */
    public Builder setMinCpuPlatform(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      minCpuPlatform_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Specifies the minimum cpu platform for the Instance Group.
     * See [Dataproc -&gt; Minimum CPU
     * Platform](https://cloud.google.com/dataproc/docs/concepts/compute/dataproc-min-cpu).
     * </pre>
     *
     * <code>string min_cpu_platform = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMinCpuPlatform() {

      minCpuPlatform_ = getDefaultInstance().getMinCpuPlatform();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Specifies the minimum cpu platform for the Instance Group.
     * See [Dataproc -&gt; Minimum CPU
     * Platform](https://cloud.google.com/dataproc/docs/concepts/compute/dataproc-min-cpu).
     * </pre>
     *
     * <code>string min_cpu_platform = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for minCpuPlatform to set.
     * @return This builder for chaining.
     */
    public Builder setMinCpuPlatformBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      minCpuPlatform_ = value;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dataproc.v1.InstanceGroupConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dataproc.v1.InstanceGroupConfig)
  private static final com.google.cloud.dataproc.v1.InstanceGroupConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dataproc.v1.InstanceGroupConfig();
  }

  public static com.google.cloud.dataproc.v1.InstanceGroupConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<InstanceGroupConfig> PARSER =
      new com.google.protobuf.AbstractParser<InstanceGroupConfig>() {
        @java.lang.Override
        public InstanceGroupConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<InstanceGroupConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<InstanceGroupConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dataproc.v1.InstanceGroupConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
