/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dataproc/v1/jobs.proto

package com.google.cloud.dataproc.v1;

/**
 *
 *
 * <pre>
 * Job scheduling options.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dataproc.v1.JobScheduling}
 */
public final class JobScheduling extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dataproc.v1.JobScheduling)
    JobSchedulingOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use JobScheduling.newBuilder() to construct.
  private JobScheduling(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private JobScheduling() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new JobScheduling();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dataproc.v1.JobsProto
        .internal_static_google_cloud_dataproc_v1_JobScheduling_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dataproc.v1.JobsProto
        .internal_static_google_cloud_dataproc_v1_JobScheduling_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dataproc.v1.JobScheduling.class,
            com.google.cloud.dataproc.v1.JobScheduling.Builder.class);
  }

  public static final int MAX_FAILURES_PER_HOUR_FIELD_NUMBER = 1;
  private int maxFailuresPerHour_;
  /**
   *
   *
   * <pre>
   * Optional. Maximum number of times per hour a driver may be restarted as
   * a result of driver exiting with non-zero code before job is
   * reported failed.
   * A job may be reported as thrashing if driver exits with non-zero code
   * 4 times within 10 minute window.
   * Maximum value is 10.
   * **Note:** Currently, this restartable job option is
   * not supported in Dataproc
   * [workflow
   * template](https://cloud.google.com/dataproc/docs/concepts/workflows/using-workflows#adding_jobs_to_a_template)
   * jobs.
   * </pre>
   *
   * <code>int32 max_failures_per_hour = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The maxFailuresPerHour.
   */
  @java.lang.Override
  public int getMaxFailuresPerHour() {
    return maxFailuresPerHour_;
  }

  public static final int MAX_FAILURES_TOTAL_FIELD_NUMBER = 2;
  private int maxFailuresTotal_;
  /**
   *
   *
   * <pre>
   * Optional. Maximum number of times in total a driver may be restarted as a result of
   * driver exiting with non-zero code before job is reported failed.
   * Maximum value is 240.
   * **Note:** Currently, this restartable job option is
   * not supported in Dataproc
   * [workflow
   * template](https://cloud.google.com/dataproc/docs/concepts/workflows/using-workflows#adding_jobs_to_a_template)
   * jobs.
   * </pre>
   *
   * <code>int32 max_failures_total = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The maxFailuresTotal.
   */
  @java.lang.Override
  public int getMaxFailuresTotal() {
    return maxFailuresTotal_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (maxFailuresPerHour_ != 0) {
      output.writeInt32(1, maxFailuresPerHour_);
    }
    if (maxFailuresTotal_ != 0) {
      output.writeInt32(2, maxFailuresTotal_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (maxFailuresPerHour_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(1, maxFailuresPerHour_);
    }
    if (maxFailuresTotal_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, maxFailuresTotal_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dataproc.v1.JobScheduling)) {
      return super.equals(obj);
    }
    com.google.cloud.dataproc.v1.JobScheduling other =
        (com.google.cloud.dataproc.v1.JobScheduling) obj;

    if (getMaxFailuresPerHour() != other.getMaxFailuresPerHour()) return false;
    if (getMaxFailuresTotal() != other.getMaxFailuresTotal()) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + MAX_FAILURES_PER_HOUR_FIELD_NUMBER;
    hash = (53 * hash) + getMaxFailuresPerHour();
    hash = (37 * hash) + MAX_FAILURES_TOTAL_FIELD_NUMBER;
    hash = (53 * hash) + getMaxFailuresTotal();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dataproc.v1.JobScheduling parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1.JobScheduling parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.JobScheduling parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1.JobScheduling parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.JobScheduling parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1.JobScheduling parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.JobScheduling parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1.JobScheduling parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.JobScheduling parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1.JobScheduling parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.JobScheduling parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1.JobScheduling parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.dataproc.v1.JobScheduling prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Job scheduling options.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dataproc.v1.JobScheduling}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dataproc.v1.JobScheduling)
      com.google.cloud.dataproc.v1.JobSchedulingOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dataproc.v1.JobsProto
          .internal_static_google_cloud_dataproc_v1_JobScheduling_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dataproc.v1.JobsProto
          .internal_static_google_cloud_dataproc_v1_JobScheduling_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dataproc.v1.JobScheduling.class,
              com.google.cloud.dataproc.v1.JobScheduling.Builder.class);
    }

    // Construct using com.google.cloud.dataproc.v1.JobScheduling.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      maxFailuresPerHour_ = 0;

      maxFailuresTotal_ = 0;

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dataproc.v1.JobsProto
          .internal_static_google_cloud_dataproc_v1_JobScheduling_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.JobScheduling getDefaultInstanceForType() {
      return com.google.cloud.dataproc.v1.JobScheduling.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.JobScheduling build() {
      com.google.cloud.dataproc.v1.JobScheduling result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.JobScheduling buildPartial() {
      com.google.cloud.dataproc.v1.JobScheduling result =
          new com.google.cloud.dataproc.v1.JobScheduling(this);
      result.maxFailuresPerHour_ = maxFailuresPerHour_;
      result.maxFailuresTotal_ = maxFailuresTotal_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dataproc.v1.JobScheduling) {
        return mergeFrom((com.google.cloud.dataproc.v1.JobScheduling) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dataproc.v1.JobScheduling other) {
      if (other == com.google.cloud.dataproc.v1.JobScheduling.getDefaultInstance()) return this;
      if (other.getMaxFailuresPerHour() != 0) {
        setMaxFailuresPerHour(other.getMaxFailuresPerHour());
      }
      if (other.getMaxFailuresTotal() != 0) {
        setMaxFailuresTotal(other.getMaxFailuresTotal());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                maxFailuresPerHour_ = input.readInt32();

                break;
              } // case 8
            case 16:
              {
                maxFailuresTotal_ = input.readInt32();

                break;
              } // case 16
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int maxFailuresPerHour_;
    /**
     *
     *
     * <pre>
     * Optional. Maximum number of times per hour a driver may be restarted as
     * a result of driver exiting with non-zero code before job is
     * reported failed.
     * A job may be reported as thrashing if driver exits with non-zero code
     * 4 times within 10 minute window.
     * Maximum value is 10.
     * **Note:** Currently, this restartable job option is
     * not supported in Dataproc
     * [workflow
     * template](https://cloud.google.com/dataproc/docs/concepts/workflows/using-workflows#adding_jobs_to_a_template)
     * jobs.
     * </pre>
     *
     * <code>int32 max_failures_per_hour = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The maxFailuresPerHour.
     */
    @java.lang.Override
    public int getMaxFailuresPerHour() {
      return maxFailuresPerHour_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Maximum number of times per hour a driver may be restarted as
     * a result of driver exiting with non-zero code before job is
     * reported failed.
     * A job may be reported as thrashing if driver exits with non-zero code
     * 4 times within 10 minute window.
     * Maximum value is 10.
     * **Note:** Currently, this restartable job option is
     * not supported in Dataproc
     * [workflow
     * template](https://cloud.google.com/dataproc/docs/concepts/workflows/using-workflows#adding_jobs_to_a_template)
     * jobs.
     * </pre>
     *
     * <code>int32 max_failures_per_hour = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The maxFailuresPerHour to set.
     * @return This builder for chaining.
     */
    public Builder setMaxFailuresPerHour(int value) {

      maxFailuresPerHour_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Maximum number of times per hour a driver may be restarted as
     * a result of driver exiting with non-zero code before job is
     * reported failed.
     * A job may be reported as thrashing if driver exits with non-zero code
     * 4 times within 10 minute window.
     * Maximum value is 10.
     * **Note:** Currently, this restartable job option is
     * not supported in Dataproc
     * [workflow
     * template](https://cloud.google.com/dataproc/docs/concepts/workflows/using-workflows#adding_jobs_to_a_template)
     * jobs.
     * </pre>
     *
     * <code>int32 max_failures_per_hour = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMaxFailuresPerHour() {

      maxFailuresPerHour_ = 0;
      onChanged();
      return this;
    }

    private int maxFailuresTotal_;
    /**
     *
     *
     * <pre>
     * Optional. Maximum number of times in total a driver may be restarted as a result of
     * driver exiting with non-zero code before job is reported failed.
     * Maximum value is 240.
     * **Note:** Currently, this restartable job option is
     * not supported in Dataproc
     * [workflow
     * template](https://cloud.google.com/dataproc/docs/concepts/workflows/using-workflows#adding_jobs_to_a_template)
     * jobs.
     * </pre>
     *
     * <code>int32 max_failures_total = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The maxFailuresTotal.
     */
    @java.lang.Override
    public int getMaxFailuresTotal() {
      return maxFailuresTotal_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Maximum number of times in total a driver may be restarted as a result of
     * driver exiting with non-zero code before job is reported failed.
     * Maximum value is 240.
     * **Note:** Currently, this restartable job option is
     * not supported in Dataproc
     * [workflow
     * template](https://cloud.google.com/dataproc/docs/concepts/workflows/using-workflows#adding_jobs_to_a_template)
     * jobs.
     * </pre>
     *
     * <code>int32 max_failures_total = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The maxFailuresTotal to set.
     * @return This builder for chaining.
     */
    public Builder setMaxFailuresTotal(int value) {

      maxFailuresTotal_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Maximum number of times in total a driver may be restarted as a result of
     * driver exiting with non-zero code before job is reported failed.
     * Maximum value is 240.
     * **Note:** Currently, this restartable job option is
     * not supported in Dataproc
     * [workflow
     * template](https://cloud.google.com/dataproc/docs/concepts/workflows/using-workflows#adding_jobs_to_a_template)
     * jobs.
     * </pre>
     *
     * <code>int32 max_failures_total = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMaxFailuresTotal() {

      maxFailuresTotal_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dataproc.v1.JobScheduling)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dataproc.v1.JobScheduling)
  private static final com.google.cloud.dataproc.v1.JobScheduling DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dataproc.v1.JobScheduling();
  }

  public static com.google.cloud.dataproc.v1.JobScheduling getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<JobScheduling> PARSER =
      new com.google.protobuf.AbstractParser<JobScheduling>() {
        @java.lang.Override
        public JobScheduling parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<JobScheduling> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<JobScheduling> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dataproc.v1.JobScheduling getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
