/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dataproc/v1/shared.proto

package com.google.cloud.dataproc.v1;

/**
 *
 *
 * <pre>
 * The configuration for running the Dataproc cluster on Kubernetes.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dataproc.v1.KubernetesClusterConfig}
 */
public final class KubernetesClusterConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dataproc.v1.KubernetesClusterConfig)
    KubernetesClusterConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use KubernetesClusterConfig.newBuilder() to construct.
  private KubernetesClusterConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private KubernetesClusterConfig() {
    kubernetesNamespace_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new KubernetesClusterConfig();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dataproc.v1.SharedProto
        .internal_static_google_cloud_dataproc_v1_KubernetesClusterConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dataproc.v1.SharedProto
        .internal_static_google_cloud_dataproc_v1_KubernetesClusterConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dataproc.v1.KubernetesClusterConfig.class,
            com.google.cloud.dataproc.v1.KubernetesClusterConfig.Builder.class);
  }

  private int configCase_ = 0;
  private java.lang.Object config_;

  public enum ConfigCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    GKE_CLUSTER_CONFIG(2),
    CONFIG_NOT_SET(0);
    private final int value;

    private ConfigCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ConfigCase valueOf(int value) {
      return forNumber(value);
    }

    public static ConfigCase forNumber(int value) {
      switch (value) {
        case 2:
          return GKE_CLUSTER_CONFIG;
        case 0:
          return CONFIG_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public ConfigCase getConfigCase() {
    return ConfigCase.forNumber(configCase_);
  }

  public static final int KUBERNETES_NAMESPACE_FIELD_NUMBER = 1;
  private volatile java.lang.Object kubernetesNamespace_;
  /**
   *
   *
   * <pre>
   * Optional. A namespace within the Kubernetes cluster to deploy into. If this namespace
   * does not exist, it is created. If it exists, Dataproc
   * verifies that another Dataproc VirtualCluster is not installed
   * into it. If not specified, the name of the Dataproc Cluster is used.
   * </pre>
   *
   * <code>string kubernetes_namespace = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The kubernetesNamespace.
   */
  @java.lang.Override
  public java.lang.String getKubernetesNamespace() {
    java.lang.Object ref = kubernetesNamespace_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      kubernetesNamespace_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. A namespace within the Kubernetes cluster to deploy into. If this namespace
   * does not exist, it is created. If it exists, Dataproc
   * verifies that another Dataproc VirtualCluster is not installed
   * into it. If not specified, the name of the Dataproc Cluster is used.
   * </pre>
   *
   * <code>string kubernetes_namespace = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for kubernetesNamespace.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getKubernetesNamespaceBytes() {
    java.lang.Object ref = kubernetesNamespace_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      kubernetesNamespace_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int GKE_CLUSTER_CONFIG_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * Required. The configuration for running the Dataproc cluster on GKE.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.GkeClusterConfig gke_cluster_config = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the gkeClusterConfig field is set.
   */
  @java.lang.Override
  public boolean hasGkeClusterConfig() {
    return configCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * Required. The configuration for running the Dataproc cluster on GKE.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.GkeClusterConfig gke_cluster_config = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The gkeClusterConfig.
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.GkeClusterConfig getGkeClusterConfig() {
    if (configCase_ == 2) {
      return (com.google.cloud.dataproc.v1.GkeClusterConfig) config_;
    }
    return com.google.cloud.dataproc.v1.GkeClusterConfig.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Required. The configuration for running the Dataproc cluster on GKE.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.GkeClusterConfig gke_cluster_config = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.GkeClusterConfigOrBuilder getGkeClusterConfigOrBuilder() {
    if (configCase_ == 2) {
      return (com.google.cloud.dataproc.v1.GkeClusterConfig) config_;
    }
    return com.google.cloud.dataproc.v1.GkeClusterConfig.getDefaultInstance();
  }

  public static final int KUBERNETES_SOFTWARE_CONFIG_FIELD_NUMBER = 3;
  private com.google.cloud.dataproc.v1.KubernetesSoftwareConfig kubernetesSoftwareConfig_;
  /**
   *
   *
   * <pre>
   * Optional. The software configuration for this Dataproc cluster running on Kubernetes.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.KubernetesSoftwareConfig kubernetes_software_config = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the kubernetesSoftwareConfig field is set.
   */
  @java.lang.Override
  public boolean hasKubernetesSoftwareConfig() {
    return kubernetesSoftwareConfig_ != null;
  }
  /**
   *
   *
   * <pre>
   * Optional. The software configuration for this Dataproc cluster running on Kubernetes.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.KubernetesSoftwareConfig kubernetes_software_config = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The kubernetesSoftwareConfig.
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.KubernetesSoftwareConfig getKubernetesSoftwareConfig() {
    return kubernetesSoftwareConfig_ == null
        ? com.google.cloud.dataproc.v1.KubernetesSoftwareConfig.getDefaultInstance()
        : kubernetesSoftwareConfig_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The software configuration for this Dataproc cluster running on Kubernetes.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.KubernetesSoftwareConfig kubernetes_software_config = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.KubernetesSoftwareConfigOrBuilder
      getKubernetesSoftwareConfigOrBuilder() {
    return getKubernetesSoftwareConfig();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(kubernetesNamespace_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, kubernetesNamespace_);
    }
    if (configCase_ == 2) {
      output.writeMessage(2, (com.google.cloud.dataproc.v1.GkeClusterConfig) config_);
    }
    if (kubernetesSoftwareConfig_ != null) {
      output.writeMessage(3, getKubernetesSoftwareConfig());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(kubernetesNamespace_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, kubernetesNamespace_);
    }
    if (configCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.google.cloud.dataproc.v1.GkeClusterConfig) config_);
    }
    if (kubernetesSoftwareConfig_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, getKubernetesSoftwareConfig());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dataproc.v1.KubernetesClusterConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.dataproc.v1.KubernetesClusterConfig other =
        (com.google.cloud.dataproc.v1.KubernetesClusterConfig) obj;

    if (!getKubernetesNamespace().equals(other.getKubernetesNamespace())) return false;
    if (hasKubernetesSoftwareConfig() != other.hasKubernetesSoftwareConfig()) return false;
    if (hasKubernetesSoftwareConfig()) {
      if (!getKubernetesSoftwareConfig().equals(other.getKubernetesSoftwareConfig())) return false;
    }
    if (!getConfigCase().equals(other.getConfigCase())) return false;
    switch (configCase_) {
      case 2:
        if (!getGkeClusterConfig().equals(other.getGkeClusterConfig())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + KUBERNETES_NAMESPACE_FIELD_NUMBER;
    hash = (53 * hash) + getKubernetesNamespace().hashCode();
    if (hasKubernetesSoftwareConfig()) {
      hash = (37 * hash) + KUBERNETES_SOFTWARE_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getKubernetesSoftwareConfig().hashCode();
    }
    switch (configCase_) {
      case 2:
        hash = (37 * hash) + GKE_CLUSTER_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getGkeClusterConfig().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dataproc.v1.KubernetesClusterConfig parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1.KubernetesClusterConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.KubernetesClusterConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1.KubernetesClusterConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.KubernetesClusterConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1.KubernetesClusterConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.KubernetesClusterConfig parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1.KubernetesClusterConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.KubernetesClusterConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1.KubernetesClusterConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.KubernetesClusterConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1.KubernetesClusterConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.dataproc.v1.KubernetesClusterConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The configuration for running the Dataproc cluster on Kubernetes.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dataproc.v1.KubernetesClusterConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dataproc.v1.KubernetesClusterConfig)
      com.google.cloud.dataproc.v1.KubernetesClusterConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dataproc.v1.SharedProto
          .internal_static_google_cloud_dataproc_v1_KubernetesClusterConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dataproc.v1.SharedProto
          .internal_static_google_cloud_dataproc_v1_KubernetesClusterConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dataproc.v1.KubernetesClusterConfig.class,
              com.google.cloud.dataproc.v1.KubernetesClusterConfig.Builder.class);
    }

    // Construct using com.google.cloud.dataproc.v1.KubernetesClusterConfig.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      kubernetesNamespace_ = "";

      if (gkeClusterConfigBuilder_ != null) {
        gkeClusterConfigBuilder_.clear();
      }
      if (kubernetesSoftwareConfigBuilder_ == null) {
        kubernetesSoftwareConfig_ = null;
      } else {
        kubernetesSoftwareConfig_ = null;
        kubernetesSoftwareConfigBuilder_ = null;
      }
      configCase_ = 0;
      config_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dataproc.v1.SharedProto
          .internal_static_google_cloud_dataproc_v1_KubernetesClusterConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.KubernetesClusterConfig getDefaultInstanceForType() {
      return com.google.cloud.dataproc.v1.KubernetesClusterConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.KubernetesClusterConfig build() {
      com.google.cloud.dataproc.v1.KubernetesClusterConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.KubernetesClusterConfig buildPartial() {
      com.google.cloud.dataproc.v1.KubernetesClusterConfig result =
          new com.google.cloud.dataproc.v1.KubernetesClusterConfig(this);
      result.kubernetesNamespace_ = kubernetesNamespace_;
      if (configCase_ == 2) {
        if (gkeClusterConfigBuilder_ == null) {
          result.config_ = config_;
        } else {
          result.config_ = gkeClusterConfigBuilder_.build();
        }
      }
      if (kubernetesSoftwareConfigBuilder_ == null) {
        result.kubernetesSoftwareConfig_ = kubernetesSoftwareConfig_;
      } else {
        result.kubernetesSoftwareConfig_ = kubernetesSoftwareConfigBuilder_.build();
      }
      result.configCase_ = configCase_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dataproc.v1.KubernetesClusterConfig) {
        return mergeFrom((com.google.cloud.dataproc.v1.KubernetesClusterConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dataproc.v1.KubernetesClusterConfig other) {
      if (other == com.google.cloud.dataproc.v1.KubernetesClusterConfig.getDefaultInstance())
        return this;
      if (!other.getKubernetesNamespace().isEmpty()) {
        kubernetesNamespace_ = other.kubernetesNamespace_;
        onChanged();
      }
      if (other.hasKubernetesSoftwareConfig()) {
        mergeKubernetesSoftwareConfig(other.getKubernetesSoftwareConfig());
      }
      switch (other.getConfigCase()) {
        case GKE_CLUSTER_CONFIG:
          {
            mergeGkeClusterConfig(other.getGkeClusterConfig());
            break;
          }
        case CONFIG_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                kubernetesNamespace_ = input.readStringRequireUtf8();

                break;
              } // case 10
            case 18:
              {
                input.readMessage(
                    getGkeClusterConfigFieldBuilder().getBuilder(), extensionRegistry);
                configCase_ = 2;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(
                    getKubernetesSoftwareConfigFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int configCase_ = 0;
    private java.lang.Object config_;

    public ConfigCase getConfigCase() {
      return ConfigCase.forNumber(configCase_);
    }

    public Builder clearConfig() {
      configCase_ = 0;
      config_ = null;
      onChanged();
      return this;
    }

    private java.lang.Object kubernetesNamespace_ = "";
    /**
     *
     *
     * <pre>
     * Optional. A namespace within the Kubernetes cluster to deploy into. If this namespace
     * does not exist, it is created. If it exists, Dataproc
     * verifies that another Dataproc VirtualCluster is not installed
     * into it. If not specified, the name of the Dataproc Cluster is used.
     * </pre>
     *
     * <code>string kubernetes_namespace = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The kubernetesNamespace.
     */
    public java.lang.String getKubernetesNamespace() {
      java.lang.Object ref = kubernetesNamespace_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        kubernetesNamespace_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A namespace within the Kubernetes cluster to deploy into. If this namespace
     * does not exist, it is created. If it exists, Dataproc
     * verifies that another Dataproc VirtualCluster is not installed
     * into it. If not specified, the name of the Dataproc Cluster is used.
     * </pre>
     *
     * <code>string kubernetes_namespace = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for kubernetesNamespace.
     */
    public com.google.protobuf.ByteString getKubernetesNamespaceBytes() {
      java.lang.Object ref = kubernetesNamespace_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        kubernetesNamespace_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A namespace within the Kubernetes cluster to deploy into. If this namespace
     * does not exist, it is created. If it exists, Dataproc
     * verifies that another Dataproc VirtualCluster is not installed
     * into it. If not specified, the name of the Dataproc Cluster is used.
     * </pre>
     *
     * <code>string kubernetes_namespace = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The kubernetesNamespace to set.
     * @return This builder for chaining.
     */
    public Builder setKubernetesNamespace(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      kubernetesNamespace_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A namespace within the Kubernetes cluster to deploy into. If this namespace
     * does not exist, it is created. If it exists, Dataproc
     * verifies that another Dataproc VirtualCluster is not installed
     * into it. If not specified, the name of the Dataproc Cluster is used.
     * </pre>
     *
     * <code>string kubernetes_namespace = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearKubernetesNamespace() {

      kubernetesNamespace_ = getDefaultInstance().getKubernetesNamespace();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A namespace within the Kubernetes cluster to deploy into. If this namespace
     * does not exist, it is created. If it exists, Dataproc
     * verifies that another Dataproc VirtualCluster is not installed
     * into it. If not specified, the name of the Dataproc Cluster is used.
     * </pre>
     *
     * <code>string kubernetes_namespace = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for kubernetesNamespace to set.
     * @return This builder for chaining.
     */
    public Builder setKubernetesNamespaceBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      kubernetesNamespace_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.GkeClusterConfig,
            com.google.cloud.dataproc.v1.GkeClusterConfig.Builder,
            com.google.cloud.dataproc.v1.GkeClusterConfigOrBuilder>
        gkeClusterConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Required. The configuration for running the Dataproc cluster on GKE.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.GkeClusterConfig gke_cluster_config = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the gkeClusterConfig field is set.
     */
    @java.lang.Override
    public boolean hasGkeClusterConfig() {
      return configCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * Required. The configuration for running the Dataproc cluster on GKE.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.GkeClusterConfig gke_cluster_config = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The gkeClusterConfig.
     */
    @java.lang.Override
    public com.google.cloud.dataproc.v1.GkeClusterConfig getGkeClusterConfig() {
      if (gkeClusterConfigBuilder_ == null) {
        if (configCase_ == 2) {
          return (com.google.cloud.dataproc.v1.GkeClusterConfig) config_;
        }
        return com.google.cloud.dataproc.v1.GkeClusterConfig.getDefaultInstance();
      } else {
        if (configCase_ == 2) {
          return gkeClusterConfigBuilder_.getMessage();
        }
        return com.google.cloud.dataproc.v1.GkeClusterConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The configuration for running the Dataproc cluster on GKE.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.GkeClusterConfig gke_cluster_config = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setGkeClusterConfig(com.google.cloud.dataproc.v1.GkeClusterConfig value) {
      if (gkeClusterConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        config_ = value;
        onChanged();
      } else {
        gkeClusterConfigBuilder_.setMessage(value);
      }
      configCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The configuration for running the Dataproc cluster on GKE.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.GkeClusterConfig gke_cluster_config = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setGkeClusterConfig(
        com.google.cloud.dataproc.v1.GkeClusterConfig.Builder builderForValue) {
      if (gkeClusterConfigBuilder_ == null) {
        config_ = builderForValue.build();
        onChanged();
      } else {
        gkeClusterConfigBuilder_.setMessage(builderForValue.build());
      }
      configCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The configuration for running the Dataproc cluster on GKE.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.GkeClusterConfig gke_cluster_config = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeGkeClusterConfig(com.google.cloud.dataproc.v1.GkeClusterConfig value) {
      if (gkeClusterConfigBuilder_ == null) {
        if (configCase_ == 2
            && config_ != com.google.cloud.dataproc.v1.GkeClusterConfig.getDefaultInstance()) {
          config_ =
              com.google.cloud.dataproc.v1.GkeClusterConfig.newBuilder(
                      (com.google.cloud.dataproc.v1.GkeClusterConfig) config_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          config_ = value;
        }
        onChanged();
      } else {
        if (configCase_ == 2) {
          gkeClusterConfigBuilder_.mergeFrom(value);
        } else {
          gkeClusterConfigBuilder_.setMessage(value);
        }
      }
      configCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The configuration for running the Dataproc cluster on GKE.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.GkeClusterConfig gke_cluster_config = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearGkeClusterConfig() {
      if (gkeClusterConfigBuilder_ == null) {
        if (configCase_ == 2) {
          configCase_ = 0;
          config_ = null;
          onChanged();
        }
      } else {
        if (configCase_ == 2) {
          configCase_ = 0;
          config_ = null;
        }
        gkeClusterConfigBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The configuration for running the Dataproc cluster on GKE.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.GkeClusterConfig gke_cluster_config = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.dataproc.v1.GkeClusterConfig.Builder getGkeClusterConfigBuilder() {
      return getGkeClusterConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. The configuration for running the Dataproc cluster on GKE.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.GkeClusterConfig gke_cluster_config = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dataproc.v1.GkeClusterConfigOrBuilder getGkeClusterConfigOrBuilder() {
      if ((configCase_ == 2) && (gkeClusterConfigBuilder_ != null)) {
        return gkeClusterConfigBuilder_.getMessageOrBuilder();
      } else {
        if (configCase_ == 2) {
          return (com.google.cloud.dataproc.v1.GkeClusterConfig) config_;
        }
        return com.google.cloud.dataproc.v1.GkeClusterConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The configuration for running the Dataproc cluster on GKE.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.GkeClusterConfig gke_cluster_config = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.GkeClusterConfig,
            com.google.cloud.dataproc.v1.GkeClusterConfig.Builder,
            com.google.cloud.dataproc.v1.GkeClusterConfigOrBuilder>
        getGkeClusterConfigFieldBuilder() {
      if (gkeClusterConfigBuilder_ == null) {
        if (!(configCase_ == 2)) {
          config_ = com.google.cloud.dataproc.v1.GkeClusterConfig.getDefaultInstance();
        }
        gkeClusterConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataproc.v1.GkeClusterConfig,
                com.google.cloud.dataproc.v1.GkeClusterConfig.Builder,
                com.google.cloud.dataproc.v1.GkeClusterConfigOrBuilder>(
                (com.google.cloud.dataproc.v1.GkeClusterConfig) config_,
                getParentForChildren(),
                isClean());
        config_ = null;
      }
      configCase_ = 2;
      onChanged();
      ;
      return gkeClusterConfigBuilder_;
    }

    private com.google.cloud.dataproc.v1.KubernetesSoftwareConfig kubernetesSoftwareConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.KubernetesSoftwareConfig,
            com.google.cloud.dataproc.v1.KubernetesSoftwareConfig.Builder,
            com.google.cloud.dataproc.v1.KubernetesSoftwareConfigOrBuilder>
        kubernetesSoftwareConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. The software configuration for this Dataproc cluster running on Kubernetes.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.KubernetesSoftwareConfig kubernetes_software_config = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the kubernetesSoftwareConfig field is set.
     */
    public boolean hasKubernetesSoftwareConfig() {
      return kubernetesSoftwareConfigBuilder_ != null || kubernetesSoftwareConfig_ != null;
    }
    /**
     *
     *
     * <pre>
     * Optional. The software configuration for this Dataproc cluster running on Kubernetes.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.KubernetesSoftwareConfig kubernetes_software_config = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The kubernetesSoftwareConfig.
     */
    public com.google.cloud.dataproc.v1.KubernetesSoftwareConfig getKubernetesSoftwareConfig() {
      if (kubernetesSoftwareConfigBuilder_ == null) {
        return kubernetesSoftwareConfig_ == null
            ? com.google.cloud.dataproc.v1.KubernetesSoftwareConfig.getDefaultInstance()
            : kubernetesSoftwareConfig_;
      } else {
        return kubernetesSoftwareConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The software configuration for this Dataproc cluster running on Kubernetes.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.KubernetesSoftwareConfig kubernetes_software_config = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setKubernetesSoftwareConfig(
        com.google.cloud.dataproc.v1.KubernetesSoftwareConfig value) {
      if (kubernetesSoftwareConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        kubernetesSoftwareConfig_ = value;
        onChanged();
      } else {
        kubernetesSoftwareConfigBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The software configuration for this Dataproc cluster running on Kubernetes.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.KubernetesSoftwareConfig kubernetes_software_config = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setKubernetesSoftwareConfig(
        com.google.cloud.dataproc.v1.KubernetesSoftwareConfig.Builder builderForValue) {
      if (kubernetesSoftwareConfigBuilder_ == null) {
        kubernetesSoftwareConfig_ = builderForValue.build();
        onChanged();
      } else {
        kubernetesSoftwareConfigBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The software configuration for this Dataproc cluster running on Kubernetes.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.KubernetesSoftwareConfig kubernetes_software_config = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeKubernetesSoftwareConfig(
        com.google.cloud.dataproc.v1.KubernetesSoftwareConfig value) {
      if (kubernetesSoftwareConfigBuilder_ == null) {
        if (kubernetesSoftwareConfig_ != null) {
          kubernetesSoftwareConfig_ =
              com.google.cloud.dataproc.v1.KubernetesSoftwareConfig.newBuilder(
                      kubernetesSoftwareConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          kubernetesSoftwareConfig_ = value;
        }
        onChanged();
      } else {
        kubernetesSoftwareConfigBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The software configuration for this Dataproc cluster running on Kubernetes.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.KubernetesSoftwareConfig kubernetes_software_config = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearKubernetesSoftwareConfig() {
      if (kubernetesSoftwareConfigBuilder_ == null) {
        kubernetesSoftwareConfig_ = null;
        onChanged();
      } else {
        kubernetesSoftwareConfig_ = null;
        kubernetesSoftwareConfigBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The software configuration for this Dataproc cluster running on Kubernetes.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.KubernetesSoftwareConfig kubernetes_software_config = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataproc.v1.KubernetesSoftwareConfig.Builder
        getKubernetesSoftwareConfigBuilder() {

      onChanged();
      return getKubernetesSoftwareConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. The software configuration for this Dataproc cluster running on Kubernetes.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.KubernetesSoftwareConfig kubernetes_software_config = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataproc.v1.KubernetesSoftwareConfigOrBuilder
        getKubernetesSoftwareConfigOrBuilder() {
      if (kubernetesSoftwareConfigBuilder_ != null) {
        return kubernetesSoftwareConfigBuilder_.getMessageOrBuilder();
      } else {
        return kubernetesSoftwareConfig_ == null
            ? com.google.cloud.dataproc.v1.KubernetesSoftwareConfig.getDefaultInstance()
            : kubernetesSoftwareConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The software configuration for this Dataproc cluster running on Kubernetes.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.KubernetesSoftwareConfig kubernetes_software_config = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.KubernetesSoftwareConfig,
            com.google.cloud.dataproc.v1.KubernetesSoftwareConfig.Builder,
            com.google.cloud.dataproc.v1.KubernetesSoftwareConfigOrBuilder>
        getKubernetesSoftwareConfigFieldBuilder() {
      if (kubernetesSoftwareConfigBuilder_ == null) {
        kubernetesSoftwareConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataproc.v1.KubernetesSoftwareConfig,
                com.google.cloud.dataproc.v1.KubernetesSoftwareConfig.Builder,
                com.google.cloud.dataproc.v1.KubernetesSoftwareConfigOrBuilder>(
                getKubernetesSoftwareConfig(), getParentForChildren(), isClean());
        kubernetesSoftwareConfig_ = null;
      }
      return kubernetesSoftwareConfigBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dataproc.v1.KubernetesClusterConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dataproc.v1.KubernetesClusterConfig)
  private static final com.google.cloud.dataproc.v1.KubernetesClusterConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dataproc.v1.KubernetesClusterConfig();
  }

  public static com.google.cloud.dataproc.v1.KubernetesClusterConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<KubernetesClusterConfig> PARSER =
      new com.google.protobuf.AbstractParser<KubernetesClusterConfig>() {
        @java.lang.Override
        public KubernetesClusterConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<KubernetesClusterConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<KubernetesClusterConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dataproc.v1.KubernetesClusterConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
