/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dataproc/v1/jobs.proto

package com.google.cloud.dataproc.v1;

/**
 *
 *
 * <pre>
 * A Dataproc job for running [Presto](https://prestosql.io/) queries.
 * **IMPORTANT**: The [Dataproc Presto Optional
 * Component](https://cloud.google.com/dataproc/docs/concepts/components/presto)
 * must be enabled when the cluster is created to submit a Presto job to the
 * cluster.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dataproc.v1.PrestoJob}
 */
public final class PrestoJob extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dataproc.v1.PrestoJob)
    PrestoJobOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use PrestoJob.newBuilder() to construct.
  private PrestoJob(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private PrestoJob() {
    outputFormat_ = "";
    clientTags_ = com.google.protobuf.LazyStringArrayList.EMPTY;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new PrestoJob();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dataproc.v1.JobsProto
        .internal_static_google_cloud_dataproc_v1_PrestoJob_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 6:
        return internalGetProperties();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dataproc.v1.JobsProto
        .internal_static_google_cloud_dataproc_v1_PrestoJob_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dataproc.v1.PrestoJob.class,
            com.google.cloud.dataproc.v1.PrestoJob.Builder.class);
  }

  private int queriesCase_ = 0;
  private java.lang.Object queries_;

  public enum QueriesCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    QUERY_FILE_URI(1),
    QUERY_LIST(2),
    QUERIES_NOT_SET(0);
    private final int value;

    private QueriesCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static QueriesCase valueOf(int value) {
      return forNumber(value);
    }

    public static QueriesCase forNumber(int value) {
      switch (value) {
        case 1:
          return QUERY_FILE_URI;
        case 2:
          return QUERY_LIST;
        case 0:
          return QUERIES_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public QueriesCase getQueriesCase() {
    return QueriesCase.forNumber(queriesCase_);
  }

  public static final int QUERY_FILE_URI_FIELD_NUMBER = 1;
  /**
   *
   *
   * <pre>
   * The HCFS URI of the script that contains SQL queries.
   * </pre>
   *
   * <code>string query_file_uri = 1;</code>
   *
   * @return Whether the queryFileUri field is set.
   */
  public boolean hasQueryFileUri() {
    return queriesCase_ == 1;
  }
  /**
   *
   *
   * <pre>
   * The HCFS URI of the script that contains SQL queries.
   * </pre>
   *
   * <code>string query_file_uri = 1;</code>
   *
   * @return The queryFileUri.
   */
  public java.lang.String getQueryFileUri() {
    java.lang.Object ref = "";
    if (queriesCase_ == 1) {
      ref = queries_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (queriesCase_ == 1) {
        queries_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The HCFS URI of the script that contains SQL queries.
   * </pre>
   *
   * <code>string query_file_uri = 1;</code>
   *
   * @return The bytes for queryFileUri.
   */
  public com.google.protobuf.ByteString getQueryFileUriBytes() {
    java.lang.Object ref = "";
    if (queriesCase_ == 1) {
      ref = queries_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (queriesCase_ == 1) {
        queries_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int QUERY_LIST_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * A list of queries.
   * </pre>
   *
   * <code>.google.cloud.dataproc.v1.QueryList query_list = 2;</code>
   *
   * @return Whether the queryList field is set.
   */
  @java.lang.Override
  public boolean hasQueryList() {
    return queriesCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * A list of queries.
   * </pre>
   *
   * <code>.google.cloud.dataproc.v1.QueryList query_list = 2;</code>
   *
   * @return The queryList.
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.QueryList getQueryList() {
    if (queriesCase_ == 2) {
      return (com.google.cloud.dataproc.v1.QueryList) queries_;
    }
    return com.google.cloud.dataproc.v1.QueryList.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * A list of queries.
   * </pre>
   *
   * <code>.google.cloud.dataproc.v1.QueryList query_list = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.QueryListOrBuilder getQueryListOrBuilder() {
    if (queriesCase_ == 2) {
      return (com.google.cloud.dataproc.v1.QueryList) queries_;
    }
    return com.google.cloud.dataproc.v1.QueryList.getDefaultInstance();
  }

  public static final int CONTINUE_ON_FAILURE_FIELD_NUMBER = 3;
  private boolean continueOnFailure_;
  /**
   *
   *
   * <pre>
   * Optional. Whether to continue executing queries if a query fails.
   * The default value is `false`. Setting to `true` can be useful when
   * executing independent parallel queries.
   * </pre>
   *
   * <code>bool continue_on_failure = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The continueOnFailure.
   */
  @java.lang.Override
  public boolean getContinueOnFailure() {
    return continueOnFailure_;
  }

  public static final int OUTPUT_FORMAT_FIELD_NUMBER = 4;
  private volatile java.lang.Object outputFormat_;
  /**
   *
   *
   * <pre>
   * Optional. The format in which query output will be displayed. See the
   * Presto documentation for supported output formats
   * </pre>
   *
   * <code>string output_format = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The outputFormat.
   */
  @java.lang.Override
  public java.lang.String getOutputFormat() {
    java.lang.Object ref = outputFormat_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      outputFormat_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The format in which query output will be displayed. See the
   * Presto documentation for supported output formats
   * </pre>
   *
   * <code>string output_format = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for outputFormat.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getOutputFormatBytes() {
    java.lang.Object ref = outputFormat_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      outputFormat_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CLIENT_TAGS_FIELD_NUMBER = 5;
  private com.google.protobuf.LazyStringList clientTags_;
  /**
   *
   *
   * <pre>
   * Optional. Presto client tags to attach to this query
   * </pre>
   *
   * <code>repeated string client_tags = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return A list containing the clientTags.
   */
  public com.google.protobuf.ProtocolStringList getClientTagsList() {
    return clientTags_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Presto client tags to attach to this query
   * </pre>
   *
   * <code>repeated string client_tags = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The count of clientTags.
   */
  public int getClientTagsCount() {
    return clientTags_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. Presto client tags to attach to this query
   * </pre>
   *
   * <code>repeated string client_tags = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the element to return.
   * @return The clientTags at the given index.
   */
  public java.lang.String getClientTags(int index) {
    return clientTags_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. Presto client tags to attach to this query
   * </pre>
   *
   * <code>repeated string client_tags = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the clientTags at the given index.
   */
  public com.google.protobuf.ByteString getClientTagsBytes(int index) {
    return clientTags_.getByteString(index);
  }

  public static final int PROPERTIES_FIELD_NUMBER = 6;

  private static final class PropertiesDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.dataproc.v1.JobsProto
                .internal_static_google_cloud_dataproc_v1_PrestoJob_PropertiesEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> properties_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetProperties() {
    if (properties_ == null) {
      return com.google.protobuf.MapField.emptyMapField(PropertiesDefaultEntryHolder.defaultEntry);
    }
    return properties_;
  }

  public int getPropertiesCount() {
    return internalGetProperties().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Optional. A mapping of property names to values. Used to set Presto
   * [session properties](https://prestodb.io/docs/current/sql/set-session.html)
   * Equivalent to using the --session flag in the Presto CLI
   * </pre>
   *
   * <code>map&lt;string, string&gt; properties = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public boolean containsProperties(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetProperties().getMap().containsKey(key);
  }
  /** Use {@link #getPropertiesMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getProperties() {
    return getPropertiesMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. A mapping of property names to values. Used to set Presto
   * [session properties](https://prestodb.io/docs/current/sql/set-session.html)
   * Equivalent to using the --session flag in the Presto CLI
   * </pre>
   *
   * <code>map&lt;string, string&gt; properties = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getPropertiesMap() {
    return internalGetProperties().getMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. A mapping of property names to values. Used to set Presto
   * [session properties](https://prestodb.io/docs/current/sql/set-session.html)
   * Equivalent to using the --session flag in the Presto CLI
   * </pre>
   *
   * <code>map&lt;string, string&gt; properties = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.lang.String getPropertiesOrDefault(
      java.lang.String key, java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetProperties().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Optional. A mapping of property names to values. Used to set Presto
   * [session properties](https://prestodb.io/docs/current/sql/set-session.html)
   * Equivalent to using the --session flag in the Presto CLI
   * </pre>
   *
   * <code>map&lt;string, string&gt; properties = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.lang.String getPropertiesOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetProperties().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int LOGGING_CONFIG_FIELD_NUMBER = 7;
  private com.google.cloud.dataproc.v1.LoggingConfig loggingConfig_;
  /**
   *
   *
   * <pre>
   * Optional. The runtime log config for job execution.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.LoggingConfig logging_config = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the loggingConfig field is set.
   */
  @java.lang.Override
  public boolean hasLoggingConfig() {
    return loggingConfig_ != null;
  }
  /**
   *
   *
   * <pre>
   * Optional. The runtime log config for job execution.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.LoggingConfig logging_config = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The loggingConfig.
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.LoggingConfig getLoggingConfig() {
    return loggingConfig_ == null
        ? com.google.cloud.dataproc.v1.LoggingConfig.getDefaultInstance()
        : loggingConfig_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The runtime log config for job execution.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.LoggingConfig logging_config = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.LoggingConfigOrBuilder getLoggingConfigOrBuilder() {
    return getLoggingConfig();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (queriesCase_ == 1) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, queries_);
    }
    if (queriesCase_ == 2) {
      output.writeMessage(2, (com.google.cloud.dataproc.v1.QueryList) queries_);
    }
    if (continueOnFailure_ != false) {
      output.writeBool(3, continueOnFailure_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(outputFormat_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, outputFormat_);
    }
    for (int i = 0; i < clientTags_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, clientTags_.getRaw(i));
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetProperties(), PropertiesDefaultEntryHolder.defaultEntry, 6);
    if (loggingConfig_ != null) {
      output.writeMessage(7, getLoggingConfig());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (queriesCase_ == 1) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, queries_);
    }
    if (queriesCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.google.cloud.dataproc.v1.QueryList) queries_);
    }
    if (continueOnFailure_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(3, continueOnFailure_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(outputFormat_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, outputFormat_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < clientTags_.size(); i++) {
        dataSize += computeStringSizeNoTag(clientTags_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getClientTagsList().size();
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetProperties().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> properties__ =
          PropertiesDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, properties__);
    }
    if (loggingConfig_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getLoggingConfig());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dataproc.v1.PrestoJob)) {
      return super.equals(obj);
    }
    com.google.cloud.dataproc.v1.PrestoJob other = (com.google.cloud.dataproc.v1.PrestoJob) obj;

    if (getContinueOnFailure() != other.getContinueOnFailure()) return false;
    if (!getOutputFormat().equals(other.getOutputFormat())) return false;
    if (!getClientTagsList().equals(other.getClientTagsList())) return false;
    if (!internalGetProperties().equals(other.internalGetProperties())) return false;
    if (hasLoggingConfig() != other.hasLoggingConfig()) return false;
    if (hasLoggingConfig()) {
      if (!getLoggingConfig().equals(other.getLoggingConfig())) return false;
    }
    if (!getQueriesCase().equals(other.getQueriesCase())) return false;
    switch (queriesCase_) {
      case 1:
        if (!getQueryFileUri().equals(other.getQueryFileUri())) return false;
        break;
      case 2:
        if (!getQueryList().equals(other.getQueryList())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + CONTINUE_ON_FAILURE_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getContinueOnFailure());
    hash = (37 * hash) + OUTPUT_FORMAT_FIELD_NUMBER;
    hash = (53 * hash) + getOutputFormat().hashCode();
    if (getClientTagsCount() > 0) {
      hash = (37 * hash) + CLIENT_TAGS_FIELD_NUMBER;
      hash = (53 * hash) + getClientTagsList().hashCode();
    }
    if (!internalGetProperties().getMap().isEmpty()) {
      hash = (37 * hash) + PROPERTIES_FIELD_NUMBER;
      hash = (53 * hash) + internalGetProperties().hashCode();
    }
    if (hasLoggingConfig()) {
      hash = (37 * hash) + LOGGING_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getLoggingConfig().hashCode();
    }
    switch (queriesCase_) {
      case 1:
        hash = (37 * hash) + QUERY_FILE_URI_FIELD_NUMBER;
        hash = (53 * hash) + getQueryFileUri().hashCode();
        break;
      case 2:
        hash = (37 * hash) + QUERY_LIST_FIELD_NUMBER;
        hash = (53 * hash) + getQueryList().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dataproc.v1.PrestoJob parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1.PrestoJob parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.PrestoJob parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1.PrestoJob parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.PrestoJob parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1.PrestoJob parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.PrestoJob parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1.PrestoJob parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.PrestoJob parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1.PrestoJob parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.PrestoJob parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1.PrestoJob parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.dataproc.v1.PrestoJob prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A Dataproc job for running [Presto](https://prestosql.io/) queries.
   * **IMPORTANT**: The [Dataproc Presto Optional
   * Component](https://cloud.google.com/dataproc/docs/concepts/components/presto)
   * must be enabled when the cluster is created to submit a Presto job to the
   * cluster.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dataproc.v1.PrestoJob}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dataproc.v1.PrestoJob)
      com.google.cloud.dataproc.v1.PrestoJobOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dataproc.v1.JobsProto
          .internal_static_google_cloud_dataproc_v1_PrestoJob_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 6:
          return internalGetProperties();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 6:
          return internalGetMutableProperties();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dataproc.v1.JobsProto
          .internal_static_google_cloud_dataproc_v1_PrestoJob_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dataproc.v1.PrestoJob.class,
              com.google.cloud.dataproc.v1.PrestoJob.Builder.class);
    }

    // Construct using com.google.cloud.dataproc.v1.PrestoJob.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (queryListBuilder_ != null) {
        queryListBuilder_.clear();
      }
      continueOnFailure_ = false;

      outputFormat_ = "";

      clientTags_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000001);
      internalGetMutableProperties().clear();
      if (loggingConfigBuilder_ == null) {
        loggingConfig_ = null;
      } else {
        loggingConfig_ = null;
        loggingConfigBuilder_ = null;
      }
      queriesCase_ = 0;
      queries_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dataproc.v1.JobsProto
          .internal_static_google_cloud_dataproc_v1_PrestoJob_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.PrestoJob getDefaultInstanceForType() {
      return com.google.cloud.dataproc.v1.PrestoJob.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.PrestoJob build() {
      com.google.cloud.dataproc.v1.PrestoJob result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.PrestoJob buildPartial() {
      com.google.cloud.dataproc.v1.PrestoJob result =
          new com.google.cloud.dataproc.v1.PrestoJob(this);
      int from_bitField0_ = bitField0_;
      if (queriesCase_ == 1) {
        result.queries_ = queries_;
      }
      if (queriesCase_ == 2) {
        if (queryListBuilder_ == null) {
          result.queries_ = queries_;
        } else {
          result.queries_ = queryListBuilder_.build();
        }
      }
      result.continueOnFailure_ = continueOnFailure_;
      result.outputFormat_ = outputFormat_;
      if (((bitField0_ & 0x00000001) != 0)) {
        clientTags_ = clientTags_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000001);
      }
      result.clientTags_ = clientTags_;
      result.properties_ = internalGetProperties();
      result.properties_.makeImmutable();
      if (loggingConfigBuilder_ == null) {
        result.loggingConfig_ = loggingConfig_;
      } else {
        result.loggingConfig_ = loggingConfigBuilder_.build();
      }
      result.queriesCase_ = queriesCase_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dataproc.v1.PrestoJob) {
        return mergeFrom((com.google.cloud.dataproc.v1.PrestoJob) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dataproc.v1.PrestoJob other) {
      if (other == com.google.cloud.dataproc.v1.PrestoJob.getDefaultInstance()) return this;
      if (other.getContinueOnFailure() != false) {
        setContinueOnFailure(other.getContinueOnFailure());
      }
      if (!other.getOutputFormat().isEmpty()) {
        outputFormat_ = other.outputFormat_;
        onChanged();
      }
      if (!other.clientTags_.isEmpty()) {
        if (clientTags_.isEmpty()) {
          clientTags_ = other.clientTags_;
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          ensureClientTagsIsMutable();
          clientTags_.addAll(other.clientTags_);
        }
        onChanged();
      }
      internalGetMutableProperties().mergeFrom(other.internalGetProperties());
      if (other.hasLoggingConfig()) {
        mergeLoggingConfig(other.getLoggingConfig());
      }
      switch (other.getQueriesCase()) {
        case QUERY_FILE_URI:
          {
            queriesCase_ = 1;
            queries_ = other.queries_;
            onChanged();
            break;
          }
        case QUERY_LIST:
          {
            mergeQueryList(other.getQueryList());
            break;
          }
        case QUERIES_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                java.lang.String s = input.readStringRequireUtf8();
                queriesCase_ = 1;
                queries_ = s;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getQueryListFieldBuilder().getBuilder(), extensionRegistry);
                queriesCase_ = 2;
                break;
              } // case 18
            case 24:
              {
                continueOnFailure_ = input.readBool();

                break;
              } // case 24
            case 34:
              {
                outputFormat_ = input.readStringRequireUtf8();

                break;
              } // case 34
            case 42:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureClientTagsIsMutable();
                clientTags_.add(s);
                break;
              } // case 42
            case 50:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> properties__ =
                    input.readMessage(
                        PropertiesDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableProperties()
                    .getMutableMap()
                    .put(properties__.getKey(), properties__.getValue());
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getLoggingConfigFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 58
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int queriesCase_ = 0;
    private java.lang.Object queries_;

    public QueriesCase getQueriesCase() {
      return QueriesCase.forNumber(queriesCase_);
    }

    public Builder clearQueries() {
      queriesCase_ = 0;
      queries_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    /**
     *
     *
     * <pre>
     * The HCFS URI of the script that contains SQL queries.
     * </pre>
     *
     * <code>string query_file_uri = 1;</code>
     *
     * @return Whether the queryFileUri field is set.
     */
    @java.lang.Override
    public boolean hasQueryFileUri() {
      return queriesCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * The HCFS URI of the script that contains SQL queries.
     * </pre>
     *
     * <code>string query_file_uri = 1;</code>
     *
     * @return The queryFileUri.
     */
    @java.lang.Override
    public java.lang.String getQueryFileUri() {
      java.lang.Object ref = "";
      if (queriesCase_ == 1) {
        ref = queries_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (queriesCase_ == 1) {
          queries_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The HCFS URI of the script that contains SQL queries.
     * </pre>
     *
     * <code>string query_file_uri = 1;</code>
     *
     * @return The bytes for queryFileUri.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getQueryFileUriBytes() {
      java.lang.Object ref = "";
      if (queriesCase_ == 1) {
        ref = queries_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (queriesCase_ == 1) {
          queries_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The HCFS URI of the script that contains SQL queries.
     * </pre>
     *
     * <code>string query_file_uri = 1;</code>
     *
     * @param value The queryFileUri to set.
     * @return This builder for chaining.
     */
    public Builder setQueryFileUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      queriesCase_ = 1;
      queries_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The HCFS URI of the script that contains SQL queries.
     * </pre>
     *
     * <code>string query_file_uri = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearQueryFileUri() {
      if (queriesCase_ == 1) {
        queriesCase_ = 0;
        queries_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The HCFS URI of the script that contains SQL queries.
     * </pre>
     *
     * <code>string query_file_uri = 1;</code>
     *
     * @param value The bytes for queryFileUri to set.
     * @return This builder for chaining.
     */
    public Builder setQueryFileUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      queriesCase_ = 1;
      queries_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.QueryList,
            com.google.cloud.dataproc.v1.QueryList.Builder,
            com.google.cloud.dataproc.v1.QueryListOrBuilder>
        queryListBuilder_;
    /**
     *
     *
     * <pre>
     * A list of queries.
     * </pre>
     *
     * <code>.google.cloud.dataproc.v1.QueryList query_list = 2;</code>
     *
     * @return Whether the queryList field is set.
     */
    @java.lang.Override
    public boolean hasQueryList() {
      return queriesCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * A list of queries.
     * </pre>
     *
     * <code>.google.cloud.dataproc.v1.QueryList query_list = 2;</code>
     *
     * @return The queryList.
     */
    @java.lang.Override
    public com.google.cloud.dataproc.v1.QueryList getQueryList() {
      if (queryListBuilder_ == null) {
        if (queriesCase_ == 2) {
          return (com.google.cloud.dataproc.v1.QueryList) queries_;
        }
        return com.google.cloud.dataproc.v1.QueryList.getDefaultInstance();
      } else {
        if (queriesCase_ == 2) {
          return queryListBuilder_.getMessage();
        }
        return com.google.cloud.dataproc.v1.QueryList.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of queries.
     * </pre>
     *
     * <code>.google.cloud.dataproc.v1.QueryList query_list = 2;</code>
     */
    public Builder setQueryList(com.google.cloud.dataproc.v1.QueryList value) {
      if (queryListBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        queries_ = value;
        onChanged();
      } else {
        queryListBuilder_.setMessage(value);
      }
      queriesCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of queries.
     * </pre>
     *
     * <code>.google.cloud.dataproc.v1.QueryList query_list = 2;</code>
     */
    public Builder setQueryList(com.google.cloud.dataproc.v1.QueryList.Builder builderForValue) {
      if (queryListBuilder_ == null) {
        queries_ = builderForValue.build();
        onChanged();
      } else {
        queryListBuilder_.setMessage(builderForValue.build());
      }
      queriesCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of queries.
     * </pre>
     *
     * <code>.google.cloud.dataproc.v1.QueryList query_list = 2;</code>
     */
    public Builder mergeQueryList(com.google.cloud.dataproc.v1.QueryList value) {
      if (queryListBuilder_ == null) {
        if (queriesCase_ == 2
            && queries_ != com.google.cloud.dataproc.v1.QueryList.getDefaultInstance()) {
          queries_ =
              com.google.cloud.dataproc.v1.QueryList.newBuilder(
                      (com.google.cloud.dataproc.v1.QueryList) queries_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          queries_ = value;
        }
        onChanged();
      } else {
        if (queriesCase_ == 2) {
          queryListBuilder_.mergeFrom(value);
        } else {
          queryListBuilder_.setMessage(value);
        }
      }
      queriesCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of queries.
     * </pre>
     *
     * <code>.google.cloud.dataproc.v1.QueryList query_list = 2;</code>
     */
    public Builder clearQueryList() {
      if (queryListBuilder_ == null) {
        if (queriesCase_ == 2) {
          queriesCase_ = 0;
          queries_ = null;
          onChanged();
        }
      } else {
        if (queriesCase_ == 2) {
          queriesCase_ = 0;
          queries_ = null;
        }
        queryListBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of queries.
     * </pre>
     *
     * <code>.google.cloud.dataproc.v1.QueryList query_list = 2;</code>
     */
    public com.google.cloud.dataproc.v1.QueryList.Builder getQueryListBuilder() {
      return getQueryListFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * A list of queries.
     * </pre>
     *
     * <code>.google.cloud.dataproc.v1.QueryList query_list = 2;</code>
     */
    @java.lang.Override
    public com.google.cloud.dataproc.v1.QueryListOrBuilder getQueryListOrBuilder() {
      if ((queriesCase_ == 2) && (queryListBuilder_ != null)) {
        return queryListBuilder_.getMessageOrBuilder();
      } else {
        if (queriesCase_ == 2) {
          return (com.google.cloud.dataproc.v1.QueryList) queries_;
        }
        return com.google.cloud.dataproc.v1.QueryList.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of queries.
     * </pre>
     *
     * <code>.google.cloud.dataproc.v1.QueryList query_list = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.QueryList,
            com.google.cloud.dataproc.v1.QueryList.Builder,
            com.google.cloud.dataproc.v1.QueryListOrBuilder>
        getQueryListFieldBuilder() {
      if (queryListBuilder_ == null) {
        if (!(queriesCase_ == 2)) {
          queries_ = com.google.cloud.dataproc.v1.QueryList.getDefaultInstance();
        }
        queryListBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataproc.v1.QueryList,
                com.google.cloud.dataproc.v1.QueryList.Builder,
                com.google.cloud.dataproc.v1.QueryListOrBuilder>(
                (com.google.cloud.dataproc.v1.QueryList) queries_,
                getParentForChildren(),
                isClean());
        queries_ = null;
      }
      queriesCase_ = 2;
      onChanged();
      ;
      return queryListBuilder_;
    }

    private boolean continueOnFailure_;
    /**
     *
     *
     * <pre>
     * Optional. Whether to continue executing queries if a query fails.
     * The default value is `false`. Setting to `true` can be useful when
     * executing independent parallel queries.
     * </pre>
     *
     * <code>bool continue_on_failure = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The continueOnFailure.
     */
    @java.lang.Override
    public boolean getContinueOnFailure() {
      return continueOnFailure_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Whether to continue executing queries if a query fails.
     * The default value is `false`. Setting to `true` can be useful when
     * executing independent parallel queries.
     * </pre>
     *
     * <code>bool continue_on_failure = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The continueOnFailure to set.
     * @return This builder for chaining.
     */
    public Builder setContinueOnFailure(boolean value) {

      continueOnFailure_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Whether to continue executing queries if a query fails.
     * The default value is `false`. Setting to `true` can be useful when
     * executing independent parallel queries.
     * </pre>
     *
     * <code>bool continue_on_failure = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearContinueOnFailure() {

      continueOnFailure_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object outputFormat_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The format in which query output will be displayed. See the
     * Presto documentation for supported output formats
     * </pre>
     *
     * <code>string output_format = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The outputFormat.
     */
    public java.lang.String getOutputFormat() {
      java.lang.Object ref = outputFormat_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        outputFormat_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The format in which query output will be displayed. See the
     * Presto documentation for supported output formats
     * </pre>
     *
     * <code>string output_format = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for outputFormat.
     */
    public com.google.protobuf.ByteString getOutputFormatBytes() {
      java.lang.Object ref = outputFormat_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        outputFormat_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The format in which query output will be displayed. See the
     * Presto documentation for supported output formats
     * </pre>
     *
     * <code>string output_format = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The outputFormat to set.
     * @return This builder for chaining.
     */
    public Builder setOutputFormat(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      outputFormat_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The format in which query output will be displayed. See the
     * Presto documentation for supported output formats
     * </pre>
     *
     * <code>string output_format = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearOutputFormat() {

      outputFormat_ = getDefaultInstance().getOutputFormat();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The format in which query output will be displayed. See the
     * Presto documentation for supported output formats
     * </pre>
     *
     * <code>string output_format = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for outputFormat to set.
     * @return This builder for chaining.
     */
    public Builder setOutputFormatBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      outputFormat_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringList clientTags_ =
        com.google.protobuf.LazyStringArrayList.EMPTY;

    private void ensureClientTagsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        clientTags_ = new com.google.protobuf.LazyStringArrayList(clientTags_);
        bitField0_ |= 0x00000001;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Presto client tags to attach to this query
     * </pre>
     *
     * <code>repeated string client_tags = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return A list containing the clientTags.
     */
    public com.google.protobuf.ProtocolStringList getClientTagsList() {
      return clientTags_.getUnmodifiableView();
    }
    /**
     *
     *
     * <pre>
     * Optional. Presto client tags to attach to this query
     * </pre>
     *
     * <code>repeated string client_tags = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The count of clientTags.
     */
    public int getClientTagsCount() {
      return clientTags_.size();
    }
    /**
     *
     *
     * <pre>
     * Optional. Presto client tags to attach to this query
     * </pre>
     *
     * <code>repeated string client_tags = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the element to return.
     * @return The clientTags at the given index.
     */
    public java.lang.String getClientTags(int index) {
      return clientTags_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. Presto client tags to attach to this query
     * </pre>
     *
     * <code>repeated string client_tags = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the clientTags at the given index.
     */
    public com.google.protobuf.ByteString getClientTagsBytes(int index) {
      return clientTags_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. Presto client tags to attach to this query
     * </pre>
     *
     * <code>repeated string client_tags = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index to set the value at.
     * @param value The clientTags to set.
     * @return This builder for chaining.
     */
    public Builder setClientTags(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureClientTagsIsMutable();
      clientTags_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Presto client tags to attach to this query
     * </pre>
     *
     * <code>repeated string client_tags = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The clientTags to add.
     * @return This builder for chaining.
     */
    public Builder addClientTags(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureClientTagsIsMutable();
      clientTags_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Presto client tags to attach to this query
     * </pre>
     *
     * <code>repeated string client_tags = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param values The clientTags to add.
     * @return This builder for chaining.
     */
    public Builder addAllClientTags(java.lang.Iterable<java.lang.String> values) {
      ensureClientTagsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, clientTags_);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Presto client tags to attach to this query
     * </pre>
     *
     * <code>repeated string client_tags = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearClientTags() {
      clientTags_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Presto client tags to attach to this query
     * </pre>
     *
     * <code>repeated string client_tags = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes of the clientTags to add.
     * @return This builder for chaining.
     */
    public Builder addClientTagsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureClientTagsIsMutable();
      clientTags_.add(value);
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> properties_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetProperties() {
      if (properties_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            PropertiesDefaultEntryHolder.defaultEntry);
      }
      return properties_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableProperties() {
      onChanged();
      ;
      if (properties_ == null) {
        properties_ =
            com.google.protobuf.MapField.newMapField(PropertiesDefaultEntryHolder.defaultEntry);
      }
      if (!properties_.isMutable()) {
        properties_ = properties_.copy();
      }
      return properties_;
    }

    public int getPropertiesCount() {
      return internalGetProperties().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Optional. A mapping of property names to values. Used to set Presto
     * [session properties](https://prestodb.io/docs/current/sql/set-session.html)
     * Equivalent to using the --session flag in the Presto CLI
     * </pre>
     *
     * <code>map&lt;string, string&gt; properties = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public boolean containsProperties(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetProperties().getMap().containsKey(key);
    }
    /** Use {@link #getPropertiesMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getProperties() {
      return getPropertiesMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. A mapping of property names to values. Used to set Presto
     * [session properties](https://prestodb.io/docs/current/sql/set-session.html)
     * Equivalent to using the --session flag in the Presto CLI
     * </pre>
     *
     * <code>map&lt;string, string&gt; properties = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getPropertiesMap() {
      return internalGetProperties().getMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. A mapping of property names to values. Used to set Presto
     * [session properties](https://prestodb.io/docs/current/sql/set-session.html)
     * Equivalent to using the --session flag in the Presto CLI
     * </pre>
     *
     * <code>map&lt;string, string&gt; properties = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.lang.String getPropertiesOrDefault(
        java.lang.String key, java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetProperties().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Optional. A mapping of property names to values. Used to set Presto
     * [session properties](https://prestodb.io/docs/current/sql/set-session.html)
     * Equivalent to using the --session flag in the Presto CLI
     * </pre>
     *
     * <code>map&lt;string, string&gt; properties = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.lang.String getPropertiesOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetProperties().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearProperties() {
      internalGetMutableProperties().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A mapping of property names to values. Used to set Presto
     * [session properties](https://prestodb.io/docs/current/sql/set-session.html)
     * Equivalent to using the --session flag in the Presto CLI
     * </pre>
     *
     * <code>map&lt;string, string&gt; properties = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeProperties(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableProperties().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableProperties() {
      return internalGetMutableProperties().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. A mapping of property names to values. Used to set Presto
     * [session properties](https://prestodb.io/docs/current/sql/set-session.html)
     * Equivalent to using the --session flag in the Presto CLI
     * </pre>
     *
     * <code>map&lt;string, string&gt; properties = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder putProperties(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }

      internalGetMutableProperties().getMutableMap().put(key, value);
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A mapping of property names to values. Used to set Presto
     * [session properties](https://prestodb.io/docs/current/sql/set-session.html)
     * Equivalent to using the --session flag in the Presto CLI
     * </pre>
     *
     * <code>map&lt;string, string&gt; properties = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder putAllProperties(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableProperties().getMutableMap().putAll(values);
      return this;
    }

    private com.google.cloud.dataproc.v1.LoggingConfig loggingConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.LoggingConfig,
            com.google.cloud.dataproc.v1.LoggingConfig.Builder,
            com.google.cloud.dataproc.v1.LoggingConfigOrBuilder>
        loggingConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. The runtime log config for job execution.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.LoggingConfig logging_config = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the loggingConfig field is set.
     */
    public boolean hasLoggingConfig() {
      return loggingConfigBuilder_ != null || loggingConfig_ != null;
    }
    /**
     *
     *
     * <pre>
     * Optional. The runtime log config for job execution.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.LoggingConfig logging_config = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The loggingConfig.
     */
    public com.google.cloud.dataproc.v1.LoggingConfig getLoggingConfig() {
      if (loggingConfigBuilder_ == null) {
        return loggingConfig_ == null
            ? com.google.cloud.dataproc.v1.LoggingConfig.getDefaultInstance()
            : loggingConfig_;
      } else {
        return loggingConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The runtime log config for job execution.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.LoggingConfig logging_config = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setLoggingConfig(com.google.cloud.dataproc.v1.LoggingConfig value) {
      if (loggingConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        loggingConfig_ = value;
        onChanged();
      } else {
        loggingConfigBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The runtime log config for job execution.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.LoggingConfig logging_config = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setLoggingConfig(
        com.google.cloud.dataproc.v1.LoggingConfig.Builder builderForValue) {
      if (loggingConfigBuilder_ == null) {
        loggingConfig_ = builderForValue.build();
        onChanged();
      } else {
        loggingConfigBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The runtime log config for job execution.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.LoggingConfig logging_config = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeLoggingConfig(com.google.cloud.dataproc.v1.LoggingConfig value) {
      if (loggingConfigBuilder_ == null) {
        if (loggingConfig_ != null) {
          loggingConfig_ =
              com.google.cloud.dataproc.v1.LoggingConfig.newBuilder(loggingConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          loggingConfig_ = value;
        }
        onChanged();
      } else {
        loggingConfigBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The runtime log config for job execution.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.LoggingConfig logging_config = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearLoggingConfig() {
      if (loggingConfigBuilder_ == null) {
        loggingConfig_ = null;
        onChanged();
      } else {
        loggingConfig_ = null;
        loggingConfigBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The runtime log config for job execution.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.LoggingConfig logging_config = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataproc.v1.LoggingConfig.Builder getLoggingConfigBuilder() {

      onChanged();
      return getLoggingConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. The runtime log config for job execution.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.LoggingConfig logging_config = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataproc.v1.LoggingConfigOrBuilder getLoggingConfigOrBuilder() {
      if (loggingConfigBuilder_ != null) {
        return loggingConfigBuilder_.getMessageOrBuilder();
      } else {
        return loggingConfig_ == null
            ? com.google.cloud.dataproc.v1.LoggingConfig.getDefaultInstance()
            : loggingConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The runtime log config for job execution.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.LoggingConfig logging_config = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.LoggingConfig,
            com.google.cloud.dataproc.v1.LoggingConfig.Builder,
            com.google.cloud.dataproc.v1.LoggingConfigOrBuilder>
        getLoggingConfigFieldBuilder() {
      if (loggingConfigBuilder_ == null) {
        loggingConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataproc.v1.LoggingConfig,
                com.google.cloud.dataproc.v1.LoggingConfig.Builder,
                com.google.cloud.dataproc.v1.LoggingConfigOrBuilder>(
                getLoggingConfig(), getParentForChildren(), isClean());
        loggingConfig_ = null;
      }
      return loggingConfigBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dataproc.v1.PrestoJob)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dataproc.v1.PrestoJob)
  private static final com.google.cloud.dataproc.v1.PrestoJob DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dataproc.v1.PrestoJob();
  }

  public static com.google.cloud.dataproc.v1.PrestoJob getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<PrestoJob> PARSER =
      new com.google.protobuf.AbstractParser<PrestoJob>() {
        @java.lang.Override
        public PrestoJob parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<PrestoJob> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<PrestoJob> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dataproc.v1.PrestoJob getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
