/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dataproc/v1/batches.proto

package com.google.cloud.dataproc.v1;

/**
 *
 *
 * <pre>
 * A configuration for running an
 * [Apache SparkR](https://spark.apache.org/docs/latest/sparkr.html)
 * batch workload.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dataproc.v1.SparkRBatch}
 */
public final class SparkRBatch extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dataproc.v1.SparkRBatch)
    SparkRBatchOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use SparkRBatch.newBuilder() to construct.
  private SparkRBatch(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private SparkRBatch() {
    mainRFileUri_ = "";
    args_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    fileUris_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    archiveUris_ = com.google.protobuf.LazyStringArrayList.EMPTY;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new SparkRBatch();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dataproc.v1.BatchesProto
        .internal_static_google_cloud_dataproc_v1_SparkRBatch_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dataproc.v1.BatchesProto
        .internal_static_google_cloud_dataproc_v1_SparkRBatch_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dataproc.v1.SparkRBatch.class,
            com.google.cloud.dataproc.v1.SparkRBatch.Builder.class);
  }

  public static final int MAIN_R_FILE_URI_FIELD_NUMBER = 1;
  private volatile java.lang.Object mainRFileUri_;
  /**
   *
   *
   * <pre>
   * Required. The HCFS URI of the main R file to use as the driver.
   * Must be a `.R` or `.r` file.
   * </pre>
   *
   * <code>string main_r_file_uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The mainRFileUri.
   */
  @java.lang.Override
  public java.lang.String getMainRFileUri() {
    java.lang.Object ref = mainRFileUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      mainRFileUri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The HCFS URI of the main R file to use as the driver.
   * Must be a `.R` or `.r` file.
   * </pre>
   *
   * <code>string main_r_file_uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for mainRFileUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getMainRFileUriBytes() {
    java.lang.Object ref = mainRFileUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      mainRFileUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ARGS_FIELD_NUMBER = 2;
  private com.google.protobuf.LazyStringList args_;
  /**
   *
   *
   * <pre>
   * Optional. The arguments to pass to the Spark driver. Do not include arguments
   * that can be set as batch properties, such as `--conf`, since a collision
   * can occur that causes an incorrect batch submission.
   * </pre>
   *
   * <code>repeated string args = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return A list containing the args.
   */
  public com.google.protobuf.ProtocolStringList getArgsList() {
    return args_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The arguments to pass to the Spark driver. Do not include arguments
   * that can be set as batch properties, such as `--conf`, since a collision
   * can occur that causes an incorrect batch submission.
   * </pre>
   *
   * <code>repeated string args = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The count of args.
   */
  public int getArgsCount() {
    return args_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. The arguments to pass to the Spark driver. Do not include arguments
   * that can be set as batch properties, such as `--conf`, since a collision
   * can occur that causes an incorrect batch submission.
   * </pre>
   *
   * <code>repeated string args = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the element to return.
   * @return The args at the given index.
   */
  public java.lang.String getArgs(int index) {
    return args_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. The arguments to pass to the Spark driver. Do not include arguments
   * that can be set as batch properties, such as `--conf`, since a collision
   * can occur that causes an incorrect batch submission.
   * </pre>
   *
   * <code>repeated string args = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the args at the given index.
   */
  public com.google.protobuf.ByteString getArgsBytes(int index) {
    return args_.getByteString(index);
  }

  public static final int FILE_URIS_FIELD_NUMBER = 3;
  private com.google.protobuf.LazyStringList fileUris_;
  /**
   *
   *
   * <pre>
   * Optional. HCFS URIs of files to be placed in the working directory of
   * each executor.
   * </pre>
   *
   * <code>repeated string file_uris = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return A list containing the fileUris.
   */
  public com.google.protobuf.ProtocolStringList getFileUrisList() {
    return fileUris_;
  }
  /**
   *
   *
   * <pre>
   * Optional. HCFS URIs of files to be placed in the working directory of
   * each executor.
   * </pre>
   *
   * <code>repeated string file_uris = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The count of fileUris.
   */
  public int getFileUrisCount() {
    return fileUris_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. HCFS URIs of files to be placed in the working directory of
   * each executor.
   * </pre>
   *
   * <code>repeated string file_uris = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the element to return.
   * @return The fileUris at the given index.
   */
  public java.lang.String getFileUris(int index) {
    return fileUris_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. HCFS URIs of files to be placed in the working directory of
   * each executor.
   * </pre>
   *
   * <code>repeated string file_uris = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the fileUris at the given index.
   */
  public com.google.protobuf.ByteString getFileUrisBytes(int index) {
    return fileUris_.getByteString(index);
  }

  public static final int ARCHIVE_URIS_FIELD_NUMBER = 4;
  private com.google.protobuf.LazyStringList archiveUris_;
  /**
   *
   *
   * <pre>
   * Optional. HCFS URIs of archives to be extracted into the working directory
   * of each executor. Supported file types:
   * `.jar`, `.tar`, `.tar.gz`, `.tgz`, and `.zip`.
   * </pre>
   *
   * <code>repeated string archive_uris = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return A list containing the archiveUris.
   */
  public com.google.protobuf.ProtocolStringList getArchiveUrisList() {
    return archiveUris_;
  }
  /**
   *
   *
   * <pre>
   * Optional. HCFS URIs of archives to be extracted into the working directory
   * of each executor. Supported file types:
   * `.jar`, `.tar`, `.tar.gz`, `.tgz`, and `.zip`.
   * </pre>
   *
   * <code>repeated string archive_uris = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The count of archiveUris.
   */
  public int getArchiveUrisCount() {
    return archiveUris_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. HCFS URIs of archives to be extracted into the working directory
   * of each executor. Supported file types:
   * `.jar`, `.tar`, `.tar.gz`, `.tgz`, and `.zip`.
   * </pre>
   *
   * <code>repeated string archive_uris = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the element to return.
   * @return The archiveUris at the given index.
   */
  public java.lang.String getArchiveUris(int index) {
    return archiveUris_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. HCFS URIs of archives to be extracted into the working directory
   * of each executor. Supported file types:
   * `.jar`, `.tar`, `.tar.gz`, `.tgz`, and `.zip`.
   * </pre>
   *
   * <code>repeated string archive_uris = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the archiveUris at the given index.
   */
  public com.google.protobuf.ByteString getArchiveUrisBytes(int index) {
    return archiveUris_.getByteString(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(mainRFileUri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, mainRFileUri_);
    }
    for (int i = 0; i < args_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, args_.getRaw(i));
    }
    for (int i = 0; i < fileUris_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, fileUris_.getRaw(i));
    }
    for (int i = 0; i < archiveUris_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, archiveUris_.getRaw(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(mainRFileUri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, mainRFileUri_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < args_.size(); i++) {
        dataSize += computeStringSizeNoTag(args_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getArgsList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < fileUris_.size(); i++) {
        dataSize += computeStringSizeNoTag(fileUris_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getFileUrisList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < archiveUris_.size(); i++) {
        dataSize += computeStringSizeNoTag(archiveUris_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getArchiveUrisList().size();
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dataproc.v1.SparkRBatch)) {
      return super.equals(obj);
    }
    com.google.cloud.dataproc.v1.SparkRBatch other = (com.google.cloud.dataproc.v1.SparkRBatch) obj;

    if (!getMainRFileUri().equals(other.getMainRFileUri())) return false;
    if (!getArgsList().equals(other.getArgsList())) return false;
    if (!getFileUrisList().equals(other.getFileUrisList())) return false;
    if (!getArchiveUrisList().equals(other.getArchiveUrisList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + MAIN_R_FILE_URI_FIELD_NUMBER;
    hash = (53 * hash) + getMainRFileUri().hashCode();
    if (getArgsCount() > 0) {
      hash = (37 * hash) + ARGS_FIELD_NUMBER;
      hash = (53 * hash) + getArgsList().hashCode();
    }
    if (getFileUrisCount() > 0) {
      hash = (37 * hash) + FILE_URIS_FIELD_NUMBER;
      hash = (53 * hash) + getFileUrisList().hashCode();
    }
    if (getArchiveUrisCount() > 0) {
      hash = (37 * hash) + ARCHIVE_URIS_FIELD_NUMBER;
      hash = (53 * hash) + getArchiveUrisList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dataproc.v1.SparkRBatch parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1.SparkRBatch parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.SparkRBatch parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1.SparkRBatch parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.SparkRBatch parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1.SparkRBatch parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.SparkRBatch parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1.SparkRBatch parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.SparkRBatch parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1.SparkRBatch parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.SparkRBatch parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1.SparkRBatch parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.dataproc.v1.SparkRBatch prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A configuration for running an
   * [Apache SparkR](https://spark.apache.org/docs/latest/sparkr.html)
   * batch workload.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dataproc.v1.SparkRBatch}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dataproc.v1.SparkRBatch)
      com.google.cloud.dataproc.v1.SparkRBatchOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dataproc.v1.BatchesProto
          .internal_static_google_cloud_dataproc_v1_SparkRBatch_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dataproc.v1.BatchesProto
          .internal_static_google_cloud_dataproc_v1_SparkRBatch_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dataproc.v1.SparkRBatch.class,
              com.google.cloud.dataproc.v1.SparkRBatch.Builder.class);
    }

    // Construct using com.google.cloud.dataproc.v1.SparkRBatch.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      mainRFileUri_ = "";

      args_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000001);
      fileUris_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000002);
      archiveUris_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000004);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dataproc.v1.BatchesProto
          .internal_static_google_cloud_dataproc_v1_SparkRBatch_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.SparkRBatch getDefaultInstanceForType() {
      return com.google.cloud.dataproc.v1.SparkRBatch.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.SparkRBatch build() {
      com.google.cloud.dataproc.v1.SparkRBatch result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.SparkRBatch buildPartial() {
      com.google.cloud.dataproc.v1.SparkRBatch result =
          new com.google.cloud.dataproc.v1.SparkRBatch(this);
      int from_bitField0_ = bitField0_;
      result.mainRFileUri_ = mainRFileUri_;
      if (((bitField0_ & 0x00000001) != 0)) {
        args_ = args_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000001);
      }
      result.args_ = args_;
      if (((bitField0_ & 0x00000002) != 0)) {
        fileUris_ = fileUris_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000002);
      }
      result.fileUris_ = fileUris_;
      if (((bitField0_ & 0x00000004) != 0)) {
        archiveUris_ = archiveUris_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000004);
      }
      result.archiveUris_ = archiveUris_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dataproc.v1.SparkRBatch) {
        return mergeFrom((com.google.cloud.dataproc.v1.SparkRBatch) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dataproc.v1.SparkRBatch other) {
      if (other == com.google.cloud.dataproc.v1.SparkRBatch.getDefaultInstance()) return this;
      if (!other.getMainRFileUri().isEmpty()) {
        mainRFileUri_ = other.mainRFileUri_;
        onChanged();
      }
      if (!other.args_.isEmpty()) {
        if (args_.isEmpty()) {
          args_ = other.args_;
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          ensureArgsIsMutable();
          args_.addAll(other.args_);
        }
        onChanged();
      }
      if (!other.fileUris_.isEmpty()) {
        if (fileUris_.isEmpty()) {
          fileUris_ = other.fileUris_;
          bitField0_ = (bitField0_ & ~0x00000002);
        } else {
          ensureFileUrisIsMutable();
          fileUris_.addAll(other.fileUris_);
        }
        onChanged();
      }
      if (!other.archiveUris_.isEmpty()) {
        if (archiveUris_.isEmpty()) {
          archiveUris_ = other.archiveUris_;
          bitField0_ = (bitField0_ & ~0x00000004);
        } else {
          ensureArchiveUrisIsMutable();
          archiveUris_.addAll(other.archiveUris_);
        }
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                mainRFileUri_ = input.readStringRequireUtf8();

                break;
              } // case 10
            case 18:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureArgsIsMutable();
                args_.add(s);
                break;
              } // case 18
            case 26:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureFileUrisIsMutable();
                fileUris_.add(s);
                break;
              } // case 26
            case 34:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureArchiveUrisIsMutable();
                archiveUris_.add(s);
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object mainRFileUri_ = "";
    /**
     *
     *
     * <pre>
     * Required. The HCFS URI of the main R file to use as the driver.
     * Must be a `.R` or `.r` file.
     * </pre>
     *
     * <code>string main_r_file_uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The mainRFileUri.
     */
    public java.lang.String getMainRFileUri() {
      java.lang.Object ref = mainRFileUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        mainRFileUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The HCFS URI of the main R file to use as the driver.
     * Must be a `.R` or `.r` file.
     * </pre>
     *
     * <code>string main_r_file_uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for mainRFileUri.
     */
    public com.google.protobuf.ByteString getMainRFileUriBytes() {
      java.lang.Object ref = mainRFileUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        mainRFileUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The HCFS URI of the main R file to use as the driver.
     * Must be a `.R` or `.r` file.
     * </pre>
     *
     * <code>string main_r_file_uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The mainRFileUri to set.
     * @return This builder for chaining.
     */
    public Builder setMainRFileUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      mainRFileUri_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The HCFS URI of the main R file to use as the driver.
     * Must be a `.R` or `.r` file.
     * </pre>
     *
     * <code>string main_r_file_uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMainRFileUri() {

      mainRFileUri_ = getDefaultInstance().getMainRFileUri();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The HCFS URI of the main R file to use as the driver.
     * Must be a `.R` or `.r` file.
     * </pre>
     *
     * <code>string main_r_file_uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for mainRFileUri to set.
     * @return This builder for chaining.
     */
    public Builder setMainRFileUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      mainRFileUri_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringList args_ =
        com.google.protobuf.LazyStringArrayList.EMPTY;

    private void ensureArgsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        args_ = new com.google.protobuf.LazyStringArrayList(args_);
        bitField0_ |= 0x00000001;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The arguments to pass to the Spark driver. Do not include arguments
     * that can be set as batch properties, such as `--conf`, since a collision
     * can occur that causes an incorrect batch submission.
     * </pre>
     *
     * <code>repeated string args = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return A list containing the args.
     */
    public com.google.protobuf.ProtocolStringList getArgsList() {
      return args_.getUnmodifiableView();
    }
    /**
     *
     *
     * <pre>
     * Optional. The arguments to pass to the Spark driver. Do not include arguments
     * that can be set as batch properties, such as `--conf`, since a collision
     * can occur that causes an incorrect batch submission.
     * </pre>
     *
     * <code>repeated string args = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The count of args.
     */
    public int getArgsCount() {
      return args_.size();
    }
    /**
     *
     *
     * <pre>
     * Optional. The arguments to pass to the Spark driver. Do not include arguments
     * that can be set as batch properties, such as `--conf`, since a collision
     * can occur that causes an incorrect batch submission.
     * </pre>
     *
     * <code>repeated string args = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the element to return.
     * @return The args at the given index.
     */
    public java.lang.String getArgs(int index) {
      return args_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. The arguments to pass to the Spark driver. Do not include arguments
     * that can be set as batch properties, such as `--conf`, since a collision
     * can occur that causes an incorrect batch submission.
     * </pre>
     *
     * <code>repeated string args = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the args at the given index.
     */
    public com.google.protobuf.ByteString getArgsBytes(int index) {
      return args_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. The arguments to pass to the Spark driver. Do not include arguments
     * that can be set as batch properties, such as `--conf`, since a collision
     * can occur that causes an incorrect batch submission.
     * </pre>
     *
     * <code>repeated string args = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index to set the value at.
     * @param value The args to set.
     * @return This builder for chaining.
     */
    public Builder setArgs(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureArgsIsMutable();
      args_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The arguments to pass to the Spark driver. Do not include arguments
     * that can be set as batch properties, such as `--conf`, since a collision
     * can occur that causes an incorrect batch submission.
     * </pre>
     *
     * <code>repeated string args = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The args to add.
     * @return This builder for chaining.
     */
    public Builder addArgs(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureArgsIsMutable();
      args_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The arguments to pass to the Spark driver. Do not include arguments
     * that can be set as batch properties, such as `--conf`, since a collision
     * can occur that causes an incorrect batch submission.
     * </pre>
     *
     * <code>repeated string args = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param values The args to add.
     * @return This builder for chaining.
     */
    public Builder addAllArgs(java.lang.Iterable<java.lang.String> values) {
      ensureArgsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, args_);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The arguments to pass to the Spark driver. Do not include arguments
     * that can be set as batch properties, such as `--conf`, since a collision
     * can occur that causes an incorrect batch submission.
     * </pre>
     *
     * <code>repeated string args = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearArgs() {
      args_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The arguments to pass to the Spark driver. Do not include arguments
     * that can be set as batch properties, such as `--conf`, since a collision
     * can occur that causes an incorrect batch submission.
     * </pre>
     *
     * <code>repeated string args = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes of the args to add.
     * @return This builder for chaining.
     */
    public Builder addArgsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureArgsIsMutable();
      args_.add(value);
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringList fileUris_ =
        com.google.protobuf.LazyStringArrayList.EMPTY;

    private void ensureFileUrisIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        fileUris_ = new com.google.protobuf.LazyStringArrayList(fileUris_);
        bitField0_ |= 0x00000002;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. HCFS URIs of files to be placed in the working directory of
     * each executor.
     * </pre>
     *
     * <code>repeated string file_uris = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return A list containing the fileUris.
     */
    public com.google.protobuf.ProtocolStringList getFileUrisList() {
      return fileUris_.getUnmodifiableView();
    }
    /**
     *
     *
     * <pre>
     * Optional. HCFS URIs of files to be placed in the working directory of
     * each executor.
     * </pre>
     *
     * <code>repeated string file_uris = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The count of fileUris.
     */
    public int getFileUrisCount() {
      return fileUris_.size();
    }
    /**
     *
     *
     * <pre>
     * Optional. HCFS URIs of files to be placed in the working directory of
     * each executor.
     * </pre>
     *
     * <code>repeated string file_uris = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the element to return.
     * @return The fileUris at the given index.
     */
    public java.lang.String getFileUris(int index) {
      return fileUris_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. HCFS URIs of files to be placed in the working directory of
     * each executor.
     * </pre>
     *
     * <code>repeated string file_uris = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the fileUris at the given index.
     */
    public com.google.protobuf.ByteString getFileUrisBytes(int index) {
      return fileUris_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. HCFS URIs of files to be placed in the working directory of
     * each executor.
     * </pre>
     *
     * <code>repeated string file_uris = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index to set the value at.
     * @param value The fileUris to set.
     * @return This builder for chaining.
     */
    public Builder setFileUris(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureFileUrisIsMutable();
      fileUris_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. HCFS URIs of files to be placed in the working directory of
     * each executor.
     * </pre>
     *
     * <code>repeated string file_uris = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The fileUris to add.
     * @return This builder for chaining.
     */
    public Builder addFileUris(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureFileUrisIsMutable();
      fileUris_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. HCFS URIs of files to be placed in the working directory of
     * each executor.
     * </pre>
     *
     * <code>repeated string file_uris = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param values The fileUris to add.
     * @return This builder for chaining.
     */
    public Builder addAllFileUris(java.lang.Iterable<java.lang.String> values) {
      ensureFileUrisIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, fileUris_);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. HCFS URIs of files to be placed in the working directory of
     * each executor.
     * </pre>
     *
     * <code>repeated string file_uris = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFileUris() {
      fileUris_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. HCFS URIs of files to be placed in the working directory of
     * each executor.
     * </pre>
     *
     * <code>repeated string file_uris = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes of the fileUris to add.
     * @return This builder for chaining.
     */
    public Builder addFileUrisBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureFileUrisIsMutable();
      fileUris_.add(value);
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringList archiveUris_ =
        com.google.protobuf.LazyStringArrayList.EMPTY;

    private void ensureArchiveUrisIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        archiveUris_ = new com.google.protobuf.LazyStringArrayList(archiveUris_);
        bitField0_ |= 0x00000004;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. HCFS URIs of archives to be extracted into the working directory
     * of each executor. Supported file types:
     * `.jar`, `.tar`, `.tar.gz`, `.tgz`, and `.zip`.
     * </pre>
     *
     * <code>repeated string archive_uris = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return A list containing the archiveUris.
     */
    public com.google.protobuf.ProtocolStringList getArchiveUrisList() {
      return archiveUris_.getUnmodifiableView();
    }
    /**
     *
     *
     * <pre>
     * Optional. HCFS URIs of archives to be extracted into the working directory
     * of each executor. Supported file types:
     * `.jar`, `.tar`, `.tar.gz`, `.tgz`, and `.zip`.
     * </pre>
     *
     * <code>repeated string archive_uris = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The count of archiveUris.
     */
    public int getArchiveUrisCount() {
      return archiveUris_.size();
    }
    /**
     *
     *
     * <pre>
     * Optional. HCFS URIs of archives to be extracted into the working directory
     * of each executor. Supported file types:
     * `.jar`, `.tar`, `.tar.gz`, `.tgz`, and `.zip`.
     * </pre>
     *
     * <code>repeated string archive_uris = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the element to return.
     * @return The archiveUris at the given index.
     */
    public java.lang.String getArchiveUris(int index) {
      return archiveUris_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. HCFS URIs of archives to be extracted into the working directory
     * of each executor. Supported file types:
     * `.jar`, `.tar`, `.tar.gz`, `.tgz`, and `.zip`.
     * </pre>
     *
     * <code>repeated string archive_uris = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the archiveUris at the given index.
     */
    public com.google.protobuf.ByteString getArchiveUrisBytes(int index) {
      return archiveUris_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. HCFS URIs of archives to be extracted into the working directory
     * of each executor. Supported file types:
     * `.jar`, `.tar`, `.tar.gz`, `.tgz`, and `.zip`.
     * </pre>
     *
     * <code>repeated string archive_uris = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index to set the value at.
     * @param value The archiveUris to set.
     * @return This builder for chaining.
     */
    public Builder setArchiveUris(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureArchiveUrisIsMutable();
      archiveUris_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. HCFS URIs of archives to be extracted into the working directory
     * of each executor. Supported file types:
     * `.jar`, `.tar`, `.tar.gz`, `.tgz`, and `.zip`.
     * </pre>
     *
     * <code>repeated string archive_uris = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The archiveUris to add.
     * @return This builder for chaining.
     */
    public Builder addArchiveUris(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureArchiveUrisIsMutable();
      archiveUris_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. HCFS URIs of archives to be extracted into the working directory
     * of each executor. Supported file types:
     * `.jar`, `.tar`, `.tar.gz`, `.tgz`, and `.zip`.
     * </pre>
     *
     * <code>repeated string archive_uris = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param values The archiveUris to add.
     * @return This builder for chaining.
     */
    public Builder addAllArchiveUris(java.lang.Iterable<java.lang.String> values) {
      ensureArchiveUrisIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, archiveUris_);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. HCFS URIs of archives to be extracted into the working directory
     * of each executor. Supported file types:
     * `.jar`, `.tar`, `.tar.gz`, `.tgz`, and `.zip`.
     * </pre>
     *
     * <code>repeated string archive_uris = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearArchiveUris() {
      archiveUris_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. HCFS URIs of archives to be extracted into the working directory
     * of each executor. Supported file types:
     * `.jar`, `.tar`, `.tar.gz`, `.tgz`, and `.zip`.
     * </pre>
     *
     * <code>repeated string archive_uris = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes of the archiveUris to add.
     * @return This builder for chaining.
     */
    public Builder addArchiveUrisBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureArchiveUrisIsMutable();
      archiveUris_.add(value);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dataproc.v1.SparkRBatch)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dataproc.v1.SparkRBatch)
  private static final com.google.cloud.dataproc.v1.SparkRBatch DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dataproc.v1.SparkRBatch();
  }

  public static com.google.cloud.dataproc.v1.SparkRBatch getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<SparkRBatch> PARSER =
      new com.google.protobuf.AbstractParser<SparkRBatch>() {
        @java.lang.Override
        public SparkRBatch parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<SparkRBatch> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<SparkRBatch> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dataproc.v1.SparkRBatch getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
