/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dataproc/v1/workflow_templates.proto

package com.google.cloud.dataproc.v1;

/**
 *
 *
 * <pre>
 * A configurable parameter that replaces one or more fields in the template.
 * Parameterizable fields:
 * - Labels
 * - File uris
 * - Job properties
 * - Job arguments
 * - Script variables
 * - Main class (in HadoopJob and SparkJob)
 * - Zone (in ClusterSelector)
 * </pre>
 *
 * Protobuf type {@code google.cloud.dataproc.v1.TemplateParameter}
 */
public final class TemplateParameter extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dataproc.v1.TemplateParameter)
    TemplateParameterOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use TemplateParameter.newBuilder() to construct.
  private TemplateParameter(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private TemplateParameter() {
    name_ = "";
    fields_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    description_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new TemplateParameter();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dataproc.v1.WorkflowTemplatesProto
        .internal_static_google_cloud_dataproc_v1_TemplateParameter_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dataproc.v1.WorkflowTemplatesProto
        .internal_static_google_cloud_dataproc_v1_TemplateParameter_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dataproc.v1.TemplateParameter.class,
            com.google.cloud.dataproc.v1.TemplateParameter.Builder.class);
  }

  public static final int NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object name_;
  /**
   *
   *
   * <pre>
   * Required. Parameter name.
   * The parameter name is used as the key, and paired with the
   * parameter value, which are passed to the template when the template
   * is instantiated.
   * The name must contain only capital letters (A-Z), numbers (0-9), and
   * underscores (_), and must not start with a number. The maximum length is
   * 40 characters.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. Parameter name.
   * The parameter name is used as the key, and paired with the
   * parameter value, which are passed to the template when the template
   * is instantiated.
   * The name must contain only capital letters (A-Z), numbers (0-9), and
   * underscores (_), and must not start with a number. The maximum length is
   * 40 characters.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FIELDS_FIELD_NUMBER = 2;
  private com.google.protobuf.LazyStringList fields_;
  /**
   *
   *
   * <pre>
   * Required. Paths to all fields that the parameter replaces.
   * A field is allowed to appear in at most one parameter's list of field
   * paths.
   * A field path is similar in syntax to a [google.protobuf.FieldMask][google.protobuf.FieldMask].
   * For example, a field path that references the zone field of a workflow
   * template's cluster selector would be specified as
   * `placement.clusterSelector.zone`.
   * Also, field paths can reference fields using the following syntax:
   * * Values in maps can be referenced by key:
   *     * labels['key']
   *     * placement.clusterSelector.clusterLabels['key']
   *     * placement.managedCluster.labels['key']
   *     * placement.clusterSelector.clusterLabels['key']
   *     * jobs['step-id'].labels['key']
   * * Jobs in the jobs list can be referenced by step-id:
   *     * jobs['step-id'].hadoopJob.mainJarFileUri
   *     * jobs['step-id'].hiveJob.queryFileUri
   *     * jobs['step-id'].pySparkJob.mainPythonFileUri
   *     * jobs['step-id'].hadoopJob.jarFileUris[0]
   *     * jobs['step-id'].hadoopJob.archiveUris[0]
   *     * jobs['step-id'].hadoopJob.fileUris[0]
   *     * jobs['step-id'].pySparkJob.pythonFileUris[0]
   * * Items in repeated fields can be referenced by a zero-based index:
   *     * jobs['step-id'].sparkJob.args[0]
   * * Other examples:
   *     * jobs['step-id'].hadoopJob.properties['key']
   *     * jobs['step-id'].hadoopJob.args[0]
   *     * jobs['step-id'].hiveJob.scriptVariables['key']
   *     * jobs['step-id'].hadoopJob.mainJarFileUri
   *     * placement.clusterSelector.zone
   * It may not be possible to parameterize maps and repeated fields in their
   * entirety since only individual map values and individual items in repeated
   * fields can be referenced. For example, the following field paths are
   * invalid:
   * - placement.clusterSelector.clusterLabels
   * - jobs['step-id'].sparkJob.args
   * </pre>
   *
   * <code>repeated string fields = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return A list containing the fields.
   */
  public com.google.protobuf.ProtocolStringList getFieldsList() {
    return fields_;
  }
  /**
   *
   *
   * <pre>
   * Required. Paths to all fields that the parameter replaces.
   * A field is allowed to appear in at most one parameter's list of field
   * paths.
   * A field path is similar in syntax to a [google.protobuf.FieldMask][google.protobuf.FieldMask].
   * For example, a field path that references the zone field of a workflow
   * template's cluster selector would be specified as
   * `placement.clusterSelector.zone`.
   * Also, field paths can reference fields using the following syntax:
   * * Values in maps can be referenced by key:
   *     * labels['key']
   *     * placement.clusterSelector.clusterLabels['key']
   *     * placement.managedCluster.labels['key']
   *     * placement.clusterSelector.clusterLabels['key']
   *     * jobs['step-id'].labels['key']
   * * Jobs in the jobs list can be referenced by step-id:
   *     * jobs['step-id'].hadoopJob.mainJarFileUri
   *     * jobs['step-id'].hiveJob.queryFileUri
   *     * jobs['step-id'].pySparkJob.mainPythonFileUri
   *     * jobs['step-id'].hadoopJob.jarFileUris[0]
   *     * jobs['step-id'].hadoopJob.archiveUris[0]
   *     * jobs['step-id'].hadoopJob.fileUris[0]
   *     * jobs['step-id'].pySparkJob.pythonFileUris[0]
   * * Items in repeated fields can be referenced by a zero-based index:
   *     * jobs['step-id'].sparkJob.args[0]
   * * Other examples:
   *     * jobs['step-id'].hadoopJob.properties['key']
   *     * jobs['step-id'].hadoopJob.args[0]
   *     * jobs['step-id'].hiveJob.scriptVariables['key']
   *     * jobs['step-id'].hadoopJob.mainJarFileUri
   *     * placement.clusterSelector.zone
   * It may not be possible to parameterize maps and repeated fields in their
   * entirety since only individual map values and individual items in repeated
   * fields can be referenced. For example, the following field paths are
   * invalid:
   * - placement.clusterSelector.clusterLabels
   * - jobs['step-id'].sparkJob.args
   * </pre>
   *
   * <code>repeated string fields = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The count of fields.
   */
  public int getFieldsCount() {
    return fields_.size();
  }
  /**
   *
   *
   * <pre>
   * Required. Paths to all fields that the parameter replaces.
   * A field is allowed to appear in at most one parameter's list of field
   * paths.
   * A field path is similar in syntax to a [google.protobuf.FieldMask][google.protobuf.FieldMask].
   * For example, a field path that references the zone field of a workflow
   * template's cluster selector would be specified as
   * `placement.clusterSelector.zone`.
   * Also, field paths can reference fields using the following syntax:
   * * Values in maps can be referenced by key:
   *     * labels['key']
   *     * placement.clusterSelector.clusterLabels['key']
   *     * placement.managedCluster.labels['key']
   *     * placement.clusterSelector.clusterLabels['key']
   *     * jobs['step-id'].labels['key']
   * * Jobs in the jobs list can be referenced by step-id:
   *     * jobs['step-id'].hadoopJob.mainJarFileUri
   *     * jobs['step-id'].hiveJob.queryFileUri
   *     * jobs['step-id'].pySparkJob.mainPythonFileUri
   *     * jobs['step-id'].hadoopJob.jarFileUris[0]
   *     * jobs['step-id'].hadoopJob.archiveUris[0]
   *     * jobs['step-id'].hadoopJob.fileUris[0]
   *     * jobs['step-id'].pySparkJob.pythonFileUris[0]
   * * Items in repeated fields can be referenced by a zero-based index:
   *     * jobs['step-id'].sparkJob.args[0]
   * * Other examples:
   *     * jobs['step-id'].hadoopJob.properties['key']
   *     * jobs['step-id'].hadoopJob.args[0]
   *     * jobs['step-id'].hiveJob.scriptVariables['key']
   *     * jobs['step-id'].hadoopJob.mainJarFileUri
   *     * placement.clusterSelector.zone
   * It may not be possible to parameterize maps and repeated fields in their
   * entirety since only individual map values and individual items in repeated
   * fields can be referenced. For example, the following field paths are
   * invalid:
   * - placement.clusterSelector.clusterLabels
   * - jobs['step-id'].sparkJob.args
   * </pre>
   *
   * <code>repeated string fields = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @param index The index of the element to return.
   * @return The fields at the given index.
   */
  public java.lang.String getFields(int index) {
    return fields_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Required. Paths to all fields that the parameter replaces.
   * A field is allowed to appear in at most one parameter's list of field
   * paths.
   * A field path is similar in syntax to a [google.protobuf.FieldMask][google.protobuf.FieldMask].
   * For example, a field path that references the zone field of a workflow
   * template's cluster selector would be specified as
   * `placement.clusterSelector.zone`.
   * Also, field paths can reference fields using the following syntax:
   * * Values in maps can be referenced by key:
   *     * labels['key']
   *     * placement.clusterSelector.clusterLabels['key']
   *     * placement.managedCluster.labels['key']
   *     * placement.clusterSelector.clusterLabels['key']
   *     * jobs['step-id'].labels['key']
   * * Jobs in the jobs list can be referenced by step-id:
   *     * jobs['step-id'].hadoopJob.mainJarFileUri
   *     * jobs['step-id'].hiveJob.queryFileUri
   *     * jobs['step-id'].pySparkJob.mainPythonFileUri
   *     * jobs['step-id'].hadoopJob.jarFileUris[0]
   *     * jobs['step-id'].hadoopJob.archiveUris[0]
   *     * jobs['step-id'].hadoopJob.fileUris[0]
   *     * jobs['step-id'].pySparkJob.pythonFileUris[0]
   * * Items in repeated fields can be referenced by a zero-based index:
   *     * jobs['step-id'].sparkJob.args[0]
   * * Other examples:
   *     * jobs['step-id'].hadoopJob.properties['key']
   *     * jobs['step-id'].hadoopJob.args[0]
   *     * jobs['step-id'].hiveJob.scriptVariables['key']
   *     * jobs['step-id'].hadoopJob.mainJarFileUri
   *     * placement.clusterSelector.zone
   * It may not be possible to parameterize maps and repeated fields in their
   * entirety since only individual map values and individual items in repeated
   * fields can be referenced. For example, the following field paths are
   * invalid:
   * - placement.clusterSelector.clusterLabels
   * - jobs['step-id'].sparkJob.args
   * </pre>
   *
   * <code>repeated string fields = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the fields at the given index.
   */
  public com.google.protobuf.ByteString getFieldsBytes(int index) {
    return fields_.getByteString(index);
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 3;
  private volatile java.lang.Object description_;
  /**
   *
   *
   * <pre>
   * Optional. Brief description of the parameter.
   * Must not exceed 1024 characters.
   * </pre>
   *
   * <code>string description = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. Brief description of the parameter.
   * Must not exceed 1024 characters.
   * </pre>
   *
   * <code>string description = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int VALIDATION_FIELD_NUMBER = 4;
  private com.google.cloud.dataproc.v1.ParameterValidation validation_;
  /**
   *
   *
   * <pre>
   * Optional. Validation rules to be applied to this parameter's value.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.ParameterValidation validation = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the validation field is set.
   */
  @java.lang.Override
  public boolean hasValidation() {
    return validation_ != null;
  }
  /**
   *
   *
   * <pre>
   * Optional. Validation rules to be applied to this parameter's value.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.ParameterValidation validation = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The validation.
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.ParameterValidation getValidation() {
    return validation_ == null
        ? com.google.cloud.dataproc.v1.ParameterValidation.getDefaultInstance()
        : validation_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Validation rules to be applied to this parameter's value.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.ParameterValidation validation = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.ParameterValidationOrBuilder getValidationOrBuilder() {
    return getValidation();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    for (int i = 0; i < fields_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, fields_.getRaw(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, description_);
    }
    if (validation_ != null) {
      output.writeMessage(4, getValidation());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < fields_.size(); i++) {
        dataSize += computeStringSizeNoTag(fields_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getFieldsList().size();
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, description_);
    }
    if (validation_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getValidation());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dataproc.v1.TemplateParameter)) {
      return super.equals(obj);
    }
    com.google.cloud.dataproc.v1.TemplateParameter other =
        (com.google.cloud.dataproc.v1.TemplateParameter) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getFieldsList().equals(other.getFieldsList())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (hasValidation() != other.hasValidation()) return false;
    if (hasValidation()) {
      if (!getValidation().equals(other.getValidation())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (getFieldsCount() > 0) {
      hash = (37 * hash) + FIELDS_FIELD_NUMBER;
      hash = (53 * hash) + getFieldsList().hashCode();
    }
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    if (hasValidation()) {
      hash = (37 * hash) + VALIDATION_FIELD_NUMBER;
      hash = (53 * hash) + getValidation().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dataproc.v1.TemplateParameter parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1.TemplateParameter parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.TemplateParameter parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1.TemplateParameter parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.TemplateParameter parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1.TemplateParameter parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.TemplateParameter parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1.TemplateParameter parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.TemplateParameter parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1.TemplateParameter parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.TemplateParameter parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1.TemplateParameter parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.dataproc.v1.TemplateParameter prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A configurable parameter that replaces one or more fields in the template.
   * Parameterizable fields:
   * - Labels
   * - File uris
   * - Job properties
   * - Job arguments
   * - Script variables
   * - Main class (in HadoopJob and SparkJob)
   * - Zone (in ClusterSelector)
   * </pre>
   *
   * Protobuf type {@code google.cloud.dataproc.v1.TemplateParameter}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dataproc.v1.TemplateParameter)
      com.google.cloud.dataproc.v1.TemplateParameterOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dataproc.v1.WorkflowTemplatesProto
          .internal_static_google_cloud_dataproc_v1_TemplateParameter_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dataproc.v1.WorkflowTemplatesProto
          .internal_static_google_cloud_dataproc_v1_TemplateParameter_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dataproc.v1.TemplateParameter.class,
              com.google.cloud.dataproc.v1.TemplateParameter.Builder.class);
    }

    // Construct using com.google.cloud.dataproc.v1.TemplateParameter.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      name_ = "";

      fields_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000001);
      description_ = "";

      if (validationBuilder_ == null) {
        validation_ = null;
      } else {
        validation_ = null;
        validationBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dataproc.v1.WorkflowTemplatesProto
          .internal_static_google_cloud_dataproc_v1_TemplateParameter_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.TemplateParameter getDefaultInstanceForType() {
      return com.google.cloud.dataproc.v1.TemplateParameter.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.TemplateParameter build() {
      com.google.cloud.dataproc.v1.TemplateParameter result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.TemplateParameter buildPartial() {
      com.google.cloud.dataproc.v1.TemplateParameter result =
          new com.google.cloud.dataproc.v1.TemplateParameter(this);
      int from_bitField0_ = bitField0_;
      result.name_ = name_;
      if (((bitField0_ & 0x00000001) != 0)) {
        fields_ = fields_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000001);
      }
      result.fields_ = fields_;
      result.description_ = description_;
      if (validationBuilder_ == null) {
        result.validation_ = validation_;
      } else {
        result.validation_ = validationBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dataproc.v1.TemplateParameter) {
        return mergeFrom((com.google.cloud.dataproc.v1.TemplateParameter) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dataproc.v1.TemplateParameter other) {
      if (other == com.google.cloud.dataproc.v1.TemplateParameter.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      if (!other.fields_.isEmpty()) {
        if (fields_.isEmpty()) {
          fields_ = other.fields_;
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          ensureFieldsIsMutable();
          fields_.addAll(other.fields_);
        }
        onChanged();
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        onChanged();
      }
      if (other.hasValidation()) {
        mergeValidation(other.getValidation());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();

                break;
              } // case 10
            case 18:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureFieldsIsMutable();
                fields_.add(s);
                break;
              } // case 18
            case 26:
              {
                description_ = input.readStringRequireUtf8();

                break;
              } // case 26
            case 34:
              {
                input.readMessage(getValidationFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Required. Parameter name.
     * The parameter name is used as the key, and paired with the
     * parameter value, which are passed to the template when the template
     * is instantiated.
     * The name must contain only capital letters (A-Z), numbers (0-9), and
     * underscores (_), and must not start with a number. The maximum length is
     * 40 characters.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Parameter name.
     * The parameter name is used as the key, and paired with the
     * parameter value, which are passed to the template when the template
     * is instantiated.
     * The name must contain only capital letters (A-Z), numbers (0-9), and
     * underscores (_), and must not start with a number. The maximum length is
     * 40 characters.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Parameter name.
     * The parameter name is used as the key, and paired with the
     * parameter value, which are passed to the template when the template
     * is instantiated.
     * The name must contain only capital letters (A-Z), numbers (0-9), and
     * underscores (_), and must not start with a number. The maximum length is
     * 40 characters.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      name_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Parameter name.
     * The parameter name is used as the key, and paired with the
     * parameter value, which are passed to the template when the template
     * is instantiated.
     * The name must contain only capital letters (A-Z), numbers (0-9), and
     * underscores (_), and must not start with a number. The maximum length is
     * 40 characters.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {

      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Parameter name.
     * The parameter name is used as the key, and paired with the
     * parameter value, which are passed to the template when the template
     * is instantiated.
     * The name must contain only capital letters (A-Z), numbers (0-9), and
     * underscores (_), and must not start with a number. The maximum length is
     * 40 characters.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      name_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringList fields_ =
        com.google.protobuf.LazyStringArrayList.EMPTY;

    private void ensureFieldsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        fields_ = new com.google.protobuf.LazyStringArrayList(fields_);
        bitField0_ |= 0x00000001;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Paths to all fields that the parameter replaces.
     * A field is allowed to appear in at most one parameter's list of field
     * paths.
     * A field path is similar in syntax to a [google.protobuf.FieldMask][google.protobuf.FieldMask].
     * For example, a field path that references the zone field of a workflow
     * template's cluster selector would be specified as
     * `placement.clusterSelector.zone`.
     * Also, field paths can reference fields using the following syntax:
     * * Values in maps can be referenced by key:
     *     * labels['key']
     *     * placement.clusterSelector.clusterLabels['key']
     *     * placement.managedCluster.labels['key']
     *     * placement.clusterSelector.clusterLabels['key']
     *     * jobs['step-id'].labels['key']
     * * Jobs in the jobs list can be referenced by step-id:
     *     * jobs['step-id'].hadoopJob.mainJarFileUri
     *     * jobs['step-id'].hiveJob.queryFileUri
     *     * jobs['step-id'].pySparkJob.mainPythonFileUri
     *     * jobs['step-id'].hadoopJob.jarFileUris[0]
     *     * jobs['step-id'].hadoopJob.archiveUris[0]
     *     * jobs['step-id'].hadoopJob.fileUris[0]
     *     * jobs['step-id'].pySparkJob.pythonFileUris[0]
     * * Items in repeated fields can be referenced by a zero-based index:
     *     * jobs['step-id'].sparkJob.args[0]
     * * Other examples:
     *     * jobs['step-id'].hadoopJob.properties['key']
     *     * jobs['step-id'].hadoopJob.args[0]
     *     * jobs['step-id'].hiveJob.scriptVariables['key']
     *     * jobs['step-id'].hadoopJob.mainJarFileUri
     *     * placement.clusterSelector.zone
     * It may not be possible to parameterize maps and repeated fields in their
     * entirety since only individual map values and individual items in repeated
     * fields can be referenced. For example, the following field paths are
     * invalid:
     * - placement.clusterSelector.clusterLabels
     * - jobs['step-id'].sparkJob.args
     * </pre>
     *
     * <code>repeated string fields = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return A list containing the fields.
     */
    public com.google.protobuf.ProtocolStringList getFieldsList() {
      return fields_.getUnmodifiableView();
    }
    /**
     *
     *
     * <pre>
     * Required. Paths to all fields that the parameter replaces.
     * A field is allowed to appear in at most one parameter's list of field
     * paths.
     * A field path is similar in syntax to a [google.protobuf.FieldMask][google.protobuf.FieldMask].
     * For example, a field path that references the zone field of a workflow
     * template's cluster selector would be specified as
     * `placement.clusterSelector.zone`.
     * Also, field paths can reference fields using the following syntax:
     * * Values in maps can be referenced by key:
     *     * labels['key']
     *     * placement.clusterSelector.clusterLabels['key']
     *     * placement.managedCluster.labels['key']
     *     * placement.clusterSelector.clusterLabels['key']
     *     * jobs['step-id'].labels['key']
     * * Jobs in the jobs list can be referenced by step-id:
     *     * jobs['step-id'].hadoopJob.mainJarFileUri
     *     * jobs['step-id'].hiveJob.queryFileUri
     *     * jobs['step-id'].pySparkJob.mainPythonFileUri
     *     * jobs['step-id'].hadoopJob.jarFileUris[0]
     *     * jobs['step-id'].hadoopJob.archiveUris[0]
     *     * jobs['step-id'].hadoopJob.fileUris[0]
     *     * jobs['step-id'].pySparkJob.pythonFileUris[0]
     * * Items in repeated fields can be referenced by a zero-based index:
     *     * jobs['step-id'].sparkJob.args[0]
     * * Other examples:
     *     * jobs['step-id'].hadoopJob.properties['key']
     *     * jobs['step-id'].hadoopJob.args[0]
     *     * jobs['step-id'].hiveJob.scriptVariables['key']
     *     * jobs['step-id'].hadoopJob.mainJarFileUri
     *     * placement.clusterSelector.zone
     * It may not be possible to parameterize maps and repeated fields in their
     * entirety since only individual map values and individual items in repeated
     * fields can be referenced. For example, the following field paths are
     * invalid:
     * - placement.clusterSelector.clusterLabels
     * - jobs['step-id'].sparkJob.args
     * </pre>
     *
     * <code>repeated string fields = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The count of fields.
     */
    public int getFieldsCount() {
      return fields_.size();
    }
    /**
     *
     *
     * <pre>
     * Required. Paths to all fields that the parameter replaces.
     * A field is allowed to appear in at most one parameter's list of field
     * paths.
     * A field path is similar in syntax to a [google.protobuf.FieldMask][google.protobuf.FieldMask].
     * For example, a field path that references the zone field of a workflow
     * template's cluster selector would be specified as
     * `placement.clusterSelector.zone`.
     * Also, field paths can reference fields using the following syntax:
     * * Values in maps can be referenced by key:
     *     * labels['key']
     *     * placement.clusterSelector.clusterLabels['key']
     *     * placement.managedCluster.labels['key']
     *     * placement.clusterSelector.clusterLabels['key']
     *     * jobs['step-id'].labels['key']
     * * Jobs in the jobs list can be referenced by step-id:
     *     * jobs['step-id'].hadoopJob.mainJarFileUri
     *     * jobs['step-id'].hiveJob.queryFileUri
     *     * jobs['step-id'].pySparkJob.mainPythonFileUri
     *     * jobs['step-id'].hadoopJob.jarFileUris[0]
     *     * jobs['step-id'].hadoopJob.archiveUris[0]
     *     * jobs['step-id'].hadoopJob.fileUris[0]
     *     * jobs['step-id'].pySparkJob.pythonFileUris[0]
     * * Items in repeated fields can be referenced by a zero-based index:
     *     * jobs['step-id'].sparkJob.args[0]
     * * Other examples:
     *     * jobs['step-id'].hadoopJob.properties['key']
     *     * jobs['step-id'].hadoopJob.args[0]
     *     * jobs['step-id'].hiveJob.scriptVariables['key']
     *     * jobs['step-id'].hadoopJob.mainJarFileUri
     *     * placement.clusterSelector.zone
     * It may not be possible to parameterize maps and repeated fields in their
     * entirety since only individual map values and individual items in repeated
     * fields can be referenced. For example, the following field paths are
     * invalid:
     * - placement.clusterSelector.clusterLabels
     * - jobs['step-id'].sparkJob.args
     * </pre>
     *
     * <code>repeated string fields = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param index The index of the element to return.
     * @return The fields at the given index.
     */
    public java.lang.String getFields(int index) {
      return fields_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Required. Paths to all fields that the parameter replaces.
     * A field is allowed to appear in at most one parameter's list of field
     * paths.
     * A field path is similar in syntax to a [google.protobuf.FieldMask][google.protobuf.FieldMask].
     * For example, a field path that references the zone field of a workflow
     * template's cluster selector would be specified as
     * `placement.clusterSelector.zone`.
     * Also, field paths can reference fields using the following syntax:
     * * Values in maps can be referenced by key:
     *     * labels['key']
     *     * placement.clusterSelector.clusterLabels['key']
     *     * placement.managedCluster.labels['key']
     *     * placement.clusterSelector.clusterLabels['key']
     *     * jobs['step-id'].labels['key']
     * * Jobs in the jobs list can be referenced by step-id:
     *     * jobs['step-id'].hadoopJob.mainJarFileUri
     *     * jobs['step-id'].hiveJob.queryFileUri
     *     * jobs['step-id'].pySparkJob.mainPythonFileUri
     *     * jobs['step-id'].hadoopJob.jarFileUris[0]
     *     * jobs['step-id'].hadoopJob.archiveUris[0]
     *     * jobs['step-id'].hadoopJob.fileUris[0]
     *     * jobs['step-id'].pySparkJob.pythonFileUris[0]
     * * Items in repeated fields can be referenced by a zero-based index:
     *     * jobs['step-id'].sparkJob.args[0]
     * * Other examples:
     *     * jobs['step-id'].hadoopJob.properties['key']
     *     * jobs['step-id'].hadoopJob.args[0]
     *     * jobs['step-id'].hiveJob.scriptVariables['key']
     *     * jobs['step-id'].hadoopJob.mainJarFileUri
     *     * placement.clusterSelector.zone
     * It may not be possible to parameterize maps and repeated fields in their
     * entirety since only individual map values and individual items in repeated
     * fields can be referenced. For example, the following field paths are
     * invalid:
     * - placement.clusterSelector.clusterLabels
     * - jobs['step-id'].sparkJob.args
     * </pre>
     *
     * <code>repeated string fields = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the fields at the given index.
     */
    public com.google.protobuf.ByteString getFieldsBytes(int index) {
      return fields_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Required. Paths to all fields that the parameter replaces.
     * A field is allowed to appear in at most one parameter's list of field
     * paths.
     * A field path is similar in syntax to a [google.protobuf.FieldMask][google.protobuf.FieldMask].
     * For example, a field path that references the zone field of a workflow
     * template's cluster selector would be specified as
     * `placement.clusterSelector.zone`.
     * Also, field paths can reference fields using the following syntax:
     * * Values in maps can be referenced by key:
     *     * labels['key']
     *     * placement.clusterSelector.clusterLabels['key']
     *     * placement.managedCluster.labels['key']
     *     * placement.clusterSelector.clusterLabels['key']
     *     * jobs['step-id'].labels['key']
     * * Jobs in the jobs list can be referenced by step-id:
     *     * jobs['step-id'].hadoopJob.mainJarFileUri
     *     * jobs['step-id'].hiveJob.queryFileUri
     *     * jobs['step-id'].pySparkJob.mainPythonFileUri
     *     * jobs['step-id'].hadoopJob.jarFileUris[0]
     *     * jobs['step-id'].hadoopJob.archiveUris[0]
     *     * jobs['step-id'].hadoopJob.fileUris[0]
     *     * jobs['step-id'].pySparkJob.pythonFileUris[0]
     * * Items in repeated fields can be referenced by a zero-based index:
     *     * jobs['step-id'].sparkJob.args[0]
     * * Other examples:
     *     * jobs['step-id'].hadoopJob.properties['key']
     *     * jobs['step-id'].hadoopJob.args[0]
     *     * jobs['step-id'].hiveJob.scriptVariables['key']
     *     * jobs['step-id'].hadoopJob.mainJarFileUri
     *     * placement.clusterSelector.zone
     * It may not be possible to parameterize maps and repeated fields in their
     * entirety since only individual map values and individual items in repeated
     * fields can be referenced. For example, the following field paths are
     * invalid:
     * - placement.clusterSelector.clusterLabels
     * - jobs['step-id'].sparkJob.args
     * </pre>
     *
     * <code>repeated string fields = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param index The index to set the value at.
     * @param value The fields to set.
     * @return This builder for chaining.
     */
    public Builder setFields(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureFieldsIsMutable();
      fields_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Paths to all fields that the parameter replaces.
     * A field is allowed to appear in at most one parameter's list of field
     * paths.
     * A field path is similar in syntax to a [google.protobuf.FieldMask][google.protobuf.FieldMask].
     * For example, a field path that references the zone field of a workflow
     * template's cluster selector would be specified as
     * `placement.clusterSelector.zone`.
     * Also, field paths can reference fields using the following syntax:
     * * Values in maps can be referenced by key:
     *     * labels['key']
     *     * placement.clusterSelector.clusterLabels['key']
     *     * placement.managedCluster.labels['key']
     *     * placement.clusterSelector.clusterLabels['key']
     *     * jobs['step-id'].labels['key']
     * * Jobs in the jobs list can be referenced by step-id:
     *     * jobs['step-id'].hadoopJob.mainJarFileUri
     *     * jobs['step-id'].hiveJob.queryFileUri
     *     * jobs['step-id'].pySparkJob.mainPythonFileUri
     *     * jobs['step-id'].hadoopJob.jarFileUris[0]
     *     * jobs['step-id'].hadoopJob.archiveUris[0]
     *     * jobs['step-id'].hadoopJob.fileUris[0]
     *     * jobs['step-id'].pySparkJob.pythonFileUris[0]
     * * Items in repeated fields can be referenced by a zero-based index:
     *     * jobs['step-id'].sparkJob.args[0]
     * * Other examples:
     *     * jobs['step-id'].hadoopJob.properties['key']
     *     * jobs['step-id'].hadoopJob.args[0]
     *     * jobs['step-id'].hiveJob.scriptVariables['key']
     *     * jobs['step-id'].hadoopJob.mainJarFileUri
     *     * placement.clusterSelector.zone
     * It may not be possible to parameterize maps and repeated fields in their
     * entirety since only individual map values and individual items in repeated
     * fields can be referenced. For example, the following field paths are
     * invalid:
     * - placement.clusterSelector.clusterLabels
     * - jobs['step-id'].sparkJob.args
     * </pre>
     *
     * <code>repeated string fields = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The fields to add.
     * @return This builder for chaining.
     */
    public Builder addFields(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureFieldsIsMutable();
      fields_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Paths to all fields that the parameter replaces.
     * A field is allowed to appear in at most one parameter's list of field
     * paths.
     * A field path is similar in syntax to a [google.protobuf.FieldMask][google.protobuf.FieldMask].
     * For example, a field path that references the zone field of a workflow
     * template's cluster selector would be specified as
     * `placement.clusterSelector.zone`.
     * Also, field paths can reference fields using the following syntax:
     * * Values in maps can be referenced by key:
     *     * labels['key']
     *     * placement.clusterSelector.clusterLabels['key']
     *     * placement.managedCluster.labels['key']
     *     * placement.clusterSelector.clusterLabels['key']
     *     * jobs['step-id'].labels['key']
     * * Jobs in the jobs list can be referenced by step-id:
     *     * jobs['step-id'].hadoopJob.mainJarFileUri
     *     * jobs['step-id'].hiveJob.queryFileUri
     *     * jobs['step-id'].pySparkJob.mainPythonFileUri
     *     * jobs['step-id'].hadoopJob.jarFileUris[0]
     *     * jobs['step-id'].hadoopJob.archiveUris[0]
     *     * jobs['step-id'].hadoopJob.fileUris[0]
     *     * jobs['step-id'].pySparkJob.pythonFileUris[0]
     * * Items in repeated fields can be referenced by a zero-based index:
     *     * jobs['step-id'].sparkJob.args[0]
     * * Other examples:
     *     * jobs['step-id'].hadoopJob.properties['key']
     *     * jobs['step-id'].hadoopJob.args[0]
     *     * jobs['step-id'].hiveJob.scriptVariables['key']
     *     * jobs['step-id'].hadoopJob.mainJarFileUri
     *     * placement.clusterSelector.zone
     * It may not be possible to parameterize maps and repeated fields in their
     * entirety since only individual map values and individual items in repeated
     * fields can be referenced. For example, the following field paths are
     * invalid:
     * - placement.clusterSelector.clusterLabels
     * - jobs['step-id'].sparkJob.args
     * </pre>
     *
     * <code>repeated string fields = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param values The fields to add.
     * @return This builder for chaining.
     */
    public Builder addAllFields(java.lang.Iterable<java.lang.String> values) {
      ensureFieldsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, fields_);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Paths to all fields that the parameter replaces.
     * A field is allowed to appear in at most one parameter's list of field
     * paths.
     * A field path is similar in syntax to a [google.protobuf.FieldMask][google.protobuf.FieldMask].
     * For example, a field path that references the zone field of a workflow
     * template's cluster selector would be specified as
     * `placement.clusterSelector.zone`.
     * Also, field paths can reference fields using the following syntax:
     * * Values in maps can be referenced by key:
     *     * labels['key']
     *     * placement.clusterSelector.clusterLabels['key']
     *     * placement.managedCluster.labels['key']
     *     * placement.clusterSelector.clusterLabels['key']
     *     * jobs['step-id'].labels['key']
     * * Jobs in the jobs list can be referenced by step-id:
     *     * jobs['step-id'].hadoopJob.mainJarFileUri
     *     * jobs['step-id'].hiveJob.queryFileUri
     *     * jobs['step-id'].pySparkJob.mainPythonFileUri
     *     * jobs['step-id'].hadoopJob.jarFileUris[0]
     *     * jobs['step-id'].hadoopJob.archiveUris[0]
     *     * jobs['step-id'].hadoopJob.fileUris[0]
     *     * jobs['step-id'].pySparkJob.pythonFileUris[0]
     * * Items in repeated fields can be referenced by a zero-based index:
     *     * jobs['step-id'].sparkJob.args[0]
     * * Other examples:
     *     * jobs['step-id'].hadoopJob.properties['key']
     *     * jobs['step-id'].hadoopJob.args[0]
     *     * jobs['step-id'].hiveJob.scriptVariables['key']
     *     * jobs['step-id'].hadoopJob.mainJarFileUri
     *     * placement.clusterSelector.zone
     * It may not be possible to parameterize maps and repeated fields in their
     * entirety since only individual map values and individual items in repeated
     * fields can be referenced. For example, the following field paths are
     * invalid:
     * - placement.clusterSelector.clusterLabels
     * - jobs['step-id'].sparkJob.args
     * </pre>
     *
     * <code>repeated string fields = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFields() {
      fields_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Paths to all fields that the parameter replaces.
     * A field is allowed to appear in at most one parameter's list of field
     * paths.
     * A field path is similar in syntax to a [google.protobuf.FieldMask][google.protobuf.FieldMask].
     * For example, a field path that references the zone field of a workflow
     * template's cluster selector would be specified as
     * `placement.clusterSelector.zone`.
     * Also, field paths can reference fields using the following syntax:
     * * Values in maps can be referenced by key:
     *     * labels['key']
     *     * placement.clusterSelector.clusterLabels['key']
     *     * placement.managedCluster.labels['key']
     *     * placement.clusterSelector.clusterLabels['key']
     *     * jobs['step-id'].labels['key']
     * * Jobs in the jobs list can be referenced by step-id:
     *     * jobs['step-id'].hadoopJob.mainJarFileUri
     *     * jobs['step-id'].hiveJob.queryFileUri
     *     * jobs['step-id'].pySparkJob.mainPythonFileUri
     *     * jobs['step-id'].hadoopJob.jarFileUris[0]
     *     * jobs['step-id'].hadoopJob.archiveUris[0]
     *     * jobs['step-id'].hadoopJob.fileUris[0]
     *     * jobs['step-id'].pySparkJob.pythonFileUris[0]
     * * Items in repeated fields can be referenced by a zero-based index:
     *     * jobs['step-id'].sparkJob.args[0]
     * * Other examples:
     *     * jobs['step-id'].hadoopJob.properties['key']
     *     * jobs['step-id'].hadoopJob.args[0]
     *     * jobs['step-id'].hiveJob.scriptVariables['key']
     *     * jobs['step-id'].hadoopJob.mainJarFileUri
     *     * placement.clusterSelector.zone
     * It may not be possible to parameterize maps and repeated fields in their
     * entirety since only individual map values and individual items in repeated
     * fields can be referenced. For example, the following field paths are
     * invalid:
     * - placement.clusterSelector.clusterLabels
     * - jobs['step-id'].sparkJob.args
     * </pre>
     *
     * <code>repeated string fields = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes of the fields to add.
     * @return This builder for chaining.
     */
    public Builder addFieldsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureFieldsIsMutable();
      fields_.add(value);
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * Optional. Brief description of the parameter.
     * Must not exceed 1024 characters.
     * </pre>
     *
     * <code>string description = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Brief description of the parameter.
     * Must not exceed 1024 characters.
     * </pre>
     *
     * <code>string description = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Brief description of the parameter.
     * Must not exceed 1024 characters.
     * </pre>
     *
     * <code>string description = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      description_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Brief description of the parameter.
     * Must not exceed 1024 characters.
     * </pre>
     *
     * <code>string description = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {

      description_ = getDefaultInstance().getDescription();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Brief description of the parameter.
     * Must not exceed 1024 characters.
     * </pre>
     *
     * <code>string description = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      description_ = value;
      onChanged();
      return this;
    }

    private com.google.cloud.dataproc.v1.ParameterValidation validation_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.ParameterValidation,
            com.google.cloud.dataproc.v1.ParameterValidation.Builder,
            com.google.cloud.dataproc.v1.ParameterValidationOrBuilder>
        validationBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Validation rules to be applied to this parameter's value.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.ParameterValidation validation = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the validation field is set.
     */
    public boolean hasValidation() {
      return validationBuilder_ != null || validation_ != null;
    }
    /**
     *
     *
     * <pre>
     * Optional. Validation rules to be applied to this parameter's value.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.ParameterValidation validation = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The validation.
     */
    public com.google.cloud.dataproc.v1.ParameterValidation getValidation() {
      if (validationBuilder_ == null) {
        return validation_ == null
            ? com.google.cloud.dataproc.v1.ParameterValidation.getDefaultInstance()
            : validation_;
      } else {
        return validationBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Validation rules to be applied to this parameter's value.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.ParameterValidation validation = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setValidation(com.google.cloud.dataproc.v1.ParameterValidation value) {
      if (validationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        validation_ = value;
        onChanged();
      } else {
        validationBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Validation rules to be applied to this parameter's value.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.ParameterValidation validation = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setValidation(
        com.google.cloud.dataproc.v1.ParameterValidation.Builder builderForValue) {
      if (validationBuilder_ == null) {
        validation_ = builderForValue.build();
        onChanged();
      } else {
        validationBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Validation rules to be applied to this parameter's value.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.ParameterValidation validation = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeValidation(com.google.cloud.dataproc.v1.ParameterValidation value) {
      if (validationBuilder_ == null) {
        if (validation_ != null) {
          validation_ =
              com.google.cloud.dataproc.v1.ParameterValidation.newBuilder(validation_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          validation_ = value;
        }
        onChanged();
      } else {
        validationBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Validation rules to be applied to this parameter's value.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.ParameterValidation validation = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearValidation() {
      if (validationBuilder_ == null) {
        validation_ = null;
        onChanged();
      } else {
        validation_ = null;
        validationBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Validation rules to be applied to this parameter's value.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.ParameterValidation validation = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataproc.v1.ParameterValidation.Builder getValidationBuilder() {

      onChanged();
      return getValidationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Validation rules to be applied to this parameter's value.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.ParameterValidation validation = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataproc.v1.ParameterValidationOrBuilder getValidationOrBuilder() {
      if (validationBuilder_ != null) {
        return validationBuilder_.getMessageOrBuilder();
      } else {
        return validation_ == null
            ? com.google.cloud.dataproc.v1.ParameterValidation.getDefaultInstance()
            : validation_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Validation rules to be applied to this parameter's value.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.ParameterValidation validation = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.ParameterValidation,
            com.google.cloud.dataproc.v1.ParameterValidation.Builder,
            com.google.cloud.dataproc.v1.ParameterValidationOrBuilder>
        getValidationFieldBuilder() {
      if (validationBuilder_ == null) {
        validationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataproc.v1.ParameterValidation,
                com.google.cloud.dataproc.v1.ParameterValidation.Builder,
                com.google.cloud.dataproc.v1.ParameterValidationOrBuilder>(
                getValidation(), getParentForChildren(), isClean());
        validation_ = null;
      }
      return validationBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dataproc.v1.TemplateParameter)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dataproc.v1.TemplateParameter)
  private static final com.google.cloud.dataproc.v1.TemplateParameter DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dataproc.v1.TemplateParameter();
  }

  public static com.google.cloud.dataproc.v1.TemplateParameter getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<TemplateParameter> PARSER =
      new com.google.protobuf.AbstractParser<TemplateParameter>() {
        @java.lang.Override
        public TemplateParameter parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<TemplateParameter> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<TemplateParameter> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dataproc.v1.TemplateParameter getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
