/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dataproc/v1/workflow_templates.proto

package com.google.cloud.dataproc.v1;

/**
 *
 *
 * <pre>
 * A Dataproc workflow template resource.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dataproc.v1.WorkflowMetadata}
 */
public final class WorkflowMetadata extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dataproc.v1.WorkflowMetadata)
    WorkflowMetadataOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use WorkflowMetadata.newBuilder() to construct.
  private WorkflowMetadata(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private WorkflowMetadata() {
    template_ = "";
    state_ = 0;
    clusterName_ = "";
    clusterUuid_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new WorkflowMetadata();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dataproc.v1.WorkflowTemplatesProto
        .internal_static_google_cloud_dataproc_v1_WorkflowMetadata_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 8:
        return internalGetParameters();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dataproc.v1.WorkflowTemplatesProto
        .internal_static_google_cloud_dataproc_v1_WorkflowMetadata_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dataproc.v1.WorkflowMetadata.class,
            com.google.cloud.dataproc.v1.WorkflowMetadata.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The operation state.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.dataproc.v1.WorkflowMetadata.State}
   */
  public enum State implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unused.
     * </pre>
     *
     * <code>UNKNOWN = 0;</code>
     */
    UNKNOWN(0),
    /**
     *
     *
     * <pre>
     * The operation has been created.
     * </pre>
     *
     * <code>PENDING = 1;</code>
     */
    PENDING(1),
    /**
     *
     *
     * <pre>
     * The operation is running.
     * </pre>
     *
     * <code>RUNNING = 2;</code>
     */
    RUNNING(2),
    /**
     *
     *
     * <pre>
     * The operation is done; either cancelled or completed.
     * </pre>
     *
     * <code>DONE = 3;</code>
     */
    DONE(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unused.
     * </pre>
     *
     * <code>UNKNOWN = 0;</code>
     */
    public static final int UNKNOWN_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The operation has been created.
     * </pre>
     *
     * <code>PENDING = 1;</code>
     */
    public static final int PENDING_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The operation is running.
     * </pre>
     *
     * <code>RUNNING = 2;</code>
     */
    public static final int RUNNING_VALUE = 2;
    /**
     *
     *
     * <pre>
     * The operation is done; either cancelled or completed.
     * </pre>
     *
     * <code>DONE = 3;</code>
     */
    public static final int DONE_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static State valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static State forNumber(int value) {
      switch (value) {
        case 0:
          return UNKNOWN;
        case 1:
          return PENDING;
        case 2:
          return RUNNING;
        case 3:
          return DONE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<State>() {
          public State findValueByNumber(int number) {
            return State.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.dataproc.v1.WorkflowMetadata.getDescriptor().getEnumTypes().get(0);
    }

    private static final State[] VALUES = values();

    public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private State(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.dataproc.v1.WorkflowMetadata.State)
  }

  public static final int TEMPLATE_FIELD_NUMBER = 1;
  private volatile java.lang.Object template_;
  /**
   *
   *
   * <pre>
   * Output only. The resource name of the workflow template as described
   * in https://cloud.google.com/apis/design/resource_names.
   * * For `projects.regions.workflowTemplates`, the resource name of the
   *   template has the following format:
   *   `projects/{project_id}/regions/{region}/workflowTemplates/{template_id}`
   * * For `projects.locations.workflowTemplates`, the resource name of the
   *   template has the following format:
   *   `projects/{project_id}/locations/{location}/workflowTemplates/{template_id}`
   * </pre>
   *
   * <code>string template = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The template.
   */
  @java.lang.Override
  public java.lang.String getTemplate() {
    java.lang.Object ref = template_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      template_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The resource name of the workflow template as described
   * in https://cloud.google.com/apis/design/resource_names.
   * * For `projects.regions.workflowTemplates`, the resource name of the
   *   template has the following format:
   *   `projects/{project_id}/regions/{region}/workflowTemplates/{template_id}`
   * * For `projects.locations.workflowTemplates`, the resource name of the
   *   template has the following format:
   *   `projects/{project_id}/locations/{location}/workflowTemplates/{template_id}`
   * </pre>
   *
   * <code>string template = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for template.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTemplateBytes() {
    java.lang.Object ref = template_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      template_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int VERSION_FIELD_NUMBER = 2;
  private int version_;
  /**
   *
   *
   * <pre>
   * Output only. The version of template at the time of
   * workflow instantiation.
   * </pre>
   *
   * <code>int32 version = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The version.
   */
  @java.lang.Override
  public int getVersion() {
    return version_;
  }

  public static final int CREATE_CLUSTER_FIELD_NUMBER = 3;
  private com.google.cloud.dataproc.v1.ClusterOperation createCluster_;
  /**
   *
   *
   * <pre>
   * Output only. The create cluster operation metadata.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.ClusterOperation create_cluster = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createCluster field is set.
   */
  @java.lang.Override
  public boolean hasCreateCluster() {
    return createCluster_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The create cluster operation metadata.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.ClusterOperation create_cluster = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createCluster.
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.ClusterOperation getCreateCluster() {
    return createCluster_ == null
        ? com.google.cloud.dataproc.v1.ClusterOperation.getDefaultInstance()
        : createCluster_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The create cluster operation metadata.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.ClusterOperation create_cluster = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.ClusterOperationOrBuilder getCreateClusterOrBuilder() {
    return getCreateCluster();
  }

  public static final int GRAPH_FIELD_NUMBER = 4;
  private com.google.cloud.dataproc.v1.WorkflowGraph graph_;
  /**
   *
   *
   * <pre>
   * Output only. The workflow graph.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.WorkflowGraph graph = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the graph field is set.
   */
  @java.lang.Override
  public boolean hasGraph() {
    return graph_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The workflow graph.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.WorkflowGraph graph = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The graph.
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.WorkflowGraph getGraph() {
    return graph_ == null
        ? com.google.cloud.dataproc.v1.WorkflowGraph.getDefaultInstance()
        : graph_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The workflow graph.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.WorkflowGraph graph = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.WorkflowGraphOrBuilder getGraphOrBuilder() {
    return getGraph();
  }

  public static final int DELETE_CLUSTER_FIELD_NUMBER = 5;
  private com.google.cloud.dataproc.v1.ClusterOperation deleteCluster_;
  /**
   *
   *
   * <pre>
   * Output only. The delete cluster operation metadata.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.ClusterOperation delete_cluster = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the deleteCluster field is set.
   */
  @java.lang.Override
  public boolean hasDeleteCluster() {
    return deleteCluster_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The delete cluster operation metadata.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.ClusterOperation delete_cluster = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The deleteCluster.
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.ClusterOperation getDeleteCluster() {
    return deleteCluster_ == null
        ? com.google.cloud.dataproc.v1.ClusterOperation.getDefaultInstance()
        : deleteCluster_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The delete cluster operation metadata.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.ClusterOperation delete_cluster = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.ClusterOperationOrBuilder getDeleteClusterOrBuilder() {
    return getDeleteCluster();
  }

  public static final int STATE_FIELD_NUMBER = 6;
  private int state_;
  /**
   *
   *
   * <pre>
   * Output only. The workflow state.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.WorkflowMetadata.State state = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The workflow state.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.WorkflowMetadata.State state = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.WorkflowMetadata.State getState() {
    @SuppressWarnings("deprecation")
    com.google.cloud.dataproc.v1.WorkflowMetadata.State result =
        com.google.cloud.dataproc.v1.WorkflowMetadata.State.valueOf(state_);
    return result == null
        ? com.google.cloud.dataproc.v1.WorkflowMetadata.State.UNRECOGNIZED
        : result;
  }

  public static final int CLUSTER_NAME_FIELD_NUMBER = 7;
  private volatile java.lang.Object clusterName_;
  /**
   *
   *
   * <pre>
   * Output only. The name of the target cluster.
   * </pre>
   *
   * <code>string cluster_name = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The clusterName.
   */
  @java.lang.Override
  public java.lang.String getClusterName() {
    java.lang.Object ref = clusterName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      clusterName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The name of the target cluster.
   * </pre>
   *
   * <code>string cluster_name = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for clusterName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getClusterNameBytes() {
    java.lang.Object ref = clusterName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      clusterName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PARAMETERS_FIELD_NUMBER = 8;

  private static final class ParametersDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.dataproc.v1.WorkflowTemplatesProto
                .internal_static_google_cloud_dataproc_v1_WorkflowMetadata_ParametersEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> parameters_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetParameters() {
    if (parameters_ == null) {
      return com.google.protobuf.MapField.emptyMapField(ParametersDefaultEntryHolder.defaultEntry);
    }
    return parameters_;
  }

  public int getParametersCount() {
    return internalGetParameters().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Map from parameter names to values that were used for those parameters.
   * </pre>
   *
   * <code>map&lt;string, string&gt; parameters = 8;</code>
   */
  @java.lang.Override
  public boolean containsParameters(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetParameters().getMap().containsKey(key);
  }
  /** Use {@link #getParametersMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getParameters() {
    return getParametersMap();
  }
  /**
   *
   *
   * <pre>
   * Map from parameter names to values that were used for those parameters.
   * </pre>
   *
   * <code>map&lt;string, string&gt; parameters = 8;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getParametersMap() {
    return internalGetParameters().getMap();
  }
  /**
   *
   *
   * <pre>
   * Map from parameter names to values that were used for those parameters.
   * </pre>
   *
   * <code>map&lt;string, string&gt; parameters = 8;</code>
   */
  @java.lang.Override
  public java.lang.String getParametersOrDefault(
      java.lang.String key, java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetParameters().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Map from parameter names to values that were used for those parameters.
   * </pre>
   *
   * <code>map&lt;string, string&gt; parameters = 8;</code>
   */
  @java.lang.Override
  public java.lang.String getParametersOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetParameters().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int START_TIME_FIELD_NUMBER = 9;
  private com.google.protobuf.Timestamp startTime_;
  /**
   *
   *
   * <pre>
   * Output only. Workflow start time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the startTime field is set.
   */
  @java.lang.Override
  public boolean hasStartTime() {
    return startTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Workflow start time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The startTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getStartTime() {
    return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Workflow start time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
    return getStartTime();
  }

  public static final int END_TIME_FIELD_NUMBER = 10;
  private com.google.protobuf.Timestamp endTime_;
  /**
   *
   *
   * <pre>
   * Output only. Workflow end time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the endTime field is set.
   */
  @java.lang.Override
  public boolean hasEndTime() {
    return endTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Workflow end time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The endTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getEndTime() {
    return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Workflow end time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
    return getEndTime();
  }

  public static final int CLUSTER_UUID_FIELD_NUMBER = 11;
  private volatile java.lang.Object clusterUuid_;
  /**
   *
   *
   * <pre>
   * Output only. The UUID of target cluster.
   * </pre>
   *
   * <code>string cluster_uuid = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The clusterUuid.
   */
  @java.lang.Override
  public java.lang.String getClusterUuid() {
    java.lang.Object ref = clusterUuid_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      clusterUuid_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The UUID of target cluster.
   * </pre>
   *
   * <code>string cluster_uuid = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for clusterUuid.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getClusterUuidBytes() {
    java.lang.Object ref = clusterUuid_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      clusterUuid_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DAG_TIMEOUT_FIELD_NUMBER = 12;
  private com.google.protobuf.Duration dagTimeout_;
  /**
   *
   *
   * <pre>
   * Output only. The timeout duration for the DAG of jobs, expressed in seconds (see
   * [JSON representation of
   * duration](https://developers.google.com/protocol-buffers/docs/proto3#json)).
   * </pre>
   *
   * <code>.google.protobuf.Duration dag_timeout = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the dagTimeout field is set.
   */
  @java.lang.Override
  public boolean hasDagTimeout() {
    return dagTimeout_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The timeout duration for the DAG of jobs, expressed in seconds (see
   * [JSON representation of
   * duration](https://developers.google.com/protocol-buffers/docs/proto3#json)).
   * </pre>
   *
   * <code>.google.protobuf.Duration dag_timeout = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The dagTimeout.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getDagTimeout() {
    return dagTimeout_ == null ? com.google.protobuf.Duration.getDefaultInstance() : dagTimeout_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The timeout duration for the DAG of jobs, expressed in seconds (see
   * [JSON representation of
   * duration](https://developers.google.com/protocol-buffers/docs/proto3#json)).
   * </pre>
   *
   * <code>.google.protobuf.Duration dag_timeout = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getDagTimeoutOrBuilder() {
    return getDagTimeout();
  }

  public static final int DAG_START_TIME_FIELD_NUMBER = 13;
  private com.google.protobuf.Timestamp dagStartTime_;
  /**
   *
   *
   * <pre>
   * Output only. DAG start time, only set for workflows with [dag_timeout][google.cloud.dataproc.v1.WorkflowMetadata.dag_timeout] when DAG
   * begins.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp dag_start_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the dagStartTime field is set.
   */
  @java.lang.Override
  public boolean hasDagStartTime() {
    return dagStartTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. DAG start time, only set for workflows with [dag_timeout][google.cloud.dataproc.v1.WorkflowMetadata.dag_timeout] when DAG
   * begins.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp dag_start_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The dagStartTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getDagStartTime() {
    return dagStartTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : dagStartTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. DAG start time, only set for workflows with [dag_timeout][google.cloud.dataproc.v1.WorkflowMetadata.dag_timeout] when DAG
   * begins.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp dag_start_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getDagStartTimeOrBuilder() {
    return getDagStartTime();
  }

  public static final int DAG_END_TIME_FIELD_NUMBER = 14;
  private com.google.protobuf.Timestamp dagEndTime_;
  /**
   *
   *
   * <pre>
   * Output only. DAG end time, only set for workflows with [dag_timeout][google.cloud.dataproc.v1.WorkflowMetadata.dag_timeout] when DAG ends.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp dag_end_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the dagEndTime field is set.
   */
  @java.lang.Override
  public boolean hasDagEndTime() {
    return dagEndTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. DAG end time, only set for workflows with [dag_timeout][google.cloud.dataproc.v1.WorkflowMetadata.dag_timeout] when DAG ends.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp dag_end_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The dagEndTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getDagEndTime() {
    return dagEndTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : dagEndTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. DAG end time, only set for workflows with [dag_timeout][google.cloud.dataproc.v1.WorkflowMetadata.dag_timeout] when DAG ends.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp dag_end_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getDagEndTimeOrBuilder() {
    return getDagEndTime();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(template_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, template_);
    }
    if (version_ != 0) {
      output.writeInt32(2, version_);
    }
    if (createCluster_ != null) {
      output.writeMessage(3, getCreateCluster());
    }
    if (graph_ != null) {
      output.writeMessage(4, getGraph());
    }
    if (deleteCluster_ != null) {
      output.writeMessage(5, getDeleteCluster());
    }
    if (state_ != com.google.cloud.dataproc.v1.WorkflowMetadata.State.UNKNOWN.getNumber()) {
      output.writeEnum(6, state_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(clusterName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, clusterName_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetParameters(), ParametersDefaultEntryHolder.defaultEntry, 8);
    if (startTime_ != null) {
      output.writeMessage(9, getStartTime());
    }
    if (endTime_ != null) {
      output.writeMessage(10, getEndTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(clusterUuid_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 11, clusterUuid_);
    }
    if (dagTimeout_ != null) {
      output.writeMessage(12, getDagTimeout());
    }
    if (dagStartTime_ != null) {
      output.writeMessage(13, getDagStartTime());
    }
    if (dagEndTime_ != null) {
      output.writeMessage(14, getDagEndTime());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(template_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, template_);
    }
    if (version_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, version_);
    }
    if (createCluster_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getCreateCluster());
    }
    if (graph_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getGraph());
    }
    if (deleteCluster_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getDeleteCluster());
    }
    if (state_ != com.google.cloud.dataproc.v1.WorkflowMetadata.State.UNKNOWN.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(6, state_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(clusterName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, clusterName_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetParameters().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> parameters__ =
          ParametersDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, parameters__);
    }
    if (startTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getStartTime());
    }
    if (endTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, getEndTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(clusterUuid_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(11, clusterUuid_);
    }
    if (dagTimeout_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(12, getDagTimeout());
    }
    if (dagStartTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(13, getDagStartTime());
    }
    if (dagEndTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(14, getDagEndTime());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dataproc.v1.WorkflowMetadata)) {
      return super.equals(obj);
    }
    com.google.cloud.dataproc.v1.WorkflowMetadata other =
        (com.google.cloud.dataproc.v1.WorkflowMetadata) obj;

    if (!getTemplate().equals(other.getTemplate())) return false;
    if (getVersion() != other.getVersion()) return false;
    if (hasCreateCluster() != other.hasCreateCluster()) return false;
    if (hasCreateCluster()) {
      if (!getCreateCluster().equals(other.getCreateCluster())) return false;
    }
    if (hasGraph() != other.hasGraph()) return false;
    if (hasGraph()) {
      if (!getGraph().equals(other.getGraph())) return false;
    }
    if (hasDeleteCluster() != other.hasDeleteCluster()) return false;
    if (hasDeleteCluster()) {
      if (!getDeleteCluster().equals(other.getDeleteCluster())) return false;
    }
    if (state_ != other.state_) return false;
    if (!getClusterName().equals(other.getClusterName())) return false;
    if (!internalGetParameters().equals(other.internalGetParameters())) return false;
    if (hasStartTime() != other.hasStartTime()) return false;
    if (hasStartTime()) {
      if (!getStartTime().equals(other.getStartTime())) return false;
    }
    if (hasEndTime() != other.hasEndTime()) return false;
    if (hasEndTime()) {
      if (!getEndTime().equals(other.getEndTime())) return false;
    }
    if (!getClusterUuid().equals(other.getClusterUuid())) return false;
    if (hasDagTimeout() != other.hasDagTimeout()) return false;
    if (hasDagTimeout()) {
      if (!getDagTimeout().equals(other.getDagTimeout())) return false;
    }
    if (hasDagStartTime() != other.hasDagStartTime()) return false;
    if (hasDagStartTime()) {
      if (!getDagStartTime().equals(other.getDagStartTime())) return false;
    }
    if (hasDagEndTime() != other.hasDagEndTime()) return false;
    if (hasDagEndTime()) {
      if (!getDagEndTime().equals(other.getDagEndTime())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + TEMPLATE_FIELD_NUMBER;
    hash = (53 * hash) + getTemplate().hashCode();
    hash = (37 * hash) + VERSION_FIELD_NUMBER;
    hash = (53 * hash) + getVersion();
    if (hasCreateCluster()) {
      hash = (37 * hash) + CREATE_CLUSTER_FIELD_NUMBER;
      hash = (53 * hash) + getCreateCluster().hashCode();
    }
    if (hasGraph()) {
      hash = (37 * hash) + GRAPH_FIELD_NUMBER;
      hash = (53 * hash) + getGraph().hashCode();
    }
    if (hasDeleteCluster()) {
      hash = (37 * hash) + DELETE_CLUSTER_FIELD_NUMBER;
      hash = (53 * hash) + getDeleteCluster().hashCode();
    }
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    hash = (37 * hash) + CLUSTER_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getClusterName().hashCode();
    if (!internalGetParameters().getMap().isEmpty()) {
      hash = (37 * hash) + PARAMETERS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetParameters().hashCode();
    }
    if (hasStartTime()) {
      hash = (37 * hash) + START_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getStartTime().hashCode();
    }
    if (hasEndTime()) {
      hash = (37 * hash) + END_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getEndTime().hashCode();
    }
    hash = (37 * hash) + CLUSTER_UUID_FIELD_NUMBER;
    hash = (53 * hash) + getClusterUuid().hashCode();
    if (hasDagTimeout()) {
      hash = (37 * hash) + DAG_TIMEOUT_FIELD_NUMBER;
      hash = (53 * hash) + getDagTimeout().hashCode();
    }
    if (hasDagStartTime()) {
      hash = (37 * hash) + DAG_START_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getDagStartTime().hashCode();
    }
    if (hasDagEndTime()) {
      hash = (37 * hash) + DAG_END_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getDagEndTime().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dataproc.v1.WorkflowMetadata parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1.WorkflowMetadata parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.WorkflowMetadata parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1.WorkflowMetadata parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.WorkflowMetadata parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1.WorkflowMetadata parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.WorkflowMetadata parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1.WorkflowMetadata parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.WorkflowMetadata parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1.WorkflowMetadata parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.WorkflowMetadata parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1.WorkflowMetadata parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.dataproc.v1.WorkflowMetadata prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A Dataproc workflow template resource.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dataproc.v1.WorkflowMetadata}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dataproc.v1.WorkflowMetadata)
      com.google.cloud.dataproc.v1.WorkflowMetadataOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dataproc.v1.WorkflowTemplatesProto
          .internal_static_google_cloud_dataproc_v1_WorkflowMetadata_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 8:
          return internalGetParameters();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 8:
          return internalGetMutableParameters();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dataproc.v1.WorkflowTemplatesProto
          .internal_static_google_cloud_dataproc_v1_WorkflowMetadata_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dataproc.v1.WorkflowMetadata.class,
              com.google.cloud.dataproc.v1.WorkflowMetadata.Builder.class);
    }

    // Construct using com.google.cloud.dataproc.v1.WorkflowMetadata.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      template_ = "";

      version_ = 0;

      if (createClusterBuilder_ == null) {
        createCluster_ = null;
      } else {
        createCluster_ = null;
        createClusterBuilder_ = null;
      }
      if (graphBuilder_ == null) {
        graph_ = null;
      } else {
        graph_ = null;
        graphBuilder_ = null;
      }
      if (deleteClusterBuilder_ == null) {
        deleteCluster_ = null;
      } else {
        deleteCluster_ = null;
        deleteClusterBuilder_ = null;
      }
      state_ = 0;

      clusterName_ = "";

      internalGetMutableParameters().clear();
      if (startTimeBuilder_ == null) {
        startTime_ = null;
      } else {
        startTime_ = null;
        startTimeBuilder_ = null;
      }
      if (endTimeBuilder_ == null) {
        endTime_ = null;
      } else {
        endTime_ = null;
        endTimeBuilder_ = null;
      }
      clusterUuid_ = "";

      if (dagTimeoutBuilder_ == null) {
        dagTimeout_ = null;
      } else {
        dagTimeout_ = null;
        dagTimeoutBuilder_ = null;
      }
      if (dagStartTimeBuilder_ == null) {
        dagStartTime_ = null;
      } else {
        dagStartTime_ = null;
        dagStartTimeBuilder_ = null;
      }
      if (dagEndTimeBuilder_ == null) {
        dagEndTime_ = null;
      } else {
        dagEndTime_ = null;
        dagEndTimeBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dataproc.v1.WorkflowTemplatesProto
          .internal_static_google_cloud_dataproc_v1_WorkflowMetadata_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.WorkflowMetadata getDefaultInstanceForType() {
      return com.google.cloud.dataproc.v1.WorkflowMetadata.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.WorkflowMetadata build() {
      com.google.cloud.dataproc.v1.WorkflowMetadata result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.WorkflowMetadata buildPartial() {
      com.google.cloud.dataproc.v1.WorkflowMetadata result =
          new com.google.cloud.dataproc.v1.WorkflowMetadata(this);
      int from_bitField0_ = bitField0_;
      result.template_ = template_;
      result.version_ = version_;
      if (createClusterBuilder_ == null) {
        result.createCluster_ = createCluster_;
      } else {
        result.createCluster_ = createClusterBuilder_.build();
      }
      if (graphBuilder_ == null) {
        result.graph_ = graph_;
      } else {
        result.graph_ = graphBuilder_.build();
      }
      if (deleteClusterBuilder_ == null) {
        result.deleteCluster_ = deleteCluster_;
      } else {
        result.deleteCluster_ = deleteClusterBuilder_.build();
      }
      result.state_ = state_;
      result.clusterName_ = clusterName_;
      result.parameters_ = internalGetParameters();
      result.parameters_.makeImmutable();
      if (startTimeBuilder_ == null) {
        result.startTime_ = startTime_;
      } else {
        result.startTime_ = startTimeBuilder_.build();
      }
      if (endTimeBuilder_ == null) {
        result.endTime_ = endTime_;
      } else {
        result.endTime_ = endTimeBuilder_.build();
      }
      result.clusterUuid_ = clusterUuid_;
      if (dagTimeoutBuilder_ == null) {
        result.dagTimeout_ = dagTimeout_;
      } else {
        result.dagTimeout_ = dagTimeoutBuilder_.build();
      }
      if (dagStartTimeBuilder_ == null) {
        result.dagStartTime_ = dagStartTime_;
      } else {
        result.dagStartTime_ = dagStartTimeBuilder_.build();
      }
      if (dagEndTimeBuilder_ == null) {
        result.dagEndTime_ = dagEndTime_;
      } else {
        result.dagEndTime_ = dagEndTimeBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dataproc.v1.WorkflowMetadata) {
        return mergeFrom((com.google.cloud.dataproc.v1.WorkflowMetadata) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dataproc.v1.WorkflowMetadata other) {
      if (other == com.google.cloud.dataproc.v1.WorkflowMetadata.getDefaultInstance()) return this;
      if (!other.getTemplate().isEmpty()) {
        template_ = other.template_;
        onChanged();
      }
      if (other.getVersion() != 0) {
        setVersion(other.getVersion());
      }
      if (other.hasCreateCluster()) {
        mergeCreateCluster(other.getCreateCluster());
      }
      if (other.hasGraph()) {
        mergeGraph(other.getGraph());
      }
      if (other.hasDeleteCluster()) {
        mergeDeleteCluster(other.getDeleteCluster());
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (!other.getClusterName().isEmpty()) {
        clusterName_ = other.clusterName_;
        onChanged();
      }
      internalGetMutableParameters().mergeFrom(other.internalGetParameters());
      if (other.hasStartTime()) {
        mergeStartTime(other.getStartTime());
      }
      if (other.hasEndTime()) {
        mergeEndTime(other.getEndTime());
      }
      if (!other.getClusterUuid().isEmpty()) {
        clusterUuid_ = other.clusterUuid_;
        onChanged();
      }
      if (other.hasDagTimeout()) {
        mergeDagTimeout(other.getDagTimeout());
      }
      if (other.hasDagStartTime()) {
        mergeDagStartTime(other.getDagStartTime());
      }
      if (other.hasDagEndTime()) {
        mergeDagEndTime(other.getDagEndTime());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                template_ = input.readStringRequireUtf8();

                break;
              } // case 10
            case 16:
              {
                version_ = input.readInt32();

                break;
              } // case 16
            case 26:
              {
                input.readMessage(getCreateClusterFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 26
            case 34:
              {
                input.readMessage(getGraphFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 34
            case 42:
              {
                input.readMessage(getDeleteClusterFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 42
            case 48:
              {
                state_ = input.readEnum();

                break;
              } // case 48
            case 58:
              {
                clusterName_ = input.readStringRequireUtf8();

                break;
              } // case 58
            case 66:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> parameters__ =
                    input.readMessage(
                        ParametersDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableParameters()
                    .getMutableMap()
                    .put(parameters__.getKey(), parameters__.getValue());
                break;
              } // case 66
            case 74:
              {
                input.readMessage(getStartTimeFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 74
            case 82:
              {
                input.readMessage(getEndTimeFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 82
            case 90:
              {
                clusterUuid_ = input.readStringRequireUtf8();

                break;
              } // case 90
            case 98:
              {
                input.readMessage(getDagTimeoutFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 98
            case 106:
              {
                input.readMessage(getDagStartTimeFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 106
            case 114:
              {
                input.readMessage(getDagEndTimeFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 114
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object template_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the workflow template as described
     * in https://cloud.google.com/apis/design/resource_names.
     * * For `projects.regions.workflowTemplates`, the resource name of the
     *   template has the following format:
     *   `projects/{project_id}/regions/{region}/workflowTemplates/{template_id}`
     * * For `projects.locations.workflowTemplates`, the resource name of the
     *   template has the following format:
     *   `projects/{project_id}/locations/{location}/workflowTemplates/{template_id}`
     * </pre>
     *
     * <code>string template = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The template.
     */
    public java.lang.String getTemplate() {
      java.lang.Object ref = template_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        template_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the workflow template as described
     * in https://cloud.google.com/apis/design/resource_names.
     * * For `projects.regions.workflowTemplates`, the resource name of the
     *   template has the following format:
     *   `projects/{project_id}/regions/{region}/workflowTemplates/{template_id}`
     * * For `projects.locations.workflowTemplates`, the resource name of the
     *   template has the following format:
     *   `projects/{project_id}/locations/{location}/workflowTemplates/{template_id}`
     * </pre>
     *
     * <code>string template = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for template.
     */
    public com.google.protobuf.ByteString getTemplateBytes() {
      java.lang.Object ref = template_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        template_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the workflow template as described
     * in https://cloud.google.com/apis/design/resource_names.
     * * For `projects.regions.workflowTemplates`, the resource name of the
     *   template has the following format:
     *   `projects/{project_id}/regions/{region}/workflowTemplates/{template_id}`
     * * For `projects.locations.workflowTemplates`, the resource name of the
     *   template has the following format:
     *   `projects/{project_id}/locations/{location}/workflowTemplates/{template_id}`
     * </pre>
     *
     * <code>string template = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The template to set.
     * @return This builder for chaining.
     */
    public Builder setTemplate(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      template_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the workflow template as described
     * in https://cloud.google.com/apis/design/resource_names.
     * * For `projects.regions.workflowTemplates`, the resource name of the
     *   template has the following format:
     *   `projects/{project_id}/regions/{region}/workflowTemplates/{template_id}`
     * * For `projects.locations.workflowTemplates`, the resource name of the
     *   template has the following format:
     *   `projects/{project_id}/locations/{location}/workflowTemplates/{template_id}`
     * </pre>
     *
     * <code>string template = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTemplate() {

      template_ = getDefaultInstance().getTemplate();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the workflow template as described
     * in https://cloud.google.com/apis/design/resource_names.
     * * For `projects.regions.workflowTemplates`, the resource name of the
     *   template has the following format:
     *   `projects/{project_id}/regions/{region}/workflowTemplates/{template_id}`
     * * For `projects.locations.workflowTemplates`, the resource name of the
     *   template has the following format:
     *   `projects/{project_id}/locations/{location}/workflowTemplates/{template_id}`
     * </pre>
     *
     * <code>string template = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for template to set.
     * @return This builder for chaining.
     */
    public Builder setTemplateBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      template_ = value;
      onChanged();
      return this;
    }

    private int version_;
    /**
     *
     *
     * <pre>
     * Output only. The version of template at the time of
     * workflow instantiation.
     * </pre>
     *
     * <code>int32 version = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The version.
     */
    @java.lang.Override
    public int getVersion() {
      return version_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The version of template at the time of
     * workflow instantiation.
     * </pre>
     *
     * <code>int32 version = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The version to set.
     * @return This builder for chaining.
     */
    public Builder setVersion(int value) {

      version_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The version of template at the time of
     * workflow instantiation.
     * </pre>
     *
     * <code>int32 version = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearVersion() {

      version_ = 0;
      onChanged();
      return this;
    }

    private com.google.cloud.dataproc.v1.ClusterOperation createCluster_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.ClusterOperation,
            com.google.cloud.dataproc.v1.ClusterOperation.Builder,
            com.google.cloud.dataproc.v1.ClusterOperationOrBuilder>
        createClusterBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The create cluster operation metadata.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.ClusterOperation create_cluster = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createCluster field is set.
     */
    public boolean hasCreateCluster() {
      return createClusterBuilder_ != null || createCluster_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. The create cluster operation metadata.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.ClusterOperation create_cluster = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createCluster.
     */
    public com.google.cloud.dataproc.v1.ClusterOperation getCreateCluster() {
      if (createClusterBuilder_ == null) {
        return createCluster_ == null
            ? com.google.cloud.dataproc.v1.ClusterOperation.getDefaultInstance()
            : createCluster_;
      } else {
        return createClusterBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The create cluster operation metadata.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.ClusterOperation create_cluster = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateCluster(com.google.cloud.dataproc.v1.ClusterOperation value) {
      if (createClusterBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createCluster_ = value;
        onChanged();
      } else {
        createClusterBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The create cluster operation metadata.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.ClusterOperation create_cluster = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateCluster(
        com.google.cloud.dataproc.v1.ClusterOperation.Builder builderForValue) {
      if (createClusterBuilder_ == null) {
        createCluster_ = builderForValue.build();
        onChanged();
      } else {
        createClusterBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The create cluster operation metadata.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.ClusterOperation create_cluster = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateCluster(com.google.cloud.dataproc.v1.ClusterOperation value) {
      if (createClusterBuilder_ == null) {
        if (createCluster_ != null) {
          createCluster_ =
              com.google.cloud.dataproc.v1.ClusterOperation.newBuilder(createCluster_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          createCluster_ = value;
        }
        onChanged();
      } else {
        createClusterBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The create cluster operation metadata.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.ClusterOperation create_cluster = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateCluster() {
      if (createClusterBuilder_ == null) {
        createCluster_ = null;
        onChanged();
      } else {
        createCluster_ = null;
        createClusterBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The create cluster operation metadata.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.ClusterOperation create_cluster = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.dataproc.v1.ClusterOperation.Builder getCreateClusterBuilder() {

      onChanged();
      return getCreateClusterFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The create cluster operation metadata.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.ClusterOperation create_cluster = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.dataproc.v1.ClusterOperationOrBuilder getCreateClusterOrBuilder() {
      if (createClusterBuilder_ != null) {
        return createClusterBuilder_.getMessageOrBuilder();
      } else {
        return createCluster_ == null
            ? com.google.cloud.dataproc.v1.ClusterOperation.getDefaultInstance()
            : createCluster_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The create cluster operation metadata.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.ClusterOperation create_cluster = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.ClusterOperation,
            com.google.cloud.dataproc.v1.ClusterOperation.Builder,
            com.google.cloud.dataproc.v1.ClusterOperationOrBuilder>
        getCreateClusterFieldBuilder() {
      if (createClusterBuilder_ == null) {
        createClusterBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataproc.v1.ClusterOperation,
                com.google.cloud.dataproc.v1.ClusterOperation.Builder,
                com.google.cloud.dataproc.v1.ClusterOperationOrBuilder>(
                getCreateCluster(), getParentForChildren(), isClean());
        createCluster_ = null;
      }
      return createClusterBuilder_;
    }

    private com.google.cloud.dataproc.v1.WorkflowGraph graph_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.WorkflowGraph,
            com.google.cloud.dataproc.v1.WorkflowGraph.Builder,
            com.google.cloud.dataproc.v1.WorkflowGraphOrBuilder>
        graphBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The workflow graph.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.WorkflowGraph graph = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the graph field is set.
     */
    public boolean hasGraph() {
      return graphBuilder_ != null || graph_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. The workflow graph.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.WorkflowGraph graph = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The graph.
     */
    public com.google.cloud.dataproc.v1.WorkflowGraph getGraph() {
      if (graphBuilder_ == null) {
        return graph_ == null
            ? com.google.cloud.dataproc.v1.WorkflowGraph.getDefaultInstance()
            : graph_;
      } else {
        return graphBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The workflow graph.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.WorkflowGraph graph = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setGraph(com.google.cloud.dataproc.v1.WorkflowGraph value) {
      if (graphBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        graph_ = value;
        onChanged();
      } else {
        graphBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The workflow graph.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.WorkflowGraph graph = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setGraph(com.google.cloud.dataproc.v1.WorkflowGraph.Builder builderForValue) {
      if (graphBuilder_ == null) {
        graph_ = builderForValue.build();
        onChanged();
      } else {
        graphBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The workflow graph.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.WorkflowGraph graph = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeGraph(com.google.cloud.dataproc.v1.WorkflowGraph value) {
      if (graphBuilder_ == null) {
        if (graph_ != null) {
          graph_ =
              com.google.cloud.dataproc.v1.WorkflowGraph.newBuilder(graph_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          graph_ = value;
        }
        onChanged();
      } else {
        graphBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The workflow graph.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.WorkflowGraph graph = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearGraph() {
      if (graphBuilder_ == null) {
        graph_ = null;
        onChanged();
      } else {
        graph_ = null;
        graphBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The workflow graph.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.WorkflowGraph graph = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.dataproc.v1.WorkflowGraph.Builder getGraphBuilder() {

      onChanged();
      return getGraphFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The workflow graph.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.WorkflowGraph graph = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.dataproc.v1.WorkflowGraphOrBuilder getGraphOrBuilder() {
      if (graphBuilder_ != null) {
        return graphBuilder_.getMessageOrBuilder();
      } else {
        return graph_ == null
            ? com.google.cloud.dataproc.v1.WorkflowGraph.getDefaultInstance()
            : graph_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The workflow graph.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.WorkflowGraph graph = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.WorkflowGraph,
            com.google.cloud.dataproc.v1.WorkflowGraph.Builder,
            com.google.cloud.dataproc.v1.WorkflowGraphOrBuilder>
        getGraphFieldBuilder() {
      if (graphBuilder_ == null) {
        graphBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataproc.v1.WorkflowGraph,
                com.google.cloud.dataproc.v1.WorkflowGraph.Builder,
                com.google.cloud.dataproc.v1.WorkflowGraphOrBuilder>(
                getGraph(), getParentForChildren(), isClean());
        graph_ = null;
      }
      return graphBuilder_;
    }

    private com.google.cloud.dataproc.v1.ClusterOperation deleteCluster_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.ClusterOperation,
            com.google.cloud.dataproc.v1.ClusterOperation.Builder,
            com.google.cloud.dataproc.v1.ClusterOperationOrBuilder>
        deleteClusterBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The delete cluster operation metadata.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.ClusterOperation delete_cluster = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the deleteCluster field is set.
     */
    public boolean hasDeleteCluster() {
      return deleteClusterBuilder_ != null || deleteCluster_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. The delete cluster operation metadata.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.ClusterOperation delete_cluster = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The deleteCluster.
     */
    public com.google.cloud.dataproc.v1.ClusterOperation getDeleteCluster() {
      if (deleteClusterBuilder_ == null) {
        return deleteCluster_ == null
            ? com.google.cloud.dataproc.v1.ClusterOperation.getDefaultInstance()
            : deleteCluster_;
      } else {
        return deleteClusterBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The delete cluster operation metadata.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.ClusterOperation delete_cluster = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setDeleteCluster(com.google.cloud.dataproc.v1.ClusterOperation value) {
      if (deleteClusterBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        deleteCluster_ = value;
        onChanged();
      } else {
        deleteClusterBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The delete cluster operation metadata.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.ClusterOperation delete_cluster = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setDeleteCluster(
        com.google.cloud.dataproc.v1.ClusterOperation.Builder builderForValue) {
      if (deleteClusterBuilder_ == null) {
        deleteCluster_ = builderForValue.build();
        onChanged();
      } else {
        deleteClusterBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The delete cluster operation metadata.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.ClusterOperation delete_cluster = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeDeleteCluster(com.google.cloud.dataproc.v1.ClusterOperation value) {
      if (deleteClusterBuilder_ == null) {
        if (deleteCluster_ != null) {
          deleteCluster_ =
              com.google.cloud.dataproc.v1.ClusterOperation.newBuilder(deleteCluster_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          deleteCluster_ = value;
        }
        onChanged();
      } else {
        deleteClusterBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The delete cluster operation metadata.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.ClusterOperation delete_cluster = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearDeleteCluster() {
      if (deleteClusterBuilder_ == null) {
        deleteCluster_ = null;
        onChanged();
      } else {
        deleteCluster_ = null;
        deleteClusterBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The delete cluster operation metadata.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.ClusterOperation delete_cluster = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.dataproc.v1.ClusterOperation.Builder getDeleteClusterBuilder() {

      onChanged();
      return getDeleteClusterFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The delete cluster operation metadata.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.ClusterOperation delete_cluster = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.dataproc.v1.ClusterOperationOrBuilder getDeleteClusterOrBuilder() {
      if (deleteClusterBuilder_ != null) {
        return deleteClusterBuilder_.getMessageOrBuilder();
      } else {
        return deleteCluster_ == null
            ? com.google.cloud.dataproc.v1.ClusterOperation.getDefaultInstance()
            : deleteCluster_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The delete cluster operation metadata.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.ClusterOperation delete_cluster = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.ClusterOperation,
            com.google.cloud.dataproc.v1.ClusterOperation.Builder,
            com.google.cloud.dataproc.v1.ClusterOperationOrBuilder>
        getDeleteClusterFieldBuilder() {
      if (deleteClusterBuilder_ == null) {
        deleteClusterBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataproc.v1.ClusterOperation,
                com.google.cloud.dataproc.v1.ClusterOperation.Builder,
                com.google.cloud.dataproc.v1.ClusterOperationOrBuilder>(
                getDeleteCluster(), getParentForChildren(), isClean());
        deleteCluster_ = null;
      }
      return deleteClusterBuilder_;
    }

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. The workflow state.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.WorkflowMetadata.State state = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The workflow state.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.WorkflowMetadata.State state = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {

      state_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The workflow state.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.WorkflowMetadata.State state = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.dataproc.v1.WorkflowMetadata.State getState() {
      @SuppressWarnings("deprecation")
      com.google.cloud.dataproc.v1.WorkflowMetadata.State result =
          com.google.cloud.dataproc.v1.WorkflowMetadata.State.valueOf(state_);
      return result == null
          ? com.google.cloud.dataproc.v1.WorkflowMetadata.State.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. The workflow state.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.WorkflowMetadata.State state = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.cloud.dataproc.v1.WorkflowMetadata.State value) {
      if (value == null) {
        throw new NullPointerException();
      }

      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The workflow state.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.WorkflowMetadata.State state = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {

      state_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object clusterName_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The name of the target cluster.
     * </pre>
     *
     * <code>string cluster_name = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The clusterName.
     */
    public java.lang.String getClusterName() {
      java.lang.Object ref = clusterName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        clusterName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The name of the target cluster.
     * </pre>
     *
     * <code>string cluster_name = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for clusterName.
     */
    public com.google.protobuf.ByteString getClusterNameBytes() {
      java.lang.Object ref = clusterName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        clusterName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The name of the target cluster.
     * </pre>
     *
     * <code>string cluster_name = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The clusterName to set.
     * @return This builder for chaining.
     */
    public Builder setClusterName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      clusterName_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The name of the target cluster.
     * </pre>
     *
     * <code>string cluster_name = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearClusterName() {

      clusterName_ = getDefaultInstance().getClusterName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The name of the target cluster.
     * </pre>
     *
     * <code>string cluster_name = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for clusterName to set.
     * @return This builder for chaining.
     */
    public Builder setClusterNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      clusterName_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> parameters_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetParameters() {
      if (parameters_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            ParametersDefaultEntryHolder.defaultEntry);
      }
      return parameters_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableParameters() {
      onChanged();
      ;
      if (parameters_ == null) {
        parameters_ =
            com.google.protobuf.MapField.newMapField(ParametersDefaultEntryHolder.defaultEntry);
      }
      if (!parameters_.isMutable()) {
        parameters_ = parameters_.copy();
      }
      return parameters_;
    }

    public int getParametersCount() {
      return internalGetParameters().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Map from parameter names to values that were used for those parameters.
     * </pre>
     *
     * <code>map&lt;string, string&gt; parameters = 8;</code>
     */
    @java.lang.Override
    public boolean containsParameters(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetParameters().getMap().containsKey(key);
    }
    /** Use {@link #getParametersMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getParameters() {
      return getParametersMap();
    }
    /**
     *
     *
     * <pre>
     * Map from parameter names to values that were used for those parameters.
     * </pre>
     *
     * <code>map&lt;string, string&gt; parameters = 8;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getParametersMap() {
      return internalGetParameters().getMap();
    }
    /**
     *
     *
     * <pre>
     * Map from parameter names to values that were used for those parameters.
     * </pre>
     *
     * <code>map&lt;string, string&gt; parameters = 8;</code>
     */
    @java.lang.Override
    public java.lang.String getParametersOrDefault(
        java.lang.String key, java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetParameters().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Map from parameter names to values that were used for those parameters.
     * </pre>
     *
     * <code>map&lt;string, string&gt; parameters = 8;</code>
     */
    @java.lang.Override
    public java.lang.String getParametersOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetParameters().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearParameters() {
      internalGetMutableParameters().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Map from parameter names to values that were used for those parameters.
     * </pre>
     *
     * <code>map&lt;string, string&gt; parameters = 8;</code>
     */
    public Builder removeParameters(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableParameters().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableParameters() {
      return internalGetMutableParameters().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Map from parameter names to values that were used for those parameters.
     * </pre>
     *
     * <code>map&lt;string, string&gt; parameters = 8;</code>
     */
    public Builder putParameters(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }

      internalGetMutableParameters().getMutableMap().put(key, value);
      return this;
    }
    /**
     *
     *
     * <pre>
     * Map from parameter names to values that were used for those parameters.
     * </pre>
     *
     * <code>map&lt;string, string&gt; parameters = 8;</code>
     */
    public Builder putAllParameters(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableParameters().getMutableMap().putAll(values);
      return this;
    }

    private com.google.protobuf.Timestamp startTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        startTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Workflow start time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the startTime field is set.
     */
    public boolean hasStartTime() {
      return startTimeBuilder_ != null || startTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. Workflow start time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The startTime.
     */
    public com.google.protobuf.Timestamp getStartTime() {
      if (startTimeBuilder_ == null) {
        return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
      } else {
        return startTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Workflow start time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setStartTime(com.google.protobuf.Timestamp value) {
      if (startTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        startTime_ = value;
        onChanged();
      } else {
        startTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Workflow start time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setStartTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (startTimeBuilder_ == null) {
        startTime_ = builderForValue.build();
        onChanged();
      } else {
        startTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Workflow start time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeStartTime(com.google.protobuf.Timestamp value) {
      if (startTimeBuilder_ == null) {
        if (startTime_ != null) {
          startTime_ =
              com.google.protobuf.Timestamp.newBuilder(startTime_).mergeFrom(value).buildPartial();
        } else {
          startTime_ = value;
        }
        onChanged();
      } else {
        startTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Workflow start time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearStartTime() {
      if (startTimeBuilder_ == null) {
        startTime_ = null;
        onChanged();
      } else {
        startTime_ = null;
        startTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Workflow start time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getStartTimeBuilder() {

      onChanged();
      return getStartTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Workflow start time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
      if (startTimeBuilder_ != null) {
        return startTimeBuilder_.getMessageOrBuilder();
      } else {
        return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Workflow start time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getStartTimeFieldBuilder() {
      if (startTimeBuilder_ == null) {
        startTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getStartTime(), getParentForChildren(), isClean());
        startTime_ = null;
      }
      return startTimeBuilder_;
    }

    private com.google.protobuf.Timestamp endTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        endTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Workflow end time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the endTime field is set.
     */
    public boolean hasEndTime() {
      return endTimeBuilder_ != null || endTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. Workflow end time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The endTime.
     */
    public com.google.protobuf.Timestamp getEndTime() {
      if (endTimeBuilder_ == null) {
        return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
      } else {
        return endTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Workflow end time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setEndTime(com.google.protobuf.Timestamp value) {
      if (endTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        endTime_ = value;
        onChanged();
      } else {
        endTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Workflow end time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setEndTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (endTimeBuilder_ == null) {
        endTime_ = builderForValue.build();
        onChanged();
      } else {
        endTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Workflow end time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeEndTime(com.google.protobuf.Timestamp value) {
      if (endTimeBuilder_ == null) {
        if (endTime_ != null) {
          endTime_ =
              com.google.protobuf.Timestamp.newBuilder(endTime_).mergeFrom(value).buildPartial();
        } else {
          endTime_ = value;
        }
        onChanged();
      } else {
        endTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Workflow end time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearEndTime() {
      if (endTimeBuilder_ == null) {
        endTime_ = null;
        onChanged();
      } else {
        endTime_ = null;
        endTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Workflow end time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getEndTimeBuilder() {

      onChanged();
      return getEndTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Workflow end time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
      if (endTimeBuilder_ != null) {
        return endTimeBuilder_.getMessageOrBuilder();
      } else {
        return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Workflow end time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getEndTimeFieldBuilder() {
      if (endTimeBuilder_ == null) {
        endTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getEndTime(), getParentForChildren(), isClean());
        endTime_ = null;
      }
      return endTimeBuilder_;
    }

    private java.lang.Object clusterUuid_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The UUID of target cluster.
     * </pre>
     *
     * <code>string cluster_uuid = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The clusterUuid.
     */
    public java.lang.String getClusterUuid() {
      java.lang.Object ref = clusterUuid_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        clusterUuid_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The UUID of target cluster.
     * </pre>
     *
     * <code>string cluster_uuid = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for clusterUuid.
     */
    public com.google.protobuf.ByteString getClusterUuidBytes() {
      java.lang.Object ref = clusterUuid_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        clusterUuid_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The UUID of target cluster.
     * </pre>
     *
     * <code>string cluster_uuid = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The clusterUuid to set.
     * @return This builder for chaining.
     */
    public Builder setClusterUuid(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      clusterUuid_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The UUID of target cluster.
     * </pre>
     *
     * <code>string cluster_uuid = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearClusterUuid() {

      clusterUuid_ = getDefaultInstance().getClusterUuid();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The UUID of target cluster.
     * </pre>
     *
     * <code>string cluster_uuid = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for clusterUuid to set.
     * @return This builder for chaining.
     */
    public Builder setClusterUuidBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      clusterUuid_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.Duration dagTimeout_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        dagTimeoutBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The timeout duration for the DAG of jobs, expressed in seconds (see
     * [JSON representation of
     * duration](https://developers.google.com/protocol-buffers/docs/proto3#json)).
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration dag_timeout = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the dagTimeout field is set.
     */
    public boolean hasDagTimeout() {
      return dagTimeoutBuilder_ != null || dagTimeout_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timeout duration for the DAG of jobs, expressed in seconds (see
     * [JSON representation of
     * duration](https://developers.google.com/protocol-buffers/docs/proto3#json)).
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration dag_timeout = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The dagTimeout.
     */
    public com.google.protobuf.Duration getDagTimeout() {
      if (dagTimeoutBuilder_ == null) {
        return dagTimeout_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : dagTimeout_;
      } else {
        return dagTimeoutBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The timeout duration for the DAG of jobs, expressed in seconds (see
     * [JSON representation of
     * duration](https://developers.google.com/protocol-buffers/docs/proto3#json)).
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration dag_timeout = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setDagTimeout(com.google.protobuf.Duration value) {
      if (dagTimeoutBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        dagTimeout_ = value;
        onChanged();
      } else {
        dagTimeoutBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timeout duration for the DAG of jobs, expressed in seconds (see
     * [JSON representation of
     * duration](https://developers.google.com/protocol-buffers/docs/proto3#json)).
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration dag_timeout = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setDagTimeout(com.google.protobuf.Duration.Builder builderForValue) {
      if (dagTimeoutBuilder_ == null) {
        dagTimeout_ = builderForValue.build();
        onChanged();
      } else {
        dagTimeoutBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timeout duration for the DAG of jobs, expressed in seconds (see
     * [JSON representation of
     * duration](https://developers.google.com/protocol-buffers/docs/proto3#json)).
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration dag_timeout = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeDagTimeout(com.google.protobuf.Duration value) {
      if (dagTimeoutBuilder_ == null) {
        if (dagTimeout_ != null) {
          dagTimeout_ =
              com.google.protobuf.Duration.newBuilder(dagTimeout_).mergeFrom(value).buildPartial();
        } else {
          dagTimeout_ = value;
        }
        onChanged();
      } else {
        dagTimeoutBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timeout duration for the DAG of jobs, expressed in seconds (see
     * [JSON representation of
     * duration](https://developers.google.com/protocol-buffers/docs/proto3#json)).
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration dag_timeout = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearDagTimeout() {
      if (dagTimeoutBuilder_ == null) {
        dagTimeout_ = null;
        onChanged();
      } else {
        dagTimeout_ = null;
        dagTimeoutBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timeout duration for the DAG of jobs, expressed in seconds (see
     * [JSON representation of
     * duration](https://developers.google.com/protocol-buffers/docs/proto3#json)).
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration dag_timeout = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Duration.Builder getDagTimeoutBuilder() {

      onChanged();
      return getDagTimeoutFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The timeout duration for the DAG of jobs, expressed in seconds (see
     * [JSON representation of
     * duration](https://developers.google.com/protocol-buffers/docs/proto3#json)).
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration dag_timeout = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.DurationOrBuilder getDagTimeoutOrBuilder() {
      if (dagTimeoutBuilder_ != null) {
        return dagTimeoutBuilder_.getMessageOrBuilder();
      } else {
        return dagTimeout_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : dagTimeout_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The timeout duration for the DAG of jobs, expressed in seconds (see
     * [JSON representation of
     * duration](https://developers.google.com/protocol-buffers/docs/proto3#json)).
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration dag_timeout = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getDagTimeoutFieldBuilder() {
      if (dagTimeoutBuilder_ == null) {
        dagTimeoutBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getDagTimeout(), getParentForChildren(), isClean());
        dagTimeout_ = null;
      }
      return dagTimeoutBuilder_;
    }

    private com.google.protobuf.Timestamp dagStartTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        dagStartTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. DAG start time, only set for workflows with [dag_timeout][google.cloud.dataproc.v1.WorkflowMetadata.dag_timeout] when DAG
     * begins.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp dag_start_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the dagStartTime field is set.
     */
    public boolean hasDagStartTime() {
      return dagStartTimeBuilder_ != null || dagStartTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. DAG start time, only set for workflows with [dag_timeout][google.cloud.dataproc.v1.WorkflowMetadata.dag_timeout] when DAG
     * begins.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp dag_start_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The dagStartTime.
     */
    public com.google.protobuf.Timestamp getDagStartTime() {
      if (dagStartTimeBuilder_ == null) {
        return dagStartTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : dagStartTime_;
      } else {
        return dagStartTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. DAG start time, only set for workflows with [dag_timeout][google.cloud.dataproc.v1.WorkflowMetadata.dag_timeout] when DAG
     * begins.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp dag_start_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setDagStartTime(com.google.protobuf.Timestamp value) {
      if (dagStartTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        dagStartTime_ = value;
        onChanged();
      } else {
        dagStartTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. DAG start time, only set for workflows with [dag_timeout][google.cloud.dataproc.v1.WorkflowMetadata.dag_timeout] when DAG
     * begins.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp dag_start_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setDagStartTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (dagStartTimeBuilder_ == null) {
        dagStartTime_ = builderForValue.build();
        onChanged();
      } else {
        dagStartTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. DAG start time, only set for workflows with [dag_timeout][google.cloud.dataproc.v1.WorkflowMetadata.dag_timeout] when DAG
     * begins.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp dag_start_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeDagStartTime(com.google.protobuf.Timestamp value) {
      if (dagStartTimeBuilder_ == null) {
        if (dagStartTime_ != null) {
          dagStartTime_ =
              com.google.protobuf.Timestamp.newBuilder(dagStartTime_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          dagStartTime_ = value;
        }
        onChanged();
      } else {
        dagStartTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. DAG start time, only set for workflows with [dag_timeout][google.cloud.dataproc.v1.WorkflowMetadata.dag_timeout] when DAG
     * begins.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp dag_start_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearDagStartTime() {
      if (dagStartTimeBuilder_ == null) {
        dagStartTime_ = null;
        onChanged();
      } else {
        dagStartTime_ = null;
        dagStartTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. DAG start time, only set for workflows with [dag_timeout][google.cloud.dataproc.v1.WorkflowMetadata.dag_timeout] when DAG
     * begins.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp dag_start_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getDagStartTimeBuilder() {

      onChanged();
      return getDagStartTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. DAG start time, only set for workflows with [dag_timeout][google.cloud.dataproc.v1.WorkflowMetadata.dag_timeout] when DAG
     * begins.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp dag_start_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getDagStartTimeOrBuilder() {
      if (dagStartTimeBuilder_ != null) {
        return dagStartTimeBuilder_.getMessageOrBuilder();
      } else {
        return dagStartTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : dagStartTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. DAG start time, only set for workflows with [dag_timeout][google.cloud.dataproc.v1.WorkflowMetadata.dag_timeout] when DAG
     * begins.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp dag_start_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getDagStartTimeFieldBuilder() {
      if (dagStartTimeBuilder_ == null) {
        dagStartTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getDagStartTime(), getParentForChildren(), isClean());
        dagStartTime_ = null;
      }
      return dagStartTimeBuilder_;
    }

    private com.google.protobuf.Timestamp dagEndTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        dagEndTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. DAG end time, only set for workflows with [dag_timeout][google.cloud.dataproc.v1.WorkflowMetadata.dag_timeout] when DAG ends.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp dag_end_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the dagEndTime field is set.
     */
    public boolean hasDagEndTime() {
      return dagEndTimeBuilder_ != null || dagEndTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. DAG end time, only set for workflows with [dag_timeout][google.cloud.dataproc.v1.WorkflowMetadata.dag_timeout] when DAG ends.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp dag_end_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The dagEndTime.
     */
    public com.google.protobuf.Timestamp getDagEndTime() {
      if (dagEndTimeBuilder_ == null) {
        return dagEndTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : dagEndTime_;
      } else {
        return dagEndTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. DAG end time, only set for workflows with [dag_timeout][google.cloud.dataproc.v1.WorkflowMetadata.dag_timeout] when DAG ends.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp dag_end_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setDagEndTime(com.google.protobuf.Timestamp value) {
      if (dagEndTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        dagEndTime_ = value;
        onChanged();
      } else {
        dagEndTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. DAG end time, only set for workflows with [dag_timeout][google.cloud.dataproc.v1.WorkflowMetadata.dag_timeout] when DAG ends.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp dag_end_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setDagEndTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (dagEndTimeBuilder_ == null) {
        dagEndTime_ = builderForValue.build();
        onChanged();
      } else {
        dagEndTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. DAG end time, only set for workflows with [dag_timeout][google.cloud.dataproc.v1.WorkflowMetadata.dag_timeout] when DAG ends.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp dag_end_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeDagEndTime(com.google.protobuf.Timestamp value) {
      if (dagEndTimeBuilder_ == null) {
        if (dagEndTime_ != null) {
          dagEndTime_ =
              com.google.protobuf.Timestamp.newBuilder(dagEndTime_).mergeFrom(value).buildPartial();
        } else {
          dagEndTime_ = value;
        }
        onChanged();
      } else {
        dagEndTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. DAG end time, only set for workflows with [dag_timeout][google.cloud.dataproc.v1.WorkflowMetadata.dag_timeout] when DAG ends.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp dag_end_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearDagEndTime() {
      if (dagEndTimeBuilder_ == null) {
        dagEndTime_ = null;
        onChanged();
      } else {
        dagEndTime_ = null;
        dagEndTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. DAG end time, only set for workflows with [dag_timeout][google.cloud.dataproc.v1.WorkflowMetadata.dag_timeout] when DAG ends.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp dag_end_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getDagEndTimeBuilder() {

      onChanged();
      return getDagEndTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. DAG end time, only set for workflows with [dag_timeout][google.cloud.dataproc.v1.WorkflowMetadata.dag_timeout] when DAG ends.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp dag_end_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getDagEndTimeOrBuilder() {
      if (dagEndTimeBuilder_ != null) {
        return dagEndTimeBuilder_.getMessageOrBuilder();
      } else {
        return dagEndTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : dagEndTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. DAG end time, only set for workflows with [dag_timeout][google.cloud.dataproc.v1.WorkflowMetadata.dag_timeout] when DAG ends.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp dag_end_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getDagEndTimeFieldBuilder() {
      if (dagEndTimeBuilder_ == null) {
        dagEndTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getDagEndTime(), getParentForChildren(), isClean());
        dagEndTime_ = null;
      }
      return dagEndTimeBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dataproc.v1.WorkflowMetadata)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dataproc.v1.WorkflowMetadata)
  private static final com.google.cloud.dataproc.v1.WorkflowMetadata DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dataproc.v1.WorkflowMetadata();
  }

  public static com.google.cloud.dataproc.v1.WorkflowMetadata getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<WorkflowMetadata> PARSER =
      new com.google.protobuf.AbstractParser<WorkflowMetadata>() {
        @java.lang.Override
        public WorkflowMetadata parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<WorkflowMetadata> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<WorkflowMetadata> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dataproc.v1.WorkflowMetadata getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
