/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dataproc/v1/workflow_templates.proto

package com.google.cloud.dataproc.v1;

/**
 *
 *
 * <pre>
 * Specifies workflow execution target.
 * Either `managed_cluster` or `cluster_selector` is required.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dataproc.v1.WorkflowTemplatePlacement}
 */
public final class WorkflowTemplatePlacement extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dataproc.v1.WorkflowTemplatePlacement)
    WorkflowTemplatePlacementOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use WorkflowTemplatePlacement.newBuilder() to construct.
  private WorkflowTemplatePlacement(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private WorkflowTemplatePlacement() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new WorkflowTemplatePlacement();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dataproc.v1.WorkflowTemplatesProto
        .internal_static_google_cloud_dataproc_v1_WorkflowTemplatePlacement_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dataproc.v1.WorkflowTemplatesProto
        .internal_static_google_cloud_dataproc_v1_WorkflowTemplatePlacement_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dataproc.v1.WorkflowTemplatePlacement.class,
            com.google.cloud.dataproc.v1.WorkflowTemplatePlacement.Builder.class);
  }

  private int placementCase_ = 0;
  private java.lang.Object placement_;

  public enum PlacementCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    MANAGED_CLUSTER(1),
    CLUSTER_SELECTOR(2),
    PLACEMENT_NOT_SET(0);
    private final int value;

    private PlacementCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static PlacementCase valueOf(int value) {
      return forNumber(value);
    }

    public static PlacementCase forNumber(int value) {
      switch (value) {
        case 1:
          return MANAGED_CLUSTER;
        case 2:
          return CLUSTER_SELECTOR;
        case 0:
          return PLACEMENT_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public PlacementCase getPlacementCase() {
    return PlacementCase.forNumber(placementCase_);
  }

  public static final int MANAGED_CLUSTER_FIELD_NUMBER = 1;
  /**
   *
   *
   * <pre>
   * A cluster that is managed by the workflow.
   * </pre>
   *
   * <code>.google.cloud.dataproc.v1.ManagedCluster managed_cluster = 1;</code>
   *
   * @return Whether the managedCluster field is set.
   */
  @java.lang.Override
  public boolean hasManagedCluster() {
    return placementCase_ == 1;
  }
  /**
   *
   *
   * <pre>
   * A cluster that is managed by the workflow.
   * </pre>
   *
   * <code>.google.cloud.dataproc.v1.ManagedCluster managed_cluster = 1;</code>
   *
   * @return The managedCluster.
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.ManagedCluster getManagedCluster() {
    if (placementCase_ == 1) {
      return (com.google.cloud.dataproc.v1.ManagedCluster) placement_;
    }
    return com.google.cloud.dataproc.v1.ManagedCluster.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * A cluster that is managed by the workflow.
   * </pre>
   *
   * <code>.google.cloud.dataproc.v1.ManagedCluster managed_cluster = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.ManagedClusterOrBuilder getManagedClusterOrBuilder() {
    if (placementCase_ == 1) {
      return (com.google.cloud.dataproc.v1.ManagedCluster) placement_;
    }
    return com.google.cloud.dataproc.v1.ManagedCluster.getDefaultInstance();
  }

  public static final int CLUSTER_SELECTOR_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * Optional. A selector that chooses target cluster for jobs based
   * on metadata.
   * The selector is evaluated at the time each job is submitted.
   * </pre>
   *
   * <code>.google.cloud.dataproc.v1.ClusterSelector cluster_selector = 2;</code>
   *
   * @return Whether the clusterSelector field is set.
   */
  @java.lang.Override
  public boolean hasClusterSelector() {
    return placementCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * Optional. A selector that chooses target cluster for jobs based
   * on metadata.
   * The selector is evaluated at the time each job is submitted.
   * </pre>
   *
   * <code>.google.cloud.dataproc.v1.ClusterSelector cluster_selector = 2;</code>
   *
   * @return The clusterSelector.
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.ClusterSelector getClusterSelector() {
    if (placementCase_ == 2) {
      return (com.google.cloud.dataproc.v1.ClusterSelector) placement_;
    }
    return com.google.cloud.dataproc.v1.ClusterSelector.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Optional. A selector that chooses target cluster for jobs based
   * on metadata.
   * The selector is evaluated at the time each job is submitted.
   * </pre>
   *
   * <code>.google.cloud.dataproc.v1.ClusterSelector cluster_selector = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.ClusterSelectorOrBuilder getClusterSelectorOrBuilder() {
    if (placementCase_ == 2) {
      return (com.google.cloud.dataproc.v1.ClusterSelector) placement_;
    }
    return com.google.cloud.dataproc.v1.ClusterSelector.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (placementCase_ == 1) {
      output.writeMessage(1, (com.google.cloud.dataproc.v1.ManagedCluster) placement_);
    }
    if (placementCase_ == 2) {
      output.writeMessage(2, (com.google.cloud.dataproc.v1.ClusterSelector) placement_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (placementCase_ == 1) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              1, (com.google.cloud.dataproc.v1.ManagedCluster) placement_);
    }
    if (placementCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.google.cloud.dataproc.v1.ClusterSelector) placement_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dataproc.v1.WorkflowTemplatePlacement)) {
      return super.equals(obj);
    }
    com.google.cloud.dataproc.v1.WorkflowTemplatePlacement other =
        (com.google.cloud.dataproc.v1.WorkflowTemplatePlacement) obj;

    if (!getPlacementCase().equals(other.getPlacementCase())) return false;
    switch (placementCase_) {
      case 1:
        if (!getManagedCluster().equals(other.getManagedCluster())) return false;
        break;
      case 2:
        if (!getClusterSelector().equals(other.getClusterSelector())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    switch (placementCase_) {
      case 1:
        hash = (37 * hash) + MANAGED_CLUSTER_FIELD_NUMBER;
        hash = (53 * hash) + getManagedCluster().hashCode();
        break;
      case 2:
        hash = (37 * hash) + CLUSTER_SELECTOR_FIELD_NUMBER;
        hash = (53 * hash) + getClusterSelector().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dataproc.v1.WorkflowTemplatePlacement parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1.WorkflowTemplatePlacement parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.WorkflowTemplatePlacement parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1.WorkflowTemplatePlacement parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.WorkflowTemplatePlacement parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1.WorkflowTemplatePlacement parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.WorkflowTemplatePlacement parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1.WorkflowTemplatePlacement parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.WorkflowTemplatePlacement parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1.WorkflowTemplatePlacement parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.WorkflowTemplatePlacement parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1.WorkflowTemplatePlacement parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.dataproc.v1.WorkflowTemplatePlacement prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Specifies workflow execution target.
   * Either `managed_cluster` or `cluster_selector` is required.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dataproc.v1.WorkflowTemplatePlacement}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dataproc.v1.WorkflowTemplatePlacement)
      com.google.cloud.dataproc.v1.WorkflowTemplatePlacementOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dataproc.v1.WorkflowTemplatesProto
          .internal_static_google_cloud_dataproc_v1_WorkflowTemplatePlacement_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dataproc.v1.WorkflowTemplatesProto
          .internal_static_google_cloud_dataproc_v1_WorkflowTemplatePlacement_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dataproc.v1.WorkflowTemplatePlacement.class,
              com.google.cloud.dataproc.v1.WorkflowTemplatePlacement.Builder.class);
    }

    // Construct using com.google.cloud.dataproc.v1.WorkflowTemplatePlacement.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (managedClusterBuilder_ != null) {
        managedClusterBuilder_.clear();
      }
      if (clusterSelectorBuilder_ != null) {
        clusterSelectorBuilder_.clear();
      }
      placementCase_ = 0;
      placement_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dataproc.v1.WorkflowTemplatesProto
          .internal_static_google_cloud_dataproc_v1_WorkflowTemplatePlacement_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.WorkflowTemplatePlacement getDefaultInstanceForType() {
      return com.google.cloud.dataproc.v1.WorkflowTemplatePlacement.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.WorkflowTemplatePlacement build() {
      com.google.cloud.dataproc.v1.WorkflowTemplatePlacement result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.WorkflowTemplatePlacement buildPartial() {
      com.google.cloud.dataproc.v1.WorkflowTemplatePlacement result =
          new com.google.cloud.dataproc.v1.WorkflowTemplatePlacement(this);
      if (placementCase_ == 1) {
        if (managedClusterBuilder_ == null) {
          result.placement_ = placement_;
        } else {
          result.placement_ = managedClusterBuilder_.build();
        }
      }
      if (placementCase_ == 2) {
        if (clusterSelectorBuilder_ == null) {
          result.placement_ = placement_;
        } else {
          result.placement_ = clusterSelectorBuilder_.build();
        }
      }
      result.placementCase_ = placementCase_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dataproc.v1.WorkflowTemplatePlacement) {
        return mergeFrom((com.google.cloud.dataproc.v1.WorkflowTemplatePlacement) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dataproc.v1.WorkflowTemplatePlacement other) {
      if (other == com.google.cloud.dataproc.v1.WorkflowTemplatePlacement.getDefaultInstance())
        return this;
      switch (other.getPlacementCase()) {
        case MANAGED_CLUSTER:
          {
            mergeManagedCluster(other.getManagedCluster());
            break;
          }
        case CLUSTER_SELECTOR:
          {
            mergeClusterSelector(other.getClusterSelector());
            break;
          }
        case PLACEMENT_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getManagedClusterFieldBuilder().getBuilder(), extensionRegistry);
                placementCase_ = 1;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getClusterSelectorFieldBuilder().getBuilder(), extensionRegistry);
                placementCase_ = 2;
                break;
              } // case 18
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int placementCase_ = 0;
    private java.lang.Object placement_;

    public PlacementCase getPlacementCase() {
      return PlacementCase.forNumber(placementCase_);
    }

    public Builder clearPlacement() {
      placementCase_ = 0;
      placement_ = null;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.ManagedCluster,
            com.google.cloud.dataproc.v1.ManagedCluster.Builder,
            com.google.cloud.dataproc.v1.ManagedClusterOrBuilder>
        managedClusterBuilder_;
    /**
     *
     *
     * <pre>
     * A cluster that is managed by the workflow.
     * </pre>
     *
     * <code>.google.cloud.dataproc.v1.ManagedCluster managed_cluster = 1;</code>
     *
     * @return Whether the managedCluster field is set.
     */
    @java.lang.Override
    public boolean hasManagedCluster() {
      return placementCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * A cluster that is managed by the workflow.
     * </pre>
     *
     * <code>.google.cloud.dataproc.v1.ManagedCluster managed_cluster = 1;</code>
     *
     * @return The managedCluster.
     */
    @java.lang.Override
    public com.google.cloud.dataproc.v1.ManagedCluster getManagedCluster() {
      if (managedClusterBuilder_ == null) {
        if (placementCase_ == 1) {
          return (com.google.cloud.dataproc.v1.ManagedCluster) placement_;
        }
        return com.google.cloud.dataproc.v1.ManagedCluster.getDefaultInstance();
      } else {
        if (placementCase_ == 1) {
          return managedClusterBuilder_.getMessage();
        }
        return com.google.cloud.dataproc.v1.ManagedCluster.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A cluster that is managed by the workflow.
     * </pre>
     *
     * <code>.google.cloud.dataproc.v1.ManagedCluster managed_cluster = 1;</code>
     */
    public Builder setManagedCluster(com.google.cloud.dataproc.v1.ManagedCluster value) {
      if (managedClusterBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        placement_ = value;
        onChanged();
      } else {
        managedClusterBuilder_.setMessage(value);
      }
      placementCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A cluster that is managed by the workflow.
     * </pre>
     *
     * <code>.google.cloud.dataproc.v1.ManagedCluster managed_cluster = 1;</code>
     */
    public Builder setManagedCluster(
        com.google.cloud.dataproc.v1.ManagedCluster.Builder builderForValue) {
      if (managedClusterBuilder_ == null) {
        placement_ = builderForValue.build();
        onChanged();
      } else {
        managedClusterBuilder_.setMessage(builderForValue.build());
      }
      placementCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A cluster that is managed by the workflow.
     * </pre>
     *
     * <code>.google.cloud.dataproc.v1.ManagedCluster managed_cluster = 1;</code>
     */
    public Builder mergeManagedCluster(com.google.cloud.dataproc.v1.ManagedCluster value) {
      if (managedClusterBuilder_ == null) {
        if (placementCase_ == 1
            && placement_ != com.google.cloud.dataproc.v1.ManagedCluster.getDefaultInstance()) {
          placement_ =
              com.google.cloud.dataproc.v1.ManagedCluster.newBuilder(
                      (com.google.cloud.dataproc.v1.ManagedCluster) placement_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          placement_ = value;
        }
        onChanged();
      } else {
        if (placementCase_ == 1) {
          managedClusterBuilder_.mergeFrom(value);
        } else {
          managedClusterBuilder_.setMessage(value);
        }
      }
      placementCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A cluster that is managed by the workflow.
     * </pre>
     *
     * <code>.google.cloud.dataproc.v1.ManagedCluster managed_cluster = 1;</code>
     */
    public Builder clearManagedCluster() {
      if (managedClusterBuilder_ == null) {
        if (placementCase_ == 1) {
          placementCase_ = 0;
          placement_ = null;
          onChanged();
        }
      } else {
        if (placementCase_ == 1) {
          placementCase_ = 0;
          placement_ = null;
        }
        managedClusterBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A cluster that is managed by the workflow.
     * </pre>
     *
     * <code>.google.cloud.dataproc.v1.ManagedCluster managed_cluster = 1;</code>
     */
    public com.google.cloud.dataproc.v1.ManagedCluster.Builder getManagedClusterBuilder() {
      return getManagedClusterFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * A cluster that is managed by the workflow.
     * </pre>
     *
     * <code>.google.cloud.dataproc.v1.ManagedCluster managed_cluster = 1;</code>
     */
    @java.lang.Override
    public com.google.cloud.dataproc.v1.ManagedClusterOrBuilder getManagedClusterOrBuilder() {
      if ((placementCase_ == 1) && (managedClusterBuilder_ != null)) {
        return managedClusterBuilder_.getMessageOrBuilder();
      } else {
        if (placementCase_ == 1) {
          return (com.google.cloud.dataproc.v1.ManagedCluster) placement_;
        }
        return com.google.cloud.dataproc.v1.ManagedCluster.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A cluster that is managed by the workflow.
     * </pre>
     *
     * <code>.google.cloud.dataproc.v1.ManagedCluster managed_cluster = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.ManagedCluster,
            com.google.cloud.dataproc.v1.ManagedCluster.Builder,
            com.google.cloud.dataproc.v1.ManagedClusterOrBuilder>
        getManagedClusterFieldBuilder() {
      if (managedClusterBuilder_ == null) {
        if (!(placementCase_ == 1)) {
          placement_ = com.google.cloud.dataproc.v1.ManagedCluster.getDefaultInstance();
        }
        managedClusterBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataproc.v1.ManagedCluster,
                com.google.cloud.dataproc.v1.ManagedCluster.Builder,
                com.google.cloud.dataproc.v1.ManagedClusterOrBuilder>(
                (com.google.cloud.dataproc.v1.ManagedCluster) placement_,
                getParentForChildren(),
                isClean());
        placement_ = null;
      }
      placementCase_ = 1;
      onChanged();
      ;
      return managedClusterBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.ClusterSelector,
            com.google.cloud.dataproc.v1.ClusterSelector.Builder,
            com.google.cloud.dataproc.v1.ClusterSelectorOrBuilder>
        clusterSelectorBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. A selector that chooses target cluster for jobs based
     * on metadata.
     * The selector is evaluated at the time each job is submitted.
     * </pre>
     *
     * <code>.google.cloud.dataproc.v1.ClusterSelector cluster_selector = 2;</code>
     *
     * @return Whether the clusterSelector field is set.
     */
    @java.lang.Override
    public boolean hasClusterSelector() {
      return placementCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * Optional. A selector that chooses target cluster for jobs based
     * on metadata.
     * The selector is evaluated at the time each job is submitted.
     * </pre>
     *
     * <code>.google.cloud.dataproc.v1.ClusterSelector cluster_selector = 2;</code>
     *
     * @return The clusterSelector.
     */
    @java.lang.Override
    public com.google.cloud.dataproc.v1.ClusterSelector getClusterSelector() {
      if (clusterSelectorBuilder_ == null) {
        if (placementCase_ == 2) {
          return (com.google.cloud.dataproc.v1.ClusterSelector) placement_;
        }
        return com.google.cloud.dataproc.v1.ClusterSelector.getDefaultInstance();
      } else {
        if (placementCase_ == 2) {
          return clusterSelectorBuilder_.getMessage();
        }
        return com.google.cloud.dataproc.v1.ClusterSelector.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A selector that chooses target cluster for jobs based
     * on metadata.
     * The selector is evaluated at the time each job is submitted.
     * </pre>
     *
     * <code>.google.cloud.dataproc.v1.ClusterSelector cluster_selector = 2;</code>
     */
    public Builder setClusterSelector(com.google.cloud.dataproc.v1.ClusterSelector value) {
      if (clusterSelectorBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        placement_ = value;
        onChanged();
      } else {
        clusterSelectorBuilder_.setMessage(value);
      }
      placementCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A selector that chooses target cluster for jobs based
     * on metadata.
     * The selector is evaluated at the time each job is submitted.
     * </pre>
     *
     * <code>.google.cloud.dataproc.v1.ClusterSelector cluster_selector = 2;</code>
     */
    public Builder setClusterSelector(
        com.google.cloud.dataproc.v1.ClusterSelector.Builder builderForValue) {
      if (clusterSelectorBuilder_ == null) {
        placement_ = builderForValue.build();
        onChanged();
      } else {
        clusterSelectorBuilder_.setMessage(builderForValue.build());
      }
      placementCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A selector that chooses target cluster for jobs based
     * on metadata.
     * The selector is evaluated at the time each job is submitted.
     * </pre>
     *
     * <code>.google.cloud.dataproc.v1.ClusterSelector cluster_selector = 2;</code>
     */
    public Builder mergeClusterSelector(com.google.cloud.dataproc.v1.ClusterSelector value) {
      if (clusterSelectorBuilder_ == null) {
        if (placementCase_ == 2
            && placement_ != com.google.cloud.dataproc.v1.ClusterSelector.getDefaultInstance()) {
          placement_ =
              com.google.cloud.dataproc.v1.ClusterSelector.newBuilder(
                      (com.google.cloud.dataproc.v1.ClusterSelector) placement_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          placement_ = value;
        }
        onChanged();
      } else {
        if (placementCase_ == 2) {
          clusterSelectorBuilder_.mergeFrom(value);
        } else {
          clusterSelectorBuilder_.setMessage(value);
        }
      }
      placementCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A selector that chooses target cluster for jobs based
     * on metadata.
     * The selector is evaluated at the time each job is submitted.
     * </pre>
     *
     * <code>.google.cloud.dataproc.v1.ClusterSelector cluster_selector = 2;</code>
     */
    public Builder clearClusterSelector() {
      if (clusterSelectorBuilder_ == null) {
        if (placementCase_ == 2) {
          placementCase_ = 0;
          placement_ = null;
          onChanged();
        }
      } else {
        if (placementCase_ == 2) {
          placementCase_ = 0;
          placement_ = null;
        }
        clusterSelectorBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A selector that chooses target cluster for jobs based
     * on metadata.
     * The selector is evaluated at the time each job is submitted.
     * </pre>
     *
     * <code>.google.cloud.dataproc.v1.ClusterSelector cluster_selector = 2;</code>
     */
    public com.google.cloud.dataproc.v1.ClusterSelector.Builder getClusterSelectorBuilder() {
      return getClusterSelectorFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. A selector that chooses target cluster for jobs based
     * on metadata.
     * The selector is evaluated at the time each job is submitted.
     * </pre>
     *
     * <code>.google.cloud.dataproc.v1.ClusterSelector cluster_selector = 2;</code>
     */
    @java.lang.Override
    public com.google.cloud.dataproc.v1.ClusterSelectorOrBuilder getClusterSelectorOrBuilder() {
      if ((placementCase_ == 2) && (clusterSelectorBuilder_ != null)) {
        return clusterSelectorBuilder_.getMessageOrBuilder();
      } else {
        if (placementCase_ == 2) {
          return (com.google.cloud.dataproc.v1.ClusterSelector) placement_;
        }
        return com.google.cloud.dataproc.v1.ClusterSelector.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A selector that chooses target cluster for jobs based
     * on metadata.
     * The selector is evaluated at the time each job is submitted.
     * </pre>
     *
     * <code>.google.cloud.dataproc.v1.ClusterSelector cluster_selector = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.ClusterSelector,
            com.google.cloud.dataproc.v1.ClusterSelector.Builder,
            com.google.cloud.dataproc.v1.ClusterSelectorOrBuilder>
        getClusterSelectorFieldBuilder() {
      if (clusterSelectorBuilder_ == null) {
        if (!(placementCase_ == 2)) {
          placement_ = com.google.cloud.dataproc.v1.ClusterSelector.getDefaultInstance();
        }
        clusterSelectorBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataproc.v1.ClusterSelector,
                com.google.cloud.dataproc.v1.ClusterSelector.Builder,
                com.google.cloud.dataproc.v1.ClusterSelectorOrBuilder>(
                (com.google.cloud.dataproc.v1.ClusterSelector) placement_,
                getParentForChildren(),
                isClean());
        placement_ = null;
      }
      placementCase_ = 2;
      onChanged();
      ;
      return clusterSelectorBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dataproc.v1.WorkflowTemplatePlacement)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dataproc.v1.WorkflowTemplatePlacement)
  private static final com.google.cloud.dataproc.v1.WorkflowTemplatePlacement DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dataproc.v1.WorkflowTemplatePlacement();
  }

  public static com.google.cloud.dataproc.v1.WorkflowTemplatePlacement getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<WorkflowTemplatePlacement> PARSER =
      new com.google.protobuf.AbstractParser<WorkflowTemplatePlacement>() {
        @java.lang.Override
        public WorkflowTemplatePlacement parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<WorkflowTemplatePlacement> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<WorkflowTemplatePlacement> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dataproc.v1.WorkflowTemplatePlacement getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
