/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dataproc/v1/autoscaling_policies.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.dataproc.v1;

/**
 *
 *
 * <pre>
 * Describes an autoscaling policy for Dataproc cluster autoscaler.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dataproc.v1.AutoscalingPolicy}
 */
public final class AutoscalingPolicy extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dataproc.v1.AutoscalingPolicy)
    AutoscalingPolicyOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use AutoscalingPolicy.newBuilder() to construct.
  private AutoscalingPolicy(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private AutoscalingPolicy() {
    id_ = "";
    name_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new AutoscalingPolicy();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dataproc.v1.AutoscalingPoliciesProto
        .internal_static_google_cloud_dataproc_v1_AutoscalingPolicy_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 6:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dataproc.v1.AutoscalingPoliciesProto
        .internal_static_google_cloud_dataproc_v1_AutoscalingPolicy_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dataproc.v1.AutoscalingPolicy.class,
            com.google.cloud.dataproc.v1.AutoscalingPolicy.Builder.class);
  }

  private int bitField0_;
  private int algorithmCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object algorithm_;

  public enum AlgorithmCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    BASIC_ALGORITHM(3),
    ALGORITHM_NOT_SET(0);
    private final int value;

    private AlgorithmCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static AlgorithmCase valueOf(int value) {
      return forNumber(value);
    }

    public static AlgorithmCase forNumber(int value) {
      switch (value) {
        case 3:
          return BASIC_ALGORITHM;
        case 0:
          return ALGORITHM_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public AlgorithmCase getAlgorithmCase() {
    return AlgorithmCase.forNumber(algorithmCase_);
  }

  public static final int ID_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object id_ = "";
  /**
   *
   *
   * <pre>
   * Required. The policy id.
   *
   * The id must contain only letters (a-z, A-Z), numbers (0-9),
   * underscores (_), and hyphens (-). Cannot begin or end with underscore
   * or hyphen. Must consist of between 3 and 50 characters.
   * </pre>
   *
   * <code>string id = 1;</code>
   *
   * @return The id.
   */
  @java.lang.Override
  public java.lang.String getId() {
    java.lang.Object ref = id_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      id_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The policy id.
   *
   * The id must contain only letters (a-z, A-Z), numbers (0-9),
   * underscores (_), and hyphens (-). Cannot begin or end with underscore
   * or hyphen. Must consist of between 3 and 50 characters.
   * </pre>
   *
   * <code>string id = 1;</code>
   *
   * @return The bytes for id.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getIdBytes() {
    java.lang.Object ref = id_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      id_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NAME_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The "resource name" of the autoscaling policy, as described
   * in https://cloud.google.com/apis/design/resource_names.
   *
   * * For `projects.regions.autoscalingPolicies`, the resource name of the
   *   policy has the following format:
   *   `projects/{project_id}/regions/{region}/autoscalingPolicies/{policy_id}`
   *
   * * For `projects.locations.autoscalingPolicies`, the resource name of the
   *   policy has the following format:
   *   `projects/{project_id}/locations/{location}/autoscalingPolicies/{policy_id}`
   * </pre>
   *
   * <code>string name = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The "resource name" of the autoscaling policy, as described
   * in https://cloud.google.com/apis/design/resource_names.
   *
   * * For `projects.regions.autoscalingPolicies`, the resource name of the
   *   policy has the following format:
   *   `projects/{project_id}/regions/{region}/autoscalingPolicies/{policy_id}`
   *
   * * For `projects.locations.autoscalingPolicies`, the resource name of the
   *   policy has the following format:
   *   `projects/{project_id}/locations/{location}/autoscalingPolicies/{policy_id}`
   * </pre>
   *
   * <code>string name = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int BASIC_ALGORITHM_FIELD_NUMBER = 3;
  /**
   * <code>
   * .google.cloud.dataproc.v1.BasicAutoscalingAlgorithm basic_algorithm = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the basicAlgorithm field is set.
   */
  @java.lang.Override
  public boolean hasBasicAlgorithm() {
    return algorithmCase_ == 3;
  }
  /**
   * <code>
   * .google.cloud.dataproc.v1.BasicAutoscalingAlgorithm basic_algorithm = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The basicAlgorithm.
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.BasicAutoscalingAlgorithm getBasicAlgorithm() {
    if (algorithmCase_ == 3) {
      return (com.google.cloud.dataproc.v1.BasicAutoscalingAlgorithm) algorithm_;
    }
    return com.google.cloud.dataproc.v1.BasicAutoscalingAlgorithm.getDefaultInstance();
  }
  /**
   * <code>
   * .google.cloud.dataproc.v1.BasicAutoscalingAlgorithm basic_algorithm = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.BasicAutoscalingAlgorithmOrBuilder
      getBasicAlgorithmOrBuilder() {
    if (algorithmCase_ == 3) {
      return (com.google.cloud.dataproc.v1.BasicAutoscalingAlgorithm) algorithm_;
    }
    return com.google.cloud.dataproc.v1.BasicAutoscalingAlgorithm.getDefaultInstance();
  }

  public static final int WORKER_CONFIG_FIELD_NUMBER = 4;
  private com.google.cloud.dataproc.v1.InstanceGroupAutoscalingPolicyConfig workerConfig_;
  /**
   *
   *
   * <pre>
   * Required. Describes how the autoscaler will operate for primary workers.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.InstanceGroupAutoscalingPolicyConfig worker_config = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the workerConfig field is set.
   */
  @java.lang.Override
  public boolean hasWorkerConfig() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Required. Describes how the autoscaler will operate for primary workers.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.InstanceGroupAutoscalingPolicyConfig worker_config = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The workerConfig.
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.InstanceGroupAutoscalingPolicyConfig getWorkerConfig() {
    return workerConfig_ == null
        ? com.google.cloud.dataproc.v1.InstanceGroupAutoscalingPolicyConfig.getDefaultInstance()
        : workerConfig_;
  }
  /**
   *
   *
   * <pre>
   * Required. Describes how the autoscaler will operate for primary workers.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.InstanceGroupAutoscalingPolicyConfig worker_config = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.InstanceGroupAutoscalingPolicyConfigOrBuilder
      getWorkerConfigOrBuilder() {
    return workerConfig_ == null
        ? com.google.cloud.dataproc.v1.InstanceGroupAutoscalingPolicyConfig.getDefaultInstance()
        : workerConfig_;
  }

  public static final int SECONDARY_WORKER_CONFIG_FIELD_NUMBER = 5;
  private com.google.cloud.dataproc.v1.InstanceGroupAutoscalingPolicyConfig secondaryWorkerConfig_;
  /**
   *
   *
   * <pre>
   * Optional. Describes how the autoscaler will operate for secondary workers.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.InstanceGroupAutoscalingPolicyConfig secondary_worker_config = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the secondaryWorkerConfig field is set.
   */
  @java.lang.Override
  public boolean hasSecondaryWorkerConfig() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. Describes how the autoscaler will operate for secondary workers.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.InstanceGroupAutoscalingPolicyConfig secondary_worker_config = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The secondaryWorkerConfig.
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.InstanceGroupAutoscalingPolicyConfig
      getSecondaryWorkerConfig() {
    return secondaryWorkerConfig_ == null
        ? com.google.cloud.dataproc.v1.InstanceGroupAutoscalingPolicyConfig.getDefaultInstance()
        : secondaryWorkerConfig_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Describes how the autoscaler will operate for secondary workers.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.InstanceGroupAutoscalingPolicyConfig secondary_worker_config = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.InstanceGroupAutoscalingPolicyConfigOrBuilder
      getSecondaryWorkerConfigOrBuilder() {
    return secondaryWorkerConfig_ == null
        ? com.google.cloud.dataproc.v1.InstanceGroupAutoscalingPolicyConfig.getDefaultInstance()
        : secondaryWorkerConfig_;
  }

  public static final int LABELS_FIELD_NUMBER = 6;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.dataproc.v1.AutoscalingPoliciesProto
                .internal_static_google_cloud_dataproc_v1_AutoscalingPolicy_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Optional. The labels to associate with this autoscaling policy.
   * Label **keys** must contain 1 to 63 characters, and must conform to
   * [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
   * Label **values** may be empty, but, if present, must contain 1 to 63
   * characters, and must conform to [RFC
   * 1035](https://www.ietf.org/rfc/rfc1035.txt). No more than 32 labels can be
   * associated with an autoscaling policy.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. The labels to associate with this autoscaling policy.
   * Label **keys** must contain 1 to 63 characters, and must conform to
   * [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
   * Label **values** may be empty, but, if present, must contain 1 to 63
   * characters, and must conform to [RFC
   * 1035](https://www.ietf.org/rfc/rfc1035.txt). No more than 32 labels can be
   * associated with an autoscaling policy.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. The labels to associate with this autoscaling policy.
   * Label **keys** must contain 1 to 63 characters, and must conform to
   * [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
   * Label **values** may be empty, but, if present, must contain 1 to 63
   * characters, and must conform to [RFC
   * 1035](https://www.ietf.org/rfc/rfc1035.txt). No more than 32 labels can be
   * associated with an autoscaling policy.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Optional. The labels to associate with this autoscaling policy.
   * Label **keys** must contain 1 to 63 characters, and must conform to
   * [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
   * Label **values** may be empty, but, if present, must contain 1 to 63
   * characters, and must conform to [RFC
   * 1035](https://www.ietf.org/rfc/rfc1035.txt). No more than 32 labels can be
   * associated with an autoscaling policy.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(id_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, id_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, name_);
    }
    if (algorithmCase_ == 3) {
      output.writeMessage(3, (com.google.cloud.dataproc.v1.BasicAutoscalingAlgorithm) algorithm_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(4, getWorkerConfig());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(5, getSecondaryWorkerConfig());
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 6);
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(id_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, id_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, name_);
    }
    if (algorithmCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, (com.google.cloud.dataproc.v1.BasicAutoscalingAlgorithm) algorithm_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getWorkerConfig());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(5, getSecondaryWorkerConfig());
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, labels__);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dataproc.v1.AutoscalingPolicy)) {
      return super.equals(obj);
    }
    com.google.cloud.dataproc.v1.AutoscalingPolicy other =
        (com.google.cloud.dataproc.v1.AutoscalingPolicy) obj;

    if (!getId().equals(other.getId())) return false;
    if (!getName().equals(other.getName())) return false;
    if (hasWorkerConfig() != other.hasWorkerConfig()) return false;
    if (hasWorkerConfig()) {
      if (!getWorkerConfig().equals(other.getWorkerConfig())) return false;
    }
    if (hasSecondaryWorkerConfig() != other.hasSecondaryWorkerConfig()) return false;
    if (hasSecondaryWorkerConfig()) {
      if (!getSecondaryWorkerConfig().equals(other.getSecondaryWorkerConfig())) return false;
    }
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (!getAlgorithmCase().equals(other.getAlgorithmCase())) return false;
    switch (algorithmCase_) {
      case 3:
        if (!getBasicAlgorithm().equals(other.getBasicAlgorithm())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + ID_FIELD_NUMBER;
    hash = (53 * hash) + getId().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (hasWorkerConfig()) {
      hash = (37 * hash) + WORKER_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getWorkerConfig().hashCode();
    }
    if (hasSecondaryWorkerConfig()) {
      hash = (37 * hash) + SECONDARY_WORKER_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getSecondaryWorkerConfig().hashCode();
    }
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    switch (algorithmCase_) {
      case 3:
        hash = (37 * hash) + BASIC_ALGORITHM_FIELD_NUMBER;
        hash = (53 * hash) + getBasicAlgorithm().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dataproc.v1.AutoscalingPolicy parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1.AutoscalingPolicy parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.AutoscalingPolicy parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1.AutoscalingPolicy parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.AutoscalingPolicy parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1.AutoscalingPolicy parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.AutoscalingPolicy parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1.AutoscalingPolicy parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.AutoscalingPolicy parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1.AutoscalingPolicy parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.AutoscalingPolicy parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1.AutoscalingPolicy parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.dataproc.v1.AutoscalingPolicy prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Describes an autoscaling policy for Dataproc cluster autoscaler.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dataproc.v1.AutoscalingPolicy}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dataproc.v1.AutoscalingPolicy)
      com.google.cloud.dataproc.v1.AutoscalingPolicyOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dataproc.v1.AutoscalingPoliciesProto
          .internal_static_google_cloud_dataproc_v1_AutoscalingPolicy_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 6:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 6:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dataproc.v1.AutoscalingPoliciesProto
          .internal_static_google_cloud_dataproc_v1_AutoscalingPolicy_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dataproc.v1.AutoscalingPolicy.class,
              com.google.cloud.dataproc.v1.AutoscalingPolicy.Builder.class);
    }

    // Construct using com.google.cloud.dataproc.v1.AutoscalingPolicy.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getWorkerConfigFieldBuilder();
        getSecondaryWorkerConfigFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      id_ = "";
      name_ = "";
      if (basicAlgorithmBuilder_ != null) {
        basicAlgorithmBuilder_.clear();
      }
      workerConfig_ = null;
      if (workerConfigBuilder_ != null) {
        workerConfigBuilder_.dispose();
        workerConfigBuilder_ = null;
      }
      secondaryWorkerConfig_ = null;
      if (secondaryWorkerConfigBuilder_ != null) {
        secondaryWorkerConfigBuilder_.dispose();
        secondaryWorkerConfigBuilder_ = null;
      }
      internalGetMutableLabels().clear();
      algorithmCase_ = 0;
      algorithm_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dataproc.v1.AutoscalingPoliciesProto
          .internal_static_google_cloud_dataproc_v1_AutoscalingPolicy_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.AutoscalingPolicy getDefaultInstanceForType() {
      return com.google.cloud.dataproc.v1.AutoscalingPolicy.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.AutoscalingPolicy build() {
      com.google.cloud.dataproc.v1.AutoscalingPolicy result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.AutoscalingPolicy buildPartial() {
      com.google.cloud.dataproc.v1.AutoscalingPolicy result =
          new com.google.cloud.dataproc.v1.AutoscalingPolicy(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.dataproc.v1.AutoscalingPolicy result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.id_ = id_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.name_ = name_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.workerConfig_ =
            workerConfigBuilder_ == null ? workerConfig_ : workerConfigBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.secondaryWorkerConfig_ =
            secondaryWorkerConfigBuilder_ == null
                ? secondaryWorkerConfig_
                : secondaryWorkerConfigBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.labels_ = internalGetLabels();
        result.labels_.makeImmutable();
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.cloud.dataproc.v1.AutoscalingPolicy result) {
      result.algorithmCase_ = algorithmCase_;
      result.algorithm_ = this.algorithm_;
      if (algorithmCase_ == 3 && basicAlgorithmBuilder_ != null) {
        result.algorithm_ = basicAlgorithmBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dataproc.v1.AutoscalingPolicy) {
        return mergeFrom((com.google.cloud.dataproc.v1.AutoscalingPolicy) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dataproc.v1.AutoscalingPolicy other) {
      if (other == com.google.cloud.dataproc.v1.AutoscalingPolicy.getDefaultInstance()) return this;
      if (!other.getId().isEmpty()) {
        id_ = other.id_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasWorkerConfig()) {
        mergeWorkerConfig(other.getWorkerConfig());
      }
      if (other.hasSecondaryWorkerConfig()) {
        mergeSecondaryWorkerConfig(other.getSecondaryWorkerConfig());
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      bitField0_ |= 0x00000020;
      switch (other.getAlgorithmCase()) {
        case BASIC_ALGORITHM:
          {
            mergeBasicAlgorithm(other.getBasicAlgorithm());
            break;
          }
        case ALGORITHM_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                id_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getBasicAlgorithmFieldBuilder().getBuilder(), extensionRegistry);
                algorithmCase_ = 3;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getWorkerConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(
                    getSecondaryWorkerConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int algorithmCase_ = 0;
    private java.lang.Object algorithm_;

    public AlgorithmCase getAlgorithmCase() {
      return AlgorithmCase.forNumber(algorithmCase_);
    }

    public Builder clearAlgorithm() {
      algorithmCase_ = 0;
      algorithm_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object id_ = "";
    /**
     *
     *
     * <pre>
     * Required. The policy id.
     *
     * The id must contain only letters (a-z, A-Z), numbers (0-9),
     * underscores (_), and hyphens (-). Cannot begin or end with underscore
     * or hyphen. Must consist of between 3 and 50 characters.
     * </pre>
     *
     * <code>string id = 1;</code>
     *
     * @return The id.
     */
    public java.lang.String getId() {
      java.lang.Object ref = id_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        id_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The policy id.
     *
     * The id must contain only letters (a-z, A-Z), numbers (0-9),
     * underscores (_), and hyphens (-). Cannot begin or end with underscore
     * or hyphen. Must consist of between 3 and 50 characters.
     * </pre>
     *
     * <code>string id = 1;</code>
     *
     * @return The bytes for id.
     */
    public com.google.protobuf.ByteString getIdBytes() {
      java.lang.Object ref = id_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        id_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The policy id.
     *
     * The id must contain only letters (a-z, A-Z), numbers (0-9),
     * underscores (_), and hyphens (-). Cannot begin or end with underscore
     * or hyphen. Must consist of between 3 and 50 characters.
     * </pre>
     *
     * <code>string id = 1;</code>
     *
     * @param value The id to set.
     * @return This builder for chaining.
     */
    public Builder setId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      id_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The policy id.
     *
     * The id must contain only letters (a-z, A-Z), numbers (0-9),
     * underscores (_), and hyphens (-). Cannot begin or end with underscore
     * or hyphen. Must consist of between 3 and 50 characters.
     * </pre>
     *
     * <code>string id = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearId() {
      id_ = getDefaultInstance().getId();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The policy id.
     *
     * The id must contain only letters (a-z, A-Z), numbers (0-9),
     * underscores (_), and hyphens (-). Cannot begin or end with underscore
     * or hyphen. Must consist of between 3 and 50 characters.
     * </pre>
     *
     * <code>string id = 1;</code>
     *
     * @param value The bytes for id to set.
     * @return This builder for chaining.
     */
    public Builder setIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      id_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The "resource name" of the autoscaling policy, as described
     * in https://cloud.google.com/apis/design/resource_names.
     *
     * * For `projects.regions.autoscalingPolicies`, the resource name of the
     *   policy has the following format:
     *   `projects/{project_id}/regions/{region}/autoscalingPolicies/{policy_id}`
     *
     * * For `projects.locations.autoscalingPolicies`, the resource name of the
     *   policy has the following format:
     *   `projects/{project_id}/locations/{location}/autoscalingPolicies/{policy_id}`
     * </pre>
     *
     * <code>string name = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The "resource name" of the autoscaling policy, as described
     * in https://cloud.google.com/apis/design/resource_names.
     *
     * * For `projects.regions.autoscalingPolicies`, the resource name of the
     *   policy has the following format:
     *   `projects/{project_id}/regions/{region}/autoscalingPolicies/{policy_id}`
     *
     * * For `projects.locations.autoscalingPolicies`, the resource name of the
     *   policy has the following format:
     *   `projects/{project_id}/locations/{location}/autoscalingPolicies/{policy_id}`
     * </pre>
     *
     * <code>string name = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The "resource name" of the autoscaling policy, as described
     * in https://cloud.google.com/apis/design/resource_names.
     *
     * * For `projects.regions.autoscalingPolicies`, the resource name of the
     *   policy has the following format:
     *   `projects/{project_id}/regions/{region}/autoscalingPolicies/{policy_id}`
     *
     * * For `projects.locations.autoscalingPolicies`, the resource name of the
     *   policy has the following format:
     *   `projects/{project_id}/locations/{location}/autoscalingPolicies/{policy_id}`
     * </pre>
     *
     * <code>string name = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The "resource name" of the autoscaling policy, as described
     * in https://cloud.google.com/apis/design/resource_names.
     *
     * * For `projects.regions.autoscalingPolicies`, the resource name of the
     *   policy has the following format:
     *   `projects/{project_id}/regions/{region}/autoscalingPolicies/{policy_id}`
     *
     * * For `projects.locations.autoscalingPolicies`, the resource name of the
     *   policy has the following format:
     *   `projects/{project_id}/locations/{location}/autoscalingPolicies/{policy_id}`
     * </pre>
     *
     * <code>string name = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The "resource name" of the autoscaling policy, as described
     * in https://cloud.google.com/apis/design/resource_names.
     *
     * * For `projects.regions.autoscalingPolicies`, the resource name of the
     *   policy has the following format:
     *   `projects/{project_id}/regions/{region}/autoscalingPolicies/{policy_id}`
     *
     * * For `projects.locations.autoscalingPolicies`, the resource name of the
     *   policy has the following format:
     *   `projects/{project_id}/locations/{location}/autoscalingPolicies/{policy_id}`
     * </pre>
     *
     * <code>string name = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.BasicAutoscalingAlgorithm,
            com.google.cloud.dataproc.v1.BasicAutoscalingAlgorithm.Builder,
            com.google.cloud.dataproc.v1.BasicAutoscalingAlgorithmOrBuilder>
        basicAlgorithmBuilder_;
    /**
     * <code>
     * .google.cloud.dataproc.v1.BasicAutoscalingAlgorithm basic_algorithm = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the basicAlgorithm field is set.
     */
    @java.lang.Override
    public boolean hasBasicAlgorithm() {
      return algorithmCase_ == 3;
    }
    /**
     * <code>
     * .google.cloud.dataproc.v1.BasicAutoscalingAlgorithm basic_algorithm = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The basicAlgorithm.
     */
    @java.lang.Override
    public com.google.cloud.dataproc.v1.BasicAutoscalingAlgorithm getBasicAlgorithm() {
      if (basicAlgorithmBuilder_ == null) {
        if (algorithmCase_ == 3) {
          return (com.google.cloud.dataproc.v1.BasicAutoscalingAlgorithm) algorithm_;
        }
        return com.google.cloud.dataproc.v1.BasicAutoscalingAlgorithm.getDefaultInstance();
      } else {
        if (algorithmCase_ == 3) {
          return basicAlgorithmBuilder_.getMessage();
        }
        return com.google.cloud.dataproc.v1.BasicAutoscalingAlgorithm.getDefaultInstance();
      }
    }
    /**
     * <code>
     * .google.cloud.dataproc.v1.BasicAutoscalingAlgorithm basic_algorithm = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setBasicAlgorithm(com.google.cloud.dataproc.v1.BasicAutoscalingAlgorithm value) {
      if (basicAlgorithmBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        algorithm_ = value;
        onChanged();
      } else {
        basicAlgorithmBuilder_.setMessage(value);
      }
      algorithmCase_ = 3;
      return this;
    }
    /**
     * <code>
     * .google.cloud.dataproc.v1.BasicAutoscalingAlgorithm basic_algorithm = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setBasicAlgorithm(
        com.google.cloud.dataproc.v1.BasicAutoscalingAlgorithm.Builder builderForValue) {
      if (basicAlgorithmBuilder_ == null) {
        algorithm_ = builderForValue.build();
        onChanged();
      } else {
        basicAlgorithmBuilder_.setMessage(builderForValue.build());
      }
      algorithmCase_ = 3;
      return this;
    }
    /**
     * <code>
     * .google.cloud.dataproc.v1.BasicAutoscalingAlgorithm basic_algorithm = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeBasicAlgorithm(
        com.google.cloud.dataproc.v1.BasicAutoscalingAlgorithm value) {
      if (basicAlgorithmBuilder_ == null) {
        if (algorithmCase_ == 3
            && algorithm_
                != com.google.cloud.dataproc.v1.BasicAutoscalingAlgorithm.getDefaultInstance()) {
          algorithm_ =
              com.google.cloud.dataproc.v1.BasicAutoscalingAlgorithm.newBuilder(
                      (com.google.cloud.dataproc.v1.BasicAutoscalingAlgorithm) algorithm_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          algorithm_ = value;
        }
        onChanged();
      } else {
        if (algorithmCase_ == 3) {
          basicAlgorithmBuilder_.mergeFrom(value);
        } else {
          basicAlgorithmBuilder_.setMessage(value);
        }
      }
      algorithmCase_ = 3;
      return this;
    }
    /**
     * <code>
     * .google.cloud.dataproc.v1.BasicAutoscalingAlgorithm basic_algorithm = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearBasicAlgorithm() {
      if (basicAlgorithmBuilder_ == null) {
        if (algorithmCase_ == 3) {
          algorithmCase_ = 0;
          algorithm_ = null;
          onChanged();
        }
      } else {
        if (algorithmCase_ == 3) {
          algorithmCase_ = 0;
          algorithm_ = null;
        }
        basicAlgorithmBuilder_.clear();
      }
      return this;
    }
    /**
     * <code>
     * .google.cloud.dataproc.v1.BasicAutoscalingAlgorithm basic_algorithm = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.dataproc.v1.BasicAutoscalingAlgorithm.Builder
        getBasicAlgorithmBuilder() {
      return getBasicAlgorithmFieldBuilder().getBuilder();
    }
    /**
     * <code>
     * .google.cloud.dataproc.v1.BasicAutoscalingAlgorithm basic_algorithm = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dataproc.v1.BasicAutoscalingAlgorithmOrBuilder
        getBasicAlgorithmOrBuilder() {
      if ((algorithmCase_ == 3) && (basicAlgorithmBuilder_ != null)) {
        return basicAlgorithmBuilder_.getMessageOrBuilder();
      } else {
        if (algorithmCase_ == 3) {
          return (com.google.cloud.dataproc.v1.BasicAutoscalingAlgorithm) algorithm_;
        }
        return com.google.cloud.dataproc.v1.BasicAutoscalingAlgorithm.getDefaultInstance();
      }
    }
    /**
     * <code>
     * .google.cloud.dataproc.v1.BasicAutoscalingAlgorithm basic_algorithm = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.BasicAutoscalingAlgorithm,
            com.google.cloud.dataproc.v1.BasicAutoscalingAlgorithm.Builder,
            com.google.cloud.dataproc.v1.BasicAutoscalingAlgorithmOrBuilder>
        getBasicAlgorithmFieldBuilder() {
      if (basicAlgorithmBuilder_ == null) {
        if (!(algorithmCase_ == 3)) {
          algorithm_ = com.google.cloud.dataproc.v1.BasicAutoscalingAlgorithm.getDefaultInstance();
        }
        basicAlgorithmBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataproc.v1.BasicAutoscalingAlgorithm,
                com.google.cloud.dataproc.v1.BasicAutoscalingAlgorithm.Builder,
                com.google.cloud.dataproc.v1.BasicAutoscalingAlgorithmOrBuilder>(
                (com.google.cloud.dataproc.v1.BasicAutoscalingAlgorithm) algorithm_,
                getParentForChildren(),
                isClean());
        algorithm_ = null;
      }
      algorithmCase_ = 3;
      onChanged();
      return basicAlgorithmBuilder_;
    }

    private com.google.cloud.dataproc.v1.InstanceGroupAutoscalingPolicyConfig workerConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.InstanceGroupAutoscalingPolicyConfig,
            com.google.cloud.dataproc.v1.InstanceGroupAutoscalingPolicyConfig.Builder,
            com.google.cloud.dataproc.v1.InstanceGroupAutoscalingPolicyConfigOrBuilder>
        workerConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Required. Describes how the autoscaler will operate for primary workers.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.InstanceGroupAutoscalingPolicyConfig worker_config = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the workerConfig field is set.
     */
    public boolean hasWorkerConfig() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. Describes how the autoscaler will operate for primary workers.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.InstanceGroupAutoscalingPolicyConfig worker_config = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The workerConfig.
     */
    public com.google.cloud.dataproc.v1.InstanceGroupAutoscalingPolicyConfig getWorkerConfig() {
      if (workerConfigBuilder_ == null) {
        return workerConfig_ == null
            ? com.google.cloud.dataproc.v1.InstanceGroupAutoscalingPolicyConfig.getDefaultInstance()
            : workerConfig_;
      } else {
        return workerConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Describes how the autoscaler will operate for primary workers.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.InstanceGroupAutoscalingPolicyConfig worker_config = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setWorkerConfig(
        com.google.cloud.dataproc.v1.InstanceGroupAutoscalingPolicyConfig value) {
      if (workerConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        workerConfig_ = value;
      } else {
        workerConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Describes how the autoscaler will operate for primary workers.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.InstanceGroupAutoscalingPolicyConfig worker_config = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setWorkerConfig(
        com.google.cloud.dataproc.v1.InstanceGroupAutoscalingPolicyConfig.Builder builderForValue) {
      if (workerConfigBuilder_ == null) {
        workerConfig_ = builderForValue.build();
      } else {
        workerConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Describes how the autoscaler will operate for primary workers.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.InstanceGroupAutoscalingPolicyConfig worker_config = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeWorkerConfig(
        com.google.cloud.dataproc.v1.InstanceGroupAutoscalingPolicyConfig value) {
      if (workerConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && workerConfig_ != null
            && workerConfig_
                != com.google.cloud.dataproc.v1.InstanceGroupAutoscalingPolicyConfig
                    .getDefaultInstance()) {
          getWorkerConfigBuilder().mergeFrom(value);
        } else {
          workerConfig_ = value;
        }
      } else {
        workerConfigBuilder_.mergeFrom(value);
      }
      if (workerConfig_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Describes how the autoscaler will operate for primary workers.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.InstanceGroupAutoscalingPolicyConfig worker_config = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearWorkerConfig() {
      bitField0_ = (bitField0_ & ~0x00000008);
      workerConfig_ = null;
      if (workerConfigBuilder_ != null) {
        workerConfigBuilder_.dispose();
        workerConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Describes how the autoscaler will operate for primary workers.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.InstanceGroupAutoscalingPolicyConfig worker_config = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.dataproc.v1.InstanceGroupAutoscalingPolicyConfig.Builder
        getWorkerConfigBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getWorkerConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. Describes how the autoscaler will operate for primary workers.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.InstanceGroupAutoscalingPolicyConfig worker_config = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.dataproc.v1.InstanceGroupAutoscalingPolicyConfigOrBuilder
        getWorkerConfigOrBuilder() {
      if (workerConfigBuilder_ != null) {
        return workerConfigBuilder_.getMessageOrBuilder();
      } else {
        return workerConfig_ == null
            ? com.google.cloud.dataproc.v1.InstanceGroupAutoscalingPolicyConfig.getDefaultInstance()
            : workerConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Describes how the autoscaler will operate for primary workers.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.InstanceGroupAutoscalingPolicyConfig worker_config = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.InstanceGroupAutoscalingPolicyConfig,
            com.google.cloud.dataproc.v1.InstanceGroupAutoscalingPolicyConfig.Builder,
            com.google.cloud.dataproc.v1.InstanceGroupAutoscalingPolicyConfigOrBuilder>
        getWorkerConfigFieldBuilder() {
      if (workerConfigBuilder_ == null) {
        workerConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataproc.v1.InstanceGroupAutoscalingPolicyConfig,
                com.google.cloud.dataproc.v1.InstanceGroupAutoscalingPolicyConfig.Builder,
                com.google.cloud.dataproc.v1.InstanceGroupAutoscalingPolicyConfigOrBuilder>(
                getWorkerConfig(), getParentForChildren(), isClean());
        workerConfig_ = null;
      }
      return workerConfigBuilder_;
    }

    private com.google.cloud.dataproc.v1.InstanceGroupAutoscalingPolicyConfig
        secondaryWorkerConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.InstanceGroupAutoscalingPolicyConfig,
            com.google.cloud.dataproc.v1.InstanceGroupAutoscalingPolicyConfig.Builder,
            com.google.cloud.dataproc.v1.InstanceGroupAutoscalingPolicyConfigOrBuilder>
        secondaryWorkerConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Describes how the autoscaler will operate for secondary workers.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.InstanceGroupAutoscalingPolicyConfig secondary_worker_config = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the secondaryWorkerConfig field is set.
     */
    public boolean hasSecondaryWorkerConfig() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Describes how the autoscaler will operate for secondary workers.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.InstanceGroupAutoscalingPolicyConfig secondary_worker_config = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The secondaryWorkerConfig.
     */
    public com.google.cloud.dataproc.v1.InstanceGroupAutoscalingPolicyConfig
        getSecondaryWorkerConfig() {
      if (secondaryWorkerConfigBuilder_ == null) {
        return secondaryWorkerConfig_ == null
            ? com.google.cloud.dataproc.v1.InstanceGroupAutoscalingPolicyConfig.getDefaultInstance()
            : secondaryWorkerConfig_;
      } else {
        return secondaryWorkerConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Describes how the autoscaler will operate for secondary workers.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.InstanceGroupAutoscalingPolicyConfig secondary_worker_config = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setSecondaryWorkerConfig(
        com.google.cloud.dataproc.v1.InstanceGroupAutoscalingPolicyConfig value) {
      if (secondaryWorkerConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        secondaryWorkerConfig_ = value;
      } else {
        secondaryWorkerConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Describes how the autoscaler will operate for secondary workers.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.InstanceGroupAutoscalingPolicyConfig secondary_worker_config = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setSecondaryWorkerConfig(
        com.google.cloud.dataproc.v1.InstanceGroupAutoscalingPolicyConfig.Builder builderForValue) {
      if (secondaryWorkerConfigBuilder_ == null) {
        secondaryWorkerConfig_ = builderForValue.build();
      } else {
        secondaryWorkerConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Describes how the autoscaler will operate for secondary workers.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.InstanceGroupAutoscalingPolicyConfig secondary_worker_config = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeSecondaryWorkerConfig(
        com.google.cloud.dataproc.v1.InstanceGroupAutoscalingPolicyConfig value) {
      if (secondaryWorkerConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && secondaryWorkerConfig_ != null
            && secondaryWorkerConfig_
                != com.google.cloud.dataproc.v1.InstanceGroupAutoscalingPolicyConfig
                    .getDefaultInstance()) {
          getSecondaryWorkerConfigBuilder().mergeFrom(value);
        } else {
          secondaryWorkerConfig_ = value;
        }
      } else {
        secondaryWorkerConfigBuilder_.mergeFrom(value);
      }
      if (secondaryWorkerConfig_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Describes how the autoscaler will operate for secondary workers.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.InstanceGroupAutoscalingPolicyConfig secondary_worker_config = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearSecondaryWorkerConfig() {
      bitField0_ = (bitField0_ & ~0x00000010);
      secondaryWorkerConfig_ = null;
      if (secondaryWorkerConfigBuilder_ != null) {
        secondaryWorkerConfigBuilder_.dispose();
        secondaryWorkerConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Describes how the autoscaler will operate for secondary workers.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.InstanceGroupAutoscalingPolicyConfig secondary_worker_config = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataproc.v1.InstanceGroupAutoscalingPolicyConfig.Builder
        getSecondaryWorkerConfigBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getSecondaryWorkerConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Describes how the autoscaler will operate for secondary workers.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.InstanceGroupAutoscalingPolicyConfig secondary_worker_config = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataproc.v1.InstanceGroupAutoscalingPolicyConfigOrBuilder
        getSecondaryWorkerConfigOrBuilder() {
      if (secondaryWorkerConfigBuilder_ != null) {
        return secondaryWorkerConfigBuilder_.getMessageOrBuilder();
      } else {
        return secondaryWorkerConfig_ == null
            ? com.google.cloud.dataproc.v1.InstanceGroupAutoscalingPolicyConfig.getDefaultInstance()
            : secondaryWorkerConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Describes how the autoscaler will operate for secondary workers.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.InstanceGroupAutoscalingPolicyConfig secondary_worker_config = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.InstanceGroupAutoscalingPolicyConfig,
            com.google.cloud.dataproc.v1.InstanceGroupAutoscalingPolicyConfig.Builder,
            com.google.cloud.dataproc.v1.InstanceGroupAutoscalingPolicyConfigOrBuilder>
        getSecondaryWorkerConfigFieldBuilder() {
      if (secondaryWorkerConfigBuilder_ == null) {
        secondaryWorkerConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataproc.v1.InstanceGroupAutoscalingPolicyConfig,
                com.google.cloud.dataproc.v1.InstanceGroupAutoscalingPolicyConfig.Builder,
                com.google.cloud.dataproc.v1.InstanceGroupAutoscalingPolicyConfigOrBuilder>(
                getSecondaryWorkerConfig(), getParentForChildren(), isClean());
        secondaryWorkerConfig_ = null;
      }
      return secondaryWorkerConfigBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Optional. The labels to associate with this autoscaling policy.
     * Label **keys** must contain 1 to 63 characters, and must conform to
     * [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
     * Label **values** may be empty, but, if present, must contain 1 to 63
     * characters, and must conform to [RFC
     * 1035](https://www.ietf.org/rfc/rfc1035.txt). No more than 32 labels can be
     * associated with an autoscaling policy.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. The labels to associate with this autoscaling policy.
     * Label **keys** must contain 1 to 63 characters, and must conform to
     * [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
     * Label **values** may be empty, but, if present, must contain 1 to 63
     * characters, and must conform to [RFC
     * 1035](https://www.ietf.org/rfc/rfc1035.txt). No more than 32 labels can be
     * associated with an autoscaling policy.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. The labels to associate with this autoscaling policy.
     * Label **keys** must contain 1 to 63 characters, and must conform to
     * [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
     * Label **values** may be empty, but, if present, must contain 1 to 63
     * characters, and must conform to [RFC
     * 1035](https://www.ietf.org/rfc/rfc1035.txt). No more than 32 labels can be
     * associated with an autoscaling policy.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Optional. The labels to associate with this autoscaling policy.
     * Label **keys** must contain 1 to 63 characters, and must conform to
     * [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
     * Label **values** may be empty, but, if present, must contain 1 to 63
     * characters, and must conform to [RFC
     * 1035](https://www.ietf.org/rfc/rfc1035.txt). No more than 32 labels can be
     * associated with an autoscaling policy.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      bitField0_ = (bitField0_ & ~0x00000020);
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The labels to associate with this autoscaling policy.
     * Label **keys** must contain 1 to 63 characters, and must conform to
     * [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
     * Label **values** may be empty, but, if present, must contain 1 to 63
     * characters, and must conform to [RFC
     * 1035](https://www.ietf.org/rfc/rfc1035.txt). No more than 32 labels can be
     * associated with an autoscaling policy.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      bitField0_ |= 0x00000020;
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. The labels to associate with this autoscaling policy.
     * Label **keys** must contain 1 to 63 characters, and must conform to
     * [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
     * Label **values** may be empty, but, if present, must contain 1 to 63
     * characters, and must conform to [RFC
     * 1035](https://www.ietf.org/rfc/rfc1035.txt). No more than 32 labels can be
     * associated with an autoscaling policy.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00000020;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The labels to associate with this autoscaling policy.
     * Label **keys** must contain 1 to 63 characters, and must conform to
     * [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
     * Label **values** may be empty, but, if present, must contain 1 to 63
     * characters, and must conform to [RFC
     * 1035](https://www.ietf.org/rfc/rfc1035.txt). No more than 32 labels can be
     * associated with an autoscaling policy.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00000020;
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dataproc.v1.AutoscalingPolicy)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dataproc.v1.AutoscalingPolicy)
  private static final com.google.cloud.dataproc.v1.AutoscalingPolicy DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dataproc.v1.AutoscalingPolicy();
  }

  public static com.google.cloud.dataproc.v1.AutoscalingPolicy getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<AutoscalingPolicy> PARSER =
      new com.google.protobuf.AbstractParser<AutoscalingPolicy>() {
        @java.lang.Override
        public AutoscalingPolicy parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<AutoscalingPolicy> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<AutoscalingPolicy> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dataproc.v1.AutoscalingPolicy getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
