/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dataproc/v1/shared.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.dataproc.v1;

/**
 *
 *
 * <pre>
 * Autotuning configuration of the workload.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dataproc.v1.AutotuningConfig}
 */
public final class AutotuningConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dataproc.v1.AutotuningConfig)
    AutotuningConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use AutotuningConfig.newBuilder() to construct.
  private AutotuningConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private AutotuningConfig() {
    scenarios_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new AutotuningConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dataproc.v1.SharedProto
        .internal_static_google_cloud_dataproc_v1_AutotuningConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dataproc.v1.SharedProto
        .internal_static_google_cloud_dataproc_v1_AutotuningConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dataproc.v1.AutotuningConfig.class,
            com.google.cloud.dataproc.v1.AutotuningConfig.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Scenario represents a specific goal that autotuning will attempt to achieve
   * by modifying workloads.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.dataproc.v1.AutotuningConfig.Scenario}
   */
  public enum Scenario implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Default value.
     * </pre>
     *
     * <code>SCENARIO_UNSPECIFIED = 0;</code>
     */
    SCENARIO_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Scaling recommendations such as initialExecutors.
     * </pre>
     *
     * <code>SCALING = 2;</code>
     */
    SCALING(2),
    /**
     *
     *
     * <pre>
     * Adding hints for potential relation broadcasts.
     * </pre>
     *
     * <code>BROADCAST_HASH_JOIN = 3;</code>
     */
    BROADCAST_HASH_JOIN(3),
    /**
     *
     *
     * <pre>
     * Memory management for workloads.
     * </pre>
     *
     * <code>MEMORY = 4;</code>
     */
    MEMORY(4),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Default value.
     * </pre>
     *
     * <code>SCENARIO_UNSPECIFIED = 0;</code>
     */
    public static final int SCENARIO_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Scaling recommendations such as initialExecutors.
     * </pre>
     *
     * <code>SCALING = 2;</code>
     */
    public static final int SCALING_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Adding hints for potential relation broadcasts.
     * </pre>
     *
     * <code>BROADCAST_HASH_JOIN = 3;</code>
     */
    public static final int BROADCAST_HASH_JOIN_VALUE = 3;
    /**
     *
     *
     * <pre>
     * Memory management for workloads.
     * </pre>
     *
     * <code>MEMORY = 4;</code>
     */
    public static final int MEMORY_VALUE = 4;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Scenario valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Scenario forNumber(int value) {
      switch (value) {
        case 0:
          return SCENARIO_UNSPECIFIED;
        case 2:
          return SCALING;
        case 3:
          return BROADCAST_HASH_JOIN;
        case 4:
          return MEMORY;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Scenario> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Scenario> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Scenario>() {
          public Scenario findValueByNumber(int number) {
            return Scenario.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.dataproc.v1.AutotuningConfig.getDescriptor().getEnumTypes().get(0);
    }

    private static final Scenario[] VALUES = values();

    public static Scenario valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Scenario(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.dataproc.v1.AutotuningConfig.Scenario)
  }

  public static final int SCENARIOS_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<java.lang.Integer> scenarios_;

  private static final com.google.protobuf.Internal.ListAdapter.Converter<
          java.lang.Integer, com.google.cloud.dataproc.v1.AutotuningConfig.Scenario>
      scenarios_converter_ =
          new com.google.protobuf.Internal.ListAdapter.Converter<
              java.lang.Integer, com.google.cloud.dataproc.v1.AutotuningConfig.Scenario>() {
            public com.google.cloud.dataproc.v1.AutotuningConfig.Scenario convert(
                java.lang.Integer from) {
              com.google.cloud.dataproc.v1.AutotuningConfig.Scenario result =
                  com.google.cloud.dataproc.v1.AutotuningConfig.Scenario.forNumber(from);
              return result == null
                  ? com.google.cloud.dataproc.v1.AutotuningConfig.Scenario.UNRECOGNIZED
                  : result;
            }
          };
  /**
   *
   *
   * <pre>
   * Optional. Scenarios for which tunings are applied.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dataproc.v1.AutotuningConfig.Scenario scenarios = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return A list containing the scenarios.
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.dataproc.v1.AutotuningConfig.Scenario> getScenariosList() {
    return new com.google.protobuf.Internal.ListAdapter<
        java.lang.Integer, com.google.cloud.dataproc.v1.AutotuningConfig.Scenario>(
        scenarios_, scenarios_converter_);
  }
  /**
   *
   *
   * <pre>
   * Optional. Scenarios for which tunings are applied.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dataproc.v1.AutotuningConfig.Scenario scenarios = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The count of scenarios.
   */
  @java.lang.Override
  public int getScenariosCount() {
    return scenarios_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. Scenarios for which tunings are applied.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dataproc.v1.AutotuningConfig.Scenario scenarios = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @param index The index of the element to return.
   * @return The scenarios at the given index.
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.AutotuningConfig.Scenario getScenarios(int index) {
    return scenarios_converter_.convert(scenarios_.get(index));
  }
  /**
   *
   *
   * <pre>
   * Optional. Scenarios for which tunings are applied.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dataproc.v1.AutotuningConfig.Scenario scenarios = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return A list containing the enum numeric values on the wire for scenarios.
   */
  @java.lang.Override
  public java.util.List<java.lang.Integer> getScenariosValueList() {
    return scenarios_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Scenarios for which tunings are applied.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dataproc.v1.AutotuningConfig.Scenario scenarios = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @param index The index of the value to return.
   * @return The enum numeric value on the wire of scenarios at the given index.
   */
  @java.lang.Override
  public int getScenariosValue(int index) {
    return scenarios_.get(index);
  }

  private int scenariosMemoizedSerializedSize;

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    getSerializedSize();
    if (getScenariosList().size() > 0) {
      output.writeUInt32NoTag(18);
      output.writeUInt32NoTag(scenariosMemoizedSerializedSize);
    }
    for (int i = 0; i < scenarios_.size(); i++) {
      output.writeEnumNoTag(scenarios_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    {
      int dataSize = 0;
      for (int i = 0; i < scenarios_.size(); i++) {
        dataSize += com.google.protobuf.CodedOutputStream.computeEnumSizeNoTag(scenarios_.get(i));
      }
      size += dataSize;
      if (!getScenariosList().isEmpty()) {
        size += 1;
        size += com.google.protobuf.CodedOutputStream.computeUInt32SizeNoTag(dataSize);
      }
      scenariosMemoizedSerializedSize = dataSize;
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dataproc.v1.AutotuningConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.dataproc.v1.AutotuningConfig other =
        (com.google.cloud.dataproc.v1.AutotuningConfig) obj;

    if (!scenarios_.equals(other.scenarios_)) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getScenariosCount() > 0) {
      hash = (37 * hash) + SCENARIOS_FIELD_NUMBER;
      hash = (53 * hash) + scenarios_.hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dataproc.v1.AutotuningConfig parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1.AutotuningConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.AutotuningConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1.AutotuningConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.AutotuningConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1.AutotuningConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.AutotuningConfig parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1.AutotuningConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.AutotuningConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1.AutotuningConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.AutotuningConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1.AutotuningConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.dataproc.v1.AutotuningConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Autotuning configuration of the workload.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dataproc.v1.AutotuningConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dataproc.v1.AutotuningConfig)
      com.google.cloud.dataproc.v1.AutotuningConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dataproc.v1.SharedProto
          .internal_static_google_cloud_dataproc_v1_AutotuningConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dataproc.v1.SharedProto
          .internal_static_google_cloud_dataproc_v1_AutotuningConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dataproc.v1.AutotuningConfig.class,
              com.google.cloud.dataproc.v1.AutotuningConfig.Builder.class);
    }

    // Construct using com.google.cloud.dataproc.v1.AutotuningConfig.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      scenarios_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000001);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dataproc.v1.SharedProto
          .internal_static_google_cloud_dataproc_v1_AutotuningConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.AutotuningConfig getDefaultInstanceForType() {
      return com.google.cloud.dataproc.v1.AutotuningConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.AutotuningConfig build() {
      com.google.cloud.dataproc.v1.AutotuningConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.AutotuningConfig buildPartial() {
      com.google.cloud.dataproc.v1.AutotuningConfig result =
          new com.google.cloud.dataproc.v1.AutotuningConfig(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.dataproc.v1.AutotuningConfig result) {
      if (((bitField0_ & 0x00000001) != 0)) {
        scenarios_ = java.util.Collections.unmodifiableList(scenarios_);
        bitField0_ = (bitField0_ & ~0x00000001);
      }
      result.scenarios_ = scenarios_;
    }

    private void buildPartial0(com.google.cloud.dataproc.v1.AutotuningConfig result) {
      int from_bitField0_ = bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dataproc.v1.AutotuningConfig) {
        return mergeFrom((com.google.cloud.dataproc.v1.AutotuningConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dataproc.v1.AutotuningConfig other) {
      if (other == com.google.cloud.dataproc.v1.AutotuningConfig.getDefaultInstance()) return this;
      if (!other.scenarios_.isEmpty()) {
        if (scenarios_.isEmpty()) {
          scenarios_ = other.scenarios_;
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          ensureScenariosIsMutable();
          scenarios_.addAll(other.scenarios_);
        }
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 16:
              {
                int tmpRaw = input.readEnum();
                ensureScenariosIsMutable();
                scenarios_.add(tmpRaw);
                break;
              } // case 16
            case 18:
              {
                int length = input.readRawVarint32();
                int oldLimit = input.pushLimit(length);
                while (input.getBytesUntilLimit() > 0) {
                  int tmpRaw = input.readEnum();
                  ensureScenariosIsMutable();
                  scenarios_.add(tmpRaw);
                }
                input.popLimit(oldLimit);
                break;
              } // case 18
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<java.lang.Integer> scenarios_ = java.util.Collections.emptyList();

    private void ensureScenariosIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        scenarios_ = new java.util.ArrayList<java.lang.Integer>(scenarios_);
        bitField0_ |= 0x00000001;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Scenarios for which tunings are applied.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.AutotuningConfig.Scenario scenarios = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return A list containing the scenarios.
     */
    public java.util.List<com.google.cloud.dataproc.v1.AutotuningConfig.Scenario>
        getScenariosList() {
      return new com.google.protobuf.Internal.ListAdapter<
          java.lang.Integer, com.google.cloud.dataproc.v1.AutotuningConfig.Scenario>(
          scenarios_, scenarios_converter_);
    }
    /**
     *
     *
     * <pre>
     * Optional. Scenarios for which tunings are applied.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.AutotuningConfig.Scenario scenarios = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The count of scenarios.
     */
    public int getScenariosCount() {
      return scenarios_.size();
    }
    /**
     *
     *
     * <pre>
     * Optional. Scenarios for which tunings are applied.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.AutotuningConfig.Scenario scenarios = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index of the element to return.
     * @return The scenarios at the given index.
     */
    public com.google.cloud.dataproc.v1.AutotuningConfig.Scenario getScenarios(int index) {
      return scenarios_converter_.convert(scenarios_.get(index));
    }
    /**
     *
     *
     * <pre>
     * Optional. Scenarios for which tunings are applied.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.AutotuningConfig.Scenario scenarios = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The scenarios to set.
     * @return This builder for chaining.
     */
    public Builder setScenarios(
        int index, com.google.cloud.dataproc.v1.AutotuningConfig.Scenario value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureScenariosIsMutable();
      scenarios_.set(index, value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Scenarios for which tunings are applied.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.AutotuningConfig.Scenario scenarios = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The scenarios to add.
     * @return This builder for chaining.
     */
    public Builder addScenarios(com.google.cloud.dataproc.v1.AutotuningConfig.Scenario value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureScenariosIsMutable();
      scenarios_.add(value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Scenarios for which tunings are applied.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.AutotuningConfig.Scenario scenarios = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param values The scenarios to add.
     * @return This builder for chaining.
     */
    public Builder addAllScenarios(
        java.lang.Iterable<? extends com.google.cloud.dataproc.v1.AutotuningConfig.Scenario>
            values) {
      ensureScenariosIsMutable();
      for (com.google.cloud.dataproc.v1.AutotuningConfig.Scenario value : values) {
        scenarios_.add(value.getNumber());
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Scenarios for which tunings are applied.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.AutotuningConfig.Scenario scenarios = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearScenarios() {
      scenarios_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Scenarios for which tunings are applied.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.AutotuningConfig.Scenario scenarios = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return A list containing the enum numeric values on the wire for scenarios.
     */
    public java.util.List<java.lang.Integer> getScenariosValueList() {
      return java.util.Collections.unmodifiableList(scenarios_);
    }
    /**
     *
     *
     * <pre>
     * Optional. Scenarios for which tunings are applied.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.AutotuningConfig.Scenario scenarios = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of scenarios at the given index.
     */
    public int getScenariosValue(int index) {
      return scenarios_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. Scenarios for which tunings are applied.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.AutotuningConfig.Scenario scenarios = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The enum numeric value on the wire for scenarios to set.
     * @return This builder for chaining.
     */
    public Builder setScenariosValue(int index, int value) {
      ensureScenariosIsMutable();
      scenarios_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Scenarios for which tunings are applied.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.AutotuningConfig.Scenario scenarios = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The enum numeric value on the wire for scenarios to add.
     * @return This builder for chaining.
     */
    public Builder addScenariosValue(int value) {
      ensureScenariosIsMutable();
      scenarios_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Scenarios for which tunings are applied.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.AutotuningConfig.Scenario scenarios = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param values The enum numeric values on the wire for scenarios to add.
     * @return This builder for chaining.
     */
    public Builder addAllScenariosValue(java.lang.Iterable<java.lang.Integer> values) {
      ensureScenariosIsMutable();
      for (int value : values) {
        scenarios_.add(value);
      }
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dataproc.v1.AutotuningConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dataproc.v1.AutotuningConfig)
  private static final com.google.cloud.dataproc.v1.AutotuningConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dataproc.v1.AutotuningConfig();
  }

  public static com.google.cloud.dataproc.v1.AutotuningConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<AutotuningConfig> PARSER =
      new com.google.protobuf.AbstractParser<AutotuningConfig>() {
        @java.lang.Override
        public AutotuningConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<AutotuningConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<AutotuningConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dataproc.v1.AutotuningConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
